# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core.utils.mime_getter import MimeGetter
from twisted.internet import defer, threads

class TestMimeGetter(ElisaTestCase):

    skip = "disabled until actually used and working well in Elisa"

    def test_get_mimetypes_filesrc(self):
        
        mime = MimeGetter()

        def callIn(result, dict):
            self.assertEquals(result,dict)

        def start_test():
            df = mime.get_type('filesrc',
                            '../sample_data/music/01_open_source__magic_mushrooms.ogg')
            df.addCallback(callIn, {'file_type': 'audio', 'mime_type': 'application/ogg'})
            df = mime.get_type('filesrc',
                            '../sample_data/music/02_icarus_grounded__jeffrey_altergott.ogg')
            df.addCallback(callIn, {'file_type': 'audio', 'mime_type': 'application/ogg'})

            df = mime.get_type('filesrc',
                            '../sample_data/music/03_monkey_bones__trailer_park_everlys.ogg')
            df.addCallback(callIn, {'file_type': 'audio', 'mime_type': 'application/ogg'})

            df = mime.get_type('filesrc',
                            '../sample_data/movies/gstreamer.ogm')
            df.addCallback(callIn, {'file_type': 'video', 'mime_type': 'application/ogg'})

            df = mime.get_type('filesrc',
                            '../sample_data/movies/')
            df.addCallback(callIn, {'file_type': '', 'mime_type' : None})
            df = mime.get_type('filesrc',
                            '../sample_data/pictures/animals/rabbit.jpg')
            df.addCallback(callIn, {'file_type': 'image', 'mime_type':'image/jpeg'} )


        
        return threads.deferToThread(start_test)


    def test_get_mimetypes_gnomevfssrc(self):
        
        mime = MimeGetter('gnomevfssrc')

        def callIn(result, dict):
            self.assertEquals(result,dict)

        def start_test():
            df = mime.get_type('gnomevfssrc',
                            '../sample_data/music/01_open_source__magic_mushrooms.ogg')
            df.addCallback(callIn, {'file_type': 'audio', 'mime_type': 'application/ogg'})
            df = mime.get_type('gnomevfssrc',
                            '../sample_data/music/02_icarus_grounded__jeffrey_altergott.ogg')
            df.addCallback(callIn, {'file_type': 'audio', 'mime_type': 'application/ogg'})

            df = mime.get_type('gnomevfssrc',
                            '../sample_data/music/03_monkey_bones__trailer_park_everlys.ogg')
            df.addCallback(callIn, {'file_type': 'audio', 'mime_type': 'application/ogg'})

            df = mime.get_type('gnomevfssrc',
                            '../sample_data/movies/gstreamer.ogm')
            df.addCallback(callIn, {'file_type': 'video', 'mime_type': 'application/ogg'})

            df = mime.get_type('gnomevfssrc',
                            '../sample_data/movies/')
            df.addCallback(callIn, {'file_type': '', 'mime_type' : None})
            df = mime.get_type('gnomevfssrc',
                            '../sample_data/pictures/animals/rabbit.jpg')
            df.addCallback(callIn, {'file_type': 'image', 'mime_type':'image/jpeg'} )


        
        return threads.deferToThread(start_test)
   
    #test_get_mimetypes_gnomevfssrc.skip = "doesn't seem to work if gnomevfssrc 
