# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.core import common
from elisa.core import plugin_registry
ListViewClass = plugin_registry.get_component_class('base:list_view')

from elisa.extern.translation import Translator, Translatable

import pgm, os
from pypgmtools.widgets.list import List
from pypgmtools.timing import implicit
from pypgmtools.graph.group import Group
from pypgmtools.graph.image import Image
from pypgmtools.graph.text import Text

class NodeView(ListViewClass):

    supported_controllers = ('base:tree_controller', 'base:node_controller')
    default_associations = (
    ('base:node_controller','classic:node_view'),
    )

    def __init__(self):
        ListViewClass.__init__(self)
        self.context_path = 'pigment:pigment_context'
        self.context_handle = None
        self.parent = None

        # FIXME: switch private to public if some are used by other views
        self._widget = None
        self._animated_widget = None
        self._root_group = None

        y = 0.18
        self._current_position = (0.35, y, 0.0)
        self._next_position = (2.3, y, 0.0)
        self._previous_position = (-1.4, y, 0.0)
        self._next_next_position = (4.5, y, 0.0)

    def frontend_changed(self, previous_frontend, new_frontend):
        # FIXME: re-bind the widgets to the new canvas
        pass

    def _replace_children_widget(self, new_widget):
        if self._animated_widget != None:
            del self._animated_widget

        if self._widget != None:
            self._root_group.remove(self._widget)

        self._widget = new_widget
        self._root_group.add(self._widget)
        self._widget.visible = True

        self._animated_widget = implicit.AnimatedObject(self._widget)
        self._animated_widget.setup_next_animations(duration = 350)


    def _create_list_widget(self):
        canvas = self.frontend.context.viewport_handle.get_canvas()

        # FIXME: should then be replaced with a List widget and contain
        # widgets created by the children views
        widget = List(canvas, pgm.DRAWABLE_MIDDLE)
        widget.fg_color = (255, 255, 255, 255)
        widget.width = 1.2
        widget.height = 2.5
        widget.bg_color = (0, 0, 0, 0)
        widget.opacity = 0
        widget.position = self._next_next_position

        return widget

    def _create_preview_widget(self):

        widget = Image()

        if self.controller.model.thumbnail_source != None:
            uri = self.controller.model.thumbnail_source
            dfr = common.application.media_manager.get_media_type(uri)

            def got_media_type(media_type):
                file_type = media_type["file_type"]
                dfr2 = common.application.thumbnailer.get_thumbnail(uri,
                                                                    256,
                                                                    file_type)
                def display(result):
                    widget.set_from_fd(os.open(result[0], os.O_RDONLY))
                    widget.set_name(result)

                dfr2.addCallback(display)
                return dfr2

            dfr.addCallback(got_media_type)

        icon = self.controller.model.theme_icon
        thumbnail = self.frontend.theme.get_media(icon,
                                               "classic:theme/unknown.png")

        widget.set_from_fd(os.open(thumbnail, os.O_RDONLY))
        widget.set_name(icon)

        widget.size = (1.5, 2.0)
        widget.bg_color = (0, 0, 0, 0)
        widget.opacity = 255

        canvas = self.frontend.context.viewport_handle.get_canvas()
        group = Group(canvas, pgm.DRAWABLE_MIDDLE)
        group.opacity = 0
        group.position = self._next_next_position
        group.add(widget)

        widget.position = (-0.14, 0.36, 0.0)
        widget.visible = True

        return group


    def create_representation(self):
        widget = Text()
        label = self.controller.model.text
        if isinstance(label, Translatable):
            translator = common.application.translator
            languages = self.frontend.languages
            label = translator.translateTranslatable(label, languages)

        widget.label = label
        widget.set_name(label)
        widget.font_family = "Bitstream DejaVu"
        widget.font_height = 0.165
        widget.ellipsize = pgm.TEXT_ELLIPSIZE_END
        widget.bg_color = (0, 0, 0, 0)
        widget.opacity = 0

        return widget

    def controller_changed(self):
        # FIXME: each NodeView should create its widget for its row in
        # the list and pass it to its parent so that it can take care of
        # updating itself -> this has been implemented in poblenou_plugin

        self.controller.loadmore_on_selection = True

        if isinstance(self.parent, NodeView):
            # if self is a node or a leaf
            self._root_group = self.parent._root_group
        else:
            # if self is root
            # FIXME: this code should go in menuroot_view

            canvas = self.frontend.context.viewport_handle.get_canvas()

            self._root_group = Group(canvas, pgm.DRAWABLE_MIDDLE)

            # cursor creation
            selector_path = self.frontend.theme.get_media("selector",
                                 "classic:theme/selector-green.png")

            selector = Image()
            selector.set_from_fd(os.open(selector_path, os.O_RDONLY))
            selector.set_name(selector_path)
            selector.opacity   = 255
            selector.size      = (1.8, 0.3)
            selector.position  = (0.0, 1.56, 0.0)
            selector.fg_color  = (255, 255, 255, 255)
            selector.bg_color  = (0, 0, 0, 0)
            selector.alignment = pgm.IMAGE_TOP_LEFT
            selector.layout    = pgm.IMAGE_FILLED
            selector.visible   = True
            self._root_group.add(selector)
            #self._animated_selector = implicit.AnimatedObject(selector)
            #self._animated_selector.setup_next_animations(duration = 300)

        if self.controller.model.has_children:
            self._replace_children_widget(self._create_list_widget())
            self._preview = False
        else:
            self._replace_children_widget(self._create_preview_widget())
            self._preview = True

        self.context_handle = self._root_group

        ListViewClass.controller_changed(self)

    def attribute_set(self, key, old_value, new_value):
        if key == 'current_index':
            self.debug("new index for %s: %s" % (id(self), new_value))

            if len(self) > 0:
                old_selected = self[self._widget.selected_item]
                new_selected = self[new_value]

                old_selected._animated_widget.setup_next_animations("opacity", duration = 200)
                old_selected._animated_widget.opacity = 0

                new_selected._widget.position = self._next_position
                new_selected._animated_widget.setup_next_animations("opacity", duration = 400)
                if new_selected._preview:
                    new_selected._animated_widget.opacity = 255
                else:
                    new_selected._animated_widget.opacity = 100

                self._widget.selected_item = new_value

        elif key == 'selected':
            self.debug("%s (un)selected: %s" % (id(self), new_value))
            if new_value == True:
                # self
                self._animated_widget.opacity = 255
                self._animated_widget.position = self._current_position

                # parent
                parent = self.parent
                if isinstance(parent, NodeView):
                    parent._animated_widget.position = self._previous_position

                # child
                child_index = self.controller.current_index
                if child_index >= 0 and child_index < len(self):
                    child = self[child_index]
                    if child._preview:
                        child._animated_widget.opacity = 255
                        child._animated_widget.position = self._next_position
                    else:
                        child._animated_widget.opacity = 100
                        child._animated_widget.position = self._next_position

                    # grand child
                    grand_child_index = child.controller.current_index
                    if grand_child_index >= 0 and grand_child_index < len(child):
                        grand_child = child[child.controller.current_index]
                        grand_child._animated_widget.position = self._next_next_position


    def child_view_created(self, view, position):
        # FIXME: this is ugly: using the model of a child view
        # instead should do self._widget.insert(position, view.context_handle)
        if self._preview:
            self._replace_children_widget(self._create_list_widget())
            self._preview = False

        if view != None:
            self._widget.insert(position, view.create_representation())
            view.parent = self
