# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'

import pygtk
pygtk.require('2.0')
import gtk

from elisa.extern.translation import Translatable

from elisa.base_components.controller import Controller
from elisa.core import plugin_registry, common
NodeViewClass = plugin_registry.get_component_class('base:node_view')


class GtkNodeView(NodeViewClass):
    """
    This class implements gtk node view support
    used by gtk tree view
    """

    supported_controllers = ('base:node_controller', 'poblenou:node_controller')
    default_associations = (
    ('base:node_controller','gtk:gtk_node_view'),
    ('poblenou:node_controller','gtk:gtk_node_view'),
    )

    def __init__(self):
        NodeViewClass.__init__(self)
        self.context_path = 'gtk:gtk_context'
        self.load_more_string = 'Downloading data...'
        self.iter = None

    def _get_fake_iter_node(self):
        if isinstance(self.parent, GtkNodeView):
            parent_iter = self.parent.iter
        else:
            parent_iter = None

        treemodel = self.root.treeview.get_model()
        first_iter = treemodel.iter_children(parent_iter)

        if first_iter == None:
            return None

        first_iter_text = treemodel.get_value(first_iter, 0)
        if first_iter_text == self.load_more_string:
            return first_iter
        return None


    def create_node(self, controller, position):
        treeview = self.root.treeview
        treemodel = treeview.get_model()

        treeview.connect("row-expanded", self._gtk_row_expanded)
        treeview.connect("row-collapsed", self._gtk_row_collapsed)
        treeview.connect("row-activated", self._gtk_row_activated)

        if isinstance(self.parent, GtkNodeView):
            parent_iter = self.parent.iter
        else:
            parent_iter = None

        fake_iter = self._get_fake_iter_node()
        label = controller.model.text
        if isinstance(label, Translatable):
            translator = common.application.translator
            label = translator.translateTranslatable(label,
                                    self.frontend.languages)

        if fake_iter:
            treemodel.set_value(fake_iter, 0, label)
            self.iter = fake_iter
        else:
            self.iter = treemodel.insert(parent_iter, position, [label])

        if controller.model.has_children:
            treemodel.insert(self.iter, 0, [self.load_more_string])


    def child_view_creating(self, view, controller, position):
        NodeViewClass.child_view_creating(self, view, controller, position)
        view.create_node(controller, position)


    def removed(self, elements, position):
        treemodel = self.root.treeview.get_model()
        for controller in elements:
            child_view = self[position]
            print "remove %r view in %r (position %r)" % (child_view.controller.model.text, self.controller.model.text, position)
            treemodel.remove(child_view.iter)
        NodeViewClass.removed(self, elements, position)


    def modified(self, key, value):
        pass


    def dirtied(self):
        pass


    def attribute_set(self, key, old_value, new_value):
        #if key not in ('hover_delayed'):
        #    print "%s : %s=%s"%(self.controller.model.text, key, new_value)
        if key == 'expanded':
            self._expand(new_value)
        if key == 'current_index':
            self.root.select_from_view(self[new_value])
        if key == 'selected':
            if new_value == True:
                self._expand(True)
                index = self.controller.current_index
                self.root.select_from_view(self[index])
                
    def _expand(self, expand):
        #expand = True, expand the none, if not, collapse it.
        treeview = self.root.treeview
        treemodel = treeview.get_model()
        if self.iter:
            tree_path = treemodel.get_path(self.iter)
            if expand == True:
                treeview.expand_row(tree_path, False)
            else:
                treeview.collapse_row(tree_path)
        


    def _gtk_row_expanded(self, treeview, iter, tree_path):
        treemodel = treeview.get_model()
        if treemodel.get_path(iter) == treemodel.get_path(self.iter):
            # FIXME: this cannot be done in the view but has to be done in the
            # controller
            self.controller.model.activity.loadmore(self.controller.model)
            self.controller.expanded = True


    def _gtk_row_collapsed(self, treeview, iter, tree_path):
        treemodel = treeview.get_model()
        if treemodel.get_path(iter) == treemodel.get_path(self.iter):
            self.controller.expanded = False


    def _gtk_row_activated(self, treeview, path, view_column):
        treemodel = treeview.get_model()
        if path == treemodel.get_path(self.iter):
            # FIXME: this cannot be done in the view but has to be done in the
            # controller
            self.debug("action callback called on %r" % self.controller.model.text)
            if callable(self.controller.model.activate_action):
                self.controller.model.activate_action(self.controller)


    def get_path(self):
        path = [self.parent.controller.index(self.controller)]
        if isinstance(self.parent, NodeViewClass):
            parent_path = self.parent.get_path()
            if len(parent_path) > 0:
                path = parent_path + path
        
        return path
