# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.core import plugin_registry
NodeControllerClass = plugin_registry.get_component_class('base:node_controller')

from elisa.core.input_event import *

from twisted.internet import reactor

class NodeController(NodeControllerClass):

    supported_models = ('base:menu_model', 'base:menu_node_model')

    default_associations = (
    ('base:menu_node_model', 'poblenou:node_controller'),
    )

    def __init__(self):
        # visualisation modes
        self._visualisation_modes = ["list", "grid"]
        self.visualisation_mode = self._visualisation_modes[0]
        
        NodeControllerClass.__init__(self)
        self.hover_delay = 1.000
        self.hover_delayed = None


    def handle_input(self, input_event):
        if input_event.action == EventAction.GO_UP:
            self.exit_node()
            return True

        elif input_event.action == EventAction.GO_DOWN:
            self.enter_node()
            return True

        elif input_event.action == EventAction.GO_LEFT:
            if len(self) > 0 and self.current_index > 0:
                self.current_index -= 1
            return True

        elif input_event.action == EventAction.GO_RIGHT:
            if len(self) > 0 and self.current_index < len(self) - 1:
                self.current_index += 1
            return True
        
        elif input_event.action == EventAction.OK:
            self.activate_node(input_event.origin)
            return True

        """
        elif input_event.value == EventValue.KEY_m:
            # switch to the next visualisation mode
            current = self._visualisation_modes.index(self.visualisation_mode)
            current = (current + 1) % len(self._visualisation_modes)
            self.visualisation_mode = self._visualisation_modes[current]

            return True
        """

        return False

    def selected__set(self, value):
        NodeControllerClass.selected__set(self, value)

        if value:
            self.hover_delayed = reactor.callLater(self.hover_delay, self.hover_action)
        else:
            if self.hover_delayed and self.hover_delayed.active():
                self.hover_delayed.cancel()

    def current_index__set(self, index):
        NodeControllerClass.current_index__set(self, index)

        if self.hover_delayed and self.hover_delayed.active():
            self.hover_delayed.reset(self.hover_delay)
        else:
            self.hover_delayed = reactor.callLater(self.hover_delay, self.hover_action)

    def hover_action(self):
        if self.current_index >= 0 and self.current_index < len(self):
            child_controller = self[self.current_index]
            if child_controller.model.hover_action != None:
                child_controller.model.hover_action(self)

    def enter_node(self):
        if len(self) == 0:
            return

        child_controller = self[self.current_index]
        if child_controller.model.has_children:
            child_controller.loadmore()
            child_controller.focus()
            child_controller.selected = True

            if self.loadmore_on_selection == True and len(child_controller) > 0:
                grand_child_controller = child_controller[child_controller.current_index]
                if grand_child_controller.model.has_children:
                    grand_child_controller.loadmore()

        elif child_controller.model.loading:
            child_controller.focus()
            child_controller.selected = True

    def exit_node(self):
        if isinstance(self.parent, NodeControllerClass):
            self.parent.focus()
            self.parent.selected = True
            self.model.activity.unload(self.model)

    def activate_node(self, origin=None):
        if self.hover_delayed.active():
            self.hover_delayed.cancel()

        if self.current_index >= 0 and self.current_index < len(self):
            child_controller = self[self.current_index]
            if callable(child_controller.model.activate_action):
                child_controller.model.activate_action(self, origin)
            else:
                self.enter_node()

##     def loading__set(self, value):
##         # display grid mode if we have more than 10 items
##         if not value:
##             if len(self.model) > 10 and self.visualisation_mode == 'list':
##                 self.visualisation_mode = 'grid'
##         else:
##             if self.visualisation_mode == 'grid':
##                 self.visualisation_mode = 'list'
            
