# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'


from elisa.core import common
from elisa.core import plugin_registry

from elisa.extern.translation import gettexter, N_
T_ = gettexter('elisa-base')

MenuActivityClass = plugin_registry.get_component_class('base:menu_activity')

class ConfigActivity(MenuActivityClass):
    """
    This class provides and manages the Config management
    """
##     config_doc = {'config_activities': 'a list of activites, which should'
##                                         'appear in the config menu'}
##     default_config = {'config_activities': []}

    menu_name = T_(N_("Configuration"))
    menu_icon_name = "config"
    media_types = []
    
    def get_model(self):
        """
        Returns a menu_node_model for the Service Menu
        """
        registry = common.application.plugin_registry
        main_node = MenuActivityClass.get_model(self)

        # TODO: re-enable aspect ratio switcher when it works properly
        activities = [#'aspect_ratio_switcher:aspect_ratio_switcher_activity',
                      'theme_switcher:theme_switcher_activity']
        
        for activity in activities:
            try:
                component = registry.create_component(activity)
            except (plugin_registry.PluginNotFound,
                    plugin_registry.ComponentNotFound), error:
                self.warning(error)
            else:
                self.log("Component %r with menu model %r", component, \
                         component.get_model())
                menu_model = component.get_model()

                if menu_model != None:
                    self.log("menu model: %r", menu_model)
                    main_node.append(menu_model)

        main_node.has_children = len(main_node) > 0        
        return main_node

