# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'
__maintainer2__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.base_components.activity import Activity
from elisa.core import common
from elisa.core.plugin_registry import PluginNotFound, ComponentNotFound

class MenuActivity(Activity):
    """
    DOCME
    """
 
    menu_name = ""
    menu_icon_name = ""

    def _create_menu_model(self, text, icon, thumbnail_source=None, parent=None):
        """ Create a new MenuModel, give it a text and an icon.

        This method is just an helper for the developer who don't want to
        directly use the plugin_registry to create a base:menu_model
        Component.

        @param text:             data to store under menu_item.text attribute
        @type text:              string
        @param icon:             data to store under menu_item.icon attribute
        @type icon:              string
        @param thumbnail_source: data to store under menu_item.thumbnail_source
                                 attribute
        @type thumbnail_source:  L{elisa.core.media_uri.MediaUri}
        @param parent:           the parent model
        @type parent:            L{MenuNodeModel}
        @rtype:                  L{MenuNodeModel}
        """
        registry = common.application.plugin_registry
        menu_node_model = registry.create_component('base:menu_node_model')

        menu_node_model.text = text
        menu_node_model.theme_icon = "%s_icon" % icon
        menu_node_model.thumbnail_source = thumbnail_source
        menu_node_model.activity = self
        menu_node_model.parent = parent

        return menu_node_model
 

    def loadmore(self, model):
        """
        Request new menu_models for L{model}.

        @param model:  the model to create sub-menus for
        @type model:   L{elisa.plugins.base.models.menu_model.MenuModel}
        """
        pass

    def unload(self, model):
        """
        Clear the children models of L{model} removing all corresponding
        references from the activity.

        @param model:  the model to clear
        @type model:   L{elisa.plugins.base.models.menu_model.MenuModel}
        """
        pass

    def set_directory_actions(self, menu_model, uri):
        """
        DOCME
        """
        pass

    def set_hover_action(self, menu_model, uri):
        """
        DOCME
        """
        pass

    def get_model(self):
        return self._create_menu_model(self.menu_name, self.menu_icon_name)

    def _create_activity(self, activity_path):
        registry = common.application.plugin_registry
        try:
            activity = registry.create_component(activity_path)
        except (PluginNotFound, ComponentNotFound), error:
            self.warning(error)
            activity = None
        else:
            activity.player_model = self.player_model
            activity.dvd_player_model = self.dvd_player_model
            activity.slideshow_model = self.slideshow_model
        return activity

