# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'
__maintainer2__ = 'Florian Boucault <florian@fluendo.com>'

from elisa.base_components.controller import Controller
from elisa.core.input_event import *
from elisa.core import common

class ElisaController(Controller):
    """
    DOCME
    """

    supported_models = ('base:elisa_model',)

    default_associations = (
    ('base:menu_model','base:tree_controller'),
    ('base:player_model','base:player_controller'),
    ('dvd:dvd_player_model','dvd:dvd_player_controller'),
    ('base:slideshow_model','base:slideshow_controller')
    )

    menu = None
    player = None
    slideshow = None
    dvd_player = None
    menu_controller_focused = None
    
    # theme component path (syntax: plugin:component)
    # set to None at startup
    # used to set the same theme for all the frontends connected to the
    # backend through this controller
    theme_path = None
    
    default_config = {'start_fullscreen': '0'}
    config_doc = {'start_fullscreen': 'whether or not Elisa should start fullscreen'}


    def __init__(self):
        Controller.__init__(self)
        self._last_panel_focused = None
        
    def last_panel_focused__get(self):
        activity_name = self.menu_controller_focused.model.activity.name
        if activity_name == 'main_menu_activity':
            index = self.menu_controller_focused.current_index
            activity_name = self.menu_controller_focused[index].model.activity.name
            
        if activity_name == 'image_activity':
            return self.slideshow
        elif activity_name == 'video_activity':
            return self.player
        elif activity_name == 'dvd_activity':
            return self.dvd_player
        
        return self.player

    def model_changed(self, old_model, new_model):
        self.menu = self.create_child_controller(self.model.menu)
        self.player = self.create_child_controller(self.model.player)
        self.dvd_player = self.create_child_controller(self.model.dvd_player)

        self.slideshow = self.create_child_controller(self.model.slideshow)

        self.menu.focus()
        self.menu_controller_focused = self.menu

        self.fullscreen = bool(int(self.config.get('start_fullscreen', '0')))

    def handle_input(self, input_event):
        if input_event.action == EventAction.MENU:
            self.toggle_menu()
            return True

        elif input_event.action == EventAction.EXIT:
            common.application.stop()
            return True

        elif input_event.action == EventAction.TOGGLE_FULLSCREEN:
            self.fullscreen = not self.fullscreen
            return True

        return False
    
    def toggle_menu(self):
        if self.menu.focused and self.menu.selected_controller == self.menu:
            return
            
        if self.backend != None:
            if self.menu.focused:
                self.last_panel_focused.focus()
            else:
                self.menu_controller_focused.focus()


    def focused_changed(self, old_focused, new_focused):
        if self.menu.focused:
            self.menu_controller_focused = self.backend.focused_controller


    def show_menu(self):
        self.menu_controller_focused.focus()
