# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'
__maintainer2__ = 'Philippe Normand <philippe@fluendo.com>'


from elisa.base_components.model import Model


class PlayerModel(Model):
    """
    DOCME

    @ivar uri:             URI of the media currently played
    @type uri:             L{elisa.core.media_uri.MediaUri}
    @ivar state:           current state of the player
    @type state:           L{elisa.core.player.STATES}
    @ivar playlist:        list of media that are to be played
    @type playlist:        L{elisa.plugins.base.models.list_model.ListModel}
    @ivar preview_mode:    whether or not the player is previewing the media
    @type preview_mode:    boolean
    @ivar volume:          volume level; between 0 and 10
    @type volume:          float
    @ivar muted:           whether or not the player is muted
    @type muted:           boolean
    @ivar position:        current position in the media (in nanoseconds);
                           READ ONLY; -1 if unknown
    @type position:        int
    @ivar duration:        duration of the current media (in nanoseconds);
                           READ ONLY; -1 if unknown
    @type duration:        int
    @ivar seek_to:         position where to seek in the file (in nanoseconds)
    @type seek_to:         int
    @ivar pause_requested: DOCME
    @type pause_requested: boolean
    @ivar media_type:      type of the media current played amongst; can be
                           'audio' or 'video'
    @type media_type:      string
    """

    uri = None
    state = None
    playlist = None
    preview_mode = False
    volume = 1.0
    muted = False
    position = -1
    duration = -1
    seek_to = 0
    # FIXME: pause_requested is not understandable
    # should the player pause() next time OK key is pressed
    pause_requested = False
    media_type = None
