
from elisa.core.tests import component_test_case
from elisa.plugins.base.models.list_model import ListModel
from elisa.base_components.model import Model

class TestListModel(component_test_case.ComponentTestCase):

    component_class = ListModel

    def test_parent(self):

        root_model = ListModel()
        child_list_model = ListModel()
        child_model = Model()
        child_model2 = Model()

        self.assertEquals(root_model.parent, None)
        self.assertEquals(child_list_model.parent, None)
        self.assertEquals(child_model.parent, None)

        root_model.append(child_model)
        self.assertEquals(root_model.parent, None)
        self.assertEquals(child_list_model.parent, None)
        self.assertEquals(child_model.parent, root_model)

        root_model.append(child_list_model)
        self.assertEquals(root_model.parent, None)
        self.assertEquals(child_list_model.parent, root_model)
        self.assertEquals(child_model.parent, root_model)

        root_model.remove(child_list_model)
        self.assertEquals(root_model.parent, None)
        self.assertEquals(child_list_model.parent, None)
        self.assertEquals(child_model.parent, root_model)

        root_model.remove(child_model)
        self.assertEquals(root_model.parent, None)
        self.assertEquals(child_list_model.parent, None)
        self.assertEquals(child_model.parent, None)


        root_model.append(child_list_model)
        self.assertEquals(child_list_model.parent, root_model)
        root_model.extend([child_model, child_model2])
        self.assertEquals(child_model.parent, root_model)
        self.assertEquals(child_model2.parent, root_model)

        root_model.pop()
        self.assertEquals(child_list_model.parent, root_model)
        self.assertEquals(child_model.parent, root_model)
        self.assertEquals(child_model2.parent, None)

        root_model.insert(0, child_model2)
        self.assertEquals(child_list_model.parent, root_model)
        self.assertEquals(child_model.parent, root_model)
        self.assertEquals(child_model2.parent, root_model)

        del root_model[0]
        self.assertEquals(child_list_model.parent, root_model)
        self.assertEquals(child_model.parent, root_model)
        self.assertEquals(child_model2.parent, None)
        child_list_model = ListModel()

        root_model[1] = child_model2
        self.assertEquals(child_list_model.parent, None)
        self.assertEquals(child_model.parent, None)
        self.assertEquals(child_model2.parent, root_model)

        root_model.insert(0, child_list_model)
        root_model.insert(1, child_model)
        self.assertEquals(child_list_model.parent, root_model)
        self.assertEquals(child_model.parent, root_model)
        self.assertEquals(child_model2.parent, root_model)

        del root_model[0:2]
        self.assertEquals(child_list_model.parent, None)
        self.assertEquals(child_model.parent, None)
        self.assertEquals(child_model2.parent, root_model)
        child_list_model = ListModel()
        child_model = Model()

        root_model=ListModel()
        root_model.append(child_list_model)
        root_model.append(child_model)
        root_model.append(child_model2)
        child_model3 = Model()
        child_model4 = Model()

        self.assertEquals(child_list_model.parent, root_model)
        self.assertEquals(child_model.parent, root_model)
        self.assertEquals(child_model2.parent, root_model)
        self.assertEquals(child_model3.parent, None)
        self.assertEquals(child_model4.parent, None)

        root_model[1:2] = [child_model3, child_model4]
        self.assertEquals(child_list_model.parent, root_model)
        self.assertEquals(child_model.parent, None)
        self.assertEquals(child_model2.parent, root_model)
        self.assertEquals(child_model3.parent, root_model)
        self.assertEquals(child_model4.parent, root_model)


    def test_parent2(self):
        root_model = ListModel()
        child_list_model = ListModel()
        child_model = Model()

        child_list_model.append(child_model)
        root_model.append(child_list_model)

        self.assertEquals(root_model.parent, None)
        self.assertEquals(child_list_model.parent, root_model)
        self.assertEquals(child_model.parent, child_list_model)
