
from elisa.core.tests import component_test_case
from elisa.base_components.media_provider import NotifyEvent
from elisa.plugins.base.media_providers import local_media
from elisa.core import media_uri
import os, gc, time
from twisted.internet import defer
from elisa.extern.coherence.inotify import INotify

class TestLocalMedia(component_test_case.ComponentTestCase):

    component_class = local_media.LocalMedia

    def __init__(self, methodName='runTest'):
        component_test_case.ComponentTestCase.__init__(self,
                                                       methodName=methodName)
        try:
            i = INotify()
            i.release()
        except Exception, error:
            self.skip = error
            
    def tearDown(self):
        try:
            i = INotify()
        except Exception, error:
            # no need to skip from here
            pass
        else:
            i.release()
            component_test_case.ComponentTestCase.tearDown(self)

    def _create_fs_hierarchy(self):
        try:
            os.makedirs('test/A/B')
        except:
            pass

        self._touch(media_uri.MediaUri('file://./test/A1.ogg'))
        self._touch(media_uri.MediaUri('file://./test/A/B/foo.mp3'))
        self._touch(media_uri.MediaUri('file://./test/A/B/bar.mp3'))
        self._touch(media_uri.MediaUri('file://./test/A/A2.ogg'))

    def _touch(self, path):
        f = open(path.path, 'w')
        f.write('woo')
        f.close()


    def test_get_direct_children(self):

        def list_filled(l):
            self.failUnless(len(l) > 0)


        uri = media_uri.MediaUri(u'file://.')
        l = []
        dfr = self.component.get_direct_children(uri, l)
        dfr.addCallback(list_filled)
        return dfr

    def test_monitor_uri(self):
        dfr = defer.Deferred()
        uri = media_uri.MediaUri(u'file://.')
        foo_txt = media_uri.MediaUri('file://./foo.txt')
        
        def cb(u1, metadata, evt, u):
            self.assertEquals(u, uri)
            self.assertEquals(evt, NotifyEvent.ADDED)
            self.assertEquals(u1, foo_txt)
            self.assertEquals(metadata, {})
            dfr.callback(True)
            
        self.component.monitor_uri(uri, cb)
        self._touch(foo_txt)
        
        dfr.addCallback(lambda r: self.component.unmonitor_uri(uri))
        return dfr

    def test_copy(self):

        self._create_fs_hierarchy()
        orig_uri = media_uri.MediaUri('file://./test/A1.ogg')
        dest_uri = media_uri.MediaUri('file://./test/B1.ogg')

        self.component.copy(orig_uri, dest_uri)
        self.failUnless(os.path.exists(dest_uri.path))


    def test_move(self):

        self._create_fs_hierarchy()
        orig_uri = media_uri.MediaUri('file://./test/A1.ogg')
        dest_uri = media_uri.MediaUri('file://./test/B1.ogg')

        self.component.move(orig_uri, dest_uri)
        self.failUnless(os.path.exists(dest_uri.path))


    def test_delete(self):

        uri = media_uri.MediaUri('file://./test/A1.ogg')
        self._touch(uri)
        self.component.delete(uri)
        self.failUnless(os.path.exists(uri.path) == False)


    def test_next_prev_location(self):

        self._create_fs_hierarchy()

        start = media_uri.MediaUri(u'file://./test/')

        def got_next1(next):
            self.assertEquals(next, media_uri.MediaUri(u'file://./test/A'))

            dfr2 = self.component.next_location(next, root=start)
            dfr2.addCallback(got_next2)
            return dfr2

        def got_next2(next):
            self.assertEquals(next, media_uri.MediaUri(u'file://./test/A/B'))

            dfr = self.component.next_location(next, root=start)
            dfr.addCallback(got_next3)
            return dfr

        def got_next3(next):
            self.assertEquals(next, media_uri.MediaUri(u'file://./test/A/B/bar.mp3'))

            dfr = self.component.next_location(next, root=start)
            dfr.addCallback(got_next4)
            return dfr

        def got_next4(next):
            self.assertEquals(next, media_uri.MediaUri(u'file://./test/A/B/foo.mp3'))

            dfr = self.component.next_location(next)
            dfr.addCallback(got_next5)
            return dfr

        def got_next5(next, end=False):
            self.assertEquals(next, media_uri.MediaUri(u'file://./test/A/A2.ogg'))

            if not end:
                dfr = self.component.next_location(next, root=start)
                dfr.addCallback(got_next6)
                return dfr

        def got_next6(next):
            self.assertEquals(next, media_uri.MediaUri(u'file://./test/A1.ogg'))

            dfr = self.component.previous_location(next)
            dfr.addCallback(got_next5, True)
            return dfr


        dfr = self.component.next_location(start, root=start)
        dfr.addCallback(got_next1)
        return dfr
        #self.assertEquals(prev, media_uri.MediaUri(u'file://./test/A/A2.ogg'))

        #FIXME: Make this test work with the new mime_getter

    def test_get_media_type(self):
        
        def got_ogg(media_type):
            self.assertEquals(media_type, {'file_type': 'audio',
                                           'mime_type': 'application/ogg'})

        ogg = media_uri.MediaUri(u'file://./test.ogg')
        d1 = self.component.get_media_type(ogg)
        d1.addCallback(got_ogg)

        def got_m3u(media_type):
            self.assertEquals(media_type, {'file_type': '',
                                           'mime_type': ''})

        m3u = media_uri.MediaUri(u'file://./test.m3u')
        d2 = self.component.get_media_type(m3u)
        d2.addCallback(got_m3u)

        def got_mp3(media_type):
            self.assertEquals(media_type, {'file_type': 'audio',
                                           'mime_type': 'audio/mpeg'})

        mp3 = media_uri.MediaUri(u'file://./test.mp3')
        d3 = self.component.get_media_type(mp3)
        d3.addCallback(got_mp3)

        d = defer.DeferredList([d1,d2,d3])
        return d
