
from elisa.core.tests import component_test_case
from elisa.core.media_uri import MediaUri
from twisted.internet import defer
import os

# TODO:
# - test http:// file:// smb:// ...
# - finish provider methods test

class TestVfsMedia(component_test_case.ComponentTestCase):

    component_class = 'elisa.plugins.base.media_providers.gnomevfs_media:GnomevfsMedia'

    def tearDown(self):
        self.component.clean()
        component_test_case.ComponentTestCase.tearDown(self)

    def test_directory1(self):

        def got_answer(answer, right_value):
            self.assertEquals(answer, right_value)

        uri = MediaUri(u'ftp://ftp.informatik.rwth-aachen.de/')
        dfr = self.component.is_directory(uri)
        dfr.addCallback(got_answer, True)

        uri = MediaUri(u'ftp://ftp.informatik.rwth-aachen.de/README')
        dfr2 = self.component.is_directory(uri)
        dfr2.addCallback(got_answer, False)

        return defer.DeferredList([dfr, dfr2])

    test_directory1.skip = "unreliable (at times) FTP"

    def test_has_children(self):

        def got_answer(answer, right_value):
            self.assertEquals(answer, right_value)

        uri = MediaUri(u'ftp://ftp.informatik.rwth-aachen.de/')
        dfr = self.component.is_directory(uri)
        dfr.addCallback(got_answer, True)

        uri = MediaUri(u'ftp://ftp.informatik.rwth-aachen.de/README')
        dfr2 = self.component.is_directory(uri)
        dfr2.addCallback(got_answer, False)

        return defer.DeferredList([dfr, dfr2])

    test_has_children.skip = "unreliable (at times) FTP"
