# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'

from elisa.core import plugin 
from elisa.core import component

class PigmentPlugin(plugin.Plugin):
    name = "pigment"
    config_file = "plugin.conf"
    
    @classmethod
    def initialize(cls):
        errors = plugin.Plugin.initialize()
        if not errors:
            # check if old version of Pigment is installed
            try:
                from pgm import render
            except ImportError:
                pass
            else:
                reason = "Pigment 0.1.x detected. Please uninstall it and install at least the 0.3.1 version"
                raise component.InitializeFailure(cls.name, reason)
            
        return errors
