# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


from elisa.core import common, plugin_registry
from elisa.core.plugin_registry import PluginNotFound, ComponentNotFound
from elisa.core.media_uri import MediaUri

from elisa.extern.translation import gettexter, N_
T_ = gettexter('elisa-theme-switcher')

from switch_theme_action import SwitchThemeAction


MenuActivityClass = plugin_registry.get_component_class('base:menu_activity')

class ThemeSwitcherActivity(MenuActivityClass):
    """
    Manages a list of themes that the user can switch between.
    """
    config_doc = {'themes': "a list of themes (eg. ['classic:theme',"
                            "'poblenou:tango_theme'])"}
    default_config = {'themes': []}

    menu_name = T_(N_("Themes"))
    menu_icon_name = "theme_switcher"
    media_types = []
    
    def get_model(self):
        """
        Returns a menu_node_model for the Theme menu
        """
        registry = common.application.plugin_registry
        main_node = MenuActivityClass.get_model(self)
        
        for theme_path in self.config.get("themes" , []):
            try:
                component = registry.create_component(theme_path)
            except (PluginNotFound, ComponentNotFound), error:
                self.warning(error)
            else:
                self.log("Component %r with menu model %r", component, \
                         component.name)
                label = component.name.split('_')[0].capitalize()
                menu_model = self._create_menu_model(label, 'theme')
                thumbnail = MediaUri('file://%s' % \
                                     component.get_media('theme_icon'))
                menu_model.thumbnail_source = thumbnail
                action = SwitchThemeAction()
                action.theme_path = theme_path
                menu_model.activate_action = action
                menu_model.activity = self
                
                if menu_model != None:
                    self.log("menu model: %r", menu_model)
                    main_node.append(menu_model)
                else:
                    self.debug("menu_model %r should have got %r appended",
                               main_node, component.name)

        main_node.has_children = len(main_node) > 0
        
        return main_node
