# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


from elisa.core import common
from elisa.core.plugin_registry import PluginNotFound, ComponentNotFound
from elisa.core import plugin_registry

from elisa.extern.translation import gettexter, N_
T_ = gettexter('elisa-service')

MenuActivityClass = plugin_registry.get_component_class('base:menu_activity')

class AboutActivity(MenuActivityClass):


    menu_name = T_(N_("About"))
    menu_icon_name = "about"
    media_types = []
