# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2008-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
Default configuration constants.
"""

import os.path

CONFIG_DIR = os.path.join(os.path.expanduser('~'), ".elisa-0.5")

# We add to the configuration file name the version number in order to bypass
# the configuration upgrade system. Direct consequences:
# - custom user configuration is lost between releases
# - prevents configuration upgrade bugs
# - avoid configuration upgrade work
#version_string = "_".join([str(n) for n in version_info])
#CONFIG_FILE = "elisa_%s.conf" % version_string

# FIXME: hardcoded configuration file name in order to avoid its rewriting
# starting from Elisa 0.5.6; this is a temporary solution that is valid for
# the moment given that there is no configuration to upgrade for now.
CONFIG_FILE = "elisa_0_5_6.conf"

PICTURES_CACHE = os.path.join(CONFIG_DIR, 'pictures_cache')

DEFAULT_CONFIG = """\
[general]
version = '%(version)s'
install_date = '%(install_date)s'
frontends = ['frontend1']
disabled_plugins = []
# database connection string. see https://storm.canonical.com/Manual
database = '%(database_uri)s'
# Set to 1 for advanced, unsupported (possibly unstable, you've been warned!)
# features.
power_user = '0'

[frontend1]
frontend = 'pigment.pigment_frontend:PigmentFrontend'
theme = 'elisa.plugins.poblesec'
controller_path = '/poblesec'

[directories]
video = ['*default*']
pictures = ['*default*']
music = ['*default*']
"""
