package de.lmu.ifi.dbs.elki.math.statistics.distribution;

/*
 This file is part of ELKI:
 Environment for Developing KDD-Applications Supported by Index-Structures

 Copyright (C) 2015
 Ludwig-Maximilians-Universität München
 Lehr- und Forschungseinheit für Datenbanksysteme
 ELKI Development Team

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import org.junit.Test;

import de.lmu.ifi.dbs.elki.JUnit4Test;

/**
 * Unit test for the Gumbel distribution in ELKI.
 * 
 * The reference values were computed using SciPy.
 * 
 * @author Erich Schubert
 * @since 0.6.0
 */
public class GumbelDistributionTest extends AbstractDistributionTest implements JUnit4Test {
  public static final double[] P_CDFPDF = { //
  1e-10, 1e-05, 0.1, 0.1234567, 0.2, 0.271828182846, 0.3, 0.314159265359, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.71828182846, 3.14159265359 //
  };

  public static final double[] SCIPY_GUMBEL_CDF_1_1 = { //
  6.59880358632499303128682299757201690226793289184570e-02, // 0.000000
  6.59898296015106466949617924910853616893291473388672e-02, // 0.000010
  8.54688658759459179981021748062630649656057357788086e-02, // 0.100000
  9.04841721928088676962786962576501537114381790161133e-02, // 0.123457
  1.08008977696591554340521668109431630000472068786621e-01, // 0.200000
  1.26023050723474722145667215045250486582517623901367e-01, // 0.271828
  1.33486796658083856081944418292550835758447647094727e-01, // 0.300000
  1.37320130159857167750914186399313621222972869873047e-01, // 0.314159
  1.61682814145126474425495644027250818908214569091797e-01, // 0.400000
  1.92295645547964910715421638087718747556209564208984e-01, // 0.500000
  2.24961793549918465107140264080953784286975860595703e-01, // 0.600000
  2.59276865990827554142583721841219812631607055664062e-01, // 0.700000
  2.94816320729158143354453613937948830425739288330078e-01, // 0.800000
  3.31154277152908960157873252683202736079692840576172e-01, // 0.900000
  3.67879441171442334024277442949824035167694091796875e-01, // 1.000000
  4.04607661664131867951255117077380418777465820312500e-01, // 1.100000
  4.40991025942982617369381159733165986835956573486328e-01, // 1.200000
  4.76723690714594083850386141421040520071983337402344e-01, // 1.300000
  5.11544833689041578139722332707606256008148193359375e-01, // 1.400000
  5.45239211892605046827497972117271274328231811523438e-01, // 1.500000
  5.77635844258915676086019175272667780518531799316406e-01, // 1.600000
  6.08605317804406409365469698968809098005294799804688e-01, // 1.700000
  6.38056166582018691180167024867841973900794982910156e-01, // 1.800000
  6.65930705440122117089174480497604236006736755371094e-01, // 1.900000
  6.92200627555346392760782237019157037138938903808594e-01, // 2.000000
  8.35793188453588298258978284138720482587814331054688e-01, // 2.718282
  8.89169312582892001906031964608700945973396301269531e-01, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_PDF_1_1 = { //
  1.79374078764838684740823282481869682669639587402344e-01, // 0.000000
  1.79377160888317427334115450321405660361051559448242e-01, // 0.000010
  2.10219488415532645975147829631168860942125320434570e-01, // 0.100000
  2.17395492872112461313349740521516650915145874023438e-01, // 0.123457
  2.40378400508394624024433028353087138384580612182617e-01, // 0.200000
  2.61030341003925192566725854703690856695175170898438e-01, // 0.271828
  2.68809398181777348124654736238881014287471771240234e-01, // 0.300000
  2.72640929007956611673790803251904435455799102783203e-01, // 0.314159
  2.94605295353879470532376672053942456841468811035156e-01, // 0.400000
  3.17041921077942157047857563156867399811744689941406e-01, // 0.500000
  3.35603559643445015225893257593270391225814819335938e-01, // 0.600000
  3.49987161158421655748895773285767063498497009277344e-01, // 0.700000
  3.60089467289227027624320953691494651138782501220703e-01, // 0.800000
  3.65982076505757814022246066087973304092884063720703e-01, // 0.900000
  3.67879441171442334024277442949824035167694091796875e-01, // 1.000000
  3.66104151897740148768889412167482078075408935546875e-01, // 1.100000
  3.61052914770930044596752850338816642761230468750000e-01, // 1.200000
  3.53165596312007168400270984420785680413246154785156e-01, // 1.300000
  3.42898756467731824493228032224578782916069030761719e-01, // 1.400000
  3.30704298890418080247854959452524781227111816406250e-01, // 1.500000
  3.17013272754289754384871002912404946982860565185547e-01, // 1.600000
  3.02224456630968474346587981926859356462955474853516e-01, // 1.700000
  2.86697116378903826827695411338936537504196166992188e-01, // 1.800000
  2.70747220321607640070027400724939070641994476318359e-01, // 1.900000
  2.54646380043582531982337968656793236732482910156250e-01, // 2.000000
  1.49919633191029216812140134607034269720315933227539e-01, // 2.718282
  1.04448592925595828972973322379402816295623779296875e-01, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_CDF_2_1 = { //
  6.17978989787721657254981888485190211213193833827972e-04, // 0.000000
  6.18024653604032120531031058163762281765230000019073e-04, // 0.000010
  1.24839763464425581619698935043061283067800104618073e-03, // 0.100000
  1.45770722707259806419366476859522663289681077003479e-03, // 0.123457
  2.35869338329322553171607523836428299546241760253906e-03, // 0.200000
  3.58731530475635143964674433902928285533562302589417e-03, // 0.271828
  4.19464154138938540017367273549098172225058078765869e-03, // 0.300000
  4.53021237372840286650177432647979003377258777618408e-03, // 0.314159
  7.06196156220941038267335798650492506567388772964478e-03, // 0.400000
  1.13142863804596271321001310639076109509915113449097e-02, // 0.500000
  1.73320140087645062354493319389803218655288219451904e-02, // 0.600000
  2.54943946757241260425708162529190303757786750793457e-02, // 0.700000
  3.61486049131355194341530534529738361015915870666504e-02, // 0.800000
  4.95800856955669819181586888134916080161929130554199e-02, // 0.900000
  6.59880358453125426265728492580819875001907348632812e-02, // 1.000000
  8.54688658759459596314655982496333308517932891845703e-02, // 1.100000
  1.08008977696591554340521668109431630000472068786621e-01, // 1.200000
  1.33486796658083856081944418292550835758447647094727e-01, // 1.300000
  1.61682814145126418914344412769423797726631164550781e-01, // 1.400000
  1.92295645547964910715421638087718747556209564208984e-01, // 1.500000
  2.24961793549918520618291495338780805468559265136719e-01, // 1.600000
  2.59276865990827554142583721841219812631607055664062e-01, // 1.700000
  2.94816320729158143354453613937948830425739288330078e-01, // 1.800000
  3.31154277152908849135570790167548693716526031494141e-01, // 1.900000
  3.67879441171442334024277442949824035167694091796875e-01, // 2.000000
  6.14105034982032282897534969379194080829620361328125e-01, // 2.718282
  7.26650204627822926539693071390502154827117919921875e-01, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_PDF_2_1 = { //
  4.56628142304533850281966778084097313694655895233154e-03, // 0.000000
  4.56657317004234564183917655100231058895587921142578e-03, // 0.000010
  8.34665480722261536594697162172451498918235301971436e-03, // 0.100000
  9.52012623739182869964103872462146682664752006530762e-03, // 0.123457
  1.42692634455674552396153842437342973425984382629395e-02, // 0.200000
  2.01978449671180448898866188756073825061321258544922e-02, // 0.271828
  2.29612471247189892098461427849542815238237380981445e-02, // 0.300000
  2.44494948372630735433652660049119731411337852478027e-02, // 0.314159
  3.49781245974551888155978929262346355244517326354980e-02, // 0.400000
  5.07071136099807306951703367303707636892795562744141e-02, // 0.500000
  7.02847826336932546276159428089158609509468078613281e-02, // 0.600000
  9.35464974266043414186100335427909158170223236083984e-02, // 0.700000
  1.20017594905418731321411485168937360867857933044434e-01, // 0.800000
  1.48946808910974892725675999827217310667037963867188e-01, // 0.900000
  1.79374078734017200487116383555985521525144577026367e-01, // 1.000000
  2.10219488415532701486299060888995882123708724975586e-01, // 1.100000
  2.40378400508394624024433028353087138384580612182617e-01, // 1.200000
  2.68809398181777348124654736238881014287471771240234e-01, // 1.300000
  2.94605295353879415021225440796115435659885406494141e-01, // 1.400000
  3.17041921077942157047857563156867399811744689941406e-01, // 1.500000
  3.35603559643445015225893257593270391225814819335938e-01, // 1.600000
  3.49987161158421655748895773285767063498497009277344e-01, // 1.700000
  3.60089467289227027624320953691494651138782501220703e-01, // 1.800000
  3.65982076505757758511094834830146282911300659179688e-01, // 1.900000
  3.67879441171442334024277442949824035167694091796875e-01, // 2.000000
  2.99431043346856384790299898668308742344379425048828e-01, // 2.718282
  2.32026725020700291812758564446994569152593612670898e-01, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_CDF_4_1 = { //
  1.94233761556120265073609843858010169210640550320133e-24, // 0.000000
  1.94339836960486498321475838226799834065378487714337e-24, // 0.000010
  3.50581472625786942134053009067093603336708158078897e-22, // 0.100000
  1.10204869082170943883948227538294176292737847487482e-21, // 0.123457
  3.85942175009585124493227078787604613125739296999845e-20, // 0.200000
  8.55175072212361792537222183911253732406541162804661e-19, // 0.271828
  2.71618226092945448511767238087193692507249743561641e-18, // 0.300000
  4.79654546206938212109880845109838654258082904740905e-18, // 0.314159
  1.27523062451624426541224412921385568571695936319552e-16, // 0.400000
  4.15089692010904525288672126361021019245556122612140e-15, // 0.500000
  9.69966408521639154441452223525895873820334286419254e-14, // 0.600000
  1.67930865740466120726981233244263965733930610291225e-12, // 0.700000
  2.21644780341866066467927092510455566905236413077773e-11, // 0.800000
  2.28850701972651310101286108247299871248925384747963e-10, // 0.900000
  1.89217869483829244811168274588777937772476889222162e-09, // 1.000000
  1.27958444708893479866928830448492837579266279135481e-08, // 1.100000
  7.21407495654723266621612446335143342679430134012364e-08, // 1.200000
  3.44996444807882075559481984891596617615050490712747e-07, // 1.300000
  1.42158510896623277238609052430806656275308341719210e-06, // 1.400000
  5.11929429867073290303346178031773661132319830358028e-06, // 1.500000
  1.63190669761509105832684302095358930273505393415689e-05, // 1.600000
  4.65873061192628793976758250217073964449809864163399e-05, // 1.700000
  1.20361180348421196420645451485853527628933079540730e-04, // 1.800000
  2.84104078721292101477463587499983077577780932188034e-04, // 1.900000
  6.17978989331093432439689916435554550844244658946991e-04, // 2.000000
  2.72466505377139643628847665013381629250943660736084e-02, // 2.718282
  9.44768930014186492094552249909611418843269348144531e-02, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_PDF_4_1 = { //
  1.06048040538825383895657084905076034872528558503039e-22, // 0.000000
  1.06104894703602011823679422569673096865235426708292e-22, // 0.000010
  1.73195833587372556877622009550080809725453568188831e-20, // 0.100000
  5.31816915757311281533262916149991462179401939316581e-20, // 0.123457
  1.72520723688492552379661823003568327945291845918510e-18, // 0.200000
  3.55778320603558542628503187787223104575572232312602e-17, // 0.271828
  1.09862250605229655196224903219933069216592916588111e-16, // 0.300000
  1.91279689150650823875815251444059610432563375858640e-16, // 0.314159
  4.66711893658034022812779722242683120807921724748635e-15, // 0.400000
  1.37458827543354963946170620516550599064667728677058e-13, // 0.500000
  2.90641705075567549607614189502246106536209602211329e-12, // 0.600000
  4.55304892645473537813182015220254180570824686924425e-11, // 0.700000
  5.43750726676849818042246906675497505889715910143423e-10, // 0.800000
  5.08001673311263319774744418142083113298923535694485e-09, // 0.900000
  3.80054250404435749527446645589651152974397518846672e-08, // 1.000000
  2.32553537538727241913236328495206972633013720042072e-07, // 1.100000
  1.18632914440636535453432297976261722283197741489857e-06, // 1.200000
  5.13345454477618321902391770872320364560437155887485e-06, // 1.300000
  1.91398495015806936032053131579999671885161660611629e-05, // 1.400000
  6.23657718766199291749591226974303026509005576372147e-05, // 1.500000
  1.79887953645615079585964868336134259152458980679512e-04, // 1.600000
  4.64670291311834173994532726226225349819287657737732e-04, // 1.700000
  1.08626127745232634556893369648378211422823369503021e-03, // 1.800000
  2.32004217969156720582923902895799983525648713111877e-03, // 1.900000
  4.56628142012791525539139314560088678263127803802490e-03, // 2.000000
  9.81649050447965243471060148294782266020774841308594e-02, // 2.718282
  2.22908780675388440428719150077085942029953002929688e-01, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_CDF_4_10 = { //
  2.24961793553274530532704034158086869865655899047852e-01, // 0.000000
  2.24962129153560647099041602814395446330308914184570e-01, // 0.000010
  2.28326012057771948748907675508235115557909011840820e-01, // 0.100000
  2.29117491320003585641984500398393720388412475585938e-01, // 0.123457
  2.31706315790068034798920848515990655869245529174805e-01, // 0.200000
  2.34144016800101217867791092430707067251205444335938e-01, // 0.271828
  2.35102282543562940420045492828649003058671951293945e-01, // 0.300000
  2.35584367949729117652779564195952843874692916870117e-01, // 0.314159
  2.38513488532688416876581527503731194883584976196289e-01, // 0.400000
  2.41939508585804652351924914910341612994670867919922e-01, // 0.500000
  2.45379916339054454654799997115333098918199539184570e-01, // 0.600000
  2.48834284427714574894352494993654545396566390991211e-01, // 0.700000
  2.52302184674948581921682944084750488400459289550781e-01, // 0.800000
  2.55783188277869832916167069924995303153991699218750e-01, // 0.900000
  2.59276865990827554142583721841219812631607055664062e-01, // 1.000000
  2.62782788305835623976491888242890127003192901611328e-01, // 1.100000
  2.66300525630066620141889188744244165718555450439453e-01, // 1.200000
  2.69829648460341131599449226996512152254581451416016e-01, // 1.300000
  2.73369727554544250658352666505379602313041687011719e-01, // 1.400000
  2.76920334099908960201474883433547802269458770751953e-01, // 1.500000
  2.80481039878108018292834913154365494847297668457031e-01, // 1.600000
  2.84051417427103602975080320902634412050247192382812e-01, // 1.700000
  2.87631040199704479665143708189134486019611358642578e-01, // 1.800000
  2.91219482718789723918462186702527105808258056640625e-01, // 1.900000
  2.94816320729158143354453613937948830425739288330078e-01, // 2.000000
  3.20860670367920819412432820172398351132869720458984e-01, // 2.718282
  3.36339983908659712064093127992236986756324768066406e-01, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_PDF_4_10 = { //
  3.35603559645095625429966901265288470312952995300293e-02, // 0.000000
  3.35603724701354494408533923888171557337045669555664e-02, // 0.000010
  3.37233134553145824652276019151031505316495895385742e-02, // 0.100000
  3.37609284733200315509193956131639424711465835571289e-02, // 0.123457
  3.38820574854396400210632123162213247269392013549805e-02, // 0.200000
  3.39934708099677296289087280456442385911941528320312e-02, // 0.271828
  3.40365712424673116931472804935765452682971954345703e-02, // 0.300000
  3.40581064819283629852009198657469823956489562988281e-02, // 0.314159
  3.41868398883302671009687401237897574901580810546875e-02, // 0.400000
  3.43328505356715121821231662124773720279335975646973e-02, // 0.500000
  3.44745922233250789989966733628534711897373199462891e-02, // 0.600000
  3.46120558908042108559044436333351768553256988525391e-02, // 0.700000
  3.47452343518489734086607256813294952735304832458496e-02, // 0.800000
  3.48741222670847020315143538482516305521130561828613e-02, // 0.900000
  3.49987161158421683504471388914680574089288711547852e-02, // 1.000000
  3.51190141671897312902750343255320331081748008728027e-02, // 1.100000
  3.52350164502270857269650150556117296218872070312500e-02, // 1.200000
  3.53467247236895973361292533354571787640452384948730e-02, // 1.300000
  3.54541424449113518058140925859333947300910949707031e-02, // 1.400000
  3.55572747381944151423560640523646725341677665710449e-02, // 1.500000
  3.56561283626308858640818755247892113402485847473145e-02, // 1.600000
  3.57507116794234872103608324778178939595818519592285e-02, // 1.700000
  3.58410346187495246206289323254168266430497169494629e-02, // 1.800000
  3.59271086462122773985683465980400796979665756225586e-02, // 1.900000
  3.60089467289226999868745338062581140547990798950195e-02, // 2.000000
  3.64737821185050284378270646357123041525483131408691e-02, // 2.718282
  3.66487069582701815995129379643913125619292259216309e-02, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_CDF_01_10 = { //
  3.64200708229312053454407305252971127629280090332031e-01, // 0.000000
  3.64201076086621500227380465730675496160984039306641e-01, // 0.000010
  3.67879441171442334024277442949824035167694091796875e-01, // 0.100000
  3.68742364149354184821305580044281668961048126220703e-01, // 0.123457
  3.71558174423808174058336817324743606150150299072266e-01, // 0.200000
  3.74200337049799547362027851704624481499195098876953e-01, // 0.271828
  3.75236541960806024853525286744115874171257019042969e-01, // 0.300000
  3.75757321275714095687447979798889718949794769287109e-01, // 0.314159
  3.78914181510685010856320786842843517661094665527344e-01, // 0.400000
  3.82590734620523953424253704724833369255065917968750e-01, // 0.500000
  3.86265846721645655925669871066929772496223449707031e-01, // 0.600000
  3.89939167191828084391147513088071718811988830566406e-01, // 0.700000
  3.93610349414351023966673892573453485965728759765625e-01, // 0.800000
  3.97279050833918845331282909683068282902240753173828e-01, // 0.900000
  4.00944933009500681375669728367938660085201263427734e-01, // 1.000000
  4.04607661664131867951255117077380418777465820312500e-01, // 1.100000
  4.08266906731719725343054960831068456172943115234375e-01, // 1.200000
  4.11922342400900476366842895004083402454853057861328e-01, // 1.300000
  4.15573647155991876545044760860037058591842651367188e-01, // 1.400000
  4.19220503815090905774809471040498465299606323242188e-01, // 1.500000
  4.22862599565362817788383154038456268608570098876953e-01, // 1.600000
  4.26499625995571840508802097247098572552204132080078e-01, // 1.700000
  4.30131279125902432625139226729515939950942993164062e-01, // 1.800000
  4.33757259435121944601831955878878943622112274169922e-01, // 1.900000
  4.37377271885135254780863078849506564438343048095703e-01, // 2.000000
  4.63178277570029439669241355659323744475841522216797e-01, // 2.718282
  4.78191805551566095910942522095865570008754730224609e-01, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_PDF_01_10 = { //
  3.67860986195510386576046357731684111058712005615234e-02, // 0.000000
  3.67860989892352038821421444936277111992239952087402e-02, // 0.000010
  3.67879441171442347902065250764280790463089942932129e-02, // 0.100000
  3.67878429896495301454351078973559197038412094116211e-02, // 0.123457
  3.67861108816435675161748974915099097415804862976074e-02, // 0.200000
  3.67825446794351126889033309907972579821944236755371e-02, // 0.271828
  3.67806360606196675044898825035488698631525039672852e-02, // 0.300000
  3.67795687265079010441759521654603304341435432434082e-02, // 0.314159
  3.67715575045233014628287548930529737845063209533691e-02, // 0.400000
  3.67589137340928531760830821895069675520062446594238e-02, // 0.500000
  3.67427439081312035007442773348884657025337219238281e-02, // 0.600000
  3.67230877916642356462162410934979561716318130493164e-02, // 0.700000
  3.66999857244961757984924588527064770460128784179688e-02, // 0.800000
  3.66734785901757648352017326942586805671453475952148e-02, // 0.900000
  3.66436077853866115638936662435298785567283630371094e-02, // 1.000000
  3.66104151897740162646677219981938833370804786682129e-02, // 1.100000
  3.65739431362198524899653762076923158019781112670898e-02, // 1.200000
  3.65342343815761166903044454556948039680719375610352e-02, // 1.300000
  3.64913320778669988952991332098463317379355430603027e-02, // 1.400000
  3.64452797439685782787677226224332116544246673583984e-02, // 1.500000
  3.63961212377742968082650065753114176914095878601074e-02, // 1.600000
  3.63439007288538645790154646419978234916925430297852e-02, // 1.700000
  3.62886626716122442926071300917101325467228889465332e-02, // 1.800000
  3.62304517789548280459754892035562079399824142456055e-02, // 1.900000
  3.61693129964641910123468449000938562676310539245605e-02, // 2.000000
  3.56482034999189151269760600371228065341711044311523e-02, // 2.718282
  3.52782829415396598227161462091316934674978256225586e-02, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_CDF_01_20 = { //
  3.66040051641140451454958792965044267475605010986328e-01, // 0.000000
  3.66040235576718830934339621308026835322380065917969e-01, // 0.000010
  3.67879441171442334024277442949824035167694091796875e-01, // 0.100000
  3.68310902956942021191366620769258588552474975585938e-01, // 0.123457
  3.69718830722743807548624772607581689953804016113281e-01, // 0.200000
  3.71040005167483422088281486139749176800251007080078e-01, // 0.271828
  3.71558174423808174058336817324743606150150299072266e-01, // 0.300000
  3.71818605637736554481165285324095748364925384521484e-01, // 0.314159
  3.73397426637427698459248404105892404913902282714844e-01, // 0.400000
  3.75236541960806024853525286744115874171257019042969e-01, // 0.500000
  3.77075475227729051130864945662324316799640655517578e-01, // 0.600000
  3.78914181510685010856320786842843517661094665527344e-01, // 0.700000
  3.80752616122933373876691121040494181215763092041016e-01, // 0.800000
  3.82590734620523953424253704724833369255065917968750e-01, // 0.900000
  3.84428492804265664606333530173287726938724517822266e-01, // 1.000000
  3.86265846721645655925669871066929772496223449707031e-01, // 1.100000
  3.88102752668698702809280121073243208229541778564453e-01, // 1.200000
  3.89939167191828084391147513088071718811988830566406e-01, // 1.300000
  3.91775047089576777814556862722383812069892883300781e-01, // 1.400000
  3.93610349414351023966673892573453485965728759765625e-01, // 1.500000
  3.95445031474095209933494743381743319332599639892578e-01, // 1.600000
  3.97279050833918845331282909683068282902240753173828e-01, // 1.700000
  3.99112365317676576204064531339099630713462829589844e-01, // 1.800000
  4.00944933009500681375669728367938660085201263427734e-01, // 1.900000
  4.02776712255286439834378597879549488425254821777344e-01, // 2.000000
  4.15907192667703928812272806680994108319282531738281e-01, // 2.718282
  4.23619395109240293173513691726839169859886169433594e-01, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_PDF_01_20 = { //
  1.83937417516764276093077512541640317067503929138184e-02, // 0.000000
  1.83937417977731651475004071016883244737982749938965e-02, // 0.000010
  1.83939720585721173951032625382140395231544971466064e-02, // 0.100000
  1.83939594126808145246876335932029178366065025329590e-02, // 0.123457
  1.83937425180828485749007228378104628063738346099854e-02, // 0.200000
  1.83932951601603437985499311935200239531695842742920e-02, // 0.271828
  1.83930554408217837580874487457549548707902431488037e-02, // 0.300000
  1.83929213116811943184991662292304681614041328430176e-02, // 0.314159
  1.83919131598794319271128472337295534089207649230957e-02, // 0.400000
  1.83903180303098337522449412517744349315762519836426e-02, // 0.500000
  1.83882724286199075725001250702916877344250679016113e-02, // 0.600000
  1.83857787522616507314143774465264868922531604766846e-02, // 0.700000
  1.83828394191271268787168935432418948039412498474121e-02, // 0.800000
  1.83794568670464265880415410947534837760031223297119e-02, // 0.900000
  1.83756335532885978212291888667095918208360671997070e-02, // 1.000000
  1.83713719540656017503721386674442328512668609619141e-02, // 1.100000
  1.83666745640393841432214117048715706914663314819336e-02, // 1.200000
  1.83615438958321178231081205467489780858159065246582e-02, // 1.300000
  1.83559824795396266117197825451512471772730350494385e-02, // 1.400000
  1.83499928622480878992462294263532385230064392089844e-02, // 1.500000
  1.83435776075540693530463443039479898288846015930176e-02, // 1.600000
  1.83367392950878824176008663471293402835726737976074e-02, // 1.700000
  1.83294805200404052614171490631633787415921688079834e-02, // 1.800000
  1.83218038926933057819468331217649392783641815185547e-02, // 1.900000
  1.83137120379528138547353677267892635427415370941162e-02, // 2.000000
  1.82436263119165158197443332710463437251746654510498e-02, // 2.718282
  1.81927559990815723711676810125936754047870635986328e-02, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_CDF_01_4 = { //
  3.58683419097346689596861324389465153217315673828125e-01, // 0.000000
  3.58684338497014365554349524245481006801128387451172e-01, // 0.000010
  3.67879441171442334024277442949824035167694091796875e-01, // 0.100000
  3.70036738247086438580168987755314446985721588134766e-01, // 0.123457
  3.77075475227729051130864945662324316799640655517578e-01, // 0.200000
  3.83677647968239443621030204667476937174797058105469e-01, // 0.271828
  3.86265846721645655925669871066929772496223449707031e-01, // 0.300000
  3.87566357530248317697640914047951810061931610107422e-01, // 0.314159
  3.95445031474095209933494743381743319332599639892578e-01, // 0.400000
  4.04607661664131867951255117077380418777465820312500e-01, // 0.500000
  4.13748531068576341773734839080134406685829162597656e-01, // 0.600000
  4.22862599565362817788383154038456268608570098876953e-01, // 0.700000
  4.31944996928375679612344129054690711200237274169922e-01, // 0.800000
  4.40991025942982672880532390990993008017539978027344e-01, // 0.900000
  4.49996164872620063590602512704208493232727050781250e-01, // 1.000000
  4.58956069307663805378894039677106775343418121337891e-01, // 1.100000
  4.67866573428437237947008497940259985625743865966797e-01, // 1.200000
  4.76723690714594083850386141421040520071983337402344e-01, // 1.300000
  4.85523614133279490800987332477234303951263427734375e-01, // 1.400000
  4.94262715838446498040070764545816928148269653320312e-01, // 1.500000
  5.02937546413495417674255349993472918868064880371094e-01, // 1.600000
  5.11544833689041578139722332707606256008148193359375e-01, // 1.700000
  5.20081481167105397211969375348417088389396667480469e-01, // 1.800000
  5.28544566082388089789390051009831950068473815917969e-01, // 1.900000
  5.36931337130553965053536558116320520639419555664062e-01, // 2.000000
  5.94719607054730259321217999968212097883224487304688e-01, // 2.718282
  6.26579099505278791504281343804905191063880920410156e-01, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_PDF_01_4 = { //
  9.19408832681790494367746191528567578643560409545898e-02, // 0.000000
  9.19408890865627964616990652757522184401750564575195e-02, // 0.000010
  9.19698602928605835060693607374560087919235229492188e-02, // 0.100000
  9.19682820379929405474328518721449654549360275268555e-02, // 0.123457
  9.19413621430995309236067214442300610244274139404297e-02, // 0.200000
  9.18862440991995849115525629713374655693769454956055e-02, // 0.271828
  9.18568597703280087518606933372211642563343048095703e-02, // 0.300000
  9.18404563854176708703747067374933976680040359497070e-02, // 0.314159
  9.17178880377703537041256254269683267921209335327148e-02, // 0.400000
  9.15260379744350371922223530418705195188522338867188e-02, // 0.500000
  9.12829492792362195974220639982377178966999053955078e-02, // 0.600000
  9.09903030944357454901094683918927330523729324340820e-02, // 0.700000
  9.06498150644146627463726417772704735398292541503906e-02, // 0.800000
  9.02632286927325111491882125847041606903076171875000e-02, // 0.900000
  8.98323090075764524309320790962374303489923477172852e-02, // 1.000000
  8.93588365430456332827446885858080349862575531005859e-02, // 1.100000
  8.88446016412571676346132676371780689805746078491211e-02, // 1.200000
  8.82913990780017921000677461051964201033115386962891e-02, // 1.300000
  8.77010230126132606098821042905910871922969818115234e-02, // 1.400000
  8.70752622608445409069233278387400787323713302612305e-02, // 1.500000
  8.64158958878580990559115093674336094409227371215820e-02, // 1.600000
  8.57246891169329561233070080561446957290172576904297e-02, // 1.700000
  8.50033895481578094521779576098197139799594879150391e-02, // 1.800000
  8.42537236802113342903908232983667403459548950195312e-02, // 1.900000
  8.34773937273183275209476050804369151592254638671875e-02, // 2.000000
  7.72637758157185411400647012669651303440332412719727e-02, // 2.718282
  7.32283395263601255553709279411123134195804595947266e-02, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_CDF_01_1 = { //
  3.31154277189507073586582919233478605747222900390625e-01, // 0.000000
  3.31157936975598421458499842628953047096729278564453e-01, // 0.000010
  3.67879441171442334024277442949824035167694091796875e-01, // 0.100000
  3.76507892217193051997981001477455720305442810058594e-01, // 0.123457
  4.04607661664131867951255117077380418777465820312500e-01, // 0.200000
  4.30794607123086759070673679161700420081615447998047e-01, // 0.271828
  4.40991025942982672880532390990993008017539978027344e-01, // 0.300000
  4.46096575846239407070470406324602663516998291015625e-01, // 0.314159
  4.76723690714594083850386141421040520071983337402344e-01, // 0.400000
  5.11544833689041578139722332707606256008148193359375e-01, // 0.500000
  5.45239211892605046827497972117271274328231811523438e-01, // 0.600000
  5.77635844258915676086019175272667780518531799316406e-01, // 0.700000
  6.08605317804406409365469698968809098005294799804688e-01, // 0.800000
  6.38056166582018691180167024867841973900794982910156e-01, // 0.900000
  6.65930705440122117089174480497604236006736755371094e-01, // 1.000000
  6.92200627555346392760782237019157037138938903808594e-01, // 1.100000
  7.16862603474862081220919662882806733250617980957031e-01, // 1.200000
  7.39934054783606187655209396325517445802688598632812e-01, // 1.300000
  7.61449220009415284060594331094762310385704040527344e-01, // 1.400000
  7.81455584849563456018017859605606645345687866210938e-01, // 1.500000
  8.00010713004353557487036141537828370928764343261719e-01, // 1.600000
  8.17179486939028754122205100429710000753402709960938e-01, // 1.700000
  8.33031748536220639778093755012378096580505371093750e-01, // 1.800000
  8.47640316515773317718185353442095220088958740234375e-01, // 1.900000
  8.61079349396833837460007998743094503879547119140625e-01, // 2.000000
  9.29667709628290483969692559185205027461051940917969e-01, // 2.718282
  9.53363743354765147408613756851991638541221618652344e-01, // 3.141593
  };

  public static final double[] SCIPY_GUMBEL_PDF_01_1 = { //
  3.65982076509606846226319021297967992722988128662109e-01, // 0.000000
  3.65982461392446445369586172091658227145671844482422e-01, // 0.000010
  3.67879441171442334024277442949824035167694091796875e-01, // 0.100000
  3.67779034862618203760575852356851100921630859375000e-01, // 0.123457
  3.66104151897740148768889412167482078075408935546875e-01, // 0.200000
  3.62782413998306907387814135290682315826416015625000e-01, // 0.271828
  3.61052914770930044596752850338816642761230468750000e-01, // 0.300000
  3.60097994370001339703435405681375414133071899414062e-01, // 0.314159
  3.53165596312007168400270984420785680413246154785156e-01, // 0.400000
  3.42898756467731824493228032224578782916069030761719e-01, // 0.500000
  3.30704298890418080247854959452524781227111816406250e-01, // 0.600000
  3.17013272754289754384871002912404946982860565185547e-01, // 0.700000
  3.02224456630968474346587981926859356462955474853516e-01, // 0.800000
  2.86697116378903826827695411338936537504196166992188e-01, // 0.900000
  2.70747220321607584558876169467112049460411071777344e-01, // 1.000000
  2.54646380043582531982337968656793236732482910156250e-01, // 1.100000
  2.38622831681304076179017670256143901497125625610352e-01, // 1.200000
  2.22863854497548474764556658556102775037288665771484e-01, // 1.300000
  2.07519121233516318225653662921104114502668380737305e-01, // 1.400000
  1.92704574679114809532265439884213265031576156616211e-01, // 1.500000
  1.78506518513120937541316379792988300323486328125000e-01, // 1.600000
  1.64985692989648907724742343816615175455808639526367e-01, // 1.700000
  1.52181175470408269756461550059611909091472625732422e-01, // 1.800000
  1.40114001931851056559352741714974399656057357788086e-01, // 1.900000
  1.28790449330409367822980470918992068618535995483398e-01, // 2.000000
  6.77988607946176241592084465992229524999856948852539e-02, // 2.718282
  4.55314756659847622022319058032735483720898628234863e-02, // 3.141593
  };

  public static final double[] P_QUANT = { //
  0.0001, 0.001, 0.01, 0.1, 0.25, 0.5, 0.75, 0.9, 0.99, 0.999, 0.9999 //
  };

  public static final double[] SCIPY_GUMBEL_QUANT_1_1 = { //
  -1.22032680636784629513158506597392261028289794921875e+00, // 0.000100
  -9.32644733916065504786274686921387910842895507812500e-01, // 0.001000
  -5.27179625807901119927123545494396239519119262695312e-01, // 0.010000
  1.65967554752044277321942900016438215970993041992188e-01, // 0.100000
  6.73365740021719005881095654331147670745849609375000e-01, // 0.250000
  1.36651292058166440313016209984198212623596191406250e+00, // 0.500000
  2.24589932370723843746418424416333436965942382812500e+00, // 0.750000
  3.25036732731244537575321373878978192806243896484375e+00, // 0.900000
  5.60014922677657889238389543606899678707122802734375e+00, // 0.990000
  7.90725507052371590077655127970501780509948730468750e+00, // 0.999000
  1.02102903698928351161612226860597729682922363281250e+01, // 0.999900
  };

  public static final double[] SCIPY_GUMBEL_QUANT_2_1 = { //
  -2.20326806367846295131585065973922610282897949218750e-01, // 0.000100
  6.73552660839344952137253130786120891571044921875000e-02, // 0.001000
  4.72820374192098880072876454505603760480880737304688e-01, // 0.010000
  1.16596755475204427732194290001643821597099304199219e+00, // 0.100000
  1.67336574002171900588109565433114767074584960937500e+00, // 0.250000
  2.36651292058166440313016209984198212623596191406250e+00, // 0.500000
  3.24589932370723843746418424416333436965942382812500e+00, // 0.750000
  4.25036732731244537575321373878978192806243896484375e+00, // 0.900000
  6.60014922677657889238389543606899678707122802734375e+00, // 0.990000
  8.90725507052371590077655127970501780509948730468750e+00, // 0.999000
  1.12102903698928351161612226860597729682922363281250e+01, // 0.999900
  };

  public static final double[] SCIPY_GUMBEL_QUANT_4_1 = { //
  1.77967319363215370486841493402607738971710205078125e+00, // 0.000100
  2.06735526608393449521372531307861208915710449218750e+00, // 0.001000
  2.47282037419209910211748137953691184520721435546875e+00, // 0.010000
  3.16596755475204449936654782504774630069732666015625e+00, // 0.100000
  3.67336574002171900588109565433114767074584960937500e+00, // 0.250000
  4.36651292058166440313016209984198212623596191406250e+00, // 0.500000
  5.24589932370723843746418424416333436965942382812500e+00, // 0.750000
  6.25036732731244537575321373878978192806243896484375e+00, // 0.900000
  8.60014922677657978056231513619422912597656250000000e+00, // 0.990000
  1.09072550705237159007765512797050178050994873046875e+01, // 0.999000
  1.32102903698928351161612226860597729682922363281250e+01, // 0.999900
  };

  public static final double[] SCIPY_GUMBEL_QUANT_4_10 = { //
  -1.82032680636784647276726900599896907806396484375000e+01, // 0.000100
  -1.53264473391606550478627468692138791084289550781250e+01, // 0.001000
  -1.12717962580790107551820256048813462257385253906250e+01, // 0.010000
  -4.34032445247955678269136114977300167083740234375000e+00, // 0.100000
  7.33657400217190502900166393374092876911163330078125e-01, // 0.250000
  7.66512920581664403130162099841982126235961914062500e+00, // 0.500000
  1.64589932370723843746418424416333436965942382812500e+01, // 0.750000
  2.65036732731244555338889767881482839584350585937500e+01, // 0.900000
  5.00014922677657907001957937609404325485229492187500e+01, // 0.990000
  7.30725507052371625604791915975511074066162109375000e+01, // 0.999000
  9.61029036989283440561848692595958709716796875000000e+01, // 0.999900
  };

  public static final double[] SCIPY_GUMBEL_QUANT_01_10 = { //
  -2.21032680636784633065872185397893190383911132812500e+01, // 0.000100
  -1.92264473391606536267772753490135073661804199218750e+01, // 0.001000
  -1.51717962580790111104533934849314391613006591796875e+01, // 0.010000
  -8.24032445247955713796272902982309460639953613281250e+00, // 0.100000
  -3.16634259978280940828199163661338388919830322265625e+00, // 0.250000
  3.76512920581664367603025311836972832679748535156250e+00, // 0.500000
  1.25589932370723822430136351613327860832214355468750e+01, // 0.750000
  2.26036732731244569549744483083486557006835937500000e+01, // 0.900000
  4.61014922677657921212812652811408042907714843750000e+01, // 0.990000
  6.91725507052371568761373055167496204376220703125000e+01, // 0.999000
  9.22029036989283383718429831787943840026855468750000e+01, // 0.999900
  };

  public static final double[] SCIPY_GUMBEL_QUANT_01_20 = { //
  -4.43065361273569280342599085997790098190307617187500e+01, // 0.000100
  -3.85528946783213086746400222182273864746093750000000e+01, // 0.001000
  -3.04435925161580200892785796895623207092285156250000e+01, // 0.010000
  -1.65806489049591121442972507793456315994262695312500e+01, // 0.100000
  -6.43268519956561934947103509330190718173980712890625e+00, // 0.250000
  7.43025841163328681915345441666431725025177001953125e+00, // 0.500000
  2.50179864741447666176554776029661297798156738281250e+01, // 0.750000
  4.51073465462489124888634250964969396591186523437500e+01, // 0.900000
  9.21029845355315757160497014410793781280517578125000e+01, // 0.990000
  1.38245101410474319436616497114300727844238281250000e+02, // 0.999000
  1.84305807397856682428027852438390254974365234375000e+02, // 0.999900
  };

  public static final double[] SCIPY_GUMBEL_QUANT_01_4 = { //
  -8.78130722547138553579770814394578337669372558593750e+00, // 0.000100
  -7.63057893566426237441646662773564457893371582031250e+00, // 0.001000
  -6.00871850323160483497986206202767789363861083984375e+00, // 0.010000
  -3.23612978099182280189438642992172390222549438476562e+00, // 0.100000
  -1.20653703991312366561317048763157799839973449707031e+00, // 0.250000
  1.56605168232665747929388544434914365410804748535156e+00, // 0.500000
  5.08359729482895250640694939647801220417022705078125e+00, // 0.750000
  9.10146930924978114774148707510903477668762207031250e+00, // 0.900000
  1.85005969071063169906210532644763588905334472656250e+01, // 0.990000
  2.77290202820948650241916766390204429626464843750000e+01, // 0.999000
  3.69411614795713418857303622644394636154174804687500e+01, // 0.999900
  };

  public static final double[] SCIPY_GUMBEL_QUANT_01_1 = { //
  -2.12032680636784620631374309596139937639236450195312e+00, // 0.000100
  -1.83264473391606541596843271690886467695236206054688e+00, // 0.001000
  -1.42717962580790103110928157548187300562858581542969e+00, // 0.010000
  -7.34032445247955744882517592486692592501640319824219e-01, // 0.100000
  -2.26634259978280933056637991285242605954408645629883e-01, // 0.250000
  4.66512920581664380925701607338851317763328552246094e-01, // 0.500000
  1.34589932370723830423742128914454951882362365722656e+00, // 0.750000
  2.35036732731244546457105570880230516195297241210938e+00, // 0.900000
  4.70014922677657853711252755601890385150909423828125e+00, // 0.990000
  7.00725507052371554550518339965492486953735351562500e+00, // 0.999000
  9.31029036989283476088985480600968003273010253906250e+00, // 0.999900
  };

  @Test
  public void testPDF() {
    checkPDF(new GumbelDistribution(1., 1.), P_CDFPDF, SCIPY_GUMBEL_PDF_1_1, 1e-12);
    checkPDF(new GumbelDistribution(2., 1.), P_CDFPDF, SCIPY_GUMBEL_PDF_2_1, 1e-12);
    checkPDF(new GumbelDistribution(4., 1.), P_CDFPDF, SCIPY_GUMBEL_PDF_4_1, 1e-11);
    checkPDF(new GumbelDistribution(4., 10.), P_CDFPDF, SCIPY_GUMBEL_PDF_4_10, 1e-13);
    checkPDF(new GumbelDistribution(.1, 1.), P_CDFPDF, SCIPY_GUMBEL_PDF_01_1, 1e-12);
    checkPDF(new GumbelDistribution(.1, 4.), P_CDFPDF, SCIPY_GUMBEL_PDF_01_4, 1e-12);
    checkPDF(new GumbelDistribution(.1, 10.), P_CDFPDF, SCIPY_GUMBEL_PDF_01_10, 1e-13);
    checkPDF(new GumbelDistribution(.1, 20.), P_CDFPDF, SCIPY_GUMBEL_PDF_01_20, 1e-14);
  }

  @Test
  public void testCDF() {
    checkCDF(new GumbelDistribution(1., 1.), P_CDFPDF, SCIPY_GUMBEL_CDF_1_1, 1e-12);
    checkCDF(new GumbelDistribution(2., 1.), P_CDFPDF, SCIPY_GUMBEL_CDF_2_1, 1e-12);
    checkCDF(new GumbelDistribution(4., 1.), P_CDFPDF, SCIPY_GUMBEL_CDF_4_1, 1e-11);
    checkCDF(new GumbelDistribution(4., 10.), P_CDFPDF, SCIPY_GUMBEL_CDF_4_10, 1e-12);
    checkCDF(new GumbelDistribution(.1, 1.), P_CDFPDF, SCIPY_GUMBEL_CDF_01_1, 1e-13);
    checkCDF(new GumbelDistribution(.1, 4.), P_CDFPDF, SCIPY_GUMBEL_CDF_01_4, 1e-13);
    checkCDF(new GumbelDistribution(.1, 10.), P_CDFPDF, SCIPY_GUMBEL_CDF_01_10, 1e-13);
    checkCDF(new GumbelDistribution(.1, 20.), P_CDFPDF, SCIPY_GUMBEL_CDF_01_20, 1e-13);
  }

  @Test
  public void testQuantile() {
    checkQuantile(new GumbelDistribution(1., 1.), P_QUANT, SCIPY_GUMBEL_QUANT_1_1, 1e-13);
    checkQuantile(new GumbelDistribution(2., 1.), P_QUANT, SCIPY_GUMBEL_QUANT_2_1, 1e-13);
    checkQuantile(new GumbelDistribution(4., 1.), P_QUANT, SCIPY_GUMBEL_QUANT_4_1, 1e-13);
    checkQuantile(new GumbelDistribution(4., 10.), P_QUANT, SCIPY_GUMBEL_QUANT_4_10, 1e-13);
    checkQuantile(new GumbelDistribution(.1, 1.), P_QUANT, SCIPY_GUMBEL_QUANT_01_1, 1e-13);
    checkQuantile(new GumbelDistribution(.1, 4.), P_QUANT, SCIPY_GUMBEL_QUANT_01_4, 1e-13);
    checkQuantile(new GumbelDistribution(.1, 10.), P_QUANT, SCIPY_GUMBEL_QUANT_01_10, 1e-13);
    checkQuantile(new GumbelDistribution(.1, 20.), P_QUANT, SCIPY_GUMBEL_QUANT_01_20, 1e-13);
  }
}
