/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

   ----------------------------------------------------------------------


   
*/
/****************************************************************************
 *    IMPLEMENTATION HEADERS
 ****************************************************************************/

#include "ecurses.h"
#include "mail.h"
#include "mailinfo.h"
#include "line.h"
#include "gettext.h"
#include "sender.h"
#include "ask.h"
#include "interface.h"
#include "color.h"

/****************************************************************************
 *    IMPLEMENTATION PRIVATE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION REQUIRED EXTERNAL REFERENCES (AVOID)
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE DATA
 ****************************************************************************/

static WINDOW *win = NULL;

static line_t *line = NULL;

/****************************************************************************
 *    INTERFACE DATA
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTION PROTOTYPES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTIONS
 ****************************************************************************/

static void
display (mail_t *mail)
{
        int   i;
        char *server;

        line_put_str (line, _("       From: "));
        if (mail->from && mail->from->full)
                line_add_str_dots (line, mail->from->full);
        window_mvaddstr (win, 0, 0, line->str);
  
        line_put_str (line, _("    Subject: "));
        if (mail->subject)
                line_add_str_dots (line, mail->subject);
        window_mvaddstr (win, 1, 0, line->str);

        line_put_str (line, _("         To: "));
        if (mail->to && mail->to->count){
                line_add_str_dots (line, mail->to->array[0]->full);
                for (i = 1; i < mail->to->count; i++){
                        line_add_str_dots (line, ", ");
                        line_add_str_dots (line, mail->to->array[i]->full);
                }
        }
        window_mvaddstr (win, 2, 0, line->str);

        line_put_str (line, _("         Cc: "));
        if (mail->cc && mail->cc->count){
                line_add_str_dots (line, mail->cc->array[0]->full);
                for (i = 1; i < mail->cc->count; i++){
                        line_add_str_dots (line, ", ");
                        line_add_str_dots (line, mail->cc->array[i]->full);
                }
        }
        window_mvaddstr (win, 3, 0, line->str);
  
        line_put_str (line, _("        Bcc: "));
        if (mail->bcc && mail->bcc->count){
                line_add_str_dots (line, mail->bcc->array[0]->full);
                for (i = 1; i < mail->bcc->count; i++){
                        line_add_str_dots (line, ", ");
                        line_add_str_dots (line, mail->bcc->array[i]->full);
                }
        }
        window_mvaddstr (win, 4, 0, line->str);
  
        line_put_str (line, _("   Reply-To: "));
        if (mail->reply_to && mail->reply_to != mail->from && mail->reply_to->full)
                line_add_str_dots (line, mail->reply_to->full);
        window_mvaddstr (win, 5, 0, line->str);

        line_put_str (line, _("Sending via: "));
        server = ask_get_field (sender_ask, "server");
        if (server)
                line_add_str (line, server);
        window_mvaddstr (win, 6, 0, line->str);

        touchwin (win);
        wnoutrefresh (win);
}

/****************************************************************************
 *    INTERFACE FUNCTIONS
 ****************************************************************************/

void
mailinfo_init (WINDOW *parent, chtype color)
{
        int width, height, top, left;

        getmaxyx (parent, height, width);
        getbegyx (parent, top, left);

        if (top < 10)
                return;

        win  = newwin (8, width, top - 9, left);
        line = line_create (width + 1);

        wattrset (win, color);
}


void
mailinfo_free_resources (void)
{
        if (win)
                delwin (win);
        win = NULL;

        if (line)
                line_destroy (line);
        line = NULL;
}    


void
mailinfo_refresh (void)
{
        touchwin (win);
        wnoutrefresh (win);
}


void
mailinfo_show (mail_t *mail)
{
        if (win == NULL)
                return;
        
        display (mail);
}


/****************************************************************************
 *    INTERFACE CLASS BODIES
 ****************************************************************************/
/****************************************************************************
 *
 *    END MODULE mailinfo.c
 *
 ****************************************************************************/
