;;; idlw-rinfo.el --- Routine Information for IDLWAVE
;; Copyright (c) 1999 Carsten Dominik
;; Copyright (c) 1999, 2000, 2001, 2002, 2003, 2004, 2005
;; Free Software Foundation

;; Author: J.D. Smith <jdsmith@as.arizona.edu>
;; Version: 5.7_22
;; Keywords: languages

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Commentary:

;; The constants which contain information about IDLs builtin
;; functions, procedures, system variables and class tags.  This
;; information is extracted automatically from the IDL documentation
;; and by talking to IDL.
;;
;; Created by get_html_rinfo on Wed May 11 14:52:40 2005
;; IDL version: 6.1
;; Number of files scanned:  3393
;; Number of routines found: 1850
;; Number of keywords found: 7685
;;
;; New versions of IDLWAVE, documentation, and more information
;; available from:
;;                 http://idlwave.org
;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Code:
(defconst idlwave-system-routines
  '(
    ("ANNOTATE" pro nil (system) "%s" ("A9.html" ("COLOR_INDICES" . 756628) ("DRAWABLE" . 756633) ("LOAD_FILE" . 756636) ("TEK_COLORS" . 756639) ("WINDOW" . 756642)))
    ("ARROW" pro nil (system) "%s, X0, Y0, X1, Y1" ("A15.html" ("COLOR" . 756673) ("DATA" . 756664) ("HSIZE" . 756670) ("HTHICK" . 756676) ("NORMALIZED" . 756667) ("SOLID" . 756679) ("THICK" . 756682)))
    ("AXIS" pro nil (system) "%s [, X [, Y [, Z]]]" ("A20.html" ("SAVE" . 986499) ("XAXIS" . 983775) ("XLOG" . 983760) ("YAXIS" . 983765) ("YLOG" . 983752) ("YNOZERO" . 158293) ("ZAXIS" . 983724)) ("graphkeyw2.html" ("CHARSIZE" . 266973) ("CHARTHICK" . 331668) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("FONT" . 331795) ("NODATA" . 316018) ("NOERASE" . 316024) ("NORMAL" . 315963) ("SUBTITLE" . 316057) ("T3D" . 315956) ("TICKLEN" . 332207) ("XCHARSIZE" . 331699) ("XGRIDSTYLE" . 332009) ("XMARGIN" . 332038) ("XMINOR" . 332061) ("XRANGE" . 332090) ("XSTYLE" . 332116) ("XTHICK" . 332298) ("XTICK_GET" . 332321) ("XTICKFORMAT" . 332347) ("XTICKINTERVAL" . 332463) ("XTICKLAYOUT" . 332488) ("XTICKLEN" . 332513) ("XTICKNAME" . 332536) ("XTICKS" . 332559) ("XTICKUNITS" . 332586) ("XTICKV" . 332628) ("XTITLE" . 316100) ("YCHARSIZE" . 331699) ("YGRIDSTYLE" . 332009) ("YMARGIN" . 332038) ("YMINOR" . 332061) ("YRANGE" . 332090) ("YSTYLE" . 332116) ("YTHICK" . 332298) ("YTICK_GET" . 332321) ("YTICKFORMAT" . 332347) ("YTICKINTERVAL" . 332463) ("YTICKLAYOUT" . 332488) ("YTICKLEN" . 332513) ("YTICKNAME" . 332536) ("YTICKS" . 332559) ("YTICKUNITS" . 332586) ("YTICKV" . 332628) ("YTITLE" . 316100) ("ZCHARSIZE" . 331699) ("ZGRIDSTYLE" . 332009) ("ZMARGIN" . 332038) ("ZMINOR" . 332061) ("ZRANGE" . 332090) ("ZSTYLE" . 332116) ("ZTHICK" . 332298) ("ZTICK_GET" . 332321) ("ZTICKFORMAT" . 332347) ("ZTICKINTERVAL" . 332463) ("ZTICKLAYOUT" . 332488) ("ZTICKLEN" . 332513) ("ZTICKNAME" . 332536) ("ZTICKS" . 332559) ("ZTICKUNITS" . 332586) ("ZTICKV" . 332628) ("ZTITLE" . 316100) ("ZVALUE" . 316102)))
    ("BAR_PLOT" pro nil (system) "%s, Values" ("B.html" ("BACKGROUND" . 756719) ("BARNAMES" . 756722) ("BAROFFSET" . 756725) ("BARSPACE" . 756728) ("BARWIDTH" . 756731) ("BASELINES" . 756734) ("BASERANGE" . 756737) ("COLORS" . 756740) ("OUTLINE" . 756743) ("OVERPLOT" . 756746) ("ROTATE" . 756749) ("TITLE" . 756752) ("XTITLE" . 756755) ("YTITLE" . 756758)))
    ("BLAS_AXPY" pro nil (system) "%s, Y, A, X [, D1, Loc1 [, D2, Range]]" ("B13.html"))
    ("BOX_CURSOR" pro nil (system) "%s, [ X0, Y0, NX, NY]" ("B15.html" ("FIXED_SIZE" . 756816) ("INIT" . 756813) ("MESSAGE" . 756819)))
    ("BREAK" pro nil (system) "%s" ("B16.html"))
    ("BREAKPOINT" pro nil (system) "%s [, File], Index" ("B17.html" ("AFTER" . 113854) ("CLEAR" . 675862) ("CONDITION" . 113859) ("DISABLE" . 907385) ("ENABLE" . 984755) ("ON_RECOMPILE" . 984772) ("ONCE" . 990987) ("SET" . 675866)))
    ("BYTEORDER" pro nil (system) "%s, Variable1, ..., Variablen" ("B21.html" ("DTOVAX" . 906658) ("DTOXDR" . 906876) ("FTOVAX" . 675911) ("FTOXDR" . 906884) ("HTONL" . 906665) ("HTONS" . 675913) ("L64SWAP" . 965960) ("LSWAP" . 675915) ("NTOHL" . 675917) ("NTOHS" . 675919) ("SSWAP" . 675921) ("SWAP_IF_BIG_ENDIAN" . 906711) ("SWAP_IF_LITTLE_ENDIAN" . 906720) ("VAXTOD" . 675923) ("VAXTOF" . 906693) ("XDRTOD" . 906679) ("XDRTOF" . 675925)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("CALDAT" pro nil (system) "%s, Julian, Month [, Day [, Year [, Hour [, Minute [, Second]]]]]" ("C2.html"))
    ("CALENDAR" pro nil (system) "%s [[, Month] , Year]" ("C3.html"))
    ("CALL_METHOD" pro nil (system) "%s, Name, ObjRef, [, P1, ..., Pn]" ("C6.html"))
    ("CALL_PROCEDURE" pro nil (system) "%s, Name [, P1, ..., Pn]" ("C7.html"))
    ("CATCH" pro nil (system) "%s, [Variable]" ("C9.html" ("CANCEL" . 716974)))
    ("CD" pro nil (system) "%s [, Directory]" ("C10.html" ("CURRENT" . 676059)))
    ("CDF_ATTDELETE" pro nil (system) "%s, Id, Attribute [, EntryNum]" ("CDF-routines9.html" ("ZVARIABLE" . 1002456)))
    ("CDF_ATTGET" pro nil (system) "%s, Id, Attribute, EntryNum, Value" ("CDF-routines11.html" ("CDF_TYPE" . 1003937) ("ZVARIABLE" . 997078)))
    ("CDF_ATTINQ" pro nil (system) "%s, Id, Attribute, Name, Scope, MaxEntry [, MaxZEntry]" ("CDF-routines12.html"))
    ("CDF_ATTPUT" pro nil (system) "%s, Id, Attribute, EntryNum, Value" ("CDF-routines14.html" ("ZVARIABLE" . 997143)))
    ("CDF_ATTRENAME" pro nil (system) "%s, Id, OldAttr, NewName" ("CDF-routines15.html"))
    ("CDF_CLOSE" pro nil (system) "%s, Id" ("CDF-routines16.html"))
    ("CDF_COMPRESSION" pro nil (system) "%s, Id" ("CDF-routines17.html" ("GET_COMPRESSION" . 1019949) ("GET_GZIP_LEVEL" . 1019952) ("GET_VAR_COMPRESSION" . 1019955) ("GET_VAR_GZIP_LEVEL" . 1019957) ("SET_COMPRESSION" . 1019965) ("SET_GZIP_LEVEL" . 1020981) ("SET_VAR_COMPRESSION" . 1019968) ("SET_VAR_GZIP_LEVEL" . 1026491) ("VARIABLE" . 1026493) ("ZVARIABLE" . 1019982)))
    ("CDF_CONTROL" pro nil (system) "%s, Id" ("CDF-routines18.html" ("ATTRIBUTE" . 997198) ("GET_ATTR_INFO" . 997201) ("GET_CACHESIZE" . 997209) ("GET_COPYRIGHT" . 997212) ("GET_FILENAME" . 997215) ("GET_FORMAT" . 997218) ("GET_NEGTOPOSFP0_MODE" . 997226) ("GET_NUMATTRS" . 997229) ("GET_READONLY_MODE" . 1047427) ("GET_RVAR_CACHESIZE" . 997236) ("GET_VAR_INFO" . 997242) ("GET_ZMODE" . 997259) ("GET_ZVAR_CACHESIZE" . 997266) ("SET_CACHESIZE" . 997269) ("SET_EXTENDRECS" . 997272) ("SET_INITIALRECS" . 997275) ("SET_NEGTOPOSFP0_MODE" . 997278) ("SET_PADVALUE" . 997281) ("SET_READONLY_MODE" . 997284) ("SET_RVAR_CACHESIZE" . 997287) ("SET_RVARS_CACHESIZE" . 997290) ("SET_ZMODE" . 997293) ("SET_ZVAR_CACHESIZE" . 997296) ("SET_ZVARS_CACHESIZE" . 997298) ("VARIABLE" . 997301) ("ZVARIABLE" . 997307)))
    ("CDF_DELETE" pro nil (system) "%s, Id" ("CDF-routines20.html"))
    ("CDF_DOC" pro nil (system) "%s, Id, Version, Release, Copyright" ("CDF-routines21.html" ("INCREMENT" . 997427)))
    ("CDF_EPOCH" pro nil (system) "%s, Epoch, Year [, Month, Day, Hour, Minute, Second, Milli]" ("CDF-routines23.html" ("BREAKDOWN_EPOCH" . 997509) ("COMPUTE_EPOCH" . 997512)))
    ("CDF_LIB_INFO" pro nil (system) "%s" ("CDF-routines27.html" ("COPYRIGHT" . 997623) ("INCREMENT" . 997626) ("RELEASE" . 997629) ("SUBINCREMENT" . 997632) ("VERSION" . 997635)))
    ("CDF_VARDELETE" pro nil (system) "%s, Id, Variable" ("CDF-routines31.html" ("ZVARIABLE" . 997776)))
    ("CDF_VARGET" pro nil (system) "%s, Id, Variable, Value" ("CDF-routines32.html" ("COUNT" . 997847) ("INTERVAL" . 997850) ("OFFSET" . 997853) ("REC_COUNT" . 997856) ("REC_INTERVAL" . 997859) ("REC_START" . 997862) ("STRING" . 997865) ("ZVARIABLE" . 997868)))
    ("CDF_VARGET1" pro nil (system) "%s, Id, Variable, Value" ("CDF-routines33.html" ("OFFSET" . 997909) ("REC_START" . 997912) ("STRING" . 997915) ("ZVARIABLE" . 997918)))
    ("CDF_VARPUT" pro nil (system) "%s, Id, Variable, Value" ("CDF-routines36.html" ("COUNT" . 998005) ("INTERVAL" . 998008) ("OFFSET" . 998011) ("REC_INTERVAL" . 998014) ("REC_START" . 998017) ("ZVARIABLE" . 998020)))
    ("CDF_VARRENAME" pro nil (system) "%s, Id, OldVariable, NewName" ("CDF-routines37.html" ("ZVARIABLE" . 998048)))
    ("CHOLDC" pro nil (system) "%s, A, P" ("C17.html" ("DOUBLE" . 1108599)))
    ("CIR_3PNT" pro nil (system) "%s, X, Y, R, X0, Y0" ("C20.html"))
    ("CLOSE" pro nil (system) "%s[, Unit1, ..., Unitn]" ("C21.html" ("ALL" . 676122) ("EXIT_STATUS" . 1017312) ("FILE" . 1017618) ("FORCE" . 1017321)))
    ("COLOR_CONVERT" pro nil (system) "%s, I0, I1, I2, O0, O1, O2" ("C25.html" ("HLS_RGB" . 861671) ("HSV_RGB" . 861673) ("RGB_HLS" . 861669) ("RGB_HSV" . 676146)))
    ("CONSTRAINED_MIN" pro nil (system) "%s, X, Xbnd, Gbnd, Nobj, Gcomp, Inform" ("C38.html" ("EPSTOP" . 908210) ("LIMSER" . 927415) ("MAXIMIZE" . 927406) ("NSTOP" . 975889) ("REPORT" . 942066) ("TITLE" . 927408)))
    ("CONTOUR" pro nil (system) "%s, Z [, X, Y]" ("C40.html" ("C_ANNOTATION" . 1023103) ("C_CHARSIZE" . 676279) ("C_CHARTHICK" . 905138) ("C_COLORS" . 676281) ("C_LABELS" . 676286) ("C_LINESTYLE" . 676292) ("C_ORIENTATION" . 676298) ("C_SPACING" . 676300) ("C_THICK" . 676302) ("CELL_FILL" . 892176) ("CLOSED" . 676304) ("DOWNHILL" . 676306) ("FILL" . 676308) ("FOLLOW" . 676311) ("IRREGULAR" . 879096) ("ISOTROPIC" . 676316) ("LEVELS" . 927695) ("MAX_VALUE" . 676323) ("MIN_VALUE" . 47033) ("NLEVELS" . 676325) ("OVERPLOT" . 861732) ("PATH_DATA_COORDS" . 879089) ("PATH_DOUBLE" . 1015046) ("PATH_FILENAME" . 676329) ("PATH_INFO" . 746342) ("PATH_XY" . 746343) ("TRIANGULATION" . 746344) ("XLOG" . 158329) ("YLOG" . 158344) ("ZAXIS" . 676344)))
    ("COPY_LUN" pro nil (system) "%s, FromUnit, ToUnit [, Num]" ("C44.html" ("EOF" . 1090923) ("LINES" . 1090926) ("TRANSFER_COUNT" . 1090928)))
    ("CPU" pro nil (system) "%s" ("C48.html" ("RESET" . 1178606) ("RESTORE" . 1178609) ("TPOOL_MAX_ELTS" . 1032362) ("TPOOL_MIN_ELTS" . 1032364) ("TPOOL_NTHREADS" . 1032366) ("VECTOR_ENABLE" . 1032368)))
    ("CREATE_VIEW" pro nil (system) "%s" ("C52.html" ("AX" . 756876) ("AY" . 756879) ("AZ" . 756882) ("PERSP" . 756885) ("RADIANS" . 756888) ("WINX" . 756891) ("WINY" . 756894) ("XMAX" . 756897) ("XMIN" . 756900) ("YMAX" . 756903) ("YMIN" . 756906) ("ZFAC" . 756909) ("ZMAX" . 756912) ("ZMIN" . 756915) ("ZOOM" . 756918)))
    ("CURSOR" pro nil (system) "%s, X, Y [, Wait]" ("C57.html" ("CHANGE" . 676458) ("DATA" . 676460) ("DEVICE" . 676464) ("DOWN" . 676462) ("NORMAL" . 676466) ("NOWAIT" . 676468) ("UP" . 676470) ("WAIT" . 676472)))
    ("CW_ANIMATE_GETP" pro nil (system) "%s, Widget, Pixmaps" ("C62.html" ("KILL_ANYWAY" . 853956)))
    ("CW_ANIMATE_LOAD" pro nil (system) "%s, Widget" ("C63.html" ("CYCLE" . 853989) ("FRAME" . 853992) ("IMAGE" . 853995) ("ORDER" . 853998) ("WINDOW" . 854001) ("XOFFSET" . 854006) ("YOFFSET" . 854009)))
    ("CW_ANIMATE_RUN" pro nil (system) "%s, Widget [, Rate]" ("C64.html" ("NFRAMES" . 854045) ("STOP" . 854048)))
    ("CW_LIGHT_EDITOR_GET" pro nil (system) "%s, WidgetID" ("C75.html" ("DIRECTION_DISABLED" . 1001479) ("DRAG_EVENTS" . 1001481) ("HIDE_DISABLED" . 1001485) ("LIGHT" . 1001487) ("LOCATION_DISABLED" . 1001489) ("TYPE_DISABLED" . 1001491) ("XRANGE" . 1001493) ("XSIZE" . 1001495) ("YRANGE" . 1001497) ("YSIZE" . 1001499) ("ZRANGE" . 1001501)))
    ("CW_LIGHT_EDITOR_SET" pro nil (system) "%s, WidgetID" ("C76.html" ("DIRECTION_DISABLED" . 1001515) ("DRAG_EVENTS" . 1001517) ("HIDE_DISABLED" . 1001521) ("LIGHT" . 1001523) ("LOCATION_DISABLED" . 1001525) ("TYPE_DISABLED" . 1001527) ("XRANGE" . 1001529) ("XSIZE" . 1001531) ("YRANGE" . 1001533) ("YSIZE" . 1001535) ("ZRANGE" . 1001537)))
    ("CW_PALETTE_EDITOR_GET" pro nil (system) "%s, WidgetID" ("C79.html" ("ALPHA" . 1001551) ("HISTOGRAM" . 1001677)))
    ("CW_PALETTE_EDITOR_SET" pro nil (system) "%s, WidgetID" ("C80.html" ("ALPHA" . 1001567) ("HISTOGRAM" . 1001569)))
    ("DEFINE_KEY" pro nil (system) "%s, Key [, Value]" ("D5.html" ("BACK_CHARACTER" . 1001954) ("BACK_WORD" . 1001956) ("CONTROL" . 1001958) ("DELETE_CHARACTER" . 1001962) ("DELETE_CURRENT" . 1001964) ("DELETE_EOL" . 1001966) ("DELETE_LINE" . 1001968) ("DELETE_WORD" . 1001970) ("END_OF_FILE" . 1001974) ("END_OF_LINE" . 1001972) ("ENTER_LINE" . 1001976) ("ESCAPE" . 1001978) ("FORWARD_CHARACTER" . 1001984) ("FORWARD_WORD" . 1001986) ("INSERT_OVERSTRIKE_TOGGLE" . 1001988) ("MATCH_PREVIOUS" . 676503) ("NEXT_LINE" . 1002066) ("NOECHO" . 676505) ("PREVIOUS_LINE" . 1002076) ("RECALL" . 1002078) ("REDRAW" . 1002103) ("START_OF_LINE" . 1002105) ("TERMINATE" . 676507)))
    ("DEFINE_MSGBLK" pro nil (system) "%s, BlockName, ErrorNames, ErrorFormats" ("D6.html" ("IGNORE_DUPLICATE" . 991846) ("PREFIX" . 991848)))
    ("DEFINE_MSGBLK_FROM_FILE" pro nil (system) "%s, Filename" ("D7.html" ("BLOCK" . 991885) ("IGNORE_DUPLICATE" . 991890) ("PREFIX" . 991892) ("VERBOSE" . 991894)))
    ("DEFSYSV" pro nil (system) "%s, Name, Value [, Read_Only]" ("D9.html" ("EXISTS" . 676585)))
    ("DELVAR" pro nil (system) "%s, V1, ..., Vn" ("D10.html"))
    ("DENDRO_PLOT" pro nil (system) "%s, Clusters, Linkdistance" ("D11.html" ("LABEL_CHARSIZE" . 1033249) ("LABEL_CHARTHICK" . 1032525) ("LABEL_COLOR" . 1032528) ("LABEL_NAMES" . 1032531) ("LABEL_ORIENTATION" . 1032535) ("LINECOLOR" . 1032538) ("ORIENTATION" . 1032541) ("OVERPLOT" . 1032569)) ("graphkeyw2.html" ("BACKGROUND" . 328424) ("CHARSIZE" . 266973) ("CHARTHICK" . 331668) ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("FONT" . 331795) ("LINESTYLE" . 331728) ("NOCLIP" . 323508) ("NODATA" . 316018) ("NOERASE" . 316024) ("NORMAL" . 315963) ("POSITION" . 316026) ("PSYM" . 316038) ("SUBTITLE" . 316057) ("SYMSIZE" . 316061) ("T3D" . 315956) ("THICK" . 316006) ("TICKLEN" . 332207) ("TITLE" . 332238) ("XCHARSIZE" . 331699) ("XGRIDSTYLE" . 332009) ("XMARGIN" . 332038) ("XMINOR" . 332061) ("XRANGE" . 332090) ("XSTYLE" . 332116) ("XTHICK" . 332298) ("XTICK_GET" . 332321) ("XTICKFORMAT" . 332347) ("XTICKINTERVAL" . 332463) ("XTICKLAYOUT" . 332488) ("XTICKLEN" . 332513) ("XTICKNAME" . 332536) ("XTICKS" . 332559) ("XTICKUNITS" . 332586) ("XTICKV" . 332628) ("XTITLE" . 316100) ("YCHARSIZE" . 331699) ("YGRIDSTYLE" . 332009) ("YMARGIN" . 332038) ("YMINOR" . 332061) ("YRANGE" . 332090) ("YSTYLE" . 332116) ("YTHICK" . 332298) ("YTICK_GET" . 332321) ("YTICKFORMAT" . 332347) ("YTICKINTERVAL" . 332463) ("YTICKLAYOUT" . 332488) ("YTICKLEN" . 332513) ("YTICKNAME" . 332536) ("YTICKS" . 332559) ("YTICKUNITS" . 332586) ("YTICKV" . 332628) ("YTITLE" . 316100) ("ZCHARSIZE" . 331699) ("ZGRIDSTYLE" . 332009) ("ZMARGIN" . 332038) ("ZMINOR" . 332061) ("ZRANGE" . 332090) ("ZSTYLE" . 332116) ("ZTHICK" . 332298) ("ZTICK_GET" . 332321) ("ZTICKFORMAT" . 332347) ("ZTICKINTERVAL" . 332463) ("ZTICKLAYOUT" . 332488) ("ZTICKLEN" . 332513) ("ZTICKNAME" . 332536) ("ZTICKS" . 332559) ("ZTICKUNITS" . 332586) ("ZTICKV" . 332628) ("ZTITLE" . 316100) ("ZVALUE" . 316102)))
    ("DENDROGRAM" pro nil (system) "%s, Clusters, Linkdistance, Outverts, Outconn" ("D12.html" ("LEAFNODES" . 1032898)))
    ("DEVICE" pro nil (system) "%s" ("D16.html" ) ("devices4.html" ("AVANTGARDE" . 482989) ("AVERAGE_LINES" . 144491) ("BINARY" . 144309) ("BITS_PER_PIXEL" . 144308) ("BKMAN" . 143940) ("BOLD" . 144497) ("BOOK" . 144499) ("BYPASS_TRANSLATION" . 144256) ("CLOSE" . 144712) ("CLOSE_DOCUMENT" . 451438) ("CLOSE_FILE" . 144158) ("CMYK" . 732196) ("COLOR" . 144479) ("COLORS" . 144313) ("COPY" . 143954) ("COURIER" . 144503) ("CURSOR_CROSSHAIR" . 144502) ("CURSOR_IMAGE" . 143934) ("CURSOR_MASK" . 144824) ("CURSOR_ORIGINAL" . 144828) ("CURSOR_STANDARD" . 144830) ("CURSOR_XY" . 143722) ("DECOMPOSED" . 144834) ("DEMI" . 143930) ("DIRECT_COLOR" . 145006) ("EJECT" . 143752) ("ENCAPSULATED" . 143751) ("ENCODING" . 144315) ("FILENAME" . 143748) ("FLOYD" . 144833) ("FONT_INDEX" . 143943) ("FONT_SIZE" . 144522) ("GET_CURRENT_FONT" . 144518) ("GET_DECOMPOSED" . 554681) ("GET_FONTNAMES" . 554610) ("GET_FONTNUM" . 144326) ("GET_GRAPHICS_FUNCTION" . 145007) ("GET_PAGE_SIZE" . 587045) ("GET_SCREEN_SIZE" . 149759) ("GET_VISUAL_DEPTH" . 452299) ("GET_VISUAL_NAME" . 551382) ("GET_WINDOW_POSITION" . 143947) ("GET_WRITE_MASK" . 143949) ("GIN_CHARS" . 143951) ("GLYPH_CACHE" . 499334) ("HELVETICA" . 144524) ("INCHES" . 144166) ("INDEX_COLOR" . 451483) ("ISOLATIN1" . 144322) ("ITALIC" . 143723) ("LANDSCAPE" . 606950) ("LANGUAGE_LEVEL" . 144167) ("LIGHT" . 618160) ("MEDIUM" . 144529) ("NARROW" . 417784) ("NCAR" . 144157) ("OBLIQUE" . 562813) ("OPTIMIZE" . 144405) ("ORDERED" . 143941) ("OUTPUT" . 144538) ("PALATINO" . 144366) ("PIXELS" . 144468) ("PLOT_TO" . 485584) ("PLOTTER_ON_OFF" . 144371) ("POLYFILL" . 144368) ("PORTRAIT" . 144170) ("PRE_DEPTH" . 144169) ("PRE_XSIZE" . 601831) ("PRE_YSIZE" . 597448) ("PREVIEW" . 601886) ("PRINT_FILE" . 556886) ("PSEUDO_COLOR" . 144688) ("RESET_STRING" . 144455) ("RESOLUTION" . 144473) ("RETAIN" . 144472) ("SCALE_FACTOR" . 144547) ("SCHOOLBOOK" . 144551) ("SET_CHARACTER_SIZE" . 486143) ("SET_COLORMAP" . 161043) ("SET_COLORS" . 486222) ("SET_FONT" . 499045) ("SET_GRAPHICS_FUNCTION" . 499029) ("SET_RESOLUTION" . 144941) ("SET_STRING" . 144466) ("SET_TRANSLATION" . 150093) ("SET_WRITE_MASK" . 143957) ("STATIC_COLOR" . 144842) ("STATIC_GRAY" . 144844) ("SYMBOL" . 144554) ("TEK4014" . 144553) ("TEK4100" . 144475) ("TEXT" . 144841) ("THRESHOLD" . 144376) ("TIMES" . 144557) ("TRANSLATION" . 144556) ("TRUE_COLOR" . 144849) ("TT_FONT" . 542703) ("TTY" . 144477) ("VT240" . 144174) ("VT241" . 144174) ("VT340" . 144532) ("VT341" . 144532) ("WINDOW_STATE" . 144546) ("XOFFSET" . 143719) ("XON_XOFF" . 144379) ("XSIZE" . 144540) ("YOFFSET" . 144175) ("YSIZE" . 144568) ("Z_BUFFERING" . 144512) ("ZAPFCHANCERY" . 144513) ("ZAPFDINGBATS" . 144515)))
    ("DFPMIN" pro nil (system) "%s, X, Gtol, Fmin, Func, Dfunc" ("D17.html" ("DOUBLE" . 50547) ("EPS" . 50550) ("ITER" . 50553) ("ITMAX" . 50556) ("STEPMAX" . 50559) ("TOLX" . 50562)))
    ("DISSOLVE" pro nil (system) "%s, Image" ("D28.html" ("DELAY" . 757174) ("ORDER" . 757177) ("SIZ" . 757180) ("X0" . 757184) ("Y0" . 757184)))
    ("DLM_LOAD" pro nil (system) "%s, DLMNameStr1 [, DLMNameStr2,..., DLMNameStrn]" ("D31.html"))
    ("DLM_REGISTER" pro nil (system) "%s, DLMDefFilePath1 [, DLMDefFilePath2, ..., DLMDefFilePathn]" ("D32.html"))
    ("DOC_LIBRARY" pro nil (system) "%s [, Name]" ("D33.html" ("DIRECTORY" . 1003439) ("MULTI" . 1003447) ("PRINT" . 42998)))
    ("DRAW_ROI" pro nil (system) "%s, oROI" ("D35.html" ("LINE_FILL" . 986287) ("SPACING" . 986289)) ("graphkeyw2.html" ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("LINESTYLE" . 331728) ("NOCLIP" . 323508) ("NORMAL" . 315963) ("ORIENTATION" . 315964) ("PSYM" . 316038) ("SYMSIZE" . 316061) ("T3D" . 315956) ("THICK" . 316006)))
    ("EFONT" pro nil (system) "%s [, Init_Font]" ("E.html" ("BLOCK" . 921048) ("GROUP" . 988298)))
    ("EMPTY" pro nil (system) "%s" ("E5.html"))
    ("ENABLE_SYSRTN" pro nil (system) "%s [, Routines]" ("E6.html" ("DISABLE" . 986251) ("EXCLUSIVE" . 986253) ("FUNCTIONS" . 986256)))
    ("ERASE" pro nil (system) "%s [, Background_Color]" ("E9.html" ("CHANNEL" . 676712) ("COLOR" . 676714)))
    ("ERRPLOT" pro nil (system) "%s, [ X, ] Low, High" ("E14.html" ("WIDTH" . 757212)))
    ("EXIT" pro nil (system) "%s" ("E16.html" ("NO_CONFIRM" . 126978) ("STATUS" . 126983)))
    ("EXPAND" pro nil (system) "%s, A, Nx, Ny, Result" ("E18.html" ("FILLVAL" . 986579) ("MAXVAL" . 757253)))
    ("FILE_CHMOD" pro nil (system) "%s, File [, Mode]" ("F6.html" ("A_EXECUTE" . 882191) ("A_READ" . 882193) ("A_WRITE" . 882195) ("G_EXECUTE" . 882197) ("G_READ" . 882199) ("G_WRITE" . 882201) ("NOEXPAND_PATH" . 882956) ("O_EXECUTE" . 882203) ("O_READ" . 882205) ("O_WRITE" . 882207) ("SETGID" . 900602) ("SETUID" . 900604) ("STICKY_BIT" . 900606) ("U_EXECUTE" . 882209) ("U_READ" . 882211) ("U_WRITE" . 882213)))
    ("FILE_COPY" pro nil (system) "%s, SourcePath, DestPath" ("F7.html" ("ALLOW_SAME" . 906390) ("COPY_NAMED_PIPE" . 906392) ("COPY_SYMLINK" . 906394) ("FORCE" . 906396) ("NOEXPAND_PATH" . 906399) ("OVERWRITE" . 906404) ("RECURSIVE" . 906406) ("REQUIRE_DIRECTORY" . 906412) ("VERBOSE" . 906414)))
    ("FILE_DELETE" pro nil (system) "%s, File1 [,... Filen]" ("F8.html" ("ALLOW_NONEXISTENT" . 882944) ("NOEXPAND_PATH" . 906788) ("QUIET" . 906823) ("RECURSIVE" . 892369) ("VERBOSE" . 906799)))
    ("FILE_LINK" pro nil (system) "%s, SourcePath, DestPath" ("F13.html" ("ALLOW_SAME" . 906533) ("HARDLINK" . 906535) ("NOEXPAND_PATH" . 906537) ("VERBOSE" . 906542)))
    ("FILE_MKDIR" pro nil (system) "%s, File1 [,... FileN]" ("F14.html" ("NOEXPAND_PATH" . 882989)))
    ("FILE_MOVE" pro nil (system) "%s, SourcePath, DestPath" ("F15.html" ("ALLOW_SAME" . 906590) ("NOEXPAND_PATH" . 906592) ("OVERWRITE" . 906597) ("REQUIRE_DIRECTORY" . 906599) ("VERBOSE" . 906601)))
    ("FLICK" pro nil (system) "%s, A, B [, Rate]" ("F25.html"))
    ("FLOW3" pro nil (system) "%s, Vx, Vy, Vz" ("F28.html" ("ARROWSIZE" . 757304) ("BLOB" . 757307) ("LEN" . 757310) ("NSTEPS" . 757313) ("NVECS" . 757316) ("SX" . 757321) ("SY" . 757321) ("SZ" . 757321)))
    ("FLUSH" pro nil (system) "%s, Unit1, ..., Unitn" ("F30.html"))
    ("FREE_LUN" pro nil (system) "%s [, Unit1, ..., Unitn]" ("F34.html" ("EXIT_STATUS" . 875865) ("FORCE" . 875880)))
    ("FUNCT" pro nil (system) "%s, X, A, F [, Pder]" ("F37.html"))
    ("GAMMA_CT" pro nil (system) "%s, Gamma" ("G2.html" ("CURRENT" . 759174) ("INTENSITY" . 759177)))
    ("GET_LUN" pro nil (system) "%s, Unit" ("G10.html"))
    ("GRID_INPUT" pro nil (system) "%s, X, Y, F, X1, Y1, F1" ("G14.html" ("DEGREES" . 877045) ("DUPLICATES" . 877047) ("EPSILON" . 877086) ("EXCLUDE" . 877088) ("POLAR" . 877090) ("SPHERE" . 877092)))
    ("H5_CLOSE" pro nil (system) "%s" ("HDF5-routines10.html"))
    ("H5_OPEN" pro nil (system) "%s" ("HDF5-routines12.html"))
    ("H5A_CLOSE" pro nil (system) "%s, Attribute_id" ("HDF5-routines14.html"))
    ("H5D_CLOSE" pro nil (system) "%s, Dataset_id" ("HDF5-routines22.html"))
    ("H5F_CLOSE" pro nil (system) "%s, File_id" ("HDF5-routines28.html"))
    ("H5G_CLOSE" pro nil (system) "%s, Group_id" ("HDF5-routines31.html"))
    ("H5S_CLOSE" pro nil (system) "%s, Dataspace_id" ("HDF5-routines41.html"))
    ("H5S_OFFSET_SIMPLE" pro nil (system) "%s, Dataspace_id, Offset" ("HDF5-routines55.html"))
    ("H5S_SELECT_ALL" pro nil (system) "%s, Dataspace_id" ("HDF5-routines56.html"))
    ("H5S_SELECT_ELEMENTS" pro nil (system) "%s, Dataspace_id, Coordinates" ("HDF5-routines57.html" ("RESET" . 1149840)))
    ("H5S_SELECT_HYPERSLAB" pro nil (system) "%s, Dataspace_id, Start, Count" ("HDF5-routines58.html" ("BLOCK" . 1149884) ("RESET" . 1149886) ("STRIDE" . 1149888)))
    ("H5S_SELECT_NONE" pro nil (system) "%s, Dataspace_id" ("HDF5-routines59.html"))
    ("H5T_CLOSE" pro nil (system) "%s, Datatype_id" ("HDF5-routines61.html"))
    ("H_EQ_CT" pro nil (system) "%s [, Image]" ("H.html"))
    ("H_EQ_INT" pro nil (system) "%s [, Image]" ("H2.html"))
    ("HDF_AN_END" pro nil (system) "%s, Annotation_id" ("HDF-routines13.html"))
    ("HDF_AN_ENDACCESS" pro nil (system) "%s, Annotation_id" ("HDF-routines14.html"))
    ("HDF_CLOSE" pro nil (system) "%s, FileHandle" ("HDF-routines25.html"))
    ("HDF_DELDD" pro nil (system) "%s, FileHandle, Tag, Ref" ("HDF-routines26.html"))
    ("HDF_DF24_ADDIMAGE" pro nil (system) "%s, Filename, Image" ("HDF-routines27.html" ("FORCE_BASELINE" . 1025840) ("JPEG" . 1025843) ("QUALITY" . 1025857) ("RLE" . 1025860)))
    ("HDF_DF24_GETIMAGE" pro nil (system) "%s, Filename, Image" ("HDF-routines28.html" ("LINE" . 996986) ("PIXEL" . 996989) ("PLANE" . 996992)))
    ("HDF_DF24_GETINFO" pro nil (system) "%s, Filename, Width, Height, Interlace" ("HDF-routines29.html"))
    ("HDF_DF24_READREF" pro nil (system) "%s, Filename, Reference_number" ("HDF-routines32.html"))
    ("HDF_DF24_RESTART" pro nil (system) "%s" ("HDF-routines33.html"))
    ("HDF_DFAN_ADDFDS" pro nil (system) "%s, Filename, Description" ("HDF-routines34.html"))
    ("HDF_DFAN_ADDFID" pro nil (system) "%s, Filename, Label" ("HDF-routines35.html"))
    ("HDF_DFAN_GETDESC" pro nil (system) "%s, Filename, Tag, Ref, Description" ("HDF-routines36.html" ("STRING" . 997205)))
    ("HDF_DFAN_GETFDS" pro nil (system) "%s, Filename, Description" ("HDF-routines37.html" ("FIRST" . 997250) ("STRING" . 997253)))
    ("HDF_DFAN_GETFID" pro nil (system) "%s, Filename, Label" ("HDF-routines38.html" ("FIRST" . 997305)))
    ("HDF_DFAN_GETLABEL" pro nil (system) "%s, Filename, Tag, Ref, Label" ("HDF-routines39.html"))
    ("HDF_DFAN_PUTDESC" pro nil (system) "%s, Filename, Tag, Ref, Description" ("HDF-routines42.html"))
    ("HDF_DFAN_PUTLABEL" pro nil (system) "%s, Filename, Tag, Ref, Label" ("HDF-routines43.html"))
    ("HDF_DFP_ADDPAL" pro nil (system) "%s, Filename, Palette" ("HDF-routines44.html"))
    ("HDF_DFP_GETPAL" pro nil (system) "%s, Filename, Palette" ("HDF-routines45.html"))
    ("HDF_DFP_PUTPAL" pro nil (system) "%s, Filename, Palette" ("HDF-routines48.html" ("DELETE" . 1016492) ("OVERWRITE" . 997545)))
    ("HDF_DFP_READREF" pro nil (system) "%s, Filename, Reference_number" ("HDF-routines49.html"))
    ("HDF_DFP_RESTART" pro nil (system) "%s" ("HDF-routines50.html"))
    ("HDF_DFP_WRITEREF" pro nil (system) "%s, Filename, Reference_number" ("HDF-routines51.html"))
    ("HDF_DFR8_ADDIMAGE" pro nil (system) "%s, Filename, Image" ("HDF-routines52.html" ("FORCE_BASELINE" . 997601) ("IMCOMP" . 1025489) ("JPEG" . 1025496) ("PALETTE" . 997604) ("QUALITY" . 997612) ("RLE" . 1025510)))
    ("HDF_DFR8_GETIMAGE" pro nil (system) "%s, Filename, Image [, Palette]" ("HDF-routines53.html"))
    ("HDF_DFR8_GETINFO" pro nil (system) "%s, Filename, Width, Height, Has_Palette" ("HDF-routines54.html"))
    ("HDF_DFR8_PUTIMAGE" pro nil (system) "%s, Filename, Image" ("HDF-routines57.html" ("FORCE_BASELINE" . 1025782) ("IMCOMP" . 1025788) ("JPEG" . 1025785) ("PALETTE" . 1025813) ("QUALITY" . 1025821) ("RLE" . 1025802)))
    ("HDF_DFR8_READREF" pro nil (system) "%s, Filename, Reference_number" ("HDF-routines58.html"))
    ("HDF_DFR8_RESTART" pro nil (system) "%s" ("HDF-routines59.html"))
    ("HDF_DFR8_SETPALETTE" pro nil (system) "%s, Palette" ("HDF-routines60.html"))
    ("HDF_DUPDD" pro nil (system) "%s, FileHandle, NewTag, NewRef, OldTag, OldRef" ("HDF-routines61.html"))
    ("HDF_GR_END" pro nil (system) "%s, gr_id" ("HDF-routines65.html"))
    ("HDF_GR_ENDACCESS" pro nil (system) "%s, ri_id" ("HDF-routines66.html"))
    ("HDF_LIB_INFO" pro nil (system) "%s, [FileHandle]" ("HDF-routines92.html" ("MAJOR" . 1031740) ("MINOR" . 1031746) ("RELEASE" . 1031752) ("VERSION" . 1031973)))
    ("HDF_SD_ADDDATA" pro nil (system) "%s, SDdataset_id, Data" ("HDF-routines97.html" ("COUNT" . 1053602) ("NOREVERSE" . 1053605) ("START" . 1053608) ("STRIDE" . 1053611)))
    ("HDF_SD_ATTRINFO" pro nil (system) "%s, SD_id, Attr_Index" ("HDF-routines99.html" ("COUNT" . 1053698) ("DATA" . 1053701) ("HDF_TYPE" . 1053704) ("NAME" . 1053707) ("TYPE" . 1053710)))
    ("HDF_SD_ATTRSET" pro nil (system) "%s, SD_id, Attr_Name, Values [, Count]" ("HDF-routines100.html" ("BYTE" . 1053770) ("DFNT_CHAR" . 1053773) ("DFNT_FLOAT32" . 1053776) ("DFNT_FLOAT64" . 1053779) ("DFNT_INT16" . 1053785) ("DFNT_INT32" . 1053788) ("DFNT_INT8" . 1053782) ("DFNT_UINT16" . 1053794) ("DFNT_UINT32" . 1053797) ("DFNT_UINT8" . 1053791) ("DOUBLE" . 1053800) ("FLOAT" . 1053803) ("INT" . 1053806) ("LONG" . 1053809) ("SHORT" . 1053812) ("STRING" . 1053815)))
    ("HDF_SD_DIMGET" pro nil (system) "%s, Dim_ID" ("HDF-routines102.html" ("COMPATIBILITY" . 1053946) ("COUNT" . 1053944) ("FORMAT" . 1053948) ("LABEL" . 1053950) ("NAME" . 1053952) ("NATTR" . 1053954) ("SCALE" . 1053956) ("TYPE" . 1053958) ("UNIT" . 1053960)))
    ("HDF_SD_DIMSET" pro nil (system) "%s, Dim_ID" ("HDF-routines104.html" ("BW_INCOMP" . 1054021) ("FORMAT" . 1054025) ("LABEL" . 1054027) ("NAME" . 1054029) ("SCALE" . 1054031) ("UNIT" . 1054033)))
    ("HDF_SD_END" pro nil (system) "%s, SDinterface_id" ("HDF-routines105.html"))
    ("HDF_SD_ENDACCESS" pro nil (system) "%s, SDinterface_id" ("HDF-routines106.html"))
    ("HDF_SD_FILEINFO" pro nil (system) "%s, SDinterface_id, Datasets, Attributes" ("HDF-routines107.html"))
    ("HDF_SD_GETDATA" pro nil (system) "%s, SDdataset_id, Data" ("HDF-routines108.html" ("COUNT" . 1054195) ("NOREVERSE" . 1054198) ("START" . 1054201) ("STRIDE" . 1054204)))
    ("HDF_SD_GETINFO" pro nil (system) "%s, SDdataset_id" ("HDF-routines109.html" ("CALDATA" . 1054234) ("COORDSYS" . 1054238) ("DIMS" . 1054241) ("FILL" . 1054244) ("FORMAT" . 1054247) ("HDF_TYPE" . 1054250) ("LABEL" . 1054253) ("NAME" . 1054256) ("NATTS" . 1054259) ("NDIMS" . 1054262) ("NOREVERSE" . 1054265) ("RANGE" . 1054268) ("TYPE" . 1054271) ("UNIT" . 1054274)))
    ("HDF_SD_SETCOMPRESS" pro nil (system) "%s, SDdataset_id, comptype" ("HDF-routines115.html" ("EFFORT" . 1074118)))
    ("HDF_SD_SETEXTFILE" pro nil (system) "%s, SDdataset_id, Filename" ("HDF-routines116.html" ("OFFSET" . 1054488)))
    ("HDF_SD_SETINFO" pro nil (system) "%s, SDdataset_id" ("HDF-routines117.html" ("CALDATA" . 1205515) ("COORDSYS" . 1205576) ("FILL" . 1054536) ("FORMAT" . 1054539) ("LABEL" . 1054542) ("RANGE" . 1054545) ("UNIT" . 1054548)))
    ("HDF_UNPACKDATA" pro nil (system) "%s, packeddata, data1 [, data2 [, data3 [, data4 [, data5 [, data6 [, data7 [, data8]]]]]]]" ("HDF-routines119.html" ("HDF_ORDER" . 1042997) ("HDF_TYPE" . 1043000) ("NREC" . 1043003)))
    ("HDF_VD_ATTRINFO" pro nil (system) "%s, VData, FieldID, AttrID" ("HDF-routines122.html" ("COUNT" . 1109959) ("DATA" . 1109961) ("HDF_TYPE" . 1109963) ("NAME" . 1109965) ("TYPE" . 1109967)))
    ("HDF_VD_ATTRSET" pro nil (system) "%s, VData, FieldID, Attr_Name, Values [, Count]" ("HDF-routines123.html" ("BYTE" . 1110005) ("DFNT_CHAR88" . 1110007) ("DFNT_FLOAT32" . 1110009) ("DFNT_FLOAT64" . 1110011) ("DFNT_INT16" . 1110015) ("DFNT_INT32" . 1110017) ("DFNT_INT8" . 1110013) ("DFNT_UCHAR88" . 1110019) ("DFNT_UINT16" . 1110023) ("DFNT_UINT32" . 1110025) ("DFNT_UINT8" . 1110021) ("DOUBLE" . 1110027) ("FLOAT" . 1110029) ("INT" . 1110031) ("LONG" . 1110033) ("SHORT" . 1110035) ("STRING" . 1110037) ("UINT" . 1110039) ("ULONG" . 1110041)))
    ("HDF_VD_DETACH" pro nil (system) "%s, VData" ("HDF-routines124.html"))
    ("HDF_VD_FDEFINE" pro nil (system) "%s, VData, Fieldname" ("HDF-routines125.html" ("BYTE" . 999536) ("DOUBLE" . 999539) ("FLOAT" . 999542) ("INT" . 999545) ("LONG" . 999548) ("ORDER" . 999551)))
    ("HDF_VD_GET" pro nil (system) "%s, VData" ("HDF-routines128.html" ("CLASS" . 999597) ("COUNT" . 999600) ("FIELDS" . 999603) ("INTERLACE" . 999606) ("NAME" . 999609) ("NFIELDS" . 999612) ("REF" . 999615) ("SIZE" . 999618) ("TAG" . 999621)))
    ("HDF_VD_GETINFO" pro nil (system) "%s, VData, Index" ("HDF-routines130.html" ("NAME" . 999666) ("ORDER" . 999669) ("SIZE" . 999672) ("TYPE" . 999675)))
    ("HDF_VD_INSERT" pro nil (system) "%s, VGroup, VData(or Vgroup)" ("HDF-routines131.html" ("POSITION" . 1141285)))
    ("HDF_VD_SEEK" pro nil (system) "%s, VData, Record" ("HDF-routines138.html"))
    ("HDF_VD_SETINFO" pro nil (system) "%s, VData" ("HDF-routines139.html" ("CLASS" . 999834) ("FULL_INTERLACE" . 999837) ("NAME" . 999840) ("NO_INTERLACE" . 999843)))
    ("HDF_VD_WRITE" pro nil (system) "%s, VData, Fields, Data" ("HDF-routines140.html" ("FULL_INTERLACE" . 999876) ("NO_INTERLACE" . 999879) ("NRECORDS" . 999882)))
    ("HDF_VG_ADDTR" pro nil (system) "%s, VGroup, Tag, Ref" ("HDF-routines141.html"))
    ("HDF_VG_DETACH" pro nil (system) "%s, VGroup" ("HDF-routines143.html"))
    ("HDF_VG_GETINFO" pro nil (system) "%s, VGroup" ("HDF-routines145.html" ("CLASS" . 1000002) ("NAME" . 1000005) ("NENTRIES" . 1000008) ("REF" . 1109613) ("TAG" . 1109591)))
    ("HDF_VG_GETTR" pro nil (system) "%s, VGroup, Index, Tags, Refs" ("HDF-routines147.html"))
    ("HDF_VG_GETTRS" pro nil (system) "%s, VGroup, Tags, Refs" ("HDF-routines148.html" ("MAXSIZE" . 1000064)))
    ("HDF_VG_INSERT" pro nil (system) "%s, VGroup, VData(or Vgroup)" ("HDF-routines150.html" ("POSITION" . 1234250)))
    ("HDF_VG_SETINFO" pro nil (system) "%s, VGroup" ("HDF-routines155.html" ("CLASSNAME" . 1000182) ("NAME" . 1000184)))
    ("HEAP_FREE" pro nil (system) "%s, Var" ("H9.html" ("OBJ" . 877472) ("PTR" . 877474) ("VERBOSE" . 877477)))
    ("HEAP_GC" pro nil (system) "%s" ("H10.html" ("OBJ" . 871683) ("PTR" . 832713) ("VERBOSE" . 832717)))
    ("HELP" pro nil (system) "%s, Expression1, ..., Expressionn" ("H11.html" ("ALL_KEYS" . 677134) ("BREAKPOINTS" . 677136) ("BRIEF" . 870534) ("CALLS" . 870532) ("DEVICE" . 677140) ("DLM" . 677142) ("FILES" . 843801) ("FULL" . 832176) ("FUNCTIONS" . 870207) ("HEAP_VARIABLES" . 870621) ("KEYS" . 677144) ("LAST_MESSAGE" . 843755) ("LEVEL" . 897567) ("MEMORY" . 677146) ("MESSAGES" . 677148) ("NAMES" . 843817) ("OBJECTS" . 832180) ("OUTPUT" . 832171) ("PATH_CACHE" . 677150) ("PROCEDURES" . 888071) ("RECALL_COMMANDS" . 870903) ("ROUTINES" . 869603) ("SHARED_MEMORY" . 880202) ("SOURCE_FILES" . 168290) ("STRUCTURES" . 677154) ("SYSTEM_VARIABLES" . 677156) ("TRACEBACK" . 677158)))
    ("HLS" pro nil (system) "%s, Litlo, Lithi, Satlo, Sathi, Hue, Loops [, Colr]" ("H16.html"))
    ("HSV" pro nil (system) "%s, Vlo, Vhi, Satlo, Sathi, Hue, Loops [, Colr]" ("H19.html"))
    ("ICONTOUR" pro nil (system) "%s[, Z[, X, Y]]" ("I2.html" ("AM_PM" . 937300) ("ANISOTROPY" . 937305) ("BACKGROUND_COLOR" . 963582) ("C_COLOR" . 963600) ("C_FILL_PATTERN" . 937326) ("C_LABEL_INTERVAL" . 937328) ("C_LABEL_NOGAPS" . 937330) ("C_LABEL_OBJECTS" . 937332) ("C_LABEL_SHOW" . 937341) ("C_LINESTYLE" . 937343) ("C_THICK" . 937356) ("C_USE_LABEL_COLOR" . 937358) ("C_USE_LABEL_ORIENTATION" . 937360) ("C_VALUE" . 937362) ("CLIP_PLANES" . 937364) ("COLOR" . 937367) ("DAYS_OF_WEEK" . 937369) ("DEPTH_OFFSET" . 963869) ("DIMENSIONS" . 937374) ("DOWNHILL" . 937376) ("FILL" . 937378) ("GRID_UNITS" . 964865) ("HIDE" . 937391) ("IDENTIFIER" . 937395) ("LABEL_FONT" . 937397) ("LABEL_FORMAT" . 937399) ("LABEL_FRMTDATA" . 937406) ("LABEL_UNITS" . 937408) ("LOCATION" . 937422) ("MACRO_NAMES" . 964542) ("MAX_VALUE" . 937424) ("MIN_VALUE" . 937431) ("MONTHS" . 937426) ("N_LEVELS" . 937435) ("NAME" . 937433) ("NO_SAVEPROMPT" . 982371) ("OVERPLOT" . 937437) ("PLANAR" . 937440) ("RGB_INDICES" . 937445) ("RGB_TABLE" . 937451) ("SHADE_RANGE" . 937458) ("SHADING" . 937460) ("STYLE_NAME" . 964365) ("TICKINTERVAL" . 937465) ("TICKLEN" . 937467) ("TITLE" . 937469) ("USE_TEXT_ALIGNMENTS" . 937471) ("VIEW_GRID" . 937473) ("VIEW_NEXT" . 937475) ("VIEW_NUMBER" . 937478) ("XGRIDSTYLE" . 937481) ("XMAJOR" . 961791) ("XMINOR" . 937483) ("XRANGE" . 937485) ("XSUBTICKLEN" . 937487) ("XTEXT_COLOR" . 937489) ("XTICKFONT_INDEX" . 937491) ("XTICKFONT_SIZE" . 937499) ("XTICKFONT_STYLE" . 937501) ("XTICKFORMAT" . 937508) ("XTICKINTERVAL" . 937526) ("XTICKLAYOUT" . 937530) ("XTICKLEN" . 937538) ("XTICKNAME" . 937540) ("XTICKUNITS" . 937542) ("XTICKVALUES" . 937558) ("XTITLE" . 937560) ("YGRIDSTYLE" . 937481) ("YMAJOR" . 961791) ("YMINOR" . 937483) ("YRANGE" . 937485) ("YSUBTICKLEN" . 937487) ("YTEXT_COLOR" . 937489) ("YTICKFONT_INDEX" . 937491) ("YTICKFONT_SIZE" . 937499) ("YTICKFONT_STYLE" . 937501) ("YTICKFORMAT" . 937508) ("YTICKINTERVAL" . 937526) ("YTICKLAYOUT" . 937530) ("YTICKLEN" . 937538) ("YTICKNAME" . 937540) ("YTICKUNITS" . 937542) ("YTICKVALUES" . 937558) ("YTITLE" . 937560) ("ZGRIDSTYLE" . 937481) ("ZMAJOR" . 961791) ("ZMINOR" . 937483) ("ZRANGE" . 937485) ("ZSUBTICKLEN" . 937487) ("ZTEXT_COLOR" . 937489) ("ZTICKFONT_INDEX" . 937491) ("ZTICKFONT_SIZE" . 937499) ("ZTICKFONT_STYLE" . 937501) ("ZTICKFORMAT" . 937508) ("ZTICKINTERVAL" . 937526) ("ZTICKLAYOUT" . 937530) ("ZTICKLEN" . 937538) ("ZTICKNAME" . 937540) ("ZTICKUNITS" . 937542) ("ZTICKVALUES" . 937558) ("ZTITLE" . 937560) ("ZVALUE" . 937562)))
    ("IIMAGE" pro nil (system) "%s[, Image[, X, Y]]" ("I8.html" ("ALPHA_CHANNEL" . 942273) ("BACKGROUND_COLOR" . 963611) ("BLUE_CHANNEL" . 940200) ("CHANNEL" . 940203) ("CLIP_PLANES" . 940205) ("DIMENSIONS" . 940208) ("GREEN_CHANNEL" . 940210) ("GRID_UNITS" . 964788) ("HIDE" . 940212) ("IDENTIFIER" . 940216) ("IMAGE_DIMENSIONS" . 940218) ("IMAGE_LOCATION" . 940220) ("INTERPOLATE" . 940222) ("LOCATION" . 940224) ("MACRO_NAMES" . 964551) ("NAME" . 940226) ("NO_SAVEPROMPT" . 982596) ("ORDER" . 964559) ("OVERPLOT" . 940230) ("RED_CHANNEL" . 940233) ("RGB_TABLE" . 940235) ("STYLE_NAME" . 964392) ("TITLE" . 940237) ("VIEW_GRID" . 940239) ("VIEW_NEXT" . 940241) ("VIEW_NUMBER" . 940244) ("XGRIDSTYLE" . 961815) ("XMAJOR" . 940247) ("XMINOR" . 940249) ("XRANGE" . 940251) ("XSUBTICKLEN" . 940253) ("XTEXT_COLOR" . 940255) ("XTICKFONT_INDEX" . 940257) ("XTICKFONT_SIZE" . 940264) ("XTICKFONT_STYLE" . 940266) ("XTICKFORMAT" . 940272) ("XTICKINTERVAL" . 940289) ("XTICKLAYOUT" . 940292) ("XTICKLEN" . 940299) ("XTICKNAME" . 940301) ("XTICKUNITS" . 940303) ("XTICKVALUES" . 940318) ("XTITLE" . 940320) ("YGRIDSTYLE" . 961815) ("YMAJOR" . 940247) ("YMINOR" . 940249) ("YRANGE" . 940251) ("YSUBTICKLEN" . 940253) ("YTEXT_COLOR" . 940255) ("YTICKFONT_INDEX" . 940257) ("YTICKFONT_SIZE" . 940264) ("YTICKFONT_STYLE" . 940266) ("YTICKFORMAT" . 940272) ("YTICKINTERVAL" . 940289) ("YTICKLAYOUT" . 940292) ("YTICKLEN" . 940299) ("YTICKNAME" . 940301) ("YTICKUNITS" . 940303) ("YTICKVALUES" . 940318) ("YTITLE" . 940320)))
    ("IMAGE_CONT" pro nil (system) "%s, A" ("I9.html" ("ASPECT" . 757356) ("INTERP" . 757359) ("WINDOW_SCALE" . 757362)))
    ("IMAGE_STATISTICS" pro nil (system) "%s, Data" ("I10.html" ("COUNT" . 873572) ("DATA_SUM" . 873574) ("LABELED" . 873576) ("LUT" . 873582) ("MASK" . 873584) ("MAXIMUM" . 873586) ("MEAN" . 873588) ("MINIMUM" . 873590) ("STDDEV" . 873592) ("SUM_OF_SQUARES" . 873594) ("VARIANCE" . 873596) ("VECTOR" . 873598) ("WEIGHT_SUM" . 873600) ("WEIGHTED" . 873603)))
    ("IMAP" pro nil (system) "%s" ("I12.html" ("BACKGROUND_COLOR" . 966654) ("CENTER_LATITUDE" . 966771) ("CENTER_LONGITUDE" . 966773) ("CONTOUR" . 966500) ("DATUM" . 966775) ("DIMENSIONS" . 966656) ("FALSE_EASTING" . 966916) ("FALSE_NORTHING" . 966918) ("GRID_UNITS" . 981023) ("HEIGHT" . 966920) ("HOM_AZIM_ANGLE" . 966924) ("HOM_AZIM_LONGITUDE" . 966922) ("HOM_LATITUDE1" . 966926) ("HOM_LATITUDE2" . 966928) ("HOM_LONGITUDE1" . 966930) ("HOM_LONGITUDE2" . 966932) ("IDENTIFIER" . 966658) ("IS_JUSTIFY" . 966936) ("IS_ZONES" . 966934) ("LIMIT" . 966941) ("LOCATION" . 966660) ("MACRO_NAMES" . 966666) ("MAP_PROJECTION" . 966503) ("MERCATOR_SCALE" . 966943) ("NAME" . 966668) ("NO_SAVEPROMPT" . 982447) ("OEA_ANGLE" . 966945) ("OEA_SHAPEM" . 966947) ("OEA_SHAPEN" . 966950) ("OVERPLOT" . 966670) ("SEMIMAJOR_AXIS" . 966953) ("SEMIMINOR_AXIS" . 966955) ("SOM_FLAG" . 966965) ("SOM_INCLINATION" . 966957) ("SOM_LANDSAT_NUMBER" . 966967) ("SOM_LANDSAT_PATH" . 966969) ("SOM_LONGITUDE" . 966959) ("SOM_PERIOD" . 966961) ("SOM_RATIO" . 966963) ("SPHERE_RADIUS" . 966971) ("STANDARD_PAR1" . 966975) ("STANDARD_PAR2" . 966977) ("STANDARD_PARALLEL" . 966973) ("STYLE_NAME" . 966673) ("TITLE" . 966678) ("TRUE_SCALE_LATITUDE" . 966979) ("VIEW_GRID" . 966680) ("VIEW_NEXT" . 966682) ("VIEW_NUMBER" . 966685) ("XGRIDSTYLE" . 966688) ("XMAJOR" . 966690) ("XMINOR" . 966692) ("XRANGE" . 966694) ("XSUBTICKLEN" . 966696) ("XTEXT_COLOR" . 966698) ("XTICKFONT_INDEX" . 966700) ("XTICKFONT_SIZE" . 966707) ("XTICKFONT_STYLE" . 966709) ("XTICKFORMAT" . 966715) ("XTICKINTERVAL" . 966736) ("XTICKLAYOUT" . 966739) ("XTICKLEN" . 966746) ("XTICKNAME" . 966748) ("XTICKUNITS" . 966750) ("XTICKVALUES" . 966766) ("XTITLE" . 966768) ("YGRIDSTYLE" . 966688) ("YMAJOR" . 966690) ("YMINOR" . 966692) ("YRANGE" . 966694) ("YSUBTICKLEN" . 966696) ("YTEXT_COLOR" . 966698) ("YTICKFONT_INDEX" . 966700) ("YTICKFONT_SIZE" . 966707) ("YTICKFONT_STYLE" . 966709) ("YTICKFORMAT" . 966715) ("YTICKINTERVAL" . 966736) ("YTICKLAYOUT" . 966739) ("YTICKLEN" . 966746) ("YTICKNAME" . 966748) ("YTICKUNITS" . 966750) ("YTICKVALUES" . 966766) ("YTITLE" . 966768) ("ZONE" . 966981)) ("I2.html" ("AM_PM" . 937300) ("ANISOTROPY" . 937305) ("BACKGROUND_COLOR" . 963582) ("C_COLOR" . 963600) ("C_FILL_PATTERN" . 937326) ("C_LABEL_INTERVAL" . 937328) ("C_LABEL_NOGAPS" . 937330) ("C_LABEL_OBJECTS" . 937332) ("C_LABEL_SHOW" . 937341) ("C_LINESTYLE" . 937343) ("C_THICK" . 937356) ("C_USE_LABEL_COLOR" . 937358) ("C_USE_LABEL_ORIENTATION" . 937360) ("C_VALUE" . 937362) ("CLIP_PLANES" . 937364) ("COLOR" . 937367) ("DAYS_OF_WEEK" . 937369) ("DEPTH_OFFSET" . 963869) ("DIMENSIONS" . 937374) ("DOWNHILL" . 937376) ("FILL" . 937378) ("GRID_UNITS" . 964865) ("HIDE" . 937391) ("IDENTIFIER" . 937395) ("LABEL_FONT" . 937397) ("LABEL_FORMAT" . 937399) ("LABEL_FRMTDATA" . 937406) ("LABEL_UNITS" . 937408) ("LOCATION" . 937422) ("MACRO_NAMES" . 964542) ("MAX_VALUE" . 937424) ("MIN_VALUE" . 937431) ("MONTHS" . 937426) ("N_LEVELS" . 937435) ("NAME" . 937433) ("NO_SAVEPROMPT" . 982371) ("OVERPLOT" . 937437) ("PLANAR" . 937440) ("RGB_INDICES" . 937445) ("RGB_TABLE" . 937451) ("SHADE_RANGE" . 937458) ("SHADING" . 937460) ("STYLE_NAME" . 964365) ("TICKINTERVAL" . 937465) ("TICKLEN" . 937467) ("TITLE" . 937469) ("USE_TEXT_ALIGNMENTS" . 937471) ("VIEW_GRID" . 937473) ("VIEW_NEXT" . 937475) ("VIEW_NUMBER" . 937478) ("XGRIDSTYLE" . 937481) ("XMAJOR" . 961791) ("XMINOR" . 937483) ("XRANGE" . 937485) ("XSUBTICKLEN" . 937487) ("XTEXT_COLOR" . 937489) ("XTICKFONT_INDEX" . 937491) ("XTICKFONT_SIZE" . 937499) ("XTICKFONT_STYLE" . 937501) ("XTICKFORMAT" . 937508) ("XTICKINTERVAL" . 937526) ("XTICKLAYOUT" . 937530) ("XTICKLEN" . 937538) ("XTICKNAME" . 937540) ("XTICKUNITS" . 937542) ("XTICKVALUES" . 937558) ("XTITLE" . 937560) ("YGRIDSTYLE" . 937481) ("YMAJOR" . 961791) ("YMINOR" . 937483) ("YRANGE" . 937485) ("YSUBTICKLEN" . 937487) ("YTEXT_COLOR" . 937489) ("YTICKFONT_INDEX" . 937491) ("YTICKFONT_SIZE" . 937499) ("YTICKFONT_STYLE" . 937501) ("YTICKFORMAT" . 937508) ("YTICKINTERVAL" . 937526) ("YTICKLAYOUT" . 937530) ("YTICKLEN" . 937538) ("YTICKNAME" . 937540) ("YTICKUNITS" . 937542) ("YTICKVALUES" . 937558) ("YTITLE" . 937560) ("ZGRIDSTYLE" . 937481) ("ZMAJOR" . 961791) ("ZMINOR" . 937483) ("ZRANGE" . 937485) ("ZSUBTICKLEN" . 937487) ("ZTEXT_COLOR" . 937489) ("ZTICKFONT_INDEX" . 937491) ("ZTICKFONT_SIZE" . 937499) ("ZTICKFONT_STYLE" . 937501) ("ZTICKFORMAT" . 937508) ("ZTICKINTERVAL" . 937526) ("ZTICKLAYOUT" . 937530) ("ZTICKLEN" . 937538) ("ZTICKNAME" . 937540) ("ZTICKUNITS" . 937542) ("ZTICKVALUES" . 937558) ("ZTITLE" . 937560) ("ZVALUE" . 937562)) ("I8.html" ("ALPHA_CHANNEL" . 942273) ("BACKGROUND_COLOR" . 963611) ("BLUE_CHANNEL" . 940200) ("CHANNEL" . 940203) ("CLIP_PLANES" . 940205) ("DIMENSIONS" . 940208) ("GREEN_CHANNEL" . 940210) ("GRID_UNITS" . 964788) ("HIDE" . 940212) ("IDENTIFIER" . 940216) ("IMAGE_DIMENSIONS" . 940218) ("IMAGE_LOCATION" . 940220) ("INTERPOLATE" . 940222) ("LOCATION" . 940224) ("MACRO_NAMES" . 964551) ("NAME" . 940226) ("NO_SAVEPROMPT" . 982596) ("ORDER" . 964559) ("OVERPLOT" . 940230) ("RED_CHANNEL" . 940233) ("RGB_TABLE" . 940235) ("STYLE_NAME" . 964392) ("TITLE" . 940237) ("VIEW_GRID" . 940239) ("VIEW_NEXT" . 940241) ("VIEW_NUMBER" . 940244) ("XGRIDSTYLE" . 961815) ("XMAJOR" . 940247) ("XMINOR" . 940249) ("XRANGE" . 940251) ("XSUBTICKLEN" . 940253) ("XTEXT_COLOR" . 940255) ("XTICKFONT_INDEX" . 940257) ("XTICKFONT_SIZE" . 940264) ("XTICKFONT_STYLE" . 940266) ("XTICKFORMAT" . 940272) ("XTICKINTERVAL" . 940289) ("XTICKLAYOUT" . 940292) ("XTICKLEN" . 940299) ("XTICKNAME" . 940301) ("XTICKUNITS" . 940303) ("XTICKVALUES" . 940318) ("XTITLE" . 940320) ("YGRIDSTYLE" . 961815) ("YMAJOR" . 940247) ("YMINOR" . 940249) ("YRANGE" . 940251) ("YSUBTICKLEN" . 940253) ("YTEXT_COLOR" . 940255) ("YTICKFONT_INDEX" . 940257) ("YTICKFONT_SIZE" . 940264) ("YTICKFONT_STYLE" . 940266) ("YTICKFORMAT" . 940272) ("YTICKINTERVAL" . 940289) ("YTICKLAYOUT" . 940292) ("YTICKLEN" . 940299) ("YTICKNAME" . 940301) ("YTICKUNITS" . 940303) ("YTICKVALUES" . 940318) ("YTITLE" . 940320)))
    ("INTERVAL_VOLUME" pro nil (system) "%s, Data, Value0, Value1, Outverts, Outconn" ("I20.html" ("AUXDATA_IN" . 877934) ("AUXDATA_OUT" . 877937) ("GEOM_XYZ" . 877940) ("PROGRESS_CALLBACK" . 904666) ("PROGRESS_METHOD" . 904664) ("PROGRESS_OBJECT" . 904694) ("PROGRESS_PERCENT" . 904705) ("PROGRESS_USERDATA" . 904717) ("TETRAHEDRA" . 904724)))
    ("IPLOT" pro nil (system) "%s, [X,] Y or %s, X, Y, Z or %s[, R], Theta" ("I23.html" ("BACKGROUND_COLOR" . 940548) ("CLIP_PLANES" . 963636) ("COLOR" . 940551) ("DIMENSIONS" . 984454) ("ERRORBAR_CAPSIZE" . 940557) ("ERRORBAR_COLOR" . 940555) ("FILL_BACKGROUND" . 940559) ("FILL_COLOR" . 940561) ("FILL_LEVEL" . 940563) ("HIDE" . 940565) ("HISTOGRAM" . 940569) ("IDENTIFIER" . 940571) ("LINESTYLE" . 940573) ("LOCATION" . 940586) ("MACRO_NAMES" . 964589) ("MAX_VALUE" . 940588) ("MIN_VALUE" . 940591) ("NAME" . 940594) ("NO_SAVEPROMPT" . 982649) ("NSUM" . 940596) ("OVERPLOT" . 940598) ("POLAR" . 940601) ("RGB_TABLE" . 940603) ("SCATTER" . 940605) ("STYLE_NAME" . 964415) ("SYM_COLOR" . 940607) ("SYM_INCREMENT" . 940610) ("SYM_INDEX" . 940612) ("SYM_SIZE" . 940623) ("SYM_THICK" . 940625) ("THICK" . 940627) ("TITLE" . 940629) ("TRANSPARENCY" . 940631) ("USE_DEFAULT_COLOR" . 940633) ("VERT_COLORS" . 940637) ("VIEW_GRID" . 940639) ("VIEW_NEXT" . 940641) ("VIEW_NUMBER" . 940644) ("X_ERRORBARS" . 940649) ("X_LOG" . 940651) ("XERROR" . 940653) ("XGRIDSTYLE" . 961829) ("XMAJOR" . 940655) ("XMINOR" . 940657) ("XRANGE" . 940659) ("XSUBTICKLEN" . 940661) ("XTEXT_COLOR" . 940663) ("XTICKFONT_INDEX" . 940665) ("XTICKFONT_SIZE" . 940673) ("XTICKFONT_STYLE" . 940675) ("XTICKFORMAT" . 940682) ("XTICKINTERVAL" . 940700) ("XTICKLAYOUT" . 940704) ("XTICKLEN" . 940712) ("XTICKNAME" . 940714) ("XTICKUNITS" . 940716) ("XTICKVALUES" . 940732) ("XTITLE" . 940734) ("XY_SHADOW" . 940647) ("XZ_SHADOW" . 940736) ("Y_ERRORBARS" . 940649) ("Y_LOG" . 940651) ("YERROR" . 940653) ("YGRIDSTYLE" . 961829) ("YMAJOR" . 940655) ("YMINOR" . 940657) ("YRANGE" . 940659) ("YSUBTICKLEN" . 940661) ("YTEXT_COLOR" . 940663) ("YTICKFONT_INDEX" . 940665) ("YTICKFONT_SIZE" . 940673) ("YTICKFONT_STYLE" . 940675) ("YTICKFORMAT" . 940682) ("YTICKINTERVAL" . 940700) ("YTICKLAYOUT" . 940704) ("YTICKLEN" . 940712) ("YTICKNAME" . 940714) ("YTICKUNITS" . 940716) ("YTICKVALUES" . 940732) ("YTITLE" . 940734) ("YZ_SHADOW" . 940738) ("Z_ERRORBARS" . 940649) ("Z_LOG" . 940651) ("ZERROR" . 940653) ("ZGRIDSTYLE" . 961829) ("ZMAJOR" . 940655) ("ZMINOR" . 940657) ("ZRANGE" . 940659) ("ZSUBTICKLEN" . 940661) ("ZTEXT_COLOR" . 940663) ("ZTICKFONT_INDEX" . 940665) ("ZTICKFONT_SIZE" . 940673) ("ZTICKFONT_STYLE" . 940675) ("ZTICKFORMAT" . 940682) ("ZTICKINTERVAL" . 940700) ("ZTICKLAYOUT" . 940704) ("ZTICKLEN" . 940712) ("ZTICKNAME" . 940714) ("ZTICKUNITS" . 940716) ("ZTICKVALUES" . 940732) ("ZTITLE" . 940734)))
    ("ISOCONTOUR" pro nil (system) "%s, Values, Outverts, Outconn" ("I25.html" ("AUXDATA_IN" . 873707) ("AUXDATA_OUT" . 873709) ("C_LABEL_INTERVAL" . 873711) ("C_LABEL_SHOW" . 880877) ("C_VALUE" . 880888) ("DOUBLE" . 875352) ("FILL" . 873713) ("GEOMX" . 873715) ("GEOMY" . 873717) ("GEOMZ" . 873719) ("LEVEL_VALUES" . 873723) ("N_LEVELS" . 873725) ("OUT_LABEL_OFFSETS" . 873727) ("OUT_LABEL_POLYLINES" . 880899) ("OUT_LABEL_STRINGS" . 880914) ("OUTCONN_INDICES" . 880934) ("POLYGONS" . 873730)))
    ("ISOSURFACE" pro nil (system) "%s, Data, Value, Outverts, Outconn" ("I26.html" ("AUXDATA_IN" . 873750) ("AUXDATA_OUT" . 873753) ("GEOM_XYZ" . 873756) ("PROGRESS_CALLBACK" . 873759) ("PROGRESS_METHOD" . 904740) ("PROGRESS_OBJECT" . 904767) ("PROGRESS_PERCENT" . 904780) ("PROGRESS_USERDATA" . 904786) ("TETRAHEDRA" . 904793)))
    ("ISURFACE" pro nil (system) "%s[, Z [, X, Y]]" ("I27.html" ("BACKGROUND_COLOR" . 940941) ("BOTTOM" . 963651) ("CLIP_PLANES" . 940943) ("COLOR" . 940946) ("DEPTH_OFFSET" . 940950) ("DIMENSIONS" . 940948) ("EXTENDED_LEGO" . 940960) ("HIDDEN_LINES" . 940962) ("HIDE" . 940964) ("IDENTIFIER" . 940968) ("LINESTYLE" . 940970) ("LOCATION" . 940983) ("MACRO_NAMES" . 964571) ("NAME" . 940985) ("NO_SAVEPROMPT" . 982715) ("OVERPLOT" . 940987) ("RGB_TABLE" . 940990) ("SHADING" . 940992) ("SHOW_SKIRT" . 940997) ("SKIRT" . 940999) ("STYLE" . 941001) ("STYLE_NAME" . 964441) ("TEXTURE_ALPHA" . 941010) ("TEXTURE_BLUE" . 941012) ("TEXTURE_GREEN" . 941014) ("TEXTURE_HIGHRES" . 941016) ("TEXTURE_IMAGE" . 941019) ("TEXTURE_INTERP" . 941021) ("TEXTURE_RED" . 941023) ("THICK" . 941025) ("TITLE" . 941027) ("USE_TRIANGLES" . 941029) ("VERT_COLORS" . 941031) ("VIEW_GRID" . 941033) ("VIEW_NEXT" . 941035) ("VIEW_NUMBER" . 941038) ("XGRIDSTYLE" . 961847) ("XMAJOR" . 941041) ("XMINOR" . 941043) ("XRANGE" . 941045) ("XSUBTICKLEN" . 941047) ("XTEXT_COLOR" . 941049) ("XTICKFONT_INDEX" . 941051) ("XTICKFONT_SIZE" . 941058) ("XTICKFONT_STYLE" . 941060) ("XTICKFORMAT" . 941066) ("XTICKINTERVAL" . 941083) ("XTICKLAYOUT" . 941086) ("XTICKLEN" . 941093) ("XTICKNAME" . 941095) ("XTICKUNITS" . 941097) ("XTICKVALUES" . 941112) ("XTITLE" . 941114) ("YGRIDSTYLE" . 961847) ("YMAJOR" . 941041) ("YMINOR" . 941043) ("YRANGE" . 941045) ("YSUBTICKLEN" . 941047) ("YTEXT_COLOR" . 941049) ("YTICKFONT_INDEX" . 941051) ("YTICKFONT_SIZE" . 941058) ("YTICKFONT_STYLE" . 941060) ("YTICKFORMAT" . 941066) ("YTICKINTERVAL" . 941083) ("YTICKLAYOUT" . 941086) ("YTICKLEN" . 941093) ("YTICKNAME" . 941095) ("YTICKUNITS" . 941097) ("YTICKVALUES" . 941112) ("YTITLE" . 941114) ("ZERO_OPACITY_SKIP" . 941116) ("ZGRIDSTYLE" . 961847) ("ZMAJOR" . 941041) ("ZMINOR" . 941043) ("ZRANGE" . 941045) ("ZSUBTICKLEN" . 941047) ("ZTEXT_COLOR" . 941049) ("ZTICKFONT_INDEX" . 941051) ("ZTICKFONT_SIZE" . 941058) ("ZTICKFONT_STYLE" . 941060) ("ZTICKFORMAT" . 941066) ("ZTICKINTERVAL" . 941083) ("ZTICKLAYOUT" . 941086) ("ZTICKLEN" . 941093) ("ZTICKNAME" . 941095) ("ZTICKUNITS" . 941097) ("ZTICKVALUES" . 941112) ("ZTITLE" . 941114)))
    ("ITCURRENT" pro nil (system) "%s, iToolID" ("I28.html"))
    ("ITDELETE" pro nil (system) "%s[, iToolID]" ("I29.html"))
    ("ITREGISTER" pro nil (system) "%s, Name, ItemName" ("I31.html" ("ANNOTATION" . 961620) ("DEFAULT" . 980906) ("FILE_READER" . 961629) ("FILE_WRITER" . 961635) ("TYPES" . 941578) ("UI_PANEL" . 941581) ("UI_SERVICE" . 941584) ("USER_INTERFACE" . 961874) ("VISUALIZATION" . 941586)))
    ("ITRESET" pro nil (system) "%s" ("I32.html" ("NO_PROMPT" . 941670)))
    ("ITRESOLVE" pro nil (system) "%s" ("I33.html" ("PATH" . 969191)))
    ("IVOLUME" pro nil (system) "%s[, Vol0[, Vol1][, Vol2, Vol3]]" ("I34.html" ("AMBIENT" . 941804) ("AUTO_RENDER" . 941806) ("BACKGROUND_COLOR" . 941809) ("BOUNDS" . 963673) ("CLIP_PLANES" . 963690) ("COMPOSITE_FUNCTION" . 941815) ("DEPTH_CUE" . 941828) ("DIMENSIONS" . 941837) ("EXTENTS_TRANSPARENCY" . 964340) ("HIDE" . 941839) ("HINTS" . 941843) ("IDENTIFIER" . 941849) ("INTERPOLATE" . 941851) ("LIGHTING_MODEL" . 941853) ("LOCATION" . 941856) ("MACRO_NAMES" . 964580) ("NAME" . 941858) ("NO_SAVEPROMPT" . 982766) ("OPACITY_TABLE0" . 941860) ("OPACITY_TABLE1" . 941862) ("OVERPLOT" . 941864) ("RENDER_EXTENTS" . 941867) ("RENDER_QUALITY" . 941874) ("RENDER_STEP" . 941872) ("RGB_TABLE0" . 941879) ("RGB_TABLE1" . 941881) ("STYLE_NAME" . 964479) ("SUBVOLUME" . 941883) ("TITLE" . 941885) ("TWO_SIDED" . 941887) ("VIEW_GRID" . 941889) ("VIEW_NEXT" . 941891) ("VIEW_NUMBER" . 941894) ("VOLUME_DIMENSIONS" . 941897) ("VOLUME_LOCATION" . 941899) ("XGRIDSTYLE" . 961859) ("XMAJOR" . 941901) ("XMINOR" . 941903) ("XRANGE" . 941905) ("XSUBTICKLEN" . 941907) ("XTEXT_COLOR" . 941909) ("XTICKFONT_INDEX" . 941911) ("XTICKFONT_SIZE" . 941918) ("XTICKFONT_STYLE" . 941920) ("XTICKFORMAT" . 941926) ("XTICKINTERVAL" . 941943) ("XTICKLAYOUT" . 941946) ("XTICKLEN" . 941953) ("XTICKNAME" . 941955) ("XTICKUNITS" . 941957) ("XTICKVALUES" . 941972) ("XTITLE" . 941974) ("YGRIDSTYLE" . 961859) ("YMAJOR" . 941901) ("YMINOR" . 941903) ("YRANGE" . 941905) ("YSUBTICKLEN" . 941907) ("YTEXT_COLOR" . 941909) ("YTICKFONT_INDEX" . 941911) ("YTICKFONT_SIZE" . 941918) ("YTICKFONT_STYLE" . 941920) ("YTICKFORMAT" . 941926) ("YTICKINTERVAL" . 941943) ("YTICKLAYOUT" . 941946) ("YTICKLEN" . 941953) ("YTICKNAME" . 941955) ("YTICKUNITS" . 941957) ("YTICKVALUES" . 941972) ("YTITLE" . 941974) ("ZBUFFER" . 941976) ("ZERO_OPACITY_SKIP" . 941978) ("ZGRIDSTYLE" . 961859) ("ZMAJOR" . 941901) ("ZMINOR" . 941903) ("ZRANGE" . 941905) ("ZSUBTICKLEN" . 941907) ("ZTEXT_COLOR" . 941909) ("ZTICKFONT_INDEX" . 941911) ("ZTICKFONT_SIZE" . 941918) ("ZTICKFONT_STYLE" . 941920) ("ZTICKFORMAT" . 941926) ("ZTICKINTERVAL" . 941943) ("ZTICKLAYOUT" . 941946) ("ZTICKLEN" . 941953) ("ZTICKNAME" . 941955) ("ZTICKUNITS" . 941957) ("ZTICKVALUES" . 941972) ("ZTITLE" . 941974)))
    ("JOURNAL" pro nil (system) "%s [, Arg]" ("J.html"))
    ("LA_CHOLDC" pro nil (system) "%s, Array" ("L2.html" ("DOUBLE" . 969070) ("STATUS" . 969072) ("UPPER" . 969077)))
    ("LA_LUDC" pro nil (system) "%s, Array, Index" ("L16.html" ("DOUBLE" . 970769) ("STATUS" . 970771)))
    ("LA_SVD" pro nil (system) "%s, Array, W, U, V" ("L19.html" ("DIVIDE_CONQUER" . 971149) ("DOUBLE" . 971151) ("STATUS" . 971153)))
    ("LA_TRIDC" pro nil (system) "%s, AL, A, AU, U2, Index" ("L20.html" ("DOUBLE" . 971273) ("STATUS" . 971275)))
    ("LA_TRIQL" pro nil (system) "%s, D, E [, A]" ("L22.html" ("DOUBLE" . 971540) ("STATUS" . 971542)))
    ("LA_TRIRED" pro nil (system) "%s, Array, D, E" ("L23.html" ("DOUBLE" . 971643) ("UPPER" . 971645)))
    ("LINKIMAGE" pro nil (system) "%s, Name, Image [, Type [, Entry]]" ("L34.html" ("DEVICE" . 855619) ("FUNCT" . 855622) ("KEYWORDS" . 855625) ("MAX_ARGS" . 855628) ("MIN_ARGS" . 855632)))
    ("LOADCT" pro nil (system) "%s [, Table]" ("L40.html" ("BOTTOM" . 168327) ("FILE" . 759299) ("GET_NAMES" . 759305) ("NCOLORS" . 759308) ("SILENT" . 759311)))
    ("LUDC" pro nil (system) "%s, A, Index" ("L51.html" ("COLUMN" . 58718) ("DOUBLE" . 50959) ("INTERCHANGES" . 50962)))
    ("MAKE_DLL" pro nil (system) "%s, InputFiles [, OutputFile], ExportedRoutineNames" ("M4.html" ("CC" . 960457) ("COMPILE_DIRECTORY" . 960459) ("DLL_PATH" . 960461) ("EXPORTED_DATA" . 960463) ("EXTRA_CFLAGS" . 960465) ("EXTRA_LFLAGS" . 960467) ("INPUT_DIRECTORY" . 960469) ("LD" . 960471) ("NOCLEANUP" . 960473) ("OUTPUT_DIRECTORY" . 960502) ("REUSE_EXISTING" . 973081) ("SHOW_ALL_OUTPUT" . 960504) ("VERBOSE" . 960506)))
    ("MAP_CONTINENTS" pro nil (system) "%s" ("M6.html" ("COASTS" . 1048587) ("COLOR" . 887531) ("CONTINENTS" . 957787) ("COUNTRIES" . 887534) ("FILL_CONTINENTS" . 887537) ("HIRES" . 887540) ("LIMIT" . 957885) ("MAP_STRUCTURE" . 1059750) ("MLINESTYLE" . 1059754) ("MLINETHICK" . 887584) ("ORIENTATION" . 887588) ("RIVERS" . 887591) ("SPACING" . 887594) ("USA" . 887597)) ("graphkeyw2.html" ("T3D" . 315956) ("ZVALUE" . 316102)))
    ("MAP_GRID" pro nil (system) "%s" ("M7.html" ("BOX_AXES" . 919039) ("CHARSIZE" . 887636) ("CLIP_TEXT" . 919041) ("COLOR" . 887639) ("FILL_HORIZON" . 958045) ("GLINESTYLE" . 887642) ("GLINETHICK" . 887648) ("HORIZON" . 958090) ("INCREMENT" . 958092) ("LABEL" . 958064) ("LATALIGN" . 887654) ("LATDEL" . 887657) ("LATLAB" . 887660) ("LATNAMES" . 887663) ("LATS" . 887668) ("LONALIGN" . 887673) ("LONDEL" . 887676) ("LONLAB" . 887679) ("LONNAMES" . 887682) ("LONS" . 887687) ("MAP_STRUCTURE" . 1059914) ("NO_GRID" . 958111) ("ORIENTATION" . 887692)) ("graphkeyw2.html" ("T3D" . 315956) ("ZVALUE" . 316102)))
    ("MAP_PROJ_INFO" pro nil (system) "%s [, iproj]" ("M12.html" ("AZIMUTHAL" . 918995) ("CIRCLE" . 928077) ("CURRENT" . 918999) ("CYLINDRICAL" . 919001) ("LL_LIMITS" . 919003) ("NAME" . 919005) ("PROJ_NAMES" . 919007) ("UV_LIMITS" . 919011) ("UV_RANGE" . 928995)))
    ("MAP_SET" pro nil (system) "%s [, P0lat, P0lon, Rot]" ("M15.html" ("ADVANCE" . 887984) ("AITOFF" . 957265) ("ALBERS" . 887925) ("AZIMUTHAL" . 887931) ("CENTRAL_AZIMUTH" . 888123) ("CHARSIZE" . 887987) ("CLIP" . 887990) ("COLOR" . 887997) ("CON_COLOR" . 888003) ("CONIC" . 887934) ("CONTINENTS" . 888000) ("CYLINDRICAL" . 887940) ("E_CONTINENTS" . 888006) ("E_GRID" . 888009) ("E_HORIZON" . 888013) ("ELLIPSOID" . 888127) ("GLINESTYLE" . 888019) ("GLINETHICK" . 888025) ("GNOMIC" . 887943) ("GOODESHOMOLOSINE" . 918601) ("GRID" . 949681) ("HAMMER" . 887946) ("HIRES" . 888031) ("HORIZON" . 888034) ("ISOTROPIC" . 888134) ("LABEL" . 918537) ("LAMBERT" . 887950) ("LATALIGN" . 888043) ("LATDEL" . 888049) ("LATLAB" . 888046) ("LIMIT" . 888141) ("LONALIGN" . 888052) ("LONDEL" . 888055) ("LONLAB" . 888058) ("MERCATOR" . 887953) ("MILLER_CYLINDRICAL" . 887956) ("MLINESTYLE" . 888061) ("MLINETHICK" . 888101) ("MOLLWEIDE" . 887959) ("NAME" . 958229) ("NOBORDER" . 958173) ("NOERASE" . 888107) ("ORTHOGRAPHIC" . 887962) ("REVERSE" . 888110) ("ROBINSON" . 919362) ("SAT_P" . 888146) ("SATELLITE" . 887965) ("SCALE" . 958134) ("SINUSOIDAL" . 887971) ("STANDARD_PARALLELS" . 888156) ("STEREOGRAPHIC" . 887974) ("TITLE" . 958298) ("TRANSVERSE_MERCATOR" . 887977) ("USA" . 888113) ("XMARGIN" . 958356) ("YMARGIN" . 888119)) ("graphkeyw2.html" ("POSITION" . 316026) ("T3D" . 315956) ("ZVALUE" . 316102)))
    ("MESH_OBJ" pro nil (system) "%s, Type, Vertex_List, Polygon_List, Array1 [, Array2]" ("M29.html" ("CLOSED" . 888559) ("DEGREES" . 965212) ("P1" . 888562) ("P5")))
    ("MESSAGE" pro nil (system) "%s, [Text]" ("M34.html" ("BLOCK" . 888669) ("CONTINUE" . 965245) ("INFORMATIONAL" . 888672) ("IOERROR" . 888676) ("LEVEL" . 965401) ("NAME" . 965353) ("NONAME" . 965554) ("NOPREFIX" . 888682) ("NOPRINT" . 888686) ("REISSUE_LAST" . 1016375) ("RESET" . 1016373) ("TRACEBACK" . 888698)))
    ("MK_HTML_HELP" pro nil (system) "%s, Sources, Filename" ("M37.html" ("STRICT" . 888862) ("TITLE" . 888864) ("VERBOSE" . 888866)))
    ("MODIFYCT" pro nil (system) "%s, Itab, Name, R, G, B" ("M38.html" ("FILE" . 962516)))
    ("MPEG_CLOSE" pro nil (system) "%s, mpegID" ("M47.html"))
    ("MPEG_PUT" pro nil (system) "%s, mpegID" ("M49.html" ("COLOR" . 889108) ("FRAME" . 915949) ("IMAGE" . 889110) ("ORDER" . 889112) ("WINDOW" . 889114)))
    ("MPEG_SAVE" pro nil (system) "%s, mpegID" ("M50.html" ("FILENAME" . 889150)))
    ("MULTI" pro nil (system) "%s, N" ("M51.html"))
    ("NCDF_ATTCDEL" pro nil (system) "%s, Cdfid [, Varid]" ("NetCDF-routines12.html" ("GLOBAL" . 996962)))
    ("NCDF_ATTGET" pro nil (system) "%s, Cdfid [, Varid]" ("NetCDF-routines13.html" ("GLOBAL" . 996996)))
    ("NCDF_ATTPUT" pro nil (system) "%s, Cdfid [, Varid]" ("NetCDF-routines16.html" ("BYTE" . 997126) ("CHAR" . 997129) ("DOUBLE" . 997132) ("FLOAT" . 997135) ("GLOBAL" . 997116) ("LENGTH" . 997119) ("LONG" . 997138) ("SHORT" . 997141)))
    ("NCDF_ATTRENAME" pro nil (system) "%s, Cdfid [, Varid]" ("NetCDF-routines17.html" ("GLOBAL" . 997166)))
    ("NCDF_CLOSE" pro nil (system) "%s, Cdfid" ("NetCDF-routines18.html"))
    ("NCDF_CONTROL" pro nil (system) "%s, Cdfid" ("NetCDF-routines19.html" ("ABORT" . 997195) ("ENDEF" . 997198) ("FILL" . 997201) ("NOFILL" . 997237) ("NOVERBOSE" . 997240) ("OLDFILL" . 997243) ("REDEF" . 997247) ("SYNC" . 997250) ("VERBOSE" . 997253)))
    ("NCDF_DIMINQ" pro nil (system) "%s, Cdfid, Dimid, Name, Size" ("NetCDF-routines23.html"))
    ("NCDF_DIMRENAME" pro nil (system) "%s, Cdfid, Dimid, NewName" ("NetCDF-routines24.html"))
    ("NCDF_VARGET" pro nil (system) "%s, Cdfid, Varid, Value" ("NetCDF-routines29.html" ("COUNT" . 997494) ("OFFSET" . 997497) ("STRIDE" . 997500)))
    ("NCDF_VARGET1" pro nil (system) "%s, Cdfid, Varid, Value" ("NetCDF-routines30.html" ("OFFSET" . 997545)))
    ("NCDF_VARPUT" pro nil (system) "%s, Cdfid, Varid, Value" ("NetCDF-routines33.html" ("COUNT" . 997627) ("OFFSET" . 997630) ("STRIDE" . 997633)))
    ("NCDF_VARRENAME" pro nil (system) "%s, Cdfid, Varid, Name" ("NetCDF-routines34.html"))
    ("OBJ" pro nil (system) "%s - > [IDLffJPEG2000::]Cleanup" ("objects_ff37.html"))
    ("OBJ_DESTROY" pro nil (system) "%s, Obj" ("objects_ff89.html"))
    ("ON_ERROR" pro nil (system) "%s, N" ("O7.html"))
    ("ON_IOERROR" pro nil (system) "%s, Label" ("O8.html"))
    ("ONLINE_HELP" pro nil (system) "%s [, Value]" ("O9.html" ("BOOK" . 889642) ("CONTEXT" . 934178) ("FOLD_CASE" . 934187) ("FULL_PATH" . 932136) ("PAGE" . 934194) ("QUIT" . 932700) ("SUPPRESS_PLUGIN_ERRORS" . 940902) ("TOPICS" . 931860)))
    ("ONLINE_HELP_PDF_INDEX" pro nil (system) "%s [, SearchTerm]" ("O10.html"))
    ("OPENR" pro nil (system) "%s, Unit, File" ("O11.html" ("APPEND" . 889709) ("BUFSIZE" . 889712) ("COMPRESS" . 928372) ("DELETE" . 928370) ("ERROR" . 889720) ("F77_UNFORMATTED" . 889729) ("GET_LUN" . 889739) ("MORE" . 889747) ("NOEXPAND_PATH" . 929441) ("RAWIO" . 934244) ("STDIO" . 930929) ("SWAP_ENDIAN" . 889764) ("SWAP_IF_BIG_ENDIAN" . 889767) ("SWAP_IF_LITTLE_ENDIAN" . 889770) ("VAX_FLOAT" . 889773) ("WIDTH" . 889787) ("XDR" . 889796)))
    ("OPENU" pro nil (system) "%s, Unit, File" ("O11.html" ("APPEND" . 889709) ("BUFSIZE" . 889712) ("COMPRESS" . 928372) ("DELETE" . 928370) ("ERROR" . 889720) ("F77_UNFORMATTED" . 889729) ("GET_LUN" . 889739) ("MORE" . 889747) ("NOEXPAND_PATH" . 929441) ("RAWIO" . 934244) ("STDIO" . 930929) ("SWAP_ENDIAN" . 889764) ("SWAP_IF_BIG_ENDIAN" . 889767) ("SWAP_IF_LITTLE_ENDIAN" . 889770) ("VAX_FLOAT" . 889773) ("WIDTH" . 889787) ("XDR" . 889796)))
    ("OPENW" pro nil (system) "%s, Unit, File" ("O11.html" ("APPEND" . 889709) ("BUFSIZE" . 889712) ("COMPRESS" . 928372) ("DELETE" . 928370) ("ERROR" . 889720) ("F77_UNFORMATTED" . 889729) ("GET_LUN" . 889739) ("MORE" . 889747) ("NOEXPAND_PATH" . 929441) ("RAWIO" . 934244) ("STDIO" . 930929) ("SWAP_ENDIAN" . 889764) ("SWAP_IF_BIG_ENDIAN" . 889767) ("SWAP_IF_LITTLE_ENDIAN" . 889770) ("VAX_FLOAT" . 889773) ("WIDTH" . 889787) ("XDR" . 889796)))
    ("OPLOT" pro nil (system) "%s, [X,] Y" ("O12.html" ("MAX_VALUE" . 889969) ("MIN_VALUE" . 889976) ("NSUM" . 889983) ("POLAR" . 889990) ("THICK" . 889995)) ("graphkeyw2.html" ("CLIP" . 315949) ("COLOR" . 315952) ("LINESTYLE" . 331728) ("NOCLIP" . 323508) ("PSYM" . 316038) ("SYMSIZE" . 316061) ("T3D" . 315956) ("ZVALUE" . 316102)))
    ("OPLOTERR" pro nil (system) "%s, [ X ,] Y , Err [, Psym]" ("O13.html"))
    ("PARTICLE_TRACE" pro nil (system) "%s, Data, Seeds, Verts, Conn [, Normals]" ("P2.html" ("ANISOTROPY" . 1071147) ("INTEGRATION" . 1071149) ("MAX_ITERATIONS" . 1071158) ("MAX_STEPSIZE" . 1071160) ("SEED_NORMAL" . 1071154) ("TOLERANCE" . 1071156) ("UNIFORM" . 1071162)))
    ("PATH_CACHE" pro nil (system) "%s" ("P3.html" ("CLEAR" . 1105531) ("ENABLE" . 1105534) ("REBUILD" . 1105537)))
    ("PLOT" pro nil (system) "%s, [X,] Y" ("P6.html" ("ISOTROPIC" . 948898) ("MAX_VALUE" . 678098) ("MIN_VALUE" . 47057) ("NSUM" . 678100) ("POLAR" . 678103) ("THICK" . 678106) ("XLOG" . 810411) ("YLOG" . 810463) ("YNOZERO" . 810415)) ("graphkeyw2.html" ("BACKGROUND" . 328424) ("CHARSIZE" . 266973) ("CHARTHICK" . 331668) ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("FONT" . 331795) ("LINESTYLE" . 331728) ("NOCLIP" . 323508) ("NODATA" . 316018) ("NOERASE" . 316024) ("NORMAL" . 315963) ("POSITION" . 316026) ("PSYM" . 316038) ("SUBTITLE" . 316057) ("SYMSIZE" . 316061) ("T3D" . 315956) ("TICKLEN" . 332207) ("TITLE" . 332238) ("XCHARSIZE" . 331699) ("XGRIDSTYLE" . 332009) ("XMARGIN" . 332038) ("XMINOR" . 332061) ("XRANGE" . 332090) ("XSTYLE" . 332116) ("XTHICK" . 332298) ("XTICK_GET" . 332321) ("XTICKFORMAT" . 332347) ("XTICKINTERVAL" . 332463) ("XTICKLAYOUT" . 332488) ("XTICKLEN" . 332513) ("XTICKNAME" . 332536) ("XTICKS" . 332559) ("XTICKUNITS" . 332586) ("XTICKV" . 332628) ("XTITLE" . 316100) ("YCHARSIZE" . 331699) ("YGRIDSTYLE" . 332009) ("YMARGIN" . 332038) ("YMINOR" . 332061) ("YRANGE" . 332090) ("YSTYLE" . 332116) ("YTHICK" . 332298) ("YTICK_GET" . 332321) ("YTICKFORMAT" . 332347) ("YTICKINTERVAL" . 332463) ("YTICKLAYOUT" . 332488) ("YTICKLEN" . 332513) ("YTICKNAME" . 332536) ("YTICKS" . 332559) ("YTICKUNITS" . 332586) ("YTICKV" . 332628) ("YTITLE" . 316100) ("ZCHARSIZE" . 331699) ("ZGRIDSTYLE" . 332009) ("ZMARGIN" . 332038) ("ZMINOR" . 332061) ("ZRANGE" . 332090) ("ZSTYLE" . 332116) ("ZTHICK" . 332298) ("ZTICK_GET" . 332321) ("ZTICKFORMAT" . 332347) ("ZTICKINTERVAL" . 332463) ("ZTICKLAYOUT" . 332488) ("ZTICKLEN" . 332513) ("ZTICKNAME" . 332536) ("ZTICKS" . 332559) ("ZTICKUNITS" . 332586) ("ZTICKV" . 332628) ("ZTITLE" . 316100) ("ZVALUE" . 316102)))
    ("PLOT_3DBOX" pro nil (system) "%s, X, Y, Z" ("P7.html" ("GRIDSTYLE" . 137555) ("PSYM" . 137608) ("SOLID_WALLS" . 835291) ("XY_PLANE" . 137639) ("XYSTYLE" . 137642) ("XZ_PLANE" . 137637) ("XZSTYLE" . 137638) ("YZ_PLANE" . 137640) ("YZSTYLE" . 137643)) ("S75.html" ("AX" . 679220) ("AZ" . 679225) ("ZAXIS" . 679256)))
    ("PLOT_FIELD" pro nil (system) "%s, U, V" ("P8.html" ("ASPECT" . 757604) ("LENGTH" . 757607) ("N" . 757610) ("TITLE" . 757613)))
    ("PLOTERR" pro nil (system) "%s, [ X ,] Y , Err" ("P9.html" ("PSYM" . 757654) ("TYPE" . 757647)))
    ("PLOTS" pro nil (system) "%s, X [, Y [, Z]]" ("P10.html" ("CONTINUE" . 678168)) ("graphkeyw2.html" ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("LINESTYLE" . 331728) ("NOCLIP" . 323508) ("NORMAL" . 315963) ("PSYM" . 316038) ("SYMSIZE" . 316061) ("T3D" . 315956) ("THICK" . 316006) ("Z" . 332658)))
    ("POINT_LUN" pro nil (system) "%s, Unit, Position" ("P12.html"))
    ("POLAR_CONTOUR" pro nil (system) "%s, Z, Theta, R" ("P13.html" ("SHOW_TRIANGULATION" . 128404)) ("C40.html" ("C_ANNOTATION" . 1023103) ("C_CHARSIZE" . 676279) ("C_CHARTHICK" . 905138) ("C_COLORS" . 676281) ("C_LINESTYLE" . 676292) ("C_ORIENTATION" . 676298) ("C_SPACING" . 676300) ("C_THICK" . 676302) ("CLOSED" . 676304) ("FILL" . 676308) ("IRREGULAR" . 879096) ("LEVELS" . 927695) ("MAX_VALUE" . 676323) ("MIN_VALUE" . 47033) ("NLEVELS" . 676325) ("OVERPLOT" . 861732) ("PATH_DATA_COORDS" . 879089) ("TRIANGULATION" . 746344) ("XLOG" . 158329) ("YLOG" . 158344) ("ZAXIS" . 676344)))
    ("POLYFILL" pro nil (system) "%s, X [, Y [, Z]]" ("P19.html" ("IMAGE_COORD" . 678254) ("IMAGE_INTERP" . 678256) ("LINE_FILL" . 678258) ("PATTERN" . 678260) ("SPACING" . 678269) ("TRANSPARENT" . 678271)) ("graphkeyw2.html" ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("LINESTYLE" . 331728) ("NOCLIP" . 323508) ("NORMAL" . 315963) ("ORIENTATION" . 315964) ("T3D" . 315956) ("THICK" . 316006) ("Z" . 332658)))
    ("POLYWARP" pro nil (system) "%s, Xi, Yi, Xo, Yo, Degree, Kx, Ky" ("P22.html" ("DOUBLE" . 1075034) ("STATUS" . 1075060)))
    ("POPD" pro nil (system) "%s" ("P23.html"))
    ("POWELL" pro nil (system) "%s, P, Xi, Ftol, Fmin, Func" ("P24.html" ("DOUBLE" . 51467) ("ITER" . 51470) ("ITMAX" . 51473)))
    ("PRINT" pro nil (system) "%s [, Expr1, ..., Exprn]" ("P26.html" ("AM_PM" . 678362) ("DAYS_OF_WEEK" . 1015582) ("FORMAT" . 1015576) ("MONTHS" . 1015619) ("STDIO_NON_FINITE" . 1015513)))
    ("PRINTD" pro nil (system) "%s" ("P27.html"))
    ("PRINTF" pro nil (system) "%s [, Unit, Expr1, ..., Exprn]" ("P26.html" ("AM_PM" . 678362) ("DAYS_OF_WEEK" . 1015582) ("FORMAT" . 1015576) ("MONTHS" . 1015619) ("STDIO_NON_FINITE" . 1015513)))
    ("PROFILER" pro nil (system) "%s [, Module]" ("P31.html" ("CLEAR" . 900205) ("DATA" . 1088814) ("OUTPUT" . 900155) ("REPORT" . 900194) ("RESET" . 900195) ("SYSTEM" . 900159)))
    ("PROFILES" pro nil (system) "%s, Image" ("P32.html" ("ORDER" . 757719) ("SX" . 757722) ("SY" . 757725) ("WSIZE" . 757728)))
    ("PS_SHOW_FONTS" pro nil (system) "%s" ("P34.html" ("NOLATIN" . 762026)))
    ("PSAFM" pro nil (system) "%s, Input_Filename, Output_Filename" ("P35.html"))
    ("PSEUDO" pro nil (system) "%s, Litlo, Lithi, Satlo, Sathi, Hue, Loops [, Colr]" ("P36.html"))
    ("PTR_FREE" pro nil (system) "%s, P1, ... ..., Pn" ("P37.html"))
    ("PUSHD" pro nil (system) "%s, Dir" ("P41.html"))
    ("QHULL" pro nil (system) "%s, V, Tr or, %s, V0 , V1, [, V2 ... [, V6] ] , Tr" ("Q2.html" ("BOUNDS" . 1073465) ("CONNECTIVITY" . 1073467) ("DELAUNAY" . 1073473) ("SPHERE" . 1073475) ("VDIAGRAM" . 1073477) ("VNORMALS" . 1073481) ("VVERTICES" . 1073483)))
    ("RDPIX" pro nil (system) "%s, Image [, X0, Y0]" ("R7.html"))
    ("READ" pro nil (system) "%s, [Prompt,] Var1, ..., Varn" ("R8.html" ("AM_PM" . 1015647) ("DAYS_OF_WEEK" . 1015649) ("FORMAT" . 1015645) ("MONTHS" . 1015670) ("PROMPT" . 863855)))
    ("READ_GIF" pro nil (system) "%s, Filename, Image [, R, G, B]" ("R13.html" ("CLOSE" . 1165757) ("MULTIPLE" . 1165763)))
    ("READ_INTERFILE" pro nil (system) "%s, File, Data" ("R15.html"))
    ("READ_JPEG" pro nil (system) "%s [, Filename] , Image [, Colortable]" ("R16.html" ("BUFFER" . 279694) ("COLORS" . 279696) ("DITHER" . 279697) ("GRAYSCALE" . 1064444) ("ORDER" . 868283) ("TRUE" . 279699) ("TWO_PASS_QUANTIZE" . 279700) ("UNIT" . 279701)))
    ("READ_PICT" pro nil (system) "%s, Filename, Image [, R, G, B]" ("R19.html"))
    ("READ_PPM" pro nil (system) "%s, Filename, Image" ("R21.html" ("MAXVAL" . 67809)))
    ("READ_SRF" pro nil (system) "%s, Filename, Image [, R, G, B]" ("R23.html"))
    ("READ_WAVE" pro nil (system) "%s, File, Variables, Names, Dimensions" ("R27.html" ("MESHNAMES" . 756240)))
    ("READ_X11_BITMAP" pro nil (system) "%s, File, Bitmap [, X, Y]" ("R28.html" ("EXPAND_TO_BYTES" . 756264)))
    ("READF" pro nil (system) "%s, [Prompt,] Unit, Var1, ..., Varn" ("R8.html" ("AM_PM" . 1015647) ("DAYS_OF_WEEK" . 1015649) ("FORMAT" . 1015645) ("MONTHS" . 1015670) ("PROMPT" . 863855)))
    ("READS" pro nil (system) "%s, Input, Var1, ..., Varn" ("R30.html" ("AM_PM" . 1015707) ("DAYS_OF_WEEK" . 1015709) ("FORMAT" . 678457) ("MONTHS" . 1015728)))
    ("READU" pro nil (system) "%s, Unit, Var1, ..., Varn" ("R31.html" ("TRANSFER_COUNT" . 678471)))
    ("REDUCE_COLORS" pro nil (system) "%s, Image, Values" ("R36.html"))
    ("REGISTER_CURSOR" pro nil (system) "%s, Name, Image" ("R39.html" ("HOTSPOT" . 1108842) ("MASK" . 1108840) ("OVERWRITE" . 1108844)))
    ("REPLICATE_INPLACE" pro nil (system) "%s, X, Value [, D1, Loc1 [, D2, Range]]" ("R43.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("RESOLVE_ALL" pro nil (system) "%s" ("R44.html" ("CLASS" . 1114080) ("CONTINUE_ON_ERROR" . 1114078) ("QUIET" . 1014991) ("RESOLVE_EITHER" . 1166218) ("RESOLVE_FUNCTION" . 1166223) ("RESOLVE_PROCEDURE" . 1166248) ("SKIP_ROUTINES" . 1166262) ("UNRESOLVED" . 1166255)))
    ("RESOLVE_ROUTINE" pro nil (system) "%s, Name" ("R45.html" ("COMPILE_FULL_FILE" . 1069898) ("EITHER" . 1073138) ("IS_FUNCTION" . 1069896) ("NO_RECOMPILE" . 1069991)))
    ("RESTORE" pro nil (system) "%s [[, Filename]]" ("R46.html" ("DESCRIPTION" . 1135778) ("FILENAME" . 678568) ("RELAXED_STRUCTURE_ASSIGNMENT" . 900571) ("RESTORED_OBJECTS" . 900564) ("VERBOSE" . 678570)))
    ("RETALL" pro nil (system) "%s" ("R47.html"))
    ("SAVE" pro nil (system) "%s [, Var1, ..., Varn]" ("S2.html" ("ALL" . 678631) ("COMM" . 678633) ("COMPRESS" . 1074405) ("DESCRIPTION" . 678635) ("FILENAME" . 1199210) ("ROUTINES" . 678637) ("SYSTEM_VARIABLES" . 678639) ("VARIABLES" . 678642) ("VERBOSE" . 678644)))
    ("SCALE3" pro nil (system) "%s" ("S4.html" ("AX" . 787108) ("AZ" . 787111) ("XRANGE" . 787099) ("YRANGE" . 787102) ("ZRANGE" . 787105)))
    ("SCALE3D" pro nil (system) "%s" ("S5.html"))
    ("SET_PLOT" pro nil (system) "%s, Device" ("S11.html" ("COPY" . 862592) ("INTERPOLATE" . 862599)))
    ("SET_SHADING" pro nil (system) "%s" ("S12.html" ("GOURAUD" . 678682) ("LIGHT" . 678685) ("REJECT" . 678687) ("VALUES" . 678689)))
    ("SETENV" pro nil (system) "%s, Environment_Expression" ("S13.html"))
    ("SETUP_KEYS" pro nil (system) "%s" ("S14.html" ("ANSI" . 43203) ("APP_KEYPAD" . 43217) ("EIGHTBIT" . 1015422) ("HP9000" . 43209) ("IBM" . 1015421) ("MIPS" . 43211) ("NUM_KEYPAD" . 43219) ("SGI" . 43215) ("SUN" . 43205) ("VT200" . 43207)))
    ("SHADE_SURF" pro nil (system) "%s, Z [, X, Y]" ("S16.html" ("AX" . 678754) ("AZ" . 678759) ("IMAGE" . 678761) ("MAX_VALUE" . 678763) ("MIN_VALUE" . 47127) ("PIXELS" . 844042) ("SAVE" . 678765) ("SHADES" . 678767) ("XLOG" . 158361) ("YLOG" . 158393)) ("graphkeyw2.html" ("CHARSIZE" . 266973) ("CHARTHICK" . 331668) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("FONT" . 331795) ("NODATA" . 316018) ("NORMAL" . 315963) ("POSITION" . 316026) ("SUBTITLE" . 316057) ("T3D" . 315956) ("THICK" . 316006) ("TICKLEN" . 332207) ("TITLE" . 332238) ("XCHARSIZE" . 331699) ("XGRIDSTYLE" . 332009) ("XMARGIN" . 332038) ("XMINOR" . 332061) ("XRANGE" . 332090) ("XSTYLE" . 332116) ("XTHICK" . 332298) ("XTICK_GET" . 332321) ("XTICKFORMAT" . 332347) ("XTICKINTERVAL" . 332463) ("XTICKLAYOUT" . 332488) ("XTICKLEN" . 332513) ("XTICKNAME" . 332536) ("XTICKS" . 332559) ("XTICKUNITS" . 332586) ("XTICKV" . 332628) ("XTITLE" . 316100) ("YCHARSIZE" . 331699) ("YGRIDSTYLE" . 332009) ("YMARGIN" . 332038) ("YMINOR" . 332061) ("YRANGE" . 332090) ("YSTYLE" . 332116) ("YTHICK" . 332298) ("YTICK_GET" . 332321) ("YTICKFORMAT" . 332347) ("YTICKINTERVAL" . 332463) ("YTICKLAYOUT" . 332488) ("YTICKLEN" . 332513) ("YTICKNAME" . 332536) ("YTICKS" . 332559) ("YTICKUNITS" . 332586) ("YTICKV" . 332628) ("YTITLE" . 316100) ("ZCHARSIZE" . 331699) ("ZGRIDSTYLE" . 332009) ("ZMARGIN" . 332038) ("ZMINOR" . 332061) ("ZRANGE" . 332090) ("ZSTYLE" . 332116) ("ZTHICK" . 332298) ("ZTICK_GET" . 332321) ("ZTICKFORMAT" . 332347) ("ZTICKINTERVAL" . 332463) ("ZTICKLAYOUT" . 332488) ("ZTICKLEN" . 332513) ("ZTICKNAME" . 332536) ("ZTICKS" . 332559) ("ZTICKUNITS" . 332586) ("ZTICKV" . 332628) ("ZTITLE" . 316100) ("ZVALUE" . 316102)))
    ("SHADE_SURF_IRR" pro nil (system) "%s, Z, X, Y" ("S17.html" ("AX" . 787162) ("AZ" . 787165) ("IMAGE" . 787168) ("PLIST" . 787171) ("T3D" . 867401)))
    ("SHADE_VOLUME" pro nil (system) "%s, Volume, Value, Vertex, Poly" ("S18.html" ("LOW" . 678801) ("SHADES" . 678803) ("VERBOSE" . 678805) ("XRANGE" . 678807) ("YRANGE" . 678809) ("ZRANGE" . 678811)))
    ("SHMMAP" pro nil (system) "%s [, SegmentName] [, D1, ..., D8]" ("S21.html" ("BYTE" . 1143213) ("COMPLEX" . 1143215) ("DCOMPLEX" . 1143217) ("DESTROY_SEGMENT" . 1143219) ("DIMENSION" . 1143226) ("DOUBLE" . 1143228) ("FILENAME" . 1143230) ("FLOAT" . 1143234) ("GET_NAME" . 1143237) ("GET_OS_HANDLE" . 1143240) ("INTEGER" . 1143245) ("L64" . 1143247) ("LONG" . 1143252) ("OFFSET" . 1143254) ("OS_HANDLE" . 1143259) ("PRIVATE" . 1143277) ("SIZE" . 1143281) ("SYSV" . 1143286) ("TEMPLATE" . 1143291) ("TYPE" . 1143293) ("UINT" . 1143298) ("UL64" . 1143302) ("ULONG" . 1143300)))
    ("SHMUNMAP" pro nil (system) "%s, SegmentName" ("S22.html"))
    ("SHOW3" pro nil (system) "%s, Image [, X, Y]" ("S24.html" ("E_CONTOUR" . 863032) ("E_SURFACE" . 863036) ("INTERP" . 862964) ("SSCALE" . 787203)))
    ("SHOWFONT" pro nil (system) "%s, Font, Name" ("S25.html" ("ENCAPSULATED" . 762072) ("TT_FONT" . 901959)))
    ("SKIP_LUN" pro nil (system) "%s, FromUnit, [, Num]" ("S32.html" ("EOF" . 1143762) ("LINES" . 1143765) ("TRANSFER_COUNT" . 1143767)))
    ("SLICER3" pro nil (system) "%s [, hData3D]" ("S33.html" ("DATA_NAMES" . 914863) ("DETACH" . 914866) ("GROUP" . 914869) ("MODAL" . 914872)))
    ("SLIDE_IMAGE" pro nil (system) "%s [, Image]" ("S34.html" ("BLOCK" . 923990) ("CONGRID" . 787344) ("FULL_WINDOW" . 787347) ("GROUP" . 787350) ("ORDER" . 787353) ("REGISTER" . 787356) ("RETAIN" . 787360) ("SHOW_FULL" . 787366) ("SLIDE_WINDOW" . 787363) ("TITLE" . 900068) ("TOP_ID" . 787369) ("XSIZE" . 787374) ("XVISIBLE" . 787377) ("YSIZE" . 787380) ("YVISIBLE" . 787383)))
    ("SOCKET" pro nil (system) "%s, Unit, Host, Port" ("S37.html" ("CONNECT_TIMEOUT" . 1098145) ("ERROR" . 1098148) ("GET_LUN" . 1142975) ("RAWIO" . 1098160) ("READ_TIMEOUT" . 1098166) ("STDIO" . 1133828) ("SWAP_ENDIAN" . 1098168) ("SWAP_IF_BIG_ENDIAN" . 1098171) ("SWAP_IF_LITTLE_ENDIAN" . 1098175) ("WIDTH" . 1098179) ("WRITE_TIMEOUT" . 1098187)))
    ("SPAWN" pro nil (system) "%s [, Command [, Result] [, ErrResult]]" ("S39.html" ("COUNT" . 678969) ("EXIT_STATUS" . 678971) ("HIDE" . 1133996) ("LOG_OUTPUT" . 1134006) ("NOSHELL" . 1108410) ("NOTTYRESET" . 1134017) ("NOWAIT" . 1134051) ("NULL_STDIN" . 1134151) ("PID" . 1084167) ("SH" . 1133965) ("STDERR" . 1133968) ("UNIT" . 1133975)))
    ("SPH_4PNT" pro nil (system) "%s, X, Y, Z, Xc, Yc, Zc, R" ("S40.html" ("DOUBLE" . 1094107)))
    ("SPLINE_P" pro nil (system) "%s, X, Y, Xr, Yr" ("S46.html" ("DOUBLE" . 1187959) ("INTERVAL" . 758561) ("TAN0" . 758564) ("TAN1" . 758567)))
    ("STOP" pro nil (system) "%s [, Expr1, ..., Exprn]" ("S54.html"))
    ("STREAMLINE" pro nil (system) "%s, Verts, Conn, Normals, Outverts, Outconn" ("S58.html" ("ANISOTROPY" . 1078861) ("PROFILE" . 1078865) ("SIZE" . 1078863)))
    ("STRETCH" pro nil (system) "%s [, Low, High [, Gamma]]" ("S60.html" ("CHOP" . 759533)))
    ("STRPUT" pro nil (system) "%s, Destination, Source [, Position]" ("S69.html"))
    ("STRUCT_ASSIGN" pro nil (system) "%s, Source, Destination" ("S72.html" ("NOZERO" . 1074356) ("VERBOSE" . 901018)))
    ("STRUCT_HIDE" pro nil (system) "%s, Arg1 [, Arg2, ..., Argn]" ("S73.html"))
    ("SURFACE" pro nil (system) "%s, Z [, X, Y]" ("S75.html" ("AX" . 679220) ("AZ" . 679225) ("BOTTOM" . 679227) ("HORIZONTAL" . 679229) ("LEGO" . 716839) ("LOWER_ONLY" . 679231) ("MAX_VALUE" . 679233) ("MIN_VALUE" . 47161) ("SAVE" . 679235) ("SHADES" . 679245) ("SKIRT" . 679247) ("UPPER_ONLY" . 679250) ("XLOG" . 158409) ("YLOG" . 158414) ("ZAXIS" . 679256) ("ZLOG" . 862016)))
    ("SURFR" pro nil (system) "%s" ("S76.html" ("AX" . 787417) ("AZ" . 787420)))
    ("SVDC" pro nil (system) "%s, A, W, U, V" ("S77.html" ("COLUMN" . 58767) ("DOUBLE" . 52115) ("ITMAX" . 1095860)))
    ("SWAP_ENDIAN_INPLACE" pro nil (system) "%s, Variable" ("S81.html" ("SWAP_IF_BIG_ENDIAN" . 1143824) ("SWAP_IF_LITTLE_ENDIAN" . 1143826)))
    ("T3D" pro nil (system) "%s [, Array]" ("T3.html" ("MATRIX" . 787453) ("OBLIQUE" . 1076313) ("PERSPECTIVE" . 787459) ("RESET" . 787462) ("ROTATE" . 787465) ("SCALE" . 787468) ("TRANSLATE" . 787471) ("XYEXCH" . 787474) ("XZEXCH" . 787477) ("YZEXCH" . 787480)))
    ("TEK_COLOR" pro nil (system) "%s [, Start_Index, Colors]" ("T7.html"))
    ("THREED" pro nil (system) "%s, A [, Sp]" ("T13.html" ("TITLE" . 787515) ("XTITLE" . 787518) ("YTITLE" . 787521)))
    ("TIME_TEST2" pro nil (system) "%s [, Filename]" ("T14.html"))
    ("TRIANGULATE" pro nil (system) "%s, X, Y, Triangles [, B]" ("T21.html" ("CONNECTIVITY" . 679547) ("DEGREES" . 126686) ("FVALUE" . 126695) ("REPEATS" . 679555) ("SPHERE" . 126681)))
    ("TRIQL" pro nil (system) "%s, D, E, A" ("T23.html" ("DOUBLE" . 52221)))
    ("TRIRED" pro nil (system) "%s, A, D, E" ("T24.html" ("DOUBLE" . 52282)))
    ("TRUNCATE_LUN" pro nil (system) "%s, Unit1, ..., Unitn" ("T26.html"))
    ("TV" pro nil (system) "%s, Image [, Position] or %s, Image [, X, Y [, Channel]]" ("T31.html" ("CENTIMETERS" . 679682) ("INCHES" . 679690) ("ORDER" . 679694) ("TRUE" . 679698) ("WORDS" . 679701) ("XSIZE" . 679703) ("YSIZE" . 679705)) ("graphkeyw2.html" ("CHANNEL" . 315931) ("DATA" . 315961) ("DEVICE" . 315977) ("NORMAL" . 315963) ("T3D" . 315956) ("Z" . 332658)))
    ("TVCRS" pro nil (system) "%s [, ON_OFF] or %s [, X, Y]" ("T32.html" ("CENTIMETERS" . 679732) ("HIDE_CURSOR" . 817846) ("INCHES" . 817861)) ("graphkeyw2.html" ("DATA" . 315961) ("DEVICE" . 315977) ("NORMAL" . 315963) ("T3D" . 315956) ("Z" . 332658)))
    ("TVLCT" pro nil (system) "%s, V1, V2, V3 [, Start]" ("T33.html" ("GET" . 844142) ("HLS" . 679761) ("HSV" . 679763)))
    ("TVSCL" pro nil (system) "%s, Image [, Position] or %s, Image [, X, Y [, Channel]]" ("T35.html" ("CENTIMETERS") ("INCHES") ("NAN" . 902069) ("ORDER") ("TOP" . 218988) ("TRUE") ("WORDS") ("XSIZE") ("YSIZE")) ("T31.html" ("CENTIMETERS" . 679682) ("INCHES" . 679690) ("ORDER" . 679694) ("TRUE" . 679698) ("WORDS" . 679701) ("XSIZE" . 679703) ("YSIZE" . 679705)) ("graphkeyw2.html" ("CHANNEL" . 315931) ("DATA" . 315961) ("DEVICE" . 315977) ("NORMAL" . 315963) ("T3D" . 315956) ("Z" . 332658)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("USERSYM" pro nil (system) "%s, X [, Y]" ("U12.html" ("COLOR" . 886945) ("FILL" . 886948) ("THICK" . 886951)))
    ("VECTOR_FIELD" pro nil (system) "%s, Field, Outverts, Outconn" ("V3.html" ("ANISOTROPY" . 957083) ("SCALE" . 957085) ("VERTICES" . 957087)))
    ("VEL" pro nil (system) "%s, U, V" ("V4.html" ("LENGTH" . 956021) ("NSTEPS" . 956033) ("NVECS" . 787550) ("TITLE" . 956041) ("XMAX" . 787553)))
    ("VELOVECT" pro nil (system) "%s, U, V [, X, Y]" ("V5.html" ("COLOR" . 787592) ("DOTS" . 787595) ("LENGTH" . 787598) ("MISSING" . 787601) ("OVERPLOT" . 957555)) ("P6.html" ("ISOTROPIC" . 948898) ("MAX_VALUE" . 678098) ("MIN_VALUE" . 47057) ("NSUM" . 678100) ("POLAR" . 678103) ("THICK" . 678106) ("XLOG" . 810411) ("YLOG" . 810463) ("YNOZERO" . 810415)))
    ("VORONOI" pro nil (system) "%s, X, Y, I0, C, Xp, Yp, Rect" ("V8.html"))
    ("WAIT" pro nil (system) "%s, Seconds" ("W.html"))
    ("WDELETE" pro nil (system) "%s [, Window_Index [, ...]]" ("W5.html"))
    ("WF_DRAW" pro nil (system) "%s, X, Y" ("W6.html" ("COLD" . 787681) ("COLOR" . 787684) ("CONVERGENCE" . 787687) ("DATA" . 787690) ("DEVICE" . 787693) ("FRONT_TYPE" . 787696) ("INTERVAL" . 787699) ("NORMAL" . 787702) ("OCCLUDED" . 787705) ("PSYM" . 787708) ("STATIONARY" . 787714) ("SYM_HT" . 787717) ("SYM_LEN" . 787720) ("THICK" . 787723) ("WARM" . 787726)))
    ("WIDGET_CONTROL" pro nil (system) "%s [, Widget_ID]" ("W13.html" ("ALIGNMENT" . 894840) ("ALL_TABLE_EVENTS" . 894849) ("ALL_TEXT_EVENTS" . 680079) ("AM_PM" . 949789) ("APPEND" . 886776) ("BAD_ID" . 680083) ("BASE_SET_TITLE" . 977104) ("BITMAP" . 1077396) ("CANCEL_BUTTON" . 910691) ("CLEAR_EVENTS" . 978647) ("COLUMN_LABELS" . 894928) ("COLUMN_WIDTHS" . 894930) ("COMBOBOX_ADDITEM" . 981369) ("COMBOBOX_DELETEITEM" . 981434) ("COMBOBOX_INDEX" . 981376) ("CONTEXT_EVENTS" . 949802) ("DAYS_OF_WEEK" . 970733) ("DEFAULT_BUTTON" . 909921) ("DEFAULT_FONT" . 680087) ("DELAY_DESTROY" . 680090) ("DELETE_COLUMNS" . 894963) ("DELETE_ROWS" . 919067) ("DESTROY" . 680094) ("DRAW_BUTTON_EVENTS" . 680097) ("DRAW_EXPOSE_EVENTS" . 907371) ("DRAW_KEYBOARD_EVENTS" . 985153) ("DRAW_MOTION_EVENTS" . 680099) ("DRAW_VIEWPORT_EVENTS" . 680101) ("DRAW_XSIZE" . 58243) ("DRAW_YSIZE" . 58244) ("DYNAMIC_RESIZE" . 192830) ("EDIT_CELL" . 895011) ("EDITABLE" . 889314) ("EVENT_FUNC" . 895036) ("EVENT_PRO" . 680108) ("FORMAT" . 895067) ("FUNC_GET_VALUE" . 680113) ("GET_DRAW_VIEW" . 680115) ("GET_UVALUE" . 680117) ("GET_VALUE" . 680122) ("GROUP_LEADER" . 933268) ("HOURGLASS" . 680134) ("ICONIFY" . 680136) ("INPUT_FOCUS" . 680138) ("INSERT_COLUMNS" . 895129) ("INSERT_ROWS" . 895131) ("KBRD_FOCUS_EVENTS" . 919052) ("KILL_NOTIFY" . 680140) ("MANAGED" . 680144) ("MAP" . 680146) ("MONTHS" . 949815) ("MULTIPLE_PROPERTIES" . 1100768) ("NO_COPY" . 680150) ("NO_NEWLINE" . 680152) ("NOTIFY_REALIZE" . 67586) ("PRO_SET_VALUE" . 680154) ("PROPERTYSHEET_SETSELECTED" . 1070765) ("PUSHBUTTON_EVENTS" . 1020091) ("REALIZE" . 680156) ("REFRESH_PROPERTY" . 1018381) ("RESET" . 1018400) ("ROW_HEIGHTS" . 895150) ("ROW_LABELS" . 895148) ("SCR_XSIZE" . 58190) ("SCR_YSIZE" . 58191) ("SEND_EVENT" . 58210) ("SENSITIVE" . 680164) ("SET_BUTTON" . 680167) ("SET_COMBOBOX_SELECT" . 981513) ("SET_DRAW_VIEW" . 680169) ("SET_DROPLIST_SELECT" . 680172) ("SET_LIST_SELECT" . 58235) ("SET_LIST_TOP" . 680175) ("SET_SLIDER_MAX" . 680177) ("SET_SLIDER_MIN" . 680179) ("SET_TAB_CURRENT" . 977118) ("SET_TAB_MULTILINE" . 977124) ("SET_TABLE_SELECT" . 895216) ("SET_TABLE_VIEW" . 895208) ("SET_TEXT_SELECT" . 680181) ("SET_TEXT_TOP_LINE" . 680185) ("SET_TREE_BITMAP" . 978535) ("SET_TREE_EXPANDED" . 978542) ("SET_TREE_SELECT" . 978548) ("SET_TREE_VISIBLE" . 978561) ("SET_UNAME" . 1095671) ("SET_UVALUE" . 949285) ("SET_VALUE" . 680190) ("SHOW" . 680199) ("TAB_MODE" . 1069607) ("TABLE_BLANK" . 1069681) ("TABLE_DISJOINT_SELECTION" . 987414) ("TABLE_XSIZE" . 895238) ("TABLE_YSIZE" . 895244) ("TIMER" . 680201) ("TLB_GET_OFFSET" . 680204) ("TLB_GET_SIZE" . 680206) ("TLB_ICONIFY_EVENTS" . 984722) ("TLB_KILL_REQUEST_EVENTS" . 192837) ("TLB_MOVE_EVENTS" . 984735) ("TLB_SET_TITLE" . 680208) ("TLB_SET_XOFFSET" . 680210) ("TLB_SET_YOFFSET" . 680212) ("TLB_SIZE_EVENTS" . 984752) ("TOOLTIP" . 982093) ("TRACKING_EVENTS" . 58183) ("UNITS" . 895316) ("UPDATE" . 680214) ("USE_TABLE_SELECT" . 934621) ("USE_TEXT_SELECT" . 192856) ("X_BITMAP_EXTRA" . 680216) ("XOFFSET" . 58269) ("XSIZE" . 58220) ("YOFFSET" . 58279) ("YSIZE" . 58221)))
    ("WIDGET_DISPLAYCONTEXTMENU" pro nil (system) "%s, Parent, X, Y, ContextBase_ID" ("W14.html"))
    ("WINDOW" pro nil (system) "%s [, Window_Index]" ("W27.html" ("COLORS" . 896410) ("FREE" . 680620) ("PIXMAP" . 680622) ("RETAIN" . 680624) ("TITLE" . 680625) ("XPOS" . 680628) ("XSIZE" . 680635) ("YPOS" . 680633) ("YSIZE" . 680637)))
    ("WRITE_BMP" pro nil (system) "%s, Filename, Image[, R, G, B]" ("W28.html" ("FOUR_BIT" . 756441) ("HEADER_DEFINE" . 756447) ("IHDR" . 756444) ("RGB" . 964751)))
    ("WRITE_GIF" pro nil (system) "%s, Filename, Image[, R, G, B]" ("W29.html" ("CLOSE" . 1068115) ("MULTIPLE" . 1068121)))
    ("WRITE_IMAGE" pro nil (system) "%s, Filename, Format, Data [, Red, Green, Blue]" ("W30.html" ("APPEND" . 961233)))
    ("WRITE_JPEG" pro nil (system) "%s [, Filename] , Image" ("W31.html" ("ORDER" . 279735) ("PROGRESSIVE" . 912025) ("QUALITY" . 279736) ("TRUE" . 279737) ("UNIT" . 896438)))
    ("WRITE_JPEG2000" pro nil (system) "%s, Filename, Image [, Red, Green, Blue]" ("W32.html" ("N_LAYERS" . 1112356) ("N_LEVELS" . 1112359) ("ORDER" . 1112362) ("REVERSIBLE" . 1112365)))
    ("WRITE_NRIF" pro nil (system) "%s, File, Image [, R, G, B]" ("W33.html"))
    ("WRITE_PICT" pro nil (system) "%s, Filename [, Image, R, G, B]" ("W34.html"))
    ("WRITE_PNG" pro nil (system) "%s, Filename, Image[, R, G, B]" ("W35.html" ("ORDER" . 950656) ("TRANSPARENT" . 950659) ("VERBOSE" . 964556)))
    ("WRITE_PPM" pro nil (system) "%s, Filename, Image" ("W36.html" ("ASCII" . 67923)))
    ("WRITE_SPR" pro nil (system) "%s, AS, Filename" ("W37.html"))
    ("WRITE_SRF" pro nil (system) "%s, Filename [, Image, R, G, B]" ("W38.html" ("ORDER" . 756556) ("WRITE_32" . 756559)))
    ("WRITE_TIFF" pro nil (system) "%s, Filename [, Image]" ("W40.html" ("APPEND" . 945440) ("BITS_PER_SAMPLE" . 945448) ("BLUE" . 960346) ("CMYK" . 1049851) ("COMPRESSION" . 972526) ("DESCRIPTION" . 1049872) ("DOCUMENT_NAME" . 1049881) ("DOT_RANGE" . 1049890) ("FLOAT" . 945539) ("GEOTIFF" . 945456) ("GREEN" . 960346) ("ICC_PROFILE" . 1049899) ("LONG" . 945853) ("ORIENTATION" . 972561) ("PHOTOSHOP" . 1049908) ("PLANARCONFIG" . 896473) ("RED" . 960346) ("SHORT" . 945559) ("UNITS" . 960431) ("VERBOSE" . 972627) ("XPOSITION" . 1063829) ("XRESOL" . 896478) ("YPOSITION" . 1063850) ("YRESOL" . 917320)))
    ("WRITE_WAV" pro nil (system) "%s, Filename, Data, Rate" ("W41.html"))
    ("WRITE_WAVE" pro nil (system) "%s, File, Array" ("W42.html" ("BIN" . 756580) ("DATANAME" . 756583) ("MESHNAME" . 756586) ("NOMESHDEF" . 756589) ("VECTOR" . 756592)))
    ("WRITEU" pro nil (system) "%s, Unit, Expr1 ..., Exprn" ("W43.html" ("TRANSFER_COUNT" . 680669)))
    ("WSET" pro nil (system) "%s [, Window_Index]" ("W44.html"))
    ("WSHOW" pro nil (system) "%s [, Window_Index [, Show]]" ("W45.html" ("ICONIC" . 680709)))
    ("WV_APPLET" pro nil (system) "%s [, Input]" ("ref4.html" ("ARRAY" . 1004583) ("GROUP_LEADER" . 1004841) ("NO_SPLASH" . 1004848) ("TOOLS" . 1004856) ("WAVELETS" . 1005269)))
    ("WV_IMPORT_DATA" pro nil (system) "%s, Data" ("ref16.html" ("MESSAGE_OUT" . 1006957) ("PARENT" . 1008033)))
    ("WV_IMPORT_WAVELET" pro nil (system) "%s [, Wavelet]" ("ref17.html" ("RESET" . 1007019)))
    ("XBM_EDIT" pro nil (system) "%s" ("X.html" ("BLOCK" . 937479) ("FILENAME" . 762711) ("GROUP" . 762714) ("XSIZE" . 762717) ("YSIZE" . 762720)))
    ("XDISPLAYFILE" pro nil (system) "%s, Filename" ("X2.html" ("BLOCK" . 937490) ("DONE_BUTTON" . 960338) ("EDITABLE" . 960341) ("FONT" . 960336) ("GROUP" . 762749) ("HEIGHT" . 762752) ("MODAL" . 933305) ("TEXT" . 762755) ("TITLE" . 762758) ("WIDTH" . 762761) ("WTEXT" . 960359)))
    ("XDXF" pro nil (system) "%s [, Filename]" ("X3.html" ("BLOCK" . 976345) ("GROUP" . 976354) ("SCALE" . 976358) ("TEST" . 976360)))
    ("XINTERANIMATE" pro nil (system) "%s [, Rate]" ("X5.html" ("BLOCK" . 964691) ("CLOSE" . 894369) ("CYCLE" . 894339) ("FRAME" . 894353) ("GROUP" . 964285) ("IMAGE" . 894356) ("KEEP_PIXMAPS" . 894375) ("MODAL" . 964292) ("MPEG_BITRATE" . 964699) ("MPEG_CLOSE" . 941497) ("MPEG_FILENAME" . 934000) ("MPEG_IFRAME_GAP" . 964723) ("MPEG_MOTION_VEC_LENGTH" . 964730) ("MPEG_OPEN" . 934051) ("MPEG_QUALITY" . 964762) ("ORDER" . 894359) ("SET" . 894336) ("SHOWLOAD" . 894342) ("TITLE" . 894348) ("TRACK" . 894345) ("WINDOW" . 894362) ("XOFFSET" . 894378) ("YOFFSET" . 894381)))
    ("XLOADCT" pro nil (system) "%s" ("X6.html" ("BLOCK" . 937520) ("BOTTOM" . 937526) ("FILE" . 937512) ("GROUP" . 959363) ("MODAL" . 930516) ("NCOLORS" . 930518) ("SILENT" . 761913) ("UPDATECALLBACK" . 950093) ("UPDATECBDATA" . 950095) ("USE_CURRENT" . 761916)))
    ("XMANAGER" pro nil (system) "%s [, Name, ID]" ("X7.html" ("CATCH" . 919187) ("CLEANUP" . 762794) ("EVENT_HANDLER" . 762797) ("GROUP_LEADER" . 762800) ("JUST_REG" . 762804) ("NO_BLOCK" . 921241)))
    ("XMNG_TMPL" pro nil (system) "%s" ("X8.html" ("BLOCK" . 937533) ("GROUP" . 762854)))
    ("XMTOOL" pro nil (system) "%s" ("X9.html" ("BLOCK" . 937544) ("GROUP" . 762874)))
    ("XOBJVIEW" pro nil (system) "%s, Obj" ("X10.html" ("BACKGROUND" . 956927) ("BLOCK" . 964889) ("DOUBLE_VIEW" . 956930) ("GROUP" . 960389) ("JUST_REG" . 959168) ("MODAL" . 988927) ("REFRESH" . 959524) ("RENDERER" . 980622) ("SCALE" . 969430) ("STATIONARY" . 959520) ("TEST" . 959458) ("TITLE" . 959454) ("TLB" . 1013972) ("XOFFSET" . 959432) ("XSIZE" . 1000024) ("YOFFSET" . 973883) ("YSIZE" . 1000026)))
    ("XOBJVIEW_ROTATE" pro nil (system) "%s, Axis, Angle" ("X11.html" ("PREMULTIPLY" . 984371)))
    ("XOBJVIEW_WRITE_IMAGE" pro nil (system) "%s, Filename, Format" ("X12.html" ("DIMENSIONS" . 984402)))
    ("XPALETTE" pro nil (system) "%s" ("X13.html" ("BLOCK" . 937555) ("GROUP" . 761941) ("UPDATECALLBACK" . 949914) ("UPDATECBDATA" . 949916)))
    ("XPCOLOR" pro nil (system) "%s" ("X14.html" ("GROUP" . 976510)))
    ("XPLOT3D" pro nil (system) "%s, X, Y, Z" ("X15.html" ("BLOCK" . 976543) ("COLOR" . 976552) ("DOUBLE_VIEW" . 976554) ("GROUP" . 976556) ("LINESTYLE" . 976558) ("MODAL" . 976571) ("NAME" . 976577) ("OVERPLOT" . 976579) ("SYMBOL" . 976581) ("TEST" . 976583) ("THICK" . 976585) ("TITLE" . 976587) ("XRANGE" . 976589) ("XTITLE" . 1014240) ("YRANGE" . 976591) ("YTITLE" . 1014248) ("ZRANGE" . 976593) ("ZTITLE" . 976599)))
    ("XROI" pro nil (system) "%s [, ImageData] [, R] [, G] [, B]" ("X17.html" ("BLOCK" . 984509) ("FLOATING" . 984515) ("GROUP" . 984518) ("MODAL" . 984520) ("REGIONS_IN" . 984522) ("REGIONS_OUT" . 984530) ("REJECTED" . 984535) ("RENDERER" . 984540) ("ROI_COLOR" . 984544) ("ROI_GEOMETRY" . 984546) ("ROI_SELECT_COLOR" . 984572) ("STATISTICS" . 984574) ("TITLE" . 984608) ("TOOLS" . 984610) ("X_SCROLL_SIZE" . 999474) ("Y_SCROLL_SIZE" . 999479)))
    ("XSURFACE" pro nil (system) "%s, Data" ("X19.html" ("BLOCK" . 937566) ("GROUP" . 787853)))
    ("XVAREDIT" pro nil (system) "%s, Var" ("X20.html" ("GROUP" . 759115) ("NAME" . 917618) ("X_SCROLL_SIZE" . 917623) ("Y_SCROLL_SIZE" . 917633)))
    ("XVOLUME" pro nil (system) "%s, Vol" ("X21.html" ("BLOCK" . 977093) ("GROUP" . 977102) ("INTERPOLATE" . 977104) ("MODAL" . 977106) ("RENDERER" . 977112) ("REPLACE" . 977116) ("SCALE" . 977121) ("TEST" . 977123) ("XSIZE" . 977128) ("YSIZE" . 977130)))
    ("XVOLUME_ROTATE" pro nil (system) "%s, Axis, Angle" ("X22.html" ("PREMULTIPLY" . 977322)))
    ("XVOLUME_WRITE_IMAGE" pro nil (system) "%s, Filename, Format" ("X23.html" ("DIMENSIONS" . 977402)))
    ("XYOUTS" pro nil (system) "%s, [X, Y,] String" ("X24.html" ("ALIGNMENT" . 680731) ("CHARSIZE" . 680733) ("CHARTHICK" . 680735) ("TEXT_AXES" . 680737) ("WIDTH" . 680739)) ("graphkeyw2.html" ("CLIP" . 315949) ("COLOR" . 315952) ("DATA" . 315961) ("DEVICE" . 315977) ("FONT" . 331795) ("NOCLIP" . 323508) ("NORMAL" . 315963) ("ORIENTATION" . 315964) ("T3D" . 315956) ("Z" . 332658)))
    ("ZOOM" pro nil (system) "%s" ("Z.html" ("CONTINUOUS" . 787879) ("FACT" . 787882) ("INTERP" . 787885) ("KEEP" . 787888) ("NEW_WINDOW" . 787891) ("XSIZE" . 787894) ("YSIZE" . 787897) ("ZOOM_WINDOW" . 787900)))
    ("ZOOM_24" pro nil (system) "%s" ("Z2.html" ("FACT" . 787920) ("RIGHT" . 787923) ("XSIZE" . 787926) ("YSIZE" . 787929)))
    ("A_CORRELATE" fun nil (system) "Result = %s(X, Lag)" ("A2.html" ("COVARIANCE" . 54405) ("DOUBLE" . 826748)))
    ("ABS" fun nil (system) "Result = %s(X)" ("A3.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ACOS" fun nil (system) "Result = %s(X)" ("A4.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ADAPT_HIST_EQUAL" fun nil (system) "Result = %s (Image)" ("A5.html" ("CLIP" . 985045) ("FCN" . 987804) ("NREGIONS" . 985047) ("TOP" . 985049)))
    ("ALOG" fun nil (system) "Result = %s(X)" ("A6.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ALOG10" fun nil (system) "Result = %s(X)" ("A7.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("AMOEBA" fun nil (system) "Result = %s( Ftol)" ("A8.html" ("FUNCTION_NAME" . 864079) ("FUNCTION_VALUE" . 864085) ("NCALLS" . 864089) ("NMAX" . 864091) ("P0" . 864094) ("SCALE" . 864103) ("SIMPLEX" . 864424)))
    ("APP_USER_DIR" fun nil (system) "Result = %s(AuthorDirname, AuthorDesc, AppDirname, AppDesc, AppReadmeText, AppReadmeVersion)" ("A10.html" ("AUTHOR_README_TEXT" . 1011596) ("AUTHOR_README_VERSION" . 1011600) ("RESTRICT_APPVERSION" . 1011616) ("RESTRICT_ARCH" . 1011619) ("RESTRICT_FAMILY" . 1011624) ("RESTRICT_FILE_OFFSET_BITS" . 1011630) ("RESTRICT_IDL_RELEASE" . 1011635) ("RESTRICT_MEMORY_BITS" . 1011640) ("RESTRICT_OS" . 1011645)))
    ("APP_USER_DIR_QUERY" fun nil (system) "Result = %s(AuthorDirname, AppDirname)" ("A11.html" ("COUNT" . 1011749) ("EXCLUDE_CURRENT" . 1011751) ("QUERY_APPVERSION" . 1011762) ("QUERY_ARCH" . 1011764) ("QUERY_FAMILY" . 1011766) ("QUERY_FILE_OFFSET_BITS" . 1011768) ("QUERY_IDL_RELEASE" . 1011770) ("QUERY_MEMORY_BITS" . 1011772) ("QUERY_OS" . 1011774)))
    ("ARG_PRESENT" fun nil (system) "Result = %s(Variable)" ("A12.html"))
    ("ARRAY_EQUAL" fun nil (system) "Result = %s( Op1 , Op2)" ("A13.html" ("NO_TYPECONV" . 987069)))
    ("ARRAY_INDICES" fun nil (system) "Result = %s(Array, Index)" ("A14.html"))
    ("ASCII_TEMPLATE" fun nil (system) "Result = %s( [Filename])" ("A16.html" ("BROWSE_LINES" . 871007) ("CANCEL" . 871139) ("GROUP" . 884032)))
    ("ASIN" fun nil (system) "Result = %s(X)" ("A17.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ASSOC" fun nil (system) "Result = %s( Unit, Array_Structure [, Offset])" ("A18.html" ("PACKED" . 906241)))
    ("ATAN" fun nil (system) "Result = %s([Y,] X)" ("A19.html" ("PHASE" . 995606)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("BESELI" fun nil (system) "Result = %s(X, N)" ("B3.html" ("DOUBLE" . 998579) ("ITER" . 998584)))
    ("BESELJ" fun nil (system) "Result = %s(X, N)" ("B4.html" ("DOUBLE" . 998704) ("ITER" . 998706)))
    ("BESELK" fun nil (system) "Result = %s( X, N)" ("B5.html" ("DOUBLE" . 998712) ("ITER" . 998714)))
    ("BESELY" fun nil (system) "Result = %s(X, N)" ("B6.html" ("DOUBLE" . 998720) ("ITER" . 998722)))
    ("BETA" fun nil (system) "Result = %s( Z, W)" ("B7.html" ("DOUBLE" . 50234)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("BILINEAR" fun nil (system) "Result = %s(P, IX, JY)" ("B8.html" ("MISSING" . 996637)))
    ("BIN_DATE" fun nil (system) "Result = %s(Ascii_Time)" ("B9.html"))
    ("BINARY_TEMPLATE" fun nil (system) "Result = %s ( [Filename])" ("B10.html" ("CANCEL" . 985257) ("GROUP" . 985259) ("N_ROWS" . 985261) ("TEMPLATE" . 988405)))
    ("BINDGEN" fun nil (system) "Result = %s(D1 [, ...,D8])" ("B11.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("BINOMIAL" fun nil (system) "Result = %s(V, N, P)" ("B12.html" ("DOUBLE" . 988094) ("GAUSSIAN" . 988097)))
    ("BLK_CON" fun nil (system) "Result = %s( Filter, Signal)" ("B14.html" ("B_LENGTH" . 749505) ("DOUBLE" . 987871)))
    ("BROYDEN" fun nil (system) "Result = %s( X, Vecfunc)" ("B18.html" ("CHECK" . 50283) ("DOUBLE" . 50286) ("EPS" . 50289) ("ITMAX" . 989330) ("STEPMAX" . 50292) ("TOLF" . 50295) ("TOLMIN" . 50298) ("TOLX" . 50301)))
    ("BYTARR" fun nil (system) "Result = %s( D1[, ..., D8])" ("B19.html" ("NOZERO" . 675878)))
    ("BYTE" fun nil (system) "Result = %s( Expression[, Offset [, D1[, ..., D8]]] )" ("B20.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("BYTSCL" fun nil (system) "Result = %s( Array)" ("B22.html" ("MAX" . 675964) ("MIN" . 675966) ("NAN" . 47179) ("TOP" . 675968)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("C_CORRELATE" fun nil (system) "Result = %s( X, Y, Lag)" ("C.html" ("COVARIANCE" . 54458) ("DOUBLE" . 826756)))
    ("CALL_EXTERNAL" fun nil (system) "Result = %s(Image, Entry [, P0, ..., PN-1])" ("C4.html" ("ALL_VALUE" . 905908) ("AUTO_GLUE" . 1025677) ("B_VALUE" . 951311) ("CC" . 1012394) ("CDECL" . 905911) ("COMPILE_DIRECTORY" . 1012398) ("D_VALUE" . 905920) ("EXTRA_CFLAGS" . 1012436) ("EXTRA_LFLAGS" . 1012440) ("F_VALUE" . 905923) ("I_VALUE" . 905926) ("IGNORE_EXISTING_GLUE" . 1012444) ("L64_VALUE" . 951332) ("LD" . 1012449) ("NOCLEANUP" . 1012453) ("RETURN_TYPE" . 1029187) ("S_VALUE" . 951354) ("SHOW_ALL_OUTPUT" . 1012458) ("UI_VALUE" . 951320) ("UL64_VALUE" . 965882) ("UL_VALUE" . 965879) ("UNLOAD" . 993357) ("VALUE" . 905936) ("VERBOSE" . 1012497) ("WRITE_WRAPPER" . 1029198)))
    ("CALL_FUNCTION" fun nil (system) "Result = %s(Name [, P1, ..., Pn])" ("C5.html"))
    ("CALL_METHOD" fun nil (system) "Result = %s, Name, ObjRef, [, P1, ..., Pn]" ("C6.html"))
    ("CDF_ATTCREATE" fun nil (system) "Result = %s( Id, Attribute_Name)" ("CDF-routines8.html" ("GLOBAL_SCOPE" . 996934) ("VARIABLE_SCOPE" . 996937)))
    ("CDF_ATTEXISTS" fun nil (system) "Result = %s( Id, Attribute [, EntryNum])" ("CDF-routines10.html" ("ZVARIABLE" . 1002462)))
    ("CDF_ATTNUM" fun nil (system) "Result = %s(Id, Attribute_Name)" ("CDF-routines13.html"))
    ("CDF_CREATE" fun nil (system) "Result = %s( Filename, [Dimensions])" ("CDF-routines19.html" ("ALPHAOSF1_DECODING" . 1017799) ("ALPHAOSF1_ENCODING" . 997337) ("ALPHAVMSD_DECODING" . 1017802) ("ALPHAVMSD_ENCODING" . 997340) ("ALPHAVMSG_DECODING" . 1017805) ("ALPHAVMSG_ENCODING" . 997343) ("CLOBBER" . 1017643) ("COL_MAJOR" . 1017646) ("DECSTATION_DECODING" . 1017808) ("DECSTATION_ENCODING" . 1017778) ("HOST_DECODING" . 1017811) ("HOST_ENCODING" . 997349) ("HP_DECODING" . 1017814) ("HP_ENCODING" . 997352) ("IBMPC_DECODING" . 1017817) ("IBMPC_ENCODING" . 1017767) ("IBMRS_DECODING" . 1017820) ("IBMRS_ENCODING" . 997355) ("MAC_DECODING" . 1017823) ("MAC_ENCODING" . 997367) ("MULTI_FILE" . 1017715) ("NETWORK_DECODING" . 1017826) ("NETWORK_ENCODING" . 997378) ("NEXT_DECODING" . 1017829) ("NEXT_ENCODING" . 997381) ("ROW_MAJOR" . 1017746) ("SGI_DECODING" . 1017832) ("SGI_ENCODING" . 1017789) ("SINGLE_FILE" . 1017749) ("SUN_DECODING" . 1017835) ("SUN_ENCODING" . 997390)))
    ("CDF_ENCODE_EPOCH" fun nil (system) "Result = %s(Epoch)" ("CDF-routines22.html" ("EPOCH" . 997448)))
    ("CDF_ERROR" fun nil (system) "Result = %s(Status)" ("CDF-routines24.html"))
    ("CDF_EXISTS" fun nil (system) "Result = %s( )" ("CDF-routines25.html"))
    ("CDF_INQUIRE" fun nil (system) "Result = %s(Id)" ("CDF-routines26.html"))
    ("CDF_OPEN" fun nil (system) "Result = %s(Filename)" ("CDF-routines28.html"))
    ("CDF_PARSE_EPOCH" fun nil (system) "Result = %s(Epoch_string)" ("CDF-routines29.html"))
    ("CDF_VARCREATE" fun nil (system) "Result = %s( Id, Name [, DimVary])" ("CDF-routines30.html" ("ALLOCATERECS" . 997736) ("DIMENSIONS" . 997739) ("NUMELEM" . 997744) ("REC_NOVARY" . 997747) ("REC_VARY" . 997750) ("VARIABLETYPE" . 1027601) ("ZVARIABLE" . 997753)))
    ("CDF_VARINQ" fun nil (system) "Result = %s( Id, Variable)" ("CDF-routines34.html" ("ZVARIABLE" . 997944)))
    ("CDF_VARNUM" fun nil (system) "Result = %s( Id, VarName [, IsZVar] )" ("CDF-routines35.html"))
    ("CEIL" fun nil (system) "Result = %s(X)" ("C12.html" ("L64" . 1015251)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("CHEBYSHEV" fun nil (system) "Result = %s(D, N)" ("C13.html"))
    ("CHECK_MATH" fun nil (system) "Result = %s()" ("C14.html" ("MASK" . 993110) ("NOCLEAR" . 993190) ("PRINT" . 993188)))
    ("CHISQR_CVF" fun nil (system) "Result = %s(P, Df)" ("C15.html"))
    ("CHISQR_PDF" fun nil (system) "Result = %s(V, Df)" ("C16.html"))
    ("CHOLSOL" fun nil (system) "Result = %s( A, P, B)" ("C18.html" ("DOUBLE" . 50387)))
    ("CINDGEN" fun nil (system) "Result = %s(D1[, ..., D8])" ("C19.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("CLUST_WTS" fun nil (system) "Result = %s( Array)" ("C22.html" ("DOUBLE" . 862498) ("N_CLUSTERS" . 862487) ("N_ITERATIONS" . 862488) ("VARIABLE_WTS" . 862545)))
    ("CLUSTER" fun nil (system) "Result = %s( Array, Weights)" ("C23.html" ("DOUBLE" . 862580) ("N_CLUSTERS" . 862583)))
    ("CLUSTER_TREE" fun nil (system) "Result = %s( Pairdistance, Linkdistance)" ("C24.html" ("DATA" . 1196682) ("LINKAGE" . 1196686) ("MEASURE" . 1196715) ("POWER_MEASURE" . 1196749)))
    ("COLOR_QUAN" fun nil (system) "Result = %s( Image_R, Image_G, Image_B, R, G, B) or Result = %s( Image, Dim, R, G, B )" ("C26.html" ("COLORS" . 676177) ("CUBE" . 676179) ("DITHER" . 676181) ("ERROR" . 676183) ("GET_TRANSLATION" . 676185) ("MAP_ALL" . 676187) ("TRANSLATION" . 676189)))
    ("COLORMAP_APPLICABLE" fun nil (system) "Result = %s( redrawRequired )" ("C27.html"))
    ("COMFIT" fun nil (system) "Result = %s( X, Y, A)" ("C28.html" ("EXPONENTIAL" . 53208) ("GEOMETRIC" . 838932) ("GOMPERTZ" . 838937) ("HYPERBOLIC" . 838944) ("LOGISTIC" . 838961) ("LOGSQUARE" . 838970) ("SIGMA" . 838980) ("WEIGHTS" . 53265) ("YFIT" . 53268)))
    ("COMPLEX" fun nil (system) "Result = %s( Real [, Imaginary])" ("C31.html" ("DOUBLE" . 1041956)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("COMPLEXARR" fun nil (system) "Result = %s( D1[, ..., D8])" ("C32.html" ("NOZERO" . 676236)))
    ("COMPLEXROUND" fun nil (system) "Result = %s(Input)" ("C33.html"))
    ("COMPUTE_MESH_NORMALS" fun nil (system) "Result = %s( fVerts[, iConn] )" ("C34.html"))
    ("COND" fun nil (system) "Result = %s( A)" ("C35.html" ("DOUBLE" . 749542) ("LNORM" . 1042001)))
    ("CONGRID" fun nil (system) "Result = %s( Array, X, Y, Z)" ("C36.html" ("CENTER" . 757848) ("CUBIC" . 1042041) ("INTERP" . 757851) ("MINUS_ONE" . 757854)))
    ("CONJ" fun nil (system) "Result = %s(X)" ("C37.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("CONVERT_COORD" fun nil (system) "Result = %s( X [, Y [, Z]])" ("C41.html" ("DATA" . 676377) ("DEVICE" . 676379) ("DOUBLE" . 1015017) ("NORMAL" . 676381) ("T3D" . 676383) ("TO_DATA" . 676385) ("TO_DEVICE" . 676387) ("TO_NORMAL" . 676389)))
    ("CONVOL" fun nil (system) "Result = %s( Array, Kernel [, Scale_Factor])" ("C42.html" ("CENTER" . 676409) ("EDGE_TRUNCATE" . 746326) ("EDGE_WRAP" . 228821) ("MISSING" . 1028668) ("NAN" . 1028683)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("COORD2TO3" fun nil (system) "Result = %s( Mx, My, Dim, D0 [, PTI] )" ("C43.html"))
    ("CORRELATE" fun nil (system) "Result = %s( X [, Y])" ("C45.html" ("COVARIANCE" . 53307) ("DOUBLE" . 868819)))
    ("COS" fun nil (system) "Result = %s(X)" ("C46.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("COSH" fun nil (system) "Result = %s(X)" ("C47.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("CRAMER" fun nil (system) "Result = %s( A, B)" ("C49.html" ("DOUBLE" . 749607) ("ZERO" . 749609)))
    ("CREATE_CURSOR" fun nil (system) "Result = %s( StringArray)" ("C50.html" ("HOTSPOT" . 1192516) ("MASK" . 1222423)))
    ("CREATE_STRUCT" fun nil (system) "Result = %s( [Tag1, Values1, ..., Tagn, Valuesn] [, Structuresn])" ("C51.html" ("NAME" . 279439)))
    ("CROSSP" fun nil (system) "Result = %s(V1, V2)" ("C53.html"))
    ("CRVLENGTH" fun nil (system) "Result = %s( X, Y)" ("C54.html" ("DOUBLE" . 862840)))
    ("CT_LUMINANCE" fun nil (system) "Result = %s( [R, G, B])" ("C55.html" ("BRIGHT" . 759145) ("DARK" . 759148) ("READ_TABLES" . 759151)))
    ("CTI_TEST" fun nil (system) "Result = %s( Obfreq)" ("C56.html" ("COEFF" . 53357) ("CORRECTED" . 53360) ("CRAMV" . 53363) ("DF" . 53366) ("EXFREQ" . 53369) ("RESIDUAL" . 53372)))
    ("CURVEFIT" fun nil (system) "Result = %s( X, Y, Weights, A [, Sigma])" ("C58.html" ("CHISQ" . 1024958) ("DOUBLE" . 1024093) ("FITA" . 148399) ("FUNCTION_NAME" . 1118305) ("ITER" . 150209) ("ITMAX" . 150211) ("NODERIVATIVE" . 150222) ("STATUS" . 1107869) ("TOL" . 1108021) ("YERROR" . 1053331)))
    ("CV_COORD" fun nil (system) "Result = %s()" ("C59.html" ("DEGREES" . 756965) ("DOUBLE" . 1025482) ("FROM_CYLIN" . 756968) ("FROM_POLAR" . 756971) ("FROM_RECT" . 756974) ("FROM_SPHERE" . 756977) ("TO_CYLIN" . 1109055) ("TO_POLAR" . 756983) ("TO_RECT" . 756986) ("TO_SPHERE" . 756989)))
    ("CVTTOBM" fun nil (system) "Result = %s( Array)" ("C60.html" ("THRESHOLD" . 871509)))
    ("CW_ANIMATE" fun nil (system) "Result = %s( Parent, Sizex, Sizey, Nframes)" ("C61.html" ("NO_KILL" . 853861) ("OPEN_FUNC" . 853864) ("PIXMAPS" . 853868) ("TAB_MODE" . 1189372) ("TRACK" . 853871) ("UNAME" . 996617) ("UVALUE" . 853874)))
    ("CW_ARCBALL" fun nil (system) "Result = %s( Parent)" ("C65.html" ("COLORS" . 755064) ("FRAME" . 755074) ("LABEL" . 755077) ("RETAIN" . 755080) ("SIZE" . 755108) ("TAB_MODE" . 1189488) ("UNAME" . 996624) ("UPDATE" . 1189483) ("UVALUE" . 755114) ("VALUE" . 755117)))
    ("CW_BGROUP" fun nil (system) "Result = %s( Parent, Names)" ("C66.html" ("BUTTON_UVALUE" . 755175) ("COLUMN" . 755178) ("EVENT_FUNC" . 755181) ("EXCLUSIVE" . 755184) ("FONT" . 755187) ("FRAME" . 755190) ("IDS" . 755193) ("LABEL_LEFT" . 755196) ("LABEL_TOP" . 755199) ("MAP" . 755202) ("NO_RELEASE" . 755208) ("NONEXCLUSIVE" . 755205) ("RETURN_ID" . 755211) ("RETURN_INDEX" . 755214) ("RETURN_NAME" . 755217) ("ROW" . 755220) ("SCROLL" . 755223) ("SET_VALUE" . 755226) ("SPACE" . 755230) ("TAB_MODE" . 1189560) ("UNAME" . 996707) ("UVALUE" . 755233) ("X_SCROLL_SIZE" . 755245) ("XOFFSET" . 755236) ("XPAD" . 755239) ("XSIZE" . 755242) ("Y_SCROLL_SIZE" . 755257) ("YOFFSET" . 755248) ("YPAD" . 755251) ("YSIZE" . 755254)))
    ("CW_CLR_INDEX" fun nil (system) "Result = %s( Parent)" ("C67.html" ("COLOR_VALUES" . 854099) ("EVENT_FUNC" . 854102) ("FRAME" . 854105) ("LABEL" . 854108) ("NCOLORS" . 854111) ("START_COLOR" . 854114) ("TAB_MODE" . 1189650) ("UNAME" . 996631) ("UVALUE" . 854117) ("VALUE" . 854120) ("XSIZE" . 1025090) ("YSIZE" . 854123)))
    ("CW_COLORSEL" fun nil (system) "Result = %s( Parent)" ("C68.html" ("FRAME" . 854194) ("TAB_MODE" . 1189739) ("UNAME" . 996638) ("UVALUE" . 1233223) ("XOFFSET" . 854200) ("YOFFSET" . 854203)))
    ("CW_DEFROI" fun nil (system) "Result = %s( Draw)" ("C69.html" ("IMAGE_SIZE" . 755439) ("OFFSET" . 755442) ("ORDER" . 755445) ("RESTORE" . 755448) ("TAB_MODE" . 1189809) ("ZOOM" . 755451)))
    ("CW_FIELD" fun nil (system) "Result = %s( Parent)" ("C70.html" ("ALL_EVENTS" . 755508) ("COLUMN" . 755511) ("FIELDFONT" . 755514) ("FLOATING" . 755517) ("FONT" . 755520) ("FRAME" . 755523) ("INTEGER" . 755526) ("LONG" . 755529) ("NOEDIT" . 755532) ("RETURN_EVENTS" . 755535) ("ROW" . 755540) ("STRING" . 755543) ("TAB_MODE" . 1189883) ("TEXT_FRAME" . 755546) ("TITLE" . 1029040) ("UNAME" . 996600) ("UVALUE" . 755549) ("VALUE" . 755552) ("XSIZE" . 755555) ("YSIZE" . 755558)))
    ("CW_FILESEL" fun nil (system) "Result = %s ( Parent)" ("C71.html" ("FILENAME" . 1001063) ("FILTER" . 1001065) ("FIX_FILTER" . 1001072) ("FRAME" . 1001074) ("IMAGE_FILTER" . 1001076) ("MULTIPLE" . 1001078) ("PATH" . 1001080) ("SAVE" . 1024908) ("TAB_MODE" . 1189963) ("UNAME" . 1001082) ("UVALUE" . 1001085) ("WARN_EXIST" . 1024611)))
    ("CW_FORM" fun nil (system) "Result = %s( [Parent,] Desc)" ("C72.html" ("COLUMN" . 141396) ("IDS" . 141399) ("TAB_MODE" . 1190037) ("TITLE" . 141402) ("UNAME" . 996652) ("UVALUE" . 141405)))
    ("CW_FSLIDER" fun nil (system) "Result = %s( Parent)" ("C73.html" ("DOUBLE" . 755581) ("DRAG" . 1028998) ("EDIT" . 755584) ("FORMAT" . 755587) ("FRAME" . 755590) ("MAXIMUM" . 755593) ("MINIMUM" . 755596) ("SCROLL" . 218849) ("SUPPRESS_VALUE" . 755599) ("TAB_MODE" . 1190109) ("TITLE" . 755602) ("UNAME" . 996664) ("UVALUE" . 755605) ("VALUE" . 755608) ("VERTICAL" . 755611) ("XSIZE" . 755614) ("YSIZE" . 755617)))
    ("CW_ITMENU" fun nil (system) "Result = %s(Parent, UI, Target)" ("fw_cw_ref4.html" ("CONTEXT_MENU" . 999147) ("UNAME" . 999150) ("UVALUE" . 999153)))
    ("CW_ITPANEL" fun nil (system) "Result = %s(Parent, UI)" ("fw_cw_ref5.html" ("ORIENTATION" . 999520) ("UNAME" . 999524) ("UVALUE" . 999527)))
    ("CW_ITSTATUSBAR" fun nil (system) "Result = %s(Parent, UI)" ("fw_cw_ref6.html" ("UNAME" . 999554) ("UVALUE" . 999557) ("XSIZE" . 999560)))
    ("CW_ITTOOLBAR" fun nil (system) "Result = %s(Parent, UI, Target)" ("fw_cw_ref7.html" ("EXCLUSIVE" . 999187) ("ROW" . 999190) ("UNAME" . 1001835) ("UVALUE" . 999196)))
    ("CW_ITWINDOW" fun nil (system) "Result = %s(Parent, UI)" ("fw_cw_ref8.html" ("DIMENSIONS" . 999225) ("UNAME" . 999229) ("UVALUE" . 999232) ("VIRTUAL_DIMENSIONS" . 1002122)))
    ("CW_LIGHT_EDITOR" fun nil (system) "Result = %s (Parent)" ("C74.html" ("DIRECTION_DISABLED" . 1001420) ("DRAG_EVENTS" . 1001422) ("FRAME" . 1001426) ("HIDE_DISABLED" . 1001428) ("LIGHT" . 1001430) ("LOCATION_DISABLED" . 1001432) ("TAB_MODE" . 1239092) ("TYPE_DISABLED" . 1001434) ("UNAME" . 1001436) ("UVALUE" . 1001439) ("XRANGE" . 1001441) ("XSIZE" . 1001443) ("YRANGE" . 1001445) ("YSIZE" . 1001447) ("ZRANGE" . 1001449)))
    ("CW_ORIENT" fun nil (system) "Result = %s( Parent)" ("C77.html" ("AX" . 755637) ("AZ" . 755640) ("FRAME" . 755643) ("TAB_MODE" . 1190182) ("TITLE" . 755646) ("UNAME" . 996671) ("UVALUE" . 755649) ("XSIZE" . 755652) ("YSIZE" . 755655)))
    ("CW_PALETTE_EDITOR" fun nil (system) "Result = %s (Parent)" ("C78.html" ("DATA" . 1001627) ("FRAME" . 1001629) ("HISTOGRAM" . 1001631) ("HORIZONTAL" . 1001633) ("SELECTION" . 1001635) ("TAB_MODE" . 1190256) ("UNAME" . 1001637) ("UVALUE" . 1001640) ("XSIZE" . 1001642) ("YSIZE" . 1001644)))
    ("CW_PDMENU" fun nil (system) "Result = %s( Parent, Desc)" ("C81.html" ("COLUMN" . 755708) ("CONTEXT_MENU" . 1025506) ("DELIMITER" . 1042113) ("FONT" . 67046) ("HELP" . 855550) ("IDS" . 860166) ("MBAR" . 1188103) ("RETURN_FULL_NAME" . 755726) ("RETURN_ID" . 1188112) ("RETURN_INDEX" . 755720) ("RETURN_NAME" . 755723) ("TAB_MODE" . 1190329) ("UNAME" . 996678) ("UVALUE" . 755731) ("XOFFSET" . 755734) ("YOFFSET" . 755737)))
    ("CW_RGBSLIDER" fun nil (system) "Result = %s( Parent)" ("C82.html" ("CMY" . 755795) ("COLOR_INDEX" . 755798) ("DRAG" . 755801) ("FRAME" . 755804) ("GRAPHICS_LEVEL" . 755807) ("HLS" . 755810) ("HSV" . 1025517) ("LENGTH" . 755813) ("RGB" . 755816) ("TAB_MODE" . 1190402) ("UNAME" . 996685) ("UVALUE" . 755819) ("VALUE" . 755822) ("VERTICAL" . 1025592)))
    ("CW_TMPL" fun nil (system) "Result = %s( Parent)" ("C83.html" ("TAB_MODE" . 1239165) ("UNAME" . 996692) ("UVALUE" . 137507)))
    ("CW_ZOOM" fun nil (system) "Result = %s( Parent)" ("C84.html" ("FRAME" . 755848) ("MAX" . 755851) ("MIN" . 755854) ("RETAIN" . 755857) ("SAMPLE" . 755885) ("SCALE" . 755888) ("TAB_MODE" . 1190480) ("TRACK" . 755891) ("UNAME" . 996700) ("UVALUE" . 755894) ("X_SCROLL_SIZE" . 755900) ("X_ZSIZE" . 755903) ("XSIZE" . 755897) ("Y_SCROLL_SIZE" . 755909) ("Y_ZSIZE" . 755912) ("YSIZE" . 755906)))
    ("DB_EXISTS" fun nil (system) "status = %s()" ("api5.html"))
    ("DBLARR" fun nil (system) "Result = %s( D1[, ..., D8])" ("D.html" ("NOZERO" . 676487)))
    ("DCINDGEN" fun nil (system) "Result = %s( D1 [, ..., D8 ])" ("D2.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("DCOMPLEX" fun nil (system) "Result = %s( Real [, Imaginary] ) or Result = %s( Expression, Offset [, D1 [, ..., D8]] )" ("D3.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("DCOMPLEXARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("D4.html" ("NOZERO" . 37699)))
    ("DEFROI" fun nil (system) "Result = %s( Sx, Sy [, Xverts, Yverts])" ("D8.html" ("NOFILL" . 757032) ("NOREGION" . 757029) ("RESTORE" . 757035) ("X0" . 757039) ("Y0" . 757039) ("ZOOM" . 757042)))
    ("DERIV" fun nil (system) "Result = %s([X,] Y)" ("D13.html"))
    ("DERIVSIG" fun nil (system) "Result = %s( [X, Y, Sigx,] Sigy )" ("D14.html"))
    ("DETERM" fun nil (system) "Result = %s( A)" ("D15.html" ("CHECK" . 749767) ("DOUBLE" . 37196) ("ZERO" . 749769)))
    ("DIAG_MATRIX" fun nil (system) "Result = %s(A [, Diag] )" ("D18.html"))
    ("DIALOG_DBCONNECT" fun nil (system) "status = %s(DBobj)" ("api4.html" ("DATASOURCE" . 1007548) ("DIALOG_PARENT" . 1007555) ("PASSWORD" . 1007553) ("USER_ID" . 1007551)))
    ("DIALOG_MESSAGE" fun nil (system) "Result = %s( Message_Text)" ("D19.html" ("CANCEL" . 863012) ("DEFAULT_CANCEL" . 863015) ("DEFAULT_NO" . 863018) ("DIALOG_PARENT" . 863021) ("DISPLAY_NAME" . 871724) ("ERROR" . 863025) ("INFORMATION" . 863028) ("QUESTION" . 863031) ("RESOURCE_NAME" . 863035) ("TITLE" . 863041)))
    ("DIALOG_PICKFILE" fun nil (system) "Result = %s()" ("D20.html" ("DEFAULT_EXTENSION" . 1010269) ("DIALOG_PARENT" . 907482) ("DIRECTORY" . 951270) ("DISPLAY_NAME" . 907484) ("FILE" . 862313) ("FILTER" . 907329) ("FIX_FILTER" . 907334) ("GET_PATH" . 862316) ("GROUP" . 862319) ("MULTIPLE_FILES" . 907351) ("MUST_EXIST" . 1009929) ("OVERWRITE_PROMPT" . 1009949) ("PATH" . 1009942) ("READ" . 862322) ("RESOURCE_NAME" . 1006308) ("TITLE" . 907359) ("WRITE" . 862325)))
    ("DIALOG_PRINTERSETUP" fun nil (system) "Result = %s( [PrintDestination])" ("D21.html" ("DIALOG_PARENT" . 984460) ("DISPLAY_NAME" . 984463) ("RESOURCE_NAME" . 984466) ("TITLE" . 984469)))
    ("DIALOG_PRINTJOB" fun nil (system) "Result = %s( [PrintDestination])" ("D22.html" ("DIALOG_PARENT" . 863760) ("DISPLAY_NAME" . 870902) ("RESOURCE_NAME" . 870904) ("TITLE" . 870915)))
    ("DIALOG_READ_IMAGE" fun nil (system) "Result = %s ( [Filename])" ("D23.html" ("BLUE" . 986778) ("DIALOG_PARENT" . 986218) ("FILE" . 986220) ("FILTER_TYPE" . 986222) ("FIX_FILTER" . 986226) ("GET_PATH" . 986785) ("GREEN" . 990353) ("IMAGE" . 986228) ("PATH" . 986230) ("QUERY" . 986232) ("RED" . 986234) ("TITLE" . 986240)))
    ("DIALOG_WRITE_IMAGE" fun nil (system) "Result = %s ( Image [, R, G, B])" ("D24.html" ("DIALOG_PARENT" . 986258) ("FILE" . 986260) ("FIX_TYPE" . 986262) ("NOWRITE" . 986264) ("OPTIONS" . 986266) ("PATH" . 986268) ("TITLE" . 986270) ("TYPE" . 986272) ("WARN_EXIST" . 990326)))
    ("DIGITAL_FILTER" fun nil (system) "Result = %s( Flow, Fhigh, A, Nterms)" ("D25.html" ("DOUBLE" . 1002899)))
    ("DILATE" fun nil (system) "Result = %s( Image, Structure [, X0 [, Y0 [, Z0]]])" ("D26.html" ("BACKGROUND" . 984751) ("CONSTRAINED" . 984770) ("GRAY" . 984614) ("PRESERVE_TYPE" . 984778) ("UINT" . 984780) ("ULONG" . 984782) ("VALUES" . 984617)))
    ("DINDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("D27.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("DIST" fun nil (system) "Result = %s(N [, M])" ("D29.html"))
    ("DISTANCE_MEASURE" fun nil (system) "Result = %s( Array)" ("D30.html" ("DOUBLE" . 1033017) ("MATRIX" . 1033020) ("MEASURE" . 1033023) ("POWER_MEASURE" . 1033069)))
    ("DOUBLE" fun nil (system) "Result = %s(Expression[, Offset [, D1 [, ..., D8]]])" ("D34.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("EIGENQL" fun nil (system) "Result = %s( A)" ("E2.html" ("ABSOLUTE" . 870576) ("ASCENDING" . 862897) ("DOUBLE" . 862899) ("EIGENVECTORS" . 870583) ("OVERWRITE" . 862901) ("RESIDUAL" . 862903)))
    ("EIGENVEC" fun nil (system) "Result = %s( A, Eval)" ("E3.html" ("DOUBLE" . 47356) ("ITMAX" . 47358) ("RESIDUAL" . 47286)))
    ("ELMHES" fun nil (system) "Result = %s( A)" ("E4.html" ("COLUMN" . 983389) ("DOUBLE" . 50601) ("NO_BALANCE" . 50604)))
    ("EOF" fun nil (system) "Result = %s(Unit)" ("E7.html"))
    ("EOS_EH_CONVANG" fun nil (system) "Result = %s(inAngle, code)" ("EOS-routines8.html"))
    ("EOS_EH_GETVERSION" fun nil (system) "Result = %s(fid, version)" ("EOS-routines9.html"))
    ("EOS_EH_IDINFO" fun nil (system) "Result = %s(fid, HDFfid, sdInterfaceID)" ("EOS-routines10.html"))
    ("EOS_EXISTS" fun nil (system) "Result = %s( )" ("EOS-routines11.html"))
    ("EOS_GD_ATTACH" fun nil (system) "Result = %s(fid, gridname)" ("EOS-routines12.html"))
    ("EOS_GD_ATTRINFO" fun nil (system) "Result = %s(gridID, attrname, numbertype, count)" ("EOS-routines13.html"))
    ("EOS_GD_BLKSOMOFFSET" fun nil (system) "Result = %s(gridID, offset, code)" ("EOS-routines14.html"))
    ("EOS_GD_CLOSE" fun nil (system) "Result = %s(fid)" ("EOS-routines15.html"))
    ("EOS_GD_COMPINFO" fun nil (system) "Result = %s(gridID, fieldname, compcode, compparm)" ("EOS-routines16.html"))
    ("EOS_GD_CREATE" fun nil (system) "Result = %s(fid, gridname, xdimsize, ydimsize, upleftpt, lowrightpt)" ("EOS-routines17.html"))
    ("EOS_GD_DEFBOXREGION" fun nil (system) "Result = %s(gridID, cornerlon, cornerlat)" ("EOS-routines18.html"))
    ("EOS_GD_DEFCOMP" fun nil (system) "Result = %s(gridID, compcode [, compparm] )" ("EOS-routines19.html"))
    ("EOS_GD_DEFDIM" fun nil (system) "Result = %s(gridID, dimname, dim)" ("EOS-routines20.html"))
    ("EOS_GD_DEFFIELD" fun nil (system) "Result = %s(gridID, fieldname, dimlist, numbertype)" ("EOS-routines21.html" ("MERGE" . 1030256)))
    ("EOS_GD_DEFORIGIN" fun nil (system) "Result = %s(gridID, origincode)" ("EOS-routines22.html"))
    ("EOS_GD_DEFPIXREG" fun nil (system) "Result = %s(gridID, pixreg)" ("EOS-routines23.html"))
    ("EOS_GD_DEFPROJ" fun nil (system) "Result = %s(gridID, projcode, zonecode, spherecode, projparm)" ("EOS-routines24.html"))
    ("EOS_GD_DEFTILE" fun nil (system) "Result = %s( gridID, tilecode [, tilerank, tiledims] )" ("EOS-routines25.html"))
    ("EOS_GD_DEFVRTREGION" fun nil (system) "Result = %s(gridID, regionID, vertObj, range)" ("EOS-routines26.html"))
    ("EOS_GD_DETACH" fun nil (system) "Result = %s(gridID)" ("EOS-routines27.html"))
    ("EOS_GD_DIMINFO" fun nil (system) "Result = %s(gridID, dimname)" ("EOS-routines28.html"))
    ("EOS_GD_DUPREGION" fun nil (system) "Result = %s(regionID)" ("EOS-routines29.html"))
    ("EOS_GD_EXTRACTREGION" fun nil (system) "Result = %s(gridID, regionID, fieldname, buffer)" ("EOS-routines30.html"))
    ("EOS_GD_FIELDINFO" fun nil (system) "Result = %s(gridID, fieldname, rank, dims, numbertype, dimlist)" ("EOS-routines31.html"))
    ("EOS_GD_GETFILLVALUE" fun nil (system) "Result = %s(gridID, fieldname, fillvalue)" ("EOS-routines32.html"))
    ("EOS_GD_GETPIXELS" fun nil (system) "Result = %s(gridID, nLonLat, lonVal, latVal, pixRow, pixCol)" ("EOS-routines33.html"))
    ("EOS_GD_GETPIXVALUES" fun nil (system) "Result = %s(gridID, nPixels, pixCol, pixRow, fieldname, buffer)" ("EOS-routines34.html"))
    ("EOS_GD_GRIDINFO" fun nil (system) "Result = %s(gridID, xdimsize, ydimsize, upleft, lowright)" ("EOS-routines35.html"))
    ("EOS_GD_INQATTRS" fun nil (system) "Result = %s( gridID, attrlist)" ("EOS-routines36.html" ("LENGTH" . 1030732)))
    ("EOS_GD_INQDIMS" fun nil (system) "Result = %s(gridID, dimname, dims)" ("EOS-routines37.html"))
    ("EOS_GD_INQFIELDS" fun nil (system) "Result = %s(gridID, fieldlist, rank, numbertype)" ("EOS-routines38.html"))
    ("EOS_GD_INQGRID" fun nil (system) "Result = %s( filename, gridlist)" ("EOS-routines39.html" ("LENGTH" . 1030811)))
    ("EOS_GD_INTERPOLATE" fun nil (system) "Result = %s(gridID, Interp, lonVal, latVal, fieldname, interpVal)" ("EOS-routines40.html"))
    ("EOS_GD_NENTRIES" fun nil (system) "Result = %s( gridID, entrycode)" ("EOS-routines41.html" ("LENGTH" . 1030866)))
    ("EOS_GD_OPEN" fun nil (system) "Result = %s( filename, access)" ("EOS-routines42.html" ("CREATE" . 1030919) ("RDWR" . 1030921) ("READ" . 1030923)))
    ("EOS_GD_ORIGININFO" fun nil (system) "Result = %s(gridID, origincode)" ("EOS-routines43.html"))
    ("EOS_GD_PIXREGINFO" fun nil (system) "Result = %s(gridID, pixregcode)" ("EOS-routines44.html"))
    ("EOS_GD_PROJINFO" fun nil (system) "Result = %s(gridID, projcode, zonecode, spherecode, projparm)" ("EOS-routines45.html"))
    ("EOS_GD_QUERY" fun nil (system) "Result = %s( Filename, GridName, [Info])" ("EOS-routines46.html"))
    ("EOS_GD_READATTR" fun nil (system) "Result = %s(gridID, attrname, datbuf)" ("EOS-routines47.html"))
    ("EOS_GD_READFIELD" fun nil (system) "Result = %s( gridID, fieldname, buffer)" ("EOS-routines48.html" ("EDGE" . 1031035) ("START" . 1031037) ("STRIDE" . 1031039)))
    ("EOS_GD_READTILE" fun nil (system) "Result = %s(gridID, fieldname, tilecoords, buffer)" ("EOS-routines49.html"))
    ("EOS_GD_REGIONINFO" fun nil (system) "Result = %s(gridID, regionID, fieldname, ntype, rank, dims, size, upleftpt, lowrightpt)" ("EOS-routines50.html"))
    ("EOS_GD_SETFILLVALUE" fun nil (system) "Result = %s(gridID, fieldname, fillvalue)" ("EOS-routines51.html"))
    ("EOS_GD_SETTILECACHE" fun nil (system) "Result = %s(gridID, fieldname, maxcache, cachecode)" ("EOS-routines52.html"))
    ("EOS_GD_TILEINFO" fun nil (system) "Result = %s(gridID, fieldname, tilecode, tilerank, tiledims)" ("EOS-routines53.html"))
    ("EOS_GD_WRITEATTR" fun nil (system) "Result = %s( gridID, attrname, datbuf)" ("EOS-routines54.html" ("COUNT" . 1031201) ("HDF_TYPE" . 1031203)))
    ("EOS_GD_WRITEFIELD" fun nil (system) "Result = %s( gridID, fieldname, data)" ("EOS-routines55.html" ("EDGE" . 1031230) ("START" . 1031232) ("STRIDE" . 1031234)))
    ("EOS_GD_WRITEFIELDMETA" fun nil (system) "Result = %s(gridID, fieldname, dimlist, numbertype)" ("EOS-routines56.html"))
    ("EOS_GD_WRITETILE" fun nil (system) "Result = %s(gridID, fieldname, tilecoords, data)" ("EOS-routines57.html"))
    ("EOS_PT_ATTACH" fun nil (system) "Result = %s(fid, pointname)" ("EOS-routines58.html"))
    ("EOS_PT_ATTRINFO" fun nil (system) "Result = %s( pointID, attrname, numbertype, count)" ("EOS-routines59.html"))
    ("EOS_PT_BCKLINKINFO" fun nil (system) "Result = %s(pointID, level, linkfield)" ("EOS-routines60.html"))
    ("EOS_PT_CLOSE" fun nil (system) "Result = %s(fid)" ("EOS-routines61.html"))
    ("EOS_PT_CREATE" fun nil (system) "Result = %s(fid, pointname)" ("EOS-routines62.html"))
    ("EOS_PT_DEFBOXREGION" fun nil (system) "Result = %s(pointID, cornerlon, cornerlat)" ("EOS-routines63.html"))
    ("EOS_PT_DEFLEVEL" fun nil (system) "Result = %s(pointID, levelname, fieldlist, fieldtype, fieldorder)" ("EOS-routines64.html"))
    ("EOS_PT_DEFLINKAGE" fun nil (system) "Result = %s(pointID, parent, child, linkfield)" ("EOS-routines65.html"))
    ("EOS_PT_DEFTIMEPERIOD" fun nil (system) "Result = %s(pointID, starttime, stoptime)" ("EOS-routines66.html"))
    ("EOS_PT_DEFVRTREGION" fun nil (system) "Result = %s( pointID, regionID, vertObj, range)" ("EOS-routines67.html"))
    ("EOS_PT_DETACH" fun nil (system) "Result = %s(pointID)" ("EOS-routines68.html"))
    ("EOS_PT_EXTRACTPERIOD" fun nil (system) "Result = %s(pointID, periodID, level, fieldlist, buffer)" ("EOS-routines69.html"))
    ("EOS_PT_EXTRACTREGION" fun nil (system) "Result = %s( pointID, regionID, level, fieldlist, buffer)" ("EOS-routines70.html"))
    ("EOS_PT_FWDLINKINFO" fun nil (system) "Result = %s(pointID, level, linkfield)" ("EOS-routines71.html"))
    ("EOS_PT_GETLEVELNAME" fun nil (system) "Result = %s( pointID, level, levelname)" ("EOS-routines72.html" ("LENGTH" . 1017099)))
    ("EOS_PT_GETRECNUMS" fun nil (system) "Result = %s( pointID, inlevel, outlevel, inNrec, inRecs, outNrec, outRecs)" ("EOS-routines73.html"))
    ("EOS_PT_INQATTRS" fun nil (system) "Result = %s( pointID, attrlist)" ("EOS-routines74.html" ("LENGTH" . 1017172)))
    ("EOS_PT_INQPOINT" fun nil (system) "Result = %s( filename, pointlist)" ("EOS-routines75.html" ("LENGTH" . 1017203)))
    ("EOS_PT_LEVELINDX" fun nil (system) "Result = %s( pointID, levelname)" ("EOS-routines76.html"))
    ("EOS_PT_LEVELINFO" fun nil (system) "Result = %s(pointID, level, fieldlist, fldtype, fldorder)" ("EOS-routines77.html"))
    ("EOS_PT_NFIELDS" fun nil (system) "Result = %s( pointID, level)" ("EOS-routines78.html" ("LENGTH" . 1017295)))
    ("EOS_PT_NLEVELS" fun nil (system) "Result = %s(pointID)" ("EOS-routines79.html"))
    ("EOS_PT_NRECS" fun nil (system) "Result = %s( pointID, level)" ("EOS-routines80.html"))
    ("EOS_PT_OPEN" fun nil (system) "Result = %s( fieldname)" ("EOS-routines81.html" ("CREATE" . 1017375) ("RDWR" . 1024341) ("READ" . 1024343)))
    ("EOS_PT_PERIODINFO" fun nil (system) "Result = %s(pointID, periodID, level, fieldlist, size)" ("EOS-routines82.html"))
    ("EOS_PT_PERIODRECS" fun nil (system) "Result = %s(pointID, periodID, level, nrec, recs)" ("EOS-routines83.html"))
    ("EOS_PT_QUERY" fun nil (system) "Result = %s( Filename, PointName, [Info] )" ("EOS-routines84.html"))
    ("EOS_PT_READATTR" fun nil (system) "Result = %s(pointID, attrname, datbuf)" ("EOS-routines85.html"))
    ("EOS_PT_READLEVEL" fun nil (system) "Result = %s(pointID, level, fieldlist, nrec, recs, buffer)" ("EOS-routines86.html"))
    ("EOS_PT_REGIONINFO" fun nil (system) "Result = %s(pointID, regionID, level, fieldlist, size)" ("EOS-routines87.html"))
    ("EOS_PT_REGIONRECS" fun nil (system) "Result = %s(pointID, regionID, level, nrec, recs)" ("EOS-routines88.html"))
    ("EOS_PT_SIZEOF" fun nil (system) "Result = %s(pointID, fieldlist, fldlevel)" ("EOS-routines89.html"))
    ("EOS_PT_UPDATELEVEL" fun nil (system) "Result = %s(pointID, level, field, list, nrec, recs, data)" ("EOS-routines90.html"))
    ("EOS_PT_WRITEATTR" fun nil (system) "Result = %s( pointID, attrname, datbuf)" ("EOS-routines91.html" ("COUNT" . 1017685) ("HDF_TYPE" . 1024378)))
    ("EOS_PT_WRITELEVEL" fun nil (system) "Result = %s(pointID, level, nrec, data)" ("EOS-routines92.html"))
    ("EOS_QUERY" fun nil (system) "Result = %s( Filename, [Info] )" ("EOS-routines93.html"))
    ("EOS_SW_ATTACH" fun nil (system) "Result = %s(fid, swathname)" ("EOS-routines94.html"))
    ("EOS_SW_ATTRINFO" fun nil (system) "Result = %s(swathID, attrname, numbertype, count)" ("EOS-routines95.html"))
    ("EOS_SW_CLOSE" fun nil (system) "Result = %s(fid)" ("EOS-routines96.html"))
    ("EOS_SW_COMPINFO" fun nil (system) "Result = %s(swathID, fieldname, compcode, compparm)" ("EOS-routines97.html"))
    ("EOS_SW_CREATE" fun nil (system) "Result = %s(fid, swathname)" ("EOS-routines98.html"))
    ("EOS_SW_DEFBOXREGION" fun nil (system) "Result = %s(swathID, cornerlon, cornerlat, mode)" ("EOS-routines99.html"))
    ("EOS_SW_DEFCOMP" fun nil (system) "Result = %s( swathID, compcode, [, compparm] )" ("EOS-routines100.html"))
    ("EOS_SW_DEFDATAFIELD" fun nil (system) "Result = %s( swathID, fieldname, dimlist, numbertype)" ("EOS-routines101.html" ("MERGE" . 1017975)))
    ("EOS_SW_DEFDIM" fun nil (system) "Result = %s(swathID, fieldname, dim)" ("EOS-routines102.html"))
    ("EOS_SW_DEFDIMMAP" fun nil (system) "Result = %s(swathID, geodim, datadim, offset, increment)" ("EOS-routines103.html"))
    ("EOS_SW_DEFGEOFIELD" fun nil (system) "Result = %s( swathID, fieldname, dimlist, numbertype)" ("EOS-routines104.html" ("MERGE" . 1022830)))
    ("EOS_SW_DEFIDXMAP" fun nil (system) "Result = %s(swathID, geodim, datadim, index)" ("EOS-routines105.html"))
    ("EOS_SW_DEFTIMEPERIOD" fun nil (system) "Result = %s(swathID, starttime , stoptime, mode)" ("EOS-routines106.html"))
    ("EOS_SW_DEFVRTREGION" fun nil (system) "Result = %s(swathID, regionID, vertObj, range)" ("EOS-routines107.html"))
    ("EOS_SW_DETACH" fun nil (system) "Result = %s(swathID)" ("EOS-routines108.html"))
    ("EOS_SW_DIMINFO" fun nil (system) "Result = %s(swathID, dimname)" ("EOS-routines109.html"))
    ("EOS_SW_DUPREGION" fun nil (system) "Result = %s(regionID)" ("EOS-routines110.html"))
    ("EOS_SW_EXTRACTPERIOD" fun nil (system) "Result = %s(swathID, periodID, fieldname, external_mode, buffer)" ("EOS-routines111.html"))
    ("EOS_SW_EXTRACTREGION" fun nil (system) "Result = %s(swathID, regionID, fieldname, external_mode, buffer)" ("EOS-routines112.html"))
    ("EOS_SW_FIELDINFO" fun nil (system) "Result = %s(swathID, fieldname, rank, dims, numbertype, dimlist)" ("EOS-routines113.html"))
    ("EOS_SW_GETFILLVALUE" fun nil (system) "Result = %s(swathID, fieldname, fillvalue)" ("EOS-routines114.html"))
    ("EOS_SW_IDXMAPINFO" fun nil (system) "Result = %s(swathID, geodim, datadim, index)" ("EOS-routines115.html"))
    ("EOS_SW_INQATTRS" fun nil (system) "Result = %s( swathID, attrlist)" ("EOS-routines116.html" ("LENGTH" . 1018488)))
    ("EOS_SW_INQDATAFIELDS" fun nil (system) "Result = %s(swathID, fieldlist, rank, numbertype)" ("EOS-routines117.html"))
    ("EOS_SW_INQDIMS" fun nil (system) "Result = %s(swathID, dimname, dim)" ("EOS-routines118.html"))
    ("EOS_SW_INQGEOFIELDS" fun nil (system) "Result = %s(swathID, fieldlist, rank, numbertype)" ("EOS-routines119.html"))
    ("EOS_SW_INQIDXMAPS" fun nil (system) "Result = %s(swathID, idxmap, idxsizes)" ("EOS-routines120.html"))
    ("EOS_SW_INQMAPS" fun nil (system) "Result = %s(swathID, dimmap, offset, increment)" ("EOS-routines121.html"))
    ("EOS_SW_INQSWATH" fun nil (system) "Result = %s( filename, swathlist)" ("EOS-routines122.html" ("LENGTH" . 1018674)))
    ("EOS_SW_MAPINFO" fun nil (system) "Result = %s(swathID, geodim, datadim, offset, increment)" ("EOS-routines123.html"))
    ("EOS_SW_NENTRIES" fun nil (system) "Result = %s( swathID, entrycode)" ("EOS-routines124.html" ("LENGTH" . 1018745)))
    ("EOS_SW_OPEN" fun nil (system) "Result = %s( filename)" ("EOS-routines125.html" ("CREATE" . 1018776) ("RDWR" . 1024156) ("READ" . 1024157)))
    ("EOS_SW_PERIODINFO" fun nil (system) "Result = %s(swathID, periodID, fieldname, ntype, rank, dims, size)" ("EOS-routines126.html"))
    ("EOS_SW_QUERY" fun nil (system) "Result=%s(Filename, SwathName, [Info])" ("EOS-routines127.html"))
    ("EOS_SW_READATTR" fun nil (system) "Result = %s(swathID, attrname, datbuf)" ("EOS-routines128.html"))
    ("EOS_SW_READFIELD" fun nil (system) "Result = %s( swathID, fieldname, buffer)" ("EOS-routines129.html" ("EDGE" . 1018883) ("START" . 1024163) ("STRIDE" . 1024164)))
    ("EOS_SW_REGIONINFO" fun nil (system) "Result = %s(swathID, regionID, fieldname, ntype, rank, dims, size)" ("EOS-routines130.html"))
    ("EOS_SW_SETFILLVALUE" fun nil (system) "Result = %s(swathID, fieldname, fillvalue)" ("EOS-routines131.html"))
    ("EOS_SW_WRITEATTR" fun nil (system) "Result = %s( swathID, attrname, datbuf)" ("EOS-routines132.html" ("COUNT" . 1019002) ("HDF_TYPE" . 1024170)))
    ("EOS_SW_WRITEDATAMETA" fun nil (system) "Result = %s(swathID, fieldname, dimlist, numbertype)" ("EOS-routines133.html"))
    ("EOS_SW_WRITEFIELD" fun nil (system) "Result = %s( swathID, fieldname, data)" ("EOS-routines134.html" ("EDGE" . 1026788) ("START" . 1026786) ("STRIDE" . 1025378)))
    ("EOS_SW_WRITEGEOMETA" fun nil (system) "Result = %s(swathID, fieldname, dimlist, numbertype)" ("EOS-routines135.html"))
    ("ERF" fun nil (system) "Result = %s(Z)" ("E10.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ERFC" fun nil (system) "Result = %s(Z)" ("E11.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ERFCX" fun nil (system) "Result = %s(Z)" ("E12.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ERODE" fun nil (system) "Result = %s( Image, Structure [, X0 [, Y0 [, Z0]]])" ("E13.html" ("GRAY" . 989437) ("PRESERVE_TYPE" . 989439) ("UINT" . 989441) ("ULONG" . 989443) ("VALUES" . 989445)))
    ("EXECUTE" fun nil (system) "Result = %s(String [, QuietCompile] [, QuietExecution])" ("E15.html"))
    ("EXP" fun nil (system) "Result = %s(Expression)" ("E17.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("EXPAND_PATH" fun nil (system) "Result = %s( String)" ("E19.html" ("ALL_DIRS" . 987744) ("ARRAY" . 987739) ("COUNT" . 676819) ("DLM" . 987893) ("HELP" . 987895)))
    ("EXPINT" fun nil (system) "Result = %s( N, X)" ("E20.html" ("DOUBLE" . 50644) ("EPS" . 997966) ("ITER" . 997968) ("ITMAX" . 997920)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("EXTRAC" fun nil (system) "Result = %s( Array, C1, C2, ..., Cn, S1, S2, ..., Sn )" ("E21.html"))
    ("EXTRACT_SLICE" fun nil (system) "Result = %s( Vol, Xsize, Ysize, Xcenter, Ycenter, Zcenter, Xrot, Yrot, Zrot)" ("E22.html" ("ANISOTROPY" . 985393) ("OUT_VAL" . 988206) ("RADIANS" . 758834) ("SAMPLE" . 758840) ("VERTICES" . 985402)))
    ("F_CVF" fun nil (system) "Result = %s(P, Dfn, Dfd)" ("F.html"))
    ("F_PDF" fun nil (system) "Result = %s(V, Dfn, Dfd)" ("F2.html"))
    ("FACTORIAL" fun nil (system) "Result = %s( N)" ("F3.html" ("STIRLING" . 54500) ("UL64" . 880257)))
    ("FFT" fun nil (system) "Result = %s( Array [, Direction])" ("F4.html" ("DIMENSION" . 37862) ("DOUBLE" . 882851) ("INVERSE" . 37868) ("OVERWRITE" . 676843)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("FILE_BASENAME" fun nil (system) "Result = %s(Path [, RemoveSuffix])" ("F5.html" ("FOLD_CASE" . 922324)))
    ("FILE_DIRNAME" fun nil (system) "Result = %s(Path)" ("F9.html" ("MARK_DIRECTORY" . 922462)))
    ("FILE_EXPAND_PATH" fun nil (system) "Result = %s (Path)" ("F10.html"))
    ("FILE_INFO" fun nil (system) "Result = %s(Path)" ("F11.html" ("NOEXPAND_PATH" . 883815)))
    ("FILE_LINES" fun nil (system) "Result = %s(Path)" ("F12.html" ("COMPRESS" . 910561) ("NOEXPAND_PATH" . 910559)))
    ("FILE_READLINK" fun nil (system) "Result = %s(Path)" ("F16.html" ("ALLOW_NONEXISTENT" . 906651) ("ALLOW_NONSYMLINK" . 906653) ("NOEXPAND_PATH" . 906655)))
    ("FILE_SAME" fun nil (system) "Result = %s(Path1, Path2)" ("F17.html" ("NOEXPAND_PATH" . 906717)))
    ("FILE_SEARCH" fun nil (system) "Result = %s(Path_Specification) or Result = %s(Dir_Specification, Recur_Pattern)" ("F18.html" ("COUNT" . 883932) ("EXPAND_ENVIRONMENT" . 883934) ("EXPAND_TILDE" . 883941) ("FOLD_CASE" . 883947) ("FULLY_QUALIFY_PATH" . 883949) ("ISSUE_ACCESS_ERROR" . 883957) ("MARK_DIRECTORY" . 883959) ("MATCH_ALL_INITIAL_DOT" . 883965) ("MATCH_INITIAL_DOT" . 883967) ("NOSORT" . 883969) ("QUOTE" . 883975) ("TEST_BLOCK_SPECIAL" . 900969) ("TEST_CHARACTER_SPECIAL" . 900971) ("TEST_DANGLING_SYMLINK" . 900973) ("TEST_DIRECTORY" . 883984) ("TEST_EXECUTABLE" . 883986) ("TEST_GROUP" . 900983) ("TEST_NAMED_PIPE" . 900993) ("TEST_READ" . 883991) ("TEST_REGULAR" . 883994) ("TEST_SETGID" . 901003) ("TEST_SETUID" . 901005) ("TEST_SOCKET" . 901015) ("TEST_STICKY_BIT" . 901017) ("TEST_SYMLINK" . 901019) ("TEST_USER" . 901021) ("TEST_WRITE" . 883996) ("TEST_ZERO_LENGTH" . 883999) ("WINDOWS_SHORT_NAMES" . 932747)))
    ("FILE_TEST" fun nil (system) "Result = %s( File)" ("F19.html" ("BLOCK_SPECIAL" . 901098) ("CHARACTER_SPECIAL" . 901108) ("DANGLING_SYMLINK" . 901110) ("DIRECTORY" . 882375) ("EXECUTABLE" . 882377) ("GET_MODE" . 882382) ("GROUP" . 901120) ("NAMED_PIPE" . 901122) ("NOEXPAND_PATH" . 883024) ("READ" . 882391) ("REGULAR" . 882393) ("SETGID" . 901132) ("SETUID" . 901134) ("SOCKET" . 901136) ("STICKY_BIT" . 901143) ("SYMLINK" . 901145) ("USER" . 901152) ("WRITE" . 882395) ("ZERO_LENGTH" . 882397)))
    ("FILE_WHICH" fun nil (system) "Result = %s( [Path, ] File)" ("F20.html" ("INCLUDE_CURRENT_DIR" . 882459)))
    ("FILEPATH" fun nil (system) "Result = %s( Filename)" ("F21.html" ("ROOT_DIR" . 762284) ("SUBDIRECTORY" . 762286) ("TERMINAL" . 762290) ("TMP" . 762292)))
    ("FINDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("F22.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("FINITE" fun nil (system) "Result = %s( X)" ("F23.html" ("INFINITY" . 862771) ("NAN" . 862772) ("SIGN" . 887616)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("FIX" fun nil (system) "Result = %s( Expression [, Offset [, D1 [, ..., D8]]])" ("F24.html" ("PRINT" . 871518) ("TYPE" . 871524)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("FLOAT" fun nil (system) "Result = %s( Expression [, Offset [, D1 [, ..., D8]]] )" ("F26.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("FLOOR" fun nil (system) "Result = %s(X)" ("F27.html" ("L64" . 875894)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("FLTARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("F29.html" ("NOZERO" . 676947)))
    ("FORMAT_AXIS_VALUES" fun nil (system) "Result = %s( Values )" ("F32.html"))
    ("FSTAT" fun nil (system) "Result = %s(Unit)" ("F35.html"))
    ("FULSTR" fun nil (system) "Result = %s(A)" ("F36.html"))
    ("FV_TEST" fun nil (system) "Result = %s(X, Y)" ("F39.html"))
    ("FX_ROOT" fun nil (system) "Result = %s(X, Func)" ("F40.html" ("DOUBLE" . 749893) ("ITMAX" . 749897) ("STOP" . 749899) ("TOL" . 749901)))
    ("FZ_ROOTS" fun nil (system) "Result = %s(C)" ("F41.html" ("DOUBLE" . 52525) ("EPS" . 902541) ("NO_POLISH" . 902543)))
    ("GAMMA" fun nil (system) "Result = %s(Z)" ("G.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("GAUSS2DFIT" fun nil (system) "Result = %s( Z, A [, X, Y])" ("G5.html" ("NEGATIVE" . 199709) ("TILT" . 199711)))
    ("GAUSS_CVF" fun nil (system) "Result = %s(P)" ("G3.html"))
    ("GAUSS_PDF" fun nil (system) "Result = %s(V)" ("G4.html"))
    ("GAUSSFIT" fun nil (system) "Result = %s( X, Y [, A])" ("G6.html" ("CHISQ" . 881490) ("ESTIMATES" . 841704) ("MEASURE_ERRORS" . 841712) ("NTERMS" . 889863) ("SIGMA" . 881498) ("YERROR" . 881500)))
    ("GAUSSINT" fun nil (system) "Result = %s(X)" ("G7.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("GET_DRIVE_LIST" fun nil (system) "Result = %s()" ("G8.html" ("CDROM" . 884482) ("COUNT" . 876351) ("FIXED" . 876358) ("REMOTE" . 878573) ("REMOVABLE" . 878575)))
    ("GET_KBRD" fun nil (system) "Result = %s(Wait)" ("G9.html"))
    ("GET_SCREEN_SIZE" fun nil (system) "Result = %s( [Display_name])" ("G11.html" ("DISPLAY_NAME" . 841676) ("RESOLUTION" . 853571)))
    ("GETENV" fun nil (system) "Result = %s( Name)" ("G12.html" ("ENVIRONMENT" . 887078)))
    ("GRID3" fun nil (system) "Result = %s( X, Y, Z, F, Gx, Gy, Gz)" ("G16.html" ("DELTA" . 677098) ("DTOL" . 168207) ("GRID" . 677100) ("NGRID" . 677102) ("START" . 677104)))
    ("GRID_TPS" fun nil (system) "Result = %s (Xp, Yp, Values)" ("G15.html" ("COEFFICIENTS" . 871830) ("DELTA" . 871832) ("NGRID" . 871834) ("START" . 871836)))
    ("GRIDDATA" fun nil (system) "Result = %s( X, F ) or Result = %s( X, Y, F ) or Result = %s( X, Y, Z, F)" ("G17.html" ("ANISOTROPY" . 877568) ("DEGREES" . 877573) ("DELTA" . 877575) ("DIMENSION" . 877578) ("EMPTY_SECTORS" . 877581) ("FAULT_POLYGONS" . 877584) ("FAULT_XY" . 877588) ("FUNCTION_TYPE" . 877591) ("GRID" . 877652) ("INVERSE_DISTANCE" . 877655) ("KRIGING" . 877657) ("LINEAR" . 877659) ("MAX_PER_SECTOR" . 877661) ("METHOD" . 877664) ("MIN_CURVATURE" . 877713) ("MIN_POINTS" . 877715) ("MISSING" . 877719) ("NATURAL_NEIGHBOR" . 877723) ("NEAREST_NEIGHBOR" . 877726) ("NEIGHBORHOOD" . 877729) ("POLYNOMIAL_REGRESSION" . 877733) ("POWER" . 877749) ("QUINTIC" . 877752) ("RADIAL_BASIS_FUNCTION" . 877755) ("SEARCH_ELLIPSE" . 877757) ("SECTORS" . 877761) ("SHEPARDS" . 877763) ("SMOOTHING" . 877766) ("SPHERE" . 877769) ("START" . 877771) ("TRIANGLES" . 877774) ("VARIOGRAM" . 877778) ("XOUT" . 877781) ("YOUT" . 877784)))
    ("GS_ITER" fun nil (system) "Result = %s( A, B)" ("G18.html" ("CHECK" . 750095) ("DOUBLE" . 875451) ("LAMBDA" . 750097) ("MAX_ITER" . 750102) ("TOL" . 872926) ("X_0" . 750104)))
    ("H5_BROWSER" fun nil (system) "Result = %s([Files])" ("H4.html" ("DIALOG_READ" . 885865)))
    ("H5_GET_LIBVERSION" fun nil (system) "Result = %s( )" ("HDF5-routines11.html"))
    ("H5_PARSE" fun nil (system) "Result = %s (File)" ("HDF5-routines13.html" ("FILE" . 1148311) ("PATH" . 1148313) ("READ_DATA" . 1148315)))
    ("H5A_GET_NAME" fun nil (system) "Result = %s(Attribute_id)" ("HDF5-routines15.html"))
    ("H5A_GET_NUM_ATTRS" fun nil (system) "Result = %s(Loc_id)" ("HDF5-routines16.html"))
    ("H5A_GET_SPACE" fun nil (system) "Result = %s(Attribute_id)" ("HDF5-routines17.html"))
    ("H5A_GET_TYPE" fun nil (system) "Result = %s(Attribute_id)" ("HDF5-routines18.html"))
    ("H5A_OPEN_IDX" fun nil (system) "Result = %s(Loc_id, Index)" ("HDF5-routines19.html"))
    ("H5A_OPEN_NAME" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines20.html"))
    ("H5A_READ" fun nil (system) "Result = %s(Attribute_id)" ("HDF5-routines21.html"))
    ("H5D_GET_SPACE" fun nil (system) "Result = %s(Dataset_id)" ("HDF5-routines23.html"))
    ("H5D_GET_STORAGE_SIZE" fun nil (system) "Result = %s(Dataset_id)" ("HDF5-routines24.html"))
    ("H5D_GET_TYPE" fun nil (system) "Result = %s(Dataset_id)" ("HDF5-routines25.html"))
    ("H5D_OPEN" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines26.html"))
    ("H5D_READ" fun nil (system) "Result = %s(Dataset_id)" ("HDF5-routines27.html" ("FILE_SPACE" . 1148824) ("MEMORY_SPACE" . 1148826)))
    ("H5F_IS_HDF5" fun nil (system) "Result = %s(Filename)" ("HDF5-routines29.html"))
    ("H5F_OPEN" fun nil (system) "Result = %s(Filename)" ("HDF5-routines30.html"))
    ("H5G_GET_COMMENT" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines32.html"))
    ("H5G_GET_LINKVAL" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines33.html"))
    ("H5G_GET_MEMBER_NAME" fun nil (system) "Result = %s(Loc_id, Name, Index)" ("HDF5-routines34.html"))
    ("H5G_GET_NMEMBERS" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines35.html"))
    ("H5G_GET_OBJINFO" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines36.html" ("FOLLOW_LINK" . 1149214)))
    ("H5G_OPEN" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines37.html"))
    ("H5I_GET_TYPE" fun nil (system) "Result = %s(Obj_id)" ("HDF5-routines38.html"))
    ("H5R_DEREFERENCE" fun nil (system) "Result = %s(Loc_id, Reference)" ("HDF5-routines39.html"))
    ("H5R_GET_OBJECT_TYPE" fun nil (system) "Result = %s(Loc_id, Reference)" ("HDF5-routines40.html"))
    ("H5S_COPY" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines42.html"))
    ("H5S_CREATE_SIMPLE" fun nil (system) "Result = %s(Dimensions)" ("HDF5-routines43.html" ("MAX_DIMENSIONS" . 1149414)))
    ("H5S_GET_SELECT_BOUNDS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines44.html"))
    ("H5S_GET_SELECT_ELEM_NPOINTS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines45.html"))
    ("H5S_GET_SELECT_ELEM_POINTLIST" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines46.html" ("NUMBER" . 1149508) ("START" . 1149506)))
    ("H5S_GET_SELECT_HYPER_BLOCKLIST" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines47.html" ("NUMBER" . 1149544) ("START" . 1149542)))
    ("H5S_GET_SELECT_HYPER_NBLOCKS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines48.html"))
    ("H5S_GET_SELECT_NPOINTS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines49.html"))
    ("H5S_GET_SIMPLE_EXTENT_DIMS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines50.html" ("MAX_DIMENSIONS" . 1149642)))
    ("H5S_GET_SIMPLE_EXTENT_NDIMS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines51.html"))
    ("H5S_GET_SIMPLE_EXTENT_NPOINTS" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines52.html"))
    ("H5S_GET_SIMPLE_EXTENT_TYPE" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines53.html"))
    ("H5S_IS_SIMPLE" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines54.html"))
    ("H5S_SELECT_VALID" fun nil (system) "Result = %s(Dataspace_id)" ("HDF5-routines60.html"))
    ("H5T_COMMITTED" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines62.html"))
    ("H5T_COPY" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines63.html"))
    ("H5T_EQUAL" fun nil (system) "Result = %s(Datatype_id1, Datatype_id2)" ("HDF5-routines64.html"))
    ("H5T_GET_ARRAY_DIMS" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines65.html" ("PERMUTATIONS" . 1150077)))
    ("H5T_GET_ARRAY_NDIMS" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines66.html"))
    ("H5T_GET_CLASS" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines67.html"))
    ("H5T_GET_CSET" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines68.html"))
    ("H5T_GET_EBIAS" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines69.html"))
    ("H5T_GET_FIELDS" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines70.html"))
    ("H5T_GET_INPAD" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines71.html"))
    ("H5T_GET_MEMBER_CLASS" fun nil (system) "Result = %s(Datatype_id, Member)" ("HDF5-routines72.html"))
    ("H5T_GET_MEMBER_NAME" fun nil (system) "Result = %s(Datatype_id, Member)" ("HDF5-routines73.html"))
    ("H5T_GET_MEMBER_OFFSET" fun nil (system) "Result = %s(Datatype_id, Member)" ("HDF5-routines74.html"))
    ("H5T_GET_MEMBER_TYPE" fun nil (system) "Result = %s(Datatype_id, Member)" ("HDF5-routines75.html"))
    ("H5T_GET_NMEMBERS" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines76.html"))
    ("H5T_GET_NORM" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines77.html"))
    ("H5T_GET_OFFSET" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines78.html"))
    ("H5T_GET_ORDER" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines79.html"))
    ("H5T_GET_PAD" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines80.html"))
    ("H5T_GET_PRECISION" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines81.html"))
    ("H5T_GET_SIGN" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines82.html"))
    ("H5T_GET_SIZE" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines83.html"))
    ("H5T_GET_STRPAD" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines84.html"))
    ("H5T_GET_SUPER" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines85.html"))
    ("H5T_IDLTYPE" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines86.html" ("ARRAY_DIMENSIONS" . 1150764) ("STRUCTURE" . 1150766)))
    ("H5T_MEMTYPE" fun nil (system) "Result = %s(Datatype_id)" ("HDF5-routines87.html"))
    ("H5T_OPEN" fun nil (system) "Result = %s(Loc_id, Name)" ("HDF5-routines88.html"))
    ("HANNING" fun nil (system) "Result = %s( N1 [, N2])" ("H5.html" ("ALPHA" . 758100) ("DOUBLE" . 874103)))
    ("HDF_AN_ANNLEN" fun nil (system) "Result = %s(Annotation_id)" ("HDF-routines8.html"))
    ("HDF_AN_ANNLIST" fun nil (system) "Result = %s(Annotation_id, Annotation_type, Object_tag, Object_ref, Annotation_list)" ("HDF-routines9.html"))
    ("HDF_AN_ATYPE2TAG" fun nil (system) "Result = %s(Annotation_type)" ("HDF-routines10.html"))
    ("HDF_AN_CREATE" fun nil (system) "Result = %s(Annotation_id, Object_tag, Object_ref, Annotation_type)" ("HDF-routines11.html"))
    ("HDF_AN_CREATEF" fun nil (system) "Result = %s(Annotation_id, Annotation_type)" ("HDF-routines12.html"))
    ("HDF_AN_FILEINFO" fun nil (system) "Result = %s(Annotation_id, n_file_labels, n_file_descs, n_data_labels, n_data_descs)" ("HDF-routines15.html"))
    ("HDF_AN_GET_TAGREF" fun nil (system) "Result = %s(Annotation_id, index, Annotation_type, Annotation_tag, Annotation_ref)" ("HDF-routines16.html"))
    ("HDF_AN_NUMANN" fun nil (system) "Result = %s(Annotation_id, Annotation_type, Object_tag, Object_ref)" ("HDF-routines18.html"))
    ("HDF_AN_READANN" fun nil (system) "Result = %s( Annotation_id, annotation)" ("HDF-routines19.html" ("LENGTH" . 1056839)))
    ("HDF_AN_SELECT" fun nil (system) "Result = %s(Annotation_id, index, Annotation_type)" ("HDF-routines20.html"))
    ("HDF_AN_START" fun nil (system) "Result = %s(file_id)" ("HDF-routines21.html"))
    ("HDF_AN_WRITEANN" fun nil (system) "Result = %s( Annotation_id, annotation)" ("HDF-routines24.html" ("LENGTH" . 1056941)))
    ("HDF_ANNOTATION_ID2TAGREF" fun nil (system) "Result = %s(Annotation_id, Annotation_tag, Annotation_ref)" ("HDF-routines17.html"))
    ("HDF_ANNOTATION_TAG2ATYPE" fun nil (system) "Result = %s(Annotation_tag)" ("HDF-routines22.html"))
    ("HDF_ANNOTATION_TAGREF2ID" fun nil (system) "Result = %s(Annotation_id, Annotation_tag, Annotation_ref)" ("HDF-routines23.html"))
    ("HDF_BROWSER" fun nil (system) "Template = %s([Filename])" ("H7.html" ("CANCEL" . 852206) ("GROUP" . 870963) ("PREFIX" . 852209)))
    ("HDF_DF24_LASTREF" fun nil (system) "Result = %s( )" ("HDF-routines30.html"))
    ("HDF_DF24_NIMAGES" fun nil (system) "Result = %s(Filename)" ("HDF-routines31.html"))
    ("HDF_DFAN_LABLIST" fun nil (system) "Result = %s( Filename, Tag, Reflist, Labellist)" ("HDF-routines40.html" ("LISTSIZE" . 997374) ("MAXLABEL" . 997377) ("STARTPOS" . 997380) ("STRING" . 997383)))
    ("HDF_DFAN_LASTREF" fun nil (system) "Result = %s( )" ("HDF-routines41.html"))
    ("HDF_DFP_LASTREF" fun nil (system) "Result = %s( )" ("HDF-routines46.html"))
    ("HDF_DFP_NPALS" fun nil (system) "Result = %s(Filename)" ("HDF-routines47.html"))
    ("HDF_DFR8_LASTREF" fun nil (system) "Result = %s( )" ("HDF-routines55.html"))
    ("HDF_DFR8_NIMAGES" fun nil (system) "Result = %s(Filename)" ("HDF-routines56.html"))
    ("HDF_EXISTS" fun nil (system) "Result = %s( )" ("HDF-routines62.html"))
    ("HDF_GR_ATTRINFO" fun nil (system) "Result = %s(obj_id, attr_index, name, data_type, count)" ("HDF-routines63.html"))
    ("HDF_GR_CREATE" fun nil (system) "Result = %s(gr_id, name, ncomp, data_type, interlace_mode, dim_sizes)" ("HDF-routines64.html"))
    ("HDF_GR_FILEINFO" fun nil (system) "Result = %s(gr_id, n_images, n_file_attrs)" ("HDF-routines67.html"))
    ("HDF_GR_FINDATTR" fun nil (system) "Result = %s(obj_id, attr_name)" ("HDF-routines68.html"))
    ("HDF_GR_GETATTR" fun nil (system) "Result = %s(obj_id, attr_index, values)" ("HDF-routines69.html"))
    ("HDF_GR_GETCHUNKINFO" fun nil (system) "Result = %s(ri_id, dim_length, flag)" ("HDF-routines70.html"))
    ("HDF_GR_GETIMINFO" fun nil (system) "Result = %s(ri_id, gr_name, ncomp, data_type, interlace_mode, dim_sizes, num_attrs)" ("HDF-routines71.html"))
    ("HDF_GR_GETLUTID" fun nil (system) "Result = %s(ri_id, pal_index)" ("HDF-routines72.html"))
    ("HDF_GR_GETLUTINFO" fun nil (system) "Result = %s(pal_id, ncomp, data_type, interlace_mode, num_entries)" ("HDF-routines73.html"))
    ("HDF_GR_IDTOREF" fun nil (system) "Result = %s(ri_id)" ("HDF-routines74.html"))
    ("HDF_GR_LUTTOREF" fun nil (system) "Result = %s(pal_id)" ("HDF-routines75.html"))
    ("HDF_GR_NAMETOINDEX" fun nil (system) "Result = %s(gr_id, gr_name)" ("HDF-routines76.html"))
    ("HDF_GR_READIMAGE" fun nil (system) "Result = %s( ri_id, data)" ("HDF-routines77.html" ("EDGE" . 1057619) ("INTERLACE" . 1057617) ("START" . 1057607) ("STRIDE" . 1057609)))
    ("HDF_GR_READLUT" fun nil (system) "Result = %s( pal_id, pal_data)" ("HDF-routines78.html" ("INTERLACE" . 1057387)))
    ("HDF_GR_REFTOINDEX" fun nil (system) "Result = %s(gr_id, gr_ref)" ("HDF-routines79.html"))
    ("HDF_GR_SELECT" fun nil (system) "Result = %s(gr_id, index)" ("HDF-routines80.html"))
    ("HDF_GR_SETATTR" fun nil (system) "Result = %s(obj_id, attr_name, data_type, count, values)" ("HDF-routines81.html"))
    ("HDF_GR_SETCHUNK" fun nil (system) "Result = %s(ri_id, dim_length, comp_type, comp_prm)" ("HDF-routines82.html"))
    ("HDF_GR_SETCHUNKCACHE" fun nil (system) "Result = %s(ri_id, maxcache, flags)" ("HDF-routines83.html"))
    ("HDF_GR_SETCOMPRESS" fun nil (system) "Result = %s(ri_id, comp_type, comp_prm)" ("HDF-routines84.html"))
    ("HDF_GR_SETEXTERNALFILE" fun nil (system) "Result = %s(ri_id, filename, offset)" ("HDF-routines85.html"))
    ("HDF_GR_START" fun nil (system) "Result = %s(file_id)" ("HDF-routines86.html"))
    ("HDF_GR_WRITEIMAGE" fun nil (system) "Result = %s( ri_id, data)" ("HDF-routines87.html" ("EDGE" . 1057693) ("INTERLACE" . 1057699) ("START" . 1057691) ("STRIDE" . 1057681)))
    ("HDF_GR_WRITELUT" fun nil (system) "Result = %s( pal_id, pal_data )" ("HDF-routines88.html"))
    ("HDF_HDF2IDLTYPE" fun nil (system) "Result = %s( hdftypecode )" ("HDF-routines89.html"))
    ("HDF_IDL2HDFTYPE" fun nil (system) "Result = %s( idltypecode )" ("HDF-routines90.html"))
    ("HDF_ISHDF" fun nil (system) "Result = %s(Filename)" ("HDF-routines91.html"))
    ("HDF_NEWREF" fun nil (system) "Result = %s(FileHandle)" ("HDF-routines93.html"))
    ("HDF_NUMBER" fun nil (system) "Result = %s( FileHandle)" ("HDF-routines94.html" ("TAG" . 998362)))
    ("HDF_OPEN" fun nil (system) "Result = %s( Filename)" ("HDF-routines95.html" ("ALL" . 998379) ("CREATE" . 998383) ("NUM_DD" . 998386) ("RDWR" . 998390) ("READ" . 998394) ("WRITE" . 998397)))
    ("HDF_PACKDATA" fun nil (system) "Result = %s( data1 [, data2 [, data3 [, data4 [, data5 [, data6 [, data7 [, data8]]]]]]])" ("HDF-routines96.html" ("HDF_ORDER" . 1042936) ("HDF_TYPE" . 1042939) ("NREC" . 1042942)))
    ("HDF_READ" fun nil (system) "Result = %s( [Filename])" ("H8.html" ("DF24" . 852278) ("DFR8" . 852275) ("PREFIX" . 871657) ("TEMPLATE" . 852281)))
    ("HDF_SD_ATTRFIND" fun nil (system) "Result = %s(SD_id, Name)" ("HDF-routines98.html"))
    ("HDF_SD_CREATE" fun nil (system) "Result = %s( SDinterface_id, Name, Dims)" ("HDF-routines101.html" ("BYTE" . 1053869) ("DFNT_CHAR88" . 1053872) ("DFNT_FLOAT32" . 1053875) ("DFNT_FLOAT64" . 1053878) ("DFNT_INT16" . 1053884) ("DFNT_INT32" . 1053887) ("DFNT_INT8" . 1053881) ("DFNT_UINT16" . 1053893) ("DFNT_UINT32" . 1053896) ("DFNT_UINT8" . 1053890) ("DOUBLE" . 1053899) ("FLOAT" . 1053902) ("HDF_TYPE" . 1106175) ("INT" . 1106171) ("LONG" . 1053908) ("SHORT" . 1053911) ("STRING" . 1053914)))
    ("HDF_SD_DIMGETID" fun nil (system) "Result = %s(SDdataset_id, Dimension_Number)" ("HDF-routines103.html"))
    ("HDF_SD_ISCOORDVAR" fun nil (system) "Result = %s(SDdataset_id)" ("HDF-routines111.html"))
    ("HDF_SD_NAMETOINDEX" fun nil (system) "Result = %s(SDinterface_id, SDS_Name)" ("HDF-routines112.html"))
    ("HDF_SD_REFTOINDEX" fun nil (system) "Result = %s(SDinterface_id, Reference_number)" ("HDF-routines113.html"))
    ("HDF_SD_SELECT" fun nil (system) "Result = %s(SDinterface_id, Number)" ("HDF-routines114.html"))
    ("HDF_SD_START" fun nil (system) "Result = %s( Filename)" ("HDF-routines118.html" ("CREATE" . 1054663) ("RDWR" . 1054661) ("READ" . 1054659)))
    ("HDF_SDINTERFACE_IDTOREF" fun nil (system) "Result = %s(SDdataset_id)" ("HDF-routines110.html"))
    ("HDF_VD_ATTACH" fun nil (system) "Result = %s( FileHandle, VData_id)" ("HDF-routines120.html" ("READ" . 999503) ("WRITE" . 999506)))
    ("HDF_VD_ATTRFIND" fun nil (system) "Result = %s(VData, FieldID, Name)" ("HDF-routines121.html"))
    ("HDF_VD_FEXIST" fun nil (system) "Result = %s(VData, Fieldnames)" ("HDF-routines126.html"))
    ("HDF_VD_FIND" fun nil (system) "Result = %s(FileHandle, Name)" ("HDF-routines127.html"))
    ("HDF_VD_GETID" fun nil (system) "Result = %s(FileHandle, VData_id)" ("HDF-routines129.html"))
    ("HDF_VD_ISATTR" fun nil (system) "Result = %s(VData)" ("HDF-routines132.html"))
    ("HDF_VD_ISVD" fun nil (system) "Result = %s(VGroup, Id)" ("HDF-routines133.html"))
    ("HDF_VD_LONE" fun nil (system) "Result = %s( FileHandle)" ("HDF-routines135.html" ("MAXSIZE" . 999761)))
    ("HDF_VD_NATTRS" fun nil (system) "Result = %s( VData, FieldID )" ("HDF-routines136.html"))
    ("HDF_VD_READ" fun nil (system) "Result = %s( VData, Data)" ("HDF-routines137.html" ("FIELDS" . 999788) ("FULL_INTERLACE" . 999791) ("NO_INTERLACE" . 999794) ("NRECORDS" . 999797)))
    ("HDF_VG_ATTACH" fun nil (system) "Result = %s( FileHandle, VGroup_id)" ("HDF-routines142.html" ("READ" . 999942) ("WRITE" . 999945)))
    ("HDF_VG_GETID" fun nil (system) "Result = %s(FileHandle, VGroup_id)" ("HDF-routines144.html"))
    ("HDF_VG_GETNEXT" fun nil (system) "Result = %s(VGroup, Id)" ("HDF-routines146.html"))
    ("HDF_VG_INQTR" fun nil (system) "Result = %s(VGroup, Tag, Ref)" ("HDF-routines149.html"))
    ("HDF_VG_ISVD" fun nil (system) "Result = %s(VGroup, Id)" ("HDF-routines151.html"))
    ("HDF_VG_ISVG" fun nil (system) "Result = %s(VGroup, Id)" ("HDF-routines152.html"))
    ("HDF_VG_LONE" fun nil (system) "Result = %s( FileHandle)" ("HDF-routines153.html" ("MAXSIZE" . 1000150)))
    ("HDF_VG_NUMBER" fun nil (system) "Result = %s(VGroup)" ("HDF-routines154.html"))
    ("HILBERT" fun nil (system) "Result = %s(X [, D])" ("H12.html"))
    ("HIST_2D" fun nil (system) "Result = %s( V1, V2)" ("H13.html" ("BIN1" . 832830) ("BIN2" . 832832) ("MAX1" . 832284) ("MAX2" . 832345) ("MIN1" . 832837) ("MIN2" . 832839)))
    ("HIST_EQUAL" fun nil (system) "Result = %s( A)" ("H14.html" ("BINSIZE" . 871698) ("FCN" . 876498) ("HISTOGRAM_ONLY" . 874403) ("MAXV" . 874687) ("MINV" . 758160) ("OMAX" . 875087) ("OMIN" . 875100) ("PERCENT" . 874600) ("TOP" . 874602)))
    ("HISTOGRAM" fun nil (system) "Result = %s( Array)" ("H15.html" ("BINSIZE" . 677175) ("INPUT" . 677177) ("L64" . 677180) ("LOCATIONS" . 886107) ("MAX" . 886113) ("MIN" . 677182) ("NAN" . 197674) ("NBINS" . 677184) ("OMAX" . 873903) ("OMIN" . 677186) ("REVERSE_INDICES" . 677188)))
    ("HOUGH" fun nil (system) "Result = %s( Array)" ("H17.html" ("BACKPROJECT" . 875957) ("DOUBLE" . 875960) ("DRHO" . 875962) ("DX" . 875964) ("DY" . 875966) ("GRAY" . 875968) ("NRHO" . 875970) ("NTHETA" . 875972) ("NX" . 875974) ("NY" . 875976) ("RHO" . 875978) ("RMIN" . 875980) ("THETA" . 875982) ("XMIN" . 875984) ("YMIN" . 875986)))
    ("HQR" fun nil (system) "Result = %s( A)" ("H18.html" ("COLUMN" . 871729) ("DOUBLE" . 50748)))
    ("IBETA" fun nil (system) "Result = %s( A, B, Z)" ("I.html" ("DOUBLE" . 875616) ("EPS" . 875618) ("ITER" . 875967) ("ITMAX" . 875622)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("IDENTITY" fun nil (system) "Result = %s( N)" ("I3.html" ("DOUBLE" . 832664)))
    ("IDL_VALIDNAME" fun nil (system) "Result = %s(String)" ("I4.html" ("CONVERT_ALL" . 937159) ("CONVERT_SPACES" . 937166)))
    ("IDLITSYS_CREATETOOL" fun nil (system) "Result = %s(StrTool)" ("I5.html" ("DIMENSIONS" . 984612) ("IDENTIFIER" . 984573) ("INITIAL_DATA" . 939956) ("LOCATION" . 984462) ("MACRO_NAMES" . 964508) ("NO_SAVEPROMPT" . 982826) ("OVERPLOT" . 939958) ("STYLE_NAME" . 984522) ("USER_INTERFACE" . 983497) ("VIEW_GRID" . 939979) ("VIEW_NEXT" . 939981) ("VIEW_NUMBER" . 939984) ("VISUALIZATION_TYPE" . 939987)))
    ("IGAMMA" fun nil (system) "Result = %s( A, Z)" ("I7.html" ("DOUBLE" . 875550) ("EPS" . 875548) ("ITER" . 875581) ("ITMAX" . 875579) ("METHOD" . 875520)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("IMAGINARY" fun nil (system) "Result = %s(Complex_Expression)" ("I11.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("INDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("I13.html" ("BYTE" . 862684) ("COMPLEX" . 862699) ("DCOMPLEX" . 862701) ("DOUBLE" . 862705) ("FLOAT" . 862707) ("L64" . 862711) ("LONG" . 862927) ("STRING" . 862930) ("TYPE" . 862752) ("UINT" . 862746) ("UL64" . 862748) ("ULONG" . 862750)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("INT_2D" fun nil (system) "Result = %s( Fxy, AB_Limits, PQ_Limits, Pts)" ("I14.html" ("DOUBLE" . 832191) ("ORDER" . 813280)))
    ("INT_3D" fun nil (system) "Result = %s( Fxyz, AB_Limits, PQ_Limits, UV_Limits, Pts)" ("I15.html" ("DOUBLE" . 813293)))
    ("INT_TABULATED" fun nil (system) "Result = %s( X, F)" ("I16.html" ("DOUBLE" . 875649) ("SORT" . 750310)))
    ("INTARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("I17.html" ("NOZERO" . 677253)))
    ("INTERPOL" fun nil (system) "Result = %s( V, N)" ("I18.html" ("LSQUADRATIC" . 872067) ("QUADRATIC" . 872072) ("SPLINE" . 872076)))
    ("INTERPOLATE" fun nil (system) "Result = %s( P, X [, Y [, Z]])" ("I19.html" ("CUBIC" . 680782) ("GRID" . 680781) ("MISSING" . 677276)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("INVERT" fun nil (system) "Result = %s( Array [, Status])" ("I21.html" ("DOUBLE" . 50809)))
    ("IOCTL" fun nil (system) "Result = %s( File_Unit [, Request, Arg])" ("I22.html" ("BY_VALUE" . 677325) ("MT_OFFLINE" . 677327) ("MT_REWIND" . 677329) ("MT_SKIP_FILE" . 677331) ("MT_SKIP_RECORD" . 677333) ("MT_WEOF" . 677335) ("SUPPRESS_ERROR" . 677337)))
    ("ISHFT" fun nil (system) "Result = %s(P1, P2)" ("I24.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ITGETCURRENT" fun nil (system) "Result = %s()" ("I30.html" ("TOOL" . 941481)))
    ("JULDAY" fun nil (system) "Result = %s(Month, Day, Year, Hour, Minute, Second)" ("J2.html"))
    ("KEYWORD_SET" fun nil (system) "Result = %s(Expression)" ("K.html"))
    ("KRIG2D" fun nil (system) "Result = %s( Z [, X, Y])" ("K2.html" ("BOUNDS" . 750620) ("EXPONENTIAL" . 750596) ("GS" . 930292) ("NX" . 750622) ("NY" . 750624) ("REGULAR" . 750607) ("SPHERICAL" . 750598) ("XGRID" . 750609) ("XVALUES" . 750611) ("YGRID" . 750613) ("YVALUES" . 750615)))
    ("KURTOSIS" fun nil (system) "Result = %s(X)" ("K3.html" ("DOUBLE" . 859078) ("NAN" . 860892)))
    ("KW_TEST" fun nil (system) "Result = %s( X)" ("K4.html" ("DF" . 53675) ("MISSING" . 53678)))
    ("L64INDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("L.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("LA_CHOLMPROVE" fun nil (system) "Result = %s( Array, Achol, B, X)" ("L3.html" ("BACKWARD_ERROR" . 969194) ("DOUBLE" . 969196) ("FORWARD_ERROR" . 969198) ("UPPER" . 969200)))
    ("LA_CHOLSOL" fun nil (system) "Result = %s( A, B)" ("L4.html" ("DOUBLE" . 969317) ("UPPER" . 969319)))
    ("LA_DETERM" fun nil (system) "Result = %s( A)" ("L5.html" ("CHECK" . 969400) ("DOUBLE" . 969402) ("ZERO" . 969404)))
    ("LA_EIGENPROBLEM" fun nil (system) "Result = %s( A [, B])" ("L6.html" ("ALPHA" . 969502) ("BALANCE" . 969505) ("BETA" . 969512) ("DOUBLE" . 969515) ("EIGENVECTORS" . 969517) ("LEFT_EIGENVECTORS" . 969520) ("NORM_BALANCE" . 969523) ("PERMUTE_RESULT" . 969525) ("RCOND_VALUE" . 969527) ("RCOND_VECTOR" . 969529) ("SCALE_RESULT" . 969531) ("STATUS" . 969533)))
    ("LA_EIGENQL" fun nil (system) "Result = %s( A [, B])" ("L7.html" ("DOUBLE" . 969688) ("EIGENVECTORS" . 969690) ("FAILED" . 969692) ("GENERALIZED" . 969695) ("METHOD" . 969701) ("RANGE" . 969707) ("SEARCH_RANGE" . 969709) ("STATUS" . 969712) ("TOLERANCE" . 969723)))
    ("LA_EIGENVEC" fun nil (system) "Result = %s( T, QZ)" ("L8.html" ("BALANCE" . 969898) ("DOUBLE" . 969901) ("EIGENINDEX" . 969903) ("LEFT_EIGENVECTORS" . 969906) ("PERMUTE_RESULT" . 969908) ("RCOND_VALUE" . 969910) ("RCOND_VECTOR" . 969912) ("SCALE_RESULT" . 969914) ("SELECT" . 969916)))
    ("LA_ELMHES" fun nil (system) "Result = %s( Array [, Q])" ("L9.html" ("BALANCE" . 970060) ("DOUBLE" . 970067) ("NORM_BALANCE" . 970069) ("PERMUTE_RESULT" . 970071) ("SCALE_RESULT" . 970073)))
    ("LA_GM_LINEAR_MODEL" fun nil (system) "Result = %s( A, B, D, Y)" ("L10.html" ("DOUBLE" . 970161)))
    ("LA_HQR" fun nil (system) "Result = %s(H [, Q])" ("L11.html" ("DOUBLE" . 970266) ("PERMUTE_RESULT" . 970268) ("STATUS" . 970270)))
    ("LA_INVERT" fun nil (system) "Result = %s( A)" ("L12.html" ("DOUBLE" . 970351) ("STATUS" . 970353)))
    ("LA_LEAST_SQUARE_EQUALITY" fun nil (system) "Result = %s( A, B, C, D)" ("L13.html" ("DOUBLE" . 970448) ("RESIDUAL" . 970450)))
    ("LA_LEAST_SQUARES" fun nil (system) "Result = %s( A, B)" ("L14.html" ("DOUBLE" . 970563) ("METHOD" . 970565) ("RANK" . 970571) ("RCONDITION" . 970573) ("RESIDUAL" . 970575) ("STATUS" . 970577)))
    ("LA_LINEAR_EQUATION" fun nil (system) "Result = %s( Array, B)" ("L15.html" ("BACKWARD_ERROR" . 970657) ("DOUBLE" . 970659) ("FORWARD_ERROR" . 970661) ("STATUS" . 970663)))
    ("LA_LUMPROVE" fun nil (system) "Result = %s( Array, Aludc, Index, B, X)" ("L17.html" ("BACKWARD_ERROR" . 970892) ("DOUBLE" . 970894) ("FORWARD_ERROR" . 970896)))
    ("LA_LUSOL" fun nil (system) "Result = %s( A, Index, B)" ("L18.html" ("DOUBLE" . 971007)))
    ("LA_TRIMPROVE" fun nil (system) "Result = %s( AL, A, AU, DAL, DA, DAU, DU2, Index, B, X)" ("L21.html" ("BACKWARD_ERROR" . 971423) ("DOUBLE" . 971425) ("FORWARD_ERROR" . 971427)))
    ("LA_TRISOL" fun nil (system) "Result = %s( AL, A, AU, U2, Index, B)" ("L24.html" ("DOUBLE" . 971725)))
    ("LABEL_DATE" fun nil (system) "Result = %s()" ("L25.html" ("AM_PM" . 939222) ("DATE_FORMAT" . 939215) ("DAYS_OF_WEEK" . 939285) ("MONTHS" . 939288) ("OFFSET" . 939291) ("ROUND_UP" . 940951)))
    ("LABEL_REGION" fun nil (system) "Result = %s( Data)" ("L26.html" ("ALL_NEIGHBORS" . 930484) ("EIGHT" . 828027) ("ULONG" . 677395)))
    ("LADFIT" fun nil (system) "Result = %s( X, Y)" ("L27.html" ("ABSDEV" . 53730) ("DOUBLE" . 837069)))
    ("LAGUERRE" fun nil (system) "Result = %s( X, N [, K])" ("L28.html" ("COEFFICIENTS" . 942495) ("DOUBLE" . 942497)))
    ("LEEFILT" fun nil (system) "Result = %s( A [, N [, Sig]])" ("L29.html" ("DOUBLE" . 939800) ("EXACT" . 833703)))
    ("LEGENDRE" fun nil (system) "Result = %s( X, L [, M])" ("L30.html" ("DOUBLE" . 942590)))
    ("LINBCG" fun nil (system) "Result = %s( A, B, X)" ("L31.html" ("DOUBLE" . 50883) ("ITER" . 50896) ("ITMAX" . 50899) ("ITOL" . 50886) ("TOL" . 50893)))
    ("LINDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("L32.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("LINFIT" fun nil (system) "Result = %s( X, Y)" ("L33.html" ("CHISQ" . 53778) ("COVAR" . 940616) ("DOUBLE" . 837073) ("MEASURE_ERRORS" . 53781) ("PROB" . 941301) ("SDEV" . 941420) ("SIGMA" . 941423) ("YFIT" . 941298)))
    ("LL_ARC_DISTANCE" fun nil (system) "Result = %s( Lon_lat0, Arc_Dist, Az)" ("L35.html" ("DEGREES" . 758227)))
    ("LMFIT" fun nil (system) "Result = %s( X, Y, A)" ("L36.html" ("ALPHA" . 849263) ("CHISQ" . 831462) ("CONVERGENCE" . 831464) ("COVAR" . 831689) ("DOUBLE" . 831466) ("FITA" . 831077) ("FUNCTION_NAME" . 831083) ("ITER" . 831471) ("ITMAX" . 831092) ("ITMIN" . 831094) ("MEASURE_ERRORS" . 941497) ("SIGMA" . 940586) ("TOL" . 940573) ("WEIGHTS" . 940578)))
    ("LMGR" fun nil (system) "Result = %s()" ("L37.html" ("CLIENTSERVER" . 879327) ("DEMO" . 856060) ("EMBEDDED" . 856064) ("EXPIRE_DATE" . 932522) ("FORCE_DEMO" . 856072) ("INSTALL_NUM" . 932505) ("LMHOSTID" . 856081) ("RUNTIME" . 856085) ("SITE_NOTICE" . 932539) ("STUDENT" . 856089) ("TRIAL" . 856094) ("VM" . 996553)))
    ("LNGAMMA" fun nil (system) "Result = %s(Z)" ("L38.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("LNP_TEST" fun nil (system) "Result = %s( X, Y)" ("L39.html" ("DOUBLE" . 54544) ("HIFAC" . 941916) ("JMAX" . 54547) ("OFAC" . 54550) ("WK1" . 54553) ("WK2" . 54556)))
    ("LOCALE_GET" fun nil (system) "Result = %s( )" ("L41.html"))
    ("LOGICAL_AND" fun nil (system) "Result = %s(Arg1, Arg2)" ("L42.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("LOGICAL_OR" fun nil (system) "Result = %s(Arg1, Arg2)" ("L43.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("LOGICAL_TRUE" fun nil (system) "Result = %s(Arg)" ("L44.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("LON64ARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("L45.html" ("NOZERO" . 918880)))
    ("LONARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("L46.html" ("NOZERO" . 916558)))
    ("LONG" fun nil (system) "Result = %s( Expression[, Offset [, D1 [, ..., D8]]] )" ("L47.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("LONG64" fun nil (system) "Result = %s( Expression[, Offset [, D1 [, ..., D8]]] )" ("L48.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("LSODE" fun nil (system) "Result = %s( Y, X, H, Derivs[, Status])" ("L49.html" ("ATOL" . 904984) ("QUIET" . 1014877) ("RTOL" . 905036)))
    ("LU_COMPLEX" fun nil (system) "Result = %s( A, B)" ("L50.html" ("DOUBLE" . 750791) ("INVERSE" . 48859) ("SPARSE" . 37275)))
    ("LUMPROVE" fun nil (system) "Result = %s( A, Alud, Index, B, X)" ("L52.html" ("COLUMN" . 58736) ("DOUBLE" . 51323)))
    ("LUSOL" fun nil (system) "Result = %s(A, Index, B)" ("L53.html" ("COLUMN" . 58727) ("DOUBLE" . 50997)))
    ("M_CORRELATE" fun nil (system) "Result = %s( X, Y)" ("M.html" ("DOUBLE" . 956112)))
    ("MACHAR" fun nil (system) "Result = %s()" ("M2.html" ("DOUBLE" . 928847)))
    ("MAKE_ARRAY" fun nil (system) "Result = %s ( [D1 [, ..., D8]])" ("M3.html" ("BYTE" . 887432) ("COMPLEX" . 887435) ("DCOMPLEX" . 887438) ("DIMENSION" . 887441) ("DOUBLE" . 887444) ("FLOAT" . 887447) ("INDEX" . 887450) ("INTEGER" . 887453) ("L64" . 916074) ("LONG" . 887456) ("NOZERO" . 887459) ("OBJ" . 887462) ("PTR" . 887465) ("SIZE" . 887468) ("STRING" . 887471) ("TYPE" . 887474) ("UINT" . 918501) ("UL64" . 918504) ("ULONG" . 916082) ("VALUE" . 887480)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("MAP_2POINTS" fun nil (system) "Result = %s( lon0, lat0, lon1, lat1)" ("M5.html" ("DPATH" . 960572) ("METERS" . 960574) ("MILES" . 960576) ("NPATH" . 960578) ("PARAMETERS" . 960581) ("RADIANS" . 960583) ("RADIUS" . 960585) ("RHUMB" . 960587)))
    ("MAP_IMAGE" fun nil (system) "Result = %s( Image [, Startx, Starty [, Xsize, Ysize]])" ("M8.html" ("BILINEAR" . 903532) ("COMPRESS" . 887760) ("LATMAX" . 887748) ("LATMIN" . 887745) ("LONMAX" . 887754) ("LONMIN" . 887751) ("MAP_STRUCTURE" . 1060029) ("MASK" . 1061279) ("MAX_VALUE" . 887766) ("MIN_VALUE" . 887770) ("MISSING" . 887774) ("SCALE" . 887763)))
    ("MAP_PATCH" fun nil (system) "Result = %s( Image_Orig [, Lons, Lats])" ("M9.html" ("LAT0" . 958167) ("LAT1" . 887838) ("LON0" . 887841) ("LON1" . 887844) ("MAX_VALUE" . 928019) ("MISSING" . 887847) ("TRIANGULATE" . 887853) ("XSIZE" . 887856) ("XSTART" . 887859) ("YSIZE" . 887862) ("YSTART" . 887865)))
    ("MAP_PROJ_FORWARD" fun nil (system) "Result = %s(Longitude [, Latitude])" ("M10.html" ("CONNECTIVITY" . 999199) ("FILL" . 999209) ("MAP_STRUCTURE" . 1059849) ("POLYGONS" . 999214) ("POLYLINES" . 999218) ("RADIANS" . 999222)))
    ("MAP_PROJ_IMAGE" fun nil (system) "Result = %s(Image [, Range])" ("M11.html" ("BILINEAR" . 1062551) ("DIMENSIONS" . 1062553) ("IMAGE_STRUCTURE" . 1062555) ("MAP_STRUCTURE" . 1062557) ("MASK" . 1062562) ("MAX_VALUE" . 1062565) ("MIN_VALUE" . 1062567) ("MISSING" . 1062569) ("UVRANGE" . 1062571)))
    ("MAP_PROJ_INIT" fun nil (system) "Result = %s(Projection)" ("M13.html" ("CENTER_AZIMUTH" . 999986) ("CENTER_LATITUDE" . 999988) ("CENTER_LONGITUDE" . 999990) ("DATUM" . 999770) ("FALSE_EASTING" . 999992) ("FALSE_NORTHING" . 999994) ("GCTP" . 999952) ("HEIGHT" . 999996) ("HOM_AZIM_ANGLE" . 1000000) ("HOM_AZIM_LONGITUDE" . 999998) ("HOM_LATITUDE1" . 1000002) ("HOM_LATITUDE2" . 1000004) ("HOM_LONGITUDE1" . 1000006) ("HOM_LONGITUDE2" . 1000008) ("IS_JUSTIFY" . 1000012) ("IS_ZONES" . 1000010) ("LIMIT" . 999954) ("MERCATOR_SCALE" . 1000036) ("OEA_ANGLE" . 1000038) ("OEA_SHAPEM" . 1000040) ("OEA_SHAPEN" . 1000042) ("RADIANS" . 999959) ("RELAXED" . 999961) ("ROTATION" . 1000045) ("SAT_TILT" . 1000074) ("SEMIMAJOR_AXIS" . 1000048) ("SEMIMINOR_AXIS" . 1000050) ("SOM_FLAG" . 1000060) ("SOM_INCLINATION" . 1000052) ("SOM_LANDSAT_NUMBER" . 1000062) ("SOM_LANDSAT_PATH" . 1000064) ("SOM_LONGITUDE" . 1000054) ("SOM_PERIOD" . 1000056) ("SOM_RATIO" . 1000058) ("SPHERE_RADIUS" . 1000066) ("STANDARD_PAR1" . 1000070) ("STANDARD_PAR2" . 1000072) ("STANDARD_PARALLEL" . 1000068) ("TRUE_SCALE_LATITUDE" . 1000076) ("ZONE" . 1000078)))
    ("MAP_PROJ_INVERSE" fun nil (system) "Result = %s (X [, Y])" ("M14.html" ("MAP_STRUCTURE" . 1000165) ("RADIANS" . 1000170)))
    ("MATRIX_MULTIPLY" fun nil (system) "Result = %s( A, B)" ("M16.html" ("ATRANSPOSE" . 960661) ("BTRANSPOSE" . 960663)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("MATRIX_POWER" fun nil (system) "Result = %s(Array, N)" ("M17.html" ("DOUBLE" . 1000204) ("STATUS" . 1000207)))
    ("MAX" fun nil (system) "Result = %s( Array [, Max_Subscript])" ("M18.html" ("ABSOLUTE" . 1047888) ("DIMENSION" . 888204) ("MIN" . 963501) ("NAN" . 888207) ("SUBSCRIPT_MIN" . 929038)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("MD_TEST" fun nil (system) "Result = %s( X)" ("M19.html" ("ABOVE" . 888251) ("BELOW" . 888254) ("MDC" . 888257)))
    ("MEAN" fun nil (system) "Result = %s( X)" ("M20.html" ("DOUBLE" . 888313) ("NAN" . 888316)))
    ("MEANABSDEV" fun nil (system) "Result = %s( X)" ("M21.html" ("DOUBLE" . 888362) ("MEDIAN" . 888365) ("NAN" . 888368)))
    ("MEDIAN" fun nil (system) "Result = %s ( Array [, Width])" ("M22.html" ("DIMENSION" . 978207) ("DOUBLE" . 1047845) ("EVEN" . 978204)))
    ("MEMORY" fun nil (system) "Result = %s()" ("M23.html" ("CURRENT" . 960747) ("HIGHWATER" . 960749) ("L64" . 960751) ("NUM_ALLOC" . 960754) ("NUM_FREE" . 960756) ("STRUCTURE" . 960758)))
    ("MESH_CLIP" fun nil (system) "Result = %s (Plane, Vertsin, Connin, Vertsout, Connout)" ("M24.html" ("AUXDATA_IN" . 948402) ("AUXDATA_OUT" . 948404) ("CUT_VERTS" . 948406)))
    ("MESH_DECIMATE" fun nil (system) "Result = %s (Verts, Conn, Connout)" ("M25.html" ("PERCENT_POLYGONS" . 948433) ("PERCENT_VERTICES" . 948431) ("PROGRESS_CALLBACK" . 1051741) ("PROGRESS_METHOD" . 1020618) ("PROGRESS_OBJECT" . 1020641) ("PROGRESS_PERCENT" . 1020654) ("PROGRESS_USERDATA" . 1020660) ("VERTICES" . 1020667)))
    ("MESH_ISSOLID" fun nil (system) "Result = %s (Conn)" ("M26.html"))
    ("MESH_MERGE" fun nil (system) "Result = %s (Verts, Conn, Verts1, Conn1)" ("M27.html" ("COMBINE_VERTICES" . 948474) ("TOLERANCE" . 948480)))
    ("MESH_NUMTRIANGLES" fun nil (system) "Result = %s (Conn)" ("M28.html"))
    ("MESH_SMOOTH" fun nil (system) "Result = %s (Verts, Conn)" ("M30.html" ("FIXED_EDGE_VERTICES" . 948537) ("FIXED_VERTICES" . 948535) ("ITERATIONS" . 948533) ("LAMBDA" . 948539)))
    ("MESH_SURFACEAREA" fun nil (system) "Result = %s ( Verts, Conn)" ("M31.html" ("AUXDATA" . 948575) ("MOMENT" . 948577)))
    ("MESH_VALIDATE" fun nil (system) "Result = %s ( Verts, Conn)" ("M32.html" ("COMBINE_VERTICES" . 948607) ("PACK_VERTICES" . 949513) ("REMOVE_NAN" . 948611) ("TOLERANCE" . 948613)))
    ("MESH_VOLUME" fun nil (system) "Result = %s ( Verts, Conn)" ("M33.html" ("SIGNED" . 948632)))
    ("MIN" fun nil (system) "Result = %s( Array [, Min_Subscript])" ("M35.html" ("ABSOLUTE" . 1047943) ("DIMENSION" . 965599) ("MAX" . 963567) ("NAN" . 888740) ("SUBSCRIPT_MAX" . 965815)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("MIN_CURVE_SURF" fun nil (system) "Result = %s(Z [, X, Y])" ("M36.html" ("BOUNDS" . 888798) ("CONST" . 956696) ("DOUBLE" . 929725) ("GS" . 888796) ("NX" . 888800) ("NY" . 888802) ("REGULAR" . 888785) ("SPHERE" . 956689) ("TPS" . 888782) ("XGRID" . 888787) ("XOUT" . 888804) ("XPOUT" . 888808) ("XVALUES" . 888789) ("YGRID" . 888791) ("YOUT" . 888806) ("YPOUT" . 888808) ("YVALUES" . 888793)))
    ("MOMENT" fun nil (system) "Result = %s( X)" ("M39.html" ("DOUBLE" . 888958) ("MDEV" . 888961) ("NAN" . 888964) ("SDEV" . 888970)))
    ("MORPH_CLOSE" fun nil (system) "Result = %s (Image, Structure)" ("M40.html" ("GRAY" . 948649) ("PRESERVE_TYPE" . 948651) ("UINT" . 948653) ("ULONG" . 948655) ("VALUES" . 948657)))
    ("MORPH_DISTANCE" fun nil (system) "Result = %s (Data)" ("M41.html" ("BACKGROUND" . 948898) ("NEIGHBOR_SAMPLING" . 948900) ("NO_COPY" . 948943)))
    ("MORPH_GRADIENT" fun nil (system) "Result = %s (Image, Structure)" ("M42.html" ("PRESERVE_TYPE" . 948983) ("UINT" . 948985) ("ULONG" . 948987) ("VALUES" . 948989)))
    ("MORPH_HITORMISS" fun nil (system) "Result = %s (Image, HitStructure, MissStructure)" ("M43.html"))
    ("MORPH_OPEN" fun nil (system) "Result = %s (Image, Structure)" ("M44.html" ("GRAY" . 949085) ("PRESERVE_TYPE" . 949087) ("UINT" . 949089) ("ULONG" . 949091) ("VALUES" . 949093)))
    ("MORPH_THIN" fun nil (system) "Result = %s ( Image, HitStructure, MissStructure )" ("M45.html"))
    ("MORPH_TOPHAT" fun nil (system) "Result = %s ( Image, Structure)" ("M46.html" ("PRESERVE_TYPE" . 949148) ("UINT" . 949150) ("ULONG" . 949152) ("VALUES" . 949154)))
    ("MPEG_OPEN" fun nil (system) "mpegID = %s( Dimensions)" ("M48.html" ("BITRATE" . 958969) ("FILENAME" . 958930) ("IFRAME_GAP" . 958935) ("MOTION_VEC_LENGTH" . 958939) ("QUALITY" . 958887)))
    ("N_ELEMENTS" fun nil (system) "Result = %s(Expression)" ("N.html"))
    ("N_PARAMS" fun nil (system) "Result = %s()" ("N2.html"))
    ("N_TAGS" fun nil (system) "Result = %s( Expression)" ("N3.html" ("DATA_LENGTH" . 889267) ("LENGTH" . 928988)))
    ("NCDF_ATTCOPY" fun nil (system) "Result = %s( Incdf [, Invar])" ("NetCDF-routines11.html" ("IN_GLOBAL" . 996938) ("OUT_GLOBAL" . 996942)))
    ("NCDF_ATTINQ" fun nil (system) "Result = %s( Cdfid [, Varid])" ("NetCDF-routines14.html" ("GLOBAL" . 997032)))
    ("NCDF_ATTNAME" fun nil (system) "Result = %s( Cdfid [, Varid])" ("NetCDF-routines15.html" ("GLOBAL" . 997094)))
    ("NCDF_CREATE" fun nil (system) "Result = %s( Filename)" ("NetCDF-routines20.html" ("CLOBBER" . 997292) ("NOCLOBBER" . 997295)))
    ("NCDF_DIMDEF" fun nil (system) "Result = %s( Cdfid, DimName, Size)" ("NetCDF-routines21.html" ("UNLIMITED" . 997333)))
    ("NCDF_DIMID" fun nil (system) "Result = %s( Cdfid, DimName )" ("NetCDF-routines22.html"))
    ("NCDF_EXISTS" fun nil (system) "Result = %s( )" ("NetCDF-routines25.html"))
    ("NCDF_INQUIRE" fun nil (system) "Result = %s(Cdfid)" ("NetCDF-routines26.html"))
    ("NCDF_OPEN" fun nil (system) "Result = %s( Filename)" ("NetCDF-routines27.html" ("NOWRITE" . 997434) ("WRITE" . 997437)))
    ("NCDF_VARDEF" fun nil (system) "Result = %s( Cdfid, Name [, Dim])" ("NetCDF-routines28.html" ("BYTE" . 997458) ("CHAR" . 997461) ("DOUBLE" . 997464) ("FLOAT" . 997467) ("LONG" . 997470) ("SHORT" . 997473)))
    ("NCDF_VARID" fun nil (system) "Result = %s(Cdfid, Name)" ("NetCDF-routines31.html"))
    ("NCDF_VARINQ" fun nil (system) "Result = %s(Cdfid, Varid)" ("NetCDF-routines32.html"))
    ("NEWTON" fun nil (system) "Result = %s( X, Vecfunc)" ("N5.html" ("CHECK" . 889318) ("DOUBLE" . 889321) ("ITMAX" . 928608) ("STEPMAX" . 889327) ("TOLF" . 889330) ("TOLMIN" . 889334) ("TOLX" . 889337)))
    ("NORM" fun nil (system) "Result = %s( A)" ("N6.html" ("DOUBLE" . 889381) ("LNORM" . 929047)))
    ("OBJ" fun nil (system) "Result = %s->[IDLitManipulatorManager::][IDLitManipulatorManager::]->GetDefaultManipulator()" ("objects_it125.html" ("REFERENCE" . 1004397)))
    ("OBJ_CLASS" fun nil (system) "Result = %s( [Arg])" ("O.html" ("COUNT" . 889415) ("SUPERCLASS" . 889418)))
    ("OBJ_ISA" fun nil (system) "Result = %s(ObjectInstance, ClassName)" ("O3.html"))
    ("OBJ_NEW" fun nil (system) "Result = %s( [ObjectClassName [, Arg1......Argn]] )" ("O4.html"))
    ("OBJ_VALID" fun nil (system) "Result = %s( [Arg])" ("O5.html" ("CAST" . 889505) ("COUNT" . 889508)))
    ("OBJARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("O6.html" ("NOZERO" . 889547)))
    ("P_CORRELATE" fun nil (system) "Result = %s( X, Y, C)" ("P.html" ("DOUBLE" . 1073021)))
    ("PATH_SEP" fun nil (system) "Result = %s()" ("P4.html" ("PARENT_DIRECTORY" . 1076856) ("SEARCH_PATH" . 1076858)))
    ("PCOMP" fun nil (system) "Result = %s( A)" ("P5.html" ("COEFFICIENTS" . 844766) ("COVARIANCE" . 844768) ("DOUBLE" . 844770) ("EIGENVALUES" . 844772) ("NVARIABLES" . 844774) ("STANDARDIZE" . 844776) ("VARIANCES" . 844778)))
    ("PNT_LINE" fun nil (system) "Result = %s( P0, L0, L1 [, Pl])" ("P11.html" ("INTERVAL" . 758337)))
    ("POLAR_SURFACE" fun nil (system) "Result = %s( Z, R, Theta)" ("P14.html" ("BOUNDS" . 753641) ("GRID" . 753637) ("MISSING" . 753645) ("QUINTIC" . 753643) ("SPACING" . 753639)))
    ("POLY" fun nil (system) "Result = %s(X, C)" ("P15.html"))
    ("POLY_2D" fun nil (system) "Result = %s( Array, P, Q [, Interp [, Dimx, Dimy]])" ("P16.html" ("CUBIC" . 678217) ("MISSING" . 680892)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("POLY_AREA" fun nil (system) "Result = %s( X, Y)" ("P17.html" ("DOUBLE" . 1074988) ("SIGNED" . 1074986)))
    ("POLY_FIT" fun nil (system) "Result = %s( X, Y, Degree)" ("P18.html" ("CHISQ" . 1073859) ("COVAR" . 1073862) ("DOUBLE" . 837040) ("MEASURE_ERRORS" . 1074498) ("SIGMA" . 1074050) ("STATUS" . 1073417) ("YBAND" . 1074058) ("YERROR" . 1074060) ("YFIT" . 1074062)))
    ("POLYFILLV" fun nil (system) "Result = %s( X, Y, Sx, Sy [, Run_Length] )" ("P20.html"))
    ("POLYSHADE" fun nil (system) "Result = %s( Vertices, Polygons) or Result = %s(X, Y, Z, Polygons)" ("P21.html" ("DATA" . 678323) ("NORMAL" . 678325) ("POLY_SHADES" . 678327) ("SHADES" . 678329) ("T3D" . 678331) ("TOP" . 678333) ("XSIZE" . 678335) ("YSIZE" . 678338)))
    ("PRIMES" fun nil (system) "Result = %s(K)" ("P25.html"))
    ("PRODUCT" fun nil (system) "Result = %s(Array [, Dimension])" ("P29.html" ("CUMULATIVE" . 1088999) ("INTEGER" . 1111663) ("NAN" . 1089001) ("PRESERVE_TYPE" . 1112722)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("PROFILE" fun nil (system) "Result = %s( Image [, XX, YY])" ("P30.html" ("NOMARK" . 757684) ("XSTART" . 757687) ("YSTART" . 757690)))
    ("PROJECT_VOL" fun nil (system) "Result = %s( Vol, X_Sample, Y_Sample, Z_Sample)" ("P33.html" ("AVG_INTENSITY" . 786865) ("CUBIC" . 1105686) ("DEPTH_Q" . 1105735) ("OPAQUE" . 786868) ("TRANS" . 786871) ("XSIZE" . 1105761) ("YSIZE" . 1105822) ("Z_BUFFER" . 1105820)))
    ("PTR_NEW" fun nil (system) "Result = %s( [InitExpr])" ("P38.html" ("ALLOCATE_HEAP" . 845063) ("NO_COPY" . 845065)))
    ("PTR_VALID" fun nil (system) "Result = %s( [Arg])" ("P39.html" ("CAST" . 863586) ("COUNT" . 863622)))
    ("PTRARR" fun nil (system) "Result = %s( D1, ... ..., D8)" ("P40.html" ("ALLOCATE_HEAP" . 845095) ("NOZERO" . 845097)))
    ("QGRID3" fun nil (system) "Result = %s( XYZ, F, Tetrahedra)" ("Q.html" ("DELTA" . 1073303) ("DIMENSION" . 1073305) ("MISSING" . 1073307) ("START" . 1073309)))
    ("QROMB" fun nil (system) "Result = %s( Func, A, B)" ("Q3.html" ("DOUBLE" . 51533) ("EPS" . 51536) ("JMAX" . 51539) ("K" . 51542)))
    ("QROMO" fun nil (system) "Result = %s(Func, A [, B])" ("Q4.html" ("DOUBLE" . 51594) ("EPS" . 51597) ("JMAX" . 51600) ("K" . 51603) ("MIDEXP" . 51606) ("MIDINF" . 51609) ("MIDPNT" . 51612) ("MIDSQL" . 51615) ("MIDSQU" . 51618)))
    ("QSIMP" fun nil (system) "Result = %s( Func, A, B)" ("Q5.html" ("DOUBLE" . 51671) ("EPS" . 51674) ("JMAX" . 51677)))
    ("QUERY_BMP" fun nil (system) "Result = %s ( Filename [, Info] )" ("Q7.html"))
    ("QUERY_DICOM" fun nil (system) "Result = %s( Filename [, Info])" ("Q8.html" ("IMAGE_INDEX" . 1045358)))
    ("QUERY_GIF" fun nil (system) "Result = %s ( Filename [, Info] )" ("Q9.html"))
    ("QUERY_IMAGE" fun nil (system) "Result = %s ( Filename[, Info])" ("Q10.html" ("CHANNELS" . 1070109) ("DIMENSIONS" . 1070111) ("HAS_PALETTE" . 1070113) ("IMAGE_INDEX" . 1070115) ("NUM_IMAGES" . 1070117) ("PIXEL_TYPE" . 1070119) ("SUPPORTED_READ" . 1070131) ("SUPPORTED_WRITE" . 1070133) ("TYPE" . 1104573)))
    ("QUERY_JPEG" fun nil (system) "Result = %s ( Filename [, Info] )" ("Q11.html"))
    ("QUERY_JPEG2000" fun nil (system) "Result = %s(Filename [, Info] )" ("Q12.html"))
    ("QUERY_MRSID" fun nil (system) "Result = %s( Filename [, Info])" ("Q13.html" ("LEVEL" . 1073601)))
    ("QUERY_PICT" fun nil (system) "Result = %s ( Filename [, Info] )" ("Q14.html"))
    ("QUERY_PNG" fun nil (system) "Result = %s ( Filename [, Info] )" ("Q15.html"))
    ("QUERY_PPM" fun nil (system) "Result = %s ( Filename [, Info])" ("Q16.html" ("MAXVAL" . 1045715)))
    ("QUERY_SRF" fun nil (system) "Result = %s (Filename [, Info] )" ("Q17.html"))
    ("QUERY_TIFF" fun nil (system) "Result = %s ( Filename [, Info])" ("Q18.html" ("GEOTIFF" . 1091493) ("IMAGE_INDEX" . 1045788)))
    ("QUERY_WAV" fun nil (system) "Result = %s ( Filename[, Info] )" ("Q19.html"))
    ("R_CORRELATE" fun nil (system) "Result = %s( X, Y)" ("R.html" ("D" . 54014) ("KENDALL" . 54017) ("PROBD" . 54020) ("ZD" . 54023)))
    ("R_TEST" fun nil (system) "Result = %s( X)" ("R2.html" ("N0" . 54060) ("N1" . 54063) ("R" . 54066)))
    ("RADON" fun nil (system) "Result = %s( Array)" ("R3.html" ("BACKPROJECT" . 1081929) ("DOUBLE" . 1081932) ("DRHO" . 1081934) ("DX" . 1081936) ("DY" . 1081938) ("GRAY" . 1081940) ("LINEAR" . 1081942) ("NRHO" . 1081944) ("NTHETA" . 1081946) ("NX" . 1081948) ("NY" . 1081950) ("RHO" . 1081952) ("RMIN" . 1081954) ("THETA" . 1081956) ("XMIN" . 1081958) ("YMIN" . 1081960)))
    ("RANDOMN" fun nil (system) "Result = %s( Seed [, D1 [, ..., D8]])" ("R4.html" ("BINOMIAL" . 867947) ("DOUBLE" . 867736) ("GAMMA" . 1080709) ("LONG" . 1080819) ("NORMAL" . 867741) ("POISSON" . 867743) ("UNIFORM" . 867744)))
    ("RANDOMU" fun nil (system) "Result = %s( Seed [, D1 [, ..., D8]])" ("R5.html" ("BINOMIAL" . 868252) ("DOUBLE" . 1080874) ("GAMMA" . 868213) ("LONG" . 1080854) ("NORMAL" . 868216) ("POISSON" . 868219) ("UNIFORM" . 868222)))
    ("RANKS" fun nil (system) "Result = %s(X)" ("R6.html"))
    ("READ_ASCII" fun nil (system) "Result = %s( [Filename])" ("R9.html" ("COMMENT_SYMBOL" . 864824) ("COUNT" . 864541) ("DATA_START" . 864606) ("DELIMITER" . 865250) ("HEADER" . 865253) ("MISSING_VALUE" . 864515) ("NUM_RECORDS" . 864373) ("RECORD_START" . 678426) ("TEMPLATE" . 863940) ("VERBOSE" . 863965)))
    ("READ_BINARY" fun nil (system) "Result = %s ([Filename] | FileUnit)" ("R10.html" ("DATA_DIMS" . 1071927) ("DATA_START" . 1071929) ("DATA_TYPE" . 1071931) ("ENDIAN" . 1071933) ("TEMPLATE" . 1071937)))
    ("READ_BMP" fun nil (system) "Result = %s( Filename, [, R, G, B] [, Ihdr])" ("R11.html" ("RGB" . 867600)))
    ("READ_DICOM" fun nil (system) "Result = %s (Filename [, Red, Green, Blue])" ("R12.html" ("IMAGE_INDEX" . 1045423)))
    ("READ_IMAGE" fun nil (system) "Result = %s (Filename [, Red, Green, Blue])" ("R14.html" ("IMAGE_INDEX" . 1071963)))
    ("READ_JPEG2000" fun nil (system) "Result = %s(Filename [, Red, Green, Blue])" ("R17.html" ("DISCARD_LEVELS" . 1171494) ("MAX_LAYERS" . 1171497) ("ORDER" . 1171500) ("REGION" . 1171503)))
    ("READ_MRSID" fun nil (system) "Result = %s ( Filename)" ("R18.html" ("LEVEL" . 1086317) ("SUB_RECT" . 1086319)))
    ("READ_PNG" fun nil (system) "Result = %s ( Filename [, R, G, B])" ("R20.html" ("ORDER" . 1045842) ("TRANSPARENT" . 1045845) ("VERBOSE" . 1075225)))
    ("READ_SPR" fun nil (system) "Result = %s(Filename)" ("R22.html"))
    ("READ_SYLK" fun nil (system) "Result = %s( File)" ("R24.html" ("ARRAY" . 67837) ("COLMAJOR" . 67840) ("NCOLS" . 67844) ("NROWS" . 67847) ("STARTCOL" . 67850) ("STARTROW" . 67853) ("USEDOUBLES" . 67856) ("USELONGS" . 67859)))
    ("READ_TIFF" fun nil (system) "Result = %s( Filename [, R, G, B])" ("R25.html" ("CHANNELS" . 1078044) ("DOT_RANGE" . 1134312) ("GEOTIFF" . 966463) ("ICC_PROFILE" . 1134317) ("IMAGE_INDEX" . 966504) ("INTERLEAVE" . 1077871) ("ORIENTATION" . 948922) ("PHOTOSHOP" . 1134329) ("PLANARCONFIG" . 1086578) ("SUB_RECT" . 966525) ("VERBOSE" . 966492)))
    ("READ_WAV" fun nil (system) "Result = %s ( Filename [, Rate] )" ("R26.html"))
    ("READ_XWD" fun nil (system) "Result = %s( Filename[, R, G, B] )" ("R29.html"))
    ("REAL_PART" fun nil (system) "Result = %s(Z)" ("R32.html"))
    ("REBIN" fun nil (system) "Result = %s( Array, D1 [, ..., D8])" ("R33.html" ("SAMPLE" . 678500)))
    ("RECALL_COMMANDS" fun nil (system) "Result = %s()" ("R34.html"))
    ("RECON3" fun nil (system) "Result = %s( Images, Obj_Rot, Obj_Pos, Focal, Dist,Vol_Pos, Img_Ref, Img_Mag, Vol_Size)" ("R35.html" ("CUBIC" . 1079063) ("MISSING" . 787003) ("MODE" . 787006) ("QUIET" . 1086709)))
    ("REFORM" fun nil (system) "Result = %s( Array, D1 [, ..., D8])" ("R37.html" ("OVERWRITE" . 678529)))
    ("REGION_GROW" fun nil (system) "Result = %s(Array, ROIPixels)" ("R38.html" ("ALL_NEIGHBORS" . 1086463) ("NAN" . 1168470) ("STDDEV_MULTIPLIER" . 1086465) ("THRESHOLD" . 1086469)))
    ("REGRESS" fun nil (system) "Result = %s( X, Y)" ("R40.html" ("CHISQ" . 1078522) ("CONST" . 1078527) ("CORRELATION" . 1078530) ("DOUBLE" . 1078533) ("FTEST" . 1078535) ("MCORRELATION" . 1078538) ("MEASURE_ERRORS" . 1080427) ("RELATIVE_WEIGHT" . 1080465) ("SIGMA" . 1080460) ("STATUS" . 1078543) ("YFIT" . 1078803)))
    ("REPLICATE" fun nil (system) "Result = %s( Value, D1 [, ..., D8] )" ("R42.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("REVERSE" fun nil (system) "Result = %s( Array [, Subscript_Index])" ("R49.html" ("OVERWRITE" . 1077839)))
    ("RK4" fun nil (system) "Result = %s( Y, Dydx, X, H, Derivs)" ("R50.html" ("DOUBLE" . 51771)))
    ("ROBERTS" fun nil (system) "Result = %s(Image)" ("R51.html"))
    ("ROT" fun nil (system) "Result = %s( A, Angle, [Mag, X0, Y0])" ("R52.html" ("CUBIC" . 758912) ("INTERP" . 758909) ("MISSING" . 758915) ("PIVOT" . 758918)))
    ("ROTATE" fun nil (system) "Result = %s(Array, Direction)" ("R53.html"))
    ("ROUND" fun nil (system) "Result = %s(X)" ("R54.html" ("L64" . 1073244)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ROUTINE_INFO" fun nil (system) "Result = %s( [Routine])" ("R55.html" ("DISABLED" . 1068792) ("ENABLED" . 1068823) ("FUNCTIONS" . 1068790) ("PARAMETERS" . 845189) ("SOURCE" . 845200) ("SYSTEM" . 845207) ("UNRESOLVED" . 845209) ("VARIABLES" . 845211)))
    ("RS_TEST" fun nil (system) "Result = %s( X, Y)" ("R56.html" ("UX" . 54144) ("UY" . 54147)))
    ("S_TEST" fun nil (system) "Result = %s( X, Y)" ("S.html" ("ZDIFF" . 54194)))
    ("SAVGOL" fun nil (system) "Result = %s( Nleft, Nright, Order, Degree)" ("S3.html" ("DOUBLE" . 1098051)))
    ("SCOPE_LEVEL" fun nil (system) "Result = %s()" ("S6.html"))
    ("SCOPE_VARFETCH" fun nil (system) "Result = %s(VarName)" ("S7.html" ("COMMON" . 1215122) ("ENTER" . 1215135) ("LEVEL" . 1215145) ("REF_EXTRA" . 1215173)))
    ("SCOPE_VARNAME" fun nil (system) "Result = %s( [Var1[, ..., Varn]])" ("S8.html" ("COMMON" . 1215382) ("COUNT" . 1215393) ("LEVEL" . 1215399)))
    ("SEARCH2D" fun nil (system) "Result = %s( Array, Xpos, Ypos, Min_Val, Max_Val)" ("S9.html" ("DECREASE" . 758963) ("DIAGONAL" . 758972) ("INCREASE" . 758966) ("LPF_BAND" . 758969)))
    ("SEARCH3D" fun nil (system) "Result = %s( Array, Xpos, Ypos, Zpos, Min_Val, Max_Val)" ("S10.html" ("DECREASE" . 759017) ("DIAGONAL" . 759026) ("INCREASE" . 759020) ("LPF_BAND" . 759023)))
    ("SFIT" fun nil (system) "Result = %s( Data, Degree)" ("S15.html" ("IRREGULAR" . 1198892) ("KX" . 1199079) ("MAX_DEGREE" . 1198955)))
    ("SHIFT" fun nil (system) "Result = %s(Array, S1, ..., Sn)" ("S19.html"))
    ("SHMDEBUG" fun nil (system) "Result = %s(Enable)" ("S20.html"))
    ("SHMVAR" fun nil (system) "Result = %s(SegmentName [, D1, ..., D8])" ("S23.html" ("BYTE" . 1143650) ("COMPLEX" . 1143652) ("DCOMPLEX" . 1143654) ("DIMENSION" . 1143656) ("DOUBLE" . 1143658) ("FLOAT" . 1143660) ("INTEGER" . 1143662) ("L64" . 1143664) ("LONG" . 1143666) ("SIZE" . 1143668) ("TEMPLATE" . 1143673) ("TYPE" . 1143675) ("UINT" . 1143680) ("UL64" . 1143684) ("ULONG" . 1143682)))
    ("SIMPLEX" fun nil (system) "Result = %s( Zequation, Constraints, M1, M2, M3 [, Tableau [, Izrov [, Iposv]]])" ("S26.html" ("DOUBLE" . 1103779) ("EPS" . 1103781) ("STATUS" . 1103783)))
    ("SIN" fun nil (system) "Result = %s(X)" ("S27.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("SINDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("S28.html"))
    ("SINH" fun nil (system) "Result = %s(X)" ("S29.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("SIZE" fun nil (system) "Result = %s( Expression)" ("S30.html" ("DIMENSIONS" . 901281) ("FILE_LUN" . 901288) ("FILE_OFFSET" . 1199822) ("L64" . 1082592) ("N_DIMENSIONS" . 1082662) ("N_ELEMENTS" . 901298) ("SNAME" . 1199867) ("STRUCTURE" . 901301) ("TNAME" . 901328) ("TYPE" . 901331)))
    ("SKEWNESS" fun nil (system) "Result = %s( X)" ("S31.html" ("DOUBLE" . 901912) ("NAN" . 903224)))
    ("SMOOTH" fun nil (system) "Result = %s( Array, Width)" ("S35.html" ("EDGE_TRUNCATE" . 113915) ("MISSING" . 1101098) ("NAN" . 1101095)))
    ("SOBEL" fun nil (system) "Result = %s(Image)" ("S36.html"))
    ("SORT" fun nil (system) "Result = %s(Array)" ("S38.html" ("L64" . 1082892)))
    ("SPH_SCAT" fun nil (system) "Result = %s( Lon, Lat, F)" ("S41.html" ("BOUNDS" . 126851) ("BOUT" . 126868) ("GOUT" . 126871) ("GS" . 126862) ("NLAT" . 126875) ("NLON" . 126858)))
    ("SPHER_HARM" fun nil (system) "Result = %s( Theta, Phi, L, M)" ("S42.html" ("DOUBLE" . 1098257)))
    ("SPL_INIT" fun nil (system) "Result = %s( X, Y)" ("S43.html" ("DOUBLE" . 51818) ("YP0" . 51822) ("YPN_1" . 1095878)))
    ("SPL_INTERP" fun nil (system) "Result = %s( X, Y, Y2, X2)" ("S44.html" ("DOUBLE" . 51859)))
    ("SPLINE" fun nil (system) "Result = %s( X, Y, T [, Sigma])" ("S45.html" ("DOUBLE" . 1134574)))
    ("SPRSAB" fun nil (system) "Result = %s( A, B)" ("S47.html" ("DOUBLE" . 51917) ("THRESHOLD" . 51920)))
    ("SPRSAX" fun nil (system) "Result = %s( A, X)" ("S48.html" ("DOUBLE" . 51985)))
    ("SPRSIN" fun nil (system) "Result = %s( A)" ("S49.html" ("COLUMN" . 58754) ("DOUBLE" . 52033) ("THRESHOLD" . 52036)))
    ("SPRSTP" fun nil (system) "Result = %s(A)" ("S50.html"))
    ("SQRT" fun nil (system) "Result = %s(X)" ("S51.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("STANDARDIZE" fun nil (system) "Result = %s( A)" ("S52.html" ("DOUBLE" . 844918)))
    ("STDDEV" fun nil (system) "Result = %s( X)" ("S53.html" ("DOUBLE" . 901885) ("NAN" . 903234)))
    ("STRARR" fun nil (system) "Result = %s(D1 [, ..., D8])" ("S55.html"))
    ("STRCMP" fun nil (system) "Result = %s( String1, String2 [, N])" ("S56.html" ("FOLD_CASE" . 1069071)))
    ("STRCOMPRESS" fun nil (system) "Result = %s( String)" ("S57.html" ("REMOVE_ALL" . 679044)))
    ("STREGEX" fun nil (system) "Result = %s( StringExpression, RegularExpression)" ("S59.html" ("BOOLEAN" . 1069164) ("EXTRACT" . 1069170) ("FOLD_CASE" . 1069177) ("LENGTH" . 1069182) ("SUBEXPR" . 1069190)))
    ("STRING" fun nil (system) "Result = %s( Expression1, ..., Expressionn)" ("S61.html" ("AM_PM" . 1015738) ("DAYS_OF_WEEK" . 1015740) ("FORMAT" . 1015736) ("MONTHS" . 1015759) ("PRINT" . 679063)))
    ("STRJOIN" fun nil (system) "Result = %s( String [, Delimiter])" ("S62.html" ("SINGLE" . 1070986)))
    ("STRLEN" fun nil (system) "Result = %s(Expression)" ("S63.html"))
    ("STRLOWCASE" fun nil (system) "Result = %s(String)" ("S64.html"))
    ("STRMATCH" fun nil (system) "Result = %s( String, SearchString)" ("S65.html" ("FOLD_CASE" . 1071246)))
    ("STRMESSAGE" fun nil (system) "Result = %s( Err)" ("S66.html" ("BLOCK" . 923971) ("CODE" . 923974) ("NAME" . 923979)))
    ("STRMID" fun nil (system) "Result = %s(Expression, First_Character [, Length])" ("S67.html" ("REVERSE_OFFSET" . 1074174)))
    ("STRPOS" fun nil (system) "Result = %s( Expression, Search_String [, Pos])" ("S68.html" ("REVERSE_OFFSET" . 1074185) ("REVERSE_SEARCH" . 1074254)))
    ("STRSPLIT" fun nil (system) "Result = %s( String [, Pattern])" ("S70.html" ("COUNT" . 1071730) ("ESCAPE" . 1153687) ("EXTRACT" . 1071749) ("FOLD_CASE" . 1071757) ("LENGTH" . 1071761) ("PRESERVE_NULL" . 1071767) ("REGEX" . 1071772)))
    ("STRTRIM" fun nil (system) "Result = %s( String [, Flag] )" ("S71.html"))
    ("STRUPCASE" fun nil (system) "Result = %s(String)" ("S74.html"))
    ("SVDFIT" fun nil (system) "Result = %s( X, Y [, M])" ("S78.html" ("A" . 845481) ("CHISQ" . 845501) ("COVAR" . 845503) ("DOUBLE" . 845488) ("FUNCTION_NAME" . 754160) ("LEGENDRE" . 1093586) ("MEASURE_ERRORS" . 1094756) ("SIGMA" . 1093549) ("SING_VALUES" . 1144017) ("SINGULAR" . 845513) ("STATUS" . 1143910) ("TOL" . 1144024) ("VARIANCE" . 845515) ("WEIGHTS" . 1093555) ("YFIT" . 754165)))
    ("SVSOL" fun nil (system) "Result = %s( U, W, V, B)" ("S79.html" ("COLUMN" . 58776) ("DOUBLE" . 52150)))
    ("SWAP_ENDIAN" fun nil (system) "Result = %s(Variable)" ("S80.html" ("SWAP_IF_BIG_ENDIAN" . 1110629) ("SWAP_IF_LITTLE_ENDIAN" . 1110632)))
    ("SYSTIME" fun nil (system) "String = %s( [0 [, ElaspedSeconds]])" ("S83.html" ("JULIAN" . 1015505) ("SECONDS" . 1015507) ("UTC" . 1083080)))
    ("T_CVF" fun nil (system) "Result = %s(P, Df)" ("T.html"))
    ("T_PDF" fun nil (system) "Result = %s(V, Df)" ("T2.html"))
    ("TAG_NAMES" fun nil (system) "Result = %s( Expression)" ("T4.html" ("STRUCTURE_NAME" . 679363)))
    ("TAN" fun nil (system) "Result = %s(X)" ("T5.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("TANH" fun nil (system) "Result = %s(X)" ("T6.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("TEMPORARY" fun nil (system) "Result = %s(Variable)" ("T8.html"))
    ("TETRA_CLIP" fun nil (system) "Result = %s ( Plane, Vertsin, Connin, Vertsout, Connout)" ("T9.html" ("AUXDATA_IN" . 1071827) ("AUXDATA_OUT" . 1071829) ("CUT_VERTS" . 1071831)))
    ("TETRA_SURFACE" fun nil (system) "Result = %s (Verts, Connin)" ("T10.html"))
    ("TETRA_VOLUME" fun nil (system) "Result = %s ( Verts, Conn)" ("T11.html" ("AUXDATA" . 1071864) ("MOMENT" . 1071866)))
    ("THIN" fun nil (system) "Result = %s( Image)" ("T12.html" ("NEIGHBOR_COUNT" . 1069698) ("PRUNE" . 1069716)))
    ("TIMEGEN" fun nil (system) "Result = %s( [D1,...,D8])" ("T15.html" ("DAYS" . 1077148) ("FINAL" . 1077151) ("HOURS" . 1077154) ("MINUTES" . 1077156) ("MONTHS" . 1077158) ("SECONDS" . 1077160) ("START" . 1077162) ("STEP_SIZE" . 1077166) ("UNITS" . 1077168) ("YEAR" . 1077211)))
    ("TM_TEST" fun nil (system) "Result = %s( X, Y)" ("T16.html" ("PAIRED" . 54299) ("UNEQUAL" . 54302)))
    ("TOTAL" fun nil (system) "Result = %s( Array [, Dimension])" ("T17.html" ("CUMULATIVE" . 1070565) ("DOUBLE" . 1070569) ("INTEGER" . 1115757) ("NAN" . 47220) ("PRESERVE_TYPE" . 1116699)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("TRACE" fun nil (system) "Result = %s( A)" ("T18.html" ("DOUBLE" . 845005)))
    ("TRANSPOSE" fun nil (system) "Result = %s( Array [, P] )" ("T19.html"))
    ("TRI_SURF" fun nil (system) "Result = %s( Z [, X, Y])" ("T20.html" ("BOUNDS" . 758634) ("EXTRAPOLATE" . 758607) ("GS" . 758631) ("LINEAR" . 758610) ("MISSING" . 949473) ("NX" . 758637) ("NY" . 758640) ("REGULAR" . 851712) ("XGRID" . 758617) ("XVALUES" . 758620) ("YGRID" . 758623) ("YVALUES" . 758626)))
    ("TRIGRID" fun nil (system) "Result = %s( X, Y, Z, Triangles [, GS, Limits] ) or Result = %s( F , GS, Limits)" ("T22.html" ("DEGREES" . 679620) ("EXTRAPOLATE" . 126730) ("INPUT" . 128106) ("MAX_VALUE" . 128088) ("MIN_VALUE" . 128089) ("MISSING" . 679622) ("NX" . 1076987) ("NY" . 1076989) ("QUINTIC" . 679624) ("SPHERE" . 126737) ("XGRID" . 837019) ("XOUT" . 1075935) ("YGRID" . 837021) ("YOUT" . 1075879)))
    ("TRISOL" fun nil (system) "Result = %s( A, B, C, R)" ("T25.html" ("DOUBLE" . 52330)))
    ("TS_COEF" fun nil (system) "Result = %s( X, P)" ("T27.html" ("DOUBLE" . 1076434) ("MSE" . 54734)))
    ("TS_DIFF" fun nil (system) "Result = %s( X, K)" ("T28.html" ("DOUBLE" . 861958)))
    ("TS_FCAST" fun nil (system) "Result = %s( X, P, Nvalues)" ("T29.html" ("BACKCAST" . 223046) ("DOUBLE" . 223055)))
    ("TS_SMOOTH" fun nil (system) "Result = %s( X, Nvalues)" ("T30.html" ("BACKWARD" . 223123) ("DOUBLE" . 223168) ("FORWARD" . 223093) ("ORDER" . 223094)))
    ("TVRD" fun nil (system) "Result = %s( [X0 [, Y0 [, Nx [, Ny [, Channel]]]]])" ("T34.html" ("CHANNEL" . 679790) ("ORDER" . 679793) ("TRUE" . 679795) ("WORDS" . 679797)))
    ("UINDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("U.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("UINT" fun nil (system) "Result = %s( Expression[, Offset [, D1 [, ..., D8]]] )" ("U2.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("UINTARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("U3.html" ("NOZERO" . 950261)))
    ("UL64INDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("U4.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ULINDGEN" fun nil (system) "Result = %s(D1 [, ..., D8])" ("U5.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ULON64ARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("U6.html" ("NOZERO" . 950420)))
    ("ULONARR" fun nil (system) "Result = %s( D1 [, ..., D8])" ("U7.html" ("NOZERO" . 950477)))
    ("ULONG" fun nil (system) "Result = %s( Expression[, Offset [, D1 [, ..., D8]]] )" ("U8.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("ULONG64" fun nil (system) "Result = %s( Expression[, Offset [, D1 [, ..., D8]]] )" ("U9.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("UNIQ" fun nil (system) "Result = %s( Array [, Index] )" ("U10.html"))
    ("UNSHARP_MASK" fun nil (system) "Result = %s(Image)" ("U11.html" ("AMOUNT" . 968717) ("RADIUS" . 968720) ("THRESHOLD" . 968725) ("TRUE" . 968729)))
    ("VALUE_LOCATE" fun nil (system) "Result = %s ( Vector, Value)" ("V.html" ("L64" . 957054)))
    ("VARIANCE" fun nil (system) "Result = %s( X)" ("V2.html" ("DOUBLE" . 938748) ("NAN" . 938858)))
    ("VERT_T3D" fun nil (system) "Result = %s( Vertex_List)" ("V6.html" ("DOUBLE" . 787625) ("MATRIX" . 957551) ("NO_COPY" . 787628) ("NO_DIVIDE" . 787631) ("SAVE_DIVIDE" . 787634)))
    ("VOIGT" fun nil (system) "Result = %s(A, U)" ("V7.html") ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("VOXEL_PROJ" fun nil (system) "Result = %s( V [, RGBO])" ("V9.html" ("BACKGROUND" . 677308) ("CUTTING_PLANE" . 680823) ("INTERPOLATE" . 680824) ("MAXIMUM_INTENSITY" . 680825) ("STEP" . 680826) ("XSIZE" . 680827) ("YSIZE" . 680828) ("ZBUFFER" . 680829) ("ZPIXELS" . 680830)))
    ("WARP_TRI" fun nil (system) "Result = %s( Xo, Yo, Xi, Yi, Image)" ("W2.html" ("EXTRAPOLATE" . 758734) ("OUTPUT_SIZE" . 758728) ("QUINTIC" . 758731) ("TPS" . 967342)))
    ("WATERSHED" fun nil (system) "Result = %s ( Image)" ("W3.html" ("CONNECTIVITY" . 961172) ("LONG" . 1049951) ("NREGIONS" . 1049960)))
    ("WHERE" fun nil (system) "Result = %s( Array_Expression [, Count])" ("W7.html" ("COMPLEMENT" . 964874) ("L64" . 964006) ("NCOMPLEMENT" . 964887)) ("tpoolkeyw2.html" ("TPOOL_MAX_ELTS" . 333417) ("TPOOL_MIN_ELTS" . 333286) ("TPOOL_NOTHREAD" . 333289)))
    ("WIDGET_ACTIVEX" fun nil (system) "Result = %s( Parent, COM_ID)" ("W9.html" ("ALIGN_BOTTOM" . 970441) ("ALIGN_CENTER" . 970444) ("ALIGN_LEFT" . 970446) ("ALIGN_RIGHT" . 970448) ("ALIGN_TOP" . 970450) ("EVENT_FUNC" . 970453) ("EVENT_PRO" . 970455) ("FUNC_GET_VALUE" . 970458) ("ID_TYPE" . 970461) ("KILL_NOTIFY" . 970465) ("NO_COPY" . 970471) ("NOTIFY_REALIZE" . 970475) ("PRO_SET_VALUE" . 970479) ("SCR_XSIZE" . 970483) ("SCR_YSIZE" . 970486) ("SENSITIVE" . 970488) ("UNAME" . 1003671) ("UNITS" . 970503) ("UVALUE" . 970505) ("XOFFSET" . 970510) ("XSIZE" . 970513) ("YOFFSET" . 970515) ("YSIZE" . 970518)))
    ("WIDGET_BASE" fun nil (system) "Result = %s( [Parent])" ("W10.html" ("ALIGN_BOTTOM" . 679920) ("ALIGN_CENTER" . 107036) ("ALIGN_LEFT" . 107030) ("ALIGN_RIGHT" . 107035) ("ALIGN_TOP" . 107037) ("BASE_ALIGN_BOTTOM" . 107046) ("BASE_ALIGN_CENTER" . 107047) ("BASE_ALIGN_LEFT" . 107048) ("BASE_ALIGN_RIGHT" . 107049) ("BASE_ALIGN_TOP" . 107050) ("COLUMN" . 107029) ("CONTEXT_EVENTS" . 917417) ("CONTEXT_MENU" . 970908) ("DISPLAY_NAME" . 970988) ("EVENT_FUNC" . 679923) ("EVENT_PRO" . 679925) ("EXCLUSIVE" . 679927) ("FLOATING" . 911154) ("FRAME" . 679931) ("FUNC_GET_VALUE" . 679933) ("GRID_LAYOUT" . 679935) ("GROUP_LEADER" . 895915) ("KBRD_FOCUS_EVENTS" . 912183) ("KILL_NOTIFY" . 679938) ("MAP" . 108526) ("MBAR" . 934563) ("MODAL" . 910174) ("NO_COPY" . 106818) ("NONEXCLUSIVE" . 679946) ("NOTIFY_REALIZE" . 67508) ("PRO_SET_VALUE" . 679949) ("RESOURCE_NAME" . 281150) ("RNAME_MBAR" . 72437) ("ROW" . 679951) ("SCR_XSIZE" . 948019) ("SCR_YSIZE" . 58070) ("SCROLL" . 679954) ("SENSITIVE" . 948204) ("SPACE" . 679957) ("TAB_MODE" . 1068884) ("TITLE" . 679959) ("TLB_FRAME_ATTR" . 977197) ("TLB_ICONIFY_EVENTS" . 984484) ("TLB_KILL_REQUEST_EVENTS" . 192742) ("TLB_MOVE_EVENTS" . 984511) ("TLB_SIZE_EVENTS" . 679965) ("TOOLBAR" . 978753) ("TRACKING_EVENTS" . 58059) ("UNAME" . 949220) ("UNITS" . 895507) ("UVALUE" . 679967) ("X_SCROLL_SIZE" . 679980) ("XOFFSET" . 679972) ("XPAD" . 679975) ("XSIZE" . 679977) ("Y_SCROLL_SIZE" . 679991) ("YOFFSET" . 679983) ("YPAD" . 679986) ("YSIZE" . 679988)))
    ("WIDGET_BUTTON" fun nil (system) "Result = %s( Parent)" ("W11.html" ("ACCELERATOR" . 1069174) ("ALIGN_CENTER" . 680015) ("ALIGN_LEFT" . 57956) ("ALIGN_RIGHT" . 57957) ("BITMAP" . 192775) ("CHECKED_MENU" . 978512) ("DYNAMIC_RESIZE" . 978508) ("EVENT_FUNC" . 106419) ("EVENT_PRO" . 680017) ("FONT" . 680019) ("FRAME" . 680021) ("FUNC_GET_VALUE" . 108837) ("GROUP_LEADER" . 680025) ("HELP" . 57994) ("KILL_NOTIFY" . 680028) ("MENU" . 680031) ("NO_COPY" . 109087) ("NO_RELEASE" . 680036) ("NOTIFY_REALIZE" . 67569) ("PRO_SET_VALUE" . 680038) ("PUSHBUTTON_EVENTS" . 1019958) ("RESOURCE_NAME" . 724023) ("SCR_XSIZE" . 67277) ("SCR_YSIZE" . 67280) ("SENSITIVE" . 948118) ("SEPARATOR" . 58000) ("TAB_MODE" . 1069036) ("TOOLTIP" . 982062) ("TRACKING_EVENTS" . 982064) ("UNAME" . 949273) ("UNITS" . 895525) ("UVALUE" . 680040) ("VALUE" . 680044) ("X_BITMAP_EXTRA" . 680046) ("XOFFSET" . 680048) ("XSIZE" . 680051) ("YOFFSET" . 680054) ("YSIZE" . 680057)))
    ("WIDGET_COMBOBOX" fun nil (system) "Result = %s( Parent)" ("W12.html" ("DYNAMIC_RESIZE" . 1011945) ("EDITABLE" . 1011949) ("EVENT_FUNC" . 1011951) ("EVENT_PRO" . 1011953) ("FONT" . 1011955) ("FRAME" . 1011964) ("FUNC_GET_VALUE" . 1011967) ("GROUP_LEADER" . 1011969) ("IGNORE_ACCELERATORS" . 1096967) ("KILL_NOTIFY" . 1011972) ("NO_COPY" . 1011975) ("NOTIFY_REALIZE" . 1011978) ("PRO_SET_VALUE" . 1011980) ("RESOURCE_NAME" . 1011983) ("SCR_XSIZE" . 1011991) ("SCR_YSIZE" . 1011993) ("SENSITIVE" . 1011995) ("TAB_MODE" . 1071311) ("TRACKING_EVENTS" . 1012005) ("UNAME" . 1012013) ("UNITS" . 1012019) ("UVALUE" . 1012021) ("VALUE" . 1012025) ("XOFFSET" . 1012027) ("XSIZE" . 1012030) ("YOFFSET" . 1012032) ("YSIZE" . 1012035)))
    ("WIDGET_DRAW" fun nil (system) "Result = %s(Parent)" ("W15.html" ("APP_SCROLL" . 680227) ("BUTTON_EVENTS" . 941808) ("COLOR_MODEL" . 930114) ("COLORS" . 896380) ("EVENT_FUNC" . 680234) ("EVENT_PRO" . 680236) ("EXPOSE_EVENTS" . 907355) ("FRAME" . 680238) ("FUNC_GET_VALUE" . 680240) ("GRAPHICS_LEVEL" . 914743) ("GROUP_LEADER" . 680242) ("IGNORE_ACCELERATORS" . 1097640) ("KEYBOARD_EVENTS" . 1097628) ("KILL_NOTIFY" . 680245) ("MOTION_EVENTS" . 153791) ("NO_COPY" . 680251) ("NOTIFY_REALIZE" . 67601) ("PRO_SET_VALUE" . 680253) ("RENDERER" . 930656) ("RESOURCE_NAME" . 947866) ("RETAIN" . 680255) ("SCR_XSIZE" . 67289) ("SCR_YSIZE" . 67292) ("SCROLL" . 67286) ("SENSITIVE" . 948221) ("TOOLTIP" . 982084) ("TRACKING_EVENTS" . 67368) ("UNAME" . 949316) ("UNITS" . 895543) ("UVALUE" . 680259) ("VALUE" . 680263) ("VIEWPORT_EVENTS" . 279483) ("X_SCROLL_SIZE" . 680274) ("XOFFSET" . 680268) ("XSIZE" . 680271) ("Y_SCROLL_SIZE" . 680283) ("YOFFSET" . 680277) ("YSIZE" . 680280)))
    ("WIDGET_DROPLIST" fun nil (system) "Result = %s( Parent)" ("W16.html" ("DYNAMIC_RESIZE" . 192790) ("EVENT_FUNC" . 192787) ("EVENT_PRO" . 58393) ("FONT" . 963245) ("FRAME" . 58399) ("FUNC_GET_VALUE" . 58404) ("GROUP_LEADER" . 58412) ("KILL_NOTIFY" . 58424) ("NO_COPY" . 67153) ("NOTIFY_REALIZE" . 67614) ("PRO_SET_VALUE" . 67133) ("RESOURCE_NAME" . 67140) ("SCR_XSIZE" . 67120) ("SCR_YSIZE" . 67123) ("SENSITIVE" . 948234) ("TAB_MODE" . 1071560) ("TITLE" . 888903) ("TRACKING_EVENTS" . 58334) ("UNAME" . 949326) ("UNITS" . 895561) ("UVALUE" . 67166) ("VALUE" . 67174) ("XOFFSET" . 67194) ("XSIZE" . 67198) ("YOFFSET" . 67201) ("YSIZE" . 67205)))
    ("WIDGET_EVENT" fun nil (system) "Result = %s([Widget_ID])" ("W17.html" ("BAD_ID" . 680307) ("NOWAIT" . 680311) ("SAVE_HOURGLASS" . 680313) ("YIELD_TO_TTY" . 675439)))
    ("WIDGET_INFO" fun nil (system) "Result = %s( [Widget_ID] )" ("W18.html" ("ACTIVE" . 680342) ("BUTTON_SET" . 978692) ("CHILD" . 978690) ("COLUMN_WIDTHS" . 895941) ("COMBOBOX_GETTEXT" . 981639) ("COMBOBOX_NUMBER" . 981602) ("COMPONENT" . 1018415) ("CONTEXT_EVENTS" . 1018413) ("DRAW_BUTTON_EVENTS" . 971032) ("DRAW_EXPOSE_EVENTS" . 909787) ("DRAW_KEYBOARD_EVENTS" . 985204) ("DRAW_MOTION_EVENTS" . 985200) ("DRAW_VIEWPORT_EVENTS" . 680350) ("DROPLIST_NUMBER" . 58164) ("DROPLIST_SELECT" . 58165) ("DYNAMIC_RESIZE" . 192872) ("EVENT_FUNC" . 680352) ("EVENT_PRO" . 680354) ("FIND_BY_UNAME" . 58144) ("FONTNAME" . 980336) ("GEOMETRY" . 980339) ("KBRD_FOCUS_EVENTS" . 1012790) ("LIST_MULTIPLE" . 934733) ("LIST_NUM_VISIBLE" . 680358) ("LIST_NUMBER" . 911616) ("LIST_SELECT" . 680360) ("LIST_TOP" . 680362) ("MANAGED" . 907337) ("MAP" . 982652) ("MODAL" . 910752) ("MULTIPLE_PROPERTIES" . 1100808) ("NAME" . 1100833) ("PARENT" . 680364) ("PROPERTY_VALID" . 1018429) ("PROPERTY_VALUE" . 1018452) ("PROPERTYSHEET_NSELECTED" . 1070799) ("PROPERTYSHEET_SELECTED" . 1082483) ("PUSHBUTTON_EVENTS" . 1020048) ("REALIZED" . 1018448) ("ROW_HEIGHTS" . 895972) ("SENSITIVE" . 982686) ("SIBLING" . 680368) ("SLIDER_MIN_MAX" . 680889) ("SYSTEM_COLORS" . 895977) ("TAB_CURRENT" . 976997) ("TAB_MODE" . 1069869) ("TAB_MULTILINE" . 977009) ("TAB_NUMBER" . 977045) ("TABLE_ALL_EVENTS" . 971069) ("TABLE_DISJOINT_SELECTION" . 987431) ("TABLE_EDIT_CELL" . 895981) ("TABLE_EDITABLE" . 895979) ("TABLE_SELECT" . 895983) ("TABLE_VIEW" . 895985) ("TEXT_ALL_EVENTS" . 680895) ("TEXT_EDITABLE" . 680899) ("TEXT_NUMBER" . 680370) ("TEXT_OFFSET_TO_XY" . 680903) ("TEXT_SELECT" . 680906) ("TEXT_TOP_LINE" . 680913) ("TEXT_XY_TO_OFFSET" . 899965) ("TLB_ICONIFY_EVENTS" . 984875) ("TLB_KILL_REQUEST_EVENTS" . 192881) ("TLB_MOVE_EVENTS" . 984854) ("TLB_SIZE_EVENTS" . 984889) ("TOOLTIP" . 982130) ("TRACKING_EVENTS" . 58086) ("TREE_EXPANDED" . 978324) ("TREE_ROOT" . 986723) ("TREE_SELECT" . 978331) ("TYPE" . 680072) ("UNAME" . 949465) ("UNITS" . 949467) ("UPDATE" . 680371) ("USE_TABLE_SELECT" . 896009) ("VALID_ID" . 891030) ("VERSION" . 680373) ("VISIBLE" . 984410)))
    ("WIDGET_LABEL" fun nil (system) "Result = %s( Parent)" ("W19.html" ("ALIGN_CENTER" . 57967) ("ALIGN_LEFT" . 57970) ("ALIGN_RIGHT" . 57973) ("DYNAMIC_RESIZE" . 192801) ("FONT" . 680390) ("FRAME" . 680392) ("FUNC_GET_VALUE" . 680394) ("GROUP_LEADER" . 680396) ("KILL_NOTIFY" . 680399) ("NO_COPY" . 680402) ("NOTIFY_REALIZE" . 67628) ("PRO_SET_VALUE" . 680404) ("RESOURCE_NAME" . 724047) ("SCR_XSIZE" . 67301) ("SCR_YSIZE" . 67304) ("SENSITIVE" . 948248) ("SUNKEN_FRAME" . 978731) ("TRACKING_EVENTS" . 67390) ("UNAME" . 949494) ("UNITS" . 949487) ("UVALUE" . 680406) ("VALUE" . 680410) ("XOFFSET" . 680412) ("XSIZE" . 680415) ("YOFFSET" . 680418) ("YSIZE" . 680421)))
    ("WIDGET_LIST" fun nil (system) "Result = %s( Parent)" ("W20.html" ("CONTEXT_EVENTS" . 970955) ("EVENT_FUNC" . 680433) ("EVENT_PRO" . 680435) ("FONT" . 680437) ("FRAME" . 680439) ("FUNC_GET_VALUE" . 680441) ("GROUP_LEADER" . 680443) ("KILL_NOTIFY" . 680446) ("MULTIPLE" . 934705) ("NO_COPY" . 680449) ("NOTIFY_REALIZE" . 67642) ("PRO_SET_VALUE" . 680451) ("RESOURCE_NAME" . 724057) ("SCR_XSIZE" . 67319) ("SCR_YSIZE" . 1001133) ("SENSITIVE" . 948262) ("TAB_MODE" . 1071684) ("TRACKING_EVENTS" . 1071674) ("UNAME" . 949504) ("UNITS" . 895619) ("UVALUE" . 680453) ("VALUE" . 680457) ("XOFFSET" . 680460) ("XSIZE" . 680463) ("YOFFSET" . 680466) ("YSIZE" . 58021)))
    ("WIDGET_PROPERTYSHEET" fun nil (system) "Result = %s(Parent)" ("W21.html" ("ALIGN_BOTTOM" . 1036791) ("ALIGN_CENTER" . 1036794) ("ALIGN_LEFT" . 1036796) ("ALIGN_RIGHT" . 1036798) ("ALIGN_TOP" . 1036800) ("CONTEXT_EVENTS" . 1036802) ("EDITABLE" . 1078422) ("EVENT_FUNC" . 1036806) ("EVENT_PRO" . 1036808) ("FONT" . 1036810) ("FRAME" . 1070614) ("FUNC_GET_VALUE" . 1036813) ("IGNORE_ACCELERATORS" . 1097821) ("KILL_NOTIFY" . 1036815) ("MULTIPLE_PROPERTIES" . 1100848) ("NO_COPY" . 1036819) ("NOTIFY_REALIZE" . 1036822) ("PRO_SET_VALUE" . 1036824) ("SCR_XSIZE" . 1036826) ("SCR_YSIZE" . 1036828) ("SENSITIVE" . 1036830) ("SUNKEN_FRAME" . 1070660) ("TRACKING_EVENTS" . 1036836) ("UNAME" . 1036838) ("UNITS" . 1036841) ("UVALUE" . 1036843) ("VALUE" . 1036847) ("XOFFSET" . 1036853) ("XSIZE" . 1036856) ("YOFFSET" . 1036858) ("YSIZE" . 1036861)))
    ("WIDGET_SLIDER" fun nil (system) "Result = %s( Parent)" ("W22.html" ("DRAG" . 680487) ("EVENT_FUNC" . 680490) ("EVENT_PRO" . 680492) ("FONT" . 680494) ("FRAME" . 680496) ("FUNC_GET_VALUE" . 680498) ("GROUP_LEADER" . 680500) ("KILL_NOTIFY" . 680503) ("MAXIMUM" . 680506) ("MINIMUM" . 680508) ("NO_COPY" . 680510) ("NOTIFY_REALIZE" . 67656) ("PRO_SET_VALUE" . 680512) ("RESOURCE_NAME" . 724067) ("SCR_XSIZE" . 67331) ("SCR_YSIZE" . 67334) ("SCROLL" . 680514) ("SENSITIVE" . 948276) ("SUPPRESS_VALUE" . 680516) ("TAB_MODE" . 1071832) ("TITLE" . 1071823) ("TRACKING_EVENTS" . 67418) ("UNAME" . 949514) ("UNITS" . 895638) ("UVALUE" . 680519) ("VALUE" . 680523) ("VERTICAL" . 680527) ("XOFFSET" . 680529) ("XSIZE" . 680532) ("YOFFSET" . 680535) ("YSIZE" . 680538)))
    ("WIDGET_TAB" fun nil (system) "Result = %s( Parent)" ("W23.html" ("ALIGN_BOTTOM" . 1012200) ("ALIGN_CENTER" . 1012202) ("ALIGN_LEFT" . 1012204) ("ALIGN_RIGHT" . 1012206) ("ALIGN_TOP" . 1012208) ("EVENT_FUNC" . 1012210) ("EVENT_PRO" . 1012212) ("FUNC_GET_VALUE" . 1012214) ("GROUP_LEADER" . 1012216) ("KILL_NOTIFY" . 1012219) ("LOCATION" . 1012223) ("MULTILINE" . 1012253) ("NO_COPY" . 1012263) ("NOTIFY_REALIZE" . 1012266) ("PRO_SET_VALUE" . 1012268) ("SCR_XSIZE" . 1012270) ("SCR_YSIZE" . 1012272) ("SENSITIVE" . 1012274) ("TAB_MODE" . 1071955) ("TRACKING_EVENTS" . 1018541) ("UNAME" . 1012284) ("UNITS" . 1012290) ("UVALUE" . 1012292) ("XOFFSET" . 1012296) ("XSIZE" . 1012299) ("YOFFSET" . 1012301) ("YSIZE" . 1012304)))
    ("WIDGET_TABLE" fun nil (system) "Result = %s( Parent)" ("W24.html" ("ALIGNMENT" . 896042) ("ALL_EVENTS" . 941688) ("AM_PM" . 1076926) ("COLUMN_LABELS" . 1076933) ("COLUMN_MAJOR" . 909845) ("COLUMN_WIDTHS" . 896114) ("CONTEXT_EVENTS" . 1074773) ("DAYS_OF_WEEK" . 949838) ("DISJOINT_SELECTION" . 987345) ("EDITABLE" . 987346) ("EVENT_FUNC" . 896120) ("EVENT_PRO" . 896123) ("FONT" . 896126) ("FORMAT" . 896130) ("FRAME" . 896133) ("FUNC_GET_VALUE" . 896136) ("GROUP_LEADER" . 896151) ("IGNORE_ACCELERATORS" . 1097865) ("KBRD_FOCUS_EVENTS" . 911525) ("KILL_NOTIFY" . 896155) ("MONTHS" . 949844) ("NO_COLUMN_HEADERS" . 1074713) ("NO_COPY" . 896163) ("NO_HEADERS" . 909873) ("NO_ROW_HEADERS" . 1074723) ("NOTIFY_REALIZE" . 896166) ("PRO_SET_VALUE" . 896169) ("RESIZEABLE_COLUMNS" . 896172) ("RESIZEABLE_ROWS" . 901244) ("RESOURCE_NAME" . 896175) ("ROW_HEIGHTS" . 909879) ("ROW_LABELS" . 896181) ("ROW_MAJOR" . 909886) ("SCR_XSIZE" . 896187) ("SCR_YSIZE" . 896190) ("SCROLL" . 896193) ("SENSITIVE" . 948291) ("TAB_MODE" . 1072083) ("TRACKING_EVENTS" . 896200) ("UNAME" . 949524) ("UNITS" . 896203) ("UVALUE" . 896207) ("VALUE" . 896212) ("X_SCROLL_SIZE" . 896223) ("XOFFSET" . 896215) ("XSIZE" . 896219) ("Y_SCROLL_SIZE" . 896235) ("YOFFSET" . 896227) ("YSIZE" . 896231)))
    ("WIDGET_TEXT" fun nil (system) "Result = %s( Parent)" ("W25.html" ("ALL_EVENTS" . 680556) ("CONTEXT_EVENTS" . 970972) ("EDITABLE" . 886884) ("EVENT_FUNC" . 680561) ("EVENT_PRO" . 680563) ("FONT" . 680565) ("FRAME" . 680567) ("FUNC_GET_VALUE" . 680569) ("GROUP_LEADER" . 680571) ("IGNORE_ACCELERATORS" . 1097921) ("KBRD_FOCUS_EVENTS" . 911545) ("KILL_NOTIFY" . 680574) ("NO_COPY" . 680577) ("NO_NEWLINE" . 680579) ("NOTIFY_REALIZE" . 67670) ("PRO_SET_VALUE" . 680581) ("RESOURCE_NAME" . 724077) ("SCR_XSIZE" . 67343) ("SCR_YSIZE" . 67346) ("SCROLL" . 680583) ("SENSITIVE" . 948305) ("TAB_MODE" . 1072230) ("TRACKING_EVENTS" . 67432) ("UNAME" . 949534) ("UNITS" . 895656) ("UVALUE" . 680586) ("VALUE" . 680590) ("WRAP" . 58056) ("XOFFSET" . 680592) ("XSIZE" . 680595) ("YOFFSET" . 680598) ("YSIZE" . 680601)))
    ("WIDGET_TREE" fun nil (system) "Result = %s( Parent)" ("W26.html" ("ALIGN_BOTTOM" . 1012440) ("ALIGN_CENTER" . 1012442) ("ALIGN_LEFT" . 1012444) ("ALIGN_RIGHT" . 1012446) ("ALIGN_TOP" . 1012448) ("BITMAP" . 1012450) ("CONTEXT_EVENTS" . 1012452) ("EVENT_FUNC" . 1012461) ("EVENT_PRO" . 1012463) ("EXPANDED" . 1012465) ("FOLDER" . 1012468) ("FUNC_GET_VALUE" . 1012472) ("GROUP_LEADER" . 1012474) ("KILL_NOTIFY" . 1012477) ("MULTIPLE" . 1012481) ("NO_COPY" . 1012484) ("NOTIFY_REALIZE" . 1012487) ("PRO_SET_VALUE" . 1012489) ("SCR_XSIZE" . 1012491) ("SCR_YSIZE" . 1012493) ("SENSITIVE" . 1012495) ("TAB_MODE" . 1072351) ("TOP" . 1012505) ("TRACKING_EVENTS" . 1018556) ("UNAME" . 1012508) ("UNITS" . 1012514) ("UVALUE" . 1012516) ("VALUE" . 1012520) ("XOFFSET" . 1012523) ("XSIZE" . 1012526) ("YOFFSET" . 1012528) ("YSIZE" . 1012531)))
    ("WRITE_SYLK" fun nil (system) "Result = %s( File, Data)" ("W39.html" ("STARTCOL" . 67955) ("STARTROW" . 67958)))
    ("WTN" fun nil (system) "Result = %s( A, Coef)" ("W46.html" ("COLUMN" . 58787) ("DOUBLE" . 52415) ("INVERSE" . 52418) ("OVERWRITE" . 52421)))
    ("WV_CW_WAVELET" fun nil (system) "Result = %s( [Parent])" ("ref5.html" ("DISCRETE" . 1003928) ("NO_COLOR" . 1015397) ("NO_DRAW_WINDOW" . 1015435) ("TITLE" . 1015385) ("UNAME" . 1004532) ("UVALUE" . 1003932) ("VALUE" . 1015413) ("WAVELETS" . 1008397)))
    ("WV_CWT" fun nil (system) "Result = %s(Array, Family, Order)" ("ref6.html" ("DOUBLE" . 1009356) ("DSCALE" . 1009358) ("NSCALE" . 1009484) ("PAD" . 1009489) ("SCALE" . 1009494) ("START_SCALE" . 1009568)))
    ("WV_DENOISE" fun nil (system) "Result = %s(Array [, Family, Order])" ("ref7.html" ("COEFFICIENTS" . 1010533) ("CUTOFF" . 1010481) ("DENOISE_STATE" . 1010485) ("DOUBLE" . 1010505) ("DWT_FILTERED" . 1010508) ("PERCENT" . 1010511) ("THRESHOLD" . 1010517) ("WPS_FILTERED" . 1010522)))
    ("WV_DWT" fun nil (system) "Result = %s(Array, Scaling, Wavelet, Ioff, Joff)" ("ref8.html" ("DOUBLE" . 1003349) ("INVERSE" . 1003353) ("N_LEVELS" . 1043639)))
    ("WV_FN_COIFLET" fun nil (system) "Result = %s( [Order, Scaling, Wavelet, Ioff, Joff] )" ("ref9.html"))
    ("WV_FN_DAUBECHIES" fun nil (system) "Result = %s( [Order, Scaling, Wavelet, Ioff, Joff] )" ("ref10.html"))
    ("WV_FN_GAUSSIAN" fun nil (system) "Result = %s( [Order] [, Scale, N])" ("ref11.html" ("DOUBLE" . 1018338) ("FREQUENCY" . 1018340) ("SPATIAL" . 1018342) ("WAVELET" . 1018344)))
    ("WV_FN_HAAR" fun nil (system) "Result = %s( [Order, Scaling, Wavelet, Ioff, Joff] )" ("ref12.html"))
    ("WV_FN_MORLET" fun nil (system) "Result = %s( [Order] [, Scale, N])" ("ref13.html" ("DOUBLE" . 1009779) ("FREQUENCY" . 1015564) ("SPATIAL" . 1015558) ("WAVELET" . 1009789)))
    ("WV_FN_PAUL" fun nil (system) "Result = %s( [Order] [, Scale, N])" ("ref14.html" ("DOUBLE" . 1010078) ("FREQUENCY" . 1015576) ("SPATIAL" . 1010080) ("WAVELET" . 1010082)))
    ("WV_FN_SYMLET" fun nil (system) "Result = %s( [Order, Scaling, Wavelet, Ioff, Joff] )" ("ref15.html"))
    ("WV_PLOT3D_WPS" fun nil (system) "Result = %s( Array [, X] [, Y])" ("ref18.html" ("GROUP_LEADER" . 1006236) ("SURFACE_STYLE" . 1015696) ("TITLE" . 1006239) ("UNITS" . 1006241) ("XTITLE" . 1006243) ("XUNITS" . 1006245) ("YTITLE" . 1006247) ("YUNITS" . 1006249)))
    ("WV_PLOT_MULTIRES" fun nil (system) "Result = %s( Array [, X] [, Y])" ("ref19.html" ("GROUP_LEADER" . 1008291) ("TITLE" . 1008295) ("UNITS" . 1008298) ("XTITLE" . 1008301) ("XUNITS" . 1008304) ("YTITLE" . 1008307) ("YUNITS" . 1008310)))
    ("WV_PWT" fun nil (system) "Result = %s( A, Scaling, Wavelet, Ioff, Joff)" ("ref20.html" ("DOUBLE" . 1006192) ("INVERSE" . 1006194)))
    ("WV_TOOL_DENOISE" fun nil (system) "Result = %s( Array [, X] [, Y])" ("ref21.html" ("GROUP_LEADER" . 1008330) ("TITLE" . 1008334) ("UNITS" . 1008337) ("XTITLE" . 1008340) ("XUNITS" . 1008343) ("YTITLE" . 1008346) ("YUNITS" . 1008349)))
    ("XFONT" fun nil (system) "Result = %s()" ("X4.html" ("GROUP" . 762100) ("PRESERVE_FONT_INFO" . 762103)))
    ("XREGISTERED" fun nil (system) "Result = %s(Name)" ("X16.html" ("NOSHOW" . 762898)))
    ("XSQ_TEST" fun nil (system) "Result = %s( Obfreq, Exfreq)" ("X18.html" ("EXCELL" . 137437) ("OBCELL" . 137440) ("RESIDUAL" . 137443)))
    ("Add" pro "IDL_Container" (system) "Obj->[%s::]%s, Objects" ("objects_misc5.html" ("POSITION" . 1010605)))
    ("Cleanup" pro "IDL_Container" (system) "Obj->[%s::]%s" ("objects_misc6.html"))
    ("Move" pro "IDL_Container" (system) "Obj->[%s::]%s, Source, Destination" ("objects_misc11.html"))
    ("Remove" pro "IDL_Container" (system) "Obj->[%s::]%s [, Child_object]" ("objects_misc12.html" ("ALL" . 1010855) ("POSITION" . 1010857)))
    ("Count" fun "IDL_Container" (system) "Result = Obj->[%s::]%s()" ("objects_misc7.html"))
    ("Get" fun "IDL_Container" (system) "Result = Obj->[%s::]%s ()" ("objects_misc8.html" ("ALL" . 1010708) ("COUNT" . 1010710) ("ISA" . 1010712) ("POSITION" . 1010715)))
    ("Init" fun "IDL_Container" (system) "Result = Obj->[%s::]%s()" ("objects_misc9.html" ))
    ("IsContained" fun "IDL_Container" (system) "Result = Obj->[%s::]%s( Object)" ("objects_misc10.html" ("POSITION" . 1010785)))
    ("IDL" pro "IDL_Savefile" (system) "Obj->[IDL_Savefile::]IDL_Savefile::Cleanup" ("objects_misc15.html"))
    ("Restore" pro "IDL_Savefile" (system) "Obj->[%s::]%s, SaveItem" ("objects_misc19.html" ("COMMON" . 1034877) ("FUNCTION" . 1034881) ("NEW_HEAPVAR" . 1034884) ("OBJECT_HEAPVAR" . 1034892) ("POINTER_HEAPVAR" . 1034898) ("PROCEDURE" . 1034904) ("RESTORED_OBJECTS" . 1034907) ("STRUCTURE_DEFINITION" . 1034910) ("VERBOSE" . 1034913)))
    ("Contents" fun "IDL_Savefile" (system) "Result = Obj->[%s::]%s()" ("objects_misc16.html"))
    ("IDL" fun "IDL_Savefile" (system) "Result = Obj->[IDL_Savefile::]IDL_Savefile::Init([, Filename])" ("objects_misc17.html" ("FILENAME" . 1034717) ("RELAXED_STRUCTURE_ASSIGNMENT" . 1034721)))
    ("Names" fun "IDL_Savefile" (system) "Result = Obj->[%s::]%s()" ("objects_misc18.html" ("COMMON_BLOCK" . 1034777) ("COMMON_VARIABLE" . 1034780) ("COUNT" . 1034783) ("FUNCTION" . 1034786) ("OBJECT_HEAPVAR" . 1034789) ("POINTER_HEAPVAR" . 1034800) ("PROCEDURE" . 1034811) ("STRUCTURE_DEFINITION" . 1034814) ("SYSTEM_VARIABLE" . 1034817)))
    ("Size" fun "IDL_Savefile" (system) "Result = Obj->[%s::]%s(SaveItem [, Keywords])" ("objects_misc20.html"))
    ("AppendData" pro "IDLanROI" (system) "Obj->[%s::]%s, X [, Y] [, Z]" ("objects_an5.html" ("XRANGE" . 1003740) ("YRANGE" . 1003742) ("ZRANGE" . 1003744)))
    ("Cleanup" pro "IDLanROI" (system) "Obj->[%s::]%s" ("objects_an6.html"))
    ("GetProperty" pro "IDLanROI" (system) "Obj->[%s::]%s" ("objects_an10.html" ) ("objects_an4.html" ("ALL" . 1011351) ("BLOCK_SIZE" . 1011320) ("DATA" . 1011322) ("DOUBLE" . 1011324) ("INTERIOR" . 1011326) ("N_VERTS" . 1011660) ("ROI_XRANGE" . 1011699) ("ROI_YRANGE" . 1011726) ("ROI_ZRANGE" . 1011728) ("TYPE" . 1011328)))
    ("RemoveData" pro "IDLanROI" (system) "Obj->[%s::]%s" ("objects_an12.html" ("COUNT" . 1004077) ("START" . 1004079) ("XRANGE" . 1004081) ("YRANGE" . 1004083) ("ZRANGE" . 1004085)))
    ("ReplaceData" pro "IDLanROI" (system) "Obj->[%s::]%s, X[, Y[, Z]]" ("objects_an13.html" ("FINISH" . 1004123) ("START" . 1004130) ("XRANGE" . 1004136) ("YRANGE" . 1004138) ("ZRANGE" . 1004140)))
    ("Rotate" pro "IDLanROI" (system) "Obj->[%s::]%s, Axis, Angle" ("objects_an14.html" ("CENTER" . 1004176)))
    ("Scale" pro "IDLanROI" (system) "Obj->[%s::]%s, Sx[, Sy[, Sz]]" ("objects_an15.html"))
    ("SetProperty" pro "IDLanROI" (system) "Obj->[%s::]%s" ("objects_an16.html" ) ("objects_an4.html" ("BLOCK_SIZE" . 1011320) ("DATA" . 1011322) ("DOUBLE" . 1011324) ("INTERIOR" . 1011326)))
    ("Translate" pro "IDLanROI" (system) "Obj->[%s::]%s, Tx[, Ty[, Tz]]" ("objects_an17.html"))
    ("ComputeGeometry" fun "IDLanROI" (system) "Result = Obj->[%s::]%s()" ("objects_an7.html" ("AREA" . 1003819) ("CENTROID" . 1003821) ("PERIMETER" . 1003823) ("SPATIAL_OFFSET" . 1003825) ("SPATIAL_SCALE" . 1003827)))
    ("ComputeMask" fun "IDLanROI" (system) "Result = Obj->[%s::]%s()" ("objects_an8.html" ("DIMENSIONS" . 1003872) ("INITIALIZE" . 1003874) ("LOCATION" . 1003879) ("MASK_IN" . 1003881) ("MASK_RULE" . 1003883) ("PIXEL_CENTER" . 1003888) ("PLANE_NORMAL" . 1011165) ("PLANE_XAXIS" . 1003890) ("RUN_LENGTH" . 1003892)))
    ("ContainsPoints" fun "IDLanROI" (system) "Result = Obj->[%s::]%s( X [, Y [, Z]] )" ("objects_an9.html"))
    ("Init" fun "IDLanROI" (system) "Result = Obj->[%s::]%s([, X [, Y [, Z]]])" ("objects_an11.html" ) ("objects_an4.html" ("BLOCK_SIZE" . 1011320) ("DATA" . 1011322) ("DOUBLE" . 1011324) ("INTERIOR" . 1011326) ("TYPE" . 1011328)))
    ("Add" pro "IDLanROIGroup" (system) "Obj->[%s::]%s, ROI" ("objects_an20.html"))
    ("Cleanup" pro "IDLanROIGroup" (system) "Obj->[%s::]%s" ("objects_an21.html"))
    ("GetProperty" pro "IDLanROIGroup" (system) "Obj->[%s::]%s" ("objects_an25.html" ) ("objects_an19.html" ("ALL" . 1011995) ("ROIGROUP_XRANGE" . 1011998) ("ROIGROUP_YRANGE" . 1012000) ("ROIGROUP_ZRANGE" . 1012002)))
    ("Rotate" pro "IDLanROIGroup" (system) "Obj->[%s::]%s, Axis, Angle" ("objects_an27.html" ("CENTER" . 1004731)))
    ("Scale" pro "IDLanROIGroup" (system) "Obj->[%s::]%s, Sx[, Sy[, Sz]]" ("objects_an28.html"))
    ("Translate" pro "IDLanROIGroup" (system) "Obj->[%s::]%s, Tx[, Ty[, Tz]]" ("objects_an29.html"))
    ("ComputeMask" fun "IDLanROIGroup" (system) "Result = Obj->[%s::]%s()" ("objects_an22.html" ("DIMENSIONS" . 1004482) ("INITIALIZE" . 1004484) ("LOCATION" . 1004489) ("MASK_IN" . 1004491) ("MASK_RULE" . 1004493) ("PLANE_NORMAL" . 1004498) ("PLANE_XAXIS" . 1004500) ("RUN_LENGTH" . 1004502)))
    ("ComputeMesh" fun "IDLanROIGroup" (system) "Result = Obj->[%s::]%s( Vertices, Conn)" ("objects_an23.html" ("CAPPED" . 1004551) ("SURFACE_AREA" . 1004556)))
    ("ContainsPoints" fun "IDLanROIGroup" (system) "Result = Obj->[%s::]%s( X[, Y[, Z]] )" ("objects_an24.html"))
    ("Init" fun "IDLanROIGroup" (system) "Result = Obj->[%s::]%s()" ("objects_an26.html" ))
    ("GetProperty" pro "IDLcomIDispatch" (system) "Obj->[%s::]%s" ("objects_misc25.html" ("KEYWORD")))
    ("SetProperty" pro "IDLcomIDispatch" (system) "Obj->[%s::]%s" ("objects_misc27.html" ("KEYWORD")))
    ("Init" fun "IDLcomIDispatchCLSID" (system) "Result = Obj -> [%s::]%s()" ("objects_misc26.html"))
    ("Init" fun "IDLcomIDispatchPROGID" (system) "Result = Obj -> [%s::]%s()" ("objects_misc26.html"))
    ("Connect" pro "IDLdbDatabase" (system) "DBobj -> [%s::]%s" ("api8.html" ("CONNECTION" . 998610) ("DATASOURCE" . 998682) ("PASSWORD" . 998786) ("USER_ID" . 998733)))
    ("ExecuteSQL" pro "IDLdbDatabase" (system) "DBobj -> [%s::]%s, strSQL" ("api9.html"))
    ("GetProperty" pro "IDLdbDatabase" (system) "DBobj -> [%s::]%s" ("api11.html" ) ("api7.html" ("CAN_GET_TABLES" . 1029718) ("DBMS_NAME" . 1029721) ("DBMS_VERSION" . 1029727) ("DRIVER_ODBC_LEVEL" . 1029724) ("DRIVER_VERSION" . 1029730) ("IS_CONNECTED" . 1029733) ("IS_READONLY" . 1029736) ("MAX_CONNECTIONS" . 1029739) ("MAX_RECORDSETS" . 1029742) ("ODBC_LEVEL" . 1029745) ("SQL_LEVEL" . 1029748) ("SQL_SERVER_NAME" . 1029751) ("USE_CURSOR_LIB" . 1029754) ("USER_NAME" . 1029760)))
    ("SetProperty" pro "IDLdbDatabase" (system) "DBobj -> [%s::]%s" ("api13.html" ) ("api7.html" ("USE_CURSOR_LIB" . 1029754) ("VERBOSE" . 1029819)))
    ("GetDatasources" fun "IDLdbDatabase" (system) "Datasources = DBobj -> [%s::]%s()" ("api10.html"))
    ("GetTables" fun "IDLdbDatabase" (system) "Tables = DBobj -> [%s::]%s()" ("api12.html"))
    ("AddRecord" pro "IDLdbRecordset" (system) "RSobj -> [%s::]%s[, field1[, field2[, ...[, fieldn]]]]" ("api16.html" ("SET_AUTOINCREMENT" . 1014791)))
    ("DeleteRecord" pro "IDLdbRecordset" (system) "RSobj -> [%s::]%s" ("api18.html"))
    ("GetProperty" pro "IDLdbRecordset" (system) "RSobj -> [%s::]%s" ("api20.html" ) ("api15.html" ("CAN_MOVE_ABSOLUTE" . 1030659) ("CAN_MOVE_FIRST" . 1030662) ("CAN_MOVE_LAST" . 1030665) ("CAN_MOVE_NEXT" . 1030668) ("CAN_MOVE_PRIOR" . 1030671) ("CAN_MOVE_RELATIVE" . 1030674) ("FIELD_INFO" . 1030677) ("GET_DATABASE" . 1030697) ("IS_READONLY" . 1030700) ("N_BUFFERS" . 1030703) ("RECORDSET_SOURCE" . 1030706)))
    ("SetField" pro "IDLdbRecordset" (system) "RSobj -> [%s::]%s, iFieldNumber, Value" ("api24.html" ("NULL" . 1014812)))
    ("CurrentRecord" fun "IDLdbRecordset" (system) "number = RSobj -> [%s::]%s()" ("api17.html"))
    ("GetField" fun "IDLdbRecordset" (system) "value = RSobj -> [%s::]%s(iFieldNumber)" ("api19.html" ("IS_NULL" . 1013507) ("NULL_VALUE" . 1013559)))
    ("GetRecord" fun "IDLdbRecordset" (system) "Result = RSobj -> [%s::]%s()" ("api21.html"))
    ("MoveCursor" fun "IDLdbRecordset" (system) "Result = RSobj -> [%s::]%s()" ("api22.html" ("ABSOLUTE" . 1001009) ("FIRST" . 1001067) ("LAST" . 1001125) ("NEXT" . 1001187) ("PRIOR" . 1001255) ("RELATIVE" . 1001313)))
    ("NFields" fun "IDLdbRecordset" (system) "status = RSobj -> [%s::]%s()" ("api23.html"))
    ("Cleanup" pro "IDLffDICOM" (system) "Obj->[%s::]%s" ("objects_ff6.html"))
    ("DumpElements" pro "IDLffDICOM" (system) "Obj->[%s::]%s [, Filename]" ("objects_ff7.html"))
    ("Reset" pro "IDLffDICOM" (system) "Obj->[%s::]%s" ("objects_ff20.html"))
    ("GetChildren" fun "IDLffDICOM" (system) "Result = Obj->[%s::]%s(Reference)" ("objects_ff8.html"))
    ("GetDescription" fun "IDLffDICOM" (system) "Result = Obj->[%s::]%s([Group [, Element]])" ("objects_ff9.html" ("REFERENCE" . 1004342)))
    ("GetGroup" fun "IDLffDICOM" (system) "Result = Obj->[%s::]%s([Group[, Element]])" ("objects_ff11.html" ("REFERENCE" . 1004455)))
    ("GetLength" fun "IDLffDICOM" (system) "Result = Obj->[%s::]%s([Group [, Element]])" ("objects_ff12.html" ("REFERENCE" . 1004513)))
    ("GetParent" fun "IDLffDICOM" (system) "Result = Obj->[%s::]%s(ReferenceList)" ("objects_ff13.html"))
    ("GetPreamble" fun "IDLffDICOM" (system) "Result = Obj->[%s::]%s()" ("objects_ff14.html"))
    ("GetReference" fun "IDLffDICOM" (system) "Result = Obj->[%s::]%s([Group [, Element]])" ("objects_ff15.html" ("DESCRIPTION" . 1004671) ("VR" . 1004673)))
    ("GetValue" fun "IDLffDICOM" (system) "Result = Obj->[%s::]%s([Group [, Element]])" ("objects_ff16.html" ("NO_COPY" . 1004738) ("REFERENCE" . 1004736)))
    ("GetVR" fun "IDLffDICOM" (system) "array = Obj->[%s::]%s([Group [, Element]])" ("objects_ff17.html" ("REFERENCE" . 1004843)))
    ("Init" fun "IDLffDICOM" (system) "Result = Obj->[%s::]%s([, Filename])" ("objects_ff18.html" ) ("objects_ff5.html" ("VERBOSE" . 1024027)))
    ("Read" fun "IDLffDICOM" (system) "Result = Obj->[%s::]%s(Filename)" ("objects_ff19.html" ("ENDIAN" . 1004946)))
    ("Cleanup" pro "IDLffDXF" (system) "Obj->[%s::]%s" ("objects_ff23.html"))
    ("GetPalette" pro "IDLffDXF" (system) "Obj->[%s::]%s, Red, Green, Blue" ("objects_ff26.html"))
    ("PutEntity" pro "IDLffDXF" (system) "Obj->[%s::]%s, Data" ("objects_ff28.html"))
    ("RemoveEntity" pro "IDLffDXF" (system) "Obj->[%s::]%s[, Type]" ("objects_ff30.html" ("INDEX" . 1006265)))
    ("Reset" pro "IDLffDXF" (system) "Obj->[%s::]%s" ("objects_ff31.html"))
    ("SetPalette" pro "IDLffDXF" (system) "Obj->[%s::]%s, Red, Green, Blue" ("objects_ff32.html"))
    ("GetContents" fun "IDLffDXF" (system) "Result = Obj->[%s::]%s( [Filter])" ("objects_ff24.html" ("BLOCK" . 1005307) ("COUNT" . 1005309) ("LAYER" . 1005311)))
    ("GetEntity" fun "IDLffDXF" (system) "Result = Obj->[%s::]%s(Type)" ("objects_ff25.html" ("BLOCK" . 1005352) ("INDEX" . 1005354) ("LAYER" . 1005356)))
    ("Init" fun "IDLffDXF" (system) "Result = Obj->[%s::]%s([, Filename] )" ("objects_ff27.html" ))
    ("Read" fun "IDLffDXF" (system) "Result = Obj->[%s::]%s(Filename)" ("objects_ff29.html"))
    ("Write" fun "IDLffDXF" (system) "Result = Obj->[%s::]%s(Filename)" ("objects_ff33.html"))
    ("SetData" pro "IDLffJPEG2000" (system) "Obj->[%s::]%s ([P1, ..., Pn])" ("objects_ff42.html" ("COMPONENT" . 1141582) ("ORDER" . 1141585) ("TILE_INDEX" . 1141588)))
    ("GetData" fun "IDLffJPEG2000" (system) "Result = Obj->[%s::]%s()" ("objects_ff38.html" ("COMPONENT" . 1141336) ("DISCARD_LEVELS" . 1141339) ("MAX_LAYERS" . 1141342) ("N_COMPONENTS" . 1141345) ("ORDER" . 1141348) ("REGION" . 1141351) ("RGB" . 1141355) ("TILE_INDEX" . 1141363)))
    ("Init" fun "IDLffJPEG2000" (system) "Result = Obj->[%s::]%s(, Filename)" ("objects_ff41.html" ) ("objects_ff36.html" ("BIT_DEPTH" . 1140492) ("COMMENT" . 1140557) ("DIMENSIONS" . 1140585) ("DISPLAY_RESOLUTION" . 1140613) ("FILENAME" . 1140643) ("N_COMPONENTS" . 1181381) ("N_LAYERS" . 1140729) ("N_LEVELS" . 1140758) ("OFFSET" . 1140815) ("PALETTE" . 1140843) ("PERSISTENT" . 1140875) ("PROGRESSION" . 1140903) ("QUIET" . 1140953) ("READ" . 1140981) ("REVERSIBLE" . 1141009) ("SIGNED" . 1141037) ("TILE_DIMENSIONS" . 1141095) ("TILE_OFFSET" . 1141123) ("WRITE" . 1141181) ("XML" . 1141209) ("YCC" . 1141237)))
    ("Cleanup" pro "IDLffLangCat" (system) "Obj->[%s::]%s" ("objects_ff47.html"))
    ("GetProperty" pro "IDLffLangCat" (system) "Obj->[%s::]%s" ("objects_ff48.html" ) ("objects_ff45.html" ("APP_NAME" . 1126713) ("APP_PATH" . 1126741) ("AVAILABLE_LANGUAGES" . 1126769) ("DEFAULT_KEYS" . 1126797) ("DEFAULT_LANGUAGE" . 1126825) ("DEFAULT_N_KEYS" . 1126853) ("FILENAME" . 1126881) ("KEYS" . 1126909) ("LANGUAGE" . 1126937) ("N_KEYS" . 1126965) ("VERBOSE" . 1126993)))
    ("SetProperty" pro "IDLffLangCat" (system) "Obj->[%s::]%s" ("objects_ff51.html" ) ("objects_ff45.html" ("LANGUAGE" . 1126937) ("VERBOSE" . 1126993)))
    ("AppendCatalog" fun "IDLffLangCat" (system) "Result = Obj->[%s::]%s()" ("objects_ff46.html" ("APP_NAME" . 1127041) ("APP_PATH" . 1127050) ("FILENAME" . 1127056)))
    ("Init" fun "IDLffLangCat" (system) "Result = Obj->[%s::]%s" ("objects_ff49.html" ("CONTINUE_ON_ERROR" . 1127135)) ("objects_ff45.html" ("APP_NAME" . 1126713) ("APP_PATH" . 1126741) ("DEFAULT_LANGUAGE" . 1126825) ("FILENAME" . 1126881) ("LANGUAGE" . 1126937) ("VERBOSE" . 1126993)))
    ("Query" fun "IDLffLangCat" (system) "Result = Obj->[%s::]%s( Key)" ("objects_ff50.html" ("DEFAULT_STRING" . 1127154)))
    ("Cleanup" pro "IDLffMrSID" (system) "Obj->[%s::]%s" ("objects_ff54.html"))
    ("GetProperty" pro "IDLffMrSID" (system) "Obj->[%s::]%s" ("objects_ff57.html" ("CHANNELS" . 1006873) ("DIMENSIONS" . 1006875) ("GEO_ORIGIN" . 1064441) ("GEO_PROJTYPE" . 1064460) ("GEO_RESOLUTION" . 1064466) ("GEO_VALID" . 1064449) ("LEVELS" . 1006877) ("PIXEL_TYPE" . 1006879) ("TYPE" . 1006884)))
    ("GetDimsAtLevel" fun "IDLffMrSID" (system) "Result = Obj->[%s::]%s (Level)" ("objects_ff55.html"))
    ("GetImageData" fun "IDLffMrSID" (system) "Result = Obj->[%s::]%s ()" ("objects_ff56.html" ("LEVEL" . 1006785) ("SUB_RECT" . 1006788)))
    ("Init" fun "IDLffMrSID" (system) "Result = Obj->[%s::]%s(, Filename)" ("objects_ff58.html" ) ("objects_ff53.html" ("QUIET" . 1026758)))
    ("AddAttribute" pro "IDLffShape" (system) "Obj->[%s::]%s, Name, Type, Width" ("objects_ff62.html" ("PRECISION" . 1007582)))
    ("Cleanup" pro "IDLffShape" (system) "Obj->[%s::]%s" ("objects_ff63.html"))
    ("Close" pro "IDLffShape" (system) "Obj->[%s::]%s" ("objects_ff64.html"))
    ("DestroyEntity" pro "IDLffShape" (system) "Obj->[%s::]%s, Entity" ("objects_ff65.html"))
    ("GetProperty" pro "IDLffShape" (system) "Obj->[%s::]%s" ("objects_ff68.html" ) ("objects_ff61.html" ("ATTRIBUTE_INFO" . 1027034) ("ATTRIBUTE_NAMES" . 1027309) ("ENTITY_TYPE" . 1027088) ("FILENAME" . 1027353) ("IS_OPEN" . 1027563) ("N_ATTRIBUTES" . 1027361) ("N_ENTITIES" . 1027330) ("N_RECORDS" . 1027328)))
    ("PutEntity" pro "IDLffShape" (system) "Obj->[%s::]%s, Data" ("objects_ff71.html"))
    ("SetAttributes" pro "IDLffShape" (system) "Obj->[%s::]%s, Index, Attribute_Num, Value or Obj->[%s::]%s, Index, Attributes" ("objects_ff72.html"))
    ("GetAttributes" fun "IDLffShape" (system) "Result = Obj->[%s::]%s([Index])" ("objects_ff66.html" ("ALL" . 1007785) ("ATTRIBUTE_STUCTURE" . 1007787)))
    ("GetEntity" fun "IDLffShape" (system) "Result = Obj->[%s::]%s([Index])" ("objects_ff67.html" ("ALL" . 1007853) ("ATTRIBUTES" . 1007855)))
    ("Init" fun "IDLffShape" (system) "Result = Obj->[%s::]%s([, Filename])" ("objects_ff69.html" ) ("objects_ff61.html" ("DBF_ONLY" . 1027319) ("ENTITY_TYPE" . 1027088) ("UPDATE" . 1027071)))
    ("Open" fun "IDLffShape" (system) "Result = Obj->[%s::]%s( `Filename')" ("objects_ff70.html" ("DBF_ONLY" . 1008149) ("ENTITY_TYPE" . 1008154) ("UPDATE" . 1054733)))
    ("SetValue" pro "IDLffXMLDOMAttr" (system) "Obj->[%s::]%s, Value" ("objects_ff81.html"))
    ("GetName" fun "IDLffXMLDOMAttr" (system) "Result = Obj->[%s::]%s()" ("objects_ff77.html"))
    ("GetSpecified" fun "IDLffXMLDOMAttr" (system) "Result = Obj->[%s::]%s()" ("objects_ff78.html"))
    ("GetValue" fun "IDLffXMLDOMAttr" (system) "Result = Obj->[%s::]%s()" ("objects_ff79.html"))
    ("AppendData" pro "IDLffXMLDOMCharacterData" (system) "Obj->[%s::]%s, String" ("objects_ff88.html"))
    ("DeleteData" pro "IDLffXMLDOMCharacterData" (system) "Obj->[%s::]%s, Offset, Count" ("objects_ff90.html"))
    ("InsertData" pro "IDLffXMLDOMCharacterData" (system) "Obj->[%s::]%s, Offset, String" ("objects_ff94.html"))
    ("ReplaceData" pro "IDLffXMLDOMCharacterData" (system) "Obj->[%s::]%s, Offset, Count, String" ("objects_ff95.html"))
    ("SetData" pro "IDLffXMLDOMCharacterData" (system) "Obj->[%s::]%s, String" ("objects_ff96.html"))
    ("GetData" fun "IDLffXMLDOMCharacterData" (system) "Result = Obj->[%s::]%s()" ("objects_ff91.html"))
    ("GetLength" fun "IDLffXMLDOMCharacterData" (system) "Result = Obj->[%s::]%s()" ("objects_ff92.html"))
    ("SubstringData" fun "IDLffXMLDOMCharacterData" (system) "Result = Obj->[%s::]%s( Offset, Count )" ("objects_ff97.html"))
    ("Cleanup" pro "IDLffXMLDOMDocument" (system) "Obj->[%s::]%s" ("objects_ff104.html"))
    ("Load" pro "IDLffXMLDOMDocument" (system) "Obj->[%s::]%s" ("objects_ff117.html" ("EXCLUDE_IGNORABLE_WHITESPACE" . 1128132) ("EXPAND_ENTITY_REFERENCES" . 1128141) ("FILENAME" . 1128144) ("MSG_ERROR" . 1128147) ("MSG_FATAL" . 1128154) ("MSG_WARNING" . 1128160) ("QUIET" . 1128166) ("VALIDATION_MODE" . 1128169)))
    ("Save" pro "IDLffXMLDOMDocument" (system) "Obj->[%s::]%s" ("objects_ff118.html" ("EXPAND_ENTITY_REFERENCES" . 1128198) ("FILENAME" . 1128201) ("PRETTY_PRINT" . 1128204)))
    ("CreateAttribute" fun "IDLffXMLDOMDocument" (system) "Result = Obj->[%s::]%s( Name )" ("objects_ff105.html"))
    ("CreateCDATASection" fun "IDLffXMLDOMDocument" (system) "Result = Obj->[%s::]%s( String )" ("objects_ff106.html"))
    ("CreateComment" fun "IDLffXMLDOMDocument" (system) "Result = Obj->[%s::]%s( String )" ("objects_ff107.html"))
    ("CreateDocumentFragment" fun "IDLffXMLDOMDocument" (system) "Result = Obj->[%s::]%s()" ("objects_ff108.html"))
    ("CreateElement" fun "IDLffXMLDOMDocument" (system) "Result = Obj->[%s::]%s( TagName )" ("objects_ff109.html"))
    ("CreateEntityReference" fun "IDLffXMLDOMDocument" (system) "Result = Obj->[%s::]%s( Name )" ("objects_ff110.html"))
    ("CreateProcessingInstruction" fun "IDLffXMLDOMDocument" (system) "Result = Obj->[%s::]%s( Target, Data )" ("objects_ff111.html"))
    ("CreateTextNode" fun "IDLffXMLDOMDocument" (system) "Result = Obj->[%s::]%s( String )" ("objects_ff112.html"))
    ("GetDoctype" fun "IDLffXMLDOMDocument" (system) "Result = Obj->[%s::]%s()" ("objects_ff113.html"))
    ("GetDocumentElement" fun "IDLffXMLDOMDocument" (system) "Result = Obj->[%s::]%s()" ("objects_ff114.html"))
    ("GetElementsByTagName" fun "IDLffXMLDOMDocument" (system) "Result = Obj->[%s::]%s( TagName )" ("objects_ff115.html"))
    ("Init" fun "IDLffXMLDOMDocument" (system) "Result = Obj->[%s::]%s()" ("objects_ff116.html" ("EXCLUDE_IGNORABLE_WHITESPACE" . 1128039) ("EXPAND_ENTITY_REFERENCES" . 1128048) ("FILENAME" . 1128051) ("MSG_ERROR" . 1128054) ("MSG_FATAL" . 1128061) ("MSG_WARNING" . 1128067) ("QUIET" . 1128073) ("VALIDATION_MODE" . 1128076)))
    ("GetEntities" fun "IDLffXMLDOMDocumentType" (system) "Result = Obj->[%s::]%s()" ("objects_ff126.html"))
    ("GetName" fun "IDLffXMLDOMDocumentType" (system) "Result = Obj->[%s::]%s()" ("objects_ff127.html"))
    ("GetNotations" fun "IDLffXMLDOMDocumentType" (system) "Result = Obj->[%s::]%s()" ("objects_ff128.html"))
    ("SetAttribute" pro "IDLffXMLDOMElement" (system) "Obj->[%s::]%s, Name, Value" ("objects_ff140.html"))
    ("GetAttribute" fun "IDLffXMLDOMElement" (system) "Result = Obj->[%s::]%s( Name )" ("objects_ff133.html"))
    ("GetAttributeNode" fun "IDLffXMLDOMElement" (system) "Result = Obj->[%s::]%s( Name )" ("objects_ff134.html"))
    ("GetElementsByTagName" fun "IDLffXMLDOMElement" (system) "Result = Obj->[%s::]%s( TagName )" ("objects_ff135.html"))
    ("GetTagName" fun "IDLffXMLDOMElement" (system) "Result = Obj->[%s::]%s()" ("objects_ff136.html"))
    ("RemoveAttribute" fun "IDLffXMLDOMElement" (system) "Result = Obj->[%s::]%s( Name )" ("objects_ff138.html"))
    ("RemoveAttributeNode" fun "IDLffXMLDOMElement" (system) "Result = Obj->[%s::]%s( OldAttr )" ("objects_ff139.html"))
    ("SetAttributeNode" fun "IDLffXMLDOMElement" (system) "Result = Obj->[%s::]%s( NewAttr )" ("objects_ff141.html"))
    ("GetNotationName" fun "IDLffXMLDOMEntity" (system) "Result = Obj->[%s::]%s()" ("objects_ff145.html"))
    ("GetPublicId" fun "IDLffXMLDOMEntity" (system) "Result = Obj->[%s::]%s()" ("objects_ff146.html"))
    ("GetSystemId" fun "IDLffXMLDOMEntity" (system) "Result = Obj->[%s::]%s()" ("objects_ff147.html"))
    ("GetLength" fun "IDLffXMLDOMNamedNodeMap" (system) "Result = Obj->[%s::]%s()" ("objects_ff156.html"))
    ("GetNamedItem" fun "IDLffXMLDOMNamedNodeMap" (system) "Result = Obj->[%s::]%s( Name )" ("objects_ff157.html"))
    ("Item" fun "IDLffXMLDOMNamedNodeMap" (system) "Result = Obj->[%s::]%s( Index )" ("objects_ff159.html"))
    ("RemoveNamedItem" fun "IDLffXMLDOMNamedNodeMap" (system) "Result = Obj->[%s::]%s( Name )" ("objects_ff160.html"))
    ("SetNamedItem" fun "IDLffXMLDOMNamedNodeMap" (system) "Result = Obj->[%s::]%s( Node )" ("objects_ff161.html"))
    ("SetNodeValue" pro "IDLffXMLDOMNode" (system) "Obj->[%s::]%s( NodeValue )" ("objects_ff183.html"))
    ("AppendChild" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s( NewChild )" ("objects_ff164.html"))
    ("CloneNode" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s()" ("objects_ff166.html" ("DEEP" . 1129314)))
    ("GetAttributes" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s()" ("objects_ff167.html"))
    ("GetChildNodes" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s()" ("objects_ff168.html"))
    ("GetFirstChild" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s()" ("objects_ff169.html"))
    ("GetLastChild" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s()" ("objects_ff170.html"))
    ("GetNextSibling" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s()" ("objects_ff171.html"))
    ("GetNodeName" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s()" ("objects_ff172.html"))
    ("GetNodeType" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s()" ("objects_ff173.html"))
    ("GetNodeValue" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s()" ("objects_ff174.html"))
    ("GetOwnerDocument" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s()" ("objects_ff175.html"))
    ("GetParentNode" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s()" ("objects_ff176.html"))
    ("GetPreviousSibling" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s()" ("objects_ff177.html"))
    ("HasChildNodes" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s()" ("objects_ff178.html"))
    ("InsertBefore" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s( NewChild [, RefChild] )" ("objects_ff180.html"))
    ("RemoveChild" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s( OldChild )" ("objects_ff181.html"))
    ("ReplaceChild" fun "IDLffXMLDOMNode" (system) "Result = Obj->[%s::]%s( NewChild, OldChild )" ("objects_ff182.html"))
    ("GetLength" fun "IDLffXMLDOMNodeList" (system) "Result = Obj->[%s::]%s()" ("objects_ff187.html"))
    ("Item" fun "IDLffXMLDOMNodeList" (system) "Result = Obj->[%s::]%s( Index )" ("objects_ff189.html"))
    ("GetPublicId" fun "IDLffXMLDOMNotation" (system) "Result = Obj->[%s::]%s()" ("objects_ff193.html"))
    ("GetSystemId" fun "IDLffXMLDOMNotation" (system) "Result = Obj->[%s::]%s()" ("objects_ff194.html"))
    ("SetData" pro "IDLffXMLDOMProcessingInstruction" (system) "Obj->[%s::]%s, Content" ("objects_ff202.html"))
    ("GetData" fun "IDLffXMLDOMProcessingInstruction" (system) "Result = Obj->[%s::]%s()" ("objects_ff199.html"))
    ("GetTarget" fun "IDLffXMLDOMProcessingInstruction" (system) "Result = Obj->[%s::]%s()" ("objects_ff200.html"))
    ("IsIgnorableWhitespace" fun "IDLffXMLDOMText" (system) "Result = Obj->[%s::]%s()" ("objects_ff207.html"))
    ("SplitText" fun "IDLffXMLDOMText" (system) "Result = Obj->[%s::]%s( Offset )" ("objects_ff208.html"))
    ("AttributeDecl" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, eName, aName, Type, Mode, Value" ("objects_ff211.html"))
    ("Characters" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Chars" ("objects_ff212.html"))
    ("Cleanup" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s" ("objects_ff213.html"))
    ("Comment" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Comment" ("objects_ff214.html"))
    ("ElementDecl" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Name, Model" ("objects_ff215.html"))
    ("EndCDATA" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s" ("objects_ff216.html"))
    ("EndDocument" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s" ("objects_ff217.html"))
    ("EndDTD" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s" ("objects_ff218.html"))
    ("EndElement" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, URI, Local, qName" ("objects_ff219.html"))
    ("EndEntity" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Name" ("objects_ff220.html"))
    ("EndPrefixMapping" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Prefix" ("objects_ff221.html"))
    ("Error" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, SystemID, LineNumber, ColumnNumber, Message" ("objects_ff222.html"))
    ("ExternalEntityDecl" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Name, PublicID, SystemID" ("objects_ff223.html"))
    ("FatalError" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, SystemID, LineNumber, ColumnNumber, Message" ("objects_ff224.html"))
    ("GetProperty" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s" ("objects_ff225.html" ) ("objects_ff210.html" ("FILENAME" . 1027975) ("NAMESPACE_PREFIXES" . 1028045) ("PARSER_LOCATION" . 1028043) ("PARSER_PUBLICID" . 1027979) ("PARSER_URI" . 1027981) ("SCHEMA_CHECKING" . 1027990) ("VALIDATION_MODE" . 1028403)))
    ("IgnorableWhitespace" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Chars" ("objects_ff226.html"))
    ("InternalEntityDecl" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Name, Value" ("objects_ff228.html"))
    ("NotationDecl" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Name, PublicID, SystemID" ("objects_ff229.html"))
    ("ParseFile" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Filename" ("objects_ff230.html"))
    ("ProcessingInstruction" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Target, Data" ("objects_ff231.html"))
    ("SetProperty" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s" ("objects_ff232.html" ) ("objects_ff210.html" ("NAMESPACE_PREFIXES" . 1028045) ("SCHEMA_CHECKING" . 1027990) ("VALIDATION_MODE" . 1028403)))
    ("SkippedEntity" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Name" ("objects_ff233.html"))
    ("StartCDATA" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s" ("objects_ff234.html"))
    ("StartDocument" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s" ("objects_ff235.html"))
    ("StartDTD" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Name, PublicID, SystemID" ("objects_ff236.html"))
    ("StartElement" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, URI, Local, qName [, attName, attValue]" ("objects_ff237.html"))
    ("StartEntity" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Name" ("objects_ff238.html"))
    ("StartPrefixmapping" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Prefix, URI" ("objects_ff239.html"))
    ("StopParsing" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s" ("objects_ff240.html"))
    ("UnparsedEntityDecl" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, Name, PublicID, SystemID, Notation" ("objects_ff241.html"))
    ("Warning" pro "IDLffXMLSAX" (system) "Obj->[%s::]%s, SystemID, LineNumber, ColumnNumber, Message" ("objects_ff242.html"))
    ("Init" fun "IDLffXMLSAX" (system) "Result = Obj->[%s::]%s()" ("objects_ff227.html" ) ("objects_ff210.html" ("NAMESPACE_PREFIXES" . 1028045) ("SCHEMA_CHECKING" . 1027990) ("VALIDATION_MODE" . 1028403)))
    ("Cleanup" pro "IDLgrAxis" (system) "Obj->[%s::]%s" ("objects_gr5.html"))
    ("GetProperty" pro "IDLgrAxis" (system) "Obj->[%s::]%s" ("objects_gr7.html" ) ("objects_gr4.html" ("ALL" . 1045686) ("ALPHA_CHANNEL" . 1486818) ("AM_PM" . 1045715) ("CLIP_PLANES" . 1045717) ("COLOR" . 1045723) ("CRANGE" . 1047485) ("DAYS_OF_WEEK" . 1045725) ("DEPTH_TEST_DISABLE" . 1045727) ("DEPTH_TEST_FUNCTION" . 1093233) ("DEPTH_WRITE_DISABLE" . 1093333) ("DIRECTION" . 1093366) ("EXACT" . 1045730) ("EXTEND" . 1045732) ("GRIDSTYLE" . 1045735) ("HIDE" . 1048340) ("LOCATION" . 1048266) ("LOG" . 1045756) ("MAJOR" . 1045758) ("MINOR" . 1045760) ("MONTHS" . 1045762) ("NOTEXT" . 1045766) ("PALETTE" . 1045768) ("PARENT" . 1047517) ("RANGE" . 1045770) ("SUBTICKLEN" . 1093445) ("TEXTALIGNMENTS" . 1045774) ("TEXTBASELINE" . 1048408) ("TEXTPOS" . 1045782) ("TEXTUPDIR" . 1045815) ("THICK" . 1045821) ("TICKDIR" . 1045823) ("TICKFORMAT" . 1565506) ("TICKFRMTDATA" . 1565556) ("TICKINTERVAL" . 1045845) ("TICKLAYOUT" . 1045848) ("TICKLEN" . 1045855) ("TICKTEXT" . 1362754) ("TICKUNITS" . 1362791) ("TICKVALUES" . 1281692) ("TITLE" . 1045882) ("USE_TEXT_COLOR" . 1045887) ("XCOORD_CONV" . 1045891) ("XRANGE" . 1047679) ("YCOORD_CONV" . 1045897) ("YRANGE" . 1047646) ("ZCOORD_CONV" . 1045903) ("ZRANGE" . 1047606)))
    ("SetProperty" pro "IDLgrAxis" (system) "Obj->[%s::]%s" ("objects_gr9.html" ) ("objects_gr4.html" ("ALPHA_CHANNEL" . 1486818) ("AM_PM" . 1045715) ("CLIP_PLANES" . 1045717) ("COLOR" . 1045723) ("DAYS_OF_WEEK" . 1045725) ("DEPTH_TEST_DISABLE" . 1045727) ("DEPTH_TEST_FUNCTION" . 1093233) ("DEPTH_WRITE_DISABLE" . 1093333) ("DIRECTION" . 1093366) ("EXACT" . 1045730) ("EXTEND" . 1045732) ("GRIDSTYLE" . 1045735) ("HIDE" . 1048340) ("LOCATION" . 1048266) ("LOG" . 1045756) ("MAJOR" . 1045758) ("MINOR" . 1045760) ("MONTHS" . 1045762) ("NOTEXT" . 1045766) ("RANGE" . 1045770) ("SUBTICKLEN" . 1093445) ("TEXTALIGNMENTS" . 1045774) ("TEXTBASELINE" . 1048408) ("TEXTPOS" . 1045782) ("TEXTUPDIR" . 1045815) ("THICK" . 1045821) ("TICKDIR" . 1045823) ("TICKFORMAT" . 1565506) ("TICKFRMTDATA" . 1565556) ("TICKINTERVAL" . 1045845) ("TICKLAYOUT" . 1045848) ("TICKLEN" . 1045855) ("TICKTEXT" . 1362754) ("TICKUNITS" . 1362791) ("TICKVALUES" . 1281692) ("TITLE" . 1045882) ("USE_TEXT_COLOR" . 1045887) ("XCOORD_CONV" . 1045891) ("YCOORD_CONV" . 1045897) ("ZCOORD_CONV" . 1045903)))
    ("GetCTM" fun "IDLgrAxis" (system) "Result = Obj->[%s::]%s()" ("objects_gr6.html" ("DESTINATION" . 1092556) ("PATH" . 1007341) ("TOP" . 1007347)))
    ("Init" fun "IDLgrAxis" (system) "Result = Obj->[%s::]%s([, Direction])" ("objects_gr8.html" ) ("objects_gr4.html" ("ALPHA_CHANNEL" . 1486818) ("AM_PM" . 1045715) ("CLIP_PLANES" . 1045717) ("COLOR" . 1045723) ("DAYS_OF_WEEK" . 1045725) ("DEPTH_TEST_DISABLE" . 1045727) ("DEPTH_TEST_FUNCTION" . 1093233) ("DEPTH_WRITE_DISABLE" . 1093333) ("DIRECTION" . 1093366) ("EXACT" . 1045730) ("EXTEND" . 1045732) ("GRIDSTYLE" . 1045735) ("HIDE" . 1048340) ("LOCATION" . 1048266) ("LOG" . 1045756) ("MAJOR" . 1045758) ("MINOR" . 1045760) ("MONTHS" . 1045762) ("NOTEXT" . 1045766) ("RANGE" . 1045770) ("REGISTER_PROPERTIES" . 1045772) ("SUBTICKLEN" . 1093445) ("TEXTALIGNMENTS" . 1045774) ("TEXTBASELINE" . 1048408) ("TEXTPOS" . 1045782) ("TEXTUPDIR" . 1045815) ("THICK" . 1045821) ("TICKDIR" . 1045823) ("TICKFORMAT" . 1565506) ("TICKFRMTDATA" . 1565556) ("TICKINTERVAL" . 1045845) ("TICKLAYOUT" . 1045848) ("TICKLEN" . 1045855) ("TICKTEXT" . 1362754) ("TICKUNITS" . 1362791) ("TICKVALUES" . 1281692) ("TITLE" . 1045882) ("USE_TEXT_COLOR" . 1045887) ("XCOORD_CONV" . 1045891) ("YCOORD_CONV" . 1045897) ("ZCOORD_CONV" . 1045903)))
    ("Cleanup" pro "IDLgrBuffer" (system) "Obj->[%s::]%s" ("objects_gr12.html"))
    ("Draw" pro "IDLgrBuffer" (system) "Obj->[%s::]%s [, Picture]" ("objects_gr13.html" ("CREATE_INSTANCE" . 1007844) ("DRAW_INSTANCE" . 1007846)))
    ("Erase" pro "IDLgrBuffer" (system) "Obj->[%s::]%s" ("objects_gr14.html" ("COLOR" . 1007879)))
    ("GetDeviceInfo" pro "IDLgrBuffer" (system) "Obj->[%s::]%s" ("objects_gr16.html" ("ALL" . 1007957) ("MAX_NUM_CLIP_PLANES" . 1007959) ("MAX_TEXTURE_DIMENSIONS" . 1007961) ("MAX_VIEWPORT_DIMENSIONS" . 1007963) ("NAME" . 1007965) ("NUM_CPUS" . 1007967) ("VENDOR" . 1007970) ("VERSION" . 1007972)))
    ("GetProperty" pro "IDLgrBuffer" (system) "Obj->[%s::]%s" ("objects_gr18.html" ) ("objects_gr11.html" ("ALL" . 1050118) ("COLOR_MODEL" . 1050137) ("DIMENSIONS" . 1050141) ("GRAPHICS_TREE" . 1050143) ("IMAGE_DATA" . 1050202) ("N_COLORS" . 1092707) ("PALETTE" . 1050147) ("QUALITY" . 1050149) ("RESOLUTION" . 1093499) ("SCREEN_DIMENSIONS" . 1050191) ("UNITS" . 1050189) ("ZBUFFER_DATA" . 1050181)))
    ("SetProperty" pro "IDLgrBuffer" (system) "Obj->[%s::]%s" ("objects_gr24.html" ) ("objects_gr11.html" ("COLOR_MODEL" . 1050137) ("DIMENSIONS" . 1050141) ("GRAPHICS_TREE" . 1050143) ("PALETTE" . 1050147) ("QUALITY" . 1050149) ("RESOLUTION" . 1093499) ("UNITS" . 1050189)))
    ("GetContiguousPixels" fun "IDLgrBuffer" (system) "Result = Obj->[%s::]%s()" ("objects_gr15.html"))
    ("GetFontnames" fun "IDLgrBuffer" (system) "Result = Obj->[%s::]%s( FamilyName)" ("objects_gr17.html" ("IDL_FONTS" . 1008013) ("STYLES" . 1008015)))
    ("GetTextDimensions" fun "IDLgrBuffer" (system) "Result = Obj->[%s::]%s( TextObj)" ("objects_gr19.html" ("DESCENT" . 1008088) ("PATH" . 1008090)))
    ("Init" fun "IDLgrBuffer" (system) "Result = Obj->[%s::]%s()" ("objects_gr20.html" ) ("objects_gr11.html" ("COLOR_MODEL" . 1050137) ("DIMENSIONS" . 1050141) ("GRAPHICS_TREE" . 1050143) ("N_COLORS" . 1092707) ("PALETTE" . 1050147) ("QUALITY" . 1050149) ("REGISTER_PROPERTIES" . 1050154) ("RESOLUTION" . 1093499) ("UNITS" . 1050189)))
    ("PickData" fun "IDLgrBuffer" (system) "Result = Obj->[%s::]%s( View, Object, Location, XYZLocation)" ("objects_gr21.html" ("DIMENSIONS" . 1008204) ("PATH" . 1008208) ("PICK_STATUS" . 1008214)))
    ("Read" fun "IDLgrBuffer" (system) "Result = Obj->[%s::]%s()" ("objects_gr22.html"))
    ("Select" fun "IDLgrBuffer" (system) "Result = Obj->[%s::]%s(Picture, XY)" ("objects_gr23.html" ("DIMENSIONS" . 1008316) ("ORDER" . 1008320) ("SUB_SELECTION" . 1343723) ("UNITS" . 1008323)))
    ("Cleanup" pro "IDLgrClipboard" (system) "Obj->[%s::]%s" ("objects_gr27.html"))
    ("Draw" pro "IDLgrClipboard" (system) "Obj->[%s::]%s [, Picture]" ("objects_gr28.html" ("CMYK" . 1345463) ("FILENAME" . 1008514) ("POSTSCRIPT" . 1008516) ("VECT_SHADING" . 1340124) ("VECT_SORTING" . 1340189) ("VECT_TEXT_RENDER_METHOD" . 1340235) ("VECTOR" . 1008518)))
    ("GetDeviceInfo" pro "IDLgrClipboard" (system) "Obj->[%s::]%s" ("objects_gr30.html" ("ALL" . 1008688) ("MAX_NUM_CLIP_PLANES" . 1008690) ("MAX_TEXTURE_DIMENSIONS" . 1008692) ("MAX_VIEWPORT_DIMENSIONS" . 1008694) ("NAME" . 1008696) ("NUM_CPUS" . 1008698) ("VENDOR" . 1008701) ("VERSION" . 1008703)))
    ("GetProperty" pro "IDLgrClipboard" (system) "Obj->[%s::]%s" ("objects_gr32.html" ) ("objects_gr26.html" ("ALL" . 1050377) ("COLOR_MODEL" . 1050391) ("DIMENSIONS" . 1050395) ("GRAPHICS_TREE" . 1050397) ("N_COLORS" . 1050399) ("PALETTE" . 1050401) ("QUALITY" . 1050403) ("RESOLUTION" . 1093541) ("SCREEN_DIMENSIONS" . 1050442) ("UNITS" . 1050439)))
    ("SetProperty" pro "IDLgrClipboard" (system) "Obj->[%s::]%s" ("objects_gr35.html" ) ("objects_gr26.html" ("DIMENSIONS" . 1050395) ("GRAPHICS_TREE" . 1050397) ("PALETTE" . 1050401) ("QUALITY" . 1050403) ("RESOLUTION" . 1093541) ("UNITS" . 1050439)))
    ("GetContiguousPixels" fun "IDLgrClipboard" (system) "Result = Obj->[%s::]%s()" ("objects_gr29.html"))
    ("GetFontnames" fun "IDLgrClipboard" (system) "Result = Obj->[%s::]%s( FamilyName)" ("objects_gr31.html" ("IDL_FONTS" . 1008744) ("STYLES" . 1008746)))
    ("GetTextDimensions" fun "IDLgrClipboard" (system) "Result = Obj->[%s::]%s( TextObj)" ("objects_gr33.html" ("DESCENT" . 1008820) ("PATH" . 1008822)))
    ("Init" fun "IDLgrClipboard" (system) "Result = Obj->[%s::]%s()" ("objects_gr34.html" ) ("objects_gr26.html" ("COLOR_MODEL" . 1050391) ("DIMENSIONS" . 1050395) ("GRAPHICS_TREE" . 1050397) ("N_COLORS" . 1050399) ("PALETTE" . 1050401) ("QUALITY" . 1050403) ("REGISTER_PROPERTIES" . 1050408) ("RESOLUTION" . 1093541) ("UNITS" . 1050439)))
    ("Cleanup" pro "IDLgrColorbar" (system) "Obj->[%s::]%s" ("objects_gr38.html"))
    ("GetProperty" pro "IDLgrColorbar" (system) "Obj->[%s::]%s" ("objects_gr40.html" ) ("objects_gr37.html" ("ALL" . 1050584) ("BLUE_VALUES" . 1050601) ("COLOR" . 1050603) ("DIMENSIONS" . 1050605) ("GREEN_VALUES" . 1050607) ("HIDE" . 1050609) ("MAJOR" . 1050613) ("MINOR" . 1050615) ("PALETTE" . 1050619) ("PARENT" . 1050728) ("RED_VALUES" . 1050726) ("SHOW_AXIS" . 1050623) ("SHOW_OUTLINE" . 1050628) ("SUBTICKLEN" . 1050632) ("THICK" . 1050634) ("THREED" . 1050636) ("TICKFORMAT" . 1050638) ("TICKFRMTDATA" . 1050643) ("TICKLEN" . 1050645) ("TICKTEXT" . 1050647) ("TICKVALUES" . 1050649) ("TITLE" . 1050651) ("XCOORD_CONV" . 1050655) ("XRANGE" . 1050718) ("YCOORD_CONV" . 1050716) ("YRANGE" . 1050708) ("ZCOORD_CONV" . 1050706) ("ZRANGE" . 1050697)))
    ("SetProperty" pro "IDLgrColorbar" (system) "Obj->[%s::]%s" ("objects_gr42.html" ) ("objects_gr37.html" ("BLUE_VALUES" . 1050601) ("COLOR" . 1050603) ("DIMENSIONS" . 1050605) ("GREEN_VALUES" . 1050607) ("HIDE" . 1050609) ("MAJOR" . 1050613) ("MINOR" . 1050615) ("PALETTE" . 1050619) ("RED_VALUES" . 1050726) ("SHOW_AXIS" . 1050623) ("SHOW_OUTLINE" . 1050628) ("SUBTICKLEN" . 1050632) ("THICK" . 1050634) ("THREED" . 1050636) ("TICKFORMAT" . 1050638) ("TICKFRMTDATA" . 1050643) ("TICKLEN" . 1050645) ("TICKTEXT" . 1050647) ("TICKVALUES" . 1050649) ("TITLE" . 1050651) ("XCOORD_CONV" . 1050655) ("YCOORD_CONV" . 1050716) ("ZCOORD_CONV" . 1050706)))
    ("ComputeDimensions" fun "IDLgrColorbar" (system) "Result = Obj->[%s::]%s( DestinationObj)" ("objects_gr39.html" ("PATH" . 1009084)))
    ("Init" fun "IDLgrColorbar" (system) "Result = Obj->[%s::]%s([, aRed, aGreen, aBlue])" ("objects_gr41.html" ) ("objects_gr37.html" ("BLUE_VALUES" . 1050601) ("COLOR" . 1050603) ("DIMENSIONS" . 1050605) ("GREEN_VALUES" . 1050607) ("HIDE" . 1050609) ("MAJOR" . 1050613) ("MINOR" . 1050615) ("PALETTE" . 1050619) ("RED_VALUES" . 1050726) ("SHOW_AXIS" . 1050623) ("SHOW_OUTLINE" . 1050628) ("SUBTICKLEN" . 1050632) ("THICK" . 1050634) ("THREED" . 1050636) ("TICKFORMAT" . 1050638) ("TICKFRMTDATA" . 1050643) ("TICKLEN" . 1050645) ("TICKTEXT" . 1050647) ("TICKVALUES" . 1050649) ("TITLE" . 1050651) ("XCOORD_CONV" . 1050655) ("YCOORD_CONV" . 1050716) ("ZCOORD_CONV" . 1050706)))
    ("AdjustLabelOffsets" pro "IDLgrContour" (system) "Obj->[%s::]%s, LevelIndex, LabelOffsets" ("objects_gr45.html"))
    ("Cleanup" pro "IDLgrContour" (system) "Obj->[%s::]%s" ("objects_gr46.html"))
    ("GetLabelInfo" pro "IDLgrContour" (system) "Obj->[%s::]%s, Destination, LevelIndex" ("objects_gr48.html" ("LABEL_OBJECTS" . 1009508) ("LABEL_OFFSETS" . 1009503) ("LABEL_POLYLINES" . 1009505)))
    ("GetProperty" pro "IDLgrContour" (system) "Obj->[%s::]%s" ("objects_gr49.html" ) ("objects_gr44.html" ("ALL" . 1050990) ("ALPHA_CHANNEL" . 1312243) ("AM_PM" . 1051012) ("ANISOTROPY" . 1051014) ("C_COLOR" . 1051029) ("C_FILL_PATTERN" . 1051031) ("C_LABEL_INTERVAL" . 1051033) ("C_LABEL_NOGAPS" . 1051035) ("C_LABEL_OBJECTS" . 1051037) ("C_LABEL_SHOW" . 1051044) ("C_LINESTYLE" . 1051046) ("C_THICK" . 1051056) ("C_USE_LABEL_COLOR" . 1066031) ("C_USE_LABEL_ORIENTATION" . 1051060) ("C_VALUE" . 1051062) ("CLIP_PLANES" . 1051064) ("COLOR" . 1051069) ("DATA_VALUES" . 1051071) ("DAYS_OF_WEEK" . 1051073) ("DEPTH_OFFSET" . 1051075) ("DEPTH_TEST_DISABLE" . 1051081) ("DEPTH_TEST_FUNCTION" . 1093566) ("DEPTH_WRITE_DISABLE" . 1093567) ("DOUBLE_DATA" . 1093568) ("DOUBLE_GEOM" . 1051083) ("DOWNHILL" . 1051085) ("FILL" . 1051087) ("GEOM" . 1051284) ("HIDE" . 1051101) ("LABEL_FONT" . 1051105) ("LABEL_FORMAT" . 1051107) ("LABEL_UNITS" . 1051116) ("MAX_VALUE" . 1051130) ("MIN_VALUE" . 1051134) ("MONTHS" . 1051132) ("N_LEVELS" . 1051138) ("PARENT" . 1051274) ("PLANAR" . 1051272) ("POLYGONS" . 1051144) ("SHADE_RANGE" . 1094439) ("SHADING" . 1051149) ("TICKINTERVAL" . 1051154) ("TICKLEN" . 1051156) ("USE_TEXT_ALIGNMENTS" . 1051158) ("XCOORD_CONV" . 1051162) ("XRANGE" . 1051264) ("YCOORD_CONV" . 1051168) ("YRANGE" . 1051250) ("ZCOORD_CONV" . 1051174) ("ZRANGE" . 1051240)))
    ("SetProperty" pro "IDLgrContour" (system) "Obj->[%s::]%s" ("objects_gr51.html" ) ("objects_gr44.html" ("ALPHA_CHANNEL" . 1312243) ("AM_PM" . 1051012) ("ANISOTROPY" . 1051014) ("C_COLOR" . 1051029) ("C_FILL_PATTERN" . 1051031) ("C_LABEL_INTERVAL" . 1051033) ("C_LABEL_NOGAPS" . 1051035) ("C_LABEL_OBJECTS" . 1051037) ("C_LABEL_SHOW" . 1051044) ("C_LINESTYLE" . 1051046) ("C_THICK" . 1051056) ("C_USE_LABEL_COLOR" . 1066031) ("C_USE_LABEL_ORIENTATION" . 1051060) ("C_VALUE" . 1051062) ("CLIP_PLANES" . 1051064) ("COLOR" . 1051069) ("DATA_VALUES" . 1051071) ("DAYS_OF_WEEK" . 1051073) ("DEPTH_OFFSET" . 1051075) ("DEPTH_TEST_DISABLE" . 1051081) ("DEPTH_TEST_FUNCTION" . 1093566) ("DEPTH_WRITE_DISABLE" . 1093567) ("DOUBLE_DATA" . 1093568) ("DOUBLE_GEOM" . 1051083) ("DOWNHILL" . 1051085) ("FILL" . 1051087) ("GEOMX" . 1051282) ("GEOMY" . 1051091) ("GEOMZ" . 1051093) ("HIDE" . 1051101) ("LABEL_FONT" . 1051105) ("LABEL_FORMAT" . 1051107) ("LABEL_UNITS" . 1051116) ("MAX_VALUE" . 1051130) ("MIN_VALUE" . 1051134) ("MONTHS" . 1051132) ("N_LEVELS" . 1051138) ("PLANAR" . 1051272) ("POLYGONS" . 1051144) ("SHADE_RANGE" . 1094439) ("SHADING" . 1051149) ("TICKINTERVAL" . 1051154) ("TICKLEN" . 1051156) ("USE_TEXT_ALIGNMENTS" . 1051158) ("XCOORD_CONV" . 1051162) ("YCOORD_CONV" . 1051168) ("ZCOORD_CONV" . 1051174)))
    ("GetCTM" fun "IDLgrContour" (system) "Result = Obj->[%s::]%s()" ("objects_gr47.html" ("DESTINATION" . 1009456) ("PATH" . 1009458) ("TOP" . 1009464)))
    ("Init" fun "IDLgrContour" (system) "Result = Obj->[%s::]%s([, Values])" ("objects_gr50.html" ) ("objects_gr44.html" ("ALPHA_CHANNEL" . 1312243) ("AM_PM" . 1051012) ("ANISOTROPY" . 1051014) ("C_COLOR" . 1051029) ("C_FILL_PATTERN" . 1051031) ("C_LABEL_INTERVAL" . 1051033) ("C_LABEL_NOGAPS" . 1051035) ("C_LABEL_OBJECTS" . 1051037) ("C_LABEL_SHOW" . 1051044) ("C_LINESTYLE" . 1051046) ("C_THICK" . 1051056) ("C_USE_LABEL_COLOR" . 1066031) ("C_USE_LABEL_ORIENTATION" . 1051060) ("C_VALUE" . 1051062) ("CLIP_PLANES" . 1051064) ("COLOR" . 1051069) ("DATA_VALUES" . 1051071) ("DAYS_OF_WEEK" . 1051073) ("DEPTH_OFFSET" . 1051075) ("DEPTH_TEST_DISABLE" . 1051081) ("DEPTH_TEST_FUNCTION" . 1093566) ("DEPTH_WRITE_DISABLE" . 1093567) ("DOUBLE_DATA" . 1093568) ("DOUBLE_GEOM" . 1051083) ("DOWNHILL" . 1051085) ("FILL" . 1051087) ("GEOMX" . 1051282) ("GEOMY" . 1051091) ("GEOMZ" . 1051093) ("HIDE" . 1051101) ("LABEL_FONT" . 1051105) ("LABEL_FORMAT" . 1051107) ("LABEL_FRMTDATA" . 1051113) ("LABEL_UNITS" . 1051116) ("MAX_VALUE" . 1051130) ("MIN_VALUE" . 1051134) ("MONTHS" . 1051132) ("N_LEVELS" . 1051138) ("PALETTE" . 1051140) ("PLANAR" . 1051272) ("POLYGONS" . 1051144) ("REGISTER_PROPERTIES" . 1051147) ("SHADE_RANGE" . 1094439) ("SHADING" . 1051149) ("TICKINTERVAL" . 1051154) ("TICKLEN" . 1051156) ("USE_TEXT_ALIGNMENTS" . 1051158) ("XCOORD_CONV" . 1051162) ("YCOORD_CONV" . 1051168) ("ZCOORD_CONV" . 1051174)))
    ("Cleanup" pro "IDLgrFont" (system) "Obj->[%s::]%s" ("objects_gr54.html"))
    ("GetProperty" pro "IDLgrFont" (system) "Obj->[%s::]%s" ("objects_gr55.html" ) ("objects_gr53.html" ("ALL" . 1051913) ("SIZE" . 1051936) ("SUBSTITUTE" . 1051938) ("THICK" . 1051940)))
    ("SetProperty" pro "IDLgrFont" (system) "Obj->[%s::]%s" ("objects_gr57.html" ) ("objects_gr53.html" ("SIZE" . 1051936) ("SUBSTITUTE" . 1051938) ("THICK" . 1051940)))
    ("Init" fun "IDLgrFont" (system) "Result = Obj->[%s::]%s([, Fontname])" ("objects_gr56.html" ) ("objects_gr53.html" ("SIZE" . 1051936) ("SUBSTITUTE" . 1051938) ("THICK" . 1051940)))
    ("Cleanup" pro "IDLgrImage" (system) "Obj->[%s::]%s" ("objects_gr60.html"))
    ("GetProperty" pro "IDLgrImage" (system) "Obj->[%s::]%s" ("objects_gr62.html" ) ("objects_gr59.html" ("ALL" . 1052050) ("BLEND_FUNCTION" . 1052068) ("CHANNEL" . 1052124) ("CLIP_PLANES" . 1287882) ("DATA" . 1052132) ("DEPTH_TEST_DISABLE" . 1095165) ("DEPTH_TEST_FUNCTION" . 1095212) ("DEPTH_WRITE_DISABLE" . 1095251) ("DIMENSIONS" . 1095169) ("GREYSCALE" . 1052136) ("HIDE" . 1052140) ("INTERLEAVE" . 1052144) ("INTERPOLATE" . 1052150) ("LOCATION" . 1052152) ("NO_COPY" . 1052156) ("ORDER" . 1052158) ("PALETTE" . 1052160) ("PARENT" . 1052253) ("SUB_RECT" . 1052171) ("XCOORD_CONV" . 1052175) ("XRANGE" . 1052243) ("YCOORD_CONV" . 1052181) ("YRANGE" . 1052233) ("ZCOORD_CONV" . 1052187) ("ZRANGE" . 1052223)))
    ("SetProperty" pro "IDLgrImage" (system) "Obj->[%s::]%s" ("objects_gr64.html" ) ("objects_gr59.html" ("BLEND_FUNCTION" . 1052068) ("CHANNEL" . 1052124) ("CLIP_PLANES" . 1287882) ("DATA" . 1052132) ("DEPTH_TEST_DISABLE" . 1095165) ("DEPTH_TEST_FUNCTION" . 1095212) ("DEPTH_WRITE_DISABLE" . 1095251) ("DIMENSIONS" . 1095169) ("GREYSCALE" . 1052136) ("HIDE" . 1052140) ("INTERLEAVE" . 1052144) ("INTERPOLATE" . 1052150) ("LOCATION" . 1052152) ("NO_COPY" . 1052156) ("ORDER" . 1052158) ("PALETTE" . 1052160) ("RESET_DATA" . 1093772) ("SHARE_DATA" . 1052169) ("SUB_RECT" . 1052171) ("XCOORD_CONV" . 1052175) ("YCOORD_CONV" . 1052181) ("ZCOORD_CONV" . 1052187)))
    ("GetCTM" fun "IDLgrImage" (system) "Result = Obj->[%s::]%s()" ("objects_gr61.html" ("DESTINATION" . 1010164) ("PATH" . 1010166) ("TOP" . 1010172)))
    ("Init" fun "IDLgrImage" (system) "Result = Obj->[%s::]%s([, ImageData])" ("objects_gr63.html" ) ("objects_gr59.html" ("BLEND_FUNCTION" . 1052068) ("CHANNEL" . 1052124) ("CLIP_PLANES" . 1287882) ("DATA" . 1052132) ("DEPTH_TEST_DISABLE" . 1095165) ("DEPTH_TEST_FUNCTION" . 1095212) ("DEPTH_WRITE_DISABLE" . 1095251) ("DIMENSIONS" . 1095169) ("GREYSCALE" . 1052136) ("HIDE" . 1052140) ("INTERLEAVE" . 1052144) ("INTERPOLATE" . 1052150) ("LOCATION" . 1052152) ("NO_COPY" . 1052156) ("ORDER" . 1052158) ("PALETTE" . 1052160) ("REGISTER_PROPERTIES" . 1052251) ("RESET_DATA" . 1093772) ("SHARE_DATA" . 1052169) ("SUB_RECT" . 1052171) ("XCOORD_CONV" . 1052175) ("YCOORD_CONV" . 1052181) ("ZCOORD_CONV" . 1052187)))
    ("Cleanup" pro "IDLgrLegend" (system) "Obj->[%s::]%s" ("objects_gr67.html"))
    ("GetProperty" pro "IDLgrLegend" (system) "Obj->[%s::]%s" ("objects_gr69.html" ) ("objects_gr66.html" ("ALL" . 1053896) ("BORDER_GAP" . 1053903) ("COLUMNS" . 1053905) ("FILL_COLOR" . 1053907) ("FONT" . 1053909) ("GAP" . 1053912) ("GLYPH_WIDTH" . 1053914) ("HIDE" . 1053916) ("ITEM_COLOR" . 1069308) ("ITEM_LINESTYLE" . 1053922) ("ITEM_NAME" . 1053935) ("ITEM_OBJECT" . 1053937) ("ITEM_THICK" . 1053940) ("ITEM_TYPE" . 1053942) ("OUTLINE_COLOR" . 1053948) ("OUTLINE_THICK" . 1053950) ("PARENT" . 1055362) ("SHOW_FILL" . 1053952) ("SHOW_OUTLINE" . 1053956) ("TEXT_COLOR" . 1053960) ("TITLE" . 1053962) ("XCOORD_CONV" . 1053966) ("XRANGE" . 1055399) ("YCOORD_CONV" . 1053972) ("YRANGE" . 1055389) ("ZCOORD_CONV" . 1053978) ("ZRANGE" . 1070059)))
    ("SetProperty" pro "IDLgrLegend" (system) "Obj->[%s::]%s" ("objects_gr71.html" ) ("objects_gr66.html" ("BORDER_GAP" . 1053903) ("COLUMNS" . 1053905) ("FILL_COLOR" . 1053907) ("FONT" . 1053909) ("GAP" . 1053912) ("GLYPH_WIDTH" . 1053914) ("HIDE" . 1053916) ("ITEM_COLOR" . 1069308) ("ITEM_LINESTYLE" . 1053922) ("ITEM_NAME" . 1053935) ("ITEM_OBJECT" . 1053937) ("ITEM_THICK" . 1053940) ("ITEM_TYPE" . 1053942) ("OUTLINE_COLOR" . 1053948) ("OUTLINE_THICK" . 1053950) ("RECOMPUTE" . 1055360) ("SHOW_FILL" . 1053952) ("SHOW_OUTLINE" . 1053956) ("TEXT_COLOR" . 1053960) ("TITLE" . 1053962) ("XCOORD_CONV" . 1053966) ("YCOORD_CONV" . 1053972) ("ZCOORD_CONV" . 1053978)))
    ("ComputeDimensions" fun "IDLgrLegend" (system) "Result = Obj->[%s::]%s( DestinationObject)" ("objects_gr68.html" ("PATH" . 1010563)))
    ("Init" fun "IDLgrLegend" (system) "Result = Obj->[%s::]%s([, aItemNames])" ("objects_gr70.html" ) ("objects_gr66.html" ("BORDER_GAP" . 1053903) ("COLUMNS" . 1053905) ("FILL_COLOR" . 1053907) ("FONT" . 1053909) ("GAP" . 1053912) ("GLYPH_WIDTH" . 1053914) ("HIDE" . 1053916) ("ITEM_COLOR" . 1069308) ("ITEM_LINESTYLE" . 1053922) ("ITEM_NAME" . 1053935) ("ITEM_OBJECT" . 1053937) ("ITEM_THICK" . 1053940) ("ITEM_TYPE" . 1053942) ("OUTLINE_COLOR" . 1053948) ("OUTLINE_THICK" . 1053950) ("SHOW_FILL" . 1053952) ("SHOW_OUTLINE" . 1053956) ("TEXT_COLOR" . 1053960) ("TITLE" . 1053962) ("XCOORD_CONV" . 1053966) ("YCOORD_CONV" . 1053972) ("ZCOORD_CONV" . 1053978)))
    ("Cleanup" pro "IDLgrLight" (system) "Obj->[%s::]%s" ("objects_gr74.html"))
    ("GetProperty" pro "IDLgrLight" (system) "Obj->[%s::]%s" ("objects_gr76.html" ) ("objects_gr73.html" ("ALL" . 1055555) ("ATTENUATION" . 1055572) ("COLOR" . 1055581) ("CONEANGLE" . 1055583) ("DIRECTION" . 1055585) ("FOCUS" . 1055588) ("HIDE" . 1055590) ("INTENSITY" . 1055595) ("LOCATION" . 1055597) ("PALETTE" . 1088211) ("PARENT" . 1055635) ("TYPE" . 1093801) ("XCOORD_CONV" . 1055609) ("YCOORD_CONV" . 1055615) ("ZCOORD_CONV" . 1055621)))
    ("SetProperty" pro "IDLgrLight" (system) "Obj->[%s::]%s" ("objects_gr78.html" ) ("objects_gr73.html" ("ATTENUATION" . 1055572) ("COLOR" . 1055581) ("CONEANGLE" . 1055583) ("DIRECTION" . 1055585) ("FOCUS" . 1055588) ("HIDE" . 1055590) ("INTENSITY" . 1055595) ("LOCATION" . 1055597) ("PALETTE" . 1088211) ("TYPE" . 1093801) ("XCOORD_CONV" . 1055609) ("YCOORD_CONV" . 1055615) ("ZCOORD_CONV" . 1055621)))
    ("GetCTM" fun "IDLgrLight" (system) "Result = Obj->[%s::]%s()" ("objects_gr75.html" ("DESTINATION" . 1010900) ("PATH" . 1010902) ("TOP" . 1010908)))
    ("Init" fun "IDLgrLight" (system) "Result = Obj->[%s::]%s()" ("objects_gr77.html" ) ("objects_gr73.html" ("ATTENUATION" . 1055572) ("COLOR" . 1055581) ("CONEANGLE" . 1055583) ("DIRECTION" . 1055585) ("FOCUS" . 1055588) ("HIDE" . 1055590) ("INTENSITY" . 1055595) ("LOCATION" . 1055597) ("PALETTE" . 1088211) ("REGISTER_PROPERTIES" . 1088158) ("TYPE" . 1093801) ("XCOORD_CONV" . 1055609) ("YCOORD_CONV" . 1055615) ("ZCOORD_CONV" . 1055621)))
    ("Add" pro "IDLgrModel" (system) "Obj->[%s::]%s, Object" ("objects_gr81.html" ("ALIAS" . 1011206) ("POSITION" . 1011208)))
    ("Cleanup" pro "IDLgrModel" (system) "Obj->[%s::]%s" ("objects_gr82.html"))
    ("Draw" pro "IDLgrModel" (system) "Obj->[%s::]%s, Destination, Picture" ("objects_gr83.html"))
    ("GetProperty" pro "IDLgrModel" (system) "Obj->[%s::]%s" ("objects_gr86.html" ) ("objects_gr80.html" ("ALL" . 1055726) ("CLIP_PLANES" . 1055740) ("DEPTH_TEST_DISABLE" . 1094976) ("DEPTH_TEST_FUNCTION" . 1095322) ("DEPTH_WRITE_DISABLE" . 1095361) ("HIDE" . 1088312) ("LIGHTING" . 1055751) ("PARENT" . 1055781) ("SELECT_TARGET" . 1093831) ("TRANSFORM" . 1055764)))
    ("Reset" pro "IDLgrModel" (system) "Obj->[%s::]%s" ("objects_gr88.html"))
    ("Rotate" pro "IDLgrModel" (system) "Obj->[%s::]%s, Axis, Angle" ("objects_gr89.html" ("PREMULTIPLY" . 1011584)))
    ("Scale" pro "IDLgrModel" (system) "Obj->[%s::]%s, Sx, Sy, Sz" ("objects_gr90.html" ("PREMULTIPLY" . 1011618)))
    ("SetProperty" pro "IDLgrModel" (system) "Obj->[%s::]%s" ("objects_gr91.html" ) ("objects_gr80.html" ("CLIP_PLANES" . 1055740) ("DEPTH_TEST_DISABLE" . 1094976) ("DEPTH_TEST_FUNCTION" . 1095322) ("DEPTH_WRITE_DISABLE" . 1095361) ("HIDE" . 1088312) ("LIGHTING" . 1055751) ("SELECT_TARGET" . 1093831) ("TRANSFORM" . 1055764)))
    ("Translate" pro "IDLgrModel" (system) "Obj->[%s::]%s, Tx, Ty, Tz" ("objects_gr92.html" ("PREMULTIPLY" . 1011687)))
    ("GetByName" fun "IDLgrModel" (system) "Result = Obj->[%s::]%s(Name)" ("objects_gr84.html"))
    ("GetCTM" fun "IDLgrModel" (system) "Result = Obj->[%s::]%s()" ("objects_gr85.html" ("DESTINATION" . 1011369) ("PATH" . 1011371) ("TOP" . 1011377)))
    ("Init" fun "IDLgrModel" (system) "Result = Obj->[%s::]%s()" ("objects_gr87.html" ) ("objects_gr80.html" ("CLIP_PLANES" . 1055740) ("DEPTH_TEST_DISABLE" . 1094976) ("DEPTH_TEST_FUNCTION" . 1095322) ("DEPTH_WRITE_DISABLE" . 1095361) ("HIDE" . 1088312) ("LIGHTING" . 1055751) ("REGISTER_PROPERTIES" . 1055779) ("SELECT_TARGET" . 1093831) ("TRANSFORM" . 1055764)))
    ("Cleanup" pro "IDLgrMPEG" (system) "Obj->[%s::]%s" ("objects_gr95.html"))
    ("GetProperty" pro "IDLgrMPEG" (system) "Obj->[%s::]%s" ("objects_gr96.html" ) ("objects_gr94.html" ("ALL" . 1055838) ("BITRATE" . 1055845) ("FILENAME" . 1055875) ("FORMAT" . 1055877) ("FRAME_RATE" . 1055881) ("IFRAME_GAP" . 1055927) ("INTERLACED" . 1055934) ("MOTION_VEC_LENGTH" . 1055936) ("QUALITY" . 1055964) ("SCALE" . 1055967) ("STATISTICS" . 1055969)))
    ("Put" pro "IDLgrMPEG" (system) "Obj->[%s::]%s, Image[, Frame]" ("objects_gr98.html"))
    ("Save" pro "IDLgrMPEG" (system) "Obj->[%s::]%s" ("objects_gr99.html" ("FILENAME" . 1012062)))
    ("SetProperty" pro "IDLgrMPEG" (system) "Obj->[%s::]%s" ("objects_gr100.html" ) ("objects_gr94.html" ("BITRATE" . 1055845) ("FILENAME" . 1055875) ("FORMAT" . 1055877) ("FRAME_RATE" . 1055881) ("IFRAME_GAP" . 1055927) ("INTERLACED" . 1055934) ("MOTION_VEC_LENGTH" . 1055936) ("QUALITY" . 1055964) ("SCALE" . 1055967) ("STATISTICS" . 1055969)))
    ("Init" fun "IDLgrMPEG" (system) "Result = Obj->[%s::]%s()" ("objects_gr97.html" ) ("objects_gr94.html" ("BITRATE" . 1055845) ("FILENAME" . 1055875) ("FORMAT" . 1055877) ("FRAME_RATE" . 1055881) ("IFRAME_GAP" . 1055927) ("INTERLACED" . 1055934) ("MOTION_VEC_LENGTH" . 1055936) ("QUALITY" . 1055964) ("SCALE" . 1055967) ("STATISTICS" . 1055969) ("TEMP_DIRECTORY" . 1055971)))
    ("Cleanup" pro "IDLgrPalette" (system) "Obj->[%s::]%s" ("objects_gr103.html"))
    ("GetProperty" pro "IDLgrPalette" (system) "Obj->[%s::]%s" ("objects_gr105.html" ) ("objects_gr102.html" ("ALL" . 1056048) ("BLUE_VALUES" . 1056069) ("BOTTOM_STRETCH" . 1056071) ("GAMMA" . 1056073) ("GREEN_VALUES" . 1056075) ("N_COLORS" . 1056093) ("RED_VALUES" . 1056079) ("TOP_STRETCH" . 1056081)))
    ("LoadCT" pro "IDLgrPalette" (system) "Obj->[%s::]%s, TableNum" ("objects_gr107.html" ("FILE" . 1012379)))
    ("SetProperty" pro "IDLgrPalette" (system) "Obj->[%s::]%s" ("objects_gr110.html" ) ("objects_gr102.html" ("BLUE_VALUES" . 1056069) ("BOTTOM_STRETCH" . 1056071) ("GAMMA" . 1056073) ("GREEN_VALUES" . 1056075) ("RED_VALUES" . 1056079) ("TOP_STRETCH" . 1056081)))
    ("SetRGB" pro "IDLgrPalette" (system) "Obj->[%s::]%s, Index, Red, Green, Blue" ("objects_gr109.html"))
    ("GetRGB" fun "IDLgrPalette" (system) "Result = Obj->[%s::]%s(Index)" ("objects_gr104.html"))
    ("Init" fun "IDLgrPalette" (system) "Result = Obj->[%s::]%s(, aRed, aGreen, aBlue)" ("objects_gr106.html" ) ("objects_gr102.html" ("BLUE_VALUES" . 1056069) ("BOTTOM_STRETCH" . 1056071) ("GAMMA" . 1056073) ("GREEN_VALUES" . 1056075) ("RED_VALUES" . 1056079) ("TOP_STRETCH" . 1056081)))
    ("NearestColor" fun "IDLgrPalette" (system) "Result = Obj->[%s::]%s(Red, Green, Blue)" ("objects_gr108.html"))
    ("Cleanup" pro "IDLgrPattern" (system) "Obj->[%s::]%s" ("objects_gr113.html"))
    ("GetProperty" pro "IDLgrPattern" (system) "Obj->[%s::]%s" ("objects_gr114.html" ) ("objects_gr112.html" ("ALL" . 1056154) ("ORIENTATION" . 1056165) ("PATTERN" . 1056169) ("SPACING" . 1056171) ("STYLE" . 1056173)))
    ("SetProperty" pro "IDLgrPattern" (system) "Obj->[%s::]%s" ("objects_gr116.html" ) ("objects_gr112.html" ("ORIENTATION" . 1056165) ("PATTERN" . 1056169) ("SPACING" . 1056171) ("STYLE" . 1056173)))
    ("Init" fun "IDLgrPattern" (system) "Result = Obj->[%s::]%s([, Style])" ("objects_gr115.html" ) ("objects_gr112.html" ("ORIENTATION" . 1056165) ("PATTERN" . 1056169) ("SPACING" . 1056171) ("STYLE" . 1056173) ("THICK" . 1056179)))
    ("Cleanup" pro "IDLgrPlot" (system) "Obj->[%s::]%s" ("objects_gr119.html"))
    ("GetProperty" pro "IDLgrPlot" (system) "Obj->[%s::]%s" ("objects_gr121.html" ) ("objects_gr118.html" ("ALL" . 1056243) ("ALPHA_CHANNEL" . 1056258) ("CLIP_PLANES" . 1314217) ("COLOR" . 1056263) ("DATA" . 1056381) ("DEPTH_TEST_DISABLE" . 1094982) ("DEPTH_TEST_FUNCTION" . 1095444) ("DEPTH_WRITE_DISABLE" . 1095483) ("DOUBLE" . 1056269) ("HIDE" . 1056271) ("HISTOGRAM" . 1092755) ("LINESTYLE" . 1056277) ("MAX_VALUE" . 1056290) ("MIN_VALUE" . 1056292) ("NSUM" . 1056296) ("PALETTE" . 1056298) ("PARENT" . 1056392) ("POLAR" . 1056389) ("SYMBOL" . 1056306) ("THICK" . 1056311) ("VERT_COLORS" . 1056317) ("XCOORD_CONV" . 1056319) ("XRANGE" . 1056325) ("YCOORD_CONV" . 1056327) ("YRANGE" . 1056333) ("ZCOORD_CONV" . 1056335) ("ZRANGE" . 1074286) ("ZVALUE" . 1056400)))
    ("SetProperty" pro "IDLgrPlot" (system) "Obj->[%s::]%s" ("objects_gr123.html" ) ("objects_gr118.html" ("ALPHA_CHANNEL" . 1056258) ("CLIP_PLANES" . 1314217) ("COLOR" . 1056263) ("DATAX" . 1056378) ("DATAY" . 1056267) ("DEPTH_TEST_DISABLE" . 1094982) ("DEPTH_TEST_FUNCTION" . 1095444) ("DEPTH_WRITE_DISABLE" . 1095483) ("DOUBLE" . 1056269) ("HIDE" . 1056271) ("HISTOGRAM" . 1092755) ("LINESTYLE" . 1056277) ("MAX_VALUE" . 1056290) ("MIN_VALUE" . 1056292) ("NSUM" . 1056296) ("PALETTE" . 1056298) ("POLAR" . 1056389) ("RESET_DATA" . 1093845) ("SHARE_DATA" . 1056304) ("SYMBOL" . 1056306) ("THICK" . 1056311) ("VERT_COLORS" . 1056317) ("XCOORD_CONV" . 1056319) ("XRANGE" . 1056325) ("YCOORD_CONV" . 1056327) ("YRANGE" . 1056333) ("ZCOORD_CONV" . 1056335) ("ZVALUE" . 1056400)))
    ("GetCTM" fun "IDLgrPlot" (system) "Result = Obj->[%s::]%s()" ("objects_gr120.html" ("DESTINATION" . 1012838) ("PATH" . 1012840) ("TOP" . 1012846)))
    ("Init" fun "IDLgrPlot" (system) "Result = Obj->[%s::]%s([, [X,] Y])" ("objects_gr122.html" ) ("objects_gr118.html" ("ALPHA_CHANNEL" . 1056258) ("CLIP_PLANES" . 1314217) ("COLOR" . 1056263) ("DATAX" . 1056378) ("DATAY" . 1056267) ("DEPTH_TEST_DISABLE" . 1094982) ("DEPTH_TEST_FUNCTION" . 1095444) ("DEPTH_WRITE_DISABLE" . 1095483) ("DOUBLE" . 1056269) ("HIDE" . 1056271) ("HISTOGRAM" . 1092755) ("LINESTYLE" . 1056277) ("MAX_VALUE" . 1056290) ("MIN_VALUE" . 1056292) ("NSUM" . 1056296) ("PALETTE" . 1056298) ("POLAR" . 1056389) ("REGISTER_PROPERTIES" . 1056302) ("RESET_DATA" . 1093845) ("SHARE_DATA" . 1056304) ("SYMBOL" . 1056306) ("THICK" . 1056311) ("USE_ZVALUE" . 1056313) ("VERT_COLORS" . 1056317) ("XCOORD_CONV" . 1056319) ("XRANGE" . 1056325) ("YCOORD_CONV" . 1056327) ("YRANGE" . 1056333) ("ZCOORD_CONV" . 1056335) ("ZVALUE" . 1056400)))
    ("Cleanup" pro "IDLgrPolygon" (system) "Obj->[%s::]%s" ("objects_gr126.html"))
    ("GetProperty" pro "IDLgrPolygon" (system) "Obj->[%s::]%s" ("objects_gr128.html" ) ("objects_gr125.html" ("ALL" . 1056563) ("ALPHA_CHANNEL" . 1316054) ("AMBIENT" . 1309898) ("BOTTOM" . 1074388) ("CLIP_PLANES" . 1056581) ("COLOR" . 1056586) ("DATA" . 1309971) ("DEPTH_OFFSET" . 1056590) ("DEPTH_TEST_DISABLE" . 1094995) ("DEPTH_TEST_FUNCTION" . 1095559) ("DEPTH_WRITE_DISABLE" . 1095598) ("DIFFUSE" . 1310292) ("DOUBLE" . 1310286) ("EMISSION" . 1310032) ("FILL_PATTERN" . 1056598) ("HIDE" . 1056602) ("LINESTYLE" . 1056606) ("NORMALS" . 1056621) ("PARENT" . 1056792) ("POLYGONS" . 1056790) ("REJECT" . 1093870) ("SHADE_RANGE" . 1056643) ("SHADING" . 1056645) ("SHININESS" . 1310128) ("SPECULAR" . 1310225) ("STYLE" . 1310253) ("TEXTURE_COORD" . 1214343) ("TEXTURE_INTERP" . 1056664) ("TEXTURE_MAP" . 1056666) ("THICK" . 1056674) ("VERT_COLORS" . 1056679) ("XCOORD_CONV" . 1088401) ("XRANGE" . 1056808) ("YCOORD_CONV" . 1075980) ("YRANGE" . 1056822) ("ZCOORD_CONV" . 1056694) ("ZERO_OPACITY_SKIP" . 1056700) ("ZRANGE" . 1056834)))
    ("SetProperty" pro "IDLgrPolygon" (system) "Obj->[%s::]%s" ("objects_gr130.html" ) ("objects_gr125.html" ("ALPHA_CHANNEL" . 1316054) ("AMBIENT" . 1309898) ("BOTTOM" . 1074388) ("CLIP_PLANES" . 1056581) ("COLOR" . 1056586) ("DATA" . 1309971) ("DEPTH_OFFSET" . 1056590) ("DEPTH_TEST_DISABLE" . 1094995) ("DEPTH_TEST_FUNCTION" . 1095559) ("DEPTH_WRITE_DISABLE" . 1095598) ("DIFFUSE" . 1310292) ("DOUBLE" . 1310286) ("EMISSION" . 1310032) ("FILL_PATTERN" . 1056598) ("HIDE" . 1056602) ("LINESTYLE" . 1056606) ("NORMALS" . 1056621) ("POLYGONS" . 1056790) ("REJECT" . 1093870) ("RESET_DATA" . 1056641) ("SHADE_RANGE" . 1056643) ("SHADING" . 1056645) ("SHARE_DATA" . 1056650) ("SHININESS" . 1310128) ("SPECULAR" . 1310225) ("STYLE" . 1310253) ("TEXTURE_COORD" . 1214343) ("TEXTURE_INTERP" . 1056664) ("TEXTURE_MAP" . 1056666) ("THICK" . 1056674) ("VERT_COLORS" . 1056679) ("XCOORD_CONV" . 1088401) ("YCOORD_CONV" . 1075980) ("ZCOORD_CONV" . 1056694) ("ZERO_OPACITY_SKIP" . 1056700)))
    ("GetCTM" fun "IDLgrPolygon" (system) "Result = Obj->[%s::]%s()" ("objects_gr127.html" ("DESTINATION" . 1013188) ("PATH" . 1013190) ("TOP" . 1013196)))
    ("Init" fun "IDLgrPolygon" (system) "Result = Obj->[%s::]%s([, X [, Y[, Z]]])" ("objects_gr129.html" ) ("objects_gr125.html" ("ALPHA_CHANNEL" . 1316054) ("AMBIENT" . 1309898) ("BOTTOM" . 1074388) ("CLIP_PLANES" . 1056581) ("COLOR" . 1056586) ("DATA" . 1309971) ("DEPTH_OFFSET" . 1056590) ("DEPTH_TEST_DISABLE" . 1094995) ("DEPTH_TEST_FUNCTION" . 1095559) ("DEPTH_WRITE_DISABLE" . 1095598) ("DIFFUSE" . 1310292) ("DOUBLE" . 1310286) ("EMISSION" . 1310032) ("FILL_PATTERN" . 1056598) ("HIDDEN_LINES" . 1056600) ("HIDE" . 1056602) ("LINESTYLE" . 1056606) ("NORMALS" . 1056621) ("PALETTE" . 1056629) ("POLYGONS" . 1056790) ("REGISTER_PROPERTIES" . 1327262) ("REJECT" . 1093870) ("RESET_DATA" . 1056641) ("SHADE_RANGE" . 1056643) ("SHADING" . 1056645) ("SHARE_DATA" . 1056650) ("SHININESS" . 1310128) ("SPECULAR" . 1310225) ("STYLE" . 1310253) ("TEXTURE_COORD" . 1214343) ("TEXTURE_INTERP" . 1056664) ("TEXTURE_MAP" . 1056666) ("THICK" . 1056674) ("VERT_COLORS" . 1056679) ("XCOORD_CONV" . 1088401) ("YCOORD_CONV" . 1075980) ("ZCOORD_CONV" . 1056694) ("ZERO_OPACITY_SKIP" . 1056700)))
    ("Cleanup" pro "IDLgrPolyline" (system) "Obj->[%s::]%s" ("objects_gr133.html"))
    ("GetProperty" pro "IDLgrPolyline" (system) "Obj->[%s::]%s" ("objects_gr135.html" ) ("objects_gr132.html" ("ALL" . 1056980) ("ALPHA_CHANNEL" . 1329463) ("CLIP_PLANES" . 1056996) ("COLOR" . 1057001) ("DATA" . 1057003) ("DEPTH_TEST_DISABLE" . 1095001) ("DEPTH_TEST_FUNCTION" . 1095681) ("DEPTH_WRITE_DISABLE" . 1095720) ("DOUBLE" . 1057005) ("HIDE" . 1057007) ("LABEL_NOGAPS" . 1057011) ("LABEL_OBJECTS" . 1057019) ("LABEL_OFFSETS" . 1057017) ("LABEL_POLYLINES" . 1057330) ("LABEL_USE_VERTEX_COLOR" . 1077987) ("LINESTYLE" . 1057029) ("PALETTE" . 1057044) ("PARENT" . 1057101) ("POLYLINES" . 1057099) ("SHADING" . 1057051) ("SYMBOL" . 1057058) ("THICK" . 1057063) ("USE_LABEL_COLOR" . 1057065) ("USE_LABEL_ORIENTATION" . 1057067) ("USE_TEXT_ALIGNMENTS" . 1057069) ("VERT_COLORS" . 1057073) ("XCOORD_CONV" . 1057075) ("XRANGE" . 1057143) ("YCOORD_CONV" . 1057081) ("YRANGE" . 1057133) ("ZCOORD_CONV" . 1077892) ("ZRANGE" . 1057121)))
    ("SetProperty" pro "IDLgrPolyline" (system) "Obj->[%s::]%s" ("objects_gr137.html" ) ("objects_gr132.html" ("ALPHA_CHANNEL" . 1329463) ("CLIP_PLANES" . 1056996) ("COLOR" . 1057001) ("DATA" . 1057003) ("DEPTH_TEST_DISABLE" . 1095001) ("DEPTH_TEST_FUNCTION" . 1095681) ("DEPTH_WRITE_DISABLE" . 1095720) ("DOUBLE" . 1057005) ("HIDE" . 1057007) ("LABEL_NOGAPS" . 1057011) ("LABEL_OBJECTS" . 1057019) ("LABEL_OFFSETS" . 1057017) ("LABEL_POLYLINES" . 1057330) ("LABEL_USE_VERTEX_COLOR" . 1077987) ("LINESTYLE" . 1057029) ("PALETTE" . 1057044) ("POLYLINES" . 1057099) ("RESET_DATA" . 1093906) ("SHADING" . 1057051) ("SHARE_DATA" . 1057056) ("SYMBOL" . 1057058) ("THICK" . 1057063) ("USE_LABEL_COLOR" . 1057065) ("USE_LABEL_ORIENTATION" . 1057067) ("USE_TEXT_ALIGNMENTS" . 1057069) ("VERT_COLORS" . 1057073) ("XCOORD_CONV" . 1057075) ("YCOORD_CONV" . 1057081) ("ZCOORD_CONV" . 1077892)))
    ("GetCTM" fun "IDLgrPolyline" (system) "Result = Obj->[%s::]%s()" ("objects_gr134.html" ("DESTINATION" . 1013579) ("PATH" . 1013581) ("TOP" . 1013587)))
    ("Init" fun "IDLgrPolyline" (system) "Result = Obj->[%s::]%s([, X [, Y[, Z]]])" ("objects_gr136.html" ) ("objects_gr132.html" ("ALPHA_CHANNEL" . 1329463) ("CLIP_PLANES" . 1056996) ("COLOR" . 1057001) ("DATA" . 1057003) ("DEPTH_TEST_DISABLE" . 1095001) ("DEPTH_TEST_FUNCTION" . 1095681) ("DEPTH_WRITE_DISABLE" . 1095720) ("DOUBLE" . 1057005) ("HIDE" . 1057007) ("LABEL_NOGAPS" . 1057011) ("LABEL_OBJECTS" . 1057019) ("LABEL_OFFSETS" . 1057017) ("LABEL_POLYLINES" . 1057330) ("LABEL_USE_VERTEX_COLOR" . 1077987) ("LINESTYLE" . 1057029) ("PALETTE" . 1057044) ("POLYLINES" . 1057099) ("REGISTER_PROPERTIES" . 1057049) ("RESET_DATA" . 1093906) ("SHADING" . 1057051) ("SHARE_DATA" . 1057056) ("SYMBOL" . 1057058) ("THICK" . 1057063) ("USE_LABEL_COLOR" . 1057065) ("USE_LABEL_ORIENTATION" . 1057067) ("USE_TEXT_ALIGNMENTS" . 1057069) ("VERT_COLORS" . 1057073) ("XCOORD_CONV" . 1057075) ("YCOORD_CONV" . 1057081) ("ZCOORD_CONV" . 1077892)))
    ("Cleanup" pro "IDLgrPrinter" (system) "Obj->[%s::]%s" ("objects_gr140.html"))
    ("Draw" pro "IDLgrPrinter" (system) "Obj->[%s::]%s [, Picture]" ("objects_gr141.html" ("VECT_SORTING" . 1340440) ("VECT_TEXT_RENDER_METHOD" . 1340452) ("VECTOR" . 1013979)))
    ("GetProperty" pro "IDLgrPrinter" (system) "Obj->[%s::]%s" ("objects_gr144.html" ) ("objects_gr139.html" ("ALL" . 1057354) ("COLOR_MODEL" . 1057403) ("DIMENSIONS" . 1057476) ("GAMMA" . 1057474) ("GRAPHICS_TREE" . 1057413) ("LANDSCAPE" . 1057415) ("N_COLORS" . 1057418) ("N_COPIES" . 1057420) ("NAME" . 1344875) ("PALETTE" . 1057464) ("PRINT_QUALITY" . 1057428) ("QUALITY" . 1057435) ("RESOLUTION" . 1093938) ("UNITS" . 1057441)))
    ("NewDocument" pro "IDLgrPrinter" (system) "Obj->[%s::]%s" ("objects_gr147.html"))
    ("NewPage" pro "IDLgrPrinter" (system) "Obj->[%s::]%s" ("objects_gr148.html"))
    ("SetProperty" pro "IDLgrPrinter" (system) "Obj->[%s::]%s" ("objects_gr149.html" ) ("objects_gr139.html" ("GAMMA" . 1057474) ("GRAPHICS_TREE" . 1057413) ("LANDSCAPE" . 1057415) ("N_COPIES" . 1057420) ("PALETTE" . 1057464) ("PRINT_QUALITY" . 1057428) ("QUALITY" . 1057435) ("UNITS" . 1057441)))
    ("GetContiguousPixels" fun "IDLgrPrinter" (system) "Result = Obj->[%s::]%s()" ("objects_gr142.html"))
    ("GetFontnames" fun "IDLgrPrinter" (system) "Result = Obj->[%s::]%s( FamilyName)" ("objects_gr143.html" ("IDL_FONTS" . 1014147) ("STYLES" . 1014149)))
    ("GetTextDimensions" fun "IDLgrPrinter" (system) "Result = Obj->[%s::]%s( TextObj)" ("objects_gr145.html" ("DESCENT" . 1014231) ("PATH" . 1014233)))
    ("Init" fun "IDLgrPrinter" (system) "Result = Obj->[%s::]%s()" ("objects_gr146.html" ) ("objects_gr139.html" ("COLOR_MODEL" . 1057403) ("GAMMA" . 1057474) ("GRAPHICS_TREE" . 1057413) ("LANDSCAPE" . 1057415) ("N_COLORS" . 1057418) ("N_COPIES" . 1057420) ("PALETTE" . 1057464) ("PRINT_QUALITY" . 1057428) ("QUALITY" . 1057435) ("REGISTER_PROPERTIES" . 1057456) ("UNITS" . 1057441)))
    ("Cleanup" pro "IDLgrROI" (system) "Obj->[%s::]%s" ("objects_gr152.html"))
    ("GetProperty" pro "IDLgrROI" (system) "Obj->[%s::]%s" ("objects_gr153.html" ) ("objects_gr151.html" ("ALL" . 1057567) ("ALPHA_CHANNEL" . 1315614) ("CLIP_PLANES" . 1057587) ("COLOR" . 1057592) ("DEPTH_TEST_DISABLE" . 1095007) ("DEPTH_TEST_FUNCTION" . 1095803) ("DEPTH_WRITE_DISABLE" . 1095842) ("DOUBLE" . 1078228) ("HIDE" . 1078231) ("LINESTYLE" . 1057600) ("PALETTE" . 1057611) ("PARENT" . 1345141) ("STYLE" . 1093956) ("SYMBOL" . 1057621) ("THICK" . 1057626) ("XCOORD_CONV" . 1057630) ("XRANGE" . 1057656) ("YCOORD_CONV" . 1057636) ("YRANGE" . 1057668) ("ZCOORD_CONV" . 1057666) ("ZRANGE" . 1057574)))
    ("SetProperty" pro "IDLgrROI" (system) "Obj->[%s::]%s" ("objects_gr156.html" ) ("objects_gr151.html" ("ALPHA_CHANNEL" . 1315614) ("CLIP_PLANES" . 1057587) ("COLOR" . 1057592) ("DEPTH_TEST_DISABLE" . 1095007) ("DEPTH_TEST_FUNCTION" . 1095803) ("DEPTH_WRITE_DISABLE" . 1095842) ("DOUBLE" . 1078228) ("HIDE" . 1078231) ("LINESTYLE" . 1057600) ("PALETTE" . 1057611) ("STYLE" . 1093956) ("SYMBOL" . 1057621) ("THICK" . 1057626) ("XCOORD_CONV" . 1057630) ("YCOORD_CONV" . 1057636) ("ZCOORD_CONV" . 1057666)))
    ("Init" fun "IDLgrROI" (system) "Result = Obj->[%s::]%s([, X[, Y[, Z]]])" ("objects_gr154.html" ) ("objects_gr151.html" ("ALPHA_CHANNEL" . 1315614) ("CLIP_PLANES" . 1057587) ("COLOR" . 1057592) ("DEPTH_TEST_DISABLE" . 1095007) ("DEPTH_TEST_FUNCTION" . 1095803) ("DEPTH_WRITE_DISABLE" . 1095842) ("DOUBLE" . 1078228) ("HIDE" . 1078231) ("LINESTYLE" . 1057600) ("PALETTE" . 1057611) ("REGISTER_PROPERTIES" . 1057616) ("STYLE" . 1093956) ("SYMBOL" . 1057621) ("THICK" . 1057626) ("XCOORD_CONV" . 1057630) ("YCOORD_CONV" . 1057636) ("ZCOORD_CONV" . 1057666)))
    ("PickVertex" fun "IDLgrROI" (system) "Result = Obj->[%s::]%s( Dest, View, Point)" ("objects_gr155.html" ("PATH" . 1014753)))
    ("Add" pro "IDLgrROIGroup" (system) "Obj->[%s::]%s, ROI" ("objects_gr159.html"))
    ("Cleanup" pro "IDLgrROIGroup" (system) "Obj->[%s::]%s" ("objects_gr160.html"))
    ("GetProperty" pro "IDLgrROIGroup" (system) "Obj->[%s::]%s" ("objects_gr161.html" ) ("objects_gr158.html" ("ALL" . 1057772) ("CLIP_PLANES" . 1057798) ("COLOR" . 1057803) ("DEPTH_TEST_DISABLE" . 1095013) ("DEPTH_TEST_FUNCTION" . 1095918) ("DEPTH_WRITE_DISABLE" . 1095957) ("HIDE" . 1057805) ("PARENT" . 1057863) ("XCOORD_CONV" . 1057861) ("XRANGE" . 1057853) ("YCOORD_CONV" . 1057851) ("YRANGE" . 1080305) ("ZCOORD_CONV" . 1057839) ("ZRANGE" . 1057781)))
    ("SetProperty" pro "IDLgrROIGroup" (system) "Obj->[%s::]%s" ("objects_gr164.html" ) ("objects_gr158.html" ("CLIP_PLANES" . 1057798) ("COLOR" . 1057803) ("DEPTH_TEST_DISABLE" . 1095013) ("DEPTH_TEST_FUNCTION" . 1095918) ("DEPTH_WRITE_DISABLE" . 1095957) ("HIDE" . 1057805) ("XCOORD_CONV" . 1057861) ("YCOORD_CONV" . 1057851) ("ZCOORD_CONV" . 1057839)))
    ("Init" fun "IDLgrROIGroup" (system) "Result = Obj->[%s::]%s()" ("objects_gr162.html" ) ("objects_gr158.html" ("CLIP_PLANES" . 1057798) ("COLOR" . 1057803) ("DEPTH_TEST_DISABLE" . 1095013) ("DEPTH_TEST_FUNCTION" . 1095918) ("DEPTH_WRITE_DISABLE" . 1095957) ("HIDE" . 1057805) ("XCOORD_CONV" . 1057861) ("YCOORD_CONV" . 1057851) ("ZCOORD_CONV" . 1057839)))
    ("PickRegion" fun "IDLgrROIGroup" (system) "Result = Obj->[%s::]%s( Dest, View, Point)" ("objects_gr163.html" ("PATH" . 1015096)))
    ("Add" pro "IDLgrScene" (system) "Obj->[%s::]%s, View" ("objects_gr167.html" ("POSITION" . 1015243)))
    ("Cleanup" pro "IDLgrScene" (system) "Obj->[%s::]%s" ("objects_gr168.html"))
    ("GetProperty" pro "IDLgrScene" (system) "Obj->[%s::]%s" ("objects_gr170.html" ) ("objects_gr166.html" ("ALL" . 1057953) ("COLOR" . 1080480) ("TRANSPARENT" . 1093982)))
    ("SetProperty" pro "IDLgrScene" (system) "Obj->[%s::]%s" ("objects_gr172.html" ) ("objects_gr166.html" ("COLOR" . 1080480) ("TRANSPARENT" . 1093982)))
    ("GetByName" fun "IDLgrScene" (system) "Result = Obj->[%s::]%s(Name)" ("objects_gr169.html"))
    ("Init" fun "IDLgrScene" (system) "Result = Obj->[%s::]%s()" ("objects_gr171.html" ) ("objects_gr166.html" ("COLOR" . 1080480) ("HIDE" . 1057961) ("REGISTER_PROPERTIES" . 1057969)))
    ("Cleanup" pro "IDLgrSurface" (system) "Obj->[%s::]%s" ("objects_gr175.html"))
    ("GetProperty" pro "IDLgrSurface" (system) "Obj->[%s::]%s" ("objects_gr177.html" ) ("objects_gr174.html" ("ALL" . 1058014) ("ALPHA_CHANNEL" . 1314657) ("AMBIENT" . 1310692) ("BOTTOM" . 1058035) ("CLIP_PLANES" . 1058037) ("COLOR" . 1058042) ("DATA" . 1339889) ("DEPTH_OFFSET" . 1058050) ("DEPTH_TEST_DISABLE" . 1095019) ("DEPTH_TEST_FUNCTION" . 1096040) ("DEPTH_WRITE_DISABLE" . 1096079) ("DIFFUSE" . 1310743) ("DOUBLE" . 1058056) ("EMISSION" . 1310780) ("EXTENDED_LEGO" . 1058059) ("HIDDEN_LINES" . 1058061) ("HIDE" . 1058063) ("LINESTYLE" . 1058067) ("MAX_VALUE" . 1058080) ("MIN_VALUE" . 1058082) ("PALETTE" . 1058086) ("PARENT" . 1058283) ("SHADE_RANGE" . 1058090) ("SHADING" . 1058092) ("SHININESS" . 1310817) ("SHOW_SKIRT" . 1058099) ("SKIRT" . 1058101) ("SPECULAR" . 1310884) ("STYLE" . 1058103) ("TEXTURE_COORD" . 1604848) ("TEXTURE_HIGHRES" . 1058120) ("TEXTURE_INTERP" . 1058123) ("TEXTURE_MAP" . 1058125) ("THICK" . 1058136) ("USE_TRIANGLES" . 1058140) ("VERT_COLORS" . 1058142) ("XCOORD_CONV" . 1058145) ("XRANGE" . 1058297) ("YCOORD_CONV" . 1058295) ("YRANGE" . 1058309) ("ZCOORD_CONV" . 1058307) ("ZERO_OPACITY_SKIP" . 1058163) ("ZRANGE" . 1082521)))
    ("SetProperty" pro "IDLgrSurface" (system) "Obj->[%s::]%s" ("objects_gr179.html" ) ("objects_gr174.html" ("ALPHA_CHANNEL" . 1314657) ("AMBIENT" . 1310692) ("BOTTOM" . 1058035) ("CLIP_PLANES" . 1058037) ("COLOR" . 1058042) ("DATAX" . 1339826) ("DATAY" . 1058046) ("DATAZ" . 1058048) ("DEPTH_OFFSET" . 1058050) ("DEPTH_TEST_DISABLE" . 1095019) ("DEPTH_TEST_FUNCTION" . 1096040) ("DEPTH_WRITE_DISABLE" . 1096079) ("DIFFUSE" . 1310743) ("DOUBLE" . 1058056) ("EMISSION" . 1310780) ("EXTENDED_LEGO" . 1058059) ("HIDDEN_LINES" . 1058061) ("HIDE" . 1058063) ("LINESTYLE" . 1058067) ("MAX_VALUE" . 1058080) ("MIN_VALUE" . 1058082) ("PALETTE" . 1058086) ("RESET_DATA" . 1094044) ("SHADE_RANGE" . 1058090) ("SHADING" . 1058092) ("SHARE_DATA" . 1082385) ("SHININESS" . 1310817) ("SHOW_SKIRT" . 1058099) ("SKIRT" . 1058101) ("SPECULAR" . 1310884) ("STYLE" . 1058103) ("TEXTURE_COORD" . 1604848) ("TEXTURE_HIGHRES" . 1058120) ("TEXTURE_INTERP" . 1058123) ("TEXTURE_MAP" . 1058125) ("THICK" . 1058136) ("USE_TRIANGLES" . 1058140) ("VERT_COLORS" . 1058142) ("XCOORD_CONV" . 1058145) ("YCOORD_CONV" . 1058295) ("ZCOORD_CONV" . 1058307) ("ZERO_OPACITY_SKIP" . 1058163)))
    ("GetCTM" fun "IDLgrSurface" (system) "Result = Obj->[%s::]%s()" ("objects_gr176.html" ("DESTINATION" . 1015591) ("PATH" . 1015593) ("TOP" . 1015599)))
    ("Init" fun "IDLgrSurface" (system) "Result = Obj->[%s::]%s([, Z [, X, Y]])" ("objects_gr178.html" ) ("objects_gr174.html" ("ALPHA_CHANNEL" . 1314657) ("AMBIENT" . 1310692) ("BOTTOM" . 1058035) ("CLIP_PLANES" . 1058037) ("COLOR" . 1058042) ("DATAX" . 1339826) ("DATAY" . 1058046) ("DATAZ" . 1058048) ("DEPTH_OFFSET" . 1058050) ("DEPTH_TEST_DISABLE" . 1095019) ("DEPTH_TEST_FUNCTION" . 1096040) ("DEPTH_WRITE_DISABLE" . 1096079) ("DIFFUSE" . 1310743) ("DOUBLE" . 1058056) ("EMISSION" . 1310780) ("EXTENDED_LEGO" . 1058059) ("HIDDEN_LINES" . 1058061) ("HIDE" . 1058063) ("LINESTYLE" . 1058067) ("MAX_VALUE" . 1058080) ("MIN_VALUE" . 1058082) ("PALETTE" . 1058086) ("REGISTER_PROPERTIES" . 1094041) ("RESET_DATA" . 1094044) ("SHADE_RANGE" . 1058090) ("SHADING" . 1058092) ("SHARE_DATA" . 1082385) ("SHININESS" . 1310817) ("SHOW_SKIRT" . 1058099) ("SKIRT" . 1058101) ("SPECULAR" . 1310884) ("STYLE" . 1058103) ("TEXTURE_COORD" . 1604848) ("TEXTURE_HIGHRES" . 1058120) ("TEXTURE_INTERP" . 1058123) ("TEXTURE_MAP" . 1058125) ("THICK" . 1058136) ("USE_TRIANGLES" . 1058140) ("VERT_COLORS" . 1058142) ("XCOORD_CONV" . 1058145) ("YCOORD_CONV" . 1058295) ("ZCOORD_CONV" . 1058307) ("ZERO_OPACITY_SKIP" . 1058163)))
    ("Cleanup" pro "IDLgrSymbol" (system) "Obj->[%s::]%s" ("objects_gr182.html"))
    ("GetProperty" pro "IDLgrSymbol" (system) "Obj->[%s::]%s" ("objects_gr183.html" ) ("objects_gr181.html" ("ALL" . 1058799) ("ALPHA_CHANNEL" . 1315142) ("COLOR" . 1058811) ("DATA" . 1058813) ("SIZE" . 1058817) ("THICK" . 1058823)))
    ("SetProperty" pro "IDLgrSymbol" (system) "Obj->[%s::]%s" ("objects_gr185.html" ) ("objects_gr181.html" ("ALPHA_CHANNEL" . 1315142) ("COLOR" . 1058811) ("DATA" . 1058813) ("SIZE" . 1058817) ("THICK" . 1058823)))
    ("Init" fun "IDLgrSymbol" (system) "Result = Obj->[%s::]%s([, Data])" ("objects_gr184.html" ) ("objects_gr181.html" ("ALPHA_CHANNEL" . 1315142) ("COLOR" . 1058811) ("DATA" . 1058813) ("SIZE" . 1058817) ("THICK" . 1058823)))
    ("AddPolygon" pro "IDLgrTessellator" (system) "Obj->[%s::]%s, X [, Y[, Z]]" ("objects_gr188.html" ("AUXDATA" . 1016227) ("INTERIOR" . 1016232) ("POLYGON" . 1308631)))
    ("Cleanup" pro "IDLgrTessellator" (system) "Obj->[%s::]%s" ("objects_gr189.html"))
    ("Reset" pro "IDLgrTessellator" (system) "Obj->[%s::]%s" ("objects_gr191.html"))
    ("Init" fun "IDLgrTessellator" (system) "Result = Obj->[%s::]%s()" ("objects_gr190.html" ))
    ("Tessellate" fun "IDLgrTessellator" (system) "Result = Obj->[%s::]%s( Vertices, Poly)" ("objects_gr192.html" ("AUXDATA" . 1016374) ("QUIET" . 1016376)))
    ("Cleanup" pro "IDLgrText" (system) "Obj->[%s::]%s" ("objects_gr195.html"))
    ("GetProperty" pro "IDLgrText" (system) "Obj->[%s::]%s" ("objects_gr197.html" ) ("objects_gr194.html" ("ALIGNMENT" . 1058986) ("ALL" . 1058984) ("ALPHA_CHANNEL" . 1096721) ("BASELINE" . 1096723) ("CHAR_DIMENSIONS" . 1058905) ("CLIP_PLANES" . 1058910) ("COLOR" . 1058915) ("DEPTH_TEST_DISABLE" . 1095025) ("DEPTH_TEST_FUNCTION" . 1096162) ("DEPTH_WRITE_DISABLE" . 1096201) ("ENABLE_FORMATTING" . 1058917) ("FILL_BACKGROUND" . 1058922) ("FILL_COLOR" . 1090549) ("FONT" . 1090557) ("HIDE" . 1058929) ("KERNING" . 1058933) ("LOCATIONS" . 1090561) ("ONGLASS" . 1058937) ("PALETTE" . 1058939) ("PARENT" . 1058996) ("RECOMPUTE_DIMENSIONS" . 1058994) ("RENDER_METHOD" . 1096891) ("STRINGS" . 1096894) ("UPDIR" . 1058950) ("VERTICAL_ALIGNMENT" . 1058954) ("XCOORD_CONV" . 1058956) ("XRANGE" . 1059010) ("YCOORD_CONV" . 1059008) ("YRANGE" . 1059022) ("ZCOORD_CONV" . 1058968) ("ZRANGE" . 1058890)))
    ("SetProperty" pro "IDLgrText" (system) "Obj->[%s::]%s" ("objects_gr199.html" ) ("objects_gr194.html" ("ALIGNMENT" . 1058986) ("ALPHA_CHANNEL" . 1096721) ("BASELINE" . 1096723) ("CHAR_DIMENSIONS" . 1058905) ("CLIP_PLANES" . 1058910) ("COLOR" . 1058915) ("DEPTH_TEST_DISABLE" . 1095025) ("DEPTH_TEST_FUNCTION" . 1096162) ("DEPTH_WRITE_DISABLE" . 1096201) ("ENABLE_FORMATTING" . 1058917) ("FILL_BACKGROUND" . 1058922) ("FILL_COLOR" . 1090549) ("FONT" . 1090557) ("HIDE" . 1058929) ("KERNING" . 1058933) ("LOCATIONS" . 1090561) ("ONGLASS" . 1058937) ("PALETTE" . 1058939) ("RECOMPUTE_DIMENSIONS" . 1058994) ("RENDER_METHOD" . 1096891) ("STRINGS" . 1096894) ("UPDIR" . 1058950) ("VERTICAL_ALIGNMENT" . 1058954) ("XCOORD_CONV" . 1058956) ("YCOORD_CONV" . 1059008) ("ZCOORD_CONV" . 1058968)))
    ("GetCTM" fun "IDLgrText" (system) "Result = Obj->[%s::]%s()" ("objects_gr196.html" ("DESTINATION" . 1016508) ("PATH" . 1016510) ("TOP" . 1016516)))
    ("Init" fun "IDLgrText" (system) "Result = Obj->[%s::]%s([, String or vector of strings])" ("objects_gr198.html" ) ("objects_gr194.html" ("ALIGNMENT" . 1058986) ("ALPHA_CHANNEL" . 1096721) ("BASELINE" . 1096723) ("CHAR_DIMENSIONS" . 1058905) ("CLIP_PLANES" . 1058910) ("COLOR" . 1058915) ("DEPTH_TEST_DISABLE" . 1095025) ("DEPTH_TEST_FUNCTION" . 1096162) ("DEPTH_WRITE_DISABLE" . 1096201) ("ENABLE_FORMATTING" . 1058917) ("FILL_BACKGROUND" . 1058922) ("FILL_COLOR" . 1090549) ("FONT" . 1090557) ("HIDE" . 1058929) ("KERNING" . 1058933) ("LOCATIONS" . 1090561) ("ONGLASS" . 1058937) ("PALETTE" . 1058939) ("RECOMPUTE_DIMENSIONS" . 1058994) ("REGISTER_PROPERTIES" . 1058946) ("RENDER_METHOD" . 1096891) ("STRINGS" . 1096894) ("UPDIR" . 1058950) ("VERTICAL_ALIGNMENT" . 1058954) ("XCOORD_CONV" . 1058956) ("YCOORD_CONV" . 1059008) ("ZCOORD_CONV" . 1058968)))
    ("Add" pro "IDLgrView" (system) "Obj->[%s::]%s, Model" ("objects_gr202.html" ("POSITION" . 1016823)))
    ("Cleanup" pro "IDLgrView" (system) "Obj->[%s::]%s" ("objects_gr203.html"))
    ("GetProperty" pro "IDLgrView" (system) "Obj->[%s::]%s" ("objects_gr205.html" ) ("objects_gr201.html" ("ALL" . 1059162) ("COLOR" . 1059182) ("DEPTH_CUE" . 1059184) ("DIMENSIONS" . 1059192) ("DOUBLE" . 1059194) ("EYE" . 1059197) ("HIDE" . 1059199) ("LOCATION" . 1090641) ("PARENT" . 1092817) ("PROJECTION" . 1059231) ("TRANSPARENT" . 1094108) ("UNITS" . 1059207) ("VIEWPLANE_RECT" . 1059216) ("ZCLIP" . 1059219)))
    ("SetProperty" pro "IDLgrView" (system) "Obj->[%s::]%s" ("objects_gr207.html" ) ("objects_gr201.html" ("COLOR" . 1059182) ("DEPTH_CUE" . 1059184) ("DIMENSIONS" . 1059192) ("DOUBLE" . 1059194) ("EYE" . 1059197) ("HIDE" . 1059199) ("LOCATION" . 1090641) ("PROJECTION" . 1059231) ("TRANSPARENT" . 1094108) ("UNITS" . 1059207) ("VIEWPLANE_RECT" . 1059216) ("ZCLIP" . 1059219)))
    ("GetByName" fun "IDLgrView" (system) "Result = Obj->[%s::]%s(Name)" ("objects_gr204.html"))
    ("Init" fun "IDLgrView" (system) "Result = Obj->[%s::]%s()" ("objects_gr206.html" ) ("objects_gr201.html" ("COLOR" . 1059182) ("DEPTH_CUE" . 1059184) ("DIMENSIONS" . 1059192) ("DOUBLE" . 1059194) ("EYE" . 1059197) ("HIDE" . 1059199) ("LOCATION" . 1090641) ("PROJECTION" . 1059231) ("REGISTER_PROPERTIES" . 1059205) ("TRANSPARENT" . 1094108) ("UNITS" . 1059207) ("VIEWPLANE_RECT" . 1059216) ("ZCLIP" . 1059219)))
    ("Add" pro "IDLgrViewgroup" (system) "Obj->[%s::]%s, Object" ("objects_gr210.html" ("POSITION" . 1017170)))
    ("Cleanup" pro "IDLgrViewgroup" (system) "Obj->[%s::]%s" ("objects_gr211.html"))
    ("GetProperty" pro "IDLgrViewgroup" (system) "Obj->[%s::]%s" ("objects_gr213.html" ) ("objects_gr209.html" ("ALL" . 1077311) ("HIDE" . 1059327) ("PARENT" . 1084394)))
    ("SetProperty" pro "IDLgrViewgroup" (system) "Obj->[%s::]%s" ("objects_gr215.html" ) ("objects_gr209.html" ("HIDE" . 1059327)))
    ("GetByName" fun "IDLgrViewgroup" (system) "Result = Obj->[%s::]%s(Name)" ("objects_gr212.html"))
    ("Init" fun "IDLgrViewgroup" (system) "Result = Obj->[%s::]%s()" ("objects_gr214.html" ) ("objects_gr209.html" ("HIDE" . 1059327) ("REGISTER_PROPERTIES" . 1059341)))
    ("Cleanup" pro "IDLgrVolume" (system) "Obj->[%s::]%s" ("objects_gr218.html"))
    ("ComputeBounds" pro "IDLgrVolume" (system) "Obj->[%s::]%s" ("objects_gr219.html" ("OPACITY" . 1017518) ("RESET" . 1017520) ("VOLUMES" . 1017522)))
    ("GetProperty" pro "IDLgrVolume" (system) "Obj->[%s::]%s" ("objects_gr221.html" ) ("objects_gr217.html" ("ALL" . 1059382) ("ALPHA_CHANNEL" . 1315212) ("AMBIENT" . 1059403) ("BOUNDS" . 1059406) ("CLIP_PLANES" . 1059408) ("COMPOSITE_FUNCTION" . 1092822) ("DATA0" . 1059427) ("DATA1" . 1059429) ("DATA2" . 1059431) ("DATA3" . 1059433) ("DEPTH_CUE" . 1059436) ("DEPTH_TEST_DISABLE" . 1095038) ("DEPTH_TEST_FUNCTION" . 1096277) ("DEPTH_WRITE_DISABLE" . 1096316) ("HIDE" . 1059445) ("HINTS" . 1059449) ("INTERPOLATE" . 1059455) ("LIGHTING_MODEL" . 1059457) ("NO_COPY" . 1059462) ("OPACITY_TABLE0" . 1086135) ("OPACITY_TABLE1" . 1059466) ("PARENT" . 1088485) ("RENDER_STEP" . 1096662) ("RGB_TABLE0" . 1088582) ("RGB_TABLE1" . 1059472) ("TWO_SIDED" . 1059474) ("VALID_DATA" . 1059634) ("VOLUME_SELECT" . 1059632) ("XCOORD_CONV" . 1059489) ("XRANGE" . 1059648) ("YCOORD_CONV" . 1059495) ("YRANGE" . 1059660) ("ZBUFFER" . 1059501) ("ZCOORD_CONV" . 1059503) ("ZERO_OPACITY_SKIP" . 1059509) ("ZRANGE" . 1059393)))
    ("SetProperty" pro "IDLgrVolume" (system) "Obj->[%s::]%s" ("objects_gr224.html" ) ("objects_gr217.html" ("ALPHA_CHANNEL" . 1315212) ("AMBIENT" . 1059403) ("BOUNDS" . 1059406) ("CLIP_PLANES" . 1059408) ("COMPOSITE_FUNCTION" . 1092822) ("DATA0" . 1059427) ("DATA1" . 1059429) ("DATA2" . 1059431) ("DATA3" . 1059433) ("DEPTH_CUE" . 1059436) ("DEPTH_TEST_DISABLE" . 1095038) ("DEPTH_TEST_FUNCTION" . 1096277) ("DEPTH_WRITE_DISABLE" . 1096316) ("HIDE" . 1059445) ("HINTS" . 1059449) ("INTERPOLATE" . 1059455) ("LIGHTING_MODEL" . 1059457) ("NO_COPY" . 1059462) ("OPACITY_TABLE0" . 1086135) ("OPACITY_TABLE1" . 1059466) ("RENDER_STEP" . 1096662) ("RGB_TABLE0" . 1088582) ("RGB_TABLE1" . 1059472) ("TWO_SIDED" . 1059474) ("VOLUME_SELECT" . 1059632) ("XCOORD_CONV" . 1059489) ("YCOORD_CONV" . 1059495) ("ZBUFFER" . 1059501) ("ZCOORD_CONV" . 1059503) ("ZERO_OPACITY_SKIP" . 1059509)))
    ("GetCTM" fun "IDLgrVolume" (system) "Result = Obj->[%s::]%s()" ("objects_gr220.html" ("DESTINATION" . 1017555) ("PATH" . 1017557) ("TOP" . 1017563)))
    ("Init" fun "IDLgrVolume" (system) "Result = Obj->[%s::]%s([, vol0 [, vol1 [, vol2 [, vol3]]]])" ("objects_gr222.html" ) ("objects_gr217.html" ("ALPHA_CHANNEL" . 1315212) ("AMBIENT" . 1059403) ("BOUNDS" . 1059406) ("CLIP_PLANES" . 1059408) ("COMPOSITE_FUNCTION" . 1092822) ("DATA0" . 1059427) ("DATA1" . 1059429) ("DATA2" . 1059431) ("DATA3" . 1059433) ("DEPTH_CUE" . 1059436) ("DEPTH_TEST_DISABLE" . 1095038) ("DEPTH_TEST_FUNCTION" . 1096277) ("DEPTH_WRITE_DISABLE" . 1096316) ("HIDE" . 1059445) ("HINTS" . 1059449) ("INTERPOLATE" . 1059455) ("LIGHTING_MODEL" . 1059457) ("NO_COPY" . 1059462) ("OPACITY_TABLE0" . 1086135) ("OPACITY_TABLE1" . 1059466) ("REGISTER_PROPERTIES" . 1059616) ("RENDER_STEP" . 1096662) ("RGB_TABLE0" . 1088582) ("RGB_TABLE1" . 1059472) ("TWO_SIDED" . 1059474) ("VOLUME_SELECT" . 1059632) ("XCOORD_CONV" . 1059489) ("YCOORD_CONV" . 1059495) ("ZBUFFER" . 1059501) ("ZCOORD_CONV" . 1059503) ("ZERO_OPACITY_SKIP" . 1059509)))
    ("PickVoxel" fun "IDLgrVolume" (system) "Result = Obj->[%s::]%s ( Win, View, Point)" ("objects_gr223.html" ("PATH" . 1017818)))
    ("Cleanup" pro "IDLgrVRML" (system) "Obj->[%s::]%s" ("objects_gr227.html"))
    ("Draw" pro "IDLgrVRML" (system) "Obj->[%s::]%s [, Picture]" ("objects_gr228.html"))
    ("GetDeviceInfo" pro "IDLgrVRML" (system) "Obj->[%s::]%s" ("objects_gr229.html" ("ALL" . 1018053) ("MAX_NUM_CLIP_PLANES" . 1018055) ("MAX_TEXTURE_DIMENSIONS" . 1018057) ("MAX_VIEWPORT_DIMENSIONS" . 1018059) ("NAME" . 1018061) ("NUM_CPUS" . 1018063) ("VENDOR" . 1018066) ("VERSION" . 1018068)))
    ("GetProperty" pro "IDLgrVRML" (system) "Obj->[%s::]%s" ("objects_gr231.html" ) ("objects_gr226.html" ("ALL" . 1059804) ("COLOR_MODEL" . 1059817) ("DIMENSIONS" . 1059821) ("FILENAME" . 1059824) ("GRAPHICS_TREE" . 1059826) ("N_COLORS" . 1059828) ("PALETTE" . 1059830) ("QUALITY" . 1059832) ("RESOLUTION" . 1094159) ("SCREEN_DIMENSIONS" . 1059862) ("UNITS" . 1059860)))
    ("SetProperty" pro "IDLgrVRML" (system) "Obj->[%s::]%s" ("objects_gr234.html" ) ("objects_gr226.html" ("DIMENSIONS" . 1059821) ("FILENAME" . 1059824) ("GRAPHICS_TREE" . 1059826) ("PALETTE" . 1059830) ("QUALITY" . 1059832) ("RESOLUTION" . 1094159) ("UNITS" . 1059860)))
    ("GetFontnames" fun "IDLgrVRML" (system) "Result = Obj->[%s::]%s( FamilyName)" ("objects_gr230.html" ("IDL_FONTS" . 1018109) ("STYLES" . 1018111)))
    ("GetTextDimensions" fun "IDLgrVRML" (system) "Result = Obj->[%s::]%s( TextObj)" ("objects_gr232.html" ("DESCENT" . 1018185) ("PATH" . 1018187)))
    ("Init" fun "IDLgrVRML" (system) "Result = Obj->[%s::]%s()" ("objects_gr233.html" ) ("objects_gr226.html" ("COLOR_MODEL" . 1059817) ("DIMENSIONS" . 1059821) ("FILENAME" . 1059824) ("GRAPHICS_TREE" . 1059826) ("N_COLORS" . 1059828) ("PALETTE" . 1059830) ("QUALITY" . 1059832) ("REGISTER_PROPERTIES" . 1059837) ("RESOLUTION" . 1094159) ("UNITS" . 1059860) ("WORLDINFO" . 1059848) ("WORLDTITLE" . 1059850)))
    ("Cleanup" pro "IDLgrWindow" (system) "Obj->[%s::]%s" ("objects_gr237.html"))
    ("Draw" pro "IDLgrWindow" (system) "Obj->[%s::]%s [, Picture]" ("objects_gr238.html" ("CREATE_INSTANCE" . 1018509) ("DRAW_INSTANCE" . 1018511)))
    ("Erase" pro "IDLgrWindow" (system) "Obj->[%s::]%s" ("objects_gr239.html" ("COLOR" . 1018544)))
    ("GetDeviceInfo" pro "IDLgrWindow" (system) "Obj->[%s::]%s" ("objects_gr241.html" ("ALL" . 1018622) ("MAX_NUM_CLIP_PLANES" . 1018624) ("MAX_TEXTURE_DIMENSIONS" . 1018626) ("MAX_VIEWPORT_DIMENSIONS" . 1018628) ("NAME" . 1018630) ("NUM_CPUS" . 1018632) ("VENDOR" . 1018635) ("VERSION" . 1018637)))
    ("GetProperty" pro "IDLgrWindow" (system) "Obj->[%s::]%s" ("objects_gr244.html" ) ("objects_gr236.html" ("ALL" . 1059951) ("COLOR_MODEL" . 1059974) ("CURRENT_ZOOM" . 1249228) ("DIMENSIONS" . 1249231) ("DISPLAY_NAME (X Only)" . 1059985) ("GRAPHICS_TREE" . 1059987) ("IMAGE_DATA" . 1060084) ("LOCATION" . 1060082) ("MINIMUM_VIRTUAL_DIMENSIONS" . 1343479) ("N_COLORS" . 1059992) ("PALETTE" . 1059998) ("QUALITY" . 1060003) ("RENDERER" . 1094184) ("RESOLUTION" . 1060060) ("RETAIN" . 1060058) ("SCREEN_DIMENSIONS" . 1060073) ("TITLE" . 1060071) ("UNITS" . 1060033) ("VIRTUAL_DIMENSIONS" . 1060050) ("VISIBLE_LOCATION" . 1097046) ("ZBUFFER_DATA" . 1091007) ("ZOOM_BASE" . 1342797) ("ZOOM_NSTEP" . 1342953)))
    ("Iconify" pro "IDLgrWindow" (system) "Obj->[%s::]%s, IconFlag" ("objects_gr246.html"))
    ("SetCurrentCursor" pro "IDLgrWindow" (system) "Obj->[%s::]%s [, CursorName]" ("objects_gr251.html" ("HOTSPOT" . 1019148) ("IMAGE" . 1019144) ("MASK" . 1019146) ("STANDARD" . 1019150)))
    ("SetCurrentZoom" pro "IDLgrWindow" (system) "Obj-> [%s::]%s, ZoomFactor" ("objects_gr252.html" ("RESET" . 1360383)))
    ("SetProperty" pro "IDLgrWindow" (system) "Obj->[%s::]%s" ("objects_gr253.html" ) ("objects_gr236.html" ("DIMENSIONS" . 1249231) ("DISPLAY_NAME (X Only)" . 1059985) ("GRAPHICS_TREE" . 1059987) ("LOCATION" . 1060082) ("MINIMUM_VIRTUAL_DIMENSIONS" . 1343479) ("PALETTE" . 1059998) ("QUALITY" . 1060003) ("TITLE" . 1060071) ("UNITS" . 1060033) ("VIRTUAL_DIMENSIONS" . 1060050) ("VISIBLE_LOCATION" . 1097046) ("ZOOM_BASE" . 1342797)))
    ("Show" pro "IDLgrWindow" (system) "Obj->[%s::]%s, Position" ("objects_gr254.html"))
    ("ZoomIn" pro "IDLgrWindow" (system) "Obj->[%s::]%s" ("objects_gr255.html"))
    ("ZoomOut" pro "IDLgrWindow" (system) "Obj->[%s::]%s" ("objects_gr256.html"))
    ("GetContiguousPixels" fun "IDLgrWindow" (system) "Result = Obj->[%s::]%s()" ("objects_gr240.html"))
    ("GetDimensions" fun "IDLgrWindow" (system) "Result = Obj -> [%s::]%s ()" ("objects_gr242.html" ("MINIMUM_VIRTUAL_DIMENSIONS" . 1360348) ("ORIGINAL_VIRTUAL_DIMENSIONS" . 1360355) ("VIRTUAL_DIMENSIONS" . 1360358) ("VISIBLE_LOCATION" . 1360361)))
    ("GetFontnames" fun "IDLgrWindow" (system) "Result = Obj->[%s::]%s(FamilyName)" ("objects_gr243.html" ("IDL_FONTS" . 1018678) ("STYLES" . 1018680)))
    ("GetTextDimensions" fun "IDLgrWindow" (system) "Result = Obj->[%s::]%s( TextObj)" ("objects_gr245.html" ("DESCENT" . 1018765) ("PATH" . 1018767)))
    ("Init" fun "IDLgrWindow" (system) "Result = Obj->[%s::]%s()" ("objects_gr247.html" ) ("objects_gr236.html" ("COLOR_MODEL" . 1059974) ("DIMENSIONS" . 1249231) ("GRAPHICS_TREE" . 1059987) ("LOCATION" . 1060082) ("MINIMUM_VIRTUAL_DIMENSIONS" . 1343479) ("N_COLORS" . 1059992) ("PALETTE" . 1059998) ("QUALITY" . 1060003) ("REGISTER_PROPERTIES" . 1060008) ("RENDERER" . 1094184) ("RETAIN" . 1060058) ("TITLE" . 1060071) ("UNITS" . 1060033) ("VIRTUAL_DIMENSIONS" . 1060050) ("VISIBLE_LOCATION" . 1097046) ("ZOOM_BASE" . 1342797)))
    ("PickData" fun "IDLgrWindow" (system) "Result = Obj->[%s::]%s( View, Object, Location, XYZLocation)" ("objects_gr248.html" ("DIMENSIONS" . 1018957) ("PATH" . 1018961) ("PICK_STATUS" . 1018967)))
    ("Read" fun "IDLgrWindow" (system) "Result = Obj->[%s::]%s()" ("objects_gr249.html"))
    ("Select" fun "IDLgrWindow" (system) "Result = Obj->[%s::]%s( Picture, XY)" ("objects_gr250.html" ("DIMENSIONS" . 1019069) ("ORDER" . 1019073) ("SUB_SELECTION" . 1343670) ("UNITS" . 1019076)))
    ("Cleanup" pro "IDLitCommand" (system) "Obj->[%s::]%s" ("objects_it6.html"))
    ("GetProperty" pro "IDLitCommand" (system) "Obj->[%s::]%s" ("objects_it8.html" ) ("objects_it4.html" ("OPERATION_IDENTIFIER" . 1042072) ("TARGET_IDENTIFIER" . 1042044)))
    ("SetProperty" pro "IDLitCommand" (system) "Obj->[%s::]%s" ("objects_it11.html" ) ("objects_it4.html" ("OPERATION_IDENTIFIER" . 1042072) ("TARGET_IDENTIFIER" . 1042044)))
    ("AddItem" fun "IDLitCommand" (system) "Result = Obj->[%s::]%s(StrItem, Item)" ("objects_it5.html" ("OVERWRITE" . 1042134)))
    ("GetItem" fun "IDLitCommand" (system) "Result = Obj->[%s::]%s(StrItem, Item)" ("objects_it7.html"))
    ("GetSize" fun "IDLitCommand" (system) "Result = Obj->[%s::]%s()" ("objects_it9.html" ("KILOBYTES" . 1042275)))
    ("Init" fun "IDLitCommand" (system) "Result = Obj->[%s::]%s()" ("objects_it10.html" ) ("objects_it4.html" ("OPERATION_IDENTIFIER" . 1042072) ("TARGET_IDENTIFIER" . 1042044)))
    ("Cleanup" pro "IDLitCommandSet" (system) "Obj->[%s::]%s" ("objects_it14.html"))
    ("Init" fun "IDLitCommandSet" (system) "Result = Obj->[%s::]%s()" ("objects_it16.html" ))
    ("Cleanup" pro "IDLitComponent" (system) "Obj->[%s::]%s" ("objects_it19.html"))
    ("GetProperty" pro "IDLitComponent" (system) "Obj->[%s::]%s" ("objects_it22.html" ) ("objects_it18.html" ("COMPONENT_VERSION" . 1068963) ("DESCRIPTION" . 1286379) ("HELP" . 1069022) ("ICON" . 1281308) ("IDENTIFIER" . 1069050) ("NAME" . 1069084) ("PRIVATE" . 1069111) ("UVALUE" . 1069139)))
    ("GetPropertyAttribute" pro "IDLitComponent" (system) "Obj->[%s::]%s, PropertyIdentifier" ("objects_it23.html" ("TYPE" . 1069368)))
    ("RegisterProperty" pro "IDLitComponent" (system) "Obj->[%s::]%s, PropertyIdentifier[, Type]" ("objects_it27.html" ("BOOLEAN" . 1069541) ("COLOR" . 1069543) ("DESCRIPTION" . 1069545) ("ENUMLIST" . 1069547) ("FLOAT" . 1069549) ("HIDE" . 1069551) ("INTEGER" . 1069553) ("LINESTYLE" . 1069555) ("NAME" . 1069563) ("SENSITIVE" . 1069565) ("STRING" . 1069567) ("SYMBOL" . 1069569) ("THICKNESS" . 1069574) ("UNDEFINED" . 1069576) ("USERDEF" . 1069579) ("VALID_RANGE" . 1069581)))
    ("Restore" pro "IDLitComponent" (system) "Obj->[%s::]%s" ("objects_it28.html"))
    ("SetProperty" pro "IDLitComponent" (system) "Obj->[%s::]%s" ("objects_it29.html" ) ("objects_it18.html" ("DESCRIPTION" . 1286379) ("HELP" . 1069022) ("ICON" . 1281308) ("IDENTIFIER" . 1069050) ("NAME" . 1069084) ("PRIVATE" . 1069111) ("UVALUE" . 1069139)))
    ("SetPropertyAttribute" pro "IDLitComponent" (system) "Obj->[%s::]%s , PropertyIdentifier" ("objects_it30.html"))
    ("SetPropertyByIdentifier" pro "IDLitComponent" (system) "Obj->[%s::]%s, PropertyIdentifier, Value" ("objects_it31.html"))
    ("UpdateComponentVersion" pro "IDLitComponent" (system) "Obj->[%s::]%s" ("objects_it32.html"))
    ("EditUserDefProperty" fun "IDLitComponent" (system) "Result = Obj->[%s::]%s(iTool, PropertyIdentifier)" ("objects_it20.html"))
    ("GetFullIdentifier" fun "IDLitComponent" (system) "Result = Obj->[%s::]%s([Objref])" ("objects_it21.html"))
    ("GetPropertyByIdentifier" fun "IDLitComponent" (system) "Result = Obj->[%s::]%s(PropertyIdentifier, Value)" ("objects_it24.html"))
    ("Init" fun "IDLitComponent" (system) "Result = Obj->[%s::]%s()" ("objects_it25.html" ) ("objects_it18.html" ("DESCRIPTION" . 1286379) ("HELP" . 1069022) ("ICON" . 1281308) ("IDENTIFIER" . 1069050) ("NAME" . 1069084) ("PRIVATE" . 1069111) ("UVALUE" . 1069139)))
    ("QueryProperty" fun "IDLitComponent" (system) "Result = Obj->[%s::]%s([PropertyIdentifier])" ("objects_it26.html"))
    ("Add" pro "IDLitContainer" (system) "Obj->[%s::]%s, Components" ("objects_it35.html" ("NO_NOTIFY" . 1070004)))
    ("AddByIdentifier" pro "IDLitContainer" (system) "Obj->[%s::]%s, Identifier, Item" ("objects_it36.html"))
    ("Cleanup" pro "IDLitContainer" (system) "Obj->[%s::]%s" ("objects_it37.html"))
    ("Remove" pro "IDLitContainer" (system) "Obj->[%s::]%s, Components" ("objects_it42.html" ("NO_NOTIFY" . 1070225)))
    ("Get" fun "IDLitContainer" (system) "Result = Obj->[%s::]%s()" ("objects_it39.html" ("ALL" . 1070110) ("COUNT" . 1070112) ("ISA" . 1070114) ("POSITION" . 1070117) ("SKIP_PRIVATE" . 1070119)))
    ("GetByIdentifier" fun "IDLitContainer" (system) "Result = Obj->[%s::]%s(Identifier)" ("objects_it40.html"))
    ("IDLitContainer" fun "IDLitContainer" (system) "Result = Obj->[%s::]%s::FindIdentifiers([Pattern])" ("objects_it38.html" ("COUNT" . 1297331) ("LEAF_NODES" . 1297334)))
    ("Init" fun "IDLitContainer" (system) "Result = Obj->[%s::]%s()" ("objects_it41.html" ))
    ("RemoveByIdentifier" fun "IDLitContainer" (system) "Result = Obj->[%s::]%s(Identifier)" ("objects_it43.html"))
    ("AddDataObserver" pro "IDLitData" (system) "Obj->[%s::]%s, Observer" ("objects_it46.html"))
    ("Cleanup" pro "IDLitData" (system) "Obj->[%s::]%s" ("objects_it47.html"))
    ("GetProperty" pro "IDLitData" (system) "Obj->[%s::]%s" ("objects_it51.html" ) ("objects_it45.html" ("HIDE" . 1070552) ("READ_ONLY" . 1070608) ("TYPE" . 1070636)))
    ("NotifyDataChange" pro "IDLitData" (system) "Obj->[%s::]%s" ("objects_it54.html"))
    ("NotifyDataComplete" pro "IDLitData" (system) "Obj->[%s::]%s" ("objects_it55.html"))
    ("RemoveDataObserver" pro "IDLitData" (system) "Obj->[%s::]%s, Observer" ("objects_it56.html"))
    ("SetProperty" pro "IDLitData" (system) "Obj->[%s::]%s" ("objects_it58.html" ) ("objects_it45.html" ("HIDE" . 1070552) ("READ_ONLY" . 1070608)))
    ("Copy" fun "IDLitData" (system) "Result = Obj->[%s::]%s()" ("objects_it48.html"))
    ("GetByType" fun "IDLitData" (system) "Result = Obj->[%s::]%s(Type)" ("objects_it49.html" ("COUNT" . 1070828)))
    ("GetData" fun "IDLitData" (system) "Result = Obj->[%s::]%s(Data[, Identifier])" ("objects_it50.html" ("NAN" . 1070867) ("NO_COPY" . 1154511)))
    ("GetSize" fun "IDLitData" (system) "Result = Obj->[%s::]%s()" ("objects_it52.html"))
    ("Init" fun "IDLitData" (system) "Result = Obj->[%s::]%s([, Data])" ("objects_it53.html" ) ("objects_it45.html" ("HIDE" . 1070552) ("NO_COPY" . 1070580) ("READ_ONLY" . 1070608) ("TYPE" . 1070636)))
    ("SetData" fun "IDLitData" (system) "Result = Obj->[%s::]%s(Data[, Identifier])" ("objects_it57.html" ("NO_COPY" . 1071158) ("NULL" . 1071160)))
    ("Add" pro "IDLitDataContainer" (system) "Obj->[%s::]%s, Data" ("objects_it61.html" ("NO_NOTIFY" . 1275026)))
    ("Cleanup" pro "IDLitDataContainer" (system) "Obj->[%s::]%s" ("objects_it62.html"))
    ("GetProperty" pro "IDLitDataContainer" (system) "Obj->[%s::]%s" ("objects_it65.html" ))
    ("SetProperty" pro "IDLitDataContainer" (system) "Obj->[%s::]%s" ("objects_it68.html" ))
    ("GetData" fun "IDLitDataContainer" (system) "Result = Obj->[%s::]%s(Data [, Identifier])" ("objects_it63.html" ("NO_COPY" . 1071642)))
    ("GetIdentifiers" fun "IDLitDataContainer" (system) "Result = Obj->[%s::]%s([Pattern])" ("objects_it64.html" ("LEAF" . 1071682)))
    ("Init" fun "IDLitDataContainer" (system) "Result = Obj->[%s::]%s([, Data])" ("objects_it66.html" ))
    ("SetData" fun "IDLitDataContainer" (system) "Result = Obj->[%s::]%s(Data, Identifier)" ("objects_it67.html" ("NO_COPY" . 1071799) ("NULL" . 1071801)))
    ("GetProperty" pro "IDLitDataOperation" (system) "Obj->[%s::]%s" ("objects_it74.html" ))
    ("SetProperty" pro "IDLitDataOperation" (system) "Obj->[%s::]%s" ("objects_it76.html" ))
    ("DoExecuteUI" fun "IDLitDataOperation" (system) "Result = Obj->[%s::]%s()" ("objects_it72.html"))
    ("Execute" fun "IDLitDataOperation" (system) "Result = Obj->[%s::]%s(Data)" ("objects_it73.html"))
    ("Init" fun "IDLitDataOperation" (system) "Result = Obj->[%s::]%s()" ("objects_it75.html" ))
    ("UndoExecute" fun "IDLitDataOperation" (system) "Result = Obj->[%s::]%s(Data)" ("objects_it77.html"))
    ("AddOnNotifyObserver" pro "IDLitIMessaging" (system) "Obj->[%s::]%s, IdObserver, IdSubject" ("objects_it80.html"))
    ("DoOnNotify" pro "IDLitIMessaging" (system) "Obj->[%s::]%s, IdOriginator, IdMessage, Value" ("objects_it81.html"))
    ("ErrorMessage" pro "IDLitIMessaging" (system) "Obj->[%s::]%s, StrMessage" ("objects_it82.html" ("SEVERITY" . 1079859) ("TITLE" . 1079864) ("USE_LAST_ERROR" . 1079866)))
    ("ProbeStatusMessage" pro "IDLitIMessaging" (system) "Obj->[%s::]%s, StrMessage" ("objects_it84.html"))
    ("RemoveOnNotifyObserver" pro "IDLitIMessaging" (system) "Obj->[%s::]%s, IdObserver, IdSubject" ("objects_it88.html"))
    ("SignalError" pro "IDLitIMessaging" (system) "Obj->[%s::]%s, StrMessage" ("objects_it89.html" ("CODE" . 1080072) ("SEVERITY" . 1080074)))
    ("StatusMessage" pro "IDLitIMessaging" (system) "Obj->[%s::]%s, StrMessage" ("objects_it90.html" ("SEGMENT_IDENTIFIER" . 1287131)))
    ("GetTool" fun "IDLitIMessaging" (system) "Result = Obj->[%s::]%s()" ("objects_it83.html"))
    ("ProgressBar" fun "IDLitIMessaging" (system) "Result = Obj->[%s::]%s(StrMessage)" ("objects_it85.html" ("CANCEL" . 1270494) ("PERCENT" . 1079974) ("SHUTDOWN" . 1079976)))
    ("PromptUserText" fun "IDLitIMessaging" (system) "Result = Obj->[%s::]%s(StrPrompt, Answer)" ("objects_it86.html" ("TITLE" . 1080016)))
    ("PromptUserYesNo" fun "IDLitIMessaging" (system) "Result = Obj->[%s::]%s(StrPrompt, Answer)" ("objects_it87.html" ("TITLE" . 1080036)))
    ("Cleanup" pro "IDLitManipulator" (system) "Obj->[%s::]%s" ("objects_it93.html"))
    ("GetProperty" pro "IDLitManipulator" (system) "Obj->[%s::]%s" ("objects_it96.html" ) ("objects_it92.html" ("BUTTON_EVENTS" . 1080361) ("DESCRIPTION" . 1080417) ("KEYBOARD_EVENTS" . 1080504) ("MOTION_EVENTS" . 1080532) ("OPERATION_IDENTIFIER" . 1080560) ("PARAMETER_IDENTIFIER" . 1080588) ("TRANSIENT_DEFAULT" . 1080617) ("TRANSIENT_MOTION" . 1080650) ("TYPES" . 1080678) ("VISUAL_TYPE" . 1080735)))
    ("OnKeyboard" pro "IDLitManipulator" (system) "Obj->[%s::]%s, Win, IsASCII, Character, KeyValue, X, Y, Press, Release, KeyMods" ("objects_it98.html"))
    ("OnLoseCurrentManipulator" pro "IDLitManipulator" (system) "Obj->[%s::]%s" ("objects_it99.html"))
    ("OnMouseDown" pro "IDLitManipulator" (system) "Obj->[%s::]%s, Win, X, Y, IButton, KeyMods, NClicks" ("objects_it100.html"))
    ("OnMouseMotion" pro "IDLitManipulator" (system) "Obj->[%s::]%s, Win, X, Y, KeyMods" ("objects_it101.html"))
    ("OnMouseUp" pro "IDLitManipulator" (system) "Obj->[%s::]%s, Win, X, Y, IButton" ("objects_it102.html"))
    ("RegisterCursor" pro "IDLitManipulator" (system) "Obj->[%s::]%s, ArrCursor, Name" ("objects_it104.html" ("DEFAULT" . 1281810)))
    ("SetCurrentManipulator" pro "IDLitManipulator" (system) "Obj->[%s::]%s [, Item]" ("objects_it105.html"))
    ("SetProperty" pro "IDLitManipulator" (system) "Obj->[%s::]%s" ("objects_it120.html" ) ("objects_it92.html" ("BUTTON_EVENTS" . 1080361) ("DESCRIPTION" . 1080417) ("DISABLE" . 1080445) ("KEYBOARD_EVENTS" . 1080504) ("MOTION_EVENTS" . 1080532) ("OPERATION_IDENTIFIER" . 1080560) ("PARAMETER_IDENTIFIER" . 1080588) ("TRANSIENT_DEFAULT" . 1080617) ("TRANSIENT_MOTION" . 1080650) ("VISUAL_TYPE" . 1080735)))
    ("CommitUndoValues" fun "IDLitManipulator" (system) "Result = Obj->[%s::]%s()" ("objects_it94.html" ("UNCOMMIT" . 1080828)))
    ("GetCursorType" fun "IDLitManipulator" (system) "Result = Obj->[%s::]%s(TypeIn, KeyMods)" ("objects_it95.html"))
    ("Init" fun "IDLitManipulator" (system) "Result = Obj->[%s::]%s()" ("objects_it97.html" ) ("objects_it92.html" ("BUTTON_EVENTS" . 1080361) ("DEFAULT_CURSOR" . 1080389) ("DESCRIPTION" . 1080417) ("DISABLE" . 1080445) ("KEYBOARD_EVENTS" . 1080504) ("MOTION_EVENTS" . 1080532) ("OPERATION_IDENTIFIER" . 1080560) ("PARAMETER_IDENTIFIER" . 1080588) ("TRANSIENT_DEFAULT" . 1080617) ("TRANSIENT_MOTION" . 1080650) ("TYPES" . 1080678) ("VIEWS_ONLY" . 1080706) ("VISUAL_TYPE" . 1080735)))
    ("RecordUndoValues" fun "IDLitManipulator" (system) "Result = Obj->[%s::]%s()" ("objects_it103.html"))
    ("Add" pro "IDLitManipulatorContainer" (system) "Obj->[%s::]%s, Manipulator" ("objects_it109.html"))
    ("GetProperty" pro "IDLitManipulatorContainer" (system) "Obj->[%s::]%s" ("objects_it112.html" ))
    ("OnMouseDown" pro "IDLitManipulatorContainer" (system) "Obj->[%s::]%s, Win, X, Y, IButton, KeyMods, NClicks" ("objects_it115.html"))
    ("OnMouseMotion" pro "IDLitManipulatorContainer" (system) "Obj->[%s::]%s, Win, X, Y, KeyMods" ("objects_it116.html"))
    ("OnMouseUp" pro "IDLitManipulatorContainer" (system) "Obj->[%s::]%s, Win, X, Y, IButton" ("objects_it117.html"))
    ("SetCurrent" pro "IDLitManipulatorContainer" (system) "Obj->[%s::]%s, Manipulator" ("objects_it118.html"))
    ("SetCurrentManipulator" pro "IDLitManipulatorContainer" (system) "Obj->[%s::]%s, Identifier" ("objects_it119.html"))
    ("GetCurrent" fun "IDLitManipulatorContainer" (system) "Result = Obj->[%s::]%s()" ("objects_it110.html"))
    ("GetCurrentManipulator" fun "IDLitManipulatorContainer" (system) "Result = Obj->[%s::]%s()" ("objects_it111.html" ("IDENTIFIER" . 1081635)))
    ("Init" fun "IDLitManipulatorContainer" (system) "Result = Obj->[%s::]%s()" ("objects_it113.html" ) ("objects_it108.html" ("AUTO_SWITCH" . 1081512)))
    ("Add" pro "IDLitManipulatorManager" (system) "Obj->[%s::]%s, Manipulator" ("objects_it123.html" ("DEFAULT" . 1082187)))
    ("AddManipulatorObserver" pro "IDLitManipulatorManager" (system) "Obj->[%s::]%s, Observer" ("objects_it124.html"))
    ("RemoveManipulatorObserver" pro "IDLitManipulatorManager" (system) "Obj->[%s::]%s, Observer" ("objects_it127.html"))
    ("Init" fun "IDLitManipulatorManager" (system) "Result = Obj->[%s::]%s()" ("objects_it126.html" ))
    ("Cleanup" pro "IDLitManipulatorVisual" (system) "Obj->[%s::]%s" ("objects_it130.html"))
    ("GetProperty" pro "IDLitManipulatorVisual" (system) "Obj->[%s::]%s" ("objects_it131.html" ) ("objects_it129.html" ("UNIFORM_SCALE" . 1082429) ("VISUAL_TYPE" . 1082457)))
    ("SetProperty" pro "IDLitManipulatorVisual" (system) "Obj->[%s::]%s" ("objects_it133.html" ) ("objects_it129.html" ("UNIFORM_SCALE" . 1082429) ("VISUAL_TYPE" . 1082457)))
    ("Init" fun "IDLitManipulatorVisual" (system) "Result = Obj->[%s::]%s()" ("objects_it132.html" ) ("objects_it129.html" ("UNIFORM_SCALE" . 1082429) ("VISUAL_TYPE" . 1082457)))
    ("Cleanup" pro "IDLitOperation" (system) "Obj->[%s::]%s" ("objects_it71.html"))
    ("GetProperty" pro "IDLitOperation" (system) "Obj->[%s::]%s" ("objects_it138.html" ) ("objects_it135.html" ("EXPENSIVE_COMPUTATION" . 1072559) ("REVERSIBLE_OPERATION" . 1072587) ("SHOW_EXECUTION_UI" . 1072615) ("TYPES" . 1072643)))
    ("SetProperty" pro "IDLitOperation" (system) "Obj->[%s::]%s" ("objects_it143.html" ))
    ("DoAction" fun "IDLitOperation" (system) "Result = Obj->[%s::]%s(Tool)" ("objects_it137.html"))
    ("Init" fun "IDLitOperation" (system) "Result = Obj->[%s::]%s()" ("objects_it139.html" ) ("objects_it135.html" ("EXPENSIVE_COMPUTATION" . 1072559) ("REVERSIBLE_OPERATION" . 1072587) ("SHOW_EXECUTION_UI" . 1072615) ("TYPES" . 1072643)))
    ("RecordFinalValues" fun "IDLitOperation" (system) "Result = Obj->[%s::]%s(CommandSet, Targets [, IdProperty] )" ("objects_it140.html"))
    ("RecordInitialValues" fun "IDLitOperation" (system) "Result = Obj->[%s::]%s(CommandSet, Targets [, IdProperty])" ("objects_it141.html"))
    ("RedoOperation" fun "IDLitOperation" (system) "Result = Obj->[%s::]%s(CommandSet)" ("objects_it142.html"))
    ("UndoOperation" fun "IDLitOperation" (system) "Result = Obj->[%s::]%s(CommandSet)" ("objects_it144.html"))
    ("Cleanup" pro "IDLitParameter" (system) "Obj->[%s::]%s" ("objects_it147.html"))
    ("IDLitParameter" pro "IDLitParameter" (system) "Obj->[%s::]%s::SetParameterAttribute(ParamName)" ("objects_it157.html" ("KEYWORD")))
    ("OnDataChangeUpdate" pro "IDLitParameter" (system) "Obj->[%s::]%s, Data, ParameterName" ("objects_it152.html"))
    ("OnDataDisconnect" pro "IDLitParameter" (system) "Obj->[%s::]%s, ParameterName" ("objects_it153.html"))
    ("RegisterParameter" pro "IDLitParameter" (system) "Obj->[%s::]%s, Name" ("objects_it155.html" ("BY_VALUE" . 1083371) ("DESCRIPTION" . 1083373) ("INPUT" . 1083375) ("OPTARGET" . 1083377) ("OPTIONAL" . 1083379) ("OUTPUT" . 1083381) ("TYPES" . 1083383)))
    ("GetParameter" fun "IDLitParameter" (system) "Result = Obj->[%s::]%s(Name)" ("objects_it148.html" ("ALL" . 1083021) ("COUNT" . 1083023)))
    ("GetParameterSet" fun "IDLitParameter" (system) "Result = Obj->[%s::]%s()" ("objects_it150.html" ("DEEP_COPY" . 1083153)))
    ("IDLitParameter" fun "IDLitParameter" (system) "Result = Obj->[%s::]%s::QueryParameter([ParamName])" ("objects_it154.html" ("COUNT" . 1297407)))
    ("Init" fun "IDLitParameter" (system) "Result = Obj->[%s::]%s()" ("objects_it151.html" ))
    ("SetData" fun "IDLitParameter" (system) "Result = Obj->[%s::]%s(Data)" ("objects_it156.html" ("BY_VALUE" . 1083428) ("NO_UPDATE" . 1083430) ("PARAMETER_NAME" . 1083433)))
    ("SetParameterSet" fun "IDLitParameter" (system) "Result = Obj->[%s::]%s(ParamSet)" ("objects_it158.html"))
    ("Add" pro "IDLitParameterSet" (system) "Obj->[%s::]%s, Data" ("objects_it161.html" ("PARAMETER_NAME" . 1083838) ("PRESERVE_LOCATION" . 1083840)))
    ("Cleanup" pro "IDLitParameterSet" (system) "Obj->[%s::]%s" ("objects_it162.html"))
    ("Remove" pro "IDLitParameterSet" (system) "Obj->[%s::]%s [, Items]" ("objects_it168.html" ("ALL" . 1084212) ("POSITION" . 1084214)))
    ("Copy" fun "IDLitParameterSet" (system) "Result = Obj->[%s::]%s()" ("objects_it163.html"))
    ("Get" fun "IDLitParameterSet" (system) "Result = Obj->[%s::]%s()" ("objects_it164.html" ("ALL" . 1083998) ("COUNT" . 1084000) ("NAME" . 1084002) ("POSITION" . 1084004)))
    ("GetByName" fun "IDLitParameterSet" (system) "Result = Obj->[%s::]%s( Names)" ("objects_it165.html" ("COUNT" . 1228440) ("NAME" . 1084087)))
    ("GetParameterName" fun "IDLitParameterSet" (system) "Result = Obj->[%s::]%s(Data, Name)" ("objects_it166.html"))
    ("Init" fun "IDLitParameterSet" (system) "Result = Obj->[%s::]%s()" ("objects_it167.html" ))
    ("Cleanup" pro "IDLitReader" (system) "Obj->[%s::]%s" ("objects_it171.html"))
    ("GetProperty" pro "IDLitReader" (system) "Obj->[%s::]%s" ("objects_it175.html" ))
    ("SetFilename" pro "IDLitReader" (system) "Obj->[%s::]%s, Filename" ("objects_it178.html"))
    ("SetProperty" pro "IDLitReader" (system) "Obj->[%s::]%s" ("objects_it179.html" ))
    ("GetData" fun "IDLitReader" (system) "Result = Obj->[%s::]%s(Data)" ("objects_it172.html"))
    ("GetFileExtensions" fun "IDLitReader" (system) "Result = Obj->[%s::]%s()" ("objects_it173.html" ("COUNT" . 1084646)))
    ("GetFilename" fun "IDLitReader" (system) "Result = Obj->[%s::]%s()" ("objects_it174.html"))
    ("Init" fun "IDLitReader" (system) "Result = Obj->[%s::]%s(, Extensions)" ("objects_it176.html" ))
    ("IsA" fun "IDLitReader" (system) "Result = Obj->[%s::]%s(Filename)" ("objects_it177.html"))
    ("ActivateManipulator" pro "IDLitTool" (system) "Obj->[%s::]%s, Identifier" ("objects_it182.html" ("DEFAULT" . 1265856)))
    ("Add" pro "IDLitTool" (system) "Obj->[%s::]%s, Item" ("objects_it183.html"))
    ("AddService" pro "IDLitTool" (system) "Obj->[%s::]%s, Service" ("objects_it184.html"))
    ("Cleanup" pro "IDLitTool" (system) "Obj->[%s::]%s" ("objects_it185.html"))
    ("CommitActions" pro "IDLitTool" (system) "Obj->[%s::]%s" ("objects_it186.html"))
    ("DisableUpdates" pro "IDLitTool" (system) "Obj->[%s::]%s ()" ("objects_it187.html" ("PREVIOUSLY_DISABLED" . 1078152)))
    ("EnableUpdates" pro "IDLitTool" (system) "Obj->[%s::]%s" ("objects_it191.html"))
    ("GetProperty" pro "IDLitTool" (system) "Obj->[%s::]%s" ("objects_it198.html" ) ("objects_it181.html" ("DESCRIPTION" . 1123541) ("ICON" . 1077825) ("NAME" . 1077853) ("VERBOSE" . 1077937) ("VERSION" . 1077965)))
    ("RefreshCurrentWindow" pro "IDLitTool" (system) "Obj->[%s::]%s" ("objects_it203.html"))
    ("Register" pro "IDLitTool" (system) "Obj->[%s::]%s, Name, ClassName" ("objects_it204.html" ("DEFAULT" . 1363277) ("DESCRIPTION" . 1078812) ("ICON" . 1078814) ("IDENTIFIER" . 1078816) ("PROXY" . 1078824)))
    ("RegisterCustomization" pro "IDLitTool" (system) "Obj->[%s::]%s, Name, ClassName" ("objects_it205.html"))
    ("RegisterFileReader" pro "IDLitTool" (system) "Obj->[%s::]%s, Name, ClassName" ("objects_it206.html" ("DEFAULT" . 1363382) ("DESCRIPTION" . 1078859) ("ICON" . 1078861) ("IDENTIFIER" . 1078863) ("PROXY" . 1078866)))
    ("RegisterFileWriter" pro "IDLitTool" (system) "Obj->[%s::]%s, Name, ClassName" ("objects_it207.html" ("DEFAULT" . 1363460) ("DESCRIPTION" . 1078901) ("ICON" . 1078903) ("IDENTIFIER" . 1078905) ("PROXY" . 1078908)))
    ("RegisterManipulator" pro "IDLitTool" (system) "Obj->[%s::]%s, Name, ClassName" ("objects_it208.html" ("DEFAULT" . 1078943) ("DESCRIPTION" . 1078945) ("ICON" . 1078947) ("IDENTIFIER" . 1078949)))
    ("RegisterOperation" pro "IDLitTool" (system) "Obj->[%s::]%s, Name, ClassName" ("objects_it209.html" ("ACCELERATOR" . 1247195) ("CHECKED" . 1247213) ("DESCRIPTION" . 1078985) ("DISABLE" . 1247231) ("DROPLIST_EDIT" . 1292076) ("DROPLIST_INDEX" . 1292079) ("DROPLIST_ITEMS" . 1292082) ("ICON" . 1078987) ("IDENTIFIER" . 1078989) ("PROXY" . 1078992) ("SEPARATOR" . 1247249)))
    ("RegisterStatusBarSegment" pro "IDLitTool" (system) "Obj->[%s::]%s, Name" ("objects_it210.html" ("IDENTIFIER" . 1286948) ("NORMALIZED_WIDTH" . 1286951)))
    ("RegisterVisualization" pro "IDLitTool" (system) "Obj->[%s::]%s, Name, ClassName" ("objects_it211.html" ("DEFAULT" . 1079028) ("DESCRIPTION" . 1079030) ("ICON" . 1079032) ("IDENTIFIER" . 1079034) ("PROXY" . 1079037)))
    ("SetProperty" pro "IDLitTool" (system) "Obj->[%s::]%s" ("objects_it212.html" ) ("objects_it181.html" ("DESCRIPTION" . 1123541) ("ICON" . 1077825) ("NAME" . 1077853) ("TYPE" . 1077881) ("UPDATE_BYTYPE" . 1077909) ("VERBOSE" . 1077937)))
    ("UnRegister" pro "IDLitTool" (system) "Obj->[%s::]%s, Identifier" ("objects_it213.html"))
    ("UnRegisterCustomization" pro "IDLitTool" (system) "Obj->[%s::]%s" ("objects_it214.html"))
    ("UnRegisterFileReader" pro "IDLitTool" (system) "Obj->[%s::]%s, Identifier" ("objects_it215.html"))
    ("UnRegisterFileWriter" pro "IDLitTool" (system) "Obj->[%s::]%s, Identifier" ("objects_it216.html"))
    ("UnRegisterManipulator" pro "IDLitTool" (system) "Obj->[%s::]%s, Identifier" ("objects_it217.html"))
    ("UnRegisterOperation" pro "IDLitTool" (system) "Obj->[%s::]%s, Identifier" ("objects_it218.html"))
    ("UnRegisterStatusBarSegment" pro "IDLitTool" (system) "Obj->[%s::]%s, Identifier" ("objects_it219.html"))
    ("UnRegisterVisualization" pro "IDLitTool" (system) "Obj->[%s::]%s, Identifier" ("objects_it220.html"))
    ("DoAction" fun "IDLitTool" (system) "Result = Obj->[%s::]%s(Identifier)" ("objects_it188.html"))
    ("DoSetProperty" fun "IDLitTool" (system) "Result = Obj->[%s::]%s(TargetIdentifier, PropertyIdentifier, Value)" ("objects_it189.html"))
    ("DoUIService" fun "IDLitTool" (system) "Result = Obj->[%s::]%s(ServiceIdentifier, Requestor)" ("objects_it190.html"))
    ("GetCurrentManipulator" fun "IDLitTool" (system) "Result = Obj->[%s::]%s()" ("objects_it193.html"))
    ("GetFileReaders" fun "IDLitTool" (system) "Result = Obj->[%s::]%s(Identifier)" ("objects_it194.html" ("ALL" . 1078392) ("COUNT" . 1078394)))
    ("GetFileWriters" fun "IDLitTool" (system) "Result = Obj->[%s::]%s(Identifier)" ("objects_it195.html" ("ALL" . 1078432) ("COUNT" . 1078434)))
    ("GetManipulators" fun "IDLitTool" (system) "Result = Obj->[%s::]%s()" ("objects_it196.html" ("COUNT" . 1078470)))
    ("GetOperations" fun "IDLitTool" (system) "Result = Obj->[%s::]%s()" ("objects_it197.html" ("COUNT" . 1228547) ("IDENTIFIER" . 1078507)))
    ("GetSelectedItems" fun "IDLitTool" (system) "Result = Obj->[%s::]%s()" ("objects_it199.html" ("COUNT" . 1078577)))
    ("GetService" fun "IDLitTool" (system) "Result = Obj->[%s::]%s(IdService)" ("objects_it200.html"))
    ("GetVisualizations" fun "IDLitTool" (system) "Result = Obj->[%s::]%s(Identifier)" ("objects_it201.html" ("ALL" . 1078651) ("COUNT" . 1078653)))
    ("IDLitTool" fun "IDLitTool" (system) "Result = Obj->[%s::]%s::FindIdentifiers([Pattern])" ("objects_it192.html" ("ANNOTATIONS" . 1297756) ("COUNT" . 1297759) ("DATA_MANAGER" . 1297762) ("FILE_READERS" . 1297765) ("FILE_WRITERS" . 1297768) ("LEAF_NODES" . 1297771) ("MANIPULATORS" . 1297775) ("OPERATIONS" . 1297778) ("VISUALIZATIONS" . 1297781)))
    ("Init" fun "IDLitTool" (system) "Result = Obj->[%s::]%s()" ("objects_it202.html" ) ("objects_it181.html" ("DESCRIPTION" . 1123541) ("ICON" . 1077825) ("NAME" . 1077853) ("TYPE" . 1077881) ("UPDATE_BYTYPE" . 1077909) ("VERBOSE" . 1077937) ("VERSION" . 1077965)))
    ("AddOnNotifyObserver" pro "IDLitUI" (system) "Obj->[%s::]%s, IdObserver, IdSubject" ("objects_it224.html"))
    ("Cleanup" pro "IDLitUI" (system) "Obj->[%s::]%s" ("objects_it225.html"))
    ("GetProperty" pro "IDLitUI" (system) "Obj->[%s::]%s" ("objects_it227.html" ) ("objects_it223.html" ("GROUP_LEADER" . 1085364)))
    ("RemoveOnNotifyObserver" pro "IDLitUI" (system) "Obj->[%s::]%s, IdObserver, IdSubject" ("objects_it233.html"))
    ("SetProperty" pro "IDLitUI" (system) "Obj->[%s::]%s" ("objects_it234.html" ))
    ("UnRegisterUIService" pro "IDLitUI" (system) "Obj->[%s::]%s, Name" ("objects_it235.html"))
    ("UnRegisterWidget" pro "IDLitUI" (system) "Obj->[%s::]%s, Name" ("objects_it236.html"))
    ("DoAction" fun "IDLitUI" (system) "Result = Obj->[%s::]%s(Identifier)" ("objects_it226.html"))
    ("GetTool" fun "IDLitUI" (system) "Result = Obj->[%s::]%s()" ("objects_it228.html"))
    ("GetWidgetByName" fun "IDLitUI" (system) "Result = Obj->[%s::]%s(Name)" ("objects_it229.html"))
    ("Init" fun "IDLitUI" (system) "Result = Obj->[%s::]%s(, oTool)" ("objects_it230.html" ))
    ("RegisterUIService" fun "IDLitUI" (system) "Restult = Obj->[%s::]%s(Name, Callback)" ("objects_it231.html"))
    ("RegisterWidget" fun "IDLitUI" (system) "Result = Obj->[%s::]%s(wID, Name, Callback)" ("objects_it232.html" ("FLOATING" . 1085752)))
    ("Add" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Objects" ("objects_it239.html" ("AGGREGATE" . 1086521) ("NO_UPDATE" . 1086525) ("POSITION" . 1086527)))
    ("Aggregate" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Objects" ("objects_it240.html"))
    ("BeginManipulation" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Manipulator" ("objects_it241.html"))
    ("Cleanup" pro "IDLitVisualization" (system) "Obj->[%s::]%s" ("objects_it242.html"))
    ("EndManipulation" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Manipulator" ("objects_it243.html"))
    ("GetProperty" pro "IDLitVisualization" (system) "Obj->[%s::]%s" ("objects_it251.html" ) ("objects_it238.html" ("CENTER_OF_ROTATION" . 1086295) ("IMPACTS_RANGE" . 1255230) ("ISOTROPIC" . 1086379) ("MANIPULATOR_TARGET" . 1086407) ("PROPERTY_INTERSECTION" . 1153078)))
    ("Move" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Source, Destination" ("objects_it261.html"))
    ("On2DRotate" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Notifier, IsRotated" ("objects_it262.html"))
    ("OnAxesRequestChange" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Notifier, AxesRequest" ("objects_it263.html"))
    ("OnAxesStyleRequestChange" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Notifier, StyleRequest" ("objects_it264.html"))
    ("OnDataChange" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Notifier" ("objects_it265.html"))
    ("OnDataComplete" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Notifier" ("objects_it266.html"))
    ("OnDataRangeChange" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Notifier, XRange, YRange, Zrange" ("objects_it267.html"))
    ("OnDimensionChange" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Notifier, Is3D" ("objects_it268.html"))
    ("OnWorldDimensionChange" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Notifier, Is3D" ("objects_it269.html"))
    ("Remove" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Object" ("objects_it270.html" ("NO_UPDATE" . 1087640)))
    ("Restore" pro "IDLitVisualization" (system) "Obj->[%s::]%s" ("objects_it272.html"))
    ("Rotate" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Axis, Angle" ("objects_it273.html" ("CENTER_OF_ROTATION" . 1257870) ("PREMULTIPLY" . 1257943)))
    ("Scale" pro "IDLitVisualization" (system) "Obj->[%s::]%s, SX, SY, SZ" ("objects_it274.html" ("CENTER_OF_ROTATION" . 1087711) ("PREMULTIPLY" . 1087713)))
    ("Select" pro "IDLitVisualization" (system) "Obj->[%s::]%s[, Mode]" ("objects_it275.html" ("ADDITIVE" . 1087748) ("NO_NOTIFY" . 1087750) ("SELECT" . 1087752) ("TOGGLE" . 1087754) ("UNSELECT" . 1087756)))
    ("Set3D" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Is3D" ("objects_it276.html" ("ALWAYS" . 1087787) ("AUTO_COMPUTE" . 1087789)))
    ("SetAxesRequest" pro "IDLitVisualization" (system) "Obj->[%s::]%s [, AxesRequest]" ("objects_it277.html" ("ALWAYS" . 1264542) ("AUTO_COMPUTE" . 1264612) ("NO_NOTIFY" . 1264617)))
    ("SetAxesStyleRequest" pro "IDLitVisualization" (system) "Obj->[%s::]%s, StyleRequest" ("objects_it278.html" ("NO_NOTIFY" . 1264441)))
    ("SetCurrentSelectionVisual" pro "IDLitVisualization" (system) "Obj->[%s::]%s, Manipulator" ("objects_it279.html"))
    ("SetDefaultSelectionVisual" pro "IDLitVisualization" (system) "Obj->[%s::]%s, SelectionVisual" ("objects_it281.html" ("POSITION" . 1087891)))
    ("SetProperty" pro "IDLitVisualization" (system) "Obj->[%s::]%s" ("objects_it283.html" ) ("objects_it238.html" ("CENTER_OF_ROTATION" . 1086295) ("IMPACTS_RANGE" . 1255230) ("ISOTROPIC" . 1086379) ("MANIPULATOR_TARGET" . 1086407) ("TYPE" . 1086465)))
    ("UpdateSelectionVisual" pro "IDLitVisualization" (system) "Obj->[%s::]%s" ("objects_it284.html"))
    ("VisToWindow" pro "IDLitVisualization" (system) "Obj->[%s::]%s, InX, InY, InZ, OutX, OutY, OutZ" ("objects_it285.html" ("NO_TRANSFORM" . 1157092)))
    ("WindowToVis" pro "IDLitVisualization" (system) "Obj->[%s::]%s, InX, InY, InZ, OutX, OutY, OutZ or Obj->[%s::]%s, InX, InY, OutX, OutY or Obj->[%s::]%s, InVerts, OutVerts" ("objects_it286.html"))
    ("Get" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s()" ("objects_it244.html" ("ALL" . 1086723) ("COUNT" . 1086725) ("ISA" . 1086727) ("POSITION" . 1086730) ("SKIP_PRIVATE" . 1086732)))
    ("GetCenterRotation" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s()" ("objects_it245.html" ("NO_TRANSFORM" . 1086773) ("XRANGE" . 1086775) ("YRANGE" . 1086777) ("ZRANGE" . 1086779)))
    ("GetCurrentSelectionVisual" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s()" ("objects_it246.html"))
    ("GetDataSpace" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s()" ("objects_it247.html" ("UNNORMALIZED" . 1154562)))
    ("GetDataString" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s(XYZLocation)" ("objects_it248.html"))
    ("GetDefaultSelectionVisual" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s()" ("objects_it249.html"))
    ("GetManipulatorTarget" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s()" ("objects_it250.html"))
    ("GetRequestedAxesStyle" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s( )" ("objects_it252.html"))
    ("GetSelectionVisual" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s(Manipulator)" ("objects_it253.html"))
    ("GetTypes" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s()" ("objects_it254.html"))
    ("GetXYZRange" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s(XRange,YRange, ZRange)" ("objects_it255.html" ("DATA" . 1087296) ("NO_TRANSFORM" . 1087298)))
    ("Init" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s()" ("objects_it256.html" ) ("objects_it238.html" ("CENTER_OF_ROTATION" . 1086295) ("IMPACTS_RANGE" . 1255230) ("ISOTROPIC" . 1086379) ("MANIPULATOR_TARGET" . 1086407) ("PROPERTY_INTERSECTION" . 1153078) ("TYPE" . 1086465)))
    ("Is3D" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s()" ("objects_it257.html"))
    ("IsIsotropic" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s()" ("objects_it258.html"))
    ("IsManipulatorTarget" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s()" ("objects_it259.html"))
    ("IsSelected" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s()" ("objects_it260.html"))
    ("RequestsAxes" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s( )" ("objects_it271.html"))
    ("SetData" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s(Data)" ("objects_it280.html"))
    ("SetParameterSet" fun "IDLitVisualization" (system) "Result = Obj->[%s::]%s(ParameterSet)" ("objects_it282.html"))
    ("Add" pro "IDLitWindow" (system) "Obj->[%s::]%s, Objects" ("objects_it289.html" ("POSITION" . 1092060)))
    ("AddWindowEventObserver" pro "IDLitWindow" (system) "Obj->[%s::]%s, Objects" ("objects_it290.html"))
    ("Cleanup" pro "IDLitWindow" (system) "Obj->[%s::]%s" ("objects_it291.html"))
    ("ClearSelections" pro "IDLitWindow" (system) "Obj->[%s::]%s" ("objects_it292.html"))
    ("OnKeyboard" pro "IDLitWindow" (system) "Obj->[%s::]%s, IsASCII, Character, KeySymbol, X, Y, Press, Release, Modifiers" ("objects_it298.html"))
    ("OnMouseDown" pro "IDLitWindow" (system) "Obj->[%s::]%s, X, Y, ButtonMask, Modifiers, NumClicks" ("objects_it299.html"))
    ("OnMouseMotion" pro "IDLitWindow" (system) "Obj->[%s::]%s, X, Y, Modifiers" ("objects_it300.html"))
    ("OnMouseUp" pro "IDLitWindow" (system) "Obj->[%s::]%s, X, Y, ButtonMask" ("objects_it301.html"))
    ("OnScroll" pro "IDLitWindow" (system) "Obj->[%s::]%s, X, Y" ("objects_it302.html"))
    ("Remove" pro "IDLitWindow" (system) "Obj->[%s::]%s, Object" ("objects_it303.html" ("ALL" . 1092903) ("POSITION" . 1092905)))
    ("RemoveWindowEventObserver" pro "IDLitWindow" (system) "Obj->[%s::]%s, Objects" ("objects_it304.html"))
    ("SetCurrentZoom" pro "IDLitWindow" (system) "Obj->[%s::]%s, ZoomFactor" ("objects_it305.html" ("RESET" . 1092996)))
    ("SetEventMask" pro "IDLitWindow" (system) "Obj->[%s::]%s([EventMask])" ("objects_it306.html" ("BUTTON_EVENTS" . 1093069) ("KEYBOARD_EVENTS" . 1093071) ("MOTION_EVENTS" . 1093073) ("TRACKING_EVENTS" . 1093075)))
    ("SetManipulatorManager" pro "IDLitWindow" (system) "Obj->[%s::]%s, Manager" ("objects_it307.html"))
    ("SetProperty" pro "IDLitWindow" (system) "Obj->[%s::]%s" ("objects_it308.html" ))
    ("ZoomIn" pro "IDLitWindow" (system) "Obj->[%s::]%s" ("objects_it309.html"))
    ("ZoomOut" pro "IDLitWindow" (system) "Obj->[%s::]%s" ("objects_it310.html"))
    ("DoHitTest" fun "IDLitWindow" (system) "Result = Obj->[%s::]%s(X, Y)" ("objects_it293.html" ("DIMENSIONS" . 1092195) ("ORDER" . 1247287) ("SUB_HIT" . 1092197) ("UNITS" . 1092202)))
    ("GetEventMask" fun "IDLitWindow" (system) "Result = Obj->[%s::]%s()" ("objects_it294.html" ("BUTTON_EVENTS" . 1092316) ("KEYBOARD_EVENTS" . 1092318) ("MOTION_EVENTS" . 1092320) ("TRACKING_EVENTS" . 1092322)))
    ("GetSelectedItems" fun "IDLitWindow" (system) "Result = Obj->[%s::]%s()" ("objects_it296.html" ("ALL" . 1247360) ("COUNT" . 1154724)))
    ("Init" fun "IDLitWindow" (system) "Result = Obj->[%s::]%s()" ("objects_it297.html" ))
    ("Cleanup" pro "IDLitWriter" (system) "Obj->[%s::]%s" ("objects_it313.html"))
    ("GetProperty" pro "IDLitWriter" (system) "Obj->[%s::]%s" ("objects_it316.html" ) ("objects_it312.html" ("TYPES" . 1394697)))
    ("SetFilename" pro "IDLitWriter" (system) "Obj->[%s::]%s, Filename" ("objects_it320.html"))
    ("SetProperty" pro "IDLitWriter" (system) "Obj->[%s::]%s" ("objects_it321.html" ))
    ("GetFileExtensions" fun "IDLitWriter" (system) "Result = Obj->[%s::]%s()" ("objects_it314.html" ("COUNT" . 1093562)))
    ("GetFilename" fun "IDLitWriter" (system) "Result = Obj->[%s::]%s()" ("objects_it315.html"))
    ("Init" fun "IDLitWriter" (system) "Result = Obj->[%s::]%s(, Extensions)" ("objects_it317.html" ) ("objects_it312.html" ("TYPES" . 1394697)))
    ("IsA" fun "IDLitWriter" (system) "Result = Obj->[%s::]%s(Filename)" ("objects_it318.html"))
    ("SetData" fun "IDLitWriter" (system) "Result = Obj->[%s::]%s(Data)" ("objects_it319.html"))
    ("GetProperty" pro "IDLjavaObject" (system) "Obj->[%s::]%s" ("objects_misc30.html" ))
    ("SetProperty" pro "IDLjavaObject" (system) "Obj->[%s::]%s" ("objects_misc32.html" ))
    ("Init" fun "IDLjavaObject" (system) "Result = Obj -> [%s::]%s(, JavaClassName[, Arg1, ...])" ("objects_misc31.html" ))
    ("Reset" pro "TrackBall" (system) "Obj->[%s::]%s, Center, Radius" ("objects_misc36.html" ("AXIS" . 1004145) ("CONSTRAIN" . 1004150) ("MOUSE" . 1004152)))
    ("Init" fun "TrackBall" (system) "Result = Obj->[%s::]%s(, Center, Radius)" ("objects_misc35.html" ("AXIS") ("CONSTRAIN") ("MOUSE")) ("objects_misc34.html" ("AXIS" . 1010189) ("CONSTRAIN" . 1010194) ("MOUSE" . 1010196)))
    ("Update" fun "TrackBall" (system) "Result = Obj->[%s::]%s( sEvent)" ("objects_misc37.html" ("MOUSE" . 1004192) ("TRANSFORM" . 1004197) ("TRANSLATE" . 1004199)))
   )
  "1850 builtin routines with 7685 keywords for IDL version 6.1.")

(defvar idlwave-system-variables-alist
  '(
    ("C" (link "sysvars7.html#wp997337"))
    ("CPU" (tags ("HW_VECTOR") ("VECTOR_ENABLE") ("HW_NCPU") ("TPOOL_NTHREADS") ("TPOOL_MIN_ELTS") ("TPOOL_MAX_ELTS")) (link "sysvars6.html#wp1014201"))
    ("D" (tags ("NAME" . 997486) ("X_SIZE" . 997529) ("Y_SIZE" . 997529) ("X_VSIZE" . 997534) ("Y_VSIZE" . 997534) ("X_CH_SIZE" . 997518) ("Y_CH_SIZE" . 997518) ("X_PX_CM" . 997524) ("Y_PX_CM" . 997524) ("N_COLORS" . 997482) ("TABLE_SIZE" . 997494) ("FILL_DIST" . 997350) ("WINDOW" . 997514) ("UNIT" . 1008156) ("FLAGS" . 997354) ("ORIGIN" . 997490) ("ZOOM" . 997538)) (link "sysvars7.html#wp997347"))
    ("DIR" (link "sysvars6.html#wp997072"))
    ("DLM_PATH" (link "sysvars6.html#wp1004032"))
    ("DPI" (link "sysvars4.html#wp996942"))
    ("DTOR" (link "sysvars4.html#wp996946"))
    ("EDIT_INPUT" (link "sysvars6.html#wp1004047"))
    ("ERROR_STATE" (tags ("NAME") ("BLOCK") ("CODE") ("SYS_CODE") ("SYS_CODE_TYPE") ("MSG") ("SYS_MSG") ("MSG_PREFIX")) (link "sysvars5.html#wp1003013"))
    ("EXCEPT" (link "sysvars5.html#wp1002623"))
    ("HELP_PATH" (link "sysvars6.html#wp1000204"))
    ("JOURNAL" (link "sysvars6.html#wp997085"))
    ("MAKE_DLL" (tags ("COMPILE_DIRECTORY") ("COMPILER_NAME") ("CC") ("LD")) (link "sysvars6.html#wp1009307"))
    ("MAP" (tags ("PROJECTION") ("SIMPLE") ("FILL_METHOD") ("UP_FLAGS") ("UP_NAME") ("P0LON") ("P0LAT") ("U0") ("V0") ("SINO") ("COSO") ("ROTATION") ("SINR") ("COSR") ("A") ("E2") ("UV") ("POLE") ("UV_BOX") ("LL_BOX") ("SEGMENT_LENGTH") ("P") ("PIPELINE")) (link "sysvars4.html#wp996950"))
    ("MORE" (link "sysvars6.html#wp997090"))
    ("MOUSE" (tags ("X") ("Y") ("BUTTON") ("TIME")) (link "sysvars5.html#wp1000051"))
    ("ORDER" (link "sysvars7.html#wp997544"))
    ("P" (tags ("BACKGROUND" . 997554) ("CHARSIZE" . 997560) ("CHARTHICK" . 997563) ("CLIP" . 997566) ("COLOR" . 997569) ("FONT" . 997572) ("LINESTYLE" . 997575) ("MULTI" . 1004014) ("NOCLIP" . 997613) ("NOERASE" . 997616) ("NSUM" . 997619) ("POSITION" . 1006945) ("PSYM" . 997627) ("REGION" . 997633) ("SUBTITLE" . 997636) ("SYMSIZE") ("T" . 997639) ("T3D" . 997642) ("THICK" . 997645) ("TITLE" . 997648) ("TICKLEN" . 997651) ("CHANNEL" . 997557)) (link "sysvars7.html#wp997551"))
    ("PATH" (link "sysvars6.html#wp997094"))
    ("PI" (link "sysvars4.html#wp996954"))
    ("PROMPT" (link "sysvars6.html#wp997101"))
    ("QUIET" (link "sysvars6.html#wp997106"))
    ("RADEG" (link "sysvars4.html#wp996958"))
    ("VALUES" (tags ("F_INFINITY") ("F_NAN") ("D_INFINITY") ("D_NAN")) (link "sysvars4.html#wp996962"))
    ("VERSION" (tags ("ARCH") ("OS") ("OS_FAMILY") ("OS_NAME") ("RELEASE") ("BUILD_DATE") ("MEMORY_BITS") ("FILE_OFFSET_BITS")) (link "sysvars6.html#wp997111"))
    ("WARN" (tags ("OBS_ROUTINES") ("OBS_SYSVARS") ("PARENS")) (link "sysvars5.html#wp1000387"))
    ("X" (tags ("TITLE" . 997839) ("TYPE" . 997842) ("STYLE" . 997742) ("TICKS" . 999577) ("TICKLEN" . 1012793) ("THICK" . 997798) ("RANGE" . 997713) ("CRANGE" . 997670) ("S" . 997736) ("MARGIN" . 997689) ("OMARGIN" . 997702) ("WINDOW" . 997845) ("REGION" . 997724) ("CHARSIZE" . 1012787) ("MINOR" . 997699) ("TICKV" . 997833) ("TICKNAME" . 997811) ("GRIDSTYLE" . 998134) ("TICKFORMAT" . 997801) ("TICKINTERVAL" . 997808) ("TICKLAYOUT" . 1012924) ("TICKUNITS" . 1012962)) (link "sysvars7.html#wp997657"))
    ("Y" (tags ("TITLE" . 997839) ("TYPE" . 997842) ("STYLE" . 997742) ("TICKS" . 999577) ("TICKLEN" . 1012793) ("THICK" . 997798) ("RANGE" . 997713) ("CRANGE" . 997670) ("S" . 997736) ("MARGIN" . 997689) ("OMARGIN" . 997702) ("WINDOW" . 997845) ("REGION" . 997724) ("CHARSIZE" . 1012787) ("MINOR" . 997699) ("TICKV" . 997833) ("TICKNAME" . 997811) ("GRIDSTYLE" . 998134) ("TICKFORMAT" . 997801) ("TICKINTERVAL" . 997808) ("TICKLAYOUT" . 1012924) ("TICKUNITS" . 1012962)) (link "sysvars7.html#wp997657"))
    ("Z" (tags ("TITLE" . 997839) ("TYPE" . 997842) ("STYLE" . 997742) ("TICKS" . 999577) ("TICKLEN" . 1012793) ("THICK" . 997798) ("RANGE" . 997713) ("CRANGE" . 997670) ("S" . 997736) ("MARGIN" . 997689) ("OMARGIN" . 997702) ("WINDOW" . 997845) ("REGION" . 997724) ("CHARSIZE" . 1012787) ("MINOR" . 997699) ("TICKV" . 997833) ("TICKNAME" . 997811) ("GRIDSTYLE" . 998134) ("TICKFORMAT" . 997801) ("TICKINTERVAL" . 997808) ("TICKLAYOUT" . 1012924) ("TICKUNITS" . 1012962)) (link "sysvars7.html#wp997657"))))


(defvar idlwave-system-class-info
  '(
    ("IDLgrContour" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "ALPHACHANNEL" "CLIP_PLANES" "COLOR" "DEPTH_TEST_DISABLE" "DEPTH_TEST_FUNCTION" "DEPTH_WRITE_DISABLE" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRCONTOUR_TOP" "IDLGRCONTOURVERSION" "AM_PM" "ANISOTROPY" "DATA_FORMAT" "DATA" "DAYS_OF_WEEK" "GEOM_FORMAT" "GEOM" "CONTOURFLAGS" "C_COLOR" "C_FILLPATTERN" "C_LABEL_INTERVAL" "C_LABEL_NOGAPS" "C_LABEL_OBJECTS" "C_LABEL_SHOW" "C_LINESTYLE" "C_THICK" "C_USE_LABEL_COLOR" "C_USE_LABEL_ORIENTATION" "C_VALUE" "LABEL_DEFAULTS" "LABEL_FONT" "LABEL_FORMAT" "LABEL_FRMTDATA" "LABEL_UNITS" "LABEL_UNIT_CODE" "MAXVAL" "MINVAL" "MONTHS" "NLEVELS" "POLYGONS" "SHADERANGE" "SHADING" "TICKINTERVAL" "TICKLEN" "PRECISIONDATA" "PRECISIONGEOM" "PRECISIONGRAPH" "LEVELINFO" "CFILL1" "DEPTHOFFSET" "MAPINFO" "IDLGRCONTOUR_BOTTOM") (inherits "IDLitComponent") (link "objects_gr43.html"))
    ("IDLgrAxis" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "ALPHACHANNEL" "CLIP_PLANES" "COLOR" "DEPTH_TEST_DISABLE" "DEPTH_TEST_FUNCTION" "DEPTH_WRITE_DISABLE" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRAXIS_TOP" "IDLGRAXISVERSION" "AM_PM" "AXIS_TYPE" "CALCFLAGS" "DAYS_OF_WEEK" "DIRECTION" "AXISFLAGS" "GRIDSTYLE" "LOCATION" "MAJOR" "MINOR" "MONTHS" "OUTRANGE" "RANGE" "SUBTICKLEN" "TEXTALIGNMENTS" "TEXTBASELINE" "TEXTUPDIR" "THICK" "TICKDIR" "TICKFORMAT" "ARRAY_TICKFORMAT" "TICKFRMTDATA" "TICKINTERVAL" "TICKLAYOUT" "TICKLEN" "TICKTEXT" "TICKUNITCODES" "TICKUNITS" "TICKVALUES" "TITLE" "CURRENT_LEVEL" "LEVEL_DATA" "STEPRANGEUNITS" "STEPRANGE" "IDLGRAXIS_BOTTOM") (inherits "IDLitComponent") (link "objects_gr3.html"))
    ("IDLitWindow" (tags "IDLITWINDOW_TOP" "IDLITWINDOWFLAGS" "EVENTMASK" "EVENTNOTIFIER" "SCENE" "PEVENTS" "IDLITWIN_FILL1" "PEVENTTAIL" "IDLITWIN_FILL2" "IDLITWINDOW_BOTTOM") (inherits "IDLgrWindow") (link "objects_it287.html"))
    ("IDLitVisualization" (tags "_BISMESSAGER" "_CLASSNAME" "_OCHILDREN" "_OPROPINTERSECTION" "_OAGGCHILDREN" "__$$__" "GEOMREFCOUNT" "CENTERROTATION" "IHAVECENTERROTATION" "IMPACTSRANGE" "ISSELECTED" "IS3D" "DIMMETHOD" "ISOTROPIC" "ISMANIPULATORTARGET" "_SELECTIONPAD" "OGROUPPARENT" "OCURRSELECTIONVISUAL" "_CREATEDDURINGINIT" "_OSELECTIONVISUAL" "_PSTRTYPE" "AXESREQUEST" "AXESMETHOD" "AXESSTYLEREQUEST" "DOREQUESTAXESSTYLE" "_BISDELETED") (inherits "IDLgrModel" "IDLitParameter" "IDLitIMessaging") (link "objects_it237.html"))
    ("IDLitManipulatorVisual" (tags "_BISMESSAGER" "_CLASSNAME" "_OCHILDREN" "_OPROPINTERSECTION" "_OAGGCHILDREN" "__$$__" "GEOMREFCOUNT" "CENTERROTATION" "IHAVECENTERROTATION" "IMPACTSRANGE" "ISSELECTED" "IS3D" "DIMMETHOD" "ISOTROPIC" "ISMANIPULATORTARGET" "_SELECTIONPAD" "OGROUPPARENT" "OCURRSELECTIONVISUAL" "_CREATEDDURINGINIT" "_OSELECTIONVISUAL" "_PSTRTYPE" "AXESREQUEST" "AXESMETHOD" "AXESSTYLEREQUEST" "DOREQUESTAXESSTYLE" "_STRVISUALTYPE" "_UNIFORMSCALE") (inherits "IDLgrModel" "IDLitIMessaging") (link "objects_it128.html"))
    ("IDLgrSurface" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "ALPHACHANNEL" "CLIP_PLANES" "COLOR" "DEPTH_TEST_DISABLE" "DEPTH_TEST_FUNCTION" "DEPTH_WRITE_DISABLE" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRSURFACE_TOP" "IDLGRSURFACEVERSION" "DATA" "PRECISION" "SKIRT" "VERTCOLORS" "BTMCOLOR" "AMBIENT" "DIFFUSE" "SPECULAR" "EMISSION" "SHININESS" "SURFACEFLAGS" "LINESTYLE" "MAXVALUE" "MINVALUE" "SHADING" "SHADERANGE" "STYLE" "NORMALS" "TXTRCOORD" "TXTRMAP" "TXTRHIGHRES" "THICK" "DEPTHOFFSET" "IDLGRSURFACE_BOTTOM") (inherits "IDLitComponent") (link "objects_gr173.html"))
    ("IDLgrLegend" (tags "OSCALENODE" "BORDER_GAP" "COLUMNS" "OOUTLINE" "OFILL" "OFONT" "GAP" "GLYPHWIDTH" "PITEM_COLOR" "PITEM_LINESTYLE" "PITEM_NAME" "PITEM_OBJECT" "PITEM_THICK" "PITEM_TYPE" "OTITLE" "PTEXT_COLOR" "BRECOMPUTE" "PGLYPHS" "PTEXTS" "HGLYPHWIDTH" "VGLYPHWIDTH" "COLORMODE" "CLEANLEAVE" "CLEANGLYPHS" "IDLGRLEGENDVERSION") (inherits "IDLgrModel") (link "objects_gr65.html"))
    ("IDLgrPolygon" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "ALPHACHANNEL" "CLIP_PLANES" "COLOR" "DEPTH_TEST_DISABLE" "DEPTH_TEST_FUNCTION" "DEPTH_WRITE_DISABLE" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRPOLYGON_TOP" "IDLGRPOLYGONVERSION" "DATA" "PRECISION" "FILLPATTERN" "POLYGONS" "NORMALS" "POLYGONFLAGS" "SHADING" "SHADERANGE" "STYLE" "TXTRCOORD" "TXTRMAP" "VERTCOLORS" "BTMCOLOR" "AMBIENT" "DIFFUSE" "SPECULAR" "EMISSION" "SHININESS" "LINESTYLE" "THICK" "DEPTHOFFSET" "IDLGRPOLYGON_BOTTOM") (inherits "IDLitComponent") (link "objects_gr124.html"))
    ("IDLgrWindow" (tags "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRWINDOW_TOP" "IDLGRWINDOWVERSION" "WINDOWFLAGS" "CURRENT_ZOOM" "DIMENSIONS" "DISPLAYNAME" "INDEX" "LOCATION" "MINIMUM_VIRTUAL_DIMENSIONS" "ORIGINAL_VIRTUAL_DIMENSIONS" "RENDERER" "RETAIN" "SCREENDIMENSIONS" "SELF" "TITLE" "UNITS" "VIRTUAL_DIMENSIONS" "VISIBLE_LOCATION" "ZOOM_BASE" "ZOOM_NSTEP" "EXTERNAL_WINDOW" "NEXT" "WFILL1" "PARENT" "WFILL2" "IDLGRWINDOW_BOTTOM") (inherits "IDLitComponent") (link "objects_gr235.html"))
    ("IDLgrPolyline" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "ALPHACHANNEL" "CLIP_PLANES" "COLOR" "DEPTH_TEST_DISABLE" "DEPTH_TEST_FUNCTION" "DEPTH_WRITE_DISABLE" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRPOLYLINE_TOP" "IDLGRPOLYLINEVERSION" "POLYLINEFLAGS" "DATA" "PRECISION" "LABEL_NOGAPS" "LABEL_OBJECTS" "LABEL_OFFSETS" "LABEL_POLYLINES" "LINESTYLE" "POLYLINES" "SYMBOL" "PSYMBOL" "THICK" "SHADING" "USE_LABEL_COLOR" "USE_LABEL_ORIENTATION" "VERTCOLORS" "LABEL_INFO" "FILL1" "IDLGRPOLYLINE_BOTTOM") (inherits "IDLitComponent") (link "objects_gr131.html"))
    ("IDLgrROI" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "ALPHACHANNEL" "CLIP_PLANES" "COLOR" "DEPTH_TEST_DISABLE" "DEPTH_TEST_FUNCTION" "DEPTH_WRITE_DISABLE" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRROI_TOP" "IDLGRROIVERSION" "LINESTYLE" "STYLE" "SYMBOL" "THICK" "IDLGRROI_BOTTOM") (inherits "IDLanROI" "IDLitComponent") (link "objects_gr150.html"))
    ("IDLitManipulatorManager" (tags "_OOLDCURR" "_ODEFAULT" "_OWINCURR" "_CURROBS") (inherits "IDLitManipulatorContainer") (link "objects_it121.html"))
    ("IDLgrVolume" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "ALPHACHANNEL" "CLIP_PLANES" "COLOR" "DEPTH_TEST_DISABLE" "DEPTH_TEST_FUNCTION" "DEPTH_WRITE_DISABLE" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRVOLUME_TOP" "IDLGRVOLUMEVERSION" "AMBIENT" "BOUNDS" "LIMITS" "DIMENSIONS" "COLORTABLE" "COMPOSITEFUNC" "CUTPLANES" "NUMCUTPLANES" "DEPTH_CUE" "OPACITYTABLE" "RENDERSTEP" "DATA" "EDM_VOLUME" "VOLUMEFLAGS" "IDLGRVOLUME_BOTTOM") (inherits "IDLitComponent") (link "objects_gr216.html"))
    ("IDLgrPlot" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "ALPHACHANNEL" "CLIP_PLANES" "COLOR" "DEPTH_TEST_DISABLE" "DEPTH_TEST_FUNCTION" "DEPTH_WRITE_DISABLE" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRPLOT_TOP" "IDLGRPLOTVERSION" "DATA" "PLOTFLAGS" "LINESTYLE" "PRECISION" "MAXVAL" "MINVAL" "NSUM" "SYMBOL" "PSYMBOL" "THICK" "VERTCOLORS" "ZVALUE" "LINEDATA" "PFILL1" "IDLGRPLOT_BOTTOM") (inherits "IDLitComponent") (link "objects_gr117.html"))
    ("IDLgrROIGroup" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "ALPHACHANNEL" "CLIP_PLANES" "COLOR" "DEPTH_TEST_DISABLE" "DEPTH_TEST_FUNCTION" "DEPTH_WRITE_DISABLE" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRROIGROUP_TOP" "IDLGRROIGROUPVERSION" "IDLGRROIGROUP_BOTTOM") (inherits "IDLanROIGroup" "IDLitComponent") (link "objects_gr157.html"))
    ("IDLgrText" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "ALPHACHANNEL" "CLIP_PLANES" "COLOR" "DEPTH_TEST_DISABLE" "DEPTH_TEST_FUNCTION" "DEPTH_WRITE_DISABLE" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRTEXT_TOP" "IDLGRTEXTVERSION" "TEXTFLAGS" "ALIGNMENT" "BASELINE" "CHAR_DIMENSIONS" "RECOMP_CTM" "FONT" "LOCATIONS" "STRINGS" "SUBPARENT" "UPDIR" "VERTICAL_ALIGNMENT" "FILL_COLOR" "RENDER_MODE" "IDLGRTEXT_BOTTOM") (inherits "IDLitComponent") (link "objects_gr193.html"))
    ("IDLitManipulatorContainer" (tags "_BISMESSAGER" "_CLASSNAME" "_OCHILDREN" "M_BAUTOSWITCH" "M_CURRMANIP") (inherits "IDLitManipulator" "IDL_Container") (link "objects_it107.html"))
    ("IDLgrColorbar" (tags "OCOORDCONVNODE" "OSCALENODE" "MAXDIM" "DIMENSIONS" "OAXIS" "OPOLY" "OSURF" "OIMAGE" "OPALETTE" "FREE_PALETTE" "SHOW_AXIS" "IDLGRCOLORBARVERSION") (inherits "IDLgrModel") (link "objects_gr36.html"))
    ("IDLitTool" (tags "__VOID" "_STRTOOLNAME" "_STRFILENAME" "_IDCURRENT" "_STRVERSION" "_STRWORKINGDIRECTORY" "_OSYSTEM" "_MANIPULATORS" "_OUISERVICECONN" "_OUICONNECTION" "_OWINDOW" "_COMMANDBUFFER" "_OLASTERROR" "_PDISPATCHTABLE" "_TYPES" "_STATUSBAR" "_IBUFFERLOCATION" "_IDISABLEUPDATES" "_NSELCHANGE" "_CURRSTATUSSEGMENTID" "_BNOREDRAW" "_BDIRTY" "_NOSAVEPROMPT" "_BUPDATEBYTYPE" "_BCHANGEDIRECTORY") (inherits "IDLitContainer" "IDLitIMessaging") (link "objects_it180.html"))
    ("IDLgrImage" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "ALPHACHANNEL" "CLIP_PLANES" "COLOR" "DEPTH_TEST_DISABLE" "DEPTH_TEST_FUNCTION" "DEPTH_WRITE_DISABLE" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRIMAGE_TOP" "IDLGRIMAGEVERSION" "CHANNEL" "DATA" "DIMENSIONS" "SUB_RECT" "IMAGEFLAGS" "LOCATION" "INTERLEAVE" "INTERPOLATE" "BLEND_FUNCTIONS" "IDLGRIMAGE_BOTTOM") (inherits "IDLitComponent") (link "objects_gr58.html"))
    ("IDLgrLight" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "ALPHACHANNEL" "CLIP_PLANES" "COLOR" "DEPTH_TEST_DISABLE" "DEPTH_TEST_FUNCTION" "DEPTH_WRITE_DISABLE" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRLIGHT_TOP" "IDLGRLIGHTVERSION" "ATTENUATION" "CONEANGLE" "DIRECTION" "FOCUS" "INTENSITY" "LOCATION" "TYPE" "IDLGRLIGHT_BOTTOM") (inherits "IDLitComponent") (link "objects_gr72.html"))
    ("IDLgrView" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRCONTAINER_TOP" "IDLGRCONTAINERVERSION" "ISDYING" "IDLGRCONTAINER_BOTTOM" "IDLGRVIEW_TOP" "IDLGRVIEWVERSION" "VIEWFLAGS" "COLOR" "DEPTH_CUE" "DIMENSIONS" "PRECISION" "EYE" "LOCATION" "OBLIQUE" "PROJECTION" "TRANSPARENT" "UNITS" "VIEW" "ZCLIP" "IDLGRVIEW_BOTTOM") (inherits "IDLitComponent" "IDL_Container") (link "objects_gr200.html"))
    ("IDLgrVRML" (tags "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRVRML_TOP" "IDLGRVRMLVERSION" "UNITS" "DIMENSIONS" "FILENAME" "WORLDINFO" "WORLDTITLE" "IDLGRVRML_BOTTOM") (inherits "IDLitComponent") (link "objects_gr225.html"))
    ("IDLgrClipboard" (tags "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRCLIPBOARD_TOP" "IDLGRCLIPBOARDVERSION" "UNITS" "DIMENSIONS" "FILENAME" "VECTOR" "POSTSCRIPT" "IDLGRCLIPBOARD_BOTTOM") (inherits "IDLitComponent") (link "objects_gr25.html"))
    ("IDLgrPrinter" (tags "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRPRINTER_TOP" "IDLGRPRINTERVERSION" "PRINTERFLAGS" "NCOPIES" "UNITS" "GAMMA" "IDLGRPRINTER_BOTTOM") (inherits "IDLitComponent") (link "objects_gr138.html"))
    ("IDLitManipulator" (tags "PSELECTIONLIST" "NSELECTIONLIST" "BUTTONPRESS" "_OCMDSET" "_TYPES" "_OHITVIS" "_OHITVIEWGROUP" "_PSUBHITLIST" "_STRVISUALTYPE" "_IDOPERATION" "_IDPARAMETER" "_DEFAULTCURSOR" "_SUBTYPE" "_STRTMPMSG" "_SKIPMACROHISTORY" "_TRANSMOTION" "_INTRANSMOTION" "_TRANSIENT" "_KEYTRANSIENT" "_DISABLE" "_VIEWMODE" "_UIEVENTMASK" "_OLDQUALITY" "_DRAQQUAL" "_NORMALIZEDZ") (inherits "IDLitComponent" "IDLitIMessaging") (link "objects_it91.html"))
    ("IDLgrModel" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRCONTAINER_TOP" "IDLGRCONTAINERVERSION" "ISDYING" "IDLGRCONTAINER_BOTTOM" "IDLGRMODEL_TOP" "IDLGRMODELVERSION" "MODELFLAGS" "CLIP_PLANES" "DEPTH_TEST_DISABLE" "DEPTH_TEST_FUNCTION" "DEPTH_WRITE_DISABLE" "TRANSFORM" "IDLGRMODEL_BOTTOM") (inherits "IDLitComponent" "IDL_Container") (link "objects_gr79.html"))
    ("IDLgrBuffer" (tags "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRBUFFER_TOP" "IDLGRBUFFERVERSION" "UNITS" "DIMENSIONS" "IDLGRBUFFER_BOTTOM") (inherits "IDLitComponent") (link "objects_gr10.html"))
    ("IDLitParameterSet" (tags "_PNAMES") (inherits "IDLitDataContainer") (link "objects_it159.html"))
    ("IDLitDataContainer" (tags "_ONOTIFIER" "_PDATA" "_PMETADATA" "_TYPE" "_AUTODELETE" "_NREF" "_PDESTRUCT" "_HIDE" "_READ_ONLY" "_IDISABLE" "_IUPDATES" "_BINSEARCH") (inherits "IDLitContainer") (link "objects_it59.html"))
    ("IDLgrScene" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRCONTAINER_TOP" "IDLGRCONTAINERVERSION" "ISDYING" "IDLGRCONTAINER_BOTTOM" "IDLGRSCENE_TOP" "IDLGRSCENEVERSION" "COLOR" "TRANSPARENT" "IDLGRSCENE_BOTTOM") (inherits "IDLitComponent" "IDL_Container") (link "objects_gr165.html"))
    ("IDLgrViewgroup" (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "PARENT" "IDLGRCOMPONENT_BOTTOM" "IDLGRCONTAINER_TOP" "IDLGRCONTAINERVERSION" "ISDYING" "IDLGRCONTAINER_BOTTOM" "IDLGRVIEWGROUP_TOP" "IDLGRVIEWGROUPVERSION" "IDLGRVIEWGROUP_BOTTOM") (inherits "IDLitComponent" "IDL_Container") (link "objects_gr208.html"))
    ("IDLitUI" (tags "_MENUBARS" "_TOOLBARS" "_STATUSBAR" "_UISERVICES" "_PDISPATCHSUBJECT" "_PDISPATCHOBSERVER" "_OTOOL" "_IDISPATCH" "_WBASE") (inherits "IDLitContainer") (link "objects_it222.html"))
    ("IDLitDataOperation" (tags "_NAN" "_WITHINUI" "_RECORDPROPERTIES") (inherits "IDLitOperation") (link "objects_it69.html"))
    ("IDLgrMPEG" (tags "IDLGRMPEG_TOP" "IDLGRMPEGVERSION" "DIMENSIONS" "FILENAME" "FORMAT" "FRAMERATE" "INTERLACED" "QUALITY" "SCALE" "STATISTICS" "DISPLAYDIMS" "FIRSTFRAME" "LASTFRAME" "MPEGID" "TEMPNODE" "TEMPNODEFILLER" "TEMP_DIRECTORY" "BITRATE" "IFRAME_GAP" "MOTION_LENGTH" "FLAGS" "IDLGRMPEG_BOTTOM") (link "objects_gr93.html"))
    ("IDLitCommandSet" (inherits "IDLitCommand" "IDL_Container") (link "objects_it12.html"))
    ("IDLitContainer" (tags "_BISMESSAGER" "_CLASSNAME" "_OCHILDREN") (inherits "IDLitComponent" "IDL_Container") (link "objects_it33.html"))
    ("IDLitOperation" (tags "_BEXPENSIVE" "_REVERSIBLE" "_BSHOWEXECUTIONUI" "_BSKIPHISTORY" "_BSKIPMACRO" "_BMACROSHOWUIIFNULLCMD" "_BMACROSUPPRESSREFRESH" "_TYPES") (inherits "IDLitComponent" "IDLitIMessaging") (link "objects_it134.html"))
    ("IDLitData" (tags "_ONOTIFIER" "_PDATA" "_PMETADATA" "_TYPE" "_AUTODELETE" "_NREF" "_PDESTRUCT" "_HIDE" "_READ_ONLY") (inherits "IDLitComponent") (link "objects_it44.html"))
    ("IDLitWriter" (tags "_TYPES" "_BITDEPTH" "_GRAPHICSFORMAT" "_SCALEFACTOR") (inherits "IDLitReader") (link "objects_it311.html"))
    ("IDLdbRecordset" (tags "IDLDBRECORDSET_TOP" "IDLDBRECORDSETVERSION" "ISTABLE" "PDBOBJ" "ISREADONLY" "NFIELDS" "CURROW" "SOURCE" "CURSORTYPE" "PFIELDS" "PSDEF" "ROWSTATUS" "ROWSET" "ROWPOS" "HSTMT" "HDBC" "IDLDBRECORDSET_BOTTOM") (link "api14.html"))
    ("IDLffLangCat" (tags "FILENAMES" "_AVAILABLE_FILES" "LANGUAGE" "DEFAULT_LANGUAGE" "APPLICATIONS" "APPLICATION_PATH" "KEYS" "N_KEYS" "STRINGS" "DEF_KEYS" "N_DEF_KEYS" "DEF_STRINGS" "AVAILABLE_LANGUAGES" "VERBOSE" "STRICT" "IDLFFLANGCATVERSION") (link "objects_ff44.html"))
    ("IDLitCommand" (tags "_PDATADICTIONARY" "_SIZEITEMS" "_STRIDTARGET" "_STRIDOPERATION") (inherits "IDLitComponent") (link "objects_it3.html"))
    ("IDLdbDatabase" (tags "IDLDBDATABASE_TOP" "IDLDBDATABASEVERSION" "READONLY" "ISCONNECTED" "FETCHDIR" "POSOPS" "POSSTATEMENTS" "SCROLLCONCUR" "SCROLLOPTIONS" "STATICSENSE" "GETDATAEXT" "USINGCURSOR" "NSTATEMENTS" "P_RECOBJS" "HDBC" "IDLDBDATABASE_BOTTOM") (link "api6.html"))
    ("IDLitReader" (tags "_STRFILENAME" "_PEXTENSIONS") (inherits "IDLitComponent" "IDLitIMessaging") (link "objects_it169.html"))
    ("IDLanROI" (tags "IDLANROI_TOP" "IDLANROIVERSION" "IDLANROIFLAGS" "NALLOCVERTS" "NUSEDVERTS" "BLOCKSIZE" "DATA" "TYPE" "PRECISION" "PLANE" "ROI_XRANGE" "ROI_YRANGE" "ROI_ZRANGE" "IDLANROI_BOTTOM") (link "objects_an3.html"))
    ("IDLanROIGroup" (tags "IDLANROIGROUP_TOP" "IDLANROIGROUPVERSION" "IDLANROIGROUPFLAGS" "ROIGROUP_XRANGE" "ROIGROUP_YRANGE" "ROIGROUP_ZRANGE" "IDLANROIGROUP_BOTTOM") (inherits "IDL_Container") (link "objects_an18.html"))
    ("IDLffXMLDOMDocument" (tags "IDLFFXMLDOMDOCUMENT_TOP" "_DOM_IMPLEMENTATION" "_DOM_PARSER" "_DOM_ERROR_REPORTER" "_DOM_MEMORY_MANAGER" "IDLFFXMLDOMDOCUMENT_BOTTOM") (inherits "IDLffXMLDOMText") (link "objects_ff102.html"))
    ("IDLgrPalette" (tags "IDLGRPALETTE_TOP" "IDLGRPALETTE_SERIALNUM" "IDLGRPALETTEVERSION" "GAMMA" "BOTTOMSTRETCH" "TOPSTRETCH" "NENTRIES" "ORIGLUT" "CURRLUT" "INVTABLE" "UVALUE" "NAME" "IDLGRPALETTE_BOTTOM") (link "objects_gr101.html"))
    ("IDLitComponent" (tags "IDLITCOMPONENT_TOP" "IDLITCOMPONENTVERSION" "DESCRIPTION" "NAME" "ICON" "IDENTIFIER" "HELP" "UVALUE" "_PARENT" "PROPERTYDESCRIPTORS" "_FLAGS" "IDLITCOMPONENT_BOTTOM") (link "objects_it17.html"))
    ("IDLgrSymbol" (tags "IDLGRSYMBOL_TOP" "IDLGRSYMBOLVERSION" "COLOR" "DATA" "SIZE" "THICK" "FLAGS" "UVALUE" "NAME" "ALPHA_CHANNEL" "IDLGRSYMBOL_BOTTOM") (link "objects_gr180.html"))
    ("IDLgrFont" (tags "IDLGRFONT_TOP" "IDLGRFONTVERSION" "FONTFLAGS" "HERSHEY" "NAME" "SIZE" "SUBSTITUTE" "THICK" "ID" "UVALUE" "IDLGRFONT_BOTTOM") (link "objects_gr52.html"))
    ("IDLgrPattern" (tags "IDLGRPATTERN_TOP" "IDLGRPATTERNVERSION" "ORIENTATION" "PATTERN" "SPACING" "STYLE" "THICK" "UVALUE" "NAME" "IDLGRPATTERN_BOTTOM") (link "objects_gr111.html"))
    ("IDLffDXF" (tags "IDLFFDXF_TOP" "IDLFFDXFVERSION" "DXFREADVALID" "DXFHANDLEVALID" "DXFLUT" "SERIAL" "DXFHANDLE" "DXFHANDLEFILLER" "IDLFFDXF_BOTTOM") (link "objects_ff21.html"))
    ("IDLffShape" (tags "IDLFFSHAPE_TOP" "IDLFFSHAPEVERSION" "FILENAME" "ISOPEN" "SHPTYPE" "PATTRIBUTE" "SHAPEHANDLE" "DBFHANDLE" "IDLFFSHAPE_BOTTOM") (link "objects_ff59.html"))
    ("IDLffXMLSAX" (tags "IDLFFXMLSAX_TOP" "IDLFFXMLSAXVERSION" "VALIDATION_MODE" "HALT_PROCESSING" "FILENAME" "_XML_PARSER" "_XML_LOCATOR" "IDLFFXMLSAX_BOTTOM") (link "objects_ff209.html"))
    ("TrackBall" (tags "BTNDOWN" "AXIS" "CONSTRAIN" "MOUSE" "CENTER" "RADIUS" "PT0" "PT1") (link "objects_misc33.html"))
    ("IDLgrTessellator" (tags "IDLGRTESSELLATOR_TOP" "IDLGRTESSELLATORVERSION" "ITESSFLAGS" "IVERTS" "HVIDLIST" "IAUXSIZE" "IAUXTYPE" "IDLGRTESSELLATOR_BOTTOM") (link "objects_gr186.html"))
    ("IDLffDICOM" (tags "IDLFFDICOM_TOP" "IDLFFDICOMVERSION" "DICOMFLAGS" "DICOMELEMENTS" "DICOMPREAMBLE" "DICOMHANDLE" "DICOMHANDLEFILLER" "IDLFFDICOM_BOTTOM") (link "objects_ff3.html"))
    ("IDLffXMLDOMText" (inherits "IDLffXMLDOMProcessingInstruction") (link "objects_ff203.html"))
    ("IDLffXMLDOMProcessingInstruction" (inherits "IDLffXMLDOMAttr") (link "objects_ff196.html"))
    ("IDLffXMLDOMAttr" (inherits "IDLffXMLDOMElement") (link "objects_ff74.html"))
    ("IDLffXMLDOMElement" (inherits "IDLffXMLDOMNode") (link "objects_ff130.html"))
    ("IDLffXMLDOMNamedNodeMap" (tags "IDLFFXMLDOMNAMEDNODEMAP_TOP" "IDLFFXMLDOMNAMEDNODEMAPVERSION" "_IDLFFXMLDOMNAMEDNODEMAPNODE" "_IDLFFXMLDOMNAMEDNODEMAPOWNEDNODES" "_IDLFFXMLDOMNAMEDNODEMAPOWNER" "_IDLFFXMLDOMNAMEDNODEMAPDOCUMENT" "IDLFFXMLDOMNAMEDNODEMAP_BOTTOM") (link "objects_ff153.html"))
    ("IDLffXMLDOMNode" (inherits "IDLffXMLDOMNotation") (link "objects_ff162.html"))
    ("IDLffXMLDOMNotation" (inherits "IDLffXMLDOMCharacterData") (link "objects_ff190.html"))
    ("IDLffXMLDOMNodeList" (tags "IDLFFXMLDOMNODELIST_TOP" "IDLFFXMLDOMNODELISTVERSION" "_IDLFFXMLDOMNODELISTNODE" "_IDLFFXMLDOMNODELISTOWNEDNODES" "_IDLFFXMLDOMNODELISTOWNER" "_IDLFFXMLDOMNODELISTDOCUMENT" "IDLFFXMLDOMNODELIST_BOTTOM") (link "objects_ff184.html"))
    ("IDLffXMLDOMCharacterData" (inherits "IDLffXMLDOMEntity") (link "objects_ff86.html"))
    ("IDLffXMLDOMEntity" (inherits "IDLffXMLDOMDocumentType") (link "objects_ff142.html"))
    ("IDLffXMLDOMDocumentType" (tags "IDLFFXMLDOMNODE_TOP" "IDLFFXMLDOMNODEVERSION" "_IDLFFXMLDOMNODEDOMNODE" "_IDLFFXMLDOMNODEOWNEDNODES" "_IDLFFXMLDOMNODEOWNER" "_IDLFFXMLDOMNODEDOCUMENT" "IDLFFXMLDOMNODE_BOTTOM") (link "objects_ff123.html"))
    ("IDL_Container" (tags "IDL_CONTAINER_TOP" "IDLCONTAINERVERSION" "PHEAD" "PTAIL" "NLIST" "IDL_CONTAINER_BOTTOM") (link "objects_misc3.html"))
    ("IDLffJPEG2000" (tags "IDLFFJPEG2000_TOP" "CJPEG2000PTR" "IDLFFJPEG2000_BOTTOM") (link "objects_ff34.html"))
    ("IDLitParameter" (tags "_OPARAMETERDESCRIPTORS" "_OPARAMETERSET" "_PPARAMNAMES") (link "objects_it145.html"))
    ("IDL_Savefile" (tags "IDL_SAVEFILE_FILENAME" "IDL_SAVEFILE_RELAXED_STRUCTURE_ASSIGNMENT") (link "objects_misc13.html"))
    ("IDLitIMessaging" (tags "__OTOOL") (link "objects_it78.html"))
    ("IDLcomIDispatch" (link "objects_misc23.html"))
    ("IDLffMrSID" (link "objects_ff52.html"))
    ("IDLjavaObject" (link "objects_misc28.html"))))


(defvar idlwave-executive-commands-alist '(
    ("RESET_SESSION" . "symbols8.html")
    ("TRACE" . "symbols15.html")
    ("RNEW" . "symbols10.html")
    ("EDIT" . "symbols4.html")
    ("STEPOVER" . "symbols14.html")
    ("OUT" . "symbols7.html")
    ("RUN" . "symbols11.html")
    ("CONTINUE" . "symbols3.html")
    ("STEP" . "symbols13.html")
    ("RETURN" . "symbols9.html")
    ("GO" . "symbols6.html")
    ("SKIP" . "symbols12.html")
    ("FULL_RESET_SESSION" . "symbols5.html")
    ("COMPILE" . "symbols2.html")
))

;; Special words with associated help topic files
(defconst idlwave-help-special-topic-words
  '(
    ("begin" . "B2.html")
    ("case" . "C8.html")
    ("endcase" . "C8.html")
    ("of" . "C8.html")
    ("common" . "C29.html")
    ("compile_opt" . "C30.html")
    ("continue" . "C39.html")
    ("endfor" . "F31.html")
    ("for" . "F31.html")
    ("else" . "I6.html")
    ("endelse" . "I6.html")
    ("endif" . "I6.html")
    ("if" . "I6.html")
    ("then" . "I6.html")
    ("end" . "P28.html")
    ("pro" . "P28.html")
    ("endrep" . "R41.html")
    ("repeat" . "R41.html")
    ("until" . "R41.html")
    ("return" . "R48.html")
    ("endswitch" . "S82.html")
    ("switch" . "S82.html")
    ("do" . "W8.html")
    ("endwhile" . "W8.html")
    ("while" . "W8.html")
)
  "Association list of help files for special context words.")

(provide 'idlw-rinfo)
(provide 'idlwave-rinfo)

;; arch-tag: d0b65da3-7f5e-4992-b8dd-885800b5cd6b
;;; idlw-rinfo.el ends here
