#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 11;
use EmailReminder::EventList;

my $strs = [
    '5-a-side',
    '5-a-side',
    'Christmas Day',
    'New Year\'s Day',
    '9th anniversary of My Sister and Bro in Law',
    '13th anniversary of My Brother and Sis in Law',
    'PayDay',
    'Clean the House',
    'Sister\'s birthday',
    'Bro\'s birthday',
    'Friend\'s birthday',
];

# tests
my $events = EmailReminder::EventList->new('t/data.xml', 1);

# loop through all the events themselves
my $i = 0;
foreach my $event ($events->get_events()) {
    is($event->get_subject, $strs->[$i], "event subject ($i)");
    $i++;
}
