#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 14;

use EmailReminder::EventList;
use EmailReminder::Event;

# load the data in
my $er_orig = EmailReminder::EventList->new('t/data.xml', 1);

# save it out again
my $tmp_file = "/tmp/data_$$.xml";
$er_orig->save(0, $tmp_file);

# load it back and compare all elements
my $er_new = EmailReminder::EventList->new($tmp_file, 1);

# compare top level info
is($er_orig->_get_user_fname, $er_new->_get_user_fname, 'fname');
is($er_orig->_get_user_lname, $er_new->_get_user_lname, 'lname');
is($er_orig->get_user_email, $er_new->get_user_email, 'email');

# compare all the events and make sure they are the same too
my @events_orig = $er_orig->get_events();
my @events_new = $er_new->get_events();

for ( my $i = 0; $i < @events_orig; $i++ ) {
    is($events_orig[$i], $events_new[$i], "event $i");
}
