/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class JembossParams {
    public static final int SERVER_OK = 0;
    public static final int SERVER_ERR = 1;
    public static final int SERVER_DOWN = 2;
    static final String fs = System.getProperty("file.separator");
    private boolean useHTTPSProxy;
    private String useHTTPSProxyName;
    private boolean useProxy;
    private String useProxyName;
    private String proxyHost;
    private String proxyHostName;
    private int proxyPortNum;
    private String proxyPortNumName;
    private boolean useBrowserProxy;
    private String useBrowserProxyName;
    private String browserProxyHost;
    private String browserProxyHostName;
    private int browserProxyPort;
    private String browserProxyPortName;
    private boolean useTFM;
    private String useTFMName;
    private boolean useProxyAuth;
    private String useProxyAuthName;
    private String proxyAuthUser;
    private String proxyAuthUserName;
    private String proxyAuthPasswd;
    private String proxyAuthPasswdName;
    private boolean proxyOverride;
    private String proxyOverrideName;
    private boolean useAuth;
    private String useAuthName;
    private String publicSoapURL;
    private String publicSoapURLName;
    private String privateSoapURL;
    private String privateSoapURLName;
    private String soapService;
    private String soapServiceName;
    private String privateSoapService;
    private String privateSoapServiceName;
    private String publicSoapService;
    private String publicSoapServiceName;
    private boolean debug;
    private String debugName;
    private boolean hasBatchMode;
    private String hasBatchModeName;
    private boolean hasInteractiveMode;
    private String hasInteractiveModeName;
    private String currentMode;
    private String currentModeName;
    private String serverPublicList;
    private String serverPublicListName;
    private String serverPrivateList;
    private String serverPrivateListName;
    private String serviceUserName;
    private String serviceUserNameName;
    private char[] servicePasswd;
    private byte[] servicePasswdByte;
    Properties jembossSettings;
    private boolean useJavaProxy;
    private String javaProxyPort;
    private String javaProxyHost;
    private boolean useJavaNoProxy;
    private String javaNoProxy;
    private Vector javaNoProxyEntries;
    private int javaProxyPortNum;
    private boolean publicServerFailOver;
    private boolean privateServerFailOver;
    private Hashtable serverStatusHash;
    private Vector publicServers;
    private Vector privateServers;
    private static boolean jembossServer = false;
    private String jembossServerName;
    private static String cygwin = null;
    private String cygwinName;
    private String plplot;
    private String plplotName;
    private String embossData;
    private String embossDataName;
    private String embossBin;
    private String embossBinName;
    private String embossPath;
    private String embossPathName;
    private String embossEnvironment;
    private String embossEnvironmentName;
    private String acdDirToParse;
    private String acdDirToParseName;
    private String embURL;
    private String embossURL;
    private String userHome;
    private String userHomeName;
    private String resultsHome;
    private String resultsHomeName;

    public JembossParams() {
        block6: {
            this.useHTTPSProxy = false;
            this.useHTTPSProxyName = "useHTTPSProxy";
            this.useProxy = false;
            this.useProxyName = "proxy.use";
            this.proxyHost = "wwwcache";
            this.proxyHostName = "proxy.host";
            this.proxyPortNum = 8080;
            this.proxyPortNumName = "proxy.port";
            this.useBrowserProxy = false;
            this.useBrowserProxyName = "browserProxy.use";
            this.browserProxyHost = "wwwcache";
            this.browserProxyHostName = "browserProxy.host";
            this.browserProxyPort = 8080;
            this.browserProxyPortName = "browserProxy.port";
            this.useTFMName = "tfm.use";
            this.useProxyAuth = false;
            this.useProxyAuthName = "proxy.auth";
            this.proxyAuthUser = "";
            this.proxyAuthUserName = "proxy.user";
            this.proxyAuthPasswd = "";
            this.proxyAuthPasswdName = "proxy.passwd";
            this.proxyOverride = false;
            this.proxyOverrideName = "proxy.override";
            this.useAuth = true;
            this.useAuthName = "user.auth";
            this.publicSoapURL = "https://jemboss.hgmp.mrc.ac.uk:8443/axis/services";
            this.publicSoapURLName = "server.public";
            this.privateSoapURL = "https://jemboss.hgmp.mrc.ac.uk:8443/axis/services";
            this.privateSoapURLName = "server.private";
            this.soapService = "EmbossSoap";
            this.soapServiceName = "service.name";
            this.privateSoapService = "JembossAuthServer";
            this.privateSoapServiceName = "service.private";
            this.publicSoapService = "JembossAuthServer";
            this.publicSoapServiceName = "service.public";
            this.debug = false;
            this.debugName = "jemboss.debug";
            this.hasBatchMode = true;
            this.hasBatchModeName = "jemboss.hasbatchmode";
            this.hasInteractiveMode = true;
            this.hasInteractiveModeName = "jemboss.hasinteractivemode";
            this.currentMode = "interactive";
            this.currentModeName = "jemboss.mode";
            this.serverPublicList = "";
            this.serverPublicListName = "server.publiclist";
            this.serverPrivateList = "";
            this.serverPrivateListName = "server.privatelist";
            this.serviceUserName = "";
            this.serviceUserNameName = "user.name";
            this.servicePasswd = null;
            this.servicePasswdByte = null;
            this.useJavaProxy = false;
            this.javaProxyPort = "";
            this.javaProxyHost = "";
            this.useJavaNoProxy = false;
            this.javaNoProxy = "";
            this.javaProxyPortNum = 8080;
            this.publicServerFailOver = false;
            this.privateServerFailOver = false;
            this.jembossServerName = "jemboss.server";
            this.cygwinName = "cygwin";
            this.plplot = "/usr/local/share/EMBOSS/";
            this.plplotName = "plplot";
            this.embossData = "/usr/local/share/EMBOSS/data/";
            this.embossDataName = "embossData";
            this.embossBin = "/usr/local/bin/";
            this.embossBinName = "embossBin";
            this.embossPath = "/usr/bin/:/bin";
            this.embossPathName = "embossPath";
            this.embossEnvironment = "";
            this.embossEnvironmentName = "embossEnvironment";
            this.acdDirToParse = "/usr/local/share/EMBOSS/acd/";
            this.acdDirToParseName = "acdDirToParse";
            this.embURL = "http://www.uk.embnet.org/Software/EMBOSS/Apps/";
            this.embossURL = "embossURL";
            this.userHome = System.getProperty("user.home");
            this.userHomeName = "user.home";
            this.resultsHome = System.getProperty("user.home") + fs + "jemboss";
            this.resultsHomeName = "results.home";
            Properties defaults = new Properties();
            ClassLoader cl = this.getClass().getClassLoader();
            this.serverStatusHash = new Hashtable();
            this.publicServers = new Vector();
            this.privateServers = new Vector();
            defaults.put(this.userHomeName, this.userHome);
            defaults.put(this.resultsHomeName, this.resultsHome);
            defaults.put(this.embossURL, this.embURL);
            defaults.put(this.plplotName, this.plplot);
            defaults.put(this.embossDataName, this.embossData);
            defaults.put(this.embossBinName, this.embossBin);
            defaults.put(this.embossPathName, this.embossPath);
            defaults.put(this.embossEnvironmentName, this.embossEnvironment);
            defaults.put(this.acdDirToParseName, this.acdDirToParse);
            defaults.put(this.useBrowserProxyName, new Boolean(this.useBrowserProxy).toString());
            defaults.put(this.browserProxyHostName, this.browserProxyHost);
            defaults.put(this.browserProxyPortName, new Integer(this.browserProxyPort).toString());
            defaults.put(this.useTFMName, new Boolean(this.useTFM).toString());
            defaults.put(this.useProxyName, new Boolean(this.useProxy).toString());
            defaults.put(this.useHTTPSProxyName, new Boolean(this.useHTTPSProxy).toString());
            defaults.put(this.proxyHostName, this.proxyHost);
            defaults.put(this.proxyPortNumName, new Integer(this.proxyPortNum).toString());
            defaults.put(this.useProxyAuthName, new Boolean(this.useProxyAuth).toString());
            defaults.put(this.proxyAuthUserName, this.proxyAuthUser);
            defaults.put(this.proxyAuthPasswdName, this.proxyAuthPasswd);
            defaults.put(this.proxyOverrideName, new Boolean(this.proxyOverride).toString());
            defaults.put(this.useAuthName, new Boolean(this.useAuth).toString());
            defaults.put(this.publicSoapURLName, this.publicSoapURL);
            defaults.put(this.privateSoapURLName, this.privateSoapURL);
            defaults.put(this.privateSoapServiceName, this.privateSoapService);
            defaults.put(this.publicSoapServiceName, this.publicSoapService);
            defaults.put(this.debugName, new Boolean(this.debug).toString());
            defaults.put(this.hasBatchModeName, new Boolean(this.hasBatchMode).toString());
            defaults.put(this.hasInteractiveModeName, new Boolean(this.hasInteractiveMode).toString());
            defaults.put(this.currentModeName, this.currentMode);
            defaults.put(this.serverPublicListName, this.serverPublicList);
            defaults.put(this.serverPrivateListName, this.serverPrivateList);
            defaults.put(this.serviceUserNameName, this.serviceUserName);
            this.jembossSettings = new Properties(defaults);
            try {
                this.jembossSettings.load(cl.getResourceAsStream("resources/jemboss.properties"));
            }
            catch (Exception e) {
                if (!this.debug) break block6;
                System.out.println("Didn't find properties file in classpath.");
            }
        }
        this.loadIn(System.getProperty("user.dir"));
        this.loadIn(System.getProperty("user.home"));
        this.updateSettingsFromProperties();
        if (System.getProperty("useHTTPSProxy") != null && System.getProperty("useHTTPSProxy").equalsIgnoreCase("true")) {
            this.useHTTPSProxy = true;
        }
        this.javaNoProxyEntries = new Vector();
        if (System.getProperty("proxyPort") != null && System.getProperty("proxyHost") != null) {
            this.useProxy = this.useJavaProxy = true;
            this.useBrowserProxy = this.useJavaProxy;
            this.javaProxyPort = System.getProperty("proxyPort");
            this.javaProxyPortNum = Integer.parseInt(this.javaProxyPort);
            this.browserProxyHost = this.javaProxyHost = System.getProperty("proxyHost");
            this.browserProxyPort = this.javaProxyPortNum;
            if (System.getProperty("http.nonProxyHosts") != null) {
                this.useJavaNoProxy = true;
                this.javaNoProxy = System.getProperty("http.nonProxyHosts");
                StringTokenizer tok = new StringTokenizer(this.javaNoProxy, "|");
                while (tok.hasMoreTokens()) {
                    String toks = tok.nextToken() + "/";
                    this.javaNoProxyEntries.add(toks);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIn(String folder) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(folder + fs + "jemboss.properties");
            this.jembossSettings.load(in);
        }
        catch (FileNotFoundException e) {
            in = null;
            if (this.debug) {
                System.out.println("Can't find properties file in" + folder + "." + " Using defaults.");
            }
        }
        catch (IOException e) {
            if (this.debug) {
                System.out.println("Can't read properties file. Using defaults.");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
                in = null;
            }
        }
    }

    protected void updateSettingsFromProperties() {
        try {
            this.userHome = this.jembossSettings.getProperty(this.userHomeName);
            this.resultsHome = this.jembossSettings.getProperty(this.resultsHomeName);
            this.embURL = this.jembossSettings.getProperty(this.embossURL);
            this.plplot = this.jembossSettings.getProperty(this.plplotName);
            this.embossData = this.jembossSettings.getProperty(this.embossDataName);
            this.embossBin = this.jembossSettings.getProperty(this.embossBinName);
            if (this.embossBin.length() > 0 && !this.embossBin.endsWith(fs)) {
                this.embossBin = this.embossBin + fs;
            }
            this.embossPath = this.jembossSettings.getProperty(this.embossPathName);
            this.embossEnvironment = this.jembossSettings.getProperty(this.embossEnvironmentName);
            this.acdDirToParse = this.jembossSettings.getProperty(this.acdDirToParseName);
            String tmp = this.jembossSettings.getProperty(this.jembossServerName);
            jembossServer = new Boolean(tmp);
            cygwin = this.jembossSettings.getProperty(this.cygwinName);
            tmp = this.jembossSettings.getProperty(this.useHTTPSProxyName);
            this.useHTTPSProxy = new Boolean(tmp);
            tmp = this.jembossSettings.getProperty(this.useProxyName);
            this.useProxy = new Boolean(tmp);
            this.proxyHost = this.jembossSettings.getProperty(this.proxyHostName);
            tmp = this.jembossSettings.getProperty(this.proxyPortNumName);
            this.proxyPortNum = Integer.parseInt(tmp);
            tmp = this.jembossSettings.getProperty(this.useBrowserProxyName);
            this.useBrowserProxy = new Boolean(tmp);
            this.browserProxyHost = this.jembossSettings.getProperty(this.browserProxyHostName);
            tmp = this.jembossSettings.getProperty(this.browserProxyPortName);
            this.browserProxyPort = Integer.parseInt(tmp);
            tmp = this.jembossSettings.getProperty(this.useTFMName);
            this.useTFM = new Boolean(tmp);
            tmp = this.jembossSettings.getProperty(this.useProxyAuthName);
            this.useProxyAuth = new Boolean(tmp);
            this.proxyAuthUser = this.jembossSettings.getProperty(this.proxyAuthUserName);
            this.proxyAuthPasswd = this.jembossSettings.getProperty(this.proxyAuthPasswdName);
            tmp = this.jembossSettings.getProperty(this.proxyOverrideName);
            this.proxyOverride = new Boolean(tmp);
            tmp = this.jembossSettings.getProperty(this.useAuthName);
            this.useAuth = new Boolean(tmp);
            this.publicSoapURL = this.jembossSettings.getProperty(this.publicSoapURLName);
            this.privateSoapURL = this.jembossSettings.getProperty(this.privateSoapURLName);
            this.soapService = this.jembossSettings.getProperty(this.soapServiceName);
            this.privateSoapService = this.jembossSettings.getProperty(this.privateSoapServiceName);
            this.publicSoapService = this.jembossSettings.getProperty(this.publicSoapServiceName);
            tmp = this.jembossSettings.getProperty(this.debugName);
            this.debug = new Boolean(tmp);
            tmp = this.jembossSettings.getProperty(this.hasBatchModeName);
            this.hasBatchMode = new Boolean(tmp);
            tmp = this.jembossSettings.getProperty(this.hasInteractiveModeName);
            this.hasInteractiveMode = new Boolean(tmp);
            this.currentMode = this.jembossSettings.getProperty(this.currentModeName);
            this.serverPublicList = this.jembossSettings.getProperty(this.serverPublicListName);
            this.serverPrivateList = this.jembossSettings.getProperty(this.serverPrivateListName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setupServerRedundancy() {
        String toks;
        StringTokenizer tok;
        if (!this.serverPublicList.equals("")) {
            if (this.debug) {
                System.out.println("JembossParams: Redundant public servers\n  " + this.serverPublicList);
            }
            this.publicServerFailOver = true;
            tok = new StringTokenizer(this.serverPublicList, "|");
            while (tok.hasMoreTokens()) {
                toks = tok.nextToken();
                this.publicServers.add(toks);
                if (this.debug) {
                    System.out.println(" Entry " + toks);
                }
                this.serverStatusHash.put(toks, new Integer(0));
            }
        }
        if (!this.serverPrivateList.equals("")) {
            if (this.debug) {
                System.out.println("JembossParams: Redundant private servers\n  " + this.serverPrivateList);
            }
            this.privateServerFailOver = true;
            tok = new StringTokenizer(this.serverPrivateList, "|");
            while (tok.hasMoreTokens()) {
                toks = tok.nextToken();
                this.privateServers.add(toks);
                if (this.debug) {
                    System.out.println(" Entry " + toks);
                }
                this.serverStatusHash.put(toks, new Integer(0));
            }
        }
    }

    public boolean getUseProxy() {
        return this.useProxy;
    }

    public boolean getUseHTTPSProxy() {
        return this.useHTTPSProxy;
    }

    public boolean getUseProxy(String s) {
        if (this.proxyOverride) {
            return this.useProxy;
        }
        if (!this.useJavaProxy) {
            return this.useProxy;
        }
        boolean jp = true;
        if (this.useJavaNoProxy) {
            int ip = this.javaNoProxyEntries.size();
            for (int j = 0; j < ip; ++j) {
                if (s.indexOf(this.javaNoProxyEntries.get(j).toString()) == -1) continue;
                jp = false;
            }
        }
        return jp;
    }

    public String getProxyHost() {
        if (this.proxyOverride) {
            return this.proxyHost;
        }
        if (!this.useJavaProxy) {
            return this.proxyHost;
        }
        return this.javaProxyHost;
    }

    public int getProxyPortNum() {
        if (this.proxyOverride) {
            return this.proxyPortNum;
        }
        if (!this.useJavaProxy) {
            return this.proxyPortNum;
        }
        return this.javaProxyPortNum;
    }

    public boolean isBrowserProxy() {
        return this.useBrowserProxy;
    }

    public String getBrowserProxyHost() {
        return this.browserProxyHost;
    }

    public int getBrowserProxyPort() {
        return this.browserProxyPort;
    }

    public boolean isUseTFM() {
        return this.useTFM;
    }

    public boolean getUseProxyAuth() {
        return this.useProxyAuth;
    }

    public String getProxyAuthUser() {
        return this.proxyAuthUser;
    }

    public String getProxyAuthPasswd() {
        return this.proxyAuthPasswd;
    }

    public String proxyDescription() {
        String pdesc = "";
        if (this.proxyOverride) {
            if (this.useProxy) {
                String spnum = new Integer(this.proxyPortNum).toString();
                pdesc = "Current Settings: Proxy Host: " + this.proxyHost + " Proxy Port: " + spnum;
            } else {
                pdesc = "No proxies, connecting direct.";
            }
        } else if (this.useJavaProxy) {
            pdesc = "Settings Imported from Java: Proxy Host: " + this.javaProxyHost + " Proxy Port: " + this.javaProxyPort;
            if (this.useJavaNoProxy) {
                pdesc = pdesc + "\nNo Proxy On: " + this.javaNoProxy;
            }
        } else if (this.useProxy) {
            String spnum = new Integer(this.proxyPortNum).toString();
            pdesc = "Current Settings: Proxy Host: " + this.proxyHost + " Proxy Port: " + spnum;
        } else {
            pdesc = "No proxies, connecting direct.";
        }
        return pdesc;
    }

    public boolean getUseAuth() {
        return this.useAuth;
    }

    public String getPublicSoapURL() {
        return this.publicSoapURL;
    }

    public static boolean isJembossServer() {
        return jembossServer;
    }

    public static boolean isCygwin() {
        return cygwin != null && !cygwin.equals("");
    }

    public static String getCygwinRoot() {
        return cygwin;
    }

    public String getPlplot() {
        return this.plplot;
    }

    public String getUserHome() {
        return this.userHome;
    }

    public void setUserHome(String s) {
        this.userHome = s;
    }

    public String getResultsHome() {
        if (!this.resultsHome.endsWith(fs)) {
            this.resultsHome = this.resultsHome + fs;
        }
        return this.resultsHome;
    }

    public void setResultsHome(String s) {
        this.resultsHome = s;
    }

    public String getembURL() {
        return this.embURL;
    }

    public String getEmbossData() {
        return this.embossData;
    }

    public String getEmbossBin() {
        return this.embossBin;
    }

    public String getEmbossPath() {
        return this.embossPath;
    }

    public String getEmbossEnvironment() {
        this.embossEnvironment = this.embossEnvironment.trim();
        this.embossEnvironment = this.embossEnvironment.replace(':', ' ');
        this.embossEnvironment = this.embossEnvironment.replace(',', ' ');
        return this.embossEnvironment;
    }

    public String[] getEmbossEnvironmentArray(String[] envp) {
        this.embossEnvironment = this.embossEnvironment.trim();
        this.embossEnvironment = this.embossEnvironment.replace(',', ' ');
        if (this.embossEnvironment.equals("")) {
            return envp;
        }
        StringTokenizer st = new StringTokenizer(this.embossEnvironment, " ");
        int n = 0;
        while (st.hasMoreTokens()) {
            st.nextToken();
            ++n;
        }
        int sizeEnvp = envp.length;
        String[] environ = new String[n + sizeEnvp];
        st = new StringTokenizer(this.embossEnvironment, " ");
        for (int i = 0; i < sizeEnvp; ++i) {
            environ[i] = envp[i];
        }
        n = sizeEnvp;
        while (st.hasMoreTokens()) {
            environ[n] = new String(st.nextToken());
            ++n;
        }
        return environ;
    }

    public String getAcdDirToParse() {
        return this.acdDirToParse;
    }

    public void setPublicSoapURL(String s) {
        this.publicSoapURL = s;
    }

    public String getPrivateSoapURL() {
        return this.privateSoapURL;
    }

    public void setPrivateSoapURL(String s) {
        this.privateSoapURL = s;
    }

    public boolean getPublicServerFailover() {
        return this.publicServerFailOver;
    }

    public boolean getPrivateServerFailover() {
        return this.privateServerFailOver;
    }

    public Vector getPublicServers() {
        return this.publicServers;
    }

    public Vector getPrivateServers() {
        return this.privateServers;
    }

    public void setServerStatus(String server, int i) {
        this.serverStatusHash.put(server, new Integer(i));
    }

    public String getServiceUserName() {
        return this.serviceUserName;
    }

    public void setServiceUserName(String newUserName) {
        this.serviceUserName = newUserName;
    }

    public char[] getServicePasswd() {
        return this.servicePasswd;
    }

    public byte[] getServicePasswdByte() {
        return this.servicePasswdByte;
    }

    private static byte[] toByteArr(char[] ch) {
        int len = ch.length;
        byte[] msb = new byte[len];
        for (int i = 0; i < len; ++i) {
            msb[i] = (byte)ch[i];
        }
        return msb;
    }

    public void setServicePasswd(char[] newPasswd) {
        int csize = newPasswd.length;
        this.servicePasswd = new char[csize];
        for (int i = 0; i < csize; ++i) {
            this.servicePasswd[i] = newPasswd[i];
        }
        this.servicePasswdByte = JembossParams.toByteArr(newPasswd);
    }

    public String getSoapService() {
        return this.soapService;
    }

    public String getPrivateSoapService() {
        return this.privateSoapService;
    }

    public void setPrivateSoapService(String s) {
        this.privateSoapService = s;
    }

    public String getPublicSoapService() {
        return this.publicSoapService;
    }

    public void setPublicSoapService(String s) {
        this.publicSoapService = s;
    }

    public String serverDescription() {
        String serverdesc = "Current Settings:\nPublic Server: " + this.publicSoapURL + "\nPrivate Server: " + this.privateSoapURL + "\nPublic SOAP service: " + this.publicSoapService + "\nPrivate SOAP service: " + this.privateSoapService;
        return serverdesc;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean getHasBatchMode() {
        return this.hasBatchMode;
    }

    public boolean getHasInteractiveMode() {
        return this.hasInteractiveMode;
    }

    public String getCurrentMode() {
        if (this.hasInteractiveMode) {
            if (this.hasBatchMode) {
                return this.currentMode;
            }
            return "interactive";
        }
        if (this.hasBatchMode) {
            return "batch";
        }
        return this.currentMode;
    }

    public void setCurrentMode(String newMode) {
        this.currentMode = newMode;
    }

    public Vector modeVector() {
        Vector<String> mv = new Vector<String>();
        if (this.hasInteractiveMode) {
            if (this.hasBatchMode) {
                if (this.currentMode.equals("interactive")) {
                    mv.add("interactive");
                    mv.add("batch");
                } else if (this.currentMode.equals("batch")) {
                    mv.add("batch");
                    mv.add("interactive");
                } else {
                    mv.add(this.currentMode);
                    mv.add("interactive");
                    mv.add("batch");
                }
            } else {
                mv.add("interactive");
            }
        } else if (this.hasBatchMode) {
            mv.add("batch");
        }
        return mv;
    }

    public void updateJembossProperty(String name, String newvalue) {
        if (this.jembossSettings.getProperty(name) != null) {
            this.jembossSettings.setProperty(name, newvalue);
        }
    }

    public void updateJembossPropString(String entry) {
        int isep = entry.indexOf(61);
        if (isep != -1) {
            String pkey = entry.substring(0, isep);
            String pvalue = entry.substring(isep + 1);
            this.updateJembossProperty(pkey, pvalue);
        }
    }

    public void updateJembossPropStrings(String[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            this.updateJembossPropString(entries[i]);
        }
        this.updateSettingsFromProperties();
        this.setupServerRedundancy();
    }

    public void updateJembossPropHash(Hashtable hash) {
        Enumeration enumer = hash.keys();
        while (enumer.hasMoreElements()) {
            String thiskey = enumer.nextElement().toString();
            String thisval = (String)hash.get(thiskey);
            this.updateJembossProperty(thiskey, thisval);
        }
        this.updateSettingsFromProperties();
    }
}

