/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.draw.DNADraw;
import org.emboss.jemboss.draw.Wizard;
import org.emboss.jemboss.editor.AlignJFrame;
import org.emboss.jemboss.editor.Matrix;
import org.emboss.jemboss.gui.AdvancedOptions;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.LaunchJalView;
import org.emboss.jemboss.gui.SequenceData;
import org.emboss.jemboss.gui.SequenceList;
import org.emboss.jemboss.gui.ShowSavedResults;
import org.emboss.jemboss.gui.filetree.DragTree;
import org.emboss.jemboss.gui.filetree.LocalAndRemoteFileTreeFrame;
import org.emboss.jemboss.soap.AuthPopup;
import org.emboss.jemboss.soap.JembossSoapException;
import org.emboss.jemboss.soap.ServerSetup;

public class SetUpMenuBar {
    public static SequenceList seqList;
    public static LocalAndRemoteFileTreeFrame localAndRemoteTree;
    private JMenuItem showLocalRemoteFile;
    private JMenuItem fileMenuShowres;
    private ServerSetup ss = null;
    private AdvancedOptions ao;
    private JMenu favMenu;

    public SetUpMenuBar(final JembossParams mysettings, final JFrame f, final boolean withSoap) {
        final Cursor cbusy = new Cursor(3);
        final Cursor cdone = new Cursor(0);
        JMenuBar menuPanel = new JMenuBar();
        new BoxLayout(menuPanel, 0);
        menuPanel.add(Box.createRigidArea(new Dimension(5, 24)));
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        this.fileMenuShowres = new JMenuItem("Saved Results");
        this.fileMenuShowres.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                f.setCursor(cbusy);
                new ShowSavedResults(mysettings, f);
                f.setCursor(cdone);
            }
        });
        fileMenu.add(this.fileMenuShowres);
        if (withSoap) {
            this.showLocalRemoteFile = new JMenuItem("Local and Remote Files");
            this.showLocalRemoteFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    f.setCursor(cbusy);
                    if (localAndRemoteTree == null) {
                        try {
                            localAndRemoteTree = new LocalAndRemoteFileTreeFrame(mysettings);
                            Dimension d = f.getToolkit().getScreenSize();
                            int locY = (int)(d.getHeight() - (double)localAndRemoteTree.getHeight()) / 2;
                            int wid1 = (int)localAndRemoteTree.getPreferredSize().getWidth();
                            int wid2 = f.getWidth();
                            wid1 = (int)d.getWidth() - wid1;
                            if (wid2 < wid1) {
                                wid1 = wid2;
                            }
                            localAndRemoteTree.setLocation(wid1, locY);
                            localAndRemoteTree.setVisible(true);
                        }
                        catch (JembossSoapException jse) {
                            localAndRemoteTree = null;
                            AuthPopup ap = new AuthPopup(mysettings, f);
                            ap.setBottomPanel();
                            ap.setSize(380, 170);
                            ap.pack();
                            ap.setVisible(true);
                        }
                    } else {
                        localAndRemoteTree.setVisible(true);
                    }
                    f.setCursor(cdone);
                }
            });
            fileMenu.add(this.showLocalRemoteFile);
            fileMenu.addSeparator();
        }
        this.ao = new AdvancedOptions(mysettings);
        JMenuItem fileMenuExit = new JMenuItem("Exit");
        fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                f.getWindowListeners()[0].windowClosing(null);
            }
        });
        fileMenu.add(fileMenuExit);
        menuPanel.add(fileMenu);
        JMenu prefsMenu = new JMenu("Preferences");
        prefsMenu.setMnemonic(80);
        JMenuItem showAdvOpt = new JMenuItem("Advanced Options");
        showAdvOpt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetUpMenuBar.this.ao.showDiaolog(mysettings, withSoap, f, f.getX() + 70, f.getY() + 50);
            }
        });
        prefsMenu.add(showAdvOpt);
        prefsMenu.addSeparator();
        JMenuItem serverSettings = new JMenuItem("Settings");
        serverSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int sso;
                if (SetUpMenuBar.this.ss == null) {
                    SetUpMenuBar.this.ss = new ServerSetup(mysettings, withSoap);
                }
                if ((sso = JOptionPane.showConfirmDialog(f, SetUpMenuBar.this.ss, "Jemboss Settings", 2, -1, null)) == 0 && withSoap) {
                    SetUpMenuBar.this.ss.setNewSettings();
                }
            }
        });
        prefsMenu.add(serverSettings);
        menuPanel.add(prefsMenu);
        JMenu toolMenu = new JMenu("Tools");
        toolMenu.setMnemonic(84);
        JMenuItem toolAlignJFrame = new JMenuItem("Multiple Sequence Editor - Jemboss");
        toolAlignJFrame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String embossDataDir = mysettings.getEmbossData();
                Matrix m = new Matrix(embossDataDir, "EBLOSUM62");
                AlignJFrame ajFrame = new AlignJFrame(true, m);
                ajFrame.setVisible(true);
            }
        });
        toolMenu.add(toolAlignJFrame);
        JMenuItem toolJalview = new JMenuItem("Multiple Sequence Editor - Jalview");
        toolJalview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new LaunchJalView();
            }
        });
        toolMenu.add(toolJalview);
        JMenuItem toolDNAEd = new JMenuItem("Jemboss DNA Editor");
        toolDNAEd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Wizard wiz = new Wizard(null);
                DNADraw dna = wiz.getDNADraw();
                JFrame f = new JFrame("DNA Viewer");
                Dimension d = f.getToolkit().getScreenSize();
                Vector minTicks = new Vector();
                Vector majTicks = new Vector();
                Vector block = new Vector();
                Vector restrictionEnzyme = new Vector();
                if (dna == null) {
                    dna = new DNADraw(minTicks, majTicks, block, restrictionEnzyme);
                }
                DNADraw.jsp = new JScrollPane(dna);
                DNADraw.jsp.getViewport().setBackground(Color.white);
                dna.setCloseAndDispose(true, f);
                f.getContentPane().add(DNADraw.jsp);
                f.setJMenuBar(dna.createMenuBar());
                f.pack();
                f.setLocation(((int)d.getWidth() - f.getWidth()) / 4, ((int)d.getHeight() - f.getHeight()) / 2);
                f.setVisible(true);
            }
        });
        toolMenu.add(toolDNAEd);
        toolMenu.addSeparator();
        JMenuItem toolWorkList = new JMenuItem("Sequence List");
        seqList = new SequenceList(withSoap, mysettings);
        toolWorkList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                seqList.setVisible(true);
            }
        });
        toolMenu.add(toolWorkList);
        menuPanel.add(toolMenu);
        this.favMenu = new JMenu("Favourites");
        menuPanel.add(this.favMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem helpMenuAboutJemboss = new JMenuItem("About Jemboss");
        helpMenuAboutJemboss.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassLoader cl = this.getClass().getClassLoader();
                try {
                    URL inURL = cl.getResource("resources/readme.html");
                    new Browser(inURL, "resources/readme.html");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "About Jemboss Guide not found!", "Error", 0);
                }
            }
        });
        helpMenu.add(helpMenuAboutJemboss);
        JMenuItem helpMenuAbout = new JMenuItem("Version");
        helpMenuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassLoader cl = this.getClass().getClassLoader();
                String fc = "";
                try {
                    String line;
                    InputStream in = cl.getResourceAsStream("resources/version");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    while ((line = reader.readLine()) != null) {
                        fc = fc.concat(line);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Didn't find resources/version");
                }
                JOptionPane.showMessageDialog(f, fc + " by the EMBOSS team");
            }
        });
        helpMenu.add(helpMenuAbout);
        menuPanel.add(helpMenu);
        menuPanel.add(Box.createHorizontalGlue());
        f.setJMenuBar(menuPanel);
    }

    public JMenu getFavoriteJMenu() {
        return this.favMenu;
    }

    public void setEnableFileManagers(boolean b) {
        this.showLocalRemoteFile.setEnabled(b);
    }

    public void setEnableShowResults(boolean b) {
        this.fileMenuShowres.setEnabled(b);
    }

    public static DragTree getLocalDragTree() {
        if (localAndRemoteTree == null) {
            return null;
        }
        return LocalAndRemoteFileTreeFrame.getLocalDragTree();
    }

    public void deleteTmp(File cwd, final String suffix) {
        String[] tmpFiles = cwd.list(new FilenameFilter(){

            public boolean accept(File cwd, String name) {
                return name.endsWith(suffix);
            }
        });
        for (int h = 0; h < tmpFiles.length; ++h) {
            File tf = new File(tmpFiles[h]);
            tf.delete();
        }
    }

    private void writeFavorites() {
        File fseq = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jembossFavorites");
        try {
            PrintWriter fout = new PrintWriter(new FileWriter(fseq));
            int nmenu = this.favMenu.getItemCount();
            for (int i = 0; i < nmenu; ++i) {
                JMenuItem favItem = this.favMenu.getItem(i);
                if (favItem == null) {
                    fout.println();
                    continue;
                }
                fout.println(favItem.getText() + "\t" + favItem.getActionCommand());
            }
            fout.close();
        }
        catch (IOException ioe) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void exitJemboss() {
        this.writeFavorites();
        String fs = new String(System.getProperty("file.separator"));
        String cwd = new String(System.getProperty("user.dir") + fs);
        this.ao.userHomeSave();
        if (seqList.isStoreSequenceList()) {
            SetUpMenuBar.saveSequenceList();
        }
        seqList.saveBounds();
        this.deleteTmp(new File(cwd), ".jembosstmp");
        System.exit(0);
    }

    public static void saveSequenceList() {
        File fseq = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jembossSeqList");
        try {
            PrintWriter fout = new PrintWriter(new FileWriter(fseq));
            for (int i = 0; i < seqList.getRowCount(); ++i) {
                String send;
                SequenceData seqData = seqList.getSequenceData(i);
                String sbeg = seqData.s_beg;
                if (sbeg.equals("")) {
                    sbeg = "-";
                }
                if ((send = seqData.s_end).equals("")) {
                    send = "-";
                }
                if (seqData.s_name.equals("")) continue;
                fout.println(seqData.s_name + " " + sbeg + " " + send + " " + seqData.s_listFile.toString() + " " + seqData.s_default.toString() + " " + seqData.s_remote.toString());
            }
            fout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        localAndRemoteTree = null;
    }
}

