#!/bin/sh -e
#
#  Copyright 2007 Neil Williams <codehelp@debian.org>
#
#  This package is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

if [ -z "$YESNO" ]; then
  YESNO=$"yYnN"
fi

cat <<EOF
I can automatically include your apt sources list in your bug
report. This information may help to diagnose your problem.
You can always edit this information within the bug report
if necessary.

EOF

if [ -f /etc/apt/sources.list ]; then
  yesno "May I include your sources.list (/etc/apt/sources.list)? " yep

  if [ "$REPLY" = "yep" ]; then
    echo -e "\n-- /etc/apt/sources.list --\n" >&3
    cat /etc/apt/sources.list >&3
    for list in `ls /etc/apt/sources.list.d/ | grep -v ucf`; do
      echo -e "\n-- /etc/apt/sources.list.d/$list --\n" >&3
      cat /etc/apt/sources.list.d/$list >&3
    done
  fi
fi
