      PROGRAM TABLES
C
C**** *TABLES*
C
C
C     PURPOSE.
C     --------
C          CREATES BYNARY BUFR TABLES USED BY BUFR EXPANSION
C          OR BUFR ENCODING SOFTWARE
C
C**   INTERFACE.
C     ----------
C          NONE.
C
C
C     *METHOD.
C      -------
C          NONE.
C
C
C     EXTERNALS.
C     ----------
C          NONE.
C
C
C
C
C     REFERENCE.
C     ----------
C
C          BINARY UNIVERSAL FORM FOR DATA REPRESENTATION, FM 94 BUFR.
C
C          J.K.GIBSON AND M.DRAGOSAVAC,1987: DECODING DATA 
C          REPRESENTATION FM 94 BUFR,TECHNICAL MEMORANDUM NO.
C
C          J.K.GIBSON,1986:EMOS 2 - STANDARDS FOR SOFTWARE DEVELOPMENT
C          AND MAINTANANCE ,TECHICAL MEMORANDUM NO.       ECMWF.
C
C
C     AUTHOR.
C     -------
C
C          M. DRAGOSAVAC       *ECMWF*       JANUARY 1991.
C
C
C     MODIFICATIONS.
C     --------------
C
C          NONE.
C
C
      IMPLICIT LOGICAL(L,O,G), CHARACTER*8(C,H,Y)
C
      CHARACTER*256 CF,CARG(2)
      CHARACTER*256  YBTABLE
      CHARACTER*256  YCTABLE
      CHARACTER*256  YDTABLE
C
cs      external getarg
C
C     ------------------------------------------------------------------
C*          1.   CREATE BINARY BUFR TABLES.
C                __________________________
 100  CONTINUE
C
      IERR=0
      YBTABLE=' '
      YCTABLE=' '
      YDTABLE=' '
      CF     =' '
      CARG(1)=' '
      CARG(2)=' '
C
C
C     Input file name
C
C     Get input and output file name.
C
      narg=IARGC()
c
      IF(narg.NE.2) THEN
         print*,'Usage -- create_bufr_tables -o table_name '
         stop
      END IF
c
      do 101 j=1,narg
      call getarg(j,carg(j))
 101  continue
c
      if(carg(1).ne.'-o'.and.carg(1).ne.'-O'.or.
     1   carg(2).eq.' ') then
         print*,'Usage -- create_bufr_tables -o table_name '
         stop
      end if
c
      cf=carg(2)
      ii=index(cf,' ')
      ii=ii-1
C
C
      if(cf(1:1).eq.'B') YBTABLE=cf(1:ii)
      if(cf(1:1).eq.'C') YCTABLE=cf(1:ii)
      if(cf(1:1).eq.'D') YDTABLE=cf(1:ii)
C
C*          2. TABLE B.
C              --------
 200  CONTINUE
C
      IF(YBTABLE.NE.' ') CALL BTABLE(YBTABLE,IERR)
      IF(IERR.NE.0) THEN
         WRITE(*,'(1H ,A,A,A)') 'Warning --- Bufr Table ',ybtable,
     1                          ' not created.'
         IERR=0
      END IF
C
C*          3. TABLE C.
C              --------
 300  CONTINUE
C
      IF(YCTABLE.NE.' ') CALL CTABLE(YCTABLE,IERR)
      IF(IERR.NE.0) THEN
         WRITE(*,'(1H ,A,A,A)') 'Warning --- Bufr Table ',yctable,
     1                          ' not created'
         IERR=0
      END IF
C
C*          4. TABLE D.
C              --------
 400  CONTINUE
C
      IF(YDTABLE.NE.' ') CALL DTABLE(YDTABLE,IERR)
      IF(IERR.NE.0) THEN
         WRITE(*,'(1H ,A,A,A)') 'Warning --- Bufr Table ',ydtable,
     1                          ' not created'
         IERR=0
      END IF
C
      END
      SUBROUTINE BTABLE(YNAME,KERR)
C
C**** *BTABLE*
C
C
C     PURPOSE.
C     --------
C          CREATE BUFR TABLE B IN BINARY FORM.
C
C**   INTERFACE.
C     ----------
C          NONE.
C
C
C     *METHOD.
C      -------
C          NONE.
C
C
C     EXTERNALS.
C     ----------
C          NONE.
C
C
C
C
C     REFERENCE.
C     ----------
C
C          BINARY UNIVERSAL FORM FOR DATA REPRESENTATION, FM 94 BUFR.
C
C          J.K.GIBSON AND M.DRAGOSAVAC,1987: DECODING DATA 
C          REPRESENTATION FM 94 BUFR,TECHNICAL MEMORANDUM NO.
C
C          J.K.GIBSON,1986:EMOS 2 - STANDARDS FOR SOFTWARE DEVELOPMENT
C          AND MAINTANANCE ,TECHICAL MEMORANDUM NO.       ECMWF.
C
C
C     AUTHOR.
C     -------
C
C          M. DRAGOSAVAC       *ECMWF*       JANUARY 1991.
C
C
C     MODIFICATIONS.
C     --------------
C
C          NONE.
C
C
      IMPLICIT LOGICAL(L,O,G), CHARACTER*8(C,H,Y)
C
C
      PARAMETER(JP=3000)
C
      CHARACTER CTABBEN(JP)*64,CTABBU(JP)*24,YENTRY*120
      CHARACTER*(*) YNAME
      CHARACTER*256  YFNAME
C
      DIMENSION NTABBTR(JP),NTABBS(JP),NTABBRF(JP),NTABBDW(JP)
      DIMENSION NTABP(64,255)
      DATA CTABBEN/JP*' '/,CTABBU/JP*' '/
C
C     ------------------------------------------------------------------
C*          1.   INITIALIZE CONSTANTS AND VARIABLES.
C                -----------------------------------
 100  CONTINUE
C
      J=0
      ICLASS0=0
      IVIND=2147483647
      YFNAME=' '
C
      DO 101 I=1,64
      do 101 ii=1,255
      NTABP(I,ii)=0
 101  CONTINUE
C
      DO 102 i=1,JP
      NTABBTR(I)=IVIND
      NTABBS (I)=IVIND
      NTABBRF(I)=IVIND
      NTABBDW(I)=IVIND
      CTABBEN(I)=' '
      CTABBU (I)=' '
 102  CONTINUE
C
      II=INDEX(YNAME,' ')
      II=II-1
      YFNAME=YNAME(1:II)//'.TXT'
      II=INDEX(YFNAME,' ')
      II=II-1
      OPEN(UNIT=21,FILE=YFNAME(1:II),
     2            IOSTAT=IOS,      
     1            STATUS='OLD')
      if(ios.ne.0) then
         print*,'open error on ',YFNAME(1:II)
         stop
      end if
C     ------------------------------------------------------------------
C*          2.   READ IN TABLE B ELEMENT.
C                ------------------------
C
 200  CONTINUE
C
      YENTRY=' '
      READ(21,'(A)',ERR=402,END=300) YENTRY
C
      J=J+1
      IF(J.GT.JP) THEN
         PRINT*,' DIMENSION TOO SMALL J=',J
         CALL EXIT(2)
      END IF 
C
C     ------------------------------------------------------------------
C*          2.1  SET ARRAYS FOR TABLE REFERENCE, ELEMENT NAME, UNITS,
C*               REFERENCE VALUE AND DATA WIDTH.
C
 210  CONTINUE
C
C
      READ(YENTRY,'(1X,I6,1x,64x,1x,24x,1x,I3,1x,I12,1x,I3)')
     1                                         NTABBTR(J),NTABBS (J),
     1                                         NTABBRF(J),NTABBDW(J)
C
      CTABBEN(J)=YENTRY( 9:72)
      CTABBU (J)=YENTRY(74:97)
C
      ICLASS=NTABBTR(J)/1000
      iyyy  =ntabbtr(j)-iclass*1000+1
C
      iclass=iclass+1
      ntabp(iclass,iyyy)=j
C
c      WRITE(*,1000) NTABBTR(J),CTABBEN(J),CTABBU(J),NTABBS(J),
c     1              NTABBRF(J),NTABBDW(J)
c 1000 FORMAT(1H ,1X,I6,1x,64x,1x,24x,1x,,I3,1x,I12,1x,I3)
C
      GO TO 200
C
C     ------------------------------------------------------------------
C*          3.   WRITE WORKING TABLE B INTO FILE.
C                --------------------------------
 300  CONTINUE
C
      OPEN(UNIT=10,FILE=YNAME,ERR=403,
     1             FORM='UNFORMATTED',
     2             ACCESS='SEQUENTIAL',
     3             STATUS='unknown')
C
C
      WRITE(10,IOSTAT=IOS,ERR=404)  NTABBTR,CTABBEN,CTABBU,
     1                              NTABBS ,NTABBRF,NTABBDW,
     2                              NTABP
C
      CLOSE(10)
C     -----------------------------------------------------------------
 400  CONTINUE
C
      write(*,'(1h )')
      write(*,'(1h ,a,i4)') 'Total number of entries in the Table B is',
     1                       j
C
      RETURN
C
404   CONTINUE
      KERR=1
      WRITE(*,4404) IOS,yname
 4404 FORMAT(1H ,'Write error',i4,' on ',a)
      RETURN
C
403   CONTINUE
      KERR=1
      WRITE(*,4403) IOS,yname
4403  FORMAT(1H ,'Open error',i4,' on ',a)
      RETURN
C
C
402   CONTINUE
      KERR=1
      WRITE(*,4402) IOS,yfname
 4402 FORMAT(1H ,'Read error',i4,' on ',a)
      RETURN
C
C
 401  CONTINUE
C
      KERR=1
      WRITE(*,4401) IOS,YFNAME
 4401 FORMAT(1H ,'Open error',i4,' on ',a)
C     
      RETURN
      END
      SUBROUTINE DTABLE(YNAME,KERR)
C
C**** *DTABLE*
C
C
C     PURPOSE.
C     --------
C          THE MAIN PURPOSE OF THIS PROGRAMME IS TO CREATE WORKING
C          TABLE OF SEQUENCE DESCRIPTORS FOR *BUFR* DECODING.
C
C**   INTERFACE.
C     ----------
C          NONE.
C
C
C
C
C     *METHOD.
C      -------
C          NONE.
C
C
C
C     EXTERNALS.
C     ----------
C          NONE.
C
C
C
C
C     REFERENCE.
C     ----------
C
C          BINARY UNIVERSAL FORM FOR DATA REPRESENTATION, *FM 94 BUFR*.
C
C          J.K.GIBSON AND *M.DRAGOSAVAC,1987:* DECODING *DATA *REPRESENTATION
C                          *FM 94 BUFR*,*TECHNICAL *MEMORANDUM *NO.
C
C          J.K.GIBSON,1986:*EMOS 2 - *STANDARDS FOR SOFTWARE DEVELOPMENT
C                           AND MAINTANANCE *,*TECHICAL MEMORANDUM *NO.
C                           *ECMWF*.
C
C
C     AUTHOR.
C     -------
C
C          M. DRAGOSAVAC       *ECMWF*       JANUARY 1991.
C
C
C     MODIFICATIONS.
C     --------------
C
C          NONE.
C
C
      IMPLICIT LOGICAL(L,O,G), CHARACTER*8(C,H,Y)
C
C
      PARAMETER(JP=3000,JL=20)
C
      CHARACTER*120 YENTRY
      CHARACTER*256 YFNAME
      CHARACTER*(*) YNAME
C
      DIMENSION NTABDTR(JP),NTABDL(JP),NTABDST(JP),NTABDSQ(JP*20),
     1          NLIST  (JL)
C
C     ------------------------------------------------------------------
C*          1.   SET INITIAL CONSTANTS.
C                ----------------------
 100  CONTINUE
C
      KERR=0
      J  =0
      IST=1
      YFNAME=' '
C
      DO 101 I=1,JP
      NTABDTR(I)=999999
      NTABDL (I)=0
      NTABDST(I)=0
 101  CONTINUE
C
      DO 102 I=1,JP*20
      NTABDSQ(I)=0
 102  CONTINUE
C
      DO 103 I=1,JL
      NLIST(I)=0
 103  CONTINUE
C
      II=INDEX(YNAME,' ')
      II=II-1
      YFNAME=YNAME(1:II)//'.TXT'
      II=INDEX(YFNAME,' ')
      II=II-1
      OPEN(UNIT=21,iostat=ios,FILE=YFNAME(1:II),STATUS='OLD')
      if(ios.ne.0) then
         print*,'Open error on ',YFNAME(1:II)
         stop
      end if
C
C     ------------------------------------------------------------------
C*          2.   READ IN TABLE D
C                ---------------
C
 200  CONTINUE
C
      READ(21,'(A)',iostat=ios,END=300) YENTRY
      if(ios.ne.0) then
         print*,'Read error ',ios
         stop
      end if
C
      J=J+1
C
      IF(J.GT.JP) THEN
         PRINT*,' DIMENSION TOO SMALL J=',J
         kerr=1
         return
      END IF 
C
C     ------------------------------------------------------------------
C*          2.1  SET ARRAYS FOR TABLE REFERENCE, DATA LENGTH,
C*               STARTING POINTER AND SEQUENCE DESCRIPTORS.
C
 210  CONTINUE
C
C
      READ(YENTRY,'(1X,I6,1X,I2)') NTABDTR(J),NTABDL (J)
C
      IF(J.EQ.1) THEN
         IST=1
         NTABDST(J)=IST
      ELSE
         IST=IST + NTABDL(J-1)
         NTABDST(J)=IST
      END IF
C
      IF(NTABDL(J).GT.1) THEN
         READ(YENTRY,'(11X,I6)') NTABDSQ(IST)
         IIST=IST
C
         DO 220 JA=1,NTABDL(J)-1
         IIST=IIST+1
         READ(21,'(A)',END=300) YENTRY
         READ(YENTRY,'(11X,I6)') NTABDSQ(IIST)
 220     CONTINUE
C
      ELSE
         READ(YENTRY,'(11X,I6)') NTABDSQ(IST)
      END IF
C
C
c     WRITE(*,1000) NTABDTR(J),NTABDL(J),NTABDST(J),
c    1              (NTABDSQ(I),I=NTABDST(J),NTABDL(J)+NTABDST(J)-1)
C
c1000 FORMAT(1H ,I6,1X,I2,1X,I6,1X,I6/ (18X,I6))
C
      GO TO 200
C
C     ------------------------------------------------------------------
C*          3.   WRITE WORKING TABLE D INTO FILE 
C                --------------------------------
 300  CONTINUE
C
C
      OPEN(UNIT=22,FILE=YNAME,iostat=ios,
     1             FORM='UNFORMATTED',
     2             ACCESS='SEQUENTIAL',
     3             STATUS='unknown')
      if(ios.ne.0) then
         print*,'Open error on ',YNAME 
         stop
      end if
C
      WRITE(22,IOSTAT=IOS) NTABDTR,NTABDL,NTABDST,NTABDSQ
      if(ios.ne.0) then
         print*,'Write error ',ios
         stop
      end if
C
      write(*,'(1h )')
      WRITE(*,'(1h ,a,i4)') 'Total number of entries in the Table D is',
     1                       j
C
      RETURN
C     -----------------------------------------------------------------
 400  CONTINUE
C
      return
C
      END
      SUBROUTINE CTABLE(YNAME,KERR)
C
C**** *CTABLE*
C
C
C     PURPOSE.
C     --------
C          THE MAIN PURPOSE OF THIS PROGRAMME IS TO CREATE WORKING
C          CODE TABLES FOR *BUFR* DECODING.
C
C**   INTERFACE.
C     ----------
C          NONE.
C
C
C
C
C     *METHOD.
C      -------
C          NONE.
C
C
C
C     EXTERNALS.
C     ----------
C          NONE.
C
C
C
C
C     REFERENCE.
C     ----------
C
C          BINARY UNIVERSAL FORM FOR DATA REPRESENTATION, *FM 94 BUFR*.
C
C          J.K.GIBSON AND *M.DRAGOSAVAC,1987:* DECODING *DATA *REPRESENTATION
C                          *FM 94 BUFR*,*TECHNICAL *MEMORANDUM *NO. 134
C
C          J.K.GIBSON,1986:*EMOS 2 - *STANDARDS FOR SOFTWARE DEVELOPMENT
C                           AND MAINTANANCE *,*TECHICAL MEMORANDUM *NO.
C                           *ECMWF*.
C
C
C     AUTHOR.
C     -------
C
C          M. DRAGOSAVAC       *ECMWF*       JANUARY 1991.
C
C
C     MODIFICATIONS.
C     --------------
C
C          NONE.
C
C
      IMPLICIT LOGICAL(L,O,G), CHARACTER*8(C,H,Y)
C
C
      PARAMETER(JP=360,JPN=15)
C
      CHARACTER CTEXT(JP*JPN*4)*64,YENTRY*120
      CHARACTER*256 YFNAME
      CHARACTER*(*) YNAME
C
      DIMENSION NREF(JP),NSTART(JP),NLEN(JP),NCODNUM(JP*JPN),
     1          NSTARTC(JP*JPN),NLENC(JP*JPN)
C
C     ------------------------------------------------------------------
C*          1.   SET INITIAL CONSTANTS AND POINTERS
C                ----------------------------------
 100  CONTINUE
C
      J=0
      JPN4=JP*JPN*4
      YFNAME=' '
C
      DO 101 I=1,JPN4
      CTEXT(I)=' '
 101  CONTINUE
C
      DO 102 I=1,JP
      NREF(I)=0
      NSTART(I)=0
      NLEN(I)=0
 102  CONTINUE
C
      DO 103 I=1,JP*JPN
      NCODNUM(I)=0
      NSTARTC(I)=0
      NLENC  (I)=0
 103  CONTINUE
C
      II=INDEX(YNAME,' ')
      II=II-1
      YFNAME=YNAME(1:II)//'.TXT'
      II=INDEX(YFNAME,' ')
      II=II-1
      OPEN(UNIT=21,FILE=YFNAME(1:II),ERR=401,STATUS='OLD')
C
C     ------------------------------------------------------------------
C*          2.   READ IN CODE TABLE ENTRY
C                ------------------------
 200  CONTINUE
C
C
      READ(21,'(A)',ERR=402,END=300) YENTRY
C
      J = J+1
C
      IF(J.GT.JP) THEN
         PRINT*,' DIMENSION TOO SMALL J=',J
         CALL EXIT(2)
      END IF 
C
C     ------------------------------------------------------------------
C*          2.1  SET ARRAYS FOR CODE TABLE TABLE REFERENCE, STARTING POINTERS
C                FOR LIST OF CODE NUMBERS, LENGTH , LIST OF CODE NUMBERS,
C                STARTING POINTERS AND LENGTH OF TEXT INFORMATION.
 210  CONTINUE
C
      READ(YENTRY,'(I6,1X,I4,1X,I4,1X,I2)') NREF(J),NLEN(J),NCODE,NLINE
C
      IF(J.EQ.1) THEN
         NSTART (J)  = 1
         NSTARTC(J)  = 1
         IPT = 1
         IIPT= 1
      ELSE
         NSTART(J)   = NSTART(J-1) + NLEN(J-1)
         IPT         = NSTART(J)
         IIPT        = IIPT + 1
         NSTARTC(IPT)= IIPT
      END IF
C
C
      NCODNUM(IPT)=NCODE
      NLENC ( IPT)=NLINE
C
      CTEXT (IIPT)=YENTRY(21:80)
C     -------------------------------------------------------------------
      IF(NLENC(IPT).GT.1) THEN
         DO 220 JA=1,NLENC(IPT)-1
         READ(21,'(A)',END=300) YENTRY
         IIPT=IIPT+1
         CTEXT(IIPT)=YENTRY(21:80)
 220     CONTINUE
      END IF
C
      IF(NLEN(J).GT.1) THEN
         DO 230 JA=1,NLEN(J)-1
         READ(21,'(A)',END=300) YENTRY
         READ(YENTRY,'(12X,I4,1X,I2)') NCODE,NLINE
         IPT   = IPT + 1
         IIPT  =IIPT + 1
         NCODNUM(IPT)= NCODE
         NSTARTC(IPT)=  IIPT
         NLENC  (IPT)=NLINE
         CTEXT(IIPT) = YENTRY(21:80)
         IF(NLENC(IPT).GT.1) THEN
            DO 240 JB=1,NLENC(IPT)-1
            READ(21,'(A)',END=300) YENTRY
            IIPT=IIPT+1
            CTEXT(IIPT)=YENTRY(21:80)
 240        CONTINUE
         END IF
 230     CONTINUE
      END IF
C
      GO TO 200
C
C     ------------------------------------------------------------------
C*          3.   WRITE WORKING CODE TABLE INTO FILE.
C                -----------------------------------
 300  CONTINUE
C
      OPEN(UNIT=22,FILE=YNAME,ERR=403,
     1             FORM='UNFORMATTED',
     3             STATUS='unknown')
c
      WRITE(22,IOSTAT=IOS,ERR=404) NREF,NSTART,NLEN,NCODNUM,
     1                             NSTARTC,NLENC,CTEXT
C
      CLOSE(21)
      CLOSE(22)
C     -----------------------------------------------------------------
C*          3.1  WRITE TABLES ON OUTPUT FILE
C                ---------------------------
 310  CONTINUE
C
c      JEND=J
c      DO 311 J=1,JEND
C
c      IPT=NSTART(J)
c      IIPT=NSTARTC(IPT)
c      WRITE(*,999) NREF(J),NLEN(J),NCODNUM(IPT),NLENC(IPT),CTEXT(IIPT)
C
c      IF(NLENC(IPT).GT.1) THEN
c         DO 312 JA=1,NLENC(IPT)-1
c         IIPT = IIPT + 1
c         WRITE(*,998) CTEXT(IIPT)
c 312     CONTINUE
c      END IF
C
c      IF(NLEN(J).GT.1) THEN
c         DO 313 JB=1,NLEN(J)-1
c         IPT = IPT + 1
c         IIPT= NSTARTC(IPT)
c         WRITE(*,997) NCODNUM(IPT),NLENC(IPT),CTEXT(IIPT)
c         IF(NLENC(IPT).GT.1) THEN
c            DO 314 JC=1,NLENC(IPT)-1
c            IIPT= IIPT + 1
c            WRITE(*,998) CTEXT(IIPT)
c 314        CONTINUE
c         END IF
c 313     CONTINUE
c      END IF
C
c 311  CONTINUE
C
      write(*,'(1h )')
      write(*,'(1H ,a,i4)') 'Total number of entries in the Table C is',
     1                       j
C
      RETURN
C     -----------------------------------------------------------------
 400  CONTINUE
C
 401  CONTINUE
C
      KERR=1
      WRITE(*,4401) IOS,YFNAME
 4401 FORMAT(1H ,'Open error ',i4,' on ',a)
      RETURN
C
 402  CONTINUE
      KERR=1
      WRITE(*,4402) IOS,YFNAME
 4402 FORMAT(1H ,'Read error ',i4,' on ',a)
      RETURN
C
 403  CONTINUE
C
      KERR=1
      WRITE(*,4403) IOS,YNAME
 4403 FORMAT(1H ,'Open error ',i4,' on ',a)
      RETURN
 404  CONTINUE
C
      KERR=1
      WRITE(*,4404) IOS,YNAME
 4404 FORMAT(1H ,'Write error ',i4,' on ',a)
      RETURN
C
  997 FORMAT(1H ,14X,I4,1X,I2,1X,A)
  998 FORMAT(1H ,22X,A)
  999 FORMAT(1H ,2X,I6,1X,I4,1X,I4,1X,I2,1X,A)
C
      END
