C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      INTEGER FUNCTION IARESET (KSEC2, KSEC4, KVALUES, KPR, KERR)
C
C---->
C**** *IARESET*
C
C     PURPOSE
C     _______
C
C     Generate the output field definition.
C
C     INTERFACE
C     _________
C
C     IERR = IARESET (KSEC2, KSEC4, KVALUES, KPR, KERR)
C
C     Input parameters
C     ________________
C
C     KSEC2      - The GRIB Section 2 array for the input field.
C
C     KSEC4      - The GRIB Section 4 array for the input field.
C
C     KVALUES    - The number of values in the output field.
C
C     KPR        - The debug print switch.
C                  0  , No debugging output.
C                  1  , Produce debugging output.
C
C     KERR       - The error control flag.
C                  -ve, No error message. Return error code.
C                  0  , Hard failure with error message.
C                  +ve, Print error message. Return error code.
C
C     Output parameters
C     ________________
C
C     KSEC2      - The modified GRIB Section 2 array for the output
C                  field.
C
C     KSEC4      - The modified GRIB Section 4 array for the output
C                  field.
C
C     Return value
C     ____________
C
C     The error indicator (INTEGER).
C
C     Error and Warning Return Values
C     _______________________________
C
C     None
C
C     Common block usage
C     __________________
C
C     nofld.common - This file contains all the output field
C                    definition variables.
C
C     NOACC        - Number of packing bits to be used for output
C                    GRIB field is used.
C     NOAREA       - Output field area definition (N/W/S/E) is used.
C     NOGAUSS      - Output field Gaussian truncation is used.
C     NOGRID       - Output field grid definition (WE/NS) is used.
C     NONS         - Number of grid points in NS direction for output
C                    field is used.
C     NOREPR       - Output field representation is used.
C     NOSCNM       - Output field scanning mode is used.
C     NOWE         - Number of grid points in WE direction for output
C                    field is used.
C
C     EXTERNALS
C     _________
C
C     SETPAR       - Standard routine used to generate "missing" data
C                    values for GRIB fields.
C     INTLOG(R)    - Logs messages.
C
C     METHOD
C     ______
C
C     This routine modifies sections 2 and 4 of the GRIB definition
C     to match the output field.
C
C     REFERENCE
C     _________
C
C     None
C
C     COMMENTS
C     ________
C
C     Program contains sections 0 to 4 and 9
C
C     AUTHOR
C     ______
C
C     K. Fielding      *ECMWF*      Apr 1994
C
C     MODIFICATIONS
C     _____________
C
C     None
C
C----<
C     _______________________________________________________
C
C
C*    Section 0. Definition of variables.
C     _______________________________________________________
C
C*    Prefix conventions for variable names
C
C     Logical      L (but not LP), global or common.
C                  O, dummy argument
C                  G, local variable
C                  LP, parameter.
C     Character    C, global or common.
C                  H, dummy argument
C                  Y (but not YP), local variable
C                  YP, parameter.
C     Integer      M and N, global or common.
C                  K, dummy argument
C                  I, local variable
C                  J (but not JP), loop control
C                  JP, parameter.
C     REAL         A to F and Q to X, global or common.
C                  P (but not PP), dummy argument
C                  Z, local variable
C                  PP, parameter.
C
C     Implicit statement to force declarations
C
      IMPLICIT NONE
C
#include "parim.h"
#include "nofld.common"
C
C     Dummy arguments
      INTEGER KVALUES, KPR, KERR
      INTEGER KSEC2 (JPGRIB_ISEC2), KSEC4 (JPGRIB_ISEC4)
C
C     Local variables
      INTEGER IWEINC, ITEMP, IMISS, IERR
      INTEGER JPROUTINE
      PARAMETER (JPROUTINE = 24200)
C
C     External functions
C
C     Transform definition variables that must be preserved
C
C
C     _______________________________________________________
C
C*    Section 1. Initialisation
C     _______________________________________________________
C
  100 CONTINUE
C
      IF (KPR.GE.1) CALL INTLOG(JP_DEBUG,'IARESET: Section 1.',JPQUIET)
C
      IARESET = 0
      IERR = 0
C
      IF (KPR .GE. 1) THEN
        CALL INTLOG(JP_DEBUG,'IARESET: Input parameters.',JPQUIET)
        CALL INTLOG(JP_DEBUG,
     X    'IARESET: No.bits for output field packing = ',NOACC)
        CALL INTLOG(JP_DEBUG,
     X    'IARESET: No.values to be packed = ',KVALUES)
        IF (NOREPR .EQ. JPREGULAR) THEN
          CALL INTLOG(JP_DEBUG,
     X      'IARESET: West-East stride = ', NOGRID (JPWESTEP))
          CALL INTLOG(JP_DEBUG,
     X      'IARESET: North-South stride = ', NOGRID (JPNSSTEP))
        ELSE
          CALL INTLOG(JP_DEBUG,
     X      'IARESET: Gaussian truncation = ',NOGAUSS)
        ENDIF
      ENDIF
C
C     Get GRIB missing data value
C
      CALL SETPAR (ITEMP, IMISS, KPR)
C
C     Representation
C
      KSEC2 (JPSEC2_REP) = NOREPR
      KSEC2 (JPSEC2_SCAN) = NOSCNM
C
C     _______________________________________________________
C
C*    Section 2. Set Grib Section 2 regular grid variables
C     _______________________________________________________
C
  200 CONTINUE
C
      IF (NOREPR .EQ. JPREGULAR) THEN
C
      IF (KPR.GE.1) CALL INTLOG(JP_DEBUG,'IARESET: Section 2.',JPQUIET)
C
         KSEC2 (JPSEC2_QUASI) = 0
C
         KSEC2 (JPSEC2_NLONG) = NOWE
         KSEC2 (JPSEC2_NLAT) = NONS
C
         KSEC2 (JPSEC2_NORTH) = NOAREA (JPNORTH) / 10
         KSEC2 (JPSEC2_WEST) = NOAREA (JPWEST) / 10
         KSEC2 (JPSEC2_SOUTH) = NOAREA (JPSOUTH) / 10
C
         IF (MOD (NOAREA (JPEAST), 10) .EQ. 5) THEN
            KSEC2 (JPSEC2_EAST) = NOAREA (JPEAST) / 10 + 1
         ELSE
            KSEC2 (JPSEC2_EAST) = NOAREA (JPEAST) / 10
         ENDIF
C
         IF (MOD (NOGRID (JPWESTEP), 10) .EQ. 5 .OR.
     X      MOD (NOGRID (JPNSSTEP), 10) .EQ. 5) THEN
C
            KSEC2 (JPSEC2_RESOL) = 0
            KSEC2 (JPSEC2_DLONG) = IMISS
            KSEC2 (JPSEC2_DLAT) = IMISS
C
         ELSE
C
            KSEC2 (JPSEC2_RESOL) = 128
            KSEC2 (JPSEC2_DLONG) = NOGRID (JPWESTEP) / 10
            KSEC2 (JPSEC2_DLAT) = NOGRID (JPNSSTEP) / 10
C
         ENDIF
C
C     _______________________________________________________
C
C*    Section 3. Set Grib Section 2 Gaussian values
C     _______________________________________________________
C
  300 CONTINUE
C
      ELSE IF (NOREPR .EQ. JPGAUSSIAN) THEN
C
      IF (KPR.GE.1) CALL INTLOG(JP_DEBUG,'IARESET: Section 3.',JPQUIET)
C
         KSEC2 (JPSEC2_QUASI) = 0
C
         KSEC2 (JPSEC2_GTRUNC) = NOGAUSS
         KSEC2 (JPSEC2_NLONG) = NOWE
         KSEC2 (JPSEC2_NLAT) = NONS
C
         KSEC2 (JPSEC2_NORTH) = NOAREA (JPNORTH) / 10
         KSEC2 (JPSEC2_WEST) = NOAREA (JPWEST) / 10
         KSEC2 (JPSEC2_SOUTH) = NOAREA (JPSOUTH) / 10
C
         IF (MOD (NOAREA (JPEAST), 10) .EQ. 5) THEN
            KSEC2 (JPSEC2_EAST) = NOAREA (JPEAST) / 10 + 1
         ELSE
            KSEC2 (JPSEC2_EAST) = NOAREA (JPEAST) / 10
         ENDIF
C
         IWEINC = JP90 / NOGAUSS
C
         IF (MOD (IWEINC, 10) .EQ. 5) THEN
C
            KSEC2 (JPSEC2_RESOL) = 0
            KSEC2 (JPSEC2_DLONG) = IMISS
C
         ELSE
C
            KSEC2 (JPSEC2_RESOL) = 128
            KSEC2 (JPSEC2_DLONG) = IWEINC / 10
C
         ENDIF
C
      ENDIF
C
C     _______________________________________________________
C
C*    Section 4. Set Grib Section 4 values
C     _______________________________________________________
C
  400 CONTINUE
C
      IF (KPR.GE.1) CALL INTLOG(JP_DEBUG,'IARESET: Section 4.',JPQUIET)
C
      KSEC4 (JPSEC4_NVALUE) = KVALUES
C
      IF (NOACC .NE. 0) KSEC4 (JPSEC4_NBITS) = NOACC
C
C     _______________________________________________________
C
C*    Section 9. Return to calling routine. Format statements
C     _______________________________________________________
C
  900 CONTINUE
C
      IF (KPR.GE.1) CALL INTLOG(JP_DEBUG,'IARESET: Section 9.',JPQUIET)
C
      RETURN
      END
