C Copyright 1981-2012 ECMWF.
C
C This software is licensed under the terms of the Apache Licence 
C Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
C
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation 
C nor does it submit to any jurisdiction.
C

      COMPLEX FUNCTION CSUM (KN, UVEC, KNCX)                         
C                                                                       
C---->
C**** *CSUM* - ROUTINE WHICH IMPLEMENTS THE BLAS ROUTINE OF THE         
C              SAME NAME                                                
C                                                                       
C     PURPOSE.                                                          
C     --------                                                          
C                                                                       
C     SIMPLE REPLACEMENT FOR IBM                                        
C                                                                       
C**   INTERFACE.                                                        
C     ----------                                                        
C                                                                       
C     * CV = CSUM (KN, UVEC, KNCX) *                                    
C                                                                       
C                                                                       
C     METHOD.                                                           
C     -------                                                           
C                                                                       
C     CREATE COMPLEX SUM OF COMPLEX VECTOR                              
C                                                                       
C     EXTERNALS.                                                        
C     ----------                                                        
C                                                                       
C     NONE                                                              
C                                                                       
C     REFERENCE.                                                        
C     ----------                                                        
C                                                                       
C     NONE                                                              
C                                                                       
C     AUTHOR.                                                           
C     -------                                                           
C                                                                       
C     K. FIELDING         * ECMWF *     FEB 1992.                       
C                                                                       
C     MODIFICATIONS.                                                    
C     --------------                                                    
C                                                                       
C     NONE                                                              
C                                                                       
C     COMMON BLOCKS USED                                                
C     -------------------                                               
C                                                                       
C     NONE                                                              
C                                                                       
C----<
      INTEGER KN, KNCX                                                  
      COMPLEX UVEC (*)                                               
C                                                                       
      INTEGER IP                                                        
      COMPLEX CHOLD                                                  
C                                                                       
C     1.    MAIN LOOP OF CODE                                           
C           ----------------------------------------------              
C                                                                       
  100 CONTINUE                                                          
      CHOLD = (0.0D0, 0.0D0)                                            
C                                                                       
      DO 110 IP = 0, KN - 1                                             
         CHOLD = CHOLD + UVEC (1 + IP * KNCX)                           
  110 CONTINUE                                                          
C                                                                       
      CSUM = CHOLD                                                      
C                                                                       
C     END OF ROUTINE                                                    
C                                                                       
      RETURN                                                            
      END                                                               
