C Copyright 1981-2012 ECMWF.
C
C This software is licensed under the terms of the Apache Licence 
C Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
C
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation 
C nor does it submit to any jurisdiction.
C

      SUBROUTINE EULAVGG(NEWFLD, NEXT, INROW, RLAT, RLON,
     X                   POLELAT, POLELON, FIELD, NGAUSS, TYPE)
C
C---->
C**** EULAVGG
C
C     PURPOSE
C     _______
C
C     Generates values along a latitude in a rotated gaussian grid.
C     (reverses the operations carried out by GGVALUE).
C
C     INTERFACE
C     _________
C
C     CALL EULAVGG(NEWFLD, NEXT, INROW, RLAT, RLON,
C    X             POLELAT, POLELON, FIELD, NGAUSS, TYPE)
C
C
C     Input parameters
C     ________________
C
C     NEWFLD  - the field of values being created
C     NEXT    - start offset of the latitude row being created
C     INROW   - the number of points in the latitude row
C     RLAT    = target point latitude in the rotated grid
C     RLON    = target point longitude in the rotated grid
C     POLELAT = latitude of the rotated South Pole
C     POLELON = longitude of the rotated South Pole
C     FIELD   = original unrotated gaussian field values
C     NGAUSS  = original unrotated gaussian field number
C     TYPE    = original unrotated gaussian field type
C             = 'F' for full (regular) gaussian field
C             = 'R' for reduced (quasi) gaussian field
C
C     Output parameters
C     ________________
C
C     NEWFLD(NEXT) to NEWFLD(NEXT+INROW-1) contains the latitude row
C     values.
C
C
C     METHOD
C     ______
C
C     Rotates the lat/long positions of points along the latitude row
C     in a rotated gaussian grid back to positions in the unrotated grid
C     and then interpolates vsalue from the original grid.
C
C
C     EXTERNALS
C     _________
C
C     LL2XYZ  - Converts a latitude/longitude position to (x,y,z)
C               wrt axes through the centre of the globe. The z-axis
C               runs from the south to north pole. The x- and y-axes
C               are in the plane of the equator with the x-axis
C               pointing out through lat/long (0,0).
C     YROTATE - Rotates the globe about the y-axis.
C     XYZ2LL  - Converts an (x,y,z) position to a latitude/longitude.
C     GGINTRP - Interpolates a value from an existing grid.
C
C
C     REFERENCE
C     _________
C
C     None
C
C
C     COMMENTS
C     ________
C
C     The input field is assumed to be global in extent, and a known
C     definition, either N160 or N80 (reduced or regular).
C
C
C     AUTHOR
C     ______
C
C     J.D.Chambers      ECMWF       April 1996
C
C
C     MODIFICATIONS
C     _____________
C
C     None.
C
C----<
C     _______________________________________________________
C
C*    Section 0. Definition of variables.
C     _______________________________________________________
C
      IMPLICIT NONE
C
C     Function arguments
      REAL NEWFLD, RLAT, RLON, POLELAT, POLELON, FIELD
      DIMENSION NEWFLD(*), RLON(*), FIELD(*)
      INTEGER NEXT, INROW, NGAUSS
      CHARACTER*1 TYPE
C
C     Parameters
      INTEGER JPMAXGG
      PARAMETER( JPMAXGG = 1280 )
C
C     Local variables
      REAL X(JPMAXGG), Y(JPMAXGG), Z(JPMAXGG)
      REAL RX(JPMAXGG),RY(JPMAXGG),RZ(JPMAXGG)
      REAL OLAT(JPMAXGG),OLON(JPMAXGG)
      INTEGER LOOP
C
C     Adjust the target row points longitude to add back the longitude
C     rotation
      DO LOOP = 1, INROW
        OLON(LOOP) = RLON(LOOP) - POLELON
        IF( OLON(LOOP).LT.0.0 )   OLON(LOOP) = OLON(LOOP) + 360.0
        IF( OLON(LOOP).GE.360.0 ) OLON(LOOP) = OLON(LOOP) - 360.0
      ENDDO
C
C     Convert the target row points lat/long to (x,y,z) coordinates
      CALL LL2XYZ(RLAT,OLON,X,Y,Z,INROW)
C
C     Rotate the target row points forward through the original latitude
C     rotation
      CALL YROTATE((90.0+POLELAT),X,Y,Z,RX,RY,RZ,INROW)
C
C     Convert the target row points adjusted (x,y,z) coordinates to
C     lat/long in the original grid (after longitude rotation)
      CALL XYZ2LL(RX,RY,RZ,OLAT,OLON,INROW)
C
C     Interpolate the rotated grid to the target row points
      CALL GGINTRP(NEWFLD,NEXT,INROW,OLAT,OLON,FIELD,NGAUSS,TYPE)
C
      RETURN
      END
