        program JGETGG
C      SUBROUTINE JGETGG( KNUM, HTYPE, PLAT, KPTS, KRET)
C
C---->
C**** JGETGG
C
C     PURPOSE
C     _______
C
C     This routine reads the definition of a gaussian grid.
C
C
C     INTERFACE
C     _________
C
C     CALL JGETGG( KNUM, HTYPE, PLAT, KPTS, KRET)
C
C
C     Input parameters
C     ________________
C
C     KNUM     - Gaussian grid number
C     HTYPE    - Gaussian grid type
C                = 'R' for reduced, 
C                = 'F' for full
C                = 'U' for a user defined gaussian grid
C     KPTS     - Array giving users definition of the number of points
C                at each gaussian latitude if HTYPE  = 'U'
C
C
C     Output parameters
C     ________________
C
C     PLAT     - Array of gaussian latitudes (both hemispheres)
C     KPTS     - Array giving number of points at each gaussian 
C                latitude, both hemispheres
C                ( unchanged from input if HTYPE  = 'U' )
C     KRET      - Return status code
C                0 = OK
C
C
C     Common block usage
C     __________________
C
C     None.
C
C     Method
C     ______
C
C     If HTYPE = 'U', the users definition of the grid is used.
C     Latitudes values are calculated corresponding to KNUM.
C
C     An array of predefined values is used.
C
C
C     Externals
C     _________
C
C     GETENV   - Get value of an environment variable
C     INTLOG   - Output log message
C     IGGLAT   - Computes Gaussian latitude lines for given truncation.
C     EMOSNUM  - Gives current EMOSLIB version number.
C
C
C     Reference
C     _________
C
C     None
C
C
C     Comments
C     ________
C
C     None
C
C
C     AUTHOR
C     ______
C
C     J.D.Chambers      ECMWF      Jan 1994
C
C
C     MODIFICATIONS
C     _____________
C
C     J.D.Chambers      ECMWF      Apr 1995
C     Use predefined definition file for N80 and N160 to cope with
C     changes in the 'standard' definition.
C
C     J.D.Chambers      ECMWF      Apr 1996
C     Call JGGLAT if regular grid but not N80 or N160
C
C     J.D.Chambers      ECMWF      Apr 1996
C     Fixup standard pathnames for VPPs.
C     Read array of values from file if possible (once only).
C
C----<
C     -----------------------------------------------------------------|
C*    Section 0. Definition of variables.
C     -----------------------------------------------------------------|
C
      IMPLICIT NONE
C
C     Parameters
C
      INTEGER JPROUTINE, JPMAXN,I,II
      PARAMETER ( JPROUTINE = 30100 )
      PARAMETER ( JPMAXN = 2048 )
C                           `---> dimension for internal array for
C                                 gaussian grid definitions
C
C     Subroutine arguments
C
      INTEGER KNUM, KPTS, KRET
      CHARACTER*1 HTYPE
c      DIMENSION KPTS(*)
      DIMENSION KPTS(JPMAXN)
      REAL PLAT
cs      DIMENSION  PLAT(*)
      DIMENSION  PLAT(JPMAXN)
c      REAL QG400, QG512, QG1024
c      DIMENSION QG400(400),QG512(512),QG1024(1024)
C
C     Local variables
C
#include "parim.h"
#include "grfixed.h"
#include "intf.h"
#include "rgauss_200.h"
#include "rgauss_320.h"
#include "rgauss_400.h"
#include "rgauss_640.h"
#include "rgauss_512.h"
#include "rgauss_1024.h"
C
      CHARACTER*6 YEMOSNM
      CHARACTER*4 CARG
      INTEGER IERR, JJPR, JJERR,PUN
      INTEGER LOOP, NLAT, IOFFSET
      INTEGER IMAGE, K1, INUM, NGOT
C
C     Externals
C
      INTEGER  IGGLAT
      EXTERNAL IGGLAT
C
C     -----------------------------------------------------------------|
C*    Section 1.    Set up standard latitudes
C     -----------------------------------------------------------------|
C
        CALL GETARG(1,CARG)
        READ(CARG,'(I4)')KNUM
csinisa
cs           HTYPE='R'
css           KNUM=512
csinisa
C
      IF( KNUM.GT.JPMAXN) THEN
        CALL INTLOG(JP_ERROR,
     X    'JGETGG: Grid too big for internal array dimension ',JPMAXN)
        GOTO 990
      ENDIF
C
      INUM = KNUM*2
C
c      IF( (HTYPE.EQ.'R').OR.(HTYPE.EQ.'r') ) GOTO 200
C
C     If a regular gaussian grid, calculate the gaussian latitudes
C
      CALL INTLOG(JP_DEBUG,
     X  'JGETGG: Calculate the gaussian latitudes for N = ',KNUM)
C
      JJPR  = 1
      JJERR = 1
      IERR  = IGGLAT(INUM, PLAT, JJPR, JJERR)
      IF( IERR.NE.0 ) THEN
        CALL INTLOG(JP_ERROR, 'JGETGG: IGGLAT call failed',IERR)
        KRET = IERR
        GOTO 990
      ENDIF
C
C     Fill in the number of points at each latitude
C
      CALL INTLOG(JP_DEBUG,'JGETGG: Regular gaussian grid N ',KNUM)
C
c      DO LOOP = 1, INUM
c        KPTS(LOOP) = KNUM*4
c      ENDDO

C
CS      GOTO 930
C
C     -----------------------------------------------------------------|
C*    Section 2.    Read REDUCED gaussian definitions from array
C     -----------------------------------------------------------------|
C
  200 CONTINUE
C
C     Check that the definition is known
C
      IF( (KNUM.NE. 32 ).AND.
     X    (KNUM.NE. 48 ).AND.
     X    (KNUM.NE. 80 ).AND.
     X    (KNUM.NE.128 ).AND.
     X    (KNUM.NE.160 ).AND.
     X    (KNUM.NE.200 ).AND.
     X    (KNUM.NE.256 ).AND.
     X    (KNUM.NE.320 ).AND.
     X    (KNUM.NE.400 ).AND.
     X    (KNUM.NE.512 ).AND.
     X    (KNUM.NE.640 ).AND.
     X    (KNUM.NE.1024 ) ) THEN
        CALL INTLOG(JP_ERROR,
     X    'JGETGG: unknown reduced gaussian grid definition: ', KNUM)
        GOTO 990
      ENDIF
C
C     Fill in the gaussian latitudes
C
      JJPR  = 1
      JJERR = 1
      IERR  = IGGLAT(INUM, PLAT, JJPR, JJERR)
       PUN = KNUM*4
      IF( IERR.NE.0 ) THEN
        CALL INTLOG(JP_ERROR, 'JGETGG: IGGLAT call failed',IERR)
        KRET = IERR
        GOTO 990
      ENDIF
C
C
      IF( KNUM.EQ.400 ) THEN
        DO LOOP = 1, KNUM
          IMAGE       = INUM - LOOP +1
          KPTS(LOOP)  = QG400(LOOP)
          KPTS(IMAGE) = KPTS(LOOP)
        ENDDO
C
      ELSE IF( KNUM.EQ.200 ) THEN
        DO LOOP = 1, KNUM
          IMAGE       = INUM - LOOP +1
          KPTS(LOOP)  = QG200(LOOP)
          KPTS(IMAGE) = KPTS(LOOP)
        ENDDO
      ELSE IF( KNUM.EQ.320 ) THEN
        DO LOOP = 1, KNUM
          IMAGE       = INUM - LOOP +1
          KPTS(LOOP)  = QG320(LOOP)
          KPTS(IMAGE) = KPTS(LOOP)
        ENDDO
      ELSE IF( KNUM.EQ.512 ) THEN
        DO LOOP = 1, KNUM
          IMAGE       = INUM - LOOP +1
          KPTS(LOOP)  = QG512(LOOP)
          KPTS(IMAGE) = KPTS(LOOP)
        ENDDO
      ELSE IF( KNUM.EQ.640 ) THEN
        DO LOOP = 1, KNUM
          IMAGE       = INUM - LOOP +1
          KPTS(LOOP)  = QG640(LOOP)
          KPTS(IMAGE) = KPTS(LOOP)
        ENDDO
C
      ELSE
        DO LOOP = 1, KNUM
          IMAGE       = INUM - LOOP +1
          KPTS(LOOP)  = QG1024(LOOP)
          KPTS(IMAGE) = KPTS(LOOP)
        ENDDO
      ENDIF
C
C
77      format(8x,i4,8x,i4,8x,i4,3x,f9.5)
          write(*,*)'       latitude   reduced     regular  latitude'
          write(*,*)'        number     points      points'
          write(*,*)'       -------    -------     -------  --------'
        DO I = 1, KNUM
          write(*,77)I,KPTS(I),PUN,PLAT(I)
cs          write(*,*)I,KPTS(I),PUN,PLAT(I)
        ENDDO
        DO II = KNUM, 1,-1
          write(*,77)I,KPTS(II),PUN,-(PLAT(II))
           I=I+1
        ENDDO
      KRET = 0
C
 990  CONTINUE
cs      RETURN
      stop
      END
