#define MISSING_VALUE -9999999

      PROGRAM DECODING
      IMPLICIT NONE
C
      INTEGER JPACK, JPBYTES
      PARAMETER (JPACK = 500000)
C
C     JPBYTES is the number of bytes per INTEGER
C
      PARAMETER (JPBYTES = 4)
C
      INTEGER ISEC0, ISEC1, ISEC2, ISEC3, ISEC4, INBUFF, IOS, ISTR 
      DIMENSION ISEC0(2)
      DIMENSION ISEC1(1024)
      DIMENSION ISEC2(1024)
      DIMENSION ISEC3(2)
      DIMENSION ISEC4(1024)
C
      REAL ZSEC2, ZSEC3, ZSEC4, USEC4, ZZZ, ZZY
      DIMENSION ZSEC2(1024)
      DIMENSION ZSEC3(2)
      DIMENSION ZSEC4(JPACK*4),ZZZ(JPACK*4)
      DIMENSION USEC4(JPACK*4)
      DIMENSION INBUFF(JPACK)
      INTEGER IRET, FILE1, FILE2, JCOUNT
      INTEGER ILENB, LENOUT, IPUNP, IWORD, loop, NUMBER
C
      CHARACTER*128 INFILE, OUTFILE
      INTEGER IJDC, IARGC, PBGTOTL
      EXTERNAL IARGC, GETENV, PBGTOTL
C
      IJDC = IARGC()
      IF( IJDC.LT.2 ) STOP 'Usage: ginout inputfile outputfile'
      CALL GETARG(1,INFILE)
      CALL GETARG(2,OUTFILE)
C
C     Open the input file
C
      CALL PBOPEN(FILE1, INFILE(1:INDEX(INFILE,' ')-1), "R", IRET)
      IF( IRET.NE.0 ) THEN
        WRITE(*, *) 'Return code from PBOPEN = ',IRET
        CALL PBCLOSE(FILE1, IRET)
        STOP 'Fault in PBOPEN'
      ENDIF

      NUMBER = PBGTOTL(INFILE(1:INDEX(INFILE,' ')-1))
      WRITE(*,*) '****************************************'
      WRITE(*,*) 'Number of GRIBs in the file = ', NUMBER
      WRITE(*,*) '****************************************'
      IF( NUMBER.EQ.0 ) STOP 'No Gribs found'
        
C     Open the output file to write decoded products
        ISTR=INDEX(OUTFILE,' ')
      OPEN (UNIT=16,FILE=OUTFILE(1:ISTR-1),STATUS='UNKNOWN',
c     &          IOSTAT=IOS)
     &          FORM='UNFORMATTED',IOSTAT=IOS)
            IF (IOS.EQ.0) THEN
                WRITE(*,*)'File:',OUTFILE(1:ISTR-1),' opened'
            ELSE
               WRITE(*,*)'File:',OUTFILE(1:ISTR-1),' not opened'
               WRITE(*,*)'Input/output status = ',IOS
               WRITE(*,*)'Program will stop'
               STOP
            END IF

C     Lengths of INBUFF and PSEC4
      ILENB = JPACK*JPBYTES
C
C     Start of loop through products
      JCOUNT = 0

   50 CONTINUE
      JCOUNT = JCOUNT + 1
C
C     Read packed field into INBUFF.
C
      CALL PBGRIB(FILE1, INBUFF, ILENB, LENOUT, IRET )
      IF( IRET.LT.0 ) THEN
           WRITE (*, *) 'Return code from pbgrib = ',IRET

           IF( IRET.EQ.-1 ) THEN
             WRITE(*, *) 'End of file. Number of products decoded ='
     &          , (JCOUNT-1)
             CALL PBCLOSE(FILE1, IRET)
             CLOSE(16)
             STOP 'EOF'
           ELSE
             CALL PBCLOSE(FILE1, IRET)
             CLOSE(16)
             WRITE(*, *) 'Fault in PBGRIB. trying with product:', JCOUNT
             WRITE(*, *) 'Number of products decoded =', (JCOUNT-1)
             STOP 'Fault in PBGRIB'
           ENDIF
      ENDIF
C
C     Unpack GRIB message.
C
      ZSEC3(2) = MISSING_VALUE
      ISEC3(2) = NINT(ZSEC3(2))
      IRET     = 1
      IPUNP    = JPACK * JPBYTES
      ILENB    = (LENOUT + (JPBYTES-1))/JPBYTES
      CALL GRIBEX( ISEC0,ISEC1,ISEC2,ZSEC2,ISEC3,ZSEC3,ISEC4,
     X             ZSEC4,IPUNP,INBUFF,ILENB,IWORD,'D',IRET)

      WRITE (*,*) ' GRDEMO : GRIBEX return code = ', IRET
      WRITE (*,*) ' Product number= ', JCOUNT
      WRITE (*,*) '-------------------------------' 
      IF (IRET .EQ. - 6) WRITE (*,*) ' GRDEMO : Pseudo-grib data found.'
      IF( IRET.GT.0 ) THEN
        WRITE(*,*) 'GRIBEX return code = ',IRET
        STOP 'GRIBEX error'
      ENDIF
C
C
cs  Number of data values in array PSEC4
      IPUNP = ISEC4(1)
cs write decoded values to outfile
c      WRITE (16)(ZSEC4(LOOP),LOOP=1,IPUNP)
c      READ (16)(ZZZ(LOOP),LOOP=1,IPUNP)
      READ (16)(ZZZ(LOOP),LOOP=1,10)
c      READ (16)ZZY
      WRITE (*,*)(ZZZ(LOOP),LOOP=1,10)
C
C     Go back for more products
C
      GOTO 50
C
      END
