/*
    * WINNT for Windows NT, 2000, XP and later
    * Linux for all Linux versions
    * Darwin for all MacOS X versions 
    */

var eMusicPlatform = {
  flashRoot: "AppData",
  height: "600",
  width: "800",
  xOffset: "0",
  yOffset: "0",
  windowState: "",

  ident: Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULAppInfo)
                  .QueryInterface(Components.interfaces.nsIXULRuntime)
                  .OS,
  
  newline: "\r\n",
  
  downloadDirectory: null,
  
  firstTimeRun: function() {
    var thisRegBase = eMusicRegistry.eMusicBaseReg;

    var prefs = nsPreferences.mPrefService;
    var branchService = Components.classes["@mozilla.org/preferences-service;1"]
                                   .getService(Components.interfaces.nsIPrefBranch);

    // -- download directory settings 
    var thisPath = dlm_base.getSpecialFolder("Desk");
    thisPath.append("My eMusic");

    if (!branchService.prefHasUserValue("eMusic.download.dir") &&
        branchService.prefHasUserValue("browser.download.dir")) {

      // migrate path to eMusic specific download directory 8/13
      try {
        var tmpDownloadDir = prefs.getComplexValue("browser.download.dir",
                                                  Components.interfaces.nsILocalFile)
        if (tmpDownloadDir) {
          prefs.setComplexValue("eMusic.download.dir",
                                Components.interfaces.nsILocalFile,
                                tmpDownloadDir);
          prefs.setComplexValue("eMusic.download.downloadDir",
                                Components.interfaces.nsILocalFile,
                                tmpDownloadDir);
          prefs.setIntPref("eMusic.download.folderList", 2);
        }
      } catch (ex) {
        debug(ex)
      }
    }

    if (branchService.prefHasUserValue("eMusic.download.dir")) {
      try {
        thisPath = prefs.getComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile)    
      } catch (ex) {
        debug(ex)
      }
    } else {
      if (eMusicPlatform.downloadDirectory) {
        thisPath = dlm_base.getLocalFileInterface(eMusicPlatform.downloadDirectory);
      }

      prefs.setIntPref("eMusic.download.folderList", 2);
    }

    // Make sure that path and filename can and are created
    if (!thisPath.exists()) {
      try {
        thisPath.create(0x01,0755);
      } catch (ex) {
        debug(ex);
      }
    }

    /*try {
      var localStoreRDF = dlm_base.getSpecialFolder("LclSt");
      debug(localStoreRDF.path)
      localStoreRDF.remove(false)
      
    } catch (ex) {
      debug(ex)
    }*/
    
    prefs.setComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile, thisPath);
    prefs.setComplexValue("eMusic.download.downloadDir", Components.interfaces.nsILocalFile, thisPath);

    nsPreferences.setBoolPref("splash.timeout", 2000);
    nsPreferences.setBoolPref("splashext.resetVersion", "1.1");
    nsPreferences.setBoolPref("splash.windowStyle", "padding: 0px; border: 1px solid grey;");
    
    nsPreferences.setBoolPref("extensions.hyper.firsttime", false);
    nsPreferences.setBoolPref("extensions.hyper.inpagesuggestion", false);
    nsPreferences.setBoolPref("extensions.hyper.inpagesuggestionA", false);

  },
  
  minimizeWindow: function() {
    /*var fileTray = dlm_base.mostRecentWindow().document.getElementById("menu_FileTrayMinimize")

    if (fileTray && fileTray.getAttribute("checked") == "true") {
      try {
        dlm_base.mostRecentWindow().trayIcon['eMusicTrayIcon'].minimizeWindow();
      } catch (ex) {
        window.minimize();
      }
    } else {
      window.minimize();
    }*/
    window.minimize();
  },
  
  zoomWindow: function() {
    if (window.windowState == STATE_NORMAL) {
      window.maximize();
    } else {
      window.restore();
    }
  }
}


var nsIWindowsRegKey = Components.interfaces.nsIWindowsRegKey;

var winRegKeys = new Array

winRegKeys["HKCU"] = nsIWindowsRegKey.ROOT_KEY_CURRENT_USER
winRegKeys["HKLM"] = nsIWindowsRegKey.ROOT_KEY_LOCAL_MACHINE
winRegKeys["HKCR"] = nsIWindowsRegKey.ROOT_KEY_CLASSES_ROOT

var eMusicRegistry = {

  eMusicBaseReg: "Software\\eMusic\\eMusic Download Manager\\Application",

  getValue: function(thisKey, thisBase, thisReg) {
    var registryObj = Components.classes["@mozilla.org/windows-registry-key;1"]
                        .createInstance(nsIWindowsRegKey);
    var retVal = null;

    try {
      registryObj.open(thisKey, thisBase, nsIWindowsRegKey.ACCESS_READ);
  
      if (registryObj.hasValue(thisReg)) {
        switch (registryObj.getValueType(thisReg)) {
          case registryObj.TYPE_BINARY:
            retVal = registryObj.readBinaryValue(thisReg);
            break;
          case registryObj.TYPE_INT:
            retVal = registryObj.readIntValue(thisReg);
            break;
          case registryObj.TYPE_INT64:
            retVal = registryObj.readInt64Value(thisReg);
            break;
          default: //case registryObj.TYPE_STRING:
            retVal = registryObj.readStringValue(thisReg);
            break;
        }
      }
  
      registryObj.close();
  
      return retVal;
    } catch (ex) {
      registryObj.close();
      return null;
    }                                                                           
  },

  setValue: function(thisKey, thisBase, thisReg, thisValue, thisType) {

    var registryObj = Components.classes["@mozilla.org/windows-registry-key;1"]
                        .createInstance(nsIWindowsRegKey);
    var retVal = null; 
    

    try {
      registryObj.open(thisKey, thisBase, nsIWindowsRegKey.ACCESS_ALL);                                                
  
      if (!thisType) thisType = registryObj.TYPE_STRING

      if (registryObj.hasValue(thisReg)) {
        thisType = registryObj.getValueType(thisReg)
      }
  
      switch (thisType) {
        case registryObj.TYPE_BINARY:
          retVal = registryObj.writeBinaryValue(thisReg, thisValue);
          break;
        case registryObj.TYPE_INT:
          retVal = registryObj.writeIntValue(thisReg, thisValue);
          break;
        case registryObj.TYPE_INT64:
          retVal = registryObj.writeInt64Value(thisReg, thisValue);
          break;
        default: //case registryObj.TYPE_STRING:
          retVal = registryObj.writeStringValue(thisReg, thisValue);
          break;
      }

      registryObj.close();
  
      return retVal;                                                                           
    } catch (ex) {
      debug(ex)
      registryObj.close();
      return null;
    }                                                                           
  },
  
  resetStartup: function() {
    //http://developer.mozilla.org/en/docs/Accessing_the_Windows_Registry_Using_XPCOM
    var registryObj = Components.classes["@mozilla.org/windows-registry-key;1"]
                        .createInstance(nsIWindowsRegKey);

    var REG_BASE1 = "eMusicList\\shell\\open\\command";
    var REG_BASE2 = "eMusicPackage\\shell\\open\\command";

    var installFolder = dlm_base.getSpecialFolder("resource:app");
  	installFolder.append("emusic_remote.exe");
    
    try { // avoid non-admin access, ie: vista
      //registryObj.open(winRegKeys["HKCR"], REG_BASE1, nsIWindowsRegKey.ACCESS_WRITE);                                                
      registryObj.create(winRegKeys["HKCR"], REG_BASE1, nsIWindowsRegKey.ACCESS_WRITE);
      registryObj.writeStringValue("", '"' + installFolder.path + '" "%1"');
      registryObj.close();

      //registryObj.open(winRegKeys["HKCR"], REG_BASE2, nsIWindowsRegKey.ACCESS_WRITE);                                                
      registryObj.create(winRegKeys["HKCR"], REG_BASE2, nsIWindowsRegKey.ACCESS_WRITE);
      registryObj.writeStringValue("", '"' + installFolder.path + '" "%1"');
      registryObj.close();
    } catch (ex) {
      debug(ex);
      debug("Couldn't write launch setting to registry, must have admin rights");
      registryObj.close();
    }
    
    try {
      var REG_BASE3 = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\eMusic Remote";
      var myLocalStrings = eStringBundleService
                             .createBundle("chrome://emusic/locale/emusic.properties");
      var appVersion = Components.classes['@mozilla.org/xre/app-info;1']
                         .getService(Components.interfaces.nsIXULAppInfo).version

      registryObj.create(winRegKeys["HKLM"], REG_BASE3, nsIWindowsRegKey.ACCESS_WRITE);
      registryObj.writeStringValue("DisplayName", myLocalStrings.GetStringFromName("appName") + " " + appVersion);
      registryObj.writeStringValue("DisplayVersion", appVersion);

      registryObj.close();
    } catch (ex) {
      registryObj.close();
    }
  }

}

var legacyImport = {
  thisPausedDownloads: null,
  trackTotal: 0,
  currentTrack: 0,
  allTracks: null,

  init: function() {
    // import old download library
    var thisRegBase = eMusicRegistry.eMusicBaseReg;
    legacyImport.thisPausedDownloads = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "TempDirectory")

    if (legacyImport.thisPausedDownloads) {
      legacyImport.thisPausedDownloads += "\\PausedDownloads.xml";

      try {
        var obj_TargetFile = dlm_base.getLocalFileInterface(legacyImport.thisPausedDownloads);

        if (obj_TargetFile.exists()) {
          eWizard.importLegacy = true;
        }
      } catch (ex) {
        debug(ex)
      }
    }
  },
  
  legacyKickOff: function() {
    var thisRegBase = eMusicRegistry.eMusicBaseReg;

    /* --- old registry entries (Windows Only) */
    eMusicPlatform.downloadDirectory = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "DownloadDirectory")

    var thisFileNamingTemplate      = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "FileNamingTemplate")
    var thisFileNamingSeparator     = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "FileNamingSeparator")
    var thisCreateAlbumDirectory    = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "CreateAlbumDirectory")
    var thisCreateArtistDirectory   = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "CreateArtistDirectory")
    var thisAutoClearCancelled      = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "AutoClearCancelled")
    var thisQuitWhenDone            = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "QuitWhenDone")
    
    if (thisFileNamingSeparator)    nsPreferences.setUnicharPref("eMusic.FileNamingSeparator", thisFileNamingSeparator);
    if (thisFileNamingTemplate)     nsPreferences.setUnicharPref("eMusic.FileNamingTemplate", thisFileNamingTemplate);
    
    if (thisCreateAlbumDirectory)   nsPreferences.setBoolPref("eMusic.CreateAlbumDirectory", thisCreateAlbumDirectory);
    if (thisCreateArtistDirectory)  nsPreferences.setBoolPref("eMusic.CreateArtistDirectory", thisCreateArtistDirectory);
    if (thisAutoClearCancelled)     nsPreferences.setBoolPref("eMusic.AutoClearCancelled", thisAutoClearCancelled);
    if (thisQuitWhenDone)           nsPreferences.setBoolPref("eMusic.QuitWhenDone", thisQuitWhenDone);
    
    // import filenaming template
    if (thisFileNamingTemplate) {
      var NameParts = thisFileNamingTemplate.split(thisFileNamingSeparator)

      nsPreferences.setBoolPref("eMusic.template.artist", false);
      nsPreferences.setBoolPref("eMusic.template.track", false);

      for (var i = 0; i < NameParts.length; i++) {
        nsPreferences.setBoolPref("eMusic.template." + NameParts[i], true);
      }
    }

    /* TEMPORARILY DISABLING LIBARY IMPORTING */
    eWizard.skipImport();
    
    return true;
    /* TEMPORARILY DISABLING LIBARY IMPORTING */

    document.getAnonymousElementByAttribute(document.getElementById('eWizard'), 'anonid', 'Header')
      .setAttribute("label", "Importing Download Manager 3.0 Settings...")

    document.getElementById("importButtons").hidden = true;

    document.getElementById('eWizard').getButton("back").setAttribute("disabled", "true");
    document.getElementById('eWizard').getButton("next").setAttribute("disabled", "true");
    document.getElementById('eWizard').getButton("cancel").setAttribute("disabled", "true")
    document.getElementById('eWizard').getButton("finish").setAttribute("disabled", "true")

    var thisCountStatus = document.getElementById("import-count")
    thisCountStatus.setAttribute("value", "");
    var thisStatusBar = document.getElementById("status-display")
    thisStatusBar.setAttribute("value", "Preparing DLM 3.0 Track List...");
    setTimeout(function(){legacyImport.parseLegacy(legacyImport.thisPausedDownloads)}, 100);

    return true;
  },

  parseLegacy: function() {

    var thisCountStatus = document.getElementById("import-count")

    var thisStatusBar = document.getElementById("status-display")
    thisCountStatus.setAttribute("style", "font-size: 45px; font-weight: bold;")
    var baseStatusMsg = "Importing DLM 3.0 Track List"
    thisStatusBar.setAttribute("value", baseStatusMsg);

    var myDownloadList = dlm_base.getContents(legacyImport.thisPausedDownloads)

    // make the eMusic mess correct base64 - from original perl script y@._-@+/=@
    myDownloadList = myDownloadList.replace(/\./g,"+");
    myDownloadList = myDownloadList.replace(/\_/g,"/");
    myDownloadList = myDownloadList.replace(/\-/g,"=");

    var parsed64 = atob(myDownloadList)
    var decryptedEMP = rc4Decrypt("kljsdmcjh3,m4hod87lkjh43iuydfkjhsdufyklmnsdfysd8of34kh", parsed64)

//debug(decryptedEMP)
    var xmlParser = new DOMParser();
    var xmlDoc = xmlParser.parseFromString(decryptedEMP, "text/xml");
    
    // Traverse through all tracks that are available
    legacyImport.allTracks = xmlDoc.getElementsByTagName("TRACK");
    legacyImport.trackTotal = legacyImport.allTracks.length
    
    eDownloadManager.datasource.beginUpdateBatch();
    setTimeout(legacyImport.insertLegacy, 10)
  },

  insertLegacy: function() {

    var thisCountStatus = document.getElementById("import-count")
    var thisStatusBar = document.getElementById("status-display")
    //var thisCount
  
    try {
      var thisTrack = legacyImport.allTracks[legacyImport.currentTrack];

      var fileKey = thisTrack.getElementsByTagName("SAVENAME")[0].firstChild.data;

      var obj_TargetFile = dlm_base.getLocalFileInterface(fileKey);

      //thisCount = Math.floor((legacyImport.currentTrack * 100.0) / legacyImport.trackTotal)
      if (obj_TargetFile.exists()) {
        setRDFRoot(fileKey);
  
        setRDFProperty(fileKey, "Name", thisTrack.getElementsByTagName("FILENAME")[0].firstChild.data);
        setRDFProperty(fileKey, "ProgressPercent", 100, false, rdfInt);
        setRDFProperty(fileKey, "DownloadState", 1, false, rdfInt);
        setRDFProperty(fileKey, "artist", thisTrack.getElementsByTagName("ARTIST")[0].firstChild.data);

        var thisAlbum = thisTrack.getElementsByTagName("ALBUM")[0].firstChild.data;
        
        var albumRsrcURI = "album" + thisAlbum;
        addDownloadAlbum(albumRsrcURI);
        setRDFProperty(albumRsrcURI, "trackRsrc", fileKey, true, rdfRes);
        setRDFProperty(albumRsrcURI, "name", thisAlbum);
        setRDFProperty(albumRsrcURI, "genre", thisTrack.getElementsByTagName("GENRE")[0].firstChild.data);
        setRDFProperty(albumRsrcURI, "artist", thisTrack.getElementsByTagName("ARTIST")[0].firstChild.data);
        setRDFProperty(albumRsrcURI, "type", "album");

        setRDFProperty(fileKey, "album", thisAlbum);

        if (getRDFProperty(fileKey, "albumRsrc") == "") {
          //setRDFProperty(thisTrack.getElementsByTagName("FILENAME")[0].firstChild.data, "albumRsrc", albumRsrcURI, true, rdfRes);
          setRDFProperty(fileKey, "albumRsrc", albumRsrcURI, true, rdfRes);
        }  

        setRDFProperty(fileKey, "title", thisTrack.getElementsByTagName("TITLE")[0].firstChild.data);
        setRDFProperty(fileKey, "albumart", thisTrack.getElementsByTagName("ALBUMART")[0].firstChild.data);
        setRDFProperty(fileKey, "genre", thisTrack.getElementsByTagName("GENRE")[0].firstChild.data);
        setRDFProperty(fileKey, "duration", dlm_base.secondsToTime(thisTrack.getElementsByTagName("DURATION")[0].firstChild.data));
        setRDFProperty(fileKey, "DateStarted", new Date());
        setRDFProperty(fileKey, "DateEnded", new Date());
        setRDFProperty(fileKey, "URL", thisTrack.getElementsByTagName("LOCATION")[0].firstChild.data, false, rdfRes);
        setRDFProperty(fileKey, "File", fileKey, false, rdfRes);
        setRDFProperty(fileKey, "tracknum",   thisTrack.getElementsByTagName("TRACKNUM")[0].firstChild.data);
        setRDFProperty(fileKey, "tracktype",   "music");
        setRDFProperty(fileKey, "albumurl",   "http://www.emusic.com/");
        setRDFProperty(fileKey, "artisturl",  "http://www.emusic.com/");
        setRDFProperty(fileKey, "genreurl",   "http://www.emusic.com/");
      }
    } catch (ex) {
      debug(ex)
    }
    
    legacyImport.currentTrack++
    
    thisCountStatus.setAttribute("value", legacyImport.currentTrack);

    thisStatusBar.setAttribute("value", "Importing " + legacyImport.trackTotal +
                               " previous tracks.");

    if (legacyImport.currentTrack < legacyImport.trackTotal) {
      setTimeout(legacyImport.insertLegacy, 10)
    } else {
      thisCountStatus.setAttribute("value", legacyImport.trackTotal);

      var thisMessage = "Importing complete!"
      thisStatusBar.setAttribute("value", thisMessage)
      //dlm_base.popup(thisMessage);
      eDownloadManager.datasource.endUpdateBatch();
      eDownloadManager.datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();      //document.getElementById('eWizard').goTo("player")

      var mainWindow = dlm_base.mostRecentWindow();

      if (mainWindow) {
        mainWindow.eDownloadsView.builder.rebuild();
        mainWindow.eDownloadsView.builder.refresh();

        mainWindow.eDownloadsAlbumView.builder.rebuild();
        mainWindow.eDownloadsAlbumView.builder.refresh();

        mainWindow.eDownloadsAudioBooksView.builder.rebuild();
        mainWindow.eDownloadsAudioBooksView.builder.refresh();
      }

      document.getElementById('eWizard').getPageById("welcome").setAttribute("next", "player")
      document.getElementById('eWizard').getButton("back").setAttribute("disabled", "false");
      document.getElementById('eWizard').getButton("next").setAttribute("disabled", "false");
      document.getElementById('eWizard').getButton("cancel").setAttribute("disabled", "false")
      document.getElementById('eWizard').getButton("finish").setAttribute("disabled", "false")
    }

  }
}

eMusicRegistry.resetStartup();
