/** Copyright © 2007 eMusic.com Inc.
 
This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.  The GNU Lesser General Public License can be viewed by clicking on the following link:  http://www.gnu.org/licenses/lgpl.html#SEC4.  
 
This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**/

function dlmlistener() {
}

dlmlistener.prototype = {
  name: null,
  uri: null,
  file: null,
  transfer: null,

  init:  function(name,uri,file,transfer) {
    this.name      = name;
    this.uri       = uri;
  	this.file      = file;
  	this.transfer  = transfer;
  },

  onLocationChange: function(webProgress, request, location) {
    this.transfer.onLocationChange(webProgress, request, location);
  }, 
  
  onProgressChange: function(webProgress, request, curSelfProgress, maxSelfProgress, curTotalProgress, maxTotalProgress) {
  	this.transfer.onProgressChange(webProgress, request, curSelfProgress, maxSelfProgress, curTotalProgress, maxTotalProgress);

    // Calculate percentage.
    var percent = 0;

    if (maxTotalProgress > 0) {
      percent = Math.floor((curTotalProgress * 100.0) / maxTotalProgress);

      setRDFProperty(this.file.path, "ProgressPercent", percent)
    }
  },
  
  onSecurityChange: function(webProgress, request, state) {
  	this.transfer.onSecurityChange(webProgress, request, state);
  },
  
  onStateChange:  function(webProgress, request, stateFlags, status) {
    const WPL = Components.interfaces.nsIWebProgressListener;

    const NS_BINDING_ABORTED = 0x804b0002;

    try {var httpChannel = request.QueryInterface(Components.interfaces.nsIHttpChannel);
      var thisRequestStatus = httpChannel.responseStatus
      var thisRequestLength = httpChannel.getResponseHeader("Content-Length")
    } catch(ex) {
    }

    if (stateFlags & WPL.STATE_START) {
     
      switch (thisRequestStatus) {
        case 200:
          if (thisRequestLength == 0 || status == 2147500037) {
            debug("responseStatus: " + thisRequestStatus + " : " + this.file.path)
            debug("Content-Length: " + thisRequestLength + " : " + this.file.path)

            gHadDownloadErrors = true;

            request.cancel(NS_BINDING_ABORTED);

            dlm_base.removeFile(this.file.path);
          } else {
            setTimeout(function(){toggleTotalProgress(false)}, 500);
          }

          break;
        default:
          debug("responseStatus: " + thisRequestStatus + " : " + this.file.path)
          debug("Content-Length: " + thisRequestLength + " : " + this.file.path)
          request.cancel(NS_BINDING_ABORTED);

          gHadDownloadErrors = true;

          dlm_base.removeFile(this.file.path);
      }
    } else if (stateFlags & WPL.STATE_STOP) {

      //document.getElementById("dlmDirectoryTree").builder.rebuild();

      setTimeout(function(){toggleTotalProgress(false)}, 500);

      var mainWindow = dlm_base.mostRecentWindow("emusic:window");
      
      if (mainWindow.eMediaSync != "NoSync" && status == 0) {
        //debug("calling syncMedia: " + mainWindow.eMediaSync);
        
        var tmpFile = new Array()
        tmpFile.push(this.file.path);
        //debug(this.file.path)
  
        setTimeout(function() {mainWindow.mediaManagers[mainWindow.eMediaSync].syncMedia(tmpFile);}, 250);
      }

    }

  	this.transfer.onStateChange(webProgress, request, stateFlags, status);

  },
  
  onStatusChange:  function(webProgress, request, status, message) {
  	this.transfer.onStatusChange(webProgress, request, status, message);
  }, 
  
  QueryInterface:  function(iid) {
  	if (iid.equals(Components.interfaces.nsIWebProgressListener)
  		|| iid.equals(Components.interfaces.nsIDownloadListener)
  		|| iid.equals(Components.interfaces.nsISupports))
  		return this;
  	else (iid.equals(Components.interfaces.nsIRDFRemoteDataSource))
  		throw Components.results.NS_ERROR_NO_INTERFACE;
  }
}


function audiobookslistener() {
}

audiobookslistener.prototype = {
  name: null,
  uri: null,
  file: null,
  transfer: null,

  init:  function(name,uri,file,transfer) {
    this.name      = name;
    this.uri       = uri;
  	this.file      = file;
  	this.transfer  = transfer;
  },

  onLocationChange: function(webProgress, request, location) {
    this.transfer.onLocationChange(webProgress, request, location);
  }, 
  
  onProgressChange: function(webProgress, request, curSelfProgress, maxSelfProgress, curTotalProgress, maxTotalProgress) {
  	this.transfer.onProgressChange(webProgress, request, curSelfProgress, maxSelfProgress, curTotalProgress, maxTotalProgress);

    // Calculate percentage.
    var percent = 0;

    if (maxTotalProgress > 0) {
      percent = Math.floor((curTotalProgress * 100.0) / maxTotalProgress);

      setRDFProperty(this.file.path, "ProgressPercent", percent)
    }
  },
  
  onSecurityChange: function(webProgress, request, state) {
  	this.transfer.onSecurityChange(webProgress, request, state);
  },
  
  onStateChange: function(webProgress, request, stateFlags, status) {
    const WPL = Components.interfaces.nsIWebProgressListener;

    const NS_BINDING_ABORTED = 0x804b0002;

    try {var httpChannel = request.QueryInterface(Components.interfaces.nsIHttpChannel);
      var thisRequestStatus = httpChannel.responseStatus
      var thisRequestLength = httpChannel.getResponseHeader("Content-Length")
    } catch(ex) {
    }

    if (stateFlags & WPL.STATE_START) {
     
      switch (thisRequestStatus) {
        case 200:
          if (thisRequestLength == 0 || status == 2147500037) {
            debug("responseStatus: " + thisRequestStatus + " : " + this.file.path)
            debug("Content-Length: " + thisRequestLength + " : " + this.file.path)

            gHadDownloadErrors = true;

            request.cancel(NS_BINDING_ABORTED);

            dlm_base.removeFile(this.file.path);
          } else {
            setTimeout(function(){toggleTotalProgress(false)}, 500);
          }

          break;
        default:
          debug("responseStatus: " + thisRequestStatus + " : " + this.file.path)
          debug("Content-Length: " + thisRequestLength + " : " + this.file.path)
          request.cancel(NS_BINDING_ABORTED);

          gHadDownloadErrors = true;

          dlm_base.removeFile(this.file.path);
      }
    } else if (stateFlags & WPL.STATE_STOP) {

      var mainWindow = dlm_base.mostRecentWindow("emusic:window");

//debug(mainWindow.eAudiobooksQueue.length)
      setTimeout(function(){toggleTotalProgress(false)}, 500);

      if (mainWindow.eAudiobooksQueue.length != 0) {
        setTimeout(function(){mainWindow.downloadAudiobookTrack();}, 500);
      }

      if (mainWindow.eMediaSync != "NoSync" && status == 0) {
        //debug("calling syncMedia: " + mainWindow.eMediaSync);
        
        var tmpFile = new Array()
        tmpFile.push(this.file.path);
        //debug(this.file.path)
  
        setTimeout(function() {mainWindow.mediaManagers[mainWindow.eMediaSync].syncMedia(tmpFile);}, 250);
      }
    }

  	this.transfer.onStateChange(webProgress, request, stateFlags, status);

  },
  
  onStatusChange:  function(webProgress, request, status, message) {
  	this.transfer.onStatusChange(webProgress, request, status, message);
  }, 
  
  QueryInterface:  function(iid) {
  	if (iid.equals(Components.interfaces.nsIWebProgressListener)
  		|| iid.equals(Components.interfaces.nsIDownloadListener)
  		|| iid.equals(Components.interfaces.nsISupports))
  		return this;
  	else (iid.equals(Components.interfaces.nsIRDFRemoteDataSource))
  		throw Components.results.NS_ERROR_NO_INTERFACE;
  }
}

  
// implementation of nsIURIContentListener
// http://forums.mozillazine.org/viewtopic.php?p=2090958
const EMP_MIMETYPE = "application/vnd.emusic-emusic_package"
const EMX_MIMETYPE = "application/vnd.emusic-emusic_list"
const M3U_MIMETYPE = "audio/x-mpegurl"

var dlmContentListener = {
  thisTimer: null,
  thisFile: null,
  
  QueryInterface: function(iid) {
    if (iid.equals(Components.interfaces.nsIURIContentListener) ||
        iid.equals(Components.interfaces.nsISupportsWeakReference) ||
        iid.equals(Components.interfaces.nsISupports))
        return this;
    throw Components.results.NS_NOINTERFACE;
  },

  onStartURIOpen: function(uri) {
    return false;
  },

  doContent: function(contentType, isContentPreferred, request, contentHandler) {
    // We handle this type
    var channel = request.QueryInterface(Components.interfaces.nsIChannel);
    var myURL = nsIURIToString(channel.URI)

    switch (contentType) {
      case EMP_MIMETYPE:
      case EMX_MIMETYPE:

      	var urlObj = Components.classes['@mozilla.org/network/standard-url;1']
                       .createInstance(Components.interfaces.nsIURL);
      	urlObj.spec = myURL;
        var thisFileExtension = urlObj.fileExtension.toLowerCase()

        try {
          dlm_base.mostRecentWindow().processEM(myURL, urlObj.scheme, thisFileExtension);
          //debug(ex);
        } catch (ex) {
          debug("Parsing error (targetBrowser): Probably need to login, parsing error or has exceeded monthly download, redirecting");
          debug(ex);
          dlm_base.mostRecentWindow().dlm_web.goThere(myURL)
        }

        return true;
        break;
      case M3U_MIMETYPE:
        //debug(myURL)
        
        var urlObj = Components.classes['@mozilla.org/network/standard-url;1']
                       .createInstance(Components.interfaces.nsIURL);
      	urlObj.spec = myURL;

        if (urlObj.fileExtension.toLowerCase() == "m3u") {
          var tmpPath = dlm_base.getSpecialFolder("TmpD");
          
          tmpPath.append("emusic_m3us")
          var origTmpPath = tmpPath.clone()

          if (!tmpPath.exists()) {
            try {
              tmpPath.create(0x01,0777);
            } catch(ex) {
              return false;
              debug(ex);
            }
          }

          tmpPath.append(urlObj.fileName);
          tmpPath.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0777);

          this.thisFile = tmpPath.path;

          silentFileDownload(myURL, tmpPath.path, true, this.myListener)

          var entries = origTmpPath.directoryEntries;

          clearTimeout(this.thisTimer)
  
          this.thisTimer = setTimeout(function() {
            var array = [];
            while(entries.hasMoreElements()) {
              var entry = entries.getNext();
              entry.QueryInterface(Components.interfaces.nsIFile);
              //debug(entry.path)
              //debug(tmpPath.path)
              if (entry.path != tmpPath.path) {
                //debug(entry.path);
                entry.remove(false);
              }
            }
          }, 10000);
        }
        return true;
        break;
    }
    return false;
  },

  isPreferred: function(contentType, desiredContentType) {
    // We handle this type
    switch (contentType) {
      case EMP_MIMETYPE:
      case EMX_MIMETYPE:
      case M3U_MIMETYPE:
        return true;
        break;
    }
    return false;
  },

  canHandleContent: function(contentType, isContentPreferred, desiredContentType) {
    // We handle this type
    switch (contentType) {
      case EMP_MIMETYPE:
      case EMX_MIMETYPE:
      case M3U_MIMETYPE:
        return true;
        break;
    }
    return false;
  },

  GetWeakReference: function() {
    return this;
  },

  myListener: {
    STATE_STOP: Components.interfaces.nsIWebProgressListener.STATE_STOP,
    STATE_START: Components.interfaces.nsIWebProgressListener.STATE_START,
    STATE_TRANSFERRING: Components.interfaces.nsIWebProgressListener.STATE_TRANSFERRING,

    QueryInterface : function(aIID) {
      if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
          aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
          aIID.equals(Components.interfaces.nsISupports))
        return this;
      throw Components.results.NS_NOINTERFACE;
    },
  
    onStateChange:function(aProgress, aRequest, aFlag, aStatus) {
      if (aFlag & this.STATE_START) {
      }
      if (aFlag & this.STATE_STOP) {
        try {
          //var channel = aRequest.QueryInterface(Components.interfaces.nsIChannel);
          //var thisLocalFile = nsIURIToString(channel.URI)

          dlm_base.mostRecentWindow().listenToTrack(dlmContentListener.thisFile);

        } catch(ex) {
          debug(ex)
        }
      }
    },

    onLocationChange:function(a,b,c){},

    onProgressChange:function(a,b,c,d,e,f){

      if(this.STATE_TRANSFERRING) {
        try {
          /*document.getElementById("statusbar-display").label = 
            local_common.myListenerStartMsg + ": " + Math.ceil((e/f) * 100);*/

        } catch(ex) {
        }
      }
    },

    onStatusChange:function(a,b,c,d){},

    onSecurityChange:function(a,b,c){},

    onLinkIconAvailable:function(a){}
  }
}

function nsIURIToString(uri) {
    var result = uri.scheme + "://";
    result += uri.host;
    if (uri.port > 0)result += uri.port;
    result += uri.path;
    return result;
}

// Set up the content listener
var uriLoader = Components.classes["@mozilla.org/uriloader;1"].getService(Components.interfaces.nsIURILoader);
uriLoader.registerContentListener(dlmContentListener);
