/** Copyright © 2007 eMusic.com Inc.
 
This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.  The GNU Lesser General Public License can be viewed by clicking on the following link:  http://www.gnu.org/licenses/lgpl.html#SEC4.  
 
This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**/

const Ci = Components.interfaces

var myLocalBundleService = Components.classes["@mozilla.org/intl/stringbundle;1"]
      .getService(Components.interfaces.nsIStringBundleService);

var prefBranch_eMusic = null;
var prefBranch_themeChanged = null;
var prefBranch_downloadPathChanged = null;

var eBrowser = null
var eSearchURL = null
var eNavToolbox = null
var eMediaPlayer = null
var eMediaSync = null
var eMediaPlayerIcon = null
var eDLMRootPivot = null
var eContextMenu = null
var eDownloadsView = null
var eDownloadsAlbumView = null
var eDownloadsAudioBooksView = null
var eTrackPreview = null

var eURLBar = null
var eDefaultServer = null
var eDefaultHomePage = null

var bInitializing = false
var bPopupOff = false

var eSaveAlbumArt = nsPreferences.getBoolPref("eMusic.saveAlbumArt")
 
if (typeof gBrowser == "undefined") var gBrowser = null
if (typeof gURLBar == "undefined") var gURLBar = null
if (typeof appcontent == "undefined") var appcontent = null
if (typeof appCore == "undefined") var appCore = null

var eCurrentDeck = nsPreferences.getIntPref("eMusic.currentDeck")
var eDownloadDeck = nsPreferences.getIntPref("eMusic.downloadDeck")

var prefObserver = {

  getBranchPrefInterface: function (thisBranch) {
    if (typeof Components.interfaces.nsIPrefBranch2 == "undefined") {
      return thisBranch.QueryInterface(Components.interfaces.nsIPrefBranchInternal); //1.0.x support
    } else {
      return thisBranch.QueryInterface(Components.interfaces.nsIPrefBranch2); // 1.5+ support
    }
  },
  
  register: function() {
    var prefService = Components.classes["@mozilla.org/preferences-service;1"].
      getService(Components.interfaces.nsIPrefService);

    if(!prefBranch_downloadPathChanged) {
      prefBranch_downloadPathChanged = prefService.getBranch("eMusic.download.");
      var pbi = prefObserver.getBranchPrefInterface(prefBranch_downloadPathChanged);
      pbi.addObserver("", this, false);
    }

    if(!prefBranch_eMusic) {
      prefBranch_eMusic = prefService.getBranch("eMusic.");
      var pbi = prefObserver.getBranchPrefInterface(prefBranch_eMusic);
      pbi.addObserver("", this, false);
    }

    if (!prefBranch_themeChanged) {
      prefBranch_themeChanged = prefService.getBranch("extensions.lastSelectedSkin");
      var themeObs = prefObserver.getBranchPrefInterface(prefBranch_themeChanged);
      themeObs.addObserver("", themeObserver, false);
    }
  },

  unregister: function() {
  
    if(!prefBranch_downloadPathChanged) return;
    var pbi = prefObserver.getBranchPrefInterface(prefBranch_downloadPathChanged);
    pbi.removeObserver("", this);

    if(!prefBranch_eMusic) return;
    var pbi = prefObserver.getBranchPrefInterface(prefBranch_eMusic);
    pbi.removeObserver("", this);

    if(!prefBranch_themeChanged) return;
    var themeObs = prefObserver.getBranchPrefInterface(prefBranch_themeChanged);
    themeObs.removeObserver("", themeObserver);

  },

  observe: function(aSubject, aTopic, aData) {
    if (aTopic != "nsPref:changed") return;

    switch (aData) {
      case "dir":
      case "folderList":
        setTimeout(initAutoDownloadDisplay, 250);
        break;
      case "cmdLineValue":
        var thisCmdLine = nsPreferences.copyUnicharPref("eMusic.cmdLineValue");
        if (thisCmdLine != "") {
          setTimeout(processCmdLinePref, 250);
        }
        break;
      case "defaultMediaPlayerObj":
      case "defaultMediaSync":
        setTimeout(refreshDefaultPlayer, 250);
        break;
      case "defaultHomePage":
        eDefaultHomePage = nsPreferences.copyUnicharPref('eMusic.defaultHomePage');
        break;
      case "defaultServer":
        eDefaultServer = nsPreferences.copyUnicharPref('eMusic.defaultServer');
        break;
      case "currentDeck":
        eCurrentDeck = nsPreferences.getIntPref('eMusic.currentDeck');
        break;
      case "downloadDeck":
        eDownloadDeck = nsPreferences.getIntPref("eMusic.downloadDeck");
        break;
      case "saveAlbumArt":
        eSaveAlbumArt = nsPreferences.getBoolPref("eMusic.saveAlbumArt");
    }

    return;
  }
}

function processCmdLinePref() {
  try {
    var branchService = Components.classes["@mozilla.org/preferences-service;1"]
                                   .getService(Components.interfaces.nsIPrefBranch);

    if (branchService.prefHasUserValue("eMusic.cmdLineValue")) {
    	var myURL = nsPreferences.copyUnicharPref("eMusic.cmdLineValue")
      var myURLExtension = myURL.split(".").pop().toLowerCase();
      myURLExtension = myURLExtension.substring(0,3);
      //myURLExtension = "emx";

      processEM(myURL, "file", myURLExtension)

      branchService.clearUserPref("eMusic.cmdLineValue");
    }
  } catch (ex) {
    debug(ex);
    nsPreferences.setUnicharPref("eMusic.cmdLineValue", "");
  }

}

function showThisDeck(thisDeck) {

  var hideBrowserParts = true

  eCurrentDeck = thisDeck;

  document.getElementById("eStackBox").setAttribute("selectedIndex", thisDeck);

  switch (thisDeck) {
    case 0:
      eNavToolbox = document.getElementById("navigator-toolbox")
      // prior to alpha 4 we were collapsing, this can probably be removed
      // after a while or if we reset it in the ftr section
      document.getElementById("eBrowserBox").collapsed = false;
      eTrackPreview.loadURI("chrome://emusic/locale/custom.html", null, null);
      hideBrowserParts = false;
      
      if (document.getElementById("urlbar").value == "chrome://emusic/locale/loading.html") {
        setTimeout(function() {dlm_web.goThere(nsPreferences.copyUnicharPref("eMusic.lastUrl")) }, 0);
      }
      break;
    case 1:
      eNavToolbox = document.getElementById("download-toolbox")
      // prior to alpha 4 we were collapsing, this can probably be removed
      // after a while or if we reset it in the ftr section
      document.getElementById("eDownloadBox").collapsed = false;
      document.getElementById("dlmTreeBox").collapsed = false;
      //eDownloadsView.builder.rebuild();
      //eDownloadsView.builder.refresh();
      initAutoDownloadDisplay();

      eDownloadDeck = thisDeck;

      setTimeout(function () {showAlbumPreview(); document.title = dlm_base.getName()}, 0);
      //document.title = dlm_base.getName()
      break;

    case 2:
      eNavToolbox = document.getElementById("download-directory-toolbox")
      initAutoDownloadDisplay()
      //eDownloadsView2.builder.rebuild();
      setTimeout(function () {showAlbumPreview(); document.title = dlm_base.getName()}, 0);
      //document.title = dlm_base.getName()
      break;

    case 3:
      eNavToolbox = document.getElementById("download-album-toolbox")
      //eDownloadsAlbumView.builder.rebuild();
      //eDownloadsAlbumView.builder.refresh();
      initAutoDownloadDisplay();

      eDownloadDeck = thisDeck;

      setTimeout(function () {showAlbumPreview(); document.title = dlm_base.getName()}, 0);
      //document.title = dlm_base.getName()
      break;

    case 4:
      eTrackPreview.loadURI("chrome://emusic/locale/custom.html", null, null);
      document.title = dlm_base.getName();
      break;

    case 5:
      eNavToolbox = document.getElementById("audiobooks-toolbox")
      eTrackPreview.loadURI("chrome://emusic/locale/custom.html", null, null);
      document.title = dlm_base.getName();
      //eDownloadsAudioBooksView.builder.rebuild();
      //eDownloadsAudioBooksView.builder.refresh();
      initAutoDownloadDisplay();

      //eDownloadDeck = thisDeck;

      setTimeout(function () {showAlbumPreview(); document.title = dlm_base.getName()}, 0);
      break;
  }

  document.getElementById("security-button").hidden = hideBrowserParts;
  document.getElementById("statusbar-icon").hidden = hideBrowserParts;

  nsPreferences.setIntPref("eMusic.currentDeck", thisDeck);
  nsPreferences.setIntPref("eMusic.downloadDeck", eDownloadDeck);

  if (eCurrentDeck == 0 && !eURLBar.value && !bInitializing) {
    dlm_web.goThere(nsPreferences.copyUnicharPref("eMusic.lastUrl"));
  }
}

function showAlbumPreview() {
  try {
    var whichView

    switch (eCurrentDeck) {
      case 5:
        whichView = eDownloadsAudioBooksView;
        break;
      case 3:
        whichView = eDownloadsAlbumView;
        break;
      default:
        whichView = eDownloadsView;
    }

    var lastSelected = whichView.getAttribute("last-selected");
    if (!lastSelected) lastSelected = 0
    
    whichView.view.selection.select(lastSelected)

    var boxobject = whichView.boxObject;
    boxobject.QueryInterface(Components.interfaces.nsITreeBoxObject);
    //boxobject.scrollToRow(lastSelected);
    boxobject.ensureRowIsVisible(lastSelected);

  } catch (ex) {
    debug(ex)
  }
}

function setStatusBar(thisToggle) {
  document.getElementById("statusbarcontainer").setAttribute("collapsed", thisToggle);
}

function setMinimizeToTray(thisToggle) {

  if (!thisToggle) {
    thisToggle = false
  } else {
    thisToggle = true
  }
  nsPreferences.setBoolPref("extensions.minimizetotray.always", thisToggle);
}

function targetBrowser(event) {
// disable target for any link as well as provide special handling for rss & other links
  try {
    var thisTarget = event.target;

    if (thisTarget) {

      // Walk the node tree to find the actual clicked link, this resolves clicking on images
      // http://www.sitepoint.com/article/javascript-from-scratch/7
      var myURL 

      try {
        while(thisTarget.nodeName.toLowerCase() != "a") {
          thisTarget = thisTarget.parentNode;
        }
        myURL = thisTarget.href
      } catch (ex) {
        return false;
      }
    }

    if (thisTarget.hasAttribute("onclick"))
      return true;
    
    var urlObj = Components.classes['@mozilla.org/network/standard-url;1']
                   .createInstance(Components.interfaces.nsIURL);
    urlObj.spec = myURL;

    if (urlObj.path.indexOf("/downloads/emx/") == 0 ||
        urlObj.path.indexOf("/downloads/emp/") == 0) {
      return true;
    }

    if (urlObj.scheme == "javascript" && !(/^(xpi)|^(jar)/.test(thisFileExtension))) {
      return true;
    }

    switch (event.button) {
      case 0:
        var thisFileExtension = urlObj.fileExtension.toLowerCase()

      	switch (thisFileExtension) {
          case "xpi":
          case "jar":
            TriggerInstall(event, thisFileExtension, urlObj.fileName);
            break;
          default:
            var shift = event.shiftKey;
            var ctrl =  event.ctrlKey;
            var meta =  event.metaKey;
            var alt  =  event.altKey;

            if (shift || ctrl || meta || alt) {
              openUILinkIn(myURL, shift ? "tabshifted" : "tab")
            } else {
              openUILinkIn(myURL, "current")
            }

        }
        break;
      case 1: // middle-click
        openUILinkIn(myURL, "tab")
        //openExternal(myURL); // launch external on middle click
        break;
      case 2: // right-click
        try {
          event.dispatchEvent();
        } catch (ex) {
        }
        return true;
        break;
    }

    event.preventDefault();
    event.stopPropagation();
  } catch (ex) {
    //debug("(TargetBrowser) " + ex);
    dlm_web.goThere(myURL);
  } 
  
  return true;
}

function processEM(empURL, empScheme, empFileExtension) {

  toggleTotalProgress(true);

  switch (empScheme) {
    case "http":
      var req = new XMLHttpRequest();
      req.open('GET', empURL, true);
      req.onreadystatechange = function (aEvt) {
        if (req.readyState == 4) {
          if(req.status == 200) {
            var empSample = req.responseText;
            eval("eParser." + empFileExtension + "(empSample, empURL)")
          } else {
            debug("Error loading page\n");
            toggleTotalProgress(false);
            dlm_web.goThere(empURL)
          }
        }
      };

      req.send(null);
      break;
    default: // should be local link, try reading it
      empURL = dlm_base.scrubPath(empURL)

      var empSample = dlm_base.getContents(empURL)
      eval("eParser." + empFileExtension + "(empSample, empURL)")
      break;
  }
}

var eParser = {

  emx: function(empSample, empURL) {

    try {
      if (!empSample) 
        return false

      var xmlParser = new DOMParser();
      var xmlDoc = xmlParser.parseFromString(empSample, "text/xml");

      if (/XML Parsing Error/i.test(xmlDoc.documentElement.firstChild.nodeValue) ? true : false) {
        throw(xmlDoc.documentElement.firstChild.nodeValue)
        return false;
      }
      // Traverse through all tracks that are available
      
      var allTracks = xmlDoc.getElementsByTagName("TRACK");

      var arrDownloadObjects = new Array

      for (var i=0; i < allTracks.length; i++) {
  
        var objDownloadItem = {};

        // Process all child nodes and add to associative array.
        var nodes = allTracks[i].childNodes
        for (var x=0; x < nodes.length; x++) {
          if (nodes[x].nodeType==1 && allTracks[i].getElementsByTagName(nodes[x].nodeName)[0].firstChild) {
            objDownloadItem[nodes[x].nodeName] = allTracks[i].getElementsByTagName(nodes[x].nodeName)[0].firstChild.data
          } else if (nodes[x].nodeType==1) {
            objDownloadItem[nodes[x].nodeName] = ""
          }
        }
  
        if (objDownloadItem["GENRE"] == "Audiobooks") {
          eAudiobooksQueue.push(objDownloadItem)
        } else {
          arrDownloadObjects.push(objDownloadItem);
        }
      }

      var downloadQueueLength = arrDownloadObjects.length;
      
      for (var i=0; i < downloadQueueLength; i++) {
        var thisDLFileObj = arrDownloadObjects.pop()
        //debug(thisDLFileObj["TITLE"])
        //debug(Date() + " : " + thisDLFileObj["TITLE"])
        goGetIt(thisDLFileObj);
      }
      
      if (eAudiobooksQueue.length != 0) {
        downloadAudiobookTrack();
        //downloadAudiobookTrack();

        if (eCurrentDeck != 0) {
          showThisDeck(5);
          //document.getElementById("dlAudioBooksView").selected = true;
        }
      } else if (eCurrentDeck != 0) {
        showThisDeck(eDownloadDeck);
      }

    } catch (ex) {
      debug("Parsing error (eParser): Probably parsing error or has exceeded monthly download, just redirect");
      bPopupOff = true;
      toggleTotalProgress(false);
      debug(ex);
      debug(empURL)
      dlm_web.goThere(empURL)
    }

    try {
      var obj_TargetFile = dlm_base.removeFile(empURL);
    } catch (ex) {
    }

    return true;
  },

  emp: function(empSample, empURL) {
    // make the eMusic mess correct base64 - from original perl script y@._-@+/=@
    empSample = empSample.replace(/\./g, "+");
    empSample = empSample.replace(/\_/g, "/");
    empSample = empSample.replace(/\-/g, "=");

    // mozilla has btoa function for base64 decoding and atob function for encoding
    var decryptedEMP
    try {
      decryptedEMP = rc4Decrypt("kljsdmcjh3,m4hod87lkjh43iuydfkjhsdufyklmnsdfysd8of34kh", atob(empSample));
    } catch (ex) {
      debug("user not logged in or has exceed monthly download, ...");
      toggleTotalProgress(false);
      debug(ex);
      dlm_web.goThere(empURL)
      return false;
    }

    //debug(decryptedEMP)
    try {
      var xmlParser = new DOMParser();
      var xmlDoc = xmlParser.parseFromString(decryptedEMP, "text/xml");
    
      // Get Download Server path information from decrypted emp xml file 
      var objDownloadItem = {};
    
      var dlmXML = xmlDoc.getElementsByTagName("SERVER");
      objDownloadItem["NETNAME"] = dlmXML[0].getElementsByTagName("NETNAME")[0].firstChild.data;
      objDownloadItem["LOCATION"] = dlmXML[0].getElementsByTagName("LOCATION")[0].firstChild.data;
    
      objDownloadItem["BASESERVERURL"] = "http://" + objDownloadItem["NETNAME"] + objDownloadItem["LOCATION"]
    
      // Traverse through all tracks that are available
      var allTracks = xmlDoc.getElementsByTagName("TRACK");

      eDownloadManager.datasource.beginUpdateBatch();

      for (var i=0; i < allTracks.length; i++) {
        //listALBUM   = allTracks[i].getElementsByTagName("ALBUM")[0].childNodes[0].nodeValue;
    
        // Process all child nodes and add to array.
        var nodes = allTracks[i].childNodes
        for (var x=0; x < nodes.length; x++) {
          if (nodes[x].nodeType==1 && allTracks[i].getElementsByTagName(nodes[x].nodeName)[0].firstChild) {
            objDownloadItem[nodes[x].nodeName] = allTracks[i].getElementsByTagName(nodes[x].nodeName)[0].firstChild.data
          } else if (nodes[x].nodeType==1) {
            objDownloadItem[nodes[x].nodeName] = ""
          }
        }

        // Create bogus track & disk number/count entries 
        // that are only available with EMX format
        objDownloadItem["DISCNUM"]    = "01";
        objDownloadItem["DISCCOUNT"]  = "01";
        objDownloadItem["TRACKCOUNT"] = "00";
        
        // remap value to support EMX format
        objDownloadItem["EXTENSION"]   = objDownloadItem["FORMAT"];
        
        // Build TRACKURL
        objDownloadItem["TRACKURL"]   = objDownloadItem["BASESERVERURL"];
        objDownloadItem["TRACKURL"]   = objDownloadItem["TRACKURL"].replace(/\%fid/, objDownloadItem["TRACKID"]);
        objDownloadItem["TRACKURL"]   = objDownloadItem["TRACKURL"].replace(/\%f/, objDownloadItem["FILENAME"]);

        setTimeout(function() {goGetIt(objDownloadItem)}, 0);
      }

      eDownloadManager.datasource.endUpdateBatch();

    } catch (ex) {
      debug("Parsing error (eParser): Probably parsing error or has exceeded monthly download, just redirect");
      bPopupOff = true;
      toggleTotalProgress(false);
      debug(ex);
      dlm_web.goThere(empURL)
    }

    try {
      dlm_base.removeFile(empURL);
    } catch (ex) {
    }
    return true;
  }
}

function downloadAudiobookTrack() {
  if (eAudiobooksQueue.length > 0) {
    var thisDLFileObj = eAudiobooksQueue.shift()
    //debug(thisDLFileObj["TITLE"])
    //debug(Date() + " : " + thisDLFileObj["TITLE"])
    goGetIt(thisDLFileObj);
  }
}

function goGetIt(myDownloadItem) {

  var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService);

  var prefs = nsPreferences.mPrefService;
  var fileToSave = prefs.getComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile)

  var tmpSeparator = nsPreferences.copyUnicharPref("eMusic.FileNamingSeparator")

  // clean strings to build proper path/file to save
  var tmpALBUM                 = dlm_base.scrub(myDownloadItem["ALBUM"]);
  var tmpTITLE                 = dlm_base.scrub(myDownloadItem["TITLE"]);
  var tmpARTIST                = dlm_base.scrub(myDownloadItem["ARTIST"]);
  myDownloadItem["TRACKNUM"]   = dlm_base.padZero(myDownloadItem["TRACKNUM"], myDownloadItem["TRACKCOUNT"].length);
  myDownloadItem["DISCCOUNT"]  = dlm_base.padZero(myDownloadItem["DISCCOUNT"], 2);
  myDownloadItem["DISCNUM"]    = dlm_base.padZero(myDownloadItem["DISCNUM"], 2);
  
  if (!myDownloadItem["STYLES"]) myDownloadItem["STYLES"] = "" // temporary patch

  // force disc count in file name
  if (myDownloadItem["DISCCOUNT"] != "01") {
    myDownloadItem["TRACKNUM"] = myDownloadItem["DISCNUM"] + tmpSeparator + myDownloadItem["TRACKNUM"]
  }

  try {
		if (nsPreferences.getBoolPref("eMusic.CreateArtistDirectory")) {
      fileToSave.append(tmpARTIST);
    }

		if (nsPreferences.getBoolPref("eMusic.CreateAlbumDirectory")) {
      fileToSave.append(tmpALBUM);
    }
		
		//template values = artist - track - album - number

    var tmpFileName = nsPreferences.copyUnicharPref("eMusic.FileNamingTemplate") 
    tmpFileName = tmpFileName.replace(/album/, tmpALBUM)
    tmpFileName = tmpFileName.replace(/artist/, tmpARTIST)
    tmpFileName = tmpFileName.replace(/number/, myDownloadItem["TRACKNUM"])
    tmpFileName = tmpFileName.replace(/track/, tmpTITLE)
    tmpFileName += myDownloadItem["EXTENSION"]

		// Fix path and file names that are too long - First test default template
    if (eMusicPlatform.ident == "WINNT" && fileToSave.path.length + tmpFileName.length > 254) {
      tmpFileName = nsPreferences.copyUnicharPref("eMusic.FileNamingTemplate")

      // remove artist from song title
      var tmpString = "artist" + tmpSeparator 
      tmpFileName = tmpFileName.replace(tmpString, "")
      tmpFileName = tmpFileName.replace(/album/, tmpALBUM)
      tmpFileName = tmpFileName.replace(/number/, myDownloadItem["TRACKNUM"])
      tmpFileName = tmpFileName.replace(/track/, tmpTITLE)
      tmpFileName += myDownloadItem["EXTENSION"]

      // remove artist & album from song title
      if (fileToSave.path.length + tmpFileName.length > 254) {
        tmpFileName = nsPreferences.copyUnicharPref("eMusic.FileNamingTemplate")

        tmpString = "artist" + tmpSeparator 
        tmpFileName = tmpFileName.replace(tmpString, "")

        tmpString = "album" + tmpSeparator 
        tmpFileName = tmpFileName.replace(tmpString, "")

        tmpFileName = tmpFileName.replace(/number/, myDownloadItem["TRACKNUM"])
        tmpFileName = tmpFileName.replace(/track/, tmpTITLE)
        tmpFileName += myDownloadItem["EXTENSION"]

        // if still to long, just trim the track's title
        if (fileToSave.path.length + tmpFileName.length > 254) {
          tmpFileName = tmpFileName.substring(0, 254 - fileToSave.path.length) + myDownloadItem["EXTENSION"];
        }
      }
    }

    // Create directory
    if (!fileToSave.exists()) {
      try {
        fileToSave.create(0x01,0755);
      } catch (ex) {
        debug(ex);
      }
    }
  
    var photoPath = fileToSave.clone()
    var photoPath2 = fileToSave.clone()
    fileToSave.append(tmpFileName);

	  var fileuri = ioService.newFileURI(fileToSave);
		
    var obj_TargetFile = dlm_base.getLocalFileInterface(fileToSave.path);

    //setTimeout(function() {downloadMP3File(myDownloadItem["TRACKURL"], fileToSave.path); }, 2000);

    var isAudiobook = (myDownloadItem["GENRE"] == "Audiobooks") ? true : false;

    downloadMP3File(myDownloadItem["TRACKURL"], fileToSave.path, isAudiobook);

    eDownloadManager.datasource.beginUpdateBatch();

    var tmpFilePath = fileToSave.path

    //var dateStarted = new Date()
    setRDFProperty(tmpFilePath, "ProgressPercent", 0);
    setRDFProperty(tmpFilePath, "artist",     myDownloadItem["ARTIST"]);
    setRDFProperty(tmpFilePath, "album",      myDownloadItem["ALBUM"]);
    setRDFProperty(tmpFilePath, "title",      myDownloadItem["TITLE"]);
    setRDFProperty(tmpFilePath, "albumart",   myDownloadItem["ALBUMART"]);
    setRDFProperty(tmpFilePath, "genre",      myDownloadItem["GENRE"]);
    setRDFProperty(tmpFilePath, "duration",   dlm_base.secondsToTime(myDownloadItem["DURATION"]));
    setRDFProperty(tmpFilePath, "trackid",    myDownloadItem["TRACKID"]);
    setRDFProperty(tmpFilePath, "tracknum",   myDownloadItem["TRACKNUM"]);
    setRDFProperty(tmpFilePath, "trackcount", myDownloadItem["TRACKCOUNT"]);
    setRDFProperty(tmpFilePath, "discnum",    myDownloadItem["DISCNUM"]);
    setRDFProperty(tmpFilePath, "disccount",  myDownloadItem["DISCCOUNT"]);
    setRDFProperty(tmpFilePath, "albumid",    myDownloadItem["ALBUMID"]);
    setRDFProperty(tmpFilePath, "albumurl",   myDownloadItem["ALBUMURL"]);
    setRDFProperty(tmpFilePath, "artistid",   myDownloadItem["ARTISTID"]);
    setRDFProperty(tmpFilePath, "artisturl",  myDownloadItem["ARTISTURL"]);
    setRDFProperty(tmpFilePath, "genreid",    myDownloadItem["GENREID"]);
    setRDFProperty(tmpFilePath, "genreurl",   myDownloadItem["GENREURL"]);
    setRDFProperty(tmpFilePath, "label",      myDownloadItem["LABEL"]);
    setRDFProperty(tmpFilePath, "labelid",    myDownloadItem["LABELID"]);
    setRDFProperty(tmpFilePath, "labelurl",   myDownloadItem["LABELURL"]);
    setRDFProperty(tmpFilePath, "styles",     myDownloadItem["STYLES"]); /* 294:Oldies */

    if (!isAudiobook) {
      setRDFProperty(tmpFilePath, "tracktype",   "music");
    } else {
      setRDFProperty(tmpFilePath, "tracktype",   "audiobook");
    }

    var albumRsrcURI = "album" + myDownloadItem["ALBUMID"];
	  addDownloadAlbum(albumRsrcURI);
	  setRDFProperty(albumRsrcURI, "trackRsrc", fileToSave.path, true, rdfRes);
	  setRDFProperty(albumRsrcURI, "name", myDownloadItem["ALBUM"]);
	  setRDFProperty(tmpFilePath, "albumRsrc", albumRsrcURI, true, rdfRes);
	  setRDFProperty(albumRsrcURI, "genre", myDownloadItem["GENRE"]);
	  setRDFProperty(albumRsrcURI, "artist", myDownloadItem["ARTIST"]);
	  setRDFProperty(albumRsrcURI, "albumid", myDownloadItem["ALBUMID"]);

    if (isAudiobook) {
      setRDFProperty(albumRsrcURI, "type", "audiobook");
    } else {
      setRDFProperty(albumRsrcURI, "type", "album");
    }

    eDownloadManager.datasource.endUpdateBatch();

    if (eSaveAlbumArt) { //eMusicPlatform.ident == "WINNT" && 
      photoPath.append("Folder.jpg");

      var obj_PhotoFile = dlm_base.getLocalFileInterface(photoPath.path);
  
      if (!obj_PhotoFile.exists()) {
  	    silentFileDownload(myDownloadItem["ALBUMART"], photoPath.path)
      }
    }

  } catch (ex) {
    debug(ex);
    return false;
  }

  return true;
}

function downloadMP3File(thisURL, thisLocalFile, isAudiobook) {
  var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService);

  thisLocalFile = dlm_base.getLocalFileInterface(thisLocalFile);

  //// Make sure that path and filename can and are created
  if (!thisLocalFile.exists()) {
    try {
      thisLocalFile.create(0x00,0755);
    } catch (ex) {
      debug(ex);
    }
  }

  var fileuri = ioService.newFileURI(thisLocalFile);

  var persistBag = Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"]
                    .createInstance(Components.interfaces.nsIWebBrowserPersist);
  var nsIWBP = Components.interfaces.nsIWebBrowserPersist;

  persistBag.persistFlags = nsIWBP.PERSIST_FLAGS_NO_CONVERSION |
                            nsIWBP.PERSIST_FLAGS_IGNORE_REDIRECTED_DATA |
                            nsIWBP.PERSIST_FLAGS_REPLACE_EXISTING_FILES |
                            nsIWBP.PERSIST_FLAGS_BYPASS_CACHE |
                            nsIWBP.PERSIST_FLAGS_DONT_CHANGE_FILENAMES |
                            nsIWBP.PERSIST_FLAGS_CLEANUP_ON_FAILURE |
                            nsIWBP.PERSIST_FLAGS_SERIALIZE_OUTPUT;

  // Hook into download manager
  var uriObj = ioService.newURI(thisURL, null, null);

  var transObj = Components.classes["@mozilla.org/transfer;1"].createInstance(Components.interfaces.nsITransfer);
  transObj.init(uriObj, fileuri, thisLocalFile.leafName, null, null, null, persistBag);

  // do the progress listener thing and update status
  var eDownloadListener = new dlmlistener()
  if (isAudiobook) {
    eDownloadListener = new audiobookslistener()
  }
  eDownloadListener.init(thisLocalFile.leafName, uriObj, thisLocalFile, transObj);

  // now download
  persistBag.progressListener = eDownloadListener;

  try {
    persistBag.saveURI(uriObj, null, null, null, "DLM: true\r\n", fileuri);
  } catch(ex) {
    persistBag.cancelSave();
  }
}

function silentFileDownload(thisFile, thisPath, serializeFile, thisListener) {
  try {
    var obj_URI = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService)
                    .newURI(thisFile, null, null);
    var obj_TargetFile = dlm_base.getLocalFileInterface(thisPath);
  
    if (obj_TargetFile.exists()) {
      //return false;
    } else {
      try {
        obj_TargetFile.create(0x00,0755);
      } catch(ex) {
        return false;
        debug(ex);
      }
    }

    var obj_Persist = Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"]
                        .createInstance(Components.interfaces.nsIWebBrowserPersist);
    var nsIWBP = Components.interfaces.nsIWebBrowserPersist;

    obj_Persist.persistFlags = nsIWBP.PERSIST_FLAGS_REPLACE_EXISTING_FILES |
                               nsIWBP.PERSIST_FLAGS_BYPASS_CACHE;
                            
    if (serializeFile) {
      obj_Persist.persistFlags = nsIWBP.PERSIST_FLAGS_REPLACE_EXISTING_FILES |
                                 nsIWBP.PERSIST_FLAGS_BYPASS_CACHE|
                                 nsIWBP.PERSIST_FLAGS_SERIALIZE_OUTPUT;
    }

  	if (thisListener) {
  	  obj_Persist.progressListener = thisListener;
  	}
  	
    obj_Persist.saveURI(obj_URI,null,null,null,null,obj_TargetFile);

  } catch (ex) {
    debug(ex);
    return false;
  }

  return true;
}

function reQueueDownloads() {

  try {
    var RDF = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    var Container = Components.classes["@mozilla.org/rdf/container;1"].getService(Components.interfaces.nsIRDFContainer);
    var DS = eDownloadManager.datasource
    
    var ContainerUtils = Components.classes["@mozilla.org/rdf/container-utils;1"].
              getService(Components.interfaces.nsIRDFContainerUtils);
    
    Container.Init(DS, RDF.GetResource("NC:DownloadsRoot"));
  
  	var dlmEntries = Container.GetElements();
  
    //debug(Container.GetCount())
    
    var fileToRequeue = new Array
    var urlToRequeue = new Array

    while(dlmEntries.hasMoreElements()) {
  		var dlmEntry = dlmEntries.getNext();
  		var dlmEntryID = dlmEntry.QueryInterface(Components.interfaces.nsIRDFResource).ValueUTF8

      if (getRDFProperty(dlmEntryID, "DownloadState") != "1") {
        
        fileToRequeue.push(dlmEntryID)
        urlToRequeue.push(getRDFProperty(dlmEntryID, "URL"))
      }
  	}
  
    eDownloadManager.datasource.beginUpdateBatch();

    var i = fileToRequeue.length;
    while (i--) {
      downloadMP3File(urlToRequeue.pop(), fileToRequeue.pop());
    }

    eDownloadManager.datasource.endUpdateBatch();

    eDownloadManager.saveState();

  	var remoteDS = DS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
    remoteDS.Flush();

  } catch (ex) {
    //debug(ex)
  }

}

function albumCommands(thisAlbum, thisAction) {

  try {
    var RDF = Components.classes["@mozilla.org/rdf/rdf-service;1"]
                .getService(Components.interfaces.nsIRDFService);
    var Container = Components.classes["@mozilla.org/rdf/container;1"]
                      .getService(Components.interfaces.nsIRDFContainer);
    var ContainerUtils = Components.classes["@mozilla.org/rdf/container-utils;1"]
                           .getService(Components.interfaces.nsIRDFContainerUtils);
    var DS = eDownloadManager.datasource

    Container.Init(DS, RDF.GetResource("NC:DownloadsRoot"));
  
  	var dlmEntries = Container.GetElements();
  
    var fileToRemove = new Array

    var rootSubject = RDF.GetResource("NC:DownloadAlbumsRoot");
    var predicate = RDF.GetResource("http://home.netscape.com/NC-rdf#albumli");
    var objElement

		eDownloadManager.datasource.beginUpdateBatch();

    while(dlmEntries.hasMoreElements()) {
  		var dlmEntry = dlmEntries.getNext();
  		var dlmEntryID = dlmEntry.QueryInterface(Components.interfaces.nsIRDFResource).ValueUTF8

      var rdfAlbumName = getRDFProperty(dlmEntryID, "album")

      if (thisAlbum == rdfAlbumName) {
        switch (thisAction) {
          case "pause":
            try {
              eDownloadManager.pauseDownload(dlmEntryID);
              setRDFProperty(currentelement, "DownloadState", "4");
            } catch(ex) {
              //debug(ex)
            }
            break;
          case "resume":
            try {
              eDownloadManager.resumeDownload(dlmEntryID)
              setRDFProperty(currentelement, "DownloadState", "-1");
            } catch(ex) {
              downloadMP3File(getRDFProperty(dlmEntryID, "URL"), getRDFProperty(dlmEntryID, "File"))
            }
            break;
          case "cancel":
            try {
              eDownloadManager.cancelDownload(dlmEntryID);
            } catch(ex) {
              //debug(ex)
            }

            if (nsPreferences.getBoolPref("eMusic.AutoClearCancelled")) {
              eDownloadManager.removeDownload(dlmEntryID)
            }

            break;
        }
      }

  	}

    eDownloadManager.datasource.endUpdateBatch();

    eDownloadManager.saveState();

  	var remoteDS = DS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
    remoteDS.Flush();

  } catch (ex) {
    debug(ex)
  }
}

function DownloadQueueRepair() {

  try {
    var RDF = Components.classes["@mozilla.org/rdf/rdf-service;1"]
                .getService(Components.interfaces.nsIRDFService);
    var Container = Components.classes["@mozilla.org/rdf/container;1"]
                      .getService(Components.interfaces.nsIRDFContainer);
    var ContainerUtils = Components.classes["@mozilla.org/rdf/container-utils;1"]
                           .getService(Components.interfaces.nsIRDFContainerUtils);
    var DS = eDownloadManager.datasource
    
    Container.Init(DS, RDF.GetResource("NC:DownloadsRoot"));
  
  	var dlmEntries = Container.GetElements();
  
    //debug(Container.GetCount())
    
    var fileToRemove = new Array

    while(dlmEntries.hasMoreElements()) {
  		var dlmEntry = dlmEntries.getNext();
  		var dlmEntryID = dlmEntry.QueryInterface(Components.interfaces.nsIRDFResource).ValueUTF8
      
      if (!dlm_base.fileExists(dlmEntryID)) {
        fileToRemove.push(dlmEntryID)
      }
  	}
  
		eDownloadManager.datasource.beginUpdateBatch();

    var i = fileToRemove.length;
    while (i--) {
      eDownloadManager.removeDownload(fileToRemove.pop());
    }

    eDownloadManager.datasource.endUpdateBatch();

    eDownloadManager.saveState();

  	var remoteDS = DS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
    remoteDS.Flush();

    //buildRootBy(eDLMRootPivot);

  } catch (ex) {
    debug("Couldn't repair download list, resetting")
    debug(ex)

    var profileRDFPath = dlm_base.getSpecialFolder("ProfD")
    profileRDFPath.append("downloads.rdf")

    dlm_base.removeFile(profileRDFPath.path)
    eDownloadManager = Components.classes[dlmgrContractID].getService(dlmgrIID)

    eDownloadManager.saveState();

    eDownloadsView.database.AddDataSource(eDownloadManager.datasource);
    eDownloadsAlbumView.database.AddDataSource(eDownloadManager.datasource);
    eDownloadsAudioBooksView.database.AddDataSource(eDownloadManager.datasource);
  }

}

function DownloadQueueUpgrade() {

  try {
    var RDF = Components.classes["@mozilla.org/rdf/rdf-service;1"]
                .getService(Components.interfaces.nsIRDFService);
    var Container = Components.classes["@mozilla.org/rdf/container;1"]
                      .getService(Components.interfaces.nsIRDFContainer);
    var ContainerUtils = Components.classes["@mozilla.org/rdf/container-utils;1"]
                           .getService(Components.interfaces.nsIRDFContainerUtils);
    var DS = eDownloadManager.datasource
    
    Container.Init(DS, RDF.GetResource("NC:DownloadsRoot"));
  
  	var dlmEntries = Container.GetElements();
  
		eDownloadManager.datasource.beginUpdateBatch();

    while(dlmEntries.hasMoreElements()) {
  		var dlmEntry = dlmEntries.getNext();
  		var dlmEntryID = dlmEntry.QueryInterface(Components.interfaces.nsIRDFResource).ValueUTF8

      if (getRDFProperty(dlmEntryID, "tracktype") == "") {
        if (getRDFProperty(dlmEntryID, "genre") == "Audiobooks") {
          setRDFProperty(dlmEntryID, "tracktype", "audiobook");
        } else {
          setRDFProperty(dlmEntryID, "tracktype", "music");
        }
      }
      
      try {
      var albumRsrcURI
      
      if (getRDFProperty(dlmEntryID, "albumid") != "") {
        albumRsrcURI = "album" + getRDFProperty(dlmEntryID, "albumid");
      } else {
        albumRsrcURI = "album" + getRDFProperty(dlmEntryID, "album");
      }

      addDownloadAlbum(albumRsrcURI);

      //if (getRDFProperty(albumRsrcURI, "trackRsrc") == "") {
        setRDFProperty(albumRsrcURI, "trackRsrc", dlmEntryID, true, rdfRes);
      //}

      setRDFProperty(albumRsrcURI, "name", getRDFProperty(dlmEntryID, "album"));
      setRDFProperty(albumRsrcURI, "genre", getRDFProperty(dlmEntryID, "genre"));
      setRDFProperty(albumRsrcURI, "artist", getRDFProperty(dlmEntryID, "artist"));
      setRDFProperty(albumRsrcURI, "albumid", getRDFProperty(dlmEntryID, "albumid"));

      if (getRDFProperty(dlmEntryID, "albumRsrc") == "") {
        setRDFProperty(dlmEntryID, "albumRsrc", albumRsrcURI, true, rdfRes);
      }
  
      if (getRDFProperty(dlmEntryID, "genre") == "Audiobooks") {
        setRDFProperty(albumRsrcURI, "type", "audiobook");
      } else {
        setRDFProperty(albumRsrcURI, "type", "album");
      }
      } catch (ex) {
        debug(ex)
      }

  	}
  
    eDownloadManager.datasource.endUpdateBatch();

    eDownloadManager.saveState();

  	var remoteDS = DS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
    remoteDS.Flush();

    //buildRootBy(eDLMRootPivot);

  } catch (ex) {
    debug(ex)
  }

}

function toggleTotalProgress(forced) {
  var thisToggle = false
  
  var activeDownloadCount = eDownloadManager.activeDownloadCount
  var downloadCount = document.getElementById("download-count")

  activeDownloadCount += eAudiobooksQueue.length

  if (activeDownloadCount == 0 && !forced) {
    thisToggle = true

    var showAlerts = document.getElementById("view_popupAlerts").getAttribute("checked")

    if (!bInitializing && !bPopupOff && showAlerts && showAlerts == "true") {
      var thisMessage = null

      if (gHadDownloadErrors) {
        thisMessage = "Downloading complete, but there were some errors.";
        gHadDownloadErrors = false
      }

      dlm_base.popup(thisMessage);

      bPopupOff = false;
    }
  } else if (activeDownloadCount > 0) {
    downloadCount.setAttribute("value", " (" + activeDownloadCount + ")");
  }

  downloadCount.setAttribute("collapsed", thisToggle);
  document.getElementById("dlm-throbber").setAttribute("busy", !thisToggle);

  if (!bInitializing && activeDownloadCount == 0
        && nsPreferences.getBoolPref("eMusic.QuitWhenDone")) {
    setTimeout(function() {dlm_base.quit(true);}, 500);
  }
}

function displayTrackInfo() {
  var whichView
  var whichColumn
  var templateURL

  templateURL = nsPreferences.copyUnicharPref("eMusic.templateFile")
  
  try {
    switch (eCurrentDeck) {
      case 5:
        templateURL = nsPreferences.copyUnicharPref("eMusic.templateFileAudioBooks")
        whichView = eDownloadsAudioBooksView;
        whichColumn = "treeAudiobooksFilename";
        break;
      case 3:
        whichView = eDownloadsAlbumView;
        whichColumn = "treeAlbumFilename";
        break;
      case 1:
        whichView = eDownloadsView;
        whichColumn = "treeFilename";
        break;
      default:
        return false;
    }

    if (whichView.currentIndex == "-1") return false;

    //var currentelement = eDownloadsView.treeBoxObject.view.getItemAtIndex(eDownloadsView.currentIndex);
    //var currentID = currentelement.getAttribute("id")
    var currentID = whichView.contentView.getCellValue(whichView.currentIndex, whichView.columns.getNamedColumn(whichColumn))

    if (!currentID) return false;

    var req = new XMLHttpRequest();
    req.open("GET", templateURL, false); 
    req.send(null);
  
    var thisTemplate = req.responseText;
  
    thisTemplate = thisTemplate.replace(/%albumart%/g, getRDFProperty(currentID, "albumart"));
    thisTemplate = thisTemplate.replace(/%artist%/g, getRDFProperty(currentID, "artist"));
    thisTemplate = thisTemplate.replace(/%album%/g, getRDFProperty(currentID, "album"));
    thisTemplate = thisTemplate.replace(/%title%/g, getRDFProperty(currentID, "title"));
    thisTemplate = thisTemplate.replace(/%genre%/g, getRDFProperty(currentID, "genre"));
    thisTemplate = thisTemplate.replace(/%duration%/g, getRDFProperty(currentID, "duration"));

    var tmpStr = getRDFProperty(currentID, "artisturl")

    var tmpHomepage = nsPreferences.copyUnicharPref("eMusic.defaultHomePage")

    if (!tmpStr) { tmpStr = tmpHomepage }
    thisTemplate = thisTemplate.replace(/%artisturl%/g, tmpStr);

    var tmpStr = getRDFProperty(currentID, "albumurl")
    if (!tmpStr) { tmpStr = tmpHomepage }
    thisTemplate = thisTemplate.replace(/%albumurl%/g, tmpStr);

    var tmpStr = getRDFProperty(currentID, "genreurl")
    if (!tmpStr) { tmpStr = tmpHomepage }
    thisTemplate = thisTemplate.replace(/%genreurl%/g, tmpStr);

    var thisDoc = eTrackPreview.contentDocument;
    var thisBody = thisDoc.getElementsByTagName("body")[0];
    
    thisBody.innerHTML = thisTemplate;
  } catch (ex) {
    //debug(ex)
    //eTrackPreview.loadURI("chrome://emusic/locale/custom.html", null, null);
  }

  return true;
}

function initAutoDownloadDisplay() {
  var pref = Components.classes["@mozilla.org/preferences-service;1"]
                       .getService(Components.interfaces.nsIPrefBranch);

  var autodownload = pref.getBoolPref("eMusic.download.useDownloadDir");  
  if (autodownload) {
    var autodownloadInfo = document.getElementById("autodownloadInfo");
    autodownloadInfo.hidden = false;

    function getSpecialFolderKey(aFolderType) {
      if (aFolderType == "Desktop")
        return "Desk";

      if (aFolderType == "Downloads") {
        switch (eMusicPlatform.ident) {
          case "WINNT":
            return "Pers"
            break;
          default:
            return "UsrDocs"
         }
      }
      throw "ASSERTION FAILED: folder type should be 'Desktop' or 'Downloads'";
    }
    
    function getDownloadsFolder(aFolder) {
      var fileLocator = Components.classes["@mozilla.org/file/directory_service;1"]
                                  .getService(Components.interfaces.nsIProperties);
      var dir = fileLocator.get(getSpecialFolderKey(aFolder), Components.interfaces.nsILocalFile);
      
      var bundle = Components.classes["@mozilla.org/intl/stringbundle;1"]
                              .getService(Components.interfaces.nsIStringBundleService);
      bundle = bundle.createBundle("chrome://mozapps/locale/downloads/unknownContentType.properties");

      var description = bundle.GetStringFromName("myDownloads");
      if (aFolder != "Desktop")
        dir.append(description);
        
      return dir;
    }

    var displayName = null;
    var folder;
    switch (pref.getIntPref("eMusic.download.folderList")) {
    case 0:
      folder = getDownloadsFolder("Desktop");
      displayName = document.getElementById("downloadStrings").getString("displayNameDesktop");
      break;
    case 1:
      folder = getDownloadsFolder("Downloads");
      break;
    case 2: 
      folder = pref.getComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile);
      
      if (!folder.exists()) {
        try {
          folder.create(0x01,0755);
        } catch (ex) {
          debug(ex);
        }
      }
      break;
    }

    if (folder) {    
      var folderObj = document.getElementById("saveToFolder");
      if (folderObj) {
        folderObj.label = displayName || folder.leafName;
        folderObj.setAttribute("path", folder.path);
      }

      folderObj = document.getElementById("saveToFolderDirectory")
      if (folderObj) {
        folderObj.label = displayName || folder.leafName;
        folderObj.setAttribute("path", folder.path);
      }

      folderObj = document.getElementById("saveToFolderAlbum")
      if (folderObj) {
        folderObj.label = displayName || folder.leafName;
        folderObj.setAttribute("path", folder.path);
      }
      folderObj = document.getElementById("saveToFolderBrowser")
      if (folderObj) {
        folderObj.label = displayName || folder.leafName;
        folderObj.setAttribute("path", folder.path);
      }
      
      folderObj = document.getElementById("saveToFolderAudiobooks")
      if (folderObj) {
        folderObj.label = displayName || folder.leafName;
        folderObj.setAttribute("path", folder.path);
      }

      if (eMusicPlatform.ident == "WINNT") {
        // backwards compatibility and for the new installer logic
        var thisRegBase = eMusicRegistry.eMusicBaseReg;
        eMusicRegistry.setValue(winRegKeys["HKCU"], thisRegBase, "DownloadDirectory", folder.path)
      }
    }
  }
  else {
    var autodownloadInfo = document.getElementById("autodownloadInfo");
    autodownloadInfo.hidden = true;
  }
}

function onDownloadShowFolder() {
  //var folderName = document.getElementById("saveToFolder").getAttribute("path");
  var prefs = nsPreferences.mPrefService;
  var thisFolder = prefs.getComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile);

  dlm_base.showThisPath(thisFolder.path)
}

function popupload() {
  window.removeEventListener('load', popupload, false);

  if (eContextMenu) {
    eContextMenu.addEventListener('popupshowing', function() {setTimeout(popupshowing, 0);}, false);
  }

}
  
function popupshowing() {
  var back = document.getElementById("context-back");
  var forward = document.getElementById("context-forward");

  //var webNavigation = eBrowser.webNavigation;
  
  back.setAttribute("disabled", !eBrowser.canGoBack);

  forward.setAttribute("disabled", !eBrowser.canGoForward);

  //if (local_common.onLink()) 
  //http://bonsai.mozilla.org/cvsblame.cgi?file=mozilla/browser/base/content/browser.js&rev=1.609#4127
}

function fullScreenKeys(event) {
  if (event.keyCode == event.DOM_VK_F4 && event.atlKey) { // || event.keyCode == event.DOM_VK_Q && event.ctrlKey
    event.preventDefault();
    dlm_base.quit(true);
  }
}

function activateContext(event) {	
/*
	var eContextMenu = document.getElementById("contentAreaContextMenu");
 
	var xCoord = event.clientX;
	var yCoord = event.clientY;
  
  // On Mac's & Linux the xy coordinates are object specific so I have to add 
  // the navgrid width and then 10pixels for the splitter to have the context 
  // menu show up correctly.
 	var navGridObj = document.getElementById("navGrid");

  //if (eMusicPlatform.ident != "WINNT" && navGridObj) {	
    xCoord = parseInt(xCoord) + parseInt(navGridObj.width) + 10;
  //}
  
	document.getElementById("context-back").setAttribute("disabled", !eBrowser.canGoBack);
  document.getElementById("context-forward").setAttribute("disabled", !eBrowser.canGoForward);

	document.popupNode = eBrowser;
	//eContextMenu.showPopup(eBrowser, xCoord, yCoord, "bottomleft", "topleft");
	eContextMenu.showPopup(eBrowser, xCoord, yCoord, -1, -1);

  event.stopPropagation();
  event.preventDefault();
*/
}

var themeObserver = {
  observe: function(aSubject, aTopic, aData) {
    if (aTopic != "nsPref:changed") return;

    setTimeout(function() { restartPrompt(true); }, 250);
  }
}

function restartPrompt(promptMe){

  if (typeof canQuitApplication == "function" && canQuitApplication()) {
    if (promptMe != false) {
      var myPrompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
            .getService(Components.interfaces.nsIPromptService);
      var myLocalStrings = myLocalBundleService
            .createBundle("chrome://emusic/locale/emusic.properties");

      var retVal  = myPrompts.confirm(window, myLocalStrings.GetStringFromName("appName"), 
                                          myLocalStrings.GetStringFromName("promptRestart"));

      if (!retVal) {
         return true;
      }
    }

    var appStartup = Components.interfaces.nsIAppStartup;
    Components.classes["@mozilla.org/toolkit/app-startup;1"]
      .getService(appStartup).quit(appStartup.eRestart | appStartup.eAttemptQuit);
  }

  return true;
}

function checkForUpdates(){
  /**
   * Opens the update manager and checks for updates to the application.
   */
  var um = Components.classes["@mozilla.org/updates/update-manager;1"].
             getService(Components.interfaces.nsIUpdateManager);
  var prompter = Components.classes["@mozilla.org/updates/update-prompt;1"].
                   createInstance(Components.interfaces.nsIUpdatePrompt);

  // If there's an update ready to be applied, show the "Update Downloaded"
  // UI instead and let the user know they have to restart the browser for
  // the changes to be applied. 
  if (um.activeUpdate && um.activeUpdate.state == "pending")
    prompter.showUpdateDownloaded(um.activeUpdate);
  else
    prompter.checkForUpdates();
}

function refreshDaily() {
  var thisDailyDownloadBrowser = document.getElementById('navBrowserFreeDownload');
  if (!thisDailyDownloadBrowser.hidden && !thisDailyDownloadBrowser.collapsed) {
    thisDailyDownloadBrowser.reload();
  }
}

function buildRootBy(thisPivot) {

  if (!thisPivot) thisPivot = eDLMRootPivot
  else eDLMRootPivot = thisPivot
  
  nsPreferences.setUnicharPref("eMusic.treeViewPivot", thisPivot)

  try {
    var rdf = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    var Container = Components.classes["@mozilla.org/rdf/container;1"].getService(Components.interfaces.nsIRDFContainer);

    var ds = eDownloadManager.datasource
    
    //var remoteDS = ds.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
    //remoteDS.Flush();

    Container.Init(ds, rdf.GetResource("NC:DownloadsRoot"));
  
  	var dlmEntries = Container.GetElements();

    var childData = new Array()
    eMusicTreeView.visibleData = new Array()
    var dlmPivot, dlmArtist, dlmEntry, dlmEntryID, dlmProgress, dlmTitle
      
    while(dlmEntries.hasMoreElements()) {
  		dlmEntry = dlmEntries.getNext();
  		dlmEntryID = dlmEntry.QueryInterface(Components.interfaces.nsIRDFResource).ValueUTF8;

      dlmPivot = getRDFProperty(dlmEntryID, thisPivot); //genre / album / title
      dlmArtist = getRDFProperty(dlmEntryID, "artist"); //
      dlmTitle = getRDFProperty(dlmEntryID, "title"); //artist
      dlmProgress = getRDFProperty(dlmEntryID, "ProgressPercent"); //title

      if (dlmPivot && dlmProgress == "100") {
        if (!childData[dlmPivot]) childData[dlmPivot] = new Array();
        childData[dlmPivot].push(dlmArtist + " - " + dlmTitle);
      }
  	}
  
    eMusicTreeView.childData = childData;

    for (var pivot in childData) {
      eMusicTreeView.visibleData.push([pivot, true, false]);
      childData[pivot].sort();
    }
    eMusicTreeView.visibleData.sort();

    document.getElementById("dlmTree2").view = eMusicTreeView;

  } catch (ex) {
    //debug(ex)
  }

}

var eMusicTreeView = {
  childData : {},

  visibleData : [],

  treeBox: null,
  selection: null,

  get rowCount()                     { return this.visibleData.length; },
  setTree: function(treeBox)         { this.treeBox = treeBox; },
  getCellText: function(idx, column) { return this.visibleData[idx][0]; },
  isContainer: function(idx)         { return this.visibleData[idx][1]; },
  isContainerOpen: function(idx)     { return this.visibleData[idx][2]; },
  isContainerEmpty: function(idx)    { return false; },
  isSeparator: function(idx)         { return false; },
  isSorted: function()               { return false; },
  isEditable: function(idx, column)  { return false; },

  getParentIndex: function(idx) {
    if (this.isContainer(idx)) return -1;
    for (var t = idx - 1; t >= 0 ; t--) {
      if (this.isContainer(t)) return t;
    }
    return -1
  },
  getLevel: function(idx) {
    if (this.isContainer(idx)) return 0;
    return 1;
  },
  hasNextSibling: function(idx, after) {
    var thisLevel = this.getLevel(idx);
    for (var t = idx + 1; t < this.visibleData.length; t++) {
      var nextLevel = this.getLevel(t)
      if (nextLevel == thisLevel) return true;
      else if (nextLevel < thisLevel) return false;
    }
    return false
  },
  toggleOpenState: function(idx) {
    var item = this.visibleData[idx];
    if (!item[1]) return;

    if (item[2]) {
      item[2] = false;

      var thisLevel = this.getLevel(idx);
      var deletecount = 0;
      for (var t = idx + 1; t < this.visibleData.length; t++) {
        if (this.getLevel(t) > thisLevel) deletecount++;
        else break;
      }
      if (deletecount) {
        this.visibleData.splice(idx + 1, deletecount);
        this.treeBox.rowCountChanged(idx + 1, -deletecount);
      }
    }
    else {
      item[2] = true;

      var label = this.visibleData[idx][0];
      var toinsert = this.childData[label];
      for (var i = 0; i < toinsert.length; i++) {
        this.visibleData.splice(idx + i + 1, 0, [toinsert[i], false]);
      }
      this.treeBox.rowCountChanged(idx + 1, toinsert.length);
    }
  },

  getImageSrc: function(idx, column) {},
  getProgressMode : function(idx,column) {},
  getCellValue: function(idx, column) {},
  cycleHeader: function(col, elem) {},
  selectionChanged: function() {},
  cycleCell: function(idx, column) {},
  performAction: function(action) {},
  performActionOnCell: function(action, index, column) {},
  getRowProperties: function(idx, column, prop) {},
  getCellProperties: function(idx, column, prop) {},
  getColumnProperties: function(column, element, prop) {}
};

function switchFocus(elem) {
  var mediator = Components.classes["@mozilla.org/rdf/datasource;1?name=window-mediator"].getService();
  mediator.QueryInterface(Components.interfaces.nsIWindowDataSource);

  var resource = elem.getAttribute('id');
  var switchwindow = mediator.getWindowForResource(resource);

  if (switchwindow){
    switchwindow.focus();
  }
}

function toggleNavGrid() {
  
  var navGrid = document.getElementById("navGrid")
  
  navGrid.collapsed = !navGrid.collapsed

  document.getElementById("showSidebar").setAttribute("checked", !navGrid.collapsed)
}

function listenToTrack(trackLocation) {

  if (!trackLocation) return false;

  trackLocation = dlm_base.scrubPath(trackLocation);
  
  // remove trailing slash for directories so that Winamp  
  // (and possibly others) will read as directory
  if (eMediaPlayer == "Winamp") trackLocation = trackLocation.replace(/\\$/g, "")

  try {
    var defaultMediaPlayer = nsPreferences.copyUnicharPref("eMusic.defaultMediaPlayer")
    var mp3PlayerInterface
    var params = [trackLocation]

    if (defaultMediaPlayer) {
      mp3PlayerInterface = dlm_base.getLocalFileInterface(defaultMediaPlayer);
    }
    
    //debug(defaultMediaPlayer)

    switch (eMusicPlatform.ident) {
      case "WINNT":
        switch(eMediaPlayer) {
          case "WMP":
            params = ["/Service:emusic", "/play", trackLocation];
            break;
          case "iTunes":
            break;
        }
        break;
      case "Darwin":
        switch(eMediaPlayer) {
          case "iTunes":
            params = ["-a", defaultMediaPlayer, trackLocation];
            mp3PlayerInterface = dlm_base.getLocalFileInterface("/usr/bin/open");
          break;
        }
        break;
      case "Linux":
        if (defaultMediaPlayer == "DefaultPlayer" || !mp3PlayerInterface) {
          defaultMediaPlayer = nsPreferences.copyUnicharPref("eMusic.defaultMediaPlayer.Linux")
          mp3PlayerInterface = dlm_base.getLocalFileInterface(defaultMediaPlayer);
        }
        break;
    }

    var thisProcess = Components.classes["@mozilla.org/process/util;1"].
                        getService(Components.interfaces.nsIProcess);
    thisProcess.init(mp3PlayerInterface);
    
    thisProcess.run(false, params, params.length);
    
  } catch (ex) {
    //try {
      var launchMP3 = dlm_base.getLocalFileInterface(trackLocation)
      launchMP3.launch();
    /*} catch(ex) {
                dlm_base.loadExternalURL(trackLocation)
              }*/
  }

  return true;
}

function refreshDefaultPlayer() {
  eMediaPlayer = nsPreferences.copyUnicharPref("eMusic.defaultMediaPlayerObj")
  eMediaSync = nsPreferences.copyUnicharPref("eMusic.defaultMediaSync")

  var mediaPlayerButton = document.getElementById("defaultPlayerButton") //MediaPlayerLaunchButton
  var mediaCustomPlayer = document.getElementById("player-CustomPlayer")
  
  try {
    mediaCustomPlayer = nsPreferences.mPrefService
                          .getComplexValue("eMusic.defaultMediaPlayer",
                          Components.interfaces.nsILocalFile)
  
    if (eMediaPlayer == "CustomPlayer" && mediaCustomPlayer) {
      var mlocationField = document.getElementById("player-CustomPlayerPath")
      mlocationField.value = mediaCustomPlayer.path;
    }
  } catch(ex) {
  }

  try {
    document.getElementById("player-" + eMediaPlayer).setAttribute("checked", "checked");
    document.getElementById("sync-" + eMediaSync).setAttribute("checked", "checked");
    
    var wizardWindow = dlm_base.mostRecentWindow("emusic:wizard");
    if (wizardWindow) {
      wizardWindow.document.getElementById("player-" + eMediaPlayer).setAttribute("checked", "checked");
      wizardWindow.document.getElementById("sync-" + eMediaSync).setAttribute("checked", "checked");
    }
  } catch (ex) {
    debug(ex)
  }

  mediaPlayerButton.setAttribute("collapsed", false);

  if (eMediaSync == "NoSync") {
    document.getElementById("launchPlayerLabel").setAttribute("hidden", true);
    mediaPlayerButton.src = "chrome://emusic/skin/syncDisable_small.png";
  } else if (mediaManagers[eMediaSync]) {
    document.getElementById("launchPlayerLabel").setAttribute("hidden", false);
    document.getElementById("launchPlayerLabel").value = "launch " + mediaManagers[eMediaSync].getAppName();

    eMediaPlayerIcon = dlm_base.getMozIcon(mediaManagers[eMediaSync].getAppPath(), "16")
    mediaPlayerButton.src = eMediaPlayerIcon;
  }
}

function asyncFocusSearchBox(event) {
  var sidebar = document.getElementById("sidebar");
  var searchBox = sidebar.contentDocument.getElementById("search-box");
  if (searchBox)
    searchBox.focus();
  sidebar.removeEventListener("load", asyncFocusSearchBox, true);
}

function resetWindowObjects() {
  var tempWin = dlm_base.mostRecentWindow("emusic:window").document.getElementById("main-window");
  tempWin.removeAttribute("laststate");
  tempWin.removeAttribute("windowState");
  
  window.maximize(); 

  setTimeout(function() {
    // damned reset doesn't work.
    /*var tempToolbar
    var objectEnableApply = ['nav-bar', 'dlm-toolbar', 'dlm-album-toolbar', 'dlm-audiobooks-toolbar'];
  
    for(var o in objectEnableApply) {
      tempToolbar = document.getElementById(objectEnableApply[o]);
      tempToolbar.removeAttribute("currentset");
      tempToolbar.currentSet = tempToolbar.getAttribute("defaultset");
      tempToolbar.setAttribute("currentset", tempToolbar.getAttribute("defaultset"));
    }*/

    document.getElementById("navGrid").setAttribute("height", "275");
    document.getElementById("navGrid").setAttribute("width", "190");

    setMinimizeToTray(document.getElementById("menu_FileTrayMinimize").getAttribute("checked"))
  }, 250);
}

const gSessionHistoryObserver = {
   observe: function(subject, topic, data) {
     if (topic != "browser:purge-session-history")
        return;
 
     var backCommand = document.getElementById("eBrowserBack");
     backCommand.setAttribute("disabled", "true");
     var fwdCommand = document.getElementById("eBrowserForward");
     fwdCommand.setAttribute("disabled", "true");
   }
};

function shutdownCleanup() {

  if (eContextMenu) {
    eContextMenu.removeEventListener("popupshowing", popupshowing, false);
  }

  var os = Components.classes["@mozilla.org/observer-service;1"]
             .getService(Components.interfaces.nsIObserverService);
  os.removeObserver(gSessionHistoryObserver, "browser:purge-session-history"); 

  eDownloadManager.listener = null;

  eDownloadManager.saveState();
  
  eBrowser.removeProgressListener(window.XULBrowserWindow);
  eBrowser.removeEventListener("NewTab", dlm_web.BrowserOpenTab, false);

  window.removeEventListener("keydown", fullScreenKeys, true);
  
  window.XULBrowserWindow.destroy();
  window.XULBrowserWindow = null;
  window.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
        .getInterface(Components.interfaces.nsIWebNavigation)
        .QueryInterface(Components.interfaces.nsIDocShellTreeItem).treeOwner
        .QueryInterface(Components.interfaces.nsIInterfaceRequestor)
        .getInterface(Components.interfaces.nsIXULWindow)
        .XULBrowserWindow = null;
  return true;
}

function delayedStartup() {
  var os = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
  os.addObserver(gSessionHistoryObserver, "browser:purge-session-history", false);
}

function init_remote() {

  bInitializing = true;

  if (gDebugMode) {
    document.getElementById("debug_menu").hidden = false;
  }

  eBrowser = dlm_web.getBrowser();

  eDefaultServer = nsPreferences.copyUnicharPref('eMusic.defaultServer')
  eDefaultHomePage = nsPreferences.copyUnicharPref('eMusic.defaultHomePage')
  
  eContextMenu = document.getElementById('contentAreaContextMenu');
  
  eURLBar = document.getElementById("urlbar")
  eURLBar.disabled = false; // temp: till localstore can be reset

  eTrackPreview = document.getElementById("navBrowserTrackPreview");

  if (!gURLBar) gURLBar = eURLBar;
  if (!appcontent) appcontent = document.getElementById("content");

  if (eMusicPlatform.ident == "Darwin") {
    document.getElementById("menuStack").collapsed = true
  } else {
    document.getElementById("menuStack").collapsed = false
    document.getElementById("windowControls").collapsed = false
  }

  eBrowser.addEventListener("NewTab", dlm_web.BrowserOpenTab, false);

  appCore = Components.classes["@mozilla.org/appshell/component/browser/instance;1"]
              .createInstance(Components.interfaces.nsIBrowserInstance);

  // Initialize browser instance..
  appCore.setWebShellWindow(window);

  // Create web listener
  window.XULBrowserWindow = new WebProgressListener();
  window.QueryInterface(nsCI.nsIInterfaceRequestor)
        .getInterface(nsIWebNavigation)
        .QueryInterface(nsCI.nsIDocShellTreeItem).treeOwner
        .QueryInterface(nsCI.nsIInterfaceRequestor)
        .getInterface(nsCI.nsIXULWindow)
        .XULBrowserWindow = window.XULBrowserWindow;

  // Manually hook up session and global history for the first browser
  // so that we don't have to load global history before bringing up a
  // window.
  // Wire up session and global history before any possible
  // progress notifications for back/forward button updating
  // http://mxr.mozilla.org/mozilla1.8.0/source/browser/base/content/browser.js#760
  var webNavigation = eBrowser.webNavigation
  webNavigation.sessionHistory = Components.classes["@mozilla.org/browser/shistory;1"]
                                   .createInstance(Components.interfaces.nsISHistory);
  var os = Components.classes["@mozilla.org/observer-service;1"]
             .getService(Components.interfaces.nsIObserverService);
  os.addObserver(eBrowser.browsers[0], "browser:purge-session-history", false);

  // remove the disablehistory attribute so the browser cleans up, as
  // though it had done this work itself
  eBrowser.browsers[0].removeAttribute("disablehistory");

  // enable global history
  eBrowser.docShell.QueryInterface(Components.interfaces.nsIDocShellHistory).useGlobalHistory = true;        

  eBrowser.addProgressListener(window.XULBrowserWindow, Components.interfaces.nsIWebProgress.NOTIFY_ALL);

  //setTimeout(delayedStartup, 0);

  if (dlm_base.getName().indexOf("eMusic") == 0) {
  //if (dlm_base.getName() == "eMusic Download Manager") {
    gBrowser = eBrowser;
    window.gBrowser = gBrowser;
    window.loadURI = dlm_web.goThere;
  }

  eBrowser.loadURI("chrome://emusic/locale/loading.html", null, null);
  
  //var obs = Components.classes["@mozilla.org/observer-service;1"]
  //              .getService(Components.interfaces.nsIObserverService);
  //obs.notifyObservers(null, "browser-window-before-show", "");

  // upgrade and try and make sure that first time user get this file to bind with eDownloadsView
  try {
    eDownloadManager.saveState();
  } catch (ex) {
    debug("Download List potentionally corrupt, had to repair it.")
    debug(ex)
    DownloadQueueRepair()
  }

  eDownloadsView = document.getElementById("dlmTree");
  eDownloadsAlbumView = document.getElementById("dlmAlbumTree");
  eDownloadsAudioBooksView = document.getElementById("dlmAudioBooksTree");

  if (nsPreferences.getBoolPref("eMusic.firstrun")) {
    DownloadQueueUpgrade();

    eDownloadsView.columns.restoreNaturalOrder()
    eDownloadsAlbumView.columns.restoreNaturalOrder()

    document.getElementById("view_statusBar").setAttribute("checked", true)
    
    document.getElementById("view_popupAlerts").setAttribute("checked", true)

    // from pre-alpha 4, after we cleanup localstore stuff
    // this should go away
    eTrackPreview.collapsed = false

    setTimeout(resetWindowObjects, 100);
    
    setTimeout(function() {dlm_web.goThere(nsPreferences.copyUnicharPref("eMusic.firstrun.homepage"), true) }, 500);

    nsPreferences.setBoolPref("eMusic.firstrun", false);
  }
  
  document.getElementById("showSidebar")
    .setAttribute("checked", !document.getElementById("navGrid").collapsed)

  toggleTotalProgress();

  prepMediaManagers();

  refreshDefaultPlayer();

  eDownloadManager.datasource.AddObserver(dlm_dlds_observer);
  eDownloadsView.database.AddDataSource(eDownloadManager.datasource);
  eDownloadsAlbumView.database.AddDataSource(eDownloadManager.datasource);
  eDownloadsAudioBooksView.database.AddDataSource(eDownloadManager.datasource);

  setStatusBar(!document.getElementById("view_statusBar").getAttribute("checked"))

  if (eCurrentDeck == 0) {
    setTimeout(function() {dlm_web.goThere(nsPreferences.copyUnicharPref("eMusic.lastUrl")) }, 1000);
  } else {
    showThisDeck(eCurrentDeck);
  }

  // clear previous download attempts
  processCmdLinePref();

  //initAutoDownloadDisplay();

  var dlmDirTree = document.getElementById("dlmDirectoryTree")
  //var dlmDirPath = document.getElementById("saveToFolder").getAttribute("path")

  var prefs = nsPreferences.mPrefService;
  var dlmDirPath = prefs.getComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile);
  dlmDirPath = dlmDirPath.path;
  dlmDirPath = dlm_base.scrubPath(dlmDirPath);
  dlmDirTree.setAttribute("ref", "file://" + dlmDirPath);
  
  eSearchURL = nsPreferences.copyUnicharPref("eMusic.defaultSearchURL");

  setPopupHandler()

  document.getElementById("statusbar-display").setAttribute("label", "Done");

  var sidebarBox= document.getElementById("sidebar-box");
  if (sidebarBox.hasAttribute("sidebarcommand")) {
    var commandID = sidebarBox.getAttribute("sidebarcommand");
    if (commandID) {
      var command = document.getElementById(commandID);
      if (command) {
        sidebarBox.hidden = false;
        var sidebarSplitter = document.getElementById("sidebar-splitter");
        sidebarSplitter.hidden = false;
        command.setAttribute("checked", "true");
      } else {
        // Remove the |sidebarcommand| attribute, because the element it 
        // refers to no longer exists, so we should assume this sidebar
        // panel has been uninstalled. (249883)
        sidebarBox.removeAttribute("sidebarcommand");
      }
    }
  }

  bInitializing = false
  
  setTimeout(reQueueDownloads, 2000);
  
  eDownloadsView.builder.rebuild();
  eDownloadsView.builder.refresh();

  eDownloadsAlbumView.builder.rebuild();
  eDownloadsAlbumView.builder.refresh();

  eDownloadsAudioBooksView.builder.rebuild();
  eDownloadsAudioBooksView.builder.refresh();

  window.focus();
  //gBrowser.mTabContainer.addEventListener("select", dlm_web.updateURL, true);

}



window.addEventListener('load', popupload, false);
window.addEventListener("load", function() { prefObserver.register(); } , false);
window.addEventListener("keydown", fullScreenKeys, true);

window.addEventListener("unload", function() { prefObserver.unregister(); } , false);
window.addEventListener("unload", function() { shutdownCleanup(); } , false);