#ifndef LINUX_NBD_H
#define LINUX_NBD_H

  /* unsigned comments are Pavel's originals for 2.1.*
   *   pavel@atrey.karlin.mff.cuni.cz (Pavel Machek)
   * comments marked PTB are from
   *   ptb@it.uc3m.es (Peter T. Breuer)
   * comments marked AMARIN are from
   *   amarin@it.uc3m.es (Andres Marin Lopez)
   */

  #include <asm/types.h>

  #ifndef ENBD_VERSION
  # define ENBD_VERSION "2.4.31 $Date: 2003/08/24 09:41:29 $"
  #endif /*ENBD_VERSION*/


  /*
   * Third type of request apart from READ or WRITE
   */
  #ifndef IOCTL
  # define IOCTL 2
  #endif

  /* PTB - new style ioctl assignments */
  #define ENBD_SET_SOCK         _IOW(0xab, 0x00, int)
  #define ENBD_TEST_IOCTL1      _IOW(0xab, 0x01, int)
  #define ENBD_SET_SIZE         _IOW(0xab, 0x02, int)
  #define ENBD_DO_IT            _IOW(0xab, 0x03, int)
  #define ENBD_CLEAR_SOCK       _IOW(0xab, 0x04, int)
  #define ENBD_CLEAR_QUE        _IO (0xab, 0x05)
  #define ENBD_PRINT_DEBUG      _IO (0xab, 0x06)
  #define ENBD_TEST_IOCTL2      _IOR(0xab, 0x07, int)
  #define ENBD_HARD_RESET       _IO (0xab, 0x09)
  #define ENBD_DEC_USE_COUNT    _IO (0xab, 0x09)
  #define MY_NBD_ACK           _IOW(0xab, 0x0a, char *)
  #define MY_NBD_GET_REQ       _IOW(0xab, 0x0b, char *)
  #define MY_NBD_REG_BUF       _IOW(0xab, 0x0c, char *)
  #define MY_NBD_CLR_REQ       _IOW(0xab, 0x0d, int)
  #define MY_NBD_SYNC          _IOW(0xab, 0x0e, int)
  #define ENBD_SET_SECTORS      _IOW(0xab, 0x0f, int)
  #define MY_NBD_SET_SIG       _IOW(0xab, 0x10, int *)
  #define ENBD_RESET            _IO (0xab, 0x11)
  #define ENBD_TEST_IOCTL3      _IOWR(0xab, 0x12, int)
  #define MY_NBD_ERR_REQ       _IOW(0xab, 0x13, int)
  #define MY_NBD_SET_INTVL     _IOW(0xab, 0x14, int)
  #define MY_NBD_SET_SHOW_ERRS _IOW(0xab, 0x15, int) 
  #define ENBD_SET_MD5SUM       _IOW(0xab, 0x16, int) 
  #define MY_NBD_SET_BUFFERWR  _IOW(0xab, 0x17, int) 
  #define MY_NBD_INVALIDATE    _IOW(0xab, 0x18, int)
  #define MY_NBD_SET_SPID      _IOW(0xab, 0x19, int) 
  #define MY_NBD_SET_RQ_HANDLE _IOW(0xab, 0x1a, void*) 
  #define MY_NBD_SET_RQ_SEQNO  _IOW(0xab, 0x1b, int) 
  #define MY_NBD_SET_RQ_DIGEST _IOWR(0xab, 0x1d, enbd_digest_t) 
  #define ENBD_TEST_IOCTL4      _IOR(0xab, 0x1e, char[256])
  #define ENBD_TEST_IOCTL5      _IOWR(0xab, 0x1f, char[256])
  #define ENBD_TEST_IOCTL6      _IO(0xab, 0x20) // special r 256B
  #define ENBD_TEST_IOCTL7      _IO(0xab, 0x21) // special rw 256B
  #define ENBD_SET_BLKSIZE      _IOW(0xab, 0x22, int)
  #define ENBD_GET_BLKSIZE      _IOR(0xab, 0x23, long)
  #define ENBD_SET_PF_MEMALLOC  _IOW(0xab, 0x24, int)
  #define MY_NBD_SET_DIRECT    _IOW(0xab, 0x25, int) 
  #define MY_NBD_GET_NPORT     _IOR(0xab, 0x26, int)
  #define ENBD_SETFAULTY        _IOW(0xab, 0x27, int)
  #define ENBD_HOTREMOVE        _IOW(0xab, 0x28, int)
  #define ENBD_HOTADD           _IOW(0xab, 0x29, int)

  #define ENBD_SHIFT 4         /* PTB 16 partitions/sockets/slots per device */
                              /* PTB number of socket slots per device */
  #define ENBD_MAXCONN (1<<ENBD_SHIFT)
  #define MAX_NBD (256>>ENBD_SHIFT) /* PTB MAX was 128, but that's a lot */
  #define ENBD_SIGLEN 128      /* PTB length of sig on device */
  #define ENBD_MAX_SECTORS 512 /* PTB max number of 512B sectors in a buffer */
  #define ENBD_CMDBITS 2       /* PTB significant bits of req->cms */
  #define ENBD_CMDMASK 0x03    /* PTB mask pertaining to CMDBITS */
  //#define ENBD_MAXGROUP 2      /* PTB number of client groups per device */



  #ifdef __KERNEL__
    /* PTB various module defaults */
    #define ENBD_RAHEAD_DFLT    24 /* PTB slow medium                  */
    #define ENBD_SYNC_INTVL      0 /* PTB sync every nK reqs (default disable) */
    #define ENBD_REQ_TIMEO       5 /* PTB client inactivity check (rollback) */
    #define ENBD_SPEED_LIM  100000 /* PTB limit to 100M write reqs/s */
    #define ENBD_MERGE_REQ_DFLT  0 /* PTB until accounting fixed! */
    #if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
      #define ENBD_PLUG_DFLT     0 /* PTB until accounting fixed! */
    #else
     /* PTB Jens Axboe says that plug should always be set in 2.4.* */
      #define ENBD_PLUG_DFLT     1 
    #endif
    #define ENBD_MD5SUM_DFLT     0 


    struct enbd_slot {
      struct file * file;      /* PTB add - for refcnt, NULL if slot empty */
      struct socket * sock;    /* PTB add                          */
      atomic_t in;             /* PTB add - tot blocks entered     */
      atomic_t out;            /* PTB add - tot blocks released    */
      atomic_t err;            /* PTB add - tot blocks errored     */
      atomic_t req;            /* PTB add - tot blocks pending     */
      char * buffer;           /* PTB add - user space buffer      */
      int  bufsiz;             /* PTB add - user space buffer size */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
      struct list_head queue;
#else
      struct request queue;
#endif
      unsigned long req_age;   /* PTB add - age of pending req     */
      unsigned long cli_age;   /* PTB add - age of client inactivity */
      struct enbd_device *lo;  /* PTB add - parent device          */
    #define ENBD_SLOT_RUNNING   0x0001
    #define ENBD_SLOT_WAITING   0x0002
    #define ENBD_SLOT_BUFFERED  0x0004
    #define ENBD_SLOT_MD5SUM    0x8000 /* slot reply has a digest in it ..*/
    #define ENBD_SLOT_MD5_OK   0x10000 /* .. and equaled req's */
      atomic_t flags;          /* PTB add */
      int i;                   /* PTB add - slot number */
      int buflen;              /* PTB add - buffer byte count */
      int pid;                 /* PTB add - client process */
      spinlock_t lock;         /* PTB add - so clr_sock/get_req/ack safely */
      int nerrs;               /* PTB add - local error count */
      int spid;                /* PTB add - server pid */
      //int group;               /* PTB add - for dual clients */
      atomic_t md_count;       /* PTB partition-is-in-raid count */
      atomic_t refcnt;         /* PTB count opens */
    };

    
    struct enbd_acct;   // forward decl

    struct enbd_speed {
      atomic_t speed;                      /* PTB add - current speed in KB/s */
      atomic_t speedmax;                   /* PTB add - max speed */
      atomic_t speedav;                    /* PTB add - average speed */
      atomic_t distance;                   /* PTB add - last distance measure */
      atomic_t jiffy;                      /* PTB add - last jiffies speed */
      atomic_t frstj;                      /* PTB add - first jiffy seen */
      atomic_t frstd;                      /* PTB add - first distance seen */
    };

    struct enbd_ioctl_info {
        int cmd;
        unsigned long arg;
        int size;
    };

    struct enbd_acct {
      atomic_t requests_in[2];             /* PTB add - blocks put on queue */
      atomic_t requests_out[2];            /* PTB add - blocks out from queue */
      atomic_t requests_err;               /* PTB add - blocks erred on queue */
      atomic_t requests_req[2];            /* PTB add - read blocks pending */
      atomic_t kwaiters;                   /* PTB add - kernel thrds waiting */
      atomic_t kthreads;                   /* PTB add - kernel threads in */
      atomic_t maxq[2];                    /* PTB add - max req queue depth */
      atomic_t countq[2];                  /* PTB add - request queue depth */
      //atomic_t errors;                     /* PTB add - tot requests errored */
      atomic_t cwaiters;                   /* PTB add - client thrds waiting */
      atomic_t cthreads;                   /* PTB add - client threads in */
      atomic_t req_in[2][1 + ENBD_MAX_SECTORS/2];
      atomic_t maxreqblks;                 /* PTB add - maximum req size seen */
    };

    struct enbd_bitmap {
        unsigned char **map;
        unsigned long pages;
        int (*make) (struct enbd_bitmap *bitmap);
        void (*destroy) (struct enbd_bitmap *bitmap);
        int (*checkpage) (struct enbd_bitmap *bitmap, unsigned long page);
        int (*set_mask) (struct enbd_bitmap *bitmap, unsigned long offset, unsigned char mask);
        int (*test_mask) (struct enbd_bitmap *bitmap, unsigned long offset, unsigned char mask);
        int (*clearbit) (struct enbd_bitmap *bitmap, unsigned long block);
        int (*testbit) (struct enbd_bitmap *bitmap, unsigned long block);
        rwlock_t lock;                /* PTB add - spinlock bitmap */
    };

    struct enbd_device {
      atomic_t refcnt;	
    #define ENBD_READ_ONLY   0x0001
    #define ENBD_REENABLE    0x0002
    #define ENBD_INITIALISED 0x0004
    #define ENBD_SIGNED      0x0008

    #define ENBD_ENABLED     0x0010
    #define ENBD_SIZED       0x0020
    #define ENBD_BLKSIZED    0x0040
    #define ENBD_RESYNCING   0x0080        /* device is resyncing */

    #define ENBD_VALIDATING  0x0100        /* reading partition table */
    #define ENBD_SHOW_ERRS   0x0200        /* showing errs, not blocking */
    #define ENBD_SYNC        0x0400
    #define ENBD_VALIDATED   0x0800        /* read partition table */

    #define ENBD_BUFFERWR    0x1000        /* buffer writes to device */
    #define ENBD_REMOTE_INVALID \
                             0x2000        /* remote resource vanished */
    #define ENBD_DIRECT      0x4000        /* convert opens to O_DIRECT */
    #define ENBD_MD5SUM      0x8000
    #define ENBD_RAID_SHOW_ERRS  \
                            0x10000        /* set show_errs for raid */
    #define ENBD_SET_SHOW_ERRS  \
                            0x20000        /* set show_errs for remote inval */
    #define ENBD_MD5SUM_NOAUTO  \
                            0x40000        /* enable/disable md5sums */


      atomic_t flags;
      int harderror;		           /* Code of hard error	    */
      int magic;			   /* FIXME: not if debugging is off  */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
      struct list_head queue;
#else
      struct request queue;
#endif
      rwlock_t queue_lock;                 /* PTB add - spinlock */
      int nslot;                           /* PTB add - total slots */
      atomic_t islot;                      /* PTB add - current slot */
      atomic_t aslot;                      /* PTB add - total active slots*/
      struct enbd_acct *acct;
      atomic_t wrequests_5so;              /* PTB add - write blocks md5 skip */
      atomic_t wrequests_5wo;              /* PTB add - write blocks md5 wr */
      atomic_t wrequests_5eo;              /* PTB add - write blocks md5 refus*/
      atomic_t wrequests_5to;              /* PTB add - write blocks md5sum */
      atomic_t wrequests_5co;              /* PTB add - write blocks md5 tot */
      atomic_t wrequests_5no;              /* PTB add - write blocks not md5 */
      atomic_t seqno_out;                  /* PTB add - sequence number */
      wait_queue_head_t wq;                /* PTB add */
      struct enbd_slot *slots[ENBD_MAXCONN]; /* PTB add - client array */
      unsigned blksize;                    /* PTB add - device blksize in B */
      u64 bytesize;                        /* PTB add - device size in B */
      u64 sectors;                         /* PTB add - device size (sectors) */
      unsigned size;                       /* PTB add - device size in blks */
      unsigned logblksize;                 /* PTB add - log2 blksize */
      unsigned nbd;                        /* PTB add - this array index */
      int signature[ENBD_SIGLEN/sizeof(int)];
                                           /* PTB add - server sig */
      struct file * file;                  /* PTB add - for ref */
      struct inode * inode;                /* PTB add - for ref */
      int  bufsiz;                         /* PTB add - userspace buffer size */
      atomic_t kmax;                       /* PTB add - max kernel threads */
      char *blockmap;                      /* PTB add - map of block states */
      unsigned long disabled;              /* PTB add - when was it disabled */
      int req_timeo;                       /* PTB add - inactivity timeout */
      struct timer_list run_queue;         /* PTB add - run queue */
      struct tq_struct task_queue;         /* PTB add - task queue */
      char devnam[4];                      /* PTB add - drive letters */
      int max_sectors;                     /* PTB add - max req size allowed! */
      int lives;                           /* PTB add - # times enabled */
      atomic_t seqno_in;                   /* PTB add - wreq sequence number */
      // PTB speed measurement settings
      struct enbd_speed tspeed;
      struct enbd_speed wspeed;
      struct enbd_speed rspeed;
      struct request req;                  /* PTB fake request for ioctls */
   #ifdef COMPLETION_INITIALIZER
      struct completion req_x;
   #endif
      wait_queue_head_t req_wq;
      struct semaphore req_sem;            /* PTB control fake req resource */
      struct semaphore pid_sem;            /* PTB control setting pid */
      //atomic_t ngroup;                     /* PTB number of client groups */
      rwlock_t meta_lock;                  /* PTB add - spinlock meta data */
      //atomic_t agroup;                     /* PTB number of active groups */
      //atomic_t igroup;                     /* PTB lowest active group */
      //atomic_t bgroup;                     /* PTB active group bitmap */
      //struct enbd_bitmap *bitmap[ENBD_MAXGROUP];
                                           /* PTB missed blocks map */
      //atomic_t cgroup;                     /* PTB count of notuptodate groups */
      //atomic_t fgroup;                     /* PTB mask of notuptodate groups */
      //unsigned short ggroup[ENBD_MAXGROUP]; /* PTB list of notuptodate groups */
      rwlock_t bitmap_lock;                /* PTB add - spinlock bitmap */
      struct enbd_ioctl_info req_ioctl_info;/* PTB add - to hold ioctl data */
      //unsigned progress[ENBD_MAXGROUP];     /* PTB resync progress */
      atomic_t merge_requests;             /* PTB local req blks limit - 1 */
      atomic_t md_count;                   /* PTB count of raids we are in */
      unsigned long reenable_time;         /* PTB time to delayed reenable */
    };

  /* COMPATIBILITY */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
// PTB the ifndef's are because Marcello in 2.2.19 ported back stuff from
// 2.4.* that I also ported back, thus causing conflicts.
  #ifndef schedule_task
    #define schedule_task(x) queue_task(x,&tq_scheduler)
  #endif
  #ifndef module_init
    #define module_init(x) int init_module(void) { return x(); }
  #endif
  #ifndef module_exit
    #define module_exit(x) int cleanup_module(void) { x(); return 0; }
  #endif
  #ifndef __exit
    #define __exit  __attribute__ ((unused, __section__(".text.exit")))
  #endif
  #ifndef __init
    #define __init  __attribute__ ((__section__ (".text.init")))
  #endif
#endif

  #ifndef __NBD_FILE
    #define __NBD_FILE __FILE__
  #endif

  #define ENBD_ID "ENBD %s #%d[%d]: %s "
  #if ENBD_COMPILED_DEBUG_LEVEL > 0
  #define ENBD_DEBUG(level, s...) \
     if(1 || debug>=(level)) \
             { static int icnt; printk( KERN_DEBUG ENBD_ID, __NBD_FILE, __LINE__, icnt++, __FUNCTION__); printk(s);}
  #else
    #define ENBD_DEBUG(level, s...)
  #endif

  #define ENBD_ERROR( s...) { static int icnt; printk( KERN_ERR   ENBD_ID, __NBD_FILE, __LINE__, icnt++, __FUNCTION__); printk(s);}
  #define ENBD_ALERT( s...) { static int icnt; printk( KERN_ALERT ENBD_ID, __NBD_FILE, __LINE__, icnt++, __FUNCTION__); printk(s);}
  #define ENBD_INFO( s...)  { static int icnt; printk( KERN_INFO  ENBD_ID, __NBD_FILE, __LINE__, icnt++, __FUNCTION__); printk(s);}

  // PTB forward declarations, mostly exported to enbd_proc
  //char * enbd_device_letter (int i);
  //int enbd_get_merge_requests(void);
  //void enbd_set_merge_requests (int merge_requests, int index);
  //int enbd_get_plug(void);
  //void enbd_set_plug (int plug, int index);
  //void enbd_snapshot_speed (struct enbd_device *lo);
  //long enbd_nr_blks (struct request *req);
  //int enbd_hard_reset (void);
  //int enbd_soft_reset (struct enbd_device *lo);
  //static int enbd_reenable_delay (struct enbd_device *lo, int delay);
  //int enbd_get_debug(void);
  //void enbd_set_debug (int d, int index);
  //void enbd_set_bitmap (int debug, int i);
  //void enbd_set_sync_intvl (int sync_intvl, int i);
  //void enbd_set_show_errs (int show_errs, int i);
  //void enbd_set_md5sum (int md5sum, int i);
  //void enbd_set_ra (int ra, int index);
  //void enbd_set_buffer_writes (int buffer_writes, int i);
  //void enbd_set_enabled (int enable, int i);
  //void enbd_set_direct (int direct, int i);
  //void enbd_zero_counters (int zs, int i);
  struct enbd_device * enbd_get_device(int i);
  void enbd_enqueue (struct enbd_device *lo, struct request *req);
  int enbd_open (struct inode *inode, struct file *file);
  int enbd_local_wait_on_request_timeout(struct request *req, unsigned long timeout);
  #ifndef release_t
        #if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
                #define release_t void
        #else
                #define release_t int
        #endif
  #endif
  release_t enbd_release (struct inode *inode, struct file *file);
  int enbd_ioctl (struct inode *inode, struct file *file,
	   unsigned int cmd, unsigned long arg);

  #endif /* __KERNEL__ */

  /* This now IS in some kind of include file...	*/

  /* PTB 132 */ 
  #define ENBD_INIT_MAGIC 0x12345678       /* AMARIN */
  #define ENBD_REQUEST_MAGIC 0x25609513
  #define ENBD_REPLY_MAGIC 0x67446698     
  /* Do *not* use magics: 0x12560953 0x96744668. 
   */
  #define ENBD_DEV_MAGIC 0x68797548

  #define ENBD_REQUEST_MAGIC_T  __u32
  #define ENBD_REQUEST_TYPE_T   __u32
  #define ENBD_REQUEST_FROM_T   __u64
  #define ENBD_REQUEST_LEN_T    __u32
  #define ENBD_REQUEST_FLAGS_T  __u32
  #define ENBD_REQUEST_TIME_T   __u64
  #define ENBD_REQUEST_ZONE_T   __s64
  #define ENBD_REQUEST_SPECIAL_T  __u32

  #define ENBD_REPLY_MAGIC_T    __u32
  #define ENBD_REPLY_ERROR_T    __s32
  #define ENBD_REPLY_FLAGS_T    __u32
  #define ENBD_REPLY_TIME_T     __u64
  #define ENBD_REPLY_ZONE_T     __s64

  #define ENBD_REQUEST_HANDLE_T __u32
  #define ENBD_REPLY_HANDLE_T   __u32

  typedef __u32 enbd_digest_t[4];

  #define ENBD_DIGEST_T   enbd_digest_t

  #define ENBD_REQUEST_DIGEST_T   ENBD_DIGEST_T
  #define ENBD_REPLY_DIGEST_T   ENBD_DIGEST_T

  #define ENBD_DIGEST_BITS      128
  #define ENBD_DIGEST_LENGTH    ((ENBD_DIGEST_BITS)/8)
  #define ENBD_REQUEST_SEQNO_T  __u32

  struct enbd_request {
    ENBD_REQUEST_MAGIC_T  magic;
    ENBD_REQUEST_TYPE_T   type;			/* == READ || == WRITE 	*/
    ENBD_REQUEST_HANDLE_T handle;
    ENBD_REQUEST_FROM_T   from;                    /* 64 bit PTB 132 */
    ENBD_REQUEST_LEN_T    len;                     /* 32 bit or ioctl code */



  #define ENBD_REQUEST_ERRORED    0x0800
  #define ENBD_REQUEST_MD5SUM     0x8000         /* has a digest in it ..*/
  #define ENBD_REQUEST_MD5_OK    0x10000         /* .. and equaled req's */
  #define ENBD_REQUEST_IOCTL     0x40000         /* ioctl+arg in from, len=0 */
  #define ENBD_REQUEST_SPECIALRW 0x80000         /* 1 for w 0 for r on special */
    ENBD_REQUEST_FLAGS_T  flags;
    ENBD_REQUEST_TIME_T   time;
    ENBD_REQUEST_ZONE_T   zone;
    ENBD_REQUEST_SEQNO_T  seqno;
    union {
       ENBD_REQUEST_DIGEST_T digest;
    } data;
    ENBD_REQUEST_SPECIAL_T special;
    char dummy0[0];
    char dummy1[0] __attribute__ ((aligned (64)));
  }  __attribute__ ((packed)) ;

  #define ENBD_REQUEST_LENGTH sizeof(struct enbd_request)

  struct enbd_reply {
    ENBD_REPLY_MAGIC_T    magic;
    ENBD_REPLY_ERROR_T    error;		      /* 0 = ok, else error	*/
    ENBD_REPLY_HANDLE_T   handle;	      /* handle you got from request */


  #define ENBD_REPLY_ERRORED      0x0800
  #define ENBD_REPLY_MD5SUM       0x8000         /* has a digest in it .. */
  #define ENBD_REPLY_MD5_OK      0x10000         /* .. and equaled req's  */
  #define ENBD_REPLY_CLOSE       0x20000         /* close cmd from server */
  #define ENBD_REPLY_IOCTL       0x40000         /* ioctl+arg in from, len=0 */
    ENBD_REPLY_FLAGS_T    flags;
    ENBD_REPLY_TIME_T     time;
    ENBD_REPLY_ZONE_T     zone;
    union {
       ENBD_REPLY_DIGEST_T digest;
    } data;
    char dummy0[0];
    char dummy1[0] __attribute__ ((aligned (64)));
  } __attribute__ ((packed)) ;

  #define ENBD_REPLY_LENGTH sizeof(struct enbd_reply)

  #define ENBD_BUFFER_DATA_OFFSET \
   ((ENBD_REQUEST_LENGTH>ENBD_REPLY_LENGTH)?ENBD_REQUEST_LENGTH:ENBD_REPLY_LENGTH)


#endif /* LINUX_NBD_H */

