--- linux-2.4.17rc2-xfs/Documentation/Configure.help.pre-enbd	Thu Aug 22 12:55:54 2002
+++ linux-2.4.17rc2-xfs/Documentation/Configure.help	Sat Mar 29 18:26:37 2003
@@ -517,6 +517,55 @@
 
   If unsure, say N.
 
+CONFIG_BLK_DEV_ENBD
+  Saying Y here will build in support for the "enhanced network 
+  block device".  Like the plain NBD, this device proxies a remote hard
+  disk or other block device, such as a cdrom or floppy.  The difference
+  between ENBD and NBD is that ENBD is a much more heavyweight solution
+  for an industrial setting - it does automatic reconnects after network
+  brownouts, and uses multiple channels at once to carry the data.  It
+  supports remote ioctls, removable devices, and uses an MD5 sampling
+  technique to accelerate softRAID resyncs.  It will connect through
+  (secure) SSL channels.
+
+  You will need the userspace daemons, which packages are mirrored
+  on several places on the net. The primary source is 
+  ftp://oboe.it.uc3m.es/pub/Programs/nbd/nbd-2.4.31.tgz. Look on
+  http://www.freshmeat.net for project ENBD for uptodate news.
+
+  If you want to compile this driver as a module ( = code which can be
+  inserted in and removed from the running kernel whenever you want),
+  say M here and read <file:Documentation/modules.txt>. The module
+  will be called enbd.o.
+
+  If unsure, say N.
+
+CONFIG_BLK_DEV_ENBD_IOCTL
+  Saying Y here will build in support to the "enhanced network 
+  block device" for the remote execution of ioctls on the serving
+  machine. You need do nothing extra to turn on this facility.
+
+  If you want to compile this driver as a module ( = code which can be
+  inserted in and removed from the running kernel whenever you want),
+  say M here and read <file:Documentation/modules.txt>. The module
+  will be called enbd.o.
+
+  If unsure, say N.
+
+CONFIG_BLK_DEV_ENBD_BUFFERWR
+  Saying Y here will build in support to the "enhanced network block
+  device" for a mode in which writes are cached locally in memory
+  instead of being passed to the remote server.  This is useful for ENBD
+  root partitions, as a single remote partition can then conveniently be
+  used to support multiple clients.
+
+  If you want to compile this driver as a module ( = code which can be
+  inserted in and removed from the running kernel whenever you want),
+  say M here and read <file:Documentation/modules.txt>. The module
+  will be called enbd.o.
+
+  If unsure, say N.
+
 ATA/IDE/MFM/RLL support
 CONFIG_IDE
   If you say Y here, your kernel will be able to manage low cost mass
--- linux-2.4.17rc2-xfs/drivers/block/Config.in.pre-enbd	Sat Mar 29 19:08:36 2003
+++ linux-2.4.17rc2-xfs/drivers/block/Config.in	Sat Mar 29 18:28:55 2003
@@ -39,6 +39,11 @@
 
 tristate 'Loopback device support' CONFIG_BLK_DEV_LOOP
 dep_tristate 'Network block device support' CONFIG_BLK_DEV_NBD $CONFIG_NET
+dep_tristate 'Enhanced network block device support' CONFIG_BLK_DEV_ENBD $CONFIG_NET
+if [ "$CONFIG_BLK_DEV_ENBD" = "y" -o "$CONFIG_BLK_DEV_ENBD" = "m" ]; then
+   dep_tristate 'ENBD remote ioctl support' CONFIG_BLK_DEV_ENBD_IOCTL $CONFIG_BLK_DEV_ENBD
+   dep_tristate 'ENBD remote-read/local-write support' CONFIG_BLK_DEV_ENBD_BUFFERWR $CONFIG_BLK_DEV_ENBD
+fi
 
 tristate 'RAM disk support' CONFIG_BLK_DEV_RAM
 if [ "$CONFIG_BLK_DEV_RAM" = "y" -o "$CONFIG_BLK_DEV_RAM" = "m" ]; then
--- linux-2.4.17rc2-xfs/drivers/block/Makefile.pre-enbd	Sat Mar 29 19:09:06 2003
+++ linux-2.4.17rc2-xfs/drivers/block/Makefile	Sat Mar 29 18:27:56 2003
@@ -31,6 +31,9 @@
 obj-$(CONFIG_BLK_DEV_DAC960)	+= DAC960.o
 
 obj-$(CONFIG_BLK_DEV_NBD)	+= nbd.o
+obj-$(CONFIG_BLK_DEV_ENBD)	+= enbd.o
+obj-$(CONFIG_BLK_DEV_ENBD_IOCTL)	+= enbd_ioctl.o
+obj-$(CONFIG_BLK_DEV_ENBD_BUFFERWR)	+= enbd_bufferwr.o
 
 subdir-$(CONFIG_PARIDE) += paride
 
--- linux-2.4.17rc2-xfs/drivers/block/enbd.c.pre-enbd	Sat Mar 29 18:29:42 2003
+++ linux-2.4.17rc2-xfs/drivers/block/enbd.c	Sat Sep  6 19:53:04 2003
@@ -0,0 +1,7199 @@
+/*
+ * (Enhanced) Network block device - make block devices work over TCP
+ *
+ * Original NBD Copyright 1997 Pavel Machek <pavel@elf.mj.gts.cz>
+ * Further ENBD Copyrights 1998, 1999, 2000 Peter Breuer <ptb@it.uc3m.es>
+ *
+ * Development of the ENBD software has been supported by grants and
+ * contributions from Realm Information Technologies, Inc. of 5555
+ * Oakbrook Parkway, NW Norcross, GA and iNsu Innovations Inc.  of
+ * 3465, Boulevard Thimens, Saint-Laurent, Quebec, Canada.
+ * 
+ * ------------ Pavel's history notes ----------------------------------
+ * 97-3-25 compiled 0-th version, not yet tested it 
+ *   (it did not work, BTW) (later that day) HEY! it works!
+ *   (bit later) hmm, not that much... 2:00am next day:
+ *   yes, it works, but it gives something like 50kB/sec
+ * 97-3-28 it's completely strange - when using 1024 byte "packets"
+ *   it gives 50kB/sec and CPU idle; with 2048 bytes it gives
+ *   500kB/sec (and CPU loaded 100% as it should be) (all done
+ *   against localhost)
+ * 97-4-1 complete rewrite to make it possible for many requests at 
+ *   once to be processed
+ * 97-4-1 23:57 rewrite once again to make it work :-(
+ * 97-4-3 00:02 hmm, it does not work.
+ * 97-4-3 23:06 hmm, it will need one more rewrite :-)
+ * 97-4-10 It looks like it's working and stable. But I still do not
+ *  have any recovery from lost connection...
+ * (setq tab-width 4)
+ * 97-4-11 Making protocol independent of endianity etc.
+ * 97-4-15 Probably one more rewrite, since it loses requests under
+ *  heavy loads
+ * 97-9-13 Cosmetic changes
+ *
+ * possible FIXME: make set_sock / set_blksize / set_size / do_it one syscall
+ * why not: would need verify_area and friends, would share yet another 
+ *          structure with userland
+ *
+ * FIXME: not module-safe
+ *
+ * ------------ Peter's history notes ----------------------------------
+ * 98-12-18 modules now OK ptb@it.uc3m.es (Peter Breuer) ported to
+ * 2.0.*. + better debugging. Still possible lockup in connection with APM
+ * and spurious interrupt - only on write. Error treatment should
+ * be improved. After 100 errors from end_request the kernel can
+ * do anything. We should catch it ourselves.
+ * 99-1-sometime fixed lockup by extending semaphore - ptb v1.0.
+ * 99-3-sometime reconnect protocol (client mod agreed by pavel) - ptb v1.1
+ * 99-4-25 add /proc/nbdinfo - ptb v1.1.1
+ * 99-4-sometime add multiplex - ptb v1.2
+ * 99-4-26 fix multiplex and redundancy - ptb v1.2.1
+ * 99-4-29 reentrant client threads - ptb v1.2.2
+ * 99-4-29 socket related stuff placed in user space - amarin v1.3.0
+ * 99-5-3  fix all, all writes had to be before all reads - ptb v1.2.4
+ * 99-5-5  fix out-of-order, async - ptb v1.2.5
+ * 99-5-7  semaphores removed (still works!), fail cases corrected - ptb v1.2.6
+ * 99-5-12 signals unblocked in xmit, blksize != 1024 fixed, ioctls
+ *         added  - ptb v1.2.7
+ * 99-6-1  interaction with client split into two functions - amarin v1.3.0
+ * 99-6-3  reintegrated fully, mem manager fixed, accounts fixed - ptb v1.2.8.3
+ * 99-6-3  extra queue removed, mem manager removed  - ptb v1.2.8.4
+ * 99-7-3  buffer registration introduced - ptb v1.2.8.5
+ * 99-7-3  some client redundancy reestablished - ptb v2.1.1
+ * 99-7-10 encapsulated queue calls. One element rollback buffer - ptb v2.1.2
+ * 99-7-20 timestamp and rollback old abandoned request - ptb v2.1.3
+ * 99-7-24 64bit file sizes and offsets accepted - ptb v2.1.9
+ * 99-7-26 experimental request coalesces - ptb v2.1.10
+ * 99-7-27 partitioning scheme - ptb v2.2.1
+ * 99-8-3  enbd_clr_sock bug in invalidate_device fixed? - ptb v2.2.4
+ * 99-8-5  reverse replace of block_fsync, add sig ioctls - ptb v2.2.5
+ *         reverse bug introduced about v2.2.3 for compound reqs - ptb v2.2.5
+ *         fix clear_que bug (didn't rollback first) from 2.1.3 - ptb v2.2.5
+ * 99-8-22 workaround strange nr_sectors bug - ptb v2.2.6
+ * 99-8-11 fix MY_NBD_SYNC bug. Never sync'ed all - ptb v2.2.7
+ * 99-8-12 wakeups all moved to enqueue - ptb v2.2.7
+ * 99-8-23 remove slot->cli_age - ptb v2.2.7
+ * 99-8-24 first 8 bytes of signature embedded in packets - ptb v2.2.8
+ *         fix SET_SIG define buglet, remove hardcoded constants - ptb v2.2.8
+ *         fix huge bug. Missing copy_fromfs in my_nbd_ack - ptb v2.2.8     
+ *         removed signature embedding and all other decorations - ptb v2.2.8
+ * 99-8-25 recast fix in my_nbd_ack to avoid align. bug - ptb v2.2.9
+ *         put in MKDEVs and put back some hardcode const fixes - ptb v2.2.10
+ * 99-9-29 fix BLKGETSIZE bug - ptb v2.2.14
+ * 99-10-2 run with interrupts on throughout. Think we lose some - ptb v2.2.15
+ * 99-10-8 trim dead code, kernel 2.2 ifdef's - ptb v2.2.17
+ * 99-12-18 further o-o - ptb v2.2.19
+ * 99-12-28 queue account cleanup. endio on queue reqs at reset - ptb v2.2.20
+ *          interruptible semaphores for better client recovery - ptb v2.2.20
+ * 00-1-2   debugging cleanups. Fix race in end_request - ptb v2.2.21
+ * 00-1-4   semaphores simplified. - ptb v2.2.22
+ * 00-6-8   emergency control by write to proc - ptb v2.2.24
+ * 00-7-20  ported to 2.4.0-test1. Possible minor bugs found/fixed - ptb v2.2.24
+ * 00-7-27  changed proc i/f to read_proc from get_info in 2.2/2.4 - ptb v2.2.25
+ * 00-7-30  fixed reads before writes under 2.4 by disabling merge - ptb v2.2.25
+ * 00-7-30  and fixed merge_reqs for 2.4, now that I understand! - ptb v2.2.25
+ * 00-7-30  fixed/introduced possible bug in end_io  for 2.2/2.4 - ptb v2.2.25
+ * 00-7-30 added timeval/zone field in requests and replies - ptb v2.4.0
+ * 00-7-30 fixed hitherto masked bug in read_stat in enbd_client - ptb v2.4.0
+ * 00-7-30 added timeout to net writes in enbd_client - ptb v2.4.0
+ * 00-8-20 display fix for devices over 2GB - ptb v2.4.5
+ * 00-8-23 more 64 bit fixes + error out overrange requests- ptb v2.4.6/2.2.27
+ * 00-8-31 add ENBD_ERR ioctl to error out slot request- ptb v2.4.9
+ * 00-8-31 soften ENBD_SOFT_RESET so doesn't wreck protocol - ptb v2.4.9
+ * 00-9-1  remove %L's from printfs. Kernel 2.2. doesn't - ptb v2.4.10/2.2.27
+ * 00-9-6  add various state flags to help init order - ptb v2.4.11
+ * 00-9-8  add checks for device initialised to set_sock - ptb v2.4.12
+ * 00-9-17 en/disable device as aslot count goes through 0 - ptb v2.4.13/2.2.28
+ * 00-9-21 split read/write dev req counts for accounting - ptb v2.4.14
+ * 00-9-21 renamed sync_intvl to req_timeo - ptb v2.4.14
+ * 00-9-21 made sync_intvl count write blocks - ptb v2.4.14
+ * 00-9-22 repair enable after delayed disable when disabled - ptb v2.4.14
+ * 00-9-22 include sync (nonblocking) after sync_intvl reqs - ptb v2.4.14
+ * 00-9-25 disable sync (nonblocking) after sync_intvl reqs - ptb v2.4.14
+ * 00-9-25 bundle invalidate_buffers in clr_sock - ptb v2.4.14
+ * 00-10-20 implement req_timeo per device + ioctl (Wang Gang) - ptb v2.4.15
+ * 00-10-20 add raid mode (Wang Gang) - ptb v2.4.15
+ * 00-10-26 throttle in do_req  - ptb v2.4.15
+ * 00-10-28 do set_sock on first open and clr_sock on last close - ptb v2.4.15
+ * 00-11-01 make sync_intvl really sync - ptb v2.4.15
+ * 00-11-14 rename throttle to plug, enbd_sync takes arg - ptb v2.4.17
+ * 00-11-19 clr_sock errs req not rollback if show_errs & !aslot - ptb v2.4.17
+ * 00-11-20 removed autodeadlock when disabled in do_req end_req - ptb v2.4.17
+ * 00-11-21 make MY_NBD_SYNC only sync when sync_intvl > 0 - ptb v2.4.17
+ * 00-12-24 make MY_NBD_GET_REQ use a timeout arg - ptb v2.4.18
+ * 01-02-12 ported to 2.4.0 (works). do_nbd_request rewritten - ptb v2.4.20
+ * 01-02-20 managed to get plugging and clustered read/writes OK - ptb v2.4.21
+ * 01-02-21 eliminated slot->buflen for the time being - ptb v2.4.21
+ * 01-02-27 added proper devfs support - ptb v2.4.22
+ * 01-03-15 allowed more devices/in devfs, cleaned up endio - ptb v2.4.23
+ * 01-03-15 added device letter (<= 3 chars) to struct-  - ptb v2.4.23
+ * 01-03-15 added request size check to do_nbd_req - ptb v2.4.23
+ * 01-03-15 increased MAX_SECTORS to 512 by default - ptb v2.4.23
+ * 01-03-15 made major number a module parameter - ptb v2.4.23
+ * 01-03-18 added max_sectors array - ptb v2.4.23
+ * 01-03-23 added devfs links - ptb v2.4.23
+ * 01-04-17 plugging always enabled for 2.4 kernels - ptb v2.4.24
+ * 01-04-17 made SET_RO set_device_ro as well as set local flags - ptb v2.4.25
+ * 01-04-28 impl SET_MD5SUM ioctl and proc support for md5sum - ptb v2.4.25
+ * 01-04-29 added accounting for md5'd reqs - ptb v2.4.25
+ * 01-07-29 added atomic protections for accounting - ptb v2.4.25
+ * 01-08-01 fixed 2.4 smp bugs. Interrupts off in spinlocks - ptb v2.4.25
+ * 01-08-01 removed all semaphores for spinlocks - ptb v2.4.25
+ * 01-08-01 invalidate_buffers in clr_sock (req'd Rogier Wolff) - ptb v2.4.25
+ * 01-08-02 fixed smp deadlock - end_that_request_first slept! ptb v2.4.26
+ * 01-10-16 provisionally added error in device open when notenabled ptb v2.4.27
+ * 01-10-18 added DIRTY flag to save on repeated invalidate_buffers ptb v2.4.27
+ * 01-10-31 increment seqno_out before delivery, so really starts at 1  v2.4.27
+ * 01-11-01 move zeroing of seqno in cmd field to nbe_end_req* ptb v2.4.27
+ * 01-11-18 add speed calculation, dev fields, display in proc ptb v2.4.27
+ * 01-11-20 modifications for compiling into monolithic kernel ptb v2.4.27
+ * 01-12-06 clr requests before reenabling, not after, in enbd_enable ptb 2.4.27
+ * 02-02-21 make enbd_rollback modal, absorbing enbd_error ptb 2.4.27
+ * 02-03-10 path for ioctls included ptb 2.4.27
+ * 02-04-02 ioctls extended to arbitrary length ptb 2.4.28
+ * 02-05-01 restructured init to get a per individual device init ptb 2.4.29
+ * 02-05-12 add PF_MEMALLOC for tcp to win contention for buffs ptb 2.4.29
+ * 02-08-03 erase syncs from last _release, daemons are usually dead ptb 2.4.29
+ * 02-08-07 added partition support ptb 2.4.30
+ * 02-08-08 added local BLKSSZGET and related ioctl treatments ptb 2.4.30
+ * 02-08-12 make enbd_ack not ruin req when its rolled back already ptb 2.4.30
+ * 02-09-18 always allow daemon death even with reqs waiting ptb 2.4.30
+ * 02-09-18 eliminate SYNC_REQD, RLSE_REQD ptb 2.4.30
+ * 02-09-18 eliminate speed_lim ptb 2.4.30
+ * 02-09-18 fix countq accounting ptb 2.4.30
+ * 02-09-18 IOCTLACTIVE flag instead of RO_ACTIVE status for ioctl ptb 2.4.30
+ * 02-09-18 eliminated ctldta use (too much tricky logic) ptb 2.4.30
+ * 02-10-01 eliminated IOCTLACTIVE, use req_sem semaphore instead ptb 2.4.30
+ * 02-10-10 introduce DIRECT flag ptb 2.4.30
+ * 02-10-13 rollback pushes reqs to local queue, not queues them! ptb 2.4.30
+ * 02-10-13 add hooks for separate ioctl module  ptb 2.4.30
+ * 02-10-16 take set_sock out of open. Put pid check in handshake  ptb 2.4.30
+ * 02-10-16 define MY_NBD_GET_NPORT ioctl ptb 2.4.30
+ * 02-10-18 remove wait from MY_NBD_SYNC ioctl ptb 2.4.30
+ * 02-10-20 rollback adds requests to queue in seqno order ptb 2.4.30
+ * 02-10-23 introduce and use pid_sem instead of req_sem ptb 2.4.30
+ * 02-10-30 support client fallback to ioctls on whole disk ptb 2.4.30
+ * 02-11-1  moved proc code to separate module ptb 2.4.30
+ * 02-11-1  made lazy wrt to making device structs ptb 2.4.30
+ * 02-11-3  moved set INITIALISED up to coincide with setting inode ptb 2.4.30
+ * 02-11-3  add media check and revalidate routines ptb 2.4.30
+ * 02-11-4  encapuslate lives++ and ENABLED changes into enbd_enable ptb 2.4.30
+ * 02-11-4  set_enable from proc only enables, not clears queue ptb 2.4.30
+ * 02-12-6  enbd_reread launched async to avoid restart deadlock ptb 2.4.30
+ * 02-12-7  enbd_release made aware of daemons on whole disk ptb 2.4.30
+ * 02-12-25 raid1 embedded ptb 2.4.31
+ * 03-01-1  made accounting turnable on and off ptb 2.4.31
+ * 03-01-3  made proc_write use tabl ptb 2.4.31
+ * 03-01-7  added ioctls for setfaulty etc. ptb 2.4.31
+ * 03-02-1  used metalock for non-queue changes ptb 2.4.31
+ * 03-03-12 add md_list notification ioctls ptb 2.4.31
+ * 03-04-20 turn show_errs on under raid ptb 2.4.31
+ * 03-05-06 add a magic-in-arg requirement to set sig on whole disk 2.4.31
+ * 03-05-10 fix semaphore deadlock in callback from md_notify_devices 2.4.31
+ * 03-05-12 remove md_list notification ioctls ptb 2.4.31
+ * 03-08-04 remove raid1 code ptb 2.4.31
+ */
+
+static int paranoia = 0;
+#define PARANOIA_BEGIN do if(paranoia){
+#define PARANOIA_END   } while(0)
+
+
+#include <linux/major.h>
+#ifndef UNIX98_PTY_MAJOR_COUNT
+  #define UNIX98_PTY_MAJOR_COUNT 8
+  #ifndef UNIX98_NR_MAJORS
+    #define UNIX98_NR_MAJORS=UNIX98_PTY_MAJOR_COUNT
+  #endif
+#endif
+
+#include <linux/module.h>
+
+#if defined(__GNUC__) && __GNUC__ >= 2
+#define _LOOSE_KERNEL_NAMES
+#endif
+
+#include <linux/version.h>
+#ifndef KERNEL_VERSION
+#define KERNEL_VERSION(a,b,c)  (((a) << 16) + ((b) << 8) + (c))
+#endif
+
+#include <linux/fs.h>
+#include <linux/stat.h>
+#include <linux/errno.h>
+
+#include <asm/segment.h>
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
+#include <asm/uaccess.h>          /* PTB - when did this arrive in kernel? */
+#endif
+#include <asm/byteorder.h>
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
+#include <linux/wrapper.h>
+#endif
+
+#define MAJOR_NR NBD_MAJOR
+static int major = MAJOR_NR;
+
+#include <linux/proc_fs.h>
+#include <linux/genhd.h>
+#include <linux/hdreg.h>
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
+#include <linux/file.h>           /* PTB - when did this arrive in kernel? */
+#endif
+#include <linux/smp_lock.h>
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,2,15)
+#include <linux/devfs_fs_kernel.h>
+#endif
+#include <linux/sysctl.h>
+#include <linux/init.h>
+#include <linux/blkdev.h>
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
+#include <linux/iobuf.h>
+#endif
+#include <linux/delay.h>
+#include <linux/timer.h>
+
+#define SPIN_MONITOR(x,y) { void _f(void) { y }; spin_lock(x); _f(); spin_unlock(x); }
+#define WRITE_MONITOR(x,y) { void _f(void) { y }; write_lock(x); _f(); write_unlock(x); }
+
+/* PTB --------------- compatibility ------------------- */
+
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
+  #if defined(__SMP__) || defined(SMP)
+    #if ! defined(CONFIG_SMP)
+      #error CONFIG_SMP not defined
+    #endif
+  #endif
+#endif
+
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
+  #define rq_data_dir(req) ((req)->cmd & 0x01)
+#endif
+
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
+  #define ENBD_BLKREQ_SPECIAL current_nr_sectors
+  #define ENBD_BLKREQ_BITMAP  errors
+#else
+  #define ENBD_BLKREQ_SPECIAL special
+  #define ENBD_BLKREQ_BITMAP  special
+#endif
+
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+  #define  invalidate_device(dev, sync) __invalidate_buffers(dev, sync)
+  #define  blk_init_queue(device, fn) (device)->request_fn = (fn)
+  #define  BLK_DEFAULT_QUEUE(major) (&blk_dev[major])
+  #define  blkdev_dequeue_request(req) { \
+     if (req==CURRENT) { \
+          CURRENT=CURRENT->next; \
+     } else { \
+          struct request * r; \
+          for (r = CURRENT; r && r->next; r = r->next) { \
+            if (r->next == req)  { \
+              r->next = req->next; \
+              break; \
+            } \
+          } \
+     } \
+  }
+  #define blk_cleanup_queue(device) (device)->request_fn = NULL
+  #define  rwlock_init(x)   do { *(x) = RW_LOCK_UNLOCKED; } while(0)
+// PTB now devfs shenanigans for the 2.2 kernelpatch
+
+#define devfs_mk_dir(dir, name, info) \
+          devfs_mk_dir(dir, name, strlen(name), info)
+#ifdef CONFIG_DEVFS
+static void devfs_register_series (devfs_handle_t dir, const char *format, 
+  unsigned int num_entries, unsigned int flags, unsigned int major,
+  unsigned int minor_start, umode_t mode, void *ops, void *info) {
+        unsigned int count;
+        char devname[128];
+        for (count = 0; count < num_entries; ++count) {
+                sprintf (devname, format, count);
+                devfs_register (dir, devname, flags, major,
+                        minor_start, mode, ops, info);
+        }
+}
+#endif
+#define devfs_mk_symlink(dir, name, flags, link, handle, info) \
+        devfs_mk_symlink(dir, name, strlen(name), flags, link, strlen(link), handle, info)
+#define devfs_find_handle(dir, name, major, minor, type, traverse_symlinks) \
+        devfs_find_handle(dir, name, strlen(name), major, minor, type, traverse_symlinks)
+
+// and partitions
+#ifdef DO_PART
+static void add_gendisk(struct gendisk *ptr) {
+        ptr->next = gendisk_head;
+        gendisk_head = ptr;
+}
+static void del_gendisk(struct gendisk *ptr) {
+        struct gendisk **gdp;
+        for (gdp = &gendisk_head; *gdp; gdp = &((*gdp)->next)) {
+                if (*gdp == ptr)
+                        break;
+        }
+        if (*gdp)
+                *gdp =(*gdp)->next;
+}
+
+static void grok_partitions(struct gendisk *dev, int drive, unsigned minors, long size) {
+    int first_minor = drive << dev->minor_shift;
+    int end_minor   = first_minor + dev->max_p;
+
+
+    if (!dev->sizes)
+        blk_size[dev->major] = NULL;
+    dev->part[first_minor].nr_sects = size;
+
+    //if (!size)
+    //		devfs_register_partitions (dev, first_minor, 0);
+    if (!size || minors == 1)
+		return;
+
+    if (dev->sizes) {
+        int i;
+        dev->sizes[first_minor] = size >> (BLOCK_SIZE_BITS - 9); 
+        for (i = first_minor + 1; i < end_minor; i++)
+            dev->sizes[i] = 0;
+    }
+    blk_size[dev->major] = dev->sizes;
+
+    resetup_one_dev(dev, drive);
+
+}
+#else
+static void grok_partitions(struct gendisk *dev, int drive, unsigned minors, long size){}
+static void del_gendisk(struct gendisk *ptr) {}
+static void add_gendisk(struct gendisk *ptr) {}
+#endif
+
+#endif
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)
+  #define  init_waitqueue_head(x) *(x) = NULL
+  typedef struct wait_queue *wait_queue_head_t;
+#ifndef init_MUTEX
+  #define init_MUTEX(x)*(x)=MUTEX
+#endif
+#ifndef init_MUTEX_LOCKED
+  #define init_MUTEX_LOCKED(x)*(x)=MUTEX_LOCKED
+#endif
+#endif /* < 2.2.18 */
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
+  #define MODULE_PARM(x,y)
+  #define copy_from_user(x, y, z) memcpy_fromfs((x), (y), (z))
+  #define copy_to_user(x, y, z) memcpy_tofs((x), (y), (z))
+  #define fget(arg) (current->files->fd[(arg) & 0xffff])
+  #define access_ok(vrw, buffer, size) (verify_area((vrw),(buffer),(size))==0)
+  #define interruptible_sleep_on_timeout(wq, delay) { \
+        current->timeout = (delay) + jiffies; \
+        interruptible_sleep_on (wq); \
+        current->timeout = 0; \
+  }
+  #define proc_register(x,y) proc_register_dynamic((x),(y))
+  #define release_t void
+  #define release_return(x) return
+  #undef GET_USE_COUNT
+  #define GET_USE_COUNT(this_module) ({ extern long mod_use_count_; mod_use_count_; })
+#else
+  #define release_t int
+  #define release_return(x) return (x)
+#endif
+
+
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+// PTB list fn versions which use requests as the list struct
+  static void enbd_list_del(struct request *req) {
+      req->next->sem  = req->sem;
+      ((struct request *) req->sem)->next = req->next;
+  }
+  static void enbd_list_add(struct request *req, struct request *head) {
+      head->next->sem = (struct semaphore *)req;
+      req->next = head->next;
+      req->sem = (struct semaphore *)head;
+      head->next = req;
+  }
+  static void enbd_list_add_tail(struct request *req, struct request *head) {
+      ((struct request *)head->sem)->next = req;
+      req->next = head;
+      req->sem = head->sem;
+      head->sem = (struct semaphore *)req;
+  }
+  static struct request * enbd_list_head(struct request *head) {
+      struct request *req = head->next;
+      if (req == head)
+          return NULL;
+      return req;
+  }
+  static struct request * enbd_list_tail(struct request *head) {
+      struct request *req = (struct request *)head->sem;
+      if (req == head)
+          return NULL;
+      return req;
+  }
+#define list_empty(head) ({typeof(head) _h = (head); _h->next == _h;})
+#define list_head(ptr, type, member) enbd_list_head(ptr) 
+#define list_tail(ptr, type, member) enbd_list_tail(ptr) 
+#define list_next(ptr, type, member) list_head(ptr,struct request,queue)
+#undef list_entry
+#define list_entry(ptr, type, member) ptr
+#undef INIT_LIST_HEAD
+#define INIT_LIST_HEAD(ptr) do { \
+    typeof(ptr) _p = (ptr);  _p->next = _p; _p->sem = (struct semaphore *)_p; \
+} while (0)
+
+#else
+/* PTB list interface extensions */
+#define list_head(ptr, type, member) \
+  (list_empty(ptr)?NULL:list_entry(((struct list_head *)ptr)->next,type,member))
+#define list_tail(ptr, type, member) \
+  (list_empty(ptr)?NULL:list_entry(((struct list_head *)ptr)->prev,type,member))
+#define list_next(ptr, type, member) list_head(ptr,struct request,queue)
+#endif
+
+/* PTB it's hard to say by kernel version alone if these are defined */
+#ifndef list_for_each_prev
+#define list_for_each_prev(pos, head) \
+        for (pos = (struct request *)(head)->sem; pos != (head); \
+                                pos = (struct request *)pos->sem)
+#endif
+#ifndef list_for_each
+  #define list_for_each(pos, head) \
+        for (pos = (struct request *)(head)->next; pos != (head); \
+                                pos = (struct request *)pos->next)
+#endif
+#ifndef list_for_each_safe
+  #define list_for_each_safe(pos, n, head) \
+        for (pos = (struct request *)(head)->next, \
+                                n = (struct request *)pos->next; \
+                              pos != (head); \
+                              pos = n, n = (struct request *)pos->next)
+#endif
+
+
+int linux_version_code = LINUX_VERSION_CODE;
+
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
+  int warning_old_kernel = 0;
+#else
+  #warning old kernel!
+  int warning_old_kernel = 1;
+  #define spin_unlock(lock) 
+  #define spin_lock(lock)
+  #define spin_unlock_irq(lock)              /*sti()*/
+  #define spin_lock_irq(lock)                /*cli()*/
+  #define spin_lock_irqsave(lock,flags)      /*{save_flags(flags);cli();}*/
+  #define spin_unlock_irqrestore(lock,flags) /*restore_flags(flags)*/
+#endif
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
+#ifndef __SMP__
+  #undef memset
+  #define memset(b,c,l) { \
+    int i; for (i = 0; i < l; i++) { ((char*)(b))[i++] = (char)(c); } \
+  }
+#endif /* SMP */
+#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0) */
+
+#ifndef atomic_set_mask
+  #define atomic_set_mask(mask, x) (x)->counter |= (mask)
+#endif
+#ifndef atomic_clear_mask
+  #define atomic_clear_mask(mask, x) (x)->counter &= ~(mask)
+#endif
+
+/* PTB --------------- end compatibility --------------- */
+
+
+    /* PTB we are included from the kernel nbd.c so put kernel stuff here */
+
+#include <linux/locks.h>
+#include <linux/config.h>
+
+#define ENDREQ_NOCURRENT
+#define LOCAL_END_REQUEST
+#include <linux/blk.h>
+#define __NBD_FILE "enbd.c"
+#ifndef DEBUG
+#define ENBD_COMPILED_DEBUG_LEVEL 0
+#else
+#define ENBD_COMPILED_DEBUG_LEVEL DEBUG
+#endif
+#include <linux/enbd.h>
+#include <linux/enbd_ioctl.h>
+
+
+
+/*
+ * PTB Stuff that used to be in enbd.h, mostly end_request, and is static
+ */
+
+   // PTB forward decl
+   static struct enbd_device * enbd_dev[];
+
+   #ifdef COMPLETION_INITIALIZER
+    static long wait_for_completion_timeout(struct completion *x, long timeout)
+    {
+	spin_lock_irq(&x->wait.lock);
+	if (!x->done && timeout > 0) {
+		DECLARE_WAITQUEUE(wait, current);
+
+		wait.flags |= WQ_FLAG_EXCLUSIVE;
+		__add_wait_queue_tail(&x->wait, &wait);
+		do {
+			__set_current_state(TASK_UNINTERRUPTIBLE);
+			spin_unlock_irq(&x->wait.lock);
+			timeout = schedule_timeout(timeout);
+			spin_lock_irq(&x->wait.lock);
+		} while (!x->done && timeout > 0);
+		__remove_wait_queue(&x->wait, &wait);
+	}
+        if (x->done) {
+	        x->done--;
+                if (timeout <= 0)
+                        timeout = 1;
+        }
+	spin_unlock_irq(&x->wait.lock);
+        return timeout;
+    }
+   #endif
+
+
+    static void end_request(struct request *req, int uptodate) {  
+       int dev = MINOR (req->rq_dev);
+       int nbd = dev >> ENBD_SHIFT;
+       struct enbd_device *lo = enbd_dev[nbd];
+       if (&lo->req == req) {
+          // PTB this is the devices own request, not from the queue
+#ifdef COMPLETION_INITIALIZER
+          complete(req->waiting);
+#else
+          // we have the io lock
+          req->rq_status = 0;
+#endif
+          wake_up(&lo->req_wq);
+          // PTB let other side lower semaphore and clean rq_status
+          return;
+       }
+       /* unlock chained buffers */
+       if (req->cmd != rq_data_dir(req)) {
+         printk(KERN_ERR "nbd: request %p has dirty cmd field ..  repairing\n",
+             req);
+         req->cmd = rq_data_dir(req); // PTB mend it before kernel gets it!
+       }
+       while (req->nr_sectors > 0){
+           if (!end_that_request_first (req, uptodate, DEVICE_NAME))
+               break;
+       }
+       end_that_request_last( req );
+
+    }                 
+   /* 
+    * PTB This takes the spinlock itself! So call it with the io spinlock
+    * not held.
+    */
+    static void end_request_lock(struct request *req, int uptodate) {  
+       unsigned long flags;
+       int dev = MINOR (req->rq_dev);
+       int nbd = dev >> ENBD_SHIFT;
+       struct enbd_device *lo = enbd_dev[nbd];
+       if (&lo->req == req) {
+          // PTB this is the devices ioctl request structure
+#ifdef COMPLETION_INITIALIZER
+          complete(req->waiting);
+#else
+          // we have the io lock
+          req->rq_status = 0;
+#endif
+          wake_up(&lo->req_wq);
+          // PTB let other side lower semaphore and clean rq_status
+          return;
+       }
+       if (req->cmd != rq_data_dir(req)) {
+         printk(KERN_ERR "nbd: request %p has dirty cmd field ..  repairing\n",
+             req);
+         req->cmd = rq_data_dir(req);
+       }
+       /* unlock chained buffers */
+       spin_lock_irqsave(&io_request_lock, flags);
+       while (req->nr_sectors > 0){
+           if (!end_that_request_first (req, uptodate, DEVICE_NAME))
+               break;
+       }
+       end_that_request_last( req );
+       spin_unlock_irqrestore(&io_request_lock, flags);
+
+    }
+   /*
+    * PTB Call this only with the io spinlock * held.
+    */
+    static void enbd_end_request(struct request *req) {
+      /*
+       * PTB the kernel has only 2 queues, read and write, and it uses
+       * the cmd field to determine to which the req belongs. We add a
+       * seqno to it in enbd_do_req, so we reestablish it here.
+       */
+      req->cmd = rq_data_dir(req);
+      end_request( req, !req->errors );
+    }
+   /* 
+    * PTB This takes the spinlock itself! So call it with the io spinlock
+    * not held.
+    */
+    static void enbd_end_request_lock(struct request *req) {  
+      /*
+       * PTB the kernel has only 2 queues, read and write, and it uses
+       * the cmd field to determine to which the req belongs. We add a
+       * seqno to it in enbd_do_req, so we reestablish it here.
+       */
+      req->cmd = rq_data_dir(req);
+      end_request_lock( req, !req->errors );
+    }
+
+
+
+/* 
+ * PTB kernel data - 4KB worth
+ * We need space for nda, nda1, .. nda15, ndb, ndb1, ..
+ * The index is exactly the minor number.
+ */
+static int enbd_blksizes [MAX_NBD * ENBD_MAXCONN];
+static int enbd_sizes    [MAX_NBD * ENBD_MAXCONN];
+static u64 enbd_bytesizes[MAX_NBD * ENBD_MAXCONN];
+static int enbd_max_sectors[MAX_NBD * ENBD_MAXCONN];
+static struct gendisk enbd_gendisk;
+static struct hd_struct enbd_hd_struct[MAX_NBD * ENBD_MAXCONN];
+static DECLARE_MUTEX(enbd_sem);
+
+/* 
+ * PTB our data   - about 3KB
+ * These are nda, ndb, ndc, ...
+ * Divide the minor by ENBD_MAXCONN to get this index.
+ * Or shift it right by ENBD_SHIFT.
+ */
+static struct enbd_device * enbd_dev[MAX_NBD];
+struct enbd_device *enbd_get_device(int i) {
+    if (i < 0 || i >= MAX_NBD)
+        return NULL;
+    return enbd_dev[i];
+}
+
+
+// PTB this is the hook for the enbd_ioctl module
+static struct enbd_ioctl *remote_ioctl;
+int enbd_register_remote_ioctl(struct enbd_ioctl *x) {
+    // PTB race
+    if (remote_ioctl == NULL) {
+        remote_ioctl = x;
+        return 0;
+    }
+    return -EINVAL;
+}
+int enbd_unregister_remote_ioctl(struct enbd_ioctl *x) {
+    // PTB race
+    if (remote_ioctl == x) {
+        remote_ioctl = NULL;
+        return 0;
+    }
+    return -EINVAL;
+}
+
+
+#define ENBD_FAIL( s ) { \
+  ENBD_DEBUG(1, s " (result %d).\n" , result ); \
+  goto error_out; \
+}
+
+/*
+ * PTB device parameters
+ */
+static int rahead     = ENBD_RAHEAD_DFLT; /* PTB - read ahead blocks  */
+static int sync_intvl = ENBD_SYNC_INTVL;  /* PTB - sync every n secs/Kreqs */
+static int merge_requests                /* PTB - bool, do request coalesce */
+                      = ENBD_MERGE_REQ_DFLT;
+static atomic_t atomic_merge_requests;
+static int buf_sectors
+                      = ENBD_MAX_SECTORS; /* PTB - user bufsize required */
+static int debug      = ENBD_COMPILED_DEBUG_LEVEL;
+static int show_errs  = 1;               /* PTB - RAID mode? not usually */
+static int direct     = 0;               /* PTB - all opens are O_DIRECT  */
+static int plug       = ENBD_PLUG_DFLT;
+#ifndef NO_BUFFERED_WRITES
+  static int buffer_writes
+                      = 0;               /* PTB - act like ramd on write */
+#endif /* NO_BUFFERED_WRITES */
+static   int md5sum   = 0;               /* PTB - use md5summing write proto */
+static   int md5_on_threshold
+                      = 1000;            /* PTB - reqs reqd to turn md5 on */
+static   int md5_off_threshold
+                      = 10;              /* PTB - errs reqd to turn md5 off */
+static   int check_partitions
+                      = 1;               /* PTB - de we grok_parts or not? */
+
+
+#if DEBUG > 0
+static char* debug_fns[9];
+MODULE_PARM(debug_fns,"1-8s");
+#endif
+
+#if defined(MODULE) 
+ MODULE_PARM(rahead,"i");
+ MODULE_PARM(sync_intvl,"i");
+ MODULE_PARM(merge_requests,"i");
+ MODULE_PARM(buf_sectors,"i");
+ MODULE_PARM(debug,"i");
+ MODULE_PARM(show_errs,"i");
+ MODULE_PARM(direct,"i");
+ MODULE_PARM(plug,"i");
+#ifndef NO_BUFFERED_WRITES
+ MODULE_PARM(buffer_writes,"i");
+#endif /* NO_BUFFERED_WRITES */
+ MODULE_PARM(major,"i");
+ MODULE_PARM(paranoia,"i");
+ MODULE_PARM(md5sum,"i");
+ MODULE_PARM(md5_on_threshold, "i");
+ MODULE_PARM(md5_off_threshold,"i");
+ MODULE_PARM(check_partitions, "i");
+#endif
+
+int
+enbd_get_merge_requests(struct enbd_device *lo) {
+        return atomic_read(&lo->merge_requests);
+}
+void
+enbd_set_merge_requests (int mr, int i)
+{
+        void set_mr(void)  {
+                struct enbd_device * lo = enbd_dev[i];
+                if (!lo || lo->magic != ENBD_DEV_MAGIC)
+                        return;
+                atomic_set(&lo->merge_requests, mr);
+        }
+	if (i >= 0 && i < MAX_NBD) {
+		set_mr ();
+		return;
+	}
+	for (i = 0; i < MAX_NBD; i++) {
+		set_mr ();
+	}
+        atomic_set(&atomic_merge_requests, mr);
+}
+
+static struct enbd_acct *
+acct_create(void) {
+
+        struct enbd_acct * res = kmalloc(sizeof(struct enbd_acct), GFP_KERNEL);
+        if (!res)
+            return NULL;
+        memset(res, 0, sizeof(*res));
+        return res;
+}
+static void
+acct_destroy(struct enbd_acct *acct) {
+
+        if (!acct)
+                return;
+        kfree(acct);
+}
+
+
+void
+enbd_set_acct (int ac, int i)
+{
+        void set_ac(void)  {
+                struct enbd_device * lo = enbd_dev[i];
+                if (!lo || lo->magic != ENBD_DEV_MAGIC)
+                        return;
+                if (ac) {
+                    if (!lo->acct) {
+                        lo->acct = acct_create();
+                    }
+                } else {
+                    if (lo->acct) {
+                        acct_destroy(lo->acct);
+                        lo->acct = NULL;
+                    }
+                }
+        }
+	if (i >= 0 && i < MAX_NBD) {
+		set_ac ();
+		return;
+	}
+	for (i = 0; i < MAX_NBD; i++) {
+		set_ac ();
+	}
+}
+int
+enbd_get_plug(void) {
+        return plug;
+}
+void
+enbd_set_plug (int p, int index)
+{
+        plug = p;
+}
+int
+enbd_get_debug(void) {
+        return debug;
+}
+void
+enbd_set_debug (int d, int index)
+{
+        debug = d;
+}
+void
+enbd_set_ra (int ra, int index) {
+	read_ahead[major] = ra;
+}
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+#define prev sem                         /* PTB - a coarse hack */
+#else
+#endif
+
+// PTB silly definition in order to catch both 2.2 an 2.4
+// This is really a pointer, and it's initialised in enbd_init.
+static typeof(BLK_DEFAULT_QUEUE(major)) enbd_queue;
+
+
+/*
+ * PTB count number of blocks in a request. This will be an overestimate
+ * if the number is not an exact multiple. It seems to happen. We 
+ * guarrantee to return -ve only if the request is invalid.
+ *
+ * @req - request we want to count
+ */
+static inline long
+nr_blks (struct request *req)
+{
+
+    unsigned log_sectors_per_blk;
+    unsigned sectors_per_blk;
+    int size, minor, nbd;
+    int sectors;
+    struct enbd_device *lo;
+
+    if (!req)
+	return -EINVAL;
+
+    minor = MINOR (req->rq_dev);
+    nbd   = minor >> ENBD_SHIFT;
+    lo    = enbd_dev[nbd];
+
+    log_sectors_per_blk = lo->logblksize - 9;
+    sectors_per_blk = 1 << log_sectors_per_blk;
+
+    sectors = req->nr_sectors;
+    size = (sectors + sectors_per_blk - 1) >> log_sectors_per_blk;
+
+    return size;
+}
+
+long
+enbd_nr_blks (struct request *req){
+    return nr_blks(req);
+}
+
+
+/*
+ * return a temporary buffer containing the (1 or 2 char) device letter.
+ * This works for i up to 26*26. 0 is "a". The buffer is zero
+ * terminated.
+ *
+ * @i number to be transtaed to x[y] alphabetical  form.
+ */
+char *
+enbd_device_letter (int i)
+{
+
+    static char buf[3];
+    static int cached_i = -1;
+
+    if (cached_i == i)
+	return buf;
+
+    cached_i = i;
+
+    if (i < 26) {
+	buf[0] = 'a' + i;
+	buf[1] = 0;
+	return buf;
+    }
+
+    buf[0] = 'a' + i / 26;
+    buf[1] = 'a' + i % 26;
+    buf[2] = 0;
+    return buf;
+}
+
+/*
+ *  PTB sync the device. Modes:
+ *  @arg = 1:  Do it sync
+ *  @arg = 0:  Do it async
+ *
+ *  We can't call sync_dev outside a process context. I don't know why.
+ *  Death results from a scheduled attempt.
+ *
+ *  Call without the semaphore held, as we lock it and call sync_dev.
+ */
+static void
+enbd_sync (struct enbd_device *lo, long arg)
+{
+    struct inode *inode = lo->inode;
+    short minor, nbd, islot;
+
+    islot = atomic_read (&lo->islot);
+
+    ENBD_DEBUG (1, "(%d): entered\n", islot);
+
+    // PTB I think semaphores might be dangerous when we close the device
+    // as we sync then
+    if (!(atomic_read (&lo->flags) & ENBD_INITIALISED) || !inode) {
+	goto fail;
+    }
+
+    minor = MINOR (inode->i_rdev);
+    nbd = minor >> ENBD_SHIFT;
+
+    //int i;
+    ENBD_DEBUG (2, "(%d) starts sync dev nd%s (%d) at %d requests\n",
+	       islot, lo->devnam,
+	       minor & ((1 << ENBD_SHIFT) - 1),
+               lo->acct ? atomic_read (&lo->acct->requests_in[WRITE]) : 0);
+    // PTB sync_dev is async. fsync_dev is sync.
+    switch (arg) {
+      case 0:
+	// async
+	ENBD_DEBUG (2, "(%d): choose async sync\n", islot);
+	sync_dev (MKDEV (major, nbd << ENBD_SHIFT));
+	break;
+      default:
+	// sync
+	ENBD_DEBUG (2, "(%d): choose sync sync\n", islot);
+	fsync_dev (MKDEV (major, nbd << ENBD_SHIFT));
+	invalidate_buffers (MKDEV (major, nbd << ENBD_SHIFT));
+	ENBD_DEBUG (3, "invalidated buffers on device nd%s\n", lo->devnam);
+	break;
+    }
+
+    ENBD_DEBUG (2, "(%d) ends sync dev nd%s (%d)\n", islot,
+	       lo->devnam, minor & ((1 << ENBD_SHIFT) - 1));
+
+    // PTB I think semaphores might be dangerous when we close the device
+    // as we sync then
+    ENBD_DEBUG (1, "(%d): exited OK\n", islot);
+    return;
+
+  fail:
+    // PTB I think semaphores might be dangerous when we close the device
+    // as we sync then
+    ENBD_DEBUG (1, "(%d): exited fail\n", islot);
+}
+
+static void
+enbd_async_sync (struct enbd_device *lo)
+{
+    enbd_sync (lo, 0);
+}
+static void
+enbd_sync_sync (struct enbd_device *lo)
+{
+    enbd_sync (lo, 1);
+}
+/*
+ *  Do it async if we're enabled, sync if we're not.
+ */
+static void
+enbd_maybe_sync_sync (struct enbd_device *lo)
+{
+
+    if ((atomic_read (&lo->flags) & ENBD_ENABLED)
+    &&  !(atomic_read (&lo->flags) & ENBD_REMOTE_INVALID)) {
+	enbd_async_sync (lo);
+	return;
+    }
+    enbd_sync_sync (lo);
+}
+
+/*
+ * PTB - put a request onto the head of a nbd device's queue
+ *     - presumably having taken it off the kernel's queue first!
+ *     - We cannot take the io_spinlock since we are called with it on!
+ *     - and we cannot take the semaphore as we may not sleep!
+ *
+ *     @lo      = the device we are on (could we get it from the req?)
+ *     @req     = the request we shift
+ *     @irqsave = save and restore irqmask when taking our queue spinlock
+ */
+void
+enbd_enqueue (struct enbd_device *lo, struct request *req)
+{
+    unsigned long req_blks = nr_blks (req);
+    short islot = atomic_read (&lo->islot);
+
+    islot = islot;		// PTB stops compiler complaints
+
+    ENBD_DEBUG (1, "(%d): entered\n", islot);
+
+   if (req_blks < 0) {
+	ENBD_ERROR ("(%d): invalid req %p. Not touching!\n", islot, req);
+        return;
+   }
+// PTB could be a valid ioctl request .. and anyway r/w 0 block is easy!
+   if (req_blks == 0) {
+	ENBD_DEBUG (1, "(%d): req %p with no blocks\n", islot, req);
+   }
+
+    PARANOIA_BEGIN;
+    if (1) {
+	struct buffer_head *bh = req->bh;
+	if (bh && !test_bit (BH_Lock, &bh->b_state)) {
+	    ENBD_ALERT ("buffer head found unlocked!");
+	}
+    }
+    PARANOIA_END;
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+     req->next = NULL;
+#endif
+
+    // PTB don't want anybody mucking with the request quete but we're
+    // called from the kernel request loop so we can't use the spinlock
+    // and I believe we can't use the semaphore as that may cause us to
+    // sleep. We need a special spinlock here if anything.
+    // PTB experiment since we are called from the kernel loop when the
+    // req is already off the kernel queue, we can't be affected by
+    // other alterations to the kernel queue, and our own alter-egos
+    // never fire on interrupts, so they can't interfere either even
+    // if irqs are allowed.
+
+    /* PTB accounting */
+
+    if (lo->acct) {
+            int countq;
+            int cmd = rq_data_dir(req);
+            atomic_add (req_blks, &lo->acct->requests_in[cmd]);
+            atomic_inc (&lo->acct->countq[cmd]);
+            countq = atomic_read (&lo->acct->countq[cmd]);
+    // PTB the max's are just noncritical stats
+            if (atomic_read (&lo->acct->maxq[cmd]) < countq)
+	            atomic_set (&lo->acct->maxq[cmd], countq);
+            atomic_inc (&lo->acct->req_in[cmd][req_blks]);
+    // PTB the max's are just noncritical stats
+            if (atomic_read (&lo->acct->maxreqblks) < req_blks)
+	            atomic_set (&lo->acct->maxreqblks, req_blks);
+    }
+
+    ENBD_DEBUG (1, "(%d): exited OK req with %lu blks added to device queue\n",
+	       islot, req_blks);
+
+    write_lock (&lo->queue_lock);
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+    list_add (&req->queue, &lo->queue);
+#else
+    enbd_list_add (req, &lo->queue);
+#endif
+    write_unlock (&lo->queue_lock);
+
+    wake_up_interruptible (&lo->wq);
+
+}
+
+#if 0
+/*
+ * PTB - pop a request off the tail of the nbd device general queue
+ */
+static struct request *
+enbd_dequeue (struct enbd_device *lo)
+{
+    struct request *req = lo->tail;
+    unsigned long flags;
+    int cmd;
+
+    if (!req)
+	return NULL;
+
+    cmd = rq_data_dir(req);
+    atomic_dec (&lo->acct->countq[cmd]);	/* PTB accounting */
+
+    spin_lock_irqsave (&io_request_lock, flags);
+    list_del (&req->queue);
+    spin_unlock_irqrestore (&io_request_lock, flags);
+
+    return req;
+}
+#endif
+
+/*
+ * PTB - remove a request from anywhere in the nbd device general queue 
+ *     - return 0 for success, -ve for fail
+ *
+ *     We need to hold the queue semaphore when calling this routine
+ *     and the queue spinlock too! It walks the queue.
+ */
+static int
+enbd_remove (struct enbd_device *lo, struct request *req)
+{
+
+    if (!req)
+	return -2;
+
+    if (req == &lo->req)
+        ENBD_DEBUG(1, "about to remove ioctl req %p from a queue\n", req);
+
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+    list_del (&req->queue);
+#else
+    enbd_list_del (req);
+#endif
+    goto success;
+
+  success:
+    if (lo->acct) {
+            int cmd = rq_data_dir(req);
+            atomic_dec (&lo->acct->countq[cmd]);	/* PTB accounting */
+    }
+    return 0;
+}
+
+
+/*
+ * only think of calling if VALIDATING is unset and then set VALIDATING in the
+ * caller before launching. It's cleared at routine end.
+ */
+static int
+enbd_reread_partitions (struct enbd_device *lo)
+{
+	int nbd = lo->nbd;
+
+        // critical region because of flag stuff
+	write_lock (&lo->meta_lock);
+
+        if (atomic_read (&lo->flags) & ENBD_VALIDATING) {
+            // PTB we forget to set the flag before launching
+	        write_unlock (&lo->meta_lock);
+		return -EINVAL;
+        }
+
+	if (!(atomic_read (&lo->flags) & ENBD_ENABLED)) {
+	        write_unlock (&lo->meta_lock);
+		ENBD_DEBUG (1, "device %s not enabled yet\n", lo->devnam);
+		return -EINVAL;
+	}
+
+	atomic_set_mask (ENBD_VALIDATING, &lo->flags);
+
+	if (enbd_gendisk.nr_real <= nbd)
+		enbd_gendisk.nr_real = nbd + 1;
+	write_unlock (&lo->meta_lock);
+
+	ENBD_INFO ("partition check on device nd%s\n", lo->devnam);
+	grok_partitions (&enbd_gendisk, nbd, ENBD_MAXCONN, lo->sectors);
+
+	write_lock (&lo->meta_lock);
+	atomic_set_mask (ENBD_VALIDATED, &lo->flags);
+	atomic_clear_mask (ENBD_VALIDATING, &lo->flags);
+	write_unlock (&lo->meta_lock);
+
+	return 0;
+}
+
+
+/*
+ * This small struct and aux fn is needed to pass data to a kernel thread.
+ * I'd rather have used the gcc local functions trick, but I suspect it
+ * won't work when there's a kernel thread launched.
+ */
+struct enbd_kernel_thread_struct {
+	int (*f) (void *);
+	void *data;
+};
+static int
+enbd_kernel_thread_aux (void *d)
+{
+        struct enbd_kernel_thread_struct * x = d;
+        int (*f)(void *) = x->f;
+        void *data = x->data;
+	int res;
+	kfree (x); // matches kmalloc in enbd_kernel thread
+	res = f (data);
+	reparent_to_init ();
+	return res;
+}
+
+/*
+ * PTB - start a thread but reparent it to init as it terminates in
+ * order to avoid it becoming a zombie as we don't otherwise wait4 it.
+ */
+static int
+enbd_kernel_thread (int (*f) (void *), void *data, unsigned long flags)
+{
+
+	struct enbd_kernel_thread_struct * x = kmalloc(sizeof(*x), GFP_KERNEL);
+        if (!x)
+                return -ENOMEM;
+        x->f = f;
+        x->data = data;
+	return kernel_thread (enbd_kernel_thread_aux,x,flags);
+}
+
+/*
+ *  PTB - Open the device
+ */
+int
+enbd_open (struct inode *inode, struct file *file)
+{
+    int dev;
+    struct enbd_device *lo;
+    int nbd;
+    int part;
+    int islot;
+    unsigned long flags;
+
+    ENBD_DEBUG (2, "entered by pid %d\n", current->pid);
+
+    if (1 && !inode && file) {	/* added by ptb for 2.0.35. Necessary? */
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
+	inode = file->f_dentry->d_inode;
+#else
+	inode = file->f_inode;
+#endif
+    }
+    if (!inode) {
+	ENBD_ERROR ("null inode.\n");
+	ENBD_DEBUG (3, "exited INVAL\n");
+	return -EINVAL;
+    }
+
+    dev = MINOR (inode->i_rdev);
+    nbd = dev >> ENBD_SHIFT;
+    part = dev - (nbd << ENBD_SHIFT);
+    islot = part - 1;
+
+    ENBD_DEBUG (3, "have inode %x for dev %d:%d\n", (unsigned) inode,
+	       major, dev);
+
+    if (nbd >= MAX_NBD) {
+	ENBD_ERROR ("too many (%d) whole devices open\n", nbd);
+	ENBD_DEBUG (3, "exited NODEV\n");
+	return -ENODEV;
+    }
+
+    
+    // PTB kmalloc might sleep so need semaphore, not spinlock
+    down(&enbd_sem);
+    if ((lo = enbd_dev[nbd]) == NULL) {
+            static int enbd_setup(struct enbd_device *lo, int i);
+            enbd_dev[nbd] = lo = kmalloc(sizeof(*lo), GFP_KERNEL);
+            if (!lo) {
+                up(&enbd_sem);
+                return -ENOMEM;
+            }
+            ENBD_ALERT("setup device %d\n", nbd);
+            if (enbd_setup(lo, nbd) < 0) {
+                static void enbd_destroy(struct enbd_device *lo);
+                enbd_destroy(lo);
+                enbd_dev[nbd] = NULL;
+                up(&enbd_sem);
+                return -ENOMEM;
+            }
+    }
+    up(&enbd_sem);
+    // PTB release semaphore, end crit region
+
+
+    ENBD_DEBUG (3, "have device nd%s%d\n", lo->devnam, part);
+
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,9) && defined(KERNEL_HAS_O_DIRECT)
+    if (file) {
+        if ((atomic_read(&lo->flags) & ENBD_DIRECT)
+                && !(file->f_flags & O_DIRECT)) {
+                int err = alloc_kiovec(1, &file->f_iobuf);
+                if (err == 0) {
+                        // PTB O_NOFOLLOW is nonsensical and means
+                        // we have set the O_DIRECT flag ourselves
+                        file->f_flags |= O_DIRECT | O_NOFOLLOW;
+                        ENBD_INFO("converted open of nd%s%d to O_DIRECT\n",
+                               lo->devnam, part);
+                }
+        }
+        ENBD_DEBUG(1, "opened dev nd%s%d with flags %sO_DIRECT\n",
+                lo->devnam, part,
+                file->f_flags & O_DIRECT? "" : "~");
+    }
+#endif
+
+
+    ENBD_DEBUG (3, "whole device nd%s has reference count %d\n",
+	       lo->devnam, atomic_read (&lo->refcnt));
+
+
+    if (part == 0) {
+        // PTB fiddle with device metadata
+        write_lock_irqsave (&lo->meta_lock, flags);
+	if (!lo->file || lo->file != file) {
+	/* PTB we have got the whole dev's file or inode for 1st time */
+	    ENBD_DEBUG (3, "set file %x for whole device nd%s\n",
+		       (unsigned) file, lo->devnam);
+	    lo->file = file;
+	    atomic_set (&(&lo->wspeed)->frstj, jiffies);
+	    atomic_set (&(&lo->rspeed)->frstj, jiffies);
+	    atomic_set (&(&lo->tspeed)->frstj, jiffies);
+	}
+	if (!lo->inode || lo->inode != inode) {
+	    ENBD_DEBUG (3, "set inode %x for whole device nd%s\n",
+		       (unsigned) inode, lo->devnam);
+	    lo->inode = inode;
+	}
+        if (!(atomic_read (&lo->flags) & ENBD_INITIALISED)) {	/* PTB 132 */
+	        ENBD_DEBUG (1, "initialized unitialized device nd%s\n",
+                    lo->devnam);
+	        atomic_set_mask (ENBD_INITIALISED, &lo->flags);
+        }    
+        write_unlock_irqrestore (&lo->meta_lock, flags);
+    }
+
+    atomic_inc (&lo->refcnt);
+
+    ENBD_DEBUG (3, "increment device nd%s reference count to %d\n",
+	       lo->devnam, atomic_read (&lo->refcnt));
+    MOD_INC_USE_COUNT;
+
+    ENBD_DEBUG (2, "exited OK\n");
+    return 0;
+}
+
+/*
+ * PTB - complete a transaction irrefutably by taking it out of the
+ *     - slot pending position it is in, and reporting end_request to kernel
+ *
+ *       We are called without the spinlock held, and without the io
+ *       lock held, because our call to end request will take the io
+ *       lock momentarily.
+ */
+void
+enbd_commit (struct enbd_slot *slot, struct request *req)
+{
+
+    struct enbd_device *lo = slot->lo;
+    unsigned long req_blks = nr_blks (req);
+    int errors, cmd;
+
+    if (req_blks < 0) {
+        ENBD_ERROR("corrupted req %p. Not touching with bargepole.\n", req);
+    	return;
+    }
+
+    errors = req->errors;
+
+    // PTB We're the only daemon who can touch this slot so we don't need
+    // no steenking spinlock. And our slot queue doesn't need the
+    // kernels io lock protection either, so no steenking io lock.
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+    list_del (&req->queue);
+#else
+    enbd_list_del (req);
+#endif
+
+    cmd = rq_data_dir(req);
+    // PTB NB enbd_end_req_lock needs to be called without the io spinlock on
+    enbd_end_request_lock (req);
+
+    slot->req_age = 0;
+
+    slot->req -= req_blks;
+    if (lo->acct) {
+            atomic_sub (req_blks, &lo->acct->requests_req[cmd]);
+    }
+    if (errors < 0) {
+            if (lo->acct) {
+                    atomic_add (req_blks, &lo->acct->requests_err);
+            }
+            slot->err += req_blks;
+            return;
+    }
+    if (lo->acct) {
+            atomic_add (req_blks, &lo->acct->requests_out[cmd]);
+    }
+    slot->out += req_blks;
+
+    if (cmd != WRITE)
+	return;
+
+    // PTB non error case writes
+
+    // PTB account the 4 cases for a md5sum'd transaction
+    switch (slot->flags & (ENBD_SLOT_MD5SUM | ENBD_SLOT_MD5_OK)) {
+
+      case ENBD_SLOT_MD5SUM | ENBD_SLOT_MD5_OK:
+	// PTB the two matched, so we skipped writing the request
+	atomic_add (req_blks, &lo->wrequests_5to);	// 11
+	atomic_add (req_blks, &lo->wrequests_5so);
+	// zero the countdown to turning off md5 as it works
+	atomic_set (&lo->wrequests_5co, 0);
+        ENBD_DEBUG(3, "commit acked OK md5sum wreq %x\n", (unsigned)req);
+	break;
+
+      case ENBD_SLOT_MD5SUM:
+	// PTB the two differed, so we wrote the request
+	atomic_add (req_blks, &lo->wrequests_5to);	// 10
+	atomic_add (req_blks, &lo->wrequests_5wo);
+	atomic_inc (&lo->wrequests_5co);
+	if (atomic_read (&lo->wrequests_5co) > md5_off_threshold) {
+	        atomic_set (&lo->wrequests_5co, 0);
+	    // turn off md5summing as it's not successful
+	        atomic_clear_mask (ENBD_MD5SUM, &lo->flags);
+	}
+        ENBD_DEBUG(3, "commit acked failed md5sum wreq %x\n", (unsigned)req);
+	break;
+
+      case ENBD_SLOT_MD5_OK:
+	// PTB the server refused to try a md5 request
+	atomic_add (req_blks, &lo->wrequests_5to);	// 01
+	atomic_add (req_blks, &lo->wrequests_5eo);
+	atomic_inc (&lo->wrequests_5co);
+	if (atomic_read (&lo->wrequests_5co) > md5_off_threshold) {
+	       atomic_set (&lo->wrequests_5co, 0);
+	    // turn off md5summing as it's errored
+	       atomic_clear_mask (ENBD_MD5SUM, &lo->flags);
+	}
+        ENBD_DEBUG(3, "commit acked refused md5sum wreq %x\n", (unsigned)req);
+	break;
+
+      default:
+      case 0:
+	// PTB nobody asked for a md5 and nobdy gave one back
+	atomic_inc (&lo->wrequests_5no);
+	if (atomic_read (&lo->wrequests_5no) > md5_on_threshold) {
+	        atomic_set (&lo->wrequests_5no, 0);
+	    // turn on md5summing every so often
+	        atomic_set_mask (ENBD_MD5SUM, &lo->flags);
+	}
+        ENBD_DEBUG(3, "commit acked non-md5sum wreq %x\n", (unsigned)req);
+	break;
+    }
+
+    // PTB clear the md5sum indicators from the slot afterwards!
+    slot->flags &= ~(ENBD_SLOT_MD5SUM | ENBD_SLOT_MD5_OK);
+
+}
+
+/*
+ * PTB - error out a transaction irrefutably by taking it out of the
+ *     - slot pending position it is in, and reporting end_request to kernel
+ *
+ *     We must be called without the io spinlock held, as we take it
+ */
+void
+enbd_error (struct enbd_slot *slot, struct request *req)
+{
+    struct enbd_device *lo = slot->lo;
+    unsigned long req_blks = nr_blks (req);
+
+    if (req_blks < 0) {
+        ENBD_ERROR("passed illegal request %p\n", req);
+    }
+
+    req->errors++;
+
+    // PTB We don't need the spinlock since we don't touch our queue,
+    // and we're the only ones working on this slot.
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+    list_del (&req->queue);
+#else
+    enbd_list_del (req);
+#endif
+
+    ENBD_ALERT ("error out req %p from slot %d!\n", req, slot->i);
+
+    // PTB enbd_end_req_lock needs to be called without the spinlock on
+    enbd_end_request_lock (req);
+
+    ENBD_DEBUG (2, "released kernel queue lock\n");
+
+    // PTB accounting
+    if (lo->acct) {
+            int cmd = rq_data_dir(req);
+            atomic_sub (req_blks, &lo->acct->requests_req[cmd]);
+
+            slot->in -= req_blks;
+            slot->req -= req_blks;
+
+            slot->err += req_blks;
+            atomic_add (req_blks, &lo->acct->requests_err);
+    }
+
+    slot->req_age = 0;
+}
+
+/*
+ * PTB auxiliary functions for manipulating the sequence number 
+ */
+static int
+rq_seqno(struct request *req) {
+    return req->cmd >> ENBD_CMDBITS;
+}
+static void
+rq_set_seqno(struct request *req, int val) {
+	    req->cmd &= (1 << ENBD_CMDBITS) - 1;
+	    req->cmd |= val << ENBD_CMDBITS;
+}
+
+
+/*
+ * PTB - auxiliary function
+ */
+static int
+rq_type(struct request *req) {
+	    return req->cmd & ((1 << ENBD_CMDBITS) - 1);
+}
+
+/*
+ * PTB
+ * Take a request out of a slot. This must not hold the i/o lock on
+ * entry as we may take it in order to kill the request (end_request)
+ * or we may take the queue lock in order to play with the devices
+ * queue (enbd_enqueue). The request goes back on the general device
+ * queue. It goes to a new device queue if necessary.
+ */
+static void
+enbd_rollback (struct enbd_slot *slot, struct request *req)
+{
+
+	struct enbd_device *lo = slot->lo;
+	unsigned long req_blks;
+	int seqno;
+	unsigned long flags;
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+	struct list_head *pos;
+#else
+	struct request *pos;
+#endif
+	struct request *xreq;
+        int cmd;
+
+	if (atomic_read (&lo->flags) & ENBD_SHOW_ERRS) {
+		enbd_error (slot, req);
+		return;
+	}
+
+	req_blks = nr_blks (req);
+
+	if (req_blks < 0) {
+		ENBD_ERROR ("passed illegal request 0x%lx\n",
+                        (unsigned long) req);
+		return;
+	}
+
+	// PTB don't want anybody mucking with the request queue
+	// but classically this was never held so I'll try doing without it
+	// PTB the reason is that we here modify only the slot queue, to
+	// which we have unique access anyway.
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+	list_del (&req->queue);
+#else
+	enbd_list_del (req);
+#endif
+        cmd = rq_type(req); 
+
+	ENBD_ALERT ("rollback req %p, type %d, sector %lu, %lu blks, %lu  sectors from slot %d!\n",
+                req, cmd, req->sector, req_blks, req->nr_sectors, slot->i);
+	/* PTB accounting */
+        slot->in -= req_blks;
+        slot->req -= req_blks;
+
+	seqno = rq_seqno (req);
+
+	write_lock_irqsave (&lo->queue_lock, flags);
+
+	list_for_each_prev (pos, &lo->queue) {
+		xreq = list_entry (pos, struct request, queue);
+		if (rq_seqno (xreq) > seqno) {
+			break;
+		}
+	}
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+	list_add_tail (&req->queue, pos);
+#else
+	enbd_list_add_tail (req, pos);
+#endif
+
+	write_unlock_irqrestore (&lo->queue_lock, flags);
+
+}
+
+/*
+ * PTB - undo transactions by taking them out of the slot pending
+ *     - position and replacing them on the generic device queue
+ *     - NB we do not hold the io request lock or queue sem when
+ *     -    calling this as we take it internally
+ */
+static void
+enbd_rollback_all (struct enbd_slot *slot)
+{
+
+    struct request *req;
+    short count = 0;
+
+    while (!list_empty (&slot->queue)) {
+
+	if (count++ > 1000)
+	    break;
+
+	req = list_head (&slot->queue,struct request,queue);
+
+	if (!req)
+	    break;
+
+        enbd_rollback (slot, req);
+    }
+
+}
+
+
+
+/*     PTB error out all the requests on a slot
+ *     
+ *     We must be called without the io spinlock held, as we take it in
+ *     enbd_error().
+ */
+static void
+enbd_error_all (struct enbd_slot *slot)
+{
+
+    struct request *req;
+    short count = 0;
+
+    while (!list_empty (&slot->queue)) {
+	if (count++ > 1000)
+	    break;
+	req = list_head (&slot->queue,struct request,queue);
+	if (!req)
+	    break;
+	enbd_error (slot, req);
+    }
+}
+
+/*
+ * PTB - let a request onto the slot pending position
+ *     - Can be called without the spinlock and doesn't take the
+ *       spinlock as we  only deal with our  unique slot. If there
+ *       were more than one client per slot this woould be a problem
+ *       but there aren't so it isn't.
+ */
+void
+enbd_accept (struct enbd_slot *slot, struct request *req)
+{
+
+    struct enbd_device *lo = slot->lo;
+    unsigned long req_blks = nr_blks (req);
+
+    if (req_blks < 0)
+    	return;
+
+    /* PTB - really list_add(&req->queue, &slot->queue);
+     * Note that this really is slot and not lo.
+     */
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+    list_add (&req->queue, &slot->queue);
+#else
+    enbd_list_add (req, &slot->queue);
+#endif
+
+    slot->req_age = jiffies;
+
+    if (lo->acct) {
+            int cmd = rq_data_dir(req);
+            atomic_add (req_blks, &lo->acct->requests_req[cmd]);
+    }
+    slot->in += req_blks;
+    slot->req += req_blks;
+}
+
+/*
+ * PTB - read from userspace to a request buffer. Do it piecewuse
+ *     - to cope with clustered requests.
+ *     - return number of bytes read
+ *
+ *     Unfortunately the only way we can return less than the right
+ *     number of bytes is when the recieving req does not have the
+ *     right number of buffers, because the copy_from_user itself
+ *     doesn't tell us.
+ */
+static int
+copy_from_user_to_req (struct request *req, char *user, int len)
+{
+
+	unsigned size = 0;
+	struct buffer_head *bh = req->bh;
+
+	/* PTB assume user verified */
+
+	while (size < len && bh) {
+		unsigned current_size = bh->b_size;
+		char *buffer = bh->b_data;
+
+		ENBD_DEBUG (3, "read %d from user at %0x\n",
+			   current_size, (unsigned) (user + size));
+
+		copy_from_user (buffer, user + size, current_size);
+
+		size += current_size;
+
+		bh = bh->b_reqnext;
+	}
+	if (size != len) {
+		ENBD_ALERT
+		 ("requested %d and could only read %d bytes to req %p\n",
+		           len, size, req);
+		ENBD_ALERT ("request %p has first bh %p size %ld\n",
+			   req, req->bh,
+			   (long) (req->bh ? req->bh->b_size : 0));
+		ENBD_ALERT
+		 ("request %p wanted to read user space buffer %p\n",
+		          req, user);
+	}
+	return size;
+}
+
+
+
+
+/*
+ * PTB - andres' kernel half of the user-space network handshake, used
+ *     - to complete a transaction.
+ *     - return 0 for success and -ve for fail.
+ */
+int
+enbd_ack (struct enbd_slot *slot, char *buffer)
+{
+    struct enbd_reply reply;
+    struct request *req, *xreq;
+    int result = 0;
+
+    void *user;
+    unsigned long req_blks = 1;
+    struct enbd_device *lo = slot->lo;
+    unsigned buflen = 0;
+    unsigned reqlen;
+
+    ENBD_DEBUG (3, "(%d): entered\n", slot->i);
+
+    // PTB quit extra mem priority for networking as soon as we are able to
+    current->flags &= ~PF_MEMALLOC;
+
+    PARANOIA_BEGIN;
+      if (lo->magic != ENBD_DEV_MAGIC) {
+	if (slot->nerrs++ < 3) {
+	    ENBD_ALERT ("enbd_dev[] corrupted: Not enough magic\n");
+        }
+	ENBD_DEBUG (1, "(%d): exited bad magic\n", slot->i);
+	result = -ENODEV;
+	ENBD_FAIL ("exited because of bad magic on device\n");
+	// PTB we will error requests queued for us. Can we do
+        // anything else? We're corrupt!
+      }
+    PARANOIA_END;
+
+    if (!(slot->flags & ENBD_SLOT_BUFFERED)) {
+	ENBD_DEBUG (1, "(%d): exited INVAL\n", slot->i);
+        // PTB we couldn't talk to the kernel so we must let userspace know
+	return -ENOMEM;
+    }
+    if (slot->buffer != buffer) {
+	if (slot->nerrs++ < 3)
+	    ENBD_ALERT ("(%d): user buffer changed\n", slot->i);
+        // PTB we couldn't talk to the kernel so we must let userspace know
+	return -EINVAL;
+    }
+
+    if (lo->acct) {
+            atomic_inc (&lo->acct->cthreads);
+    }
+    slot->flags |= ENBD_SLOT_RUNNING;
+    slot->cli_age = jiffies;
+
+    user = slot->buffer;
+    copy_from_user ((char *) &reply, (char *) user, sizeof (struct enbd_reply));
+
+    // PTB we keep tracking the write position in the input buffer
+    //buflen += sizeof (struct enbd_reply);
+    buflen += ENBD_BUFFER_DATA_OFFSET;
+
+    // PTB save the reply handle (which is an address) as our req
+    memcpy (&req, &reply.handle, sizeof (req));
+
+    if (reply.flags & ENBD_REPLY_IOCTL)
+      ENBD_DEBUG (1, "req ioctl handle %#lx\n", (unsigned long)req);
+
+      PARANOIA_BEGIN;
+      if (!req) {
+	if (slot->nerrs++ < 3)
+	    ENBD_ALERT ("(%d): null handle in reply from userspace\n",
+		       slot->i);
+	ENBD_ALERT ("exited malformed or invalid reply\n");
+        // PTB this req is nonsense so ignore and tell userspace
+	return -EINVAL;
+      }
+      PARANOIA_END;
+
+      do {
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+	struct request *pos;
+#else
+	struct list_head *pos;
+#endif
+	int count = 0;
+	xreq = NULL;
+	list_for_each (pos, &slot->queue) {
+	    xreq = list_entry (pos, struct request, queue);
+            if (reply.flags & ENBD_REPLY_IOCTL)
+	      ENBD_DEBUG (1, "req %d on slot %d queue is %x\n",
+		       count, slot->i, (unsigned) xreq);
+	    if (count++ > 1000)
+		break;
+	    if (xreq == req)
+		/* PTB found it */
+		break;
+	}
+      } while (0);
+
+      if (xreq != req) {
+	if (xreq  && slot->nerrs++ < 3) {
+	    ENBD_ALERT ("fatal: Bad handle (given) %p != %p (found)!\n",
+                     req, xreq);
+        }
+        if (lo->acct) {
+                atomic_dec (&lo->acct->cthreads);
+        }
+        slot->flags &= ~ENBD_SLOT_RUNNING;
+        ENBD_ALERT("ignoring ack of req %p which slot does not have\n", req);
+        // PTB we lie and say success because userspace got through to
+        // us OK and the req they missed has been rolled back and will
+        // be retransmitted by the kernel later and elsewhere
+        return 0;
+      }
+
+      if (rq_type(req) == IOCTL) {
+                ENBD_DEBUG (1, "(%d): ok, got IOCTL handle %p\n", slot->i, req);
+      }
+
+      if (reply.magic != ENBD_REPLY_MAGIC) {
+        // PTB we got a matching request, but it's corrupted. Best
+        // throw the reply away and leave our request to age.
+	if (slot->nerrs++ < 3) {
+	        ENBD_ALERT ("Not enough reply magic in %s\n", __FUNCTION__);
+        }
+        // PTB returning -EAGAIN causes the client to pause 0.5s 
+        // and throw its reply away, then return to service. We leave
+        // any request we have to age and be rolled back.
+	return -EAGAIN;
+      }
+
+      if (reply.error > 0) {
+	    /* PTB wasn't error++'ed before */
+	    if (slot->nerrs++ < 3) {
+	            ENBD_ALERT ("exited with reply error\n");
+            }
+	    /* PTB we handle this - it's a remote error */
+            ENBD_FAIL ("remote error on request\n");
+      }
+
+      if (req->errors > 0) {
+	/* PTB wasn't error++'ed before */
+	if (slot->nerrs++ < 3) {
+	    ENBD_ALERT ("exited with req error\n");
+        }
+	/* PTB we handle this - it's a remote error */
+        ENBD_FAIL ("remote error on request\n");
+      }
+
+
+      req_blks = nr_blks (req);
+
+    // PTB this ifdef is not right. It kills clustering in 2.2  FIXME
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+    reqlen = req->current_nr_sectors;
+    reqlen <<= 9;
+#else
+    reqlen = req->nr_sectors;
+    reqlen <<= 9;
+#endif
+
+    PARANOIA_BEGIN;
+    if (rq_type(req) != IOCTL && req->nr_sectors > lo->max_sectors) {
+	if (slot->nerrs++ < 3) {
+	    ENBD_ALERT
+	     ("req %p nr_sectors %ld bigger than buf %d, cutting it!\n",
+	      	req, req->nr_sectors, lo->max_sectors);
+        }
+	reqlen = lo->max_sectors;
+	reqlen <<= 9;
+    }
+    PARANOIA_END;
+
+    switch (rq_type(req)) {
+	int size;
+
+      case READ:
+	ENBD_DEBUG (3, "read %d bytes data from %x to %x\n",
+		   reqlen,
+		   (unsigned) (((char *) user) + sizeof (struct enbd_reply)),
+		   (unsigned) req->buffer);
+
+	// PTB We have to copy the buffer bit by bit in
+	// case the request is clustered.
+
+	size = copy_from_user_to_req (req, ((char *) user) + buflen, reqlen);
+        if (size < reqlen) {
+	    ENBD_ALERT ("(%d): copy %dB from user to req %p failed (%d)\n",
+                    slot->i, reqlen, req, size);
+            // PTB we could try again? We should investigate.
+	    ENBD_FAIL ("exited because of bad copy from user\n");
+            // PTB what should we do about our request? We could
+            // leave it in kernel, but I guess we should error it
+            // because we have internal problems here, and that is what
+            // we do.
+        }
+
+	// PTB we keep tracking the write position in the buffer
+	buflen += size;
+
+#if DEBUG > 0
+	if (lo->blockmap) {
+
+	    unsigned long i, imax = reqlen >> lo->logblksize;
+	    unsigned long blknr = req->sector >> (lo->logblksize - 9);
+
+	    for (i = 0; i < imax; i++) {
+		int block = blknr + i;
+		int offset = block >> 2;
+		int shift = (block & 3) << 1;
+		switch ((lo->blockmap[offset] >> shift) & 3) {
+		  case READ:	// PTB 0 = READ -> READ|2
+		    lo->blockmap[offset] |= 2 << shift;
+		    break;
+		  case READ | 2:
+		    break;
+		  case WRITE:
+		  default:	// PTB 3 = empty -> READ = 0
+		    lo->blockmap[offset] &= ~(3 << shift);
+		    break;
+		}
+	    }
+	}
+#endif
+	break;
+      case WRITE:
+	// PTB we want to know if the reply is md5summed, and if it is
+	//     whether the md5sum is the same as the one on the
+	//     request. But that's not something we can presently see
+	//     from here as we don't make an md5sum in the kernel.
+	//     So we have to rely on the reply flag from userspace.
+	//     We transmit the information to the slot, as we can't
+	//     keep it on the request.
+
+	switch (reply.flags & (ENBD_REPLY_MD5SUM | ENBD_REPLY_MD5_OK)) {
+
+	  case ENBD_REPLY_MD5SUM | ENBD_REPLY_MD5_OK:
+	    ENBD_DEBUG (3, "got md5 OK indication in reply.\n");
+	    // PTB we asked for an md5sum comparison
+	    // PTB the two matched, so we skipped writing the request
+	    slot->flags |= (ENBD_SLOT_MD5SUM | ENBD_SLOT_MD5_OK);	// 11
+	    break;
+
+	  case ENBD_REPLY_MD5SUM:
+	    // PTB the two differed, so we wrote the request
+	    ENBD_DEBUG (3, "got md5 fail indication in reply.\n");
+	    slot->flags |= ENBD_SLOT_MD5SUM;
+	    slot->flags &= ~ENBD_SLOT_MD5_OK;	// 10
+	    break;
+
+	  case ENBD_REPLY_MD5_OK:
+	    ENBD_DEBUG (3, "got md5 refusal indication in reply.\n");
+	    // PTB the server refused the md5 request
+	    slot->flags &= ~ENBD_SLOT_MD5SUM;
+	    slot->flags |= ENBD_SLOT_MD5_OK;	// 01
+	    break;
+
+	  default:
+	  case 0:
+	    ENBD_DEBUG (3, "got no md5 indication in reply.\n");
+	    // PTB nobody asked for an md5sum comparison
+	    slot->flags &= ~(ENBD_SLOT_MD5SUM | ENBD_SLOT_MD5_OK);	// 00
+	    break;
+	}
+	// PTB now we're all set up to do the accounting in commit etc.
+
+#if DEBUG > 0
+	if (lo->blockmap) {
+
+	    unsigned long i;
+	    unsigned long blknr = req->sector >> (lo->logblksize - 9);
+
+	    for (i = 0; i < req_blks; i++) {
+		int block = blknr + i;
+		int offset = block >> 2;
+		int shift = (block & 3) << 1;
+		lo->blockmap[offset] &= ~(3 << shift);
+		lo->blockmap[offset] |= WRITE << shift;
+	    }
+	}
+#endif
+	break;
+
+      case IOCTL:
+        ENBD_DEBUG(1, "ioctl reply to req %p\n", req);
+
+        if (! (reply.flags & ENBD_REPLY_IOCTL))
+            ENBD_ALERT("ioctl reply to req %p has no ioctl flag set\n", req);
+        // PTB the commit should emit the request notification
+        if (1) {
+
+            // PTB the req passes in the cmd code in the special field
+            struct enbd_ioctl_info * ioctl_info =
+                (struct enbd_ioctl_info *)req->ENBD_BLKREQ_SPECIAL;
+            unsigned long cmd =
+                (unsigned long)(ioctl_info ? ioctl_info->cmd : 0);
+            char *   arg = req->buffer; // PTB saved local address or direct val
+
+            if (cmd == -1l) {
+                result = -EINVAL;
+                ENBD_FAIL("unauthorized remote ioctl\n");
+            }
+
+           if (_IOC_DIR(cmd) & _IOC_READ) {
+                // PTB it would have been nice to save size in req and
+                // in fact we did .. but only approximately, as nr_sectors.
+                // size_t  size = enbd_ioctl_size(cmd, arg);
+                int sectors = req->nr_sectors;
+                // PTB if we are reading, it should be to the local buffer
+                // PTB arg, which points at lo->ctldata or other buffer
+                if (sectors <= 0) {
+                        ENBD_DEBUG(1, "copying %d bytes (%p..) from IOCTL %#x "
+                                  "to buf %p\n",
+                                  0,
+                                  NULL,
+                                  cmd & 0xffff,
+                                  (void *)arg);
+                } else {
+                        // PTB sectors is an overestimate. SHould be OK
+                        // PTB as we are reading from the client buffer
+                        // PTB which has plenty of room to spare
+                        int size = sectors << 9;
+                        copy_from_user(arg, (char *) user + buflen, size);
+                        ENBD_DEBUG(1, "copied %d bytes (%p..) from IOCTL %#x "
+                                  "to buf %p\n",
+                                  size,
+                                  *(void **)arg,
+                                  cmd & 0xffff,
+                                  (void *)arg);
+                        buflen += size;
+                }
+            }
+        }
+        break;
+    }				// PTB eswitch
+    goto success;
+
+  success:
+    slot->nerrs = 0;
+    // PTB - completion of transaction 
+    // enbd_commit will take the io lock to do end_req
+    enbd_commit (slot, req);
+    
+    if (lo->acct) {
+            atomic_dec (&lo->acct->cthreads);
+    }
+    slot->flags &= ~ENBD_SLOT_RUNNING;
+    if (reply.flags & ENBD_REPLY_IOCTL) {
+      ENBD_DEBUG (1, "(%d): exited OK\n", slot->i);
+    }
+    return 0;
+
+  error_out:
+    // PTB we will next do a client rollback on the slot from userspace.
+    //     Right here we just skip the request. 
+    // PTB NOooo .. don't error the request. We might have rolled it
+    // back and be referencing it.
+    if (result != -EAGAIN && result != 0) {
+        req->errors += req_blks;
+        slot->err += req_blks;
+    }
+    result = result < 0 ? result : -ENODEV;
+    if (lo->acct) {
+           atomic_dec (&lo->acct->cthreads);
+    }
+    slot->flags &= ~ENBD_SLOT_RUNNING;
+    if (reply.flags & ENBD_REPLY_IOCTL) {
+           ENBD_DEBUG (1, "(%d): exited FAIL %d\n", slot->i, result);
+    }
+    return result;
+}
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+/*
+ * PTB - apply repeatedly to tail of queue to try and merge successive requests
+ *     - returns 1 for success and 0 for fail
+ */
+static inline int
+attempt_merge (struct enbd_device *lo, struct request *req)
+{
+    struct request *next = 0;
+
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
+    return 0;
+#endif
+
+    if (!req) {
+	ENBD_DEBUG (2, "no request\n");
+	return 0;
+    }
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+    next = list_head (&req->queue, struct request, queue);
+#else
+    next = list_head (req, struct request, queue);
+#endif
+    if (!next) {
+	ENBD_DEBUG (2, "no next request\n");
+	return 0;
+    }
+    if (req->sector + req->nr_sectors != next->sector) {
+	ENBD_DEBUG (2, "sectors not adjacent\n");
+	return 0;
+    }
+    if (rq_data_dir(req) != rq_data_dir(next)) {
+	ENBD_DEBUG (2, "request types differ\n");
+	return 0;
+    }
+    if (req->rq_dev != next->rq_dev) {
+	ENBD_DEBUG (2, "request devices differ\n");
+	return 0;
+    }
+    PARANOIA_BEGIN;
+    if (req->nr_sectors + next->nr_sectors >= lo->max_sectors) {
+	ENBD_DEBUG (2, "buffer would be too big\n");
+	return 0;
+    }
+    PARANOIA_END;
+#if 0
+     lo = enbd_dev[MINOR (req->rq_dev) >> ENBD_SHIFT];	/* PTB do this instead? */
+#endif
+#if 0
+    ENBD_DEBUG (1, "merge %ld, %ld + %ld == %ld\n",
+	       req->sector, req->nr_sectors, next->nr_sectors,
+	       req->nr_sectors + next->nr_sectors);
+#endif
+    if (atomic_read(&lo->merge_requests)) {
+	unsigned long flags;
+	int cmd;
+	ENBD_DEBUG (1, "will merge request\n");
+	req->bhtail->b_reqnext = next->bh;
+	req->bhtail = next->bhtail;
+	req->nr_sectors += next->nr_sectors;
+	next->rq_status = RQ_INACTIVE;
+	// PTB don't want anybody mucking with the request quete
+	// but classically this was never held so I'll try doing without it
+	write_lock_irqsave (&lo->queue_lock, flags);
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+        list_del (&next->queue);
+#else
+        enbd_list_del (next);
+#endif
+        cmd = rq_data_dir(req);
+        if (lo->acct) {
+	        atomic_dec (&lo->acct->countq[cmd]);	/* PTB accounting */
+        }
+	write_unlock_irqrestore (&lo->queue_lock, flags);
+	// PTB don't want anybody mucking with the request quete
+	// but classically this was never held so I'll try doing without it
+	return 1;
+    }
+    else {
+	ENBD_DEBUG (1, "would merge request\n");
+	return 0;
+    }
+}
+#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30) */
+
+/*
+ * PTB - write to userspace from a request buffer. Do it piecewuse
+ *     - to cope with clustered requests.
+ *     - return number of bytes written
+ */
+static int
+copy_to_user_from_req (struct request *req, char *user, int len)
+{
+
+    unsigned size = 0;
+    struct buffer_head *bh = req->bh;
+
+    /* PTB assume user verified */
+
+    while (size < len) {
+
+	unsigned current_size;
+	char *buffer;
+
+        if (!bh)  {
+                // PTB we seem to trigger here.
+	ENBD_ALERT ("req %p wanted to offer %d, could only give %d bytes\n",
+		   req, len, size);
+	ENBD_ALERT ("request %p has first bh %p size %ld\n",
+		   req, req->bh,
+                   (long)(req->bh?req->bh->b_size:0));
+	ENBD_ALERT ("request %p wanted to write to user space buffer %p\n",
+		   req, user);
+	ENBD_ALERT ("request %p is aimed at sector %d\n",
+		   req, (unsigned)req->sector);
+	ENBD_ALERT ("request %p has %d segments,\n",
+		   req, (unsigned)req->nr_segments);
+	ENBD_ALERT ("request %p has major %d minor %d\n",
+		   req, MAJOR(req->rq_dev), MINOR(req->rq_dev));
+	ENBD_ALERT ("request %p has %d sectors, first set of %d,\n",
+		   req, (unsigned)req->nr_sectors,
+                   (unsigned)req->current_nr_sectors);
+             // PTB make repairs
+	ENBD_ALERT ("request %p is being patched up. Kernel lost %ld sectors\n",
+		   req, req->nr_sectors - (size >> 9));
+            req->nr_sectors = size >> 9;
+            if (bh == req->bh) {
+                req->current_nr_sectors = req->nr_sectors;
+            }
+            break;
+        }
+
+	current_size = bh->b_size;
+	buffer = bh->b_data;
+
+	ENBD_DEBUG (3, "write %d to user at %0x\n",
+		   current_size, (unsigned) (user + size));
+
+	copy_to_user (user + size, buffer, current_size);
+
+	size += current_size;
+
+	bh = bh->b_reqnext;
+    }
+    return size;
+}
+
+static void
+enbd_speed (struct enbd_speed *spd, int distance)
+{
+
+    // last time we measured
+    int lastjiffy = atomic_read (&spd->jiffy);
+    int firstjiffy = atomic_read (&spd->frstj);
+    // jiffies since last time
+    int djiffy = jiffies - lastjiffy;
+    int tjiffy = jiffies - firstjiffy;
+
+    // previous no we measured
+    int lastdist = atomic_read (&spd->distance);
+    // blocks since last time
+    int ddistance = distance - lastdist;
+
+    // write every second in time
+    if (djiffy > HZ) {
+
+	// max tot speed measured so far
+	int speedmax = atomic_read (&spd->speedmax);
+
+	// last instantaneous speed we measured
+	int lastspeed = atomic_read (&spd->speed);
+
+	// instantaneous read blocks/s
+	int speed = djiffy ? (ddistance * HZ) / djiffy : 0;
+
+	// smoothed KB/s
+	int speedsmoothed = (djiffy * speed + HZ * lastspeed) / (djiffy + HZ);
+
+	// average speed to now in KB/s
+	int speedav = tjiffy ? (distance * HZ) / tjiffy : 0;
+
+	// smoothing count for max
+	int speedhi = (speedav > speedsmoothed) ? speedav : speedsmoothed;
+
+	// doing settings
+	atomic_set (&spd->speed, speedsmoothed);
+	if (speedhi > speedmax)
+	    atomic_set (&spd->speedmax, speedhi);
+	atomic_set (&spd->distance, distance);
+	atomic_set (&spd->speedav, speedav);
+	atomic_set (&spd->jiffy, jiffies);
+    }
+}
+
+void
+enbd_snapshot_speed (struct enbd_device *lo)
+{
+     int r, w, t;
+     struct enbd_acct * acct = lo->acct;
+     if (!acct)
+            return;
+     w = atomic_read (&acct->requests_in[WRITE]);
+     enbd_speed (&lo->wspeed, w);
+     r = atomic_read (&acct->requests_in[READ]);
+     enbd_speed (&lo->rspeed, r);
+     t = w + r;
+     enbd_speed (&lo->tspeed, t);
+}
+
+/*
+ * place a request on a slot queue in order that it be taken away and
+ * treated by infidels. Basically, we do the translation to the
+ * enbd_request struct here.
+ */
+static int
+enbd_slot_send (struct enbd_slot *slot, struct request *req)
+{
+        struct enbd_request request;
+        int result = 0;
+        struct enbd_device *lo = slot->lo;
+        struct timeval time;
+        // PTB for the new timezone field in requests 
+        extern struct timezone sys_tz;
+
+	request.magic = ENBD_REQUEST_MAGIC;
+	request.flags = 0;
+
+	switch (rq_type (req)) {
+
+		struct enbd_ioctl_info *ioctl_info;
+		unsigned long cmd;
+		char *arg;
+		size_t size;
+
+	  case IOCTL:
+
+		ENBD_DEBUG (1, "forming enbd_request IOCTL\n");
+
+		request.type = IOCTL;
+
+		/*
+		 * PTB this is our special ioctl kernel request that we
+		 * placed on the queue ourself and we are picking it up now.
+		 */
+
+		ioctl_info =
+		 (struct enbd_ioctl_info *) req->ENBD_BLKREQ_SPECIAL;
+		cmd = (unsigned long) (ioctl_info ? ioctl_info->cmd : 0);
+		arg = req->buffer;
+		size = req->nr_sectors << 9;
+
+		// PTB the arg was (either a literal or) the lo->ctldta buffer
+
+		request.len = 0;
+		if ((_IOC_DIR (cmd) & _IOC_READ) && size > 0) {
+			// PTB we're in get_req, transferring stored ioctl
+			ENBD_DEBUG (1, "ioctl req has size %d\n", size);
+			// PTB we copy to the user buffer later
+			request.len = size;
+		}
+		// PTB we store the weirded ioctl id
+		// PTB this composition is our private invention
+		request.from = (((__u64) cmd) << 32)
+		 // PTB really want this to go to a 64 bit request.special
+		 | ((__u64) (unsigned long) arg);
+		/*
+		 * PTB note that we recorded the "original" buffer,
+		 * which is the lo->ctldata stuff, so we can put it
+		 * back there later
+		 */
+		break;
+
+	  case READ:
+	  case WRITE:
+
+		ENBD_DEBUG (2, "copying %s req %p for user\n",
+			   rq_type (req) == READ ? "r" : "w", req);
+		request.type = rq_data_dir (req);
+		request.from = req->sector
+		 + enbd_hd_struct[MINOR (req->rq_dev)].start_sect;
+
+		request.from <<= 9;
+		request.len = req->nr_sectors;
+		request.len <<= 9;
+		if (atomic_read (&lo->flags) & ENBD_MD5SUM) {
+			// PTB set the please do md5sum flag on the request until we
+			// learn to do it ourselves in-kernel during the memcopy below.
+			request.flags |= ENBD_REQUEST_MD5SUM;
+			ENBD_DEBUG (3, "get_req wants md5sum on wreq %p\n",
+				   req);
+		}
+		break;
+
+	  default:
+		ENBD_ALERT ("received unknown req %p type %#x\n", req,
+			   rq_type (req));
+		break;
+	}
+
+	request.seqno = rq_seqno (req);
+
+	/*
+	 * PTB we need to erase the extra seqno info so that on error or on ack
+	 * the kernel can use the right internal array, but I'll catch this in
+	 * the ack function instead
+	 */
+
+	ENBD_DEBUG (2,
+		   "(%d): filling timeval on request %p position %p in queue\n",
+		   islot, req, list_tail (&lo->queue,
+					  struct request, queue));
+
+	do_gettimeofday (&time);
+	request.time = time.tv_sec;
+	request.time *= 1000000;
+	request.time += time.tv_usec;
+	request.zone = sys_tz.tz_minuteswest;
+
+	// PTB tz_dsttime = 0 always in linux
+
+	memcpy (&request.handle, &req, sizeof (request.handle));
+
+	ENBD_DEBUG (2, "(%d):"
+		   "magic=0x%x type=%#x from=0x%Lx len=%u handle=%p tv=%ld tz=%d"
+		   "\n",
+		   islot,
+		   (unsigned) request.magic,
+		   (unsigned) request.type,
+		   request.from,
+		   (unsigned) request.len,
+		   request.handle, request.time, request.zone);
+
+	PARANOIA_BEGIN;
+	// PTB do not assume buffer OK, although verified by REG_BUF
+	//     I half believe that we could write to a dead processes
+	//     buffer?
+	if (!access_ok
+	    (VERIFY_WRITE, slot->buffer, sizeof (struct enbd_request))) {
+		result = -EINVAL;
+		ENBD_DEBUG (3, "(%d): exited with %d\n", islot, result);
+		ENBD_FAIL ("invalid user buffer\n");
+		// PTB we do a nontrivial rollback from the user daemon, if alive 
+	}
+	ENBD_DEBUG (3, "(%d): verified user buf %p\n", islot, slot->buffer);
+	PARANOIA_END;
+
+	ENBD_DEBUG (3, "(%d): will copy_to_user req %p\n", islot, req);
+	copy_to_user (slot->buffer, (char *) &request, sizeof (request));
+
+	// PTB the type is always 2bit since it's been created by a mask
+	switch (request.type) {
+		int err;
+	  case READ:
+		break;
+
+	  case IOCTL:
+		if (request.len > 0) {
+			char *arg =
+			 (char *) slot->buffer + ENBD_BUFFER_DATA_OFFSET;
+			copy_to_user (arg, req->buffer, request.len);
+		}
+		break;
+
+	  case WRITE:
+		PARANOIA_BEGIN;
+		if (req->nr_sectors << 9 != request.len) {
+			ENBD_ALERT
+			 ("request and buffer lens %ld and %d differ\n",
+			  req->nr_sectors << 9, request.len);
+		}
+		PARANOIA_END;
+		ENBD_DEBUG (3, "(%d): will copy_to_user data from req %p\n",
+			   islot, req);
+		err =
+		 copy_to_user_from_req (req,
+					(char *) slot->buffer +
+					ENBD_BUFFER_DATA_OFFSET,
+					request.len);
+		if (err >= request.len)
+			break;	// PTB all OK
+		// PTB buffer had missing BHS's
+		ENBD_ERROR
+		 ("req %p only offered %d bytes of %d for copy to user\n",
+		  req, result, request.len);
+		// PTB this request is badly damaged. We'd better shoot it.
+		if (req && req->errors == 0) {
+			req->errors++;
+			enbd_end_request_lock (req);
+		}
+		ENBD_FAIL
+		 ("kernel failed to keep req while we copied from it\n");
+		break;
+	}
+
+	/*
+	 * PTB enbd_accept does not take spinlock and does not need to as
+	 * the req is already free of the shared queue and only needs
+	 * to be placed on the unique slot queue.
+	 */
+
+	ENBD_DEBUG (3, "(%d): placed req %p on slot queue\n", islot, req);
+	enbd_accept (slot, req);
+        return 0;
+
+  error_out:
+    result = result < 0 ? result : -ENODEV;
+
+    ENBD_DEBUG (1, "(%d): error exit %d\n", islot, result);
+    return result;
+}
+
+/*
+ * PTB - andres' kernel half of the userspace networking. This part
+ *     - initiates the transaction by taking a request off the generic
+ *     - device queue and placing it in the slots pending position.
+ *     - I believe we return 0 for success and -ve for fail.
+ *     - timeo is the number of jiffies we are prepared to wait
+ */
+int
+enbd_get_req (struct enbd_slot *slot, char *buffer)
+{
+    struct request *req;
+    int result = 0;
+    static atomic_t count;
+    unsigned start_time = jiffies;
+    struct enbd_device *lo = slot->lo;
+    unsigned timeout = lo->req_timeo * HZ;
+    int islot = slot->i;
+    unsigned long flags;
+
+    ENBD_DEBUG (1, "(%d): entered by pid %d\n", islot, current->pid);
+
+    if (lo->acct) {
+            atomic_inc (&lo->acct->cthreads);	// PTB - client thread enters
+    }
+    slot->flags |= ENBD_SLOT_RUNNING;
+    slot->cli_age = jiffies;
+
+    if (!(slot->flags & ENBD_SLOT_BUFFERED)) {
+	ENBD_FAIL ("Our slot has no buffer\n");
+    }
+    if (slot->buffer != buffer) {
+	ENBD_FAIL ("Our slot has changed its buffer!\n");
+    }
+
+    atomic_set (&lo->islot, islot);
+
+    if (!list_empty (&slot->queue)) {
+	ENBD_FAIL ("impossible! already treating one request\n");
+	// PTB we do a nontrivial rollback from the user daemon 
+    }
+    if (!slot->file) {
+	result = -EBADF;
+	ENBD_FAIL ("Our slot has been nofiled\n");
+    }
+    if (!(atomic_read (&lo->flags) & ENBD_ENABLED)) {
+	result = -ENODEV;
+	ENBD_FAIL ("Our slot has been vamooshed\n");
+    }
+
+wait_for_reqs:
+    // PTB take spinlock in order to examine queue
+    if (lo->acct) {
+            atomic_inc (&lo->acct->cwaiters);
+    }
+    slot->flags |= ENBD_SLOT_WAITING;
+
+    // we need to protect ourselves against the request fn too
+    read_lock_irqsave (&lo->queue_lock, flags);
+    if (lo->acct) {
+            atomic_dec (&lo->acct->cwaiters);
+    }
+    slot->flags &= ~ENBD_SLOT_WAITING;
+
+    // PTB - now spin until request arrives to treat 
+    while (slot->file && list_empty (&lo->queue)) {
+
+	int siz;
+        int time_left = start_time + timeout - jiffies;
+
+	read_unlock_irqrestore (&lo->queue_lock, flags);
+
+	ENBD_DEBUG (3, "(%d): going to sleep %d\n", islot,
+		   atomic_read (&count));
+        if (lo->acct) {
+	        atomic_inc (&lo->acct->cwaiters);
+        }
+	slot->flags |= ENBD_SLOT_WAITING;
+
+	interruptible_sleep_on_timeout (&lo->wq, time_left);
+	ENBD_DEBUG (3, "(%d): I wake up %d\n", islot, atomic_read (&count));
+
+	slot->flags &= ~ENBD_SLOT_WAITING;
+        if (lo->acct) {
+	        atomic_dec (&lo->acct->cwaiters);
+        }
+	atomic_inc (&count);
+
+	// PTB Have to take the spinlock again to check the queue
+        if (lo->acct) {
+	        atomic_inc (&lo->acct->cwaiters);
+        }
+	slot->flags |= ENBD_SLOT_WAITING;
+	// we need to protect ourselves against the request fn too
+	read_lock_irqsave (&lo->queue_lock, flags);
+        if (lo->acct) {
+	        atomic_dec (&lo->acct->cwaiters);
+        }
+	slot->flags &= ~ENBD_SLOT_WAITING;
+
+	// PTB fail for recheck if we're inactive too long 
+
+	if (jiffies < start_time + timeout
+                || !list_empty (&lo->queue))
+                continue;
+
+        // PTB bad. timeout with nothing on queue. Error out.
+	ENBD_DEBUG (3, "(%d): I timeout in the %dth cycle %ld jiffies late\n",
+		       islot, atomic_read (&count), - time_left);
+	result = -ETIME;
+
+	// PTB we will exit with one code or another, so up spinlock
+	read_unlock_irqrestore (&lo->queue_lock, flags);
+
+	ENBD_DEBUG (3, "ho hum nothing to do again, timeout -ETIME\n");
+
+	siz = lo->blksize + sizeof (struct enbd_request);
+	// PTB verify the buffer is still OK - holds one block 
+	if (!access_ok (VERIFY_WRITE, slot->buffer, siz)) {
+		static int enbd_clr_sock (struct enbd_slot *slot);
+		result = -EINVAL;
+
+		// PTB clr_sock takes both the io lock and the spinlock
+		enbd_clr_sock (slot);	// PTB TEST
+		ENBD_FAIL ("Our process has died or lost its buffer\n");
+	}
+
+	/*
+         * PTB we may do a rollback from the user daemon here
+	 * but it'll be trivial - without effect - as we don't
+	 * have a request in our slot to treat.
+         */
+	goto error_out;
+    }
+
+    // PTB we still have the (read) spinlock here
+
+    if (!(atomic_read (&lo->flags) & ENBD_ENABLED)) {
+	read_unlock_irqrestore (&lo->queue_lock, flags);
+	result = -ENODEV;
+	ENBD_FAIL ("Our slot vaporized while we slept!\n");
+    }
+    if (!slot->file) {
+	read_unlock_irqrestore (&lo->queue_lock, flags);
+	result = -EBADF;
+	ENBD_FAIL ("Our slot nofiled itself while we slept!\n");
+    }
+
+    if (!list_empty (&slot->queue)) {
+	read_unlock_irqrestore (&lo->queue_lock, flags);
+	result = -EINVAL;
+	ENBD_FAIL ("impossible! already treating one request\n");
+	// PTB we do a nontrivial rollback from the user daemon 
+    }
+
+    // PTB now let's relinquish the read lock and try for the write lock
+    read_unlock_irqrestore (&lo->queue_lock, flags);
+
+    write_lock_irqsave (&lo->queue_lock, flags);
+    // PTB got the write lock
+
+    if (list_empty (&lo->queue)) {
+	write_unlock_irqrestore (&lo->queue_lock, flags);
+	// PTB - somebody else did it while we waited on spinlock. OK 
+	result = -EINVAL;
+	ENBD_FAIL ("ho hum beaten to the punch\n");
+	// PTB we may do a trivial rollback from the user daemon 
+    }
+
+    // PTB cli/sti here looks unnec. hardware interrupts return here 
+    // AMARIN begin uninterruptible code 
+
+    // PTB we have the (write) spinlock and we have a req on queue
+
+    if (check_partitions && !(atomic_read(&lo->flags) & ENBD_VALIDATED)) {
+
+        // PTB not validated, so only accept sector zero
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+        struct request *pos;
+#else
+	struct list_head *pos;
+#endif
+        req = NULL;
+	list_for_each (pos, &lo->queue) {
+	        req = list_entry (pos, struct request, queue);
+                if (req->sector == 0)
+                        break;
+        }
+        if (req && req->sector == 0) {
+	        ENBD_ALERT ("validation req for sector 0 seen OK!\n");
+                goto check_req;
+        }
+
+	if (jiffies + HZ / 2 < start_time + timeout) {
+                // PTB didn't find request for sector 0 so block
+                write_unlock_irqrestore (&lo->queue_lock, flags);
+	        ENBD_ALERT ("blocking req on sector %lu while waiting for sector 0!\n",
+                req->sector);
+                 __set_current_state(TASK_UNINTERRUPTIBLE);
+                schedule_timeout (HZ / 2);
+                goto wait_for_reqs;
+        }
+
+	ENBD_ALERT ("gave up waiting for validation req!\n");
+        // PTB maybe drop through to oldest req check
+        goto check_req;
+
+    }
+
+    // PTB oldest=last element in queue 
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+    req = list_tail (&lo->queue, struct request, queue);
+#else
+    req = enbd_list_tail (&lo->queue);
+#endif
+
+
+check_req:
+
+    PARANOIA_BEGIN;
+    if (!req) {
+	write_unlock_irqrestore (&lo->queue_lock, flags);
+	result = -EINVAL;
+	ENBD_FAIL ("tail request is zero although queue reported nonempty!\n");
+    }
+    PARANOIA_END;
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+     if (atomic_read(&lo->merge_requests)) {
+	// PTB coalesce queue requests 
+	unsigned long size = req->nr_sectors << 9;
+	ENBD_ERROR ("(%d): req=0x%lx has size %lu\n",
+		   islot, (unsigned long) req, size);
+
+	while (attempt_merge (lo, req) > 0) ;
+	size = req->nr_sectors << 9;
+	ENBD_DEBUG (1, "(%d): req=0x%lx has size %lu\n",
+		   islot, (unsigned long) req, size);
+    }
+#endif
+
+    // PTB this is where we free the req from our queue. We need to be
+    // holding our spinlock at this point
+
+    // PTB - must succeed as have the spinlock 
+    result = enbd_remove (lo, req);
+
+    ENBD_DEBUG (2, "(%d):"
+	       " despatching request 0x%lx position 0x%lx in queue\n",
+	       islot, (unsigned long) req,
+	       (unsigned long) list_tail (&lo->queue, struct request, queue));
+
+    // AMARIN end uninterruptable code 
+    // PTB uh - maybe cli/sti is needed? interrupts can muck the queue?
+    //        - Nah! I've left them enabled so we can see any errors.
+
+    write_unlock_irqrestore (&lo->queue_lock, flags);
+
+    result = enbd_slot_send(slot, req);
+    if (result < 0) {
+	    ENBD_FAIL ("Could not send request to user space!\n");
+    }
+
+    // PTB make sure that networking will be able to get memory
+    if (~(current->flags & PF_MEMALLOC)) {
+            current->flags |= PF_MEMALLOC;
+            //slot->flags |=  ENBD_SLOT_SET_MEMALLOC;
+    }
+    
+ 
+    if (lo->acct) {
+            // PTB - client thread leaves normally 
+            atomic_dec (&lo->acct->cthreads);
+    }
+    slot->flags &= ~ENBD_SLOT_RUNNING;
+    ENBD_DEBUG (1, "exiting\n");
+
+    return 0;
+
+  error_out:
+    // PTB accounting - a fail to get a request is not an errored request 
+    if (lo->acct) {
+            // PTB - client thread leaves abnormally 
+            atomic_dec (&lo->acct->cthreads);
+    }
+    slot->flags &= ~ENBD_SLOT_RUNNING;
+    result = result < 0 ? result : -ENODEV;
+
+    ENBD_DEBUG (1, "(%d): error exit %d\n", islot, result);
+    return result;
+}
+
+/*
+ * PTB error out the pending requests on the kernel queue
+ * We have to be called WITHOUT the io request lock held.
+ * We sleep imbetween clearing each request, for "safety".
+ */
+static int
+enbd_clr_kernel_queue (void)
+{
+
+    int count = 0;
+    unsigned long flags;
+
+    ENBD_DEBUG (1, "entered\n");
+    spin_lock_irqsave (&io_request_lock, flags);
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+    while (CURRENT != NULL && count++ < 1000) {
+#else
+    while (! QUEUE_EMPTY && count++ < 1000) {
+#endif
+	struct request *req;
+	req = CURRENT;
+	if (!req) {		// PTB impossible
+	    spin_unlock_irqrestore (&io_request_lock, flags);
+	    ENBD_ALERT
+	     ("impossible! kernel queue empty after tested nonemty!\n");
+	    goto fail;
+	}
+	blkdev_dequeue_request (req);
+	spin_unlock_irqrestore (&io_request_lock, flags);
+	req->errors++;
+	//schedule ();
+        schedule_timeout(1);
+        enbd_end_request_lock (req);
+	spin_lock_irqsave (&io_request_lock, flags);
+    }
+    spin_unlock_irqrestore (&io_request_lock, flags);
+    goto success;
+
+  fail:
+    /* PTB fall thru */
+  success:
+    ENBD_ALERT ("removed %d requests\n", count);
+    ENBD_DEBUG (1, "exited\n");
+    return count;
+
+}
+
+/*
+ * PTB error out the pending requests on the nbd queue and kernel queue
+ * Note that we take the queue spinlock for this
+ */
+int
+enbd_clr_queue (struct enbd_device *lo)
+{
+	int count = 0;
+	unsigned long flags;
+
+	ENBD_DEBUG (1, "entered\n");
+
+	while (count < 1000) {
+
+		struct request *req;
+		int invalid = 0;
+		unsigned long req_blks = 1;
+
+		write_lock_irqsave (&lo->queue_lock, flags);
+		if (list_empty (&lo->queue)) {
+			ENBD_DEBUG (1, "exited req=0\n");
+			write_unlock_irqrestore (&lo->queue_lock, flags);
+			break;
+		}
+		req = list_head (&lo->queue, struct request, queue);
+
+		req_blks = nr_blks (req);
+
+		PARANOIA_BEGIN;
+		if (lo != enbd_dev[MINOR (req->rq_dev) >> ENBD_SHIFT]) {
+			ENBD_ALERT ("request corrupted when clearing!\n");
+			invalid = 1;
+		}
+		if (lo->magic != ENBD_DEV_MAGIC) {
+			ENBD_ERROR ("Not enough magic when clearing!\n");
+			write_unlock_irqrestore (&lo->queue_lock, flags);
+			break;
+		}
+		PARANOIA_END;
+		req->errors += req_blks + 1;
+		if (lo->acct) {
+			atomic_add (req_blks, &lo->acct->requests_err);
+		}
+
+		/* PTB - must succeed as have the spinlock */
+		enbd_remove (lo, req);
+		write_unlock_irqrestore (&lo->queue_lock, flags);
+		count++;
+	        ENBD_DEBUG (2, "released kernel queue lock\n");
+
+		if (!invalid) {
+			// PTB enbd_end_req_lock needs to be called without the io spinlock
+			enbd_end_request_lock (req);
+		}
+	}
+
+
+	ENBD_ALERT ("unqueued %d reqs\n", count);
+	ENBD_DEBUG (3, "exited\n");
+	return count;
+}
+#undef ENBD_FAIL
+#define ENBD_FAIL( s... ) { \
+  ENBD_DEBUG(1, s ); \
+  ENBD_ERROR( s ); \
+  goto error_out; \
+}
+
+static int
+ (*buffered_write) (struct enbd_device *, struct request * req);
+int
+enbd_register_bufferwr(int (*f)(struct enbd_device *,struct request *)) {
+    // PTB race
+    if (buffered_write == NULL) {
+            buffered_write = f;
+            return 0;
+    }
+    return -EINVAL;
+}
+int
+enbd_unregister_bufferwr(int (*f)(struct enbd_device *,struct request *)) {
+    // PTB race
+    if (buffered_write == f) {
+            buffered_write = NULL;
+            return 0;
+    }
+    return -EINVAL;
+}
+
+static void
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+do_nbd_request (void)
+#else
+do_nbd_request (request_queue_t * q)
+#endif
+{
+    struct request *req;
+    int dev, nbd;
+    unsigned long flags;
+
+    ENBD_DEBUG (1, "entered\n");
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+    while (CURRENT != NULL) {
+#else
+    while (! QUEUE_EMPTY) {
+    // while (! list_empty(&q->queue_head)) {
+#endif
+
+	struct enbd_device *lo = NULL;
+
+        req = CURRENT;
+
+	PARANOIA_BEGIN;
+        if (!req) {	// PTB lo notionally not defined yet
+	    ENBD_ALERT ("queue not empty but no request?");
+	    ENBD_DEBUG (1, "exiting\n");
+	    return;
+	}
+	PARANOIA_END;
+        dev = MINOR (req->rq_dev);
+	nbd = dev >> ENBD_SHIFT;
+
+	ENBD_DEBUG (1, "request on minor %d\n", dev);
+
+	if (nbd >= MAX_NBD) {
+	    ENBD_DEBUG (1, "minor %d too big in do_nbd_request\n", dev);
+	    ENBD_FAIL ("minor too big in do_nbd_request.");
+	}
+	lo = enbd_dev[nbd];
+
+	if (!lo) {
+	    ENBD_FAIL ("Request when device not ready.\n");
+        }
+        if (lo->acct) {
+	        atomic_inc (&lo->acct->kthreads);	/* PTB - one kernel thread enters */
+	        if (atomic_read (&lo->acct->kthreads) > atomic_read (&lo->kmax))
+	               atomic_set (&lo->kmax, atomic_read (&lo->acct->kthreads));
+        }
+	ENBD_DEBUG (3, "DEBUG 9\n");
+
+        /*
+         * PTB let's temporarily take this out of circulation so that
+         * requests can just pile up for the device until its ready
+         * again or until we give an explicit close command to it.
+         *
+         * PTB basic sanity test. At least one daemon has registered.
+         *
+	if (!lo->file) {
+	    ENBD_DEBUG (1, "Request when device nd%s not ready\n", lo->devnam);
+	    ENBD_FAIL ("Request when device not ready.\n");
+	}
+        */
+	// PTB - should use is_read_only(MKDEV(major,nbd<<ENBD_SHIFT))
+	// FIXME run over all the partitions too
+        switch (req->cmd) {
+            /* PTB testing */
+            case READ:
+            case WRITE:
+                break;
+            default:
+	        ENBD_FAIL ("unknown request type\n");
+                break;
+        }
+	if (rq_data_dir(req) == WRITE
+	    && (atomic_read (&lo->flags) & ENBD_READ_ONLY)) {
+	    ENBD_DEBUG (1, "write on read-only device nd%s\n", lo->devnam);
+	    ENBD_FAIL ("write on read-only device\n");
+	}
+	flags = atomic_read (&lo->flags);
+	if (!(flags & ENBD_INITIALISED)) {
+	    ENBD_DEBUG (1, "device nd%s not initialised\n", lo->devnam);
+	    ENBD_FAIL ("device not initialised.\n");
+	}
+	if (!(flags & ENBD_ENABLED)) {
+	    ENBD_DEBUG (1, "device nd%s not enabled\n", lo->devnam);
+	    ENBD_FAIL ("device not enabled.\n");
+	}
+	if (flags & ENBD_REMOTE_INVALID) {
+	    ENBD_DEBUG (1, "remote device on nd%s invalidated\n", lo->devnam);
+	    ENBD_FAIL ("remote device invalidated.\n");
+	}
+        /*
+         * PTB let's temporarily take this out of circulation so that
+         * requests can just pile up for the device until its ready
+         * again or until we give an explicit close command to it.
+         *
+	if (lo->nslot <= 0) {
+	    ENBD_ERROR ("device nd%s has no (%d) clients registered\n",
+		       lo->devnam, lo->nslot);
+	    ENBD_FAIL ("device has no clients registered yet.\n");
+	}
+	if (lo->aslot <= 0 && (flags & ENBD_SHOW_ERRS)) {
+	    ENBD_DEBUG (1, "device nd%s presently has no active clients\n",
+		       lo->devnam);
+	    ENBD_FAIL ("device presently has no active clients.\n");
+	}
+        */
+	PARANOIA_BEGIN;
+        if (lo->magic != ENBD_DEV_MAGIC) {
+	    ENBD_DEBUG (1, "nd%s is not magical!\n", lo->devnam);
+	    ENBD_FAIL ("nbd[] is not magical!\n");
+	}
+	if (req->nr_sectors > lo->max_sectors) {
+	    ENBD_FAIL ("oversize request\n");
+	}
+	PARANOIA_END;
+        if (req->sector + req->nr_sectors > enbd_hd_struct[dev].nr_sects) {
+	    ENBD_FAIL ("overrange request\n");
+	}
+        if (req->sector < 0) {
+	    ENBD_FAIL ("underrange request\n");
+	}
+        if (req->rq_status != RQ_ACTIVE) {
+            ENBD_ALERT ("received req 0x%lx that is not active!\n",
+                    (unsigned long)req);
+        }
+	req->errors = 0;
+	blkdev_dequeue_request (req);
+	PARANOIA_BEGIN;
+        if (CURRENT == req) {
+	    ENBD_ALERT ("CURRENT did not move from %p\n", req);
+	}
+	PARANOIA_END;
+	// PTB we are the only reader and writer of lo->seqno
+	if (rq_data_dir(req) == WRITE
+	     && rq_seqno(req) == 0) {
+	    // PTB it's a new request never seen before
+	    atomic_inc (&lo->seqno_out);
+	    // PTB we have to be careful to change this back before
+	    // giving it back to the kernel, as the kernel uses it.
+	    // We patch it back again in enbd_end_request.
+            rq_set_seqno(req, atomic_read (&lo->seqno_out)); 
+	}
+
+        if (0) {
+                // PTB testing
+	        enbd_end_request (req);
+	        goto accounting;
+        }
+
+	if (buffered_write != NULL
+                && (atomic_read(&lo->flags) & ENBD_BUFFERWR)) {
+
+	  switch (rq_data_dir(req)) {
+
+	    case WRITE:
+	      if (buffered_write (lo, req) < 0) {
+                  if (req->errors < 0)
+                      req->errors = 0;
+                  req->errors++;
+              }
+	      // PTB now ack the source request back to the kernel normally
+	      enbd_end_request (req);
+	      goto accounting;
+	      break;
+	      // end write
+	  }			// eswitch
+
+        }
+
+        // PTB normal sequence is to queue request locally
+	enbd_enqueue (lo, req);
+	goto accounting;
+
+      accounting:
+        if (lo->acct) {
+	        atomic_dec (&lo->acct->kthreads);
+        }
+	ENBD_DEBUG (3, "DEBUG 5\n");
+	continue; // PTB next request
+
+      error_out:
+	// PTB can rely on req being nonnull here
+	ENBD_DEBUG (3, "DEBUG 6\n");
+	req->errors++;
+	blkdev_dequeue_request (req);
+	ENBD_ALERT ("ending req %p with prejudice\n", req);
+	enbd_end_request (req);
+	if (lo && lo->acct) {
+	    int req_blks = nr_blks (req);
+	    atomic_add (req_blks, &lo->acct->requests_err);
+	    atomic_dec (&lo->acct->kthreads);
+	}
+	ENBD_DEBUG (3, "DEBUG 7\n");
+    }
+
+    ENBD_DEBUG (1, "exiting\n");
+    return;
+}
+
+static int (*md_notify_fn)(kdev_t, int);
+static int md_count;
+static spinlock_t md_access_lock;
+static int md_doing_notify;
+static int md_notify_pid = -1;
+
+#ifndef HOT_ADD_DISK
+  #define HOT_ADD_DISK          _IO (MD_MAJOR, 0x28)
+#endif
+#ifndef SET_DISK_FAULTY
+  #define SET_DISK_FAULTY       _IO (MD_MAJOR, 0x29)
+#endif
+
+static int
+enbd_notify_md_device (kdev_t enbd_dev, int cmd)
+{
+
+	spin_lock (&md_access_lock);
+	if (md_count > 0 && md_notify_fn) {
+                int err;
+                md_doing_notify = 1;
+                md_notify_pid = current->pid;
+	        spin_unlock (&md_access_lock);
+		ENBD_ALERT
+                    ("notifying %d for nbd dev %x to raid devices via fn\n",
+                        cmd, enbd_dev);
+		err = md_notify_fn (enbd_dev, cmd);
+	        spin_lock (&md_access_lock);
+                md_doing_notify = 0;
+                md_notify_pid = -1;
+		if (err < 0) {
+			ENBD_ALERT
+			 ("ioctl %d to raid devices returned %d\n", cmd, err);
+		}
+	}
+	spin_unlock (&md_access_lock);
+
+	return 0;
+}
+
+static int
+enbd_notify_md_devices (struct enbd_device *lo, int cmd)
+{
+        int j;
+        
+        for (j = 0; j - 1 < lo->nslot; j++) {
+	    kdev_t enbd_dev = MKDEV (major, j + (lo->nbd << ENBD_SHIFT));
+            if (j == 0) {
+                if (atomic_read(&lo->md_count) <= 0)
+                    continue;
+            } else {
+                struct enbd_slot *slot = lo->slots[j - 1];
+                if (!slot || slot->md_count <= 0)
+                    continue;
+            }
+            enbd_notify_md_device (enbd_dev, cmd);
+        }
+        return 0;
+}
+
+static int
+atomic_test_and_set_mask (atomic_t * a, unsigned mask)
+{
+	int i = ffs (mask);
+	if (!i)
+		return -EINVAL;
+#ifdef __LITTLE_ENDIAN
+	return test_and_set_bit (i - 1, (unsigned long *) &a->counter);
+#else
+#ifndef __BIG_ENDIAN
+#error help, I only know about bigendian or littlendian machines
+#endif
+	return test_and_set_bit
+	 (i - 1 + (sizeof (long) - sizeof (a->counter)) * 8,
+	  (unsigned long *) &a->counter);
+#endif
+
+}
+static int
+atomic_test_and_clear_mask (atomic_t * a, unsigned mask)
+{
+	int i = ffs (mask);
+	if (!i)
+		return 0;
+#ifdef __LITTLE_ENDIAN
+	return test_and_clear_bit (i - 1, (unsigned long *) &a->counter);
+#else
+#ifndef __BIG_ENDIAN
+#error help, I only know about bigendian or littlendian machines
+#endif
+	return test_and_clear_bit
+	 (i - 1 + (sizeof (long) - sizeof (a->counter)) * 8,
+	  (unsigned long *) &a->counter);
+#endif
+}
+/*
+ * PTB - set the enabled flag on a device 
+ * ( call without the spinlock held ) 
+ */
+static int
+enbd_enable (struct enbd_device *lo) {
+
+	unsigned long flags;
+        int did_enabled = 0;
+
+	if (!lo || !(atomic_read (&lo->flags) & ENBD_INITIALISED)) {
+		ENBD_ALERT("enbd_enable called on bad device\n");
+		return -EINVAL;
+        }
+	// PTB reenable part
+	write_lock_irqsave (&lo->meta_lock, flags);
+	if (!atomic_test_and_set_mask (&lo->flags, ENBD_ENABLED)) {
+                // PTB was not enabled before
+	        ENBD_ALERT ("enabled device nd%s\n", lo->devnam);
+
+	        if (atomic_test_and_clear_mask (&lo->flags, ENBD_VALIDATED)) {
+	                ENBD_ALERT ("invalidated device nd%s\n", lo->devnam);
+                }
+	        lo->lives++;
+                did_enabled = 1;
+        }
+	write_unlock_irqrestore (&lo->meta_lock, flags);
+
+        if (did_enabled)
+                enbd_notify_md_devices(lo, HOT_ADD_DISK);
+        return 0;
+}
+
+
+/*
+ * PTB rollback all requests on a given slot and then invalidate it
+ * (so the requests can't go back until somebody reactivates the slot)
+ * At least rollback (which we call takes both the io spinlock and our
+ * spinlock, so we can hold neither when we are called. Soft_reset
+ * (which we call) also calls rollback, so has the same problem.
+ */
+static int
+enbd_clr_sock (struct enbd_slot *slot) {
+
+    int i = 0;
+    struct enbd_device *lo = slot->lo;
+    int islot = slot->i;
+    unsigned long flags;
+
+    ENBD_DEBUG (3, "entered with arg %d\n", islot);
+
+    enbd_rollback_all (slot);
+
+    slot->file = NULL;
+    // PTB don't yet reset slot->group until have good reason
+    slot->bufsiz = 0;
+    slot->flags = 0;
+    slot->buffer = NULL;
+
+    write_lock_irqsave (&lo->meta_lock, flags);
+
+    /* PTB reset lo->aslot */
+
+    if (atomic_read(&lo->aslot) > 0) {
+
+	/* PTB grr .. do this the hard way since I don't seem to count right */
+        if (1) {
+                int i, count = 0;
+	        for (i = 0; i < lo->nslot; i++) {
+	                struct enbd_slot *sloti = lo->slots[i];
+	                if (sloti->file)
+		                count++;
+	        }
+                atomic_set (&lo->aslot, count);
+	        ENBD_DEBUG (3, "decremented active socket count to %d\n",
+                        atomic_read(&lo->aslot));
+        }
+
+	if (atomic_read(&lo->aslot) <= 0) {
+            // PTB make device more difficult to disable
+            if (atomic_read (&lo->flags) & ENBD_SHOW_ERRS) {
+		int enbd_soft_reset (struct enbd_device *lo);
+	        // PTB we are the last client alive, diasable device as we die
+	        atomic_clear_mask (ENBD_ENABLED, &lo->flags);
+		// PTB soft_reset will invalidate_buffers
+		// PTB soft reset will take the io spinlock and our spinlock
+		// so we must release our spinlock and never
+		// have the io spinlock at this point
+		write_unlock_irqrestore (&lo->meta_lock, flags);
+		enbd_soft_reset (lo);
+		write_lock_irqsave (&lo->meta_lock, flags);
+	        ENBD_DEBUG (3, "disabled device nd%s\n", lo->devnam);
+	    }
+	} else {
+            if (!(atomic_read (&lo->flags) & ENBD_ENABLED)) {
+                // PTB we must not call reenable as that clears the queue
+		// PTB this is silly. We're already enabled or should have been!
+		write_unlock_irqrestore (&lo->meta_lock, flags);
+                enbd_enable (lo);
+		write_lock_irqsave (&lo->meta_lock, flags);
+		ENBD_ALERT ("enabled device nd%s\n", lo->devnam);
+            }
+	}
+    }
+
+    /* PTB reset lo->islot, for no good reason */
+
+    if (atomic_read (&lo->islot) == islot) {
+	for (i = 0; i++ < lo->nslot;) {
+	    atomic_inc (&lo->islot);
+	    if (atomic_read (&lo->islot) >= lo->nslot)
+		atomic_set (&lo->islot, 0);
+	    if (lo->slots[atomic_read (&lo->islot)]->file)
+		break;
+	}
+	ENBD_DEBUG (3, "reset current socket slot to %d\n",
+		   atomic_read (&lo->islot));
+    }
+
+    lo->harderror = 0;
+    ENBD_DEBUG (3, "reset error to 0\n");
+
+    write_unlock_irqrestore (&lo->meta_lock, flags);
+
+    /* PTB don't clear whole device queue as we might still be open */
+
+    ENBD_DEBUG (3, "exited OK\n");
+    return 0;
+}
+
+/*
+ * PTB - check all slots for old requests and roll them back. 
+ * At least rollback (which we call takes both the io spinlock and our
+ * spinlock, so we can hold neither when we are called.
+ */
+static void
+enbd_rollback_old (struct enbd_device *lo)
+{
+
+    int islot;
+    ENBD_DEBUG (3, "entered\n");
+
+    for (islot = 0; islot < lo->nslot; islot++) {
+	struct enbd_slot *slot = lo->slots[islot];
+	if (slot->req_age > 0 && slot->req_age < jiffies - lo->req_timeo * HZ) {
+	    ENBD_DEBUG (1, "try rollback req on slot %d\n", islot);
+	    enbd_rollback_all (slot);
+	}
+    }
+
+    ENBD_DEBUG (3, "exited OK\n");
+}
+
+
+
+/*
+ * PTB - finally register a socket to a slot.
+ *     - Return 0 for success and -ve for failure.
+ *       Nowadays this doesn't do very much! Just finalizes things.
+ */
+static int
+enbd_set_sock (struct enbd_slot *slot, int arg)
+{
+
+    struct enbd_device *lo = slot->lo;
+    int islot = slot->i;
+    unsigned long flags;
+
+    ENBD_DEBUG (3, "entered with arg %d on slot %d\n", arg, islot);
+
+    if (!(atomic_read (&lo->flags) & ENBD_INITIALISED)) {
+	ENBD_ALERT ("(%d) device nd%s not initialised yet!\n",
+                islot, lo->devnam);
+	ENBD_DEBUG (3, "exited NODEV\n");
+	return -ENODEV;
+    }
+    if (!(atomic_read (&lo->flags) & ENBD_SIZED)) {
+	ENBD_ALERT ("(%d) device nd%s not sized yet!\n", islot, lo->devnam);
+	ENBD_DEBUG (3, "exited INVAL\n");
+	return -EINVAL;
+    }
+    if (!(atomic_read (&lo->flags) & ENBD_BLKSIZED)) {
+	ENBD_ALERT ("(%d) device nd%s not blksized yet!\n", islot, lo->devnam);
+	ENBD_DEBUG (3, "exited INVAL\n");
+	return -EINVAL;
+    }
+    if (!(atomic_read (&lo->flags) & ENBD_SIGNED)) {
+	ENBD_ALERT ("(%d) setting unsigned device nd%s! But harmless.\n",
+		   islot, lo->devnam);
+	ENBD_DEBUG (3, "exited INVAL\n");
+	return -EINVAL;
+    }
+
+    // check pid
+    down(&lo->pid_sem);
+
+    if (slot->pid != current->pid) {
+        if (jiffies > slot->cli_age + 2 * HZ * lo->req_timeo) {
+                ENBD_ALERT
+                    ("(%d) dead client process %d has nd%s%d, erasing pid!\n",
+                        islot, slot->pid, lo->devnam, islot + 1);
+                slot->pid = 0;
+                up(&lo->pid_sem);
+	        return -EINVAL;
+        } 
+        ENBD_ALERT("(%d) other live client process %d has nd%s%d!\n",
+                         islot, slot->pid, lo->devnam, islot + 1);
+        up(&lo->pid_sem);
+	return -EINVAL;
+    }
+
+    up(&lo->pid_sem);
+    // released semaphore
+
+    ENBD_DEBUG (3, "received request for slot %d with %d active of %d\n",
+	       islot, atomic_read(&lo->aslot), lo->nslot);
+    ENBD_DEBUG (3, "selected slot %d of %d\n", islot, lo->nslot);
+
+    slot = lo->slots[islot];
+
+    ENBD_DEBUG (3, "verified slot nd%s%d is available\n", lo->devnam,
+	       islot + 1);
+
+    // PTB this is a queue critical code region for the flags business
+    write_lock_irqsave (&lo->meta_lock, flags);
+
+    // PTB file has to be nonzero to indicate we're all set up. 
+    slot->file = (void *) (unsigned long) (arg+1 > 0 ? arg+1 : 1);
+
+    if (islot >= lo->nslot) {
+	lo->nslot = islot + 1;
+	ENBD_INFO ("increased socket count to %d\n", lo->nslot);
+    }
+
+    lo->harderror = 0;
+    ENBD_DEBUG (3, "set error to 0\n");
+
+    write_unlock_irqrestore (&lo->meta_lock, flags);
+    // PTB end of queue critical region 
+
+    enbd_enable(lo);
+
+
+    if (check_partitions) {
+        int want_to_check_partitions = 0;
+        write_lock (&lo->meta_lock);
+        if (!(atomic_read (&lo->flags) & (ENBD_VALIDATED|ENBD_VALIDATING)))
+                want_to_check_partitions = 1;
+        write_unlock (&lo->meta_lock);
+        if (want_to_check_partitions)
+                enbd_kernel_thread((int(*)(void*))enbd_reread_partitions, lo, CLONE_VM); 
+    }
+
+
+    ENBD_DEBUG (3, "exited OK with socket slot %d\n", islot);
+    return 0;
+}
+
+/*
+ * PTB - return the index i of 2^i + j, 0 <= j < 2^i
+ */
+static inline unsigned
+log2 (unsigned arg)
+{
+    unsigned log = 0;
+    while ((arg >>= 1) > 0)
+	log++;
+    return log;
+}
+
+/*
+ * PTB - set the blksize in bytes of the block device. Return 0 for
+ *     - success and -ve for failure.
+ */
+static int
+enbd_set_blksize (struct enbd_device *lo, unsigned int arg)
+{
+    int nbd = lo->nbd;
+    ENBD_DEBUG (1, "entered with arg %x (%u) on device %d\n", arg, arg, nbd);
+    if (arg > PAGE_SIZE) {
+	ENBD_ERROR ("blksize (%u) too big\n", arg);
+        return -EINVAL;
+    }
+    if (arg < 512) {
+	ENBD_ERROR ("blksize (%u) too small\n", arg);
+        return -EINVAL;
+    }
+    if (arg & (arg - 1)) {
+	ENBD_ERROR ("blksize (%u) not power of 2\n", arg);
+        return -EINVAL;
+    }
+
+    lo->blksize = enbd_blksizes[nbd << ENBD_SHIFT] = arg;
+    set_blocksize(MKDEV(major, nbd << ENBD_SHIFT), lo->blksize);
+    ENBD_DEBUG (1, "set blksize to %d \n", lo->blksize);
+    lo->logblksize = log2 (lo->blksize);
+    atomic_set_mask (ENBD_BLKSIZED, &lo->flags);
+    ENBD_DEBUG (1, "exited OK\n");
+    return 0;
+}
+
+/*
+ * PTB - set the size in bytes of the block device. Return 0 for
+ *     - success and -ve for failure.
+ */
+static int
+enbd_set_size (struct enbd_device *lo, u64 arg)
+{
+    int nbd = lo->nbd;
+    ENBD_DEBUG (3, "entered with arg %lx%.8lx  on device %d\n",
+	       (long) (arg >> 32), (unsigned long) (arg & 0xffffffff), nbd);
+
+    lo->bytesize = enbd_bytesizes[nbd << ENBD_SHIFT] = arg;
+    ENBD_DEBUG (1, "set bytesize to %luKB \n",
+	       (unsigned long) (lo->bytesize >> 10));
+    lo->size = enbd_sizes[nbd << ENBD_SHIFT] = arg >> 10;
+    lo->sectors = enbd_hd_struct[nbd << ENBD_SHIFT].nr_sects = lo->size << 1;
+    
+    ENBD_DEBUG (1, "set size (blocks) to %d \n", lo->size);
+
+#if DEBUG > 0
+    if (debug) {
+	if (lo->blockmap) {
+	    kfree (lo->blockmap);
+	    lo->blockmap = NULL;
+	}
+	if (!lo->blockmap) {
+	    /* PTB two bits per block in the blockmap */
+	    unsigned blocks = lo->size >> (lo->logblksize - 10);
+	    lo->blockmap = kmalloc (blocks >> 2, GFP_KERNEL);
+	    if (lo->blockmap)
+		memset (lo->blockmap, 0xff, blocks >> 2);
+	}
+    }
+#endif
+
+    atomic_set_mask (ENBD_SIZED, &lo->flags);
+    ENBD_DEBUG (3, "exited OK\n");
+    return 0;
+}
+
+/* WG */
+static int
+my_nbd_set_intvl (struct enbd_device *lo, int arg)
+{
+    ENBD_DEBUG (3, "entered with arg %x (%u) on device nd%s\n", arg, arg,
+	       lo->devnam);
+    if (arg <= 0) {
+	ENBD_ERROR ("bad pulse interval/req timeout value (%d)\n", arg);
+	ENBD_DEBUG (3, "exited INVAL\n");
+	return -EINVAL;
+    }
+    lo->req_timeo = arg;
+    ENBD_DEBUG (1, "set pulse interval/req timeout to %d \n", lo->req_timeo);
+    ENBD_DEBUG (3, "exited OK\n");
+    return 0;
+}
+
+static int
+my_nbd_set_spid (struct enbd_slot *slot, int arg)
+{
+    short spid = arg;
+
+    ENBD_DEBUG (3, "entered with arg %x (%u)\n", arg, arg);
+
+    if (arg <= 0 || arg >= (1<<(sizeof(short)*8))) {
+	ENBD_ERROR ("bad spid value (%d)\n", arg);
+	ENBD_DEBUG (3, "exited INVAL\n");
+	return -EINVAL;
+    }
+    slot->spid = spid;
+    ENBD_DEBUG (1, "set spid to %d \n", slot->spid);
+    ENBD_DEBUG (3, "exited OK\n");
+    return 0;
+}
+
+static int
+my_nbd_set_bufferwr (struct enbd_device *lo, int arg)
+{
+    ENBD_DEBUG (3, "entered with arg %x (%u) on device nd%s\n", arg, arg,
+	       lo->devnam);
+    if (arg) {
+      atomic_set_mask(ENBD_BUFFERWR, &lo->flags);
+    } else {
+      atomic_clear_mask(ENBD_BUFFERWR, &lo->flags);
+    }
+    ENBD_DEBUG (1, "set buffer wrotes flag to %d \n",
+            atomic_read(&lo->flags) & ENBD_BUFFERWR);
+    ENBD_DEBUG (3, "exited OK\n");
+    return 0;
+}
+
+static int
+my_nbd_set_remote_invalid (struct enbd_device *lo, int arg)
+{
+	// PTB we handle the event ourself exactly when it happens
+	// instead of letting the kernel have check_media defined
+	// and doing it there (and reporting 0 to the kernel)
+	unsigned long flags;
+        int do_invalidate = 0;
+	kdev_t dev = MKDEV (major, lo->nbd << ENBD_SHIFT);
+
+	ENBD_DEBUG (3, "entered with arg %x (%u) on device nd%s\n", arg,
+		   arg, lo->devnam);
+
+	if (arg == 0) {
+		if (atomic_test_and_clear_mask (&lo->flags, ENBD_REMOTE_INVALID)){
+	                if (atomic_test_and_clear_mask (&lo->flags, ENBD_SET_SHOW_ERRS)) {
+		                atomic_clear_mask (ENBD_SHOW_ERRS, &lo->flags);
+                        }
+                }
+		return 0;
+	}
+
+        write_lock_irqsave (&lo->meta_lock, flags);
+	if (!(atomic_test_and_set_mask (&lo->flags,ENBD_REMOTE_INVALID))) {
+		// PTB this tells the kernel that next open
+		// should cause recheck .. we'll agree nnot to
+		// say we're happy until INVALID is not set
+		atomic_clear_mask (ENBD_VALIDATED, &lo->flags);
+                // PTB also make errors real until device validated again
+	        if (!atomic_test_and_set_mask (&lo->flags, ENBD_SHOW_ERRS)) {
+		        atomic_set_mask (ENBD_SET_SHOW_ERRS, &lo->flags);
+                }
+                write_unlock_irqrestore (&lo->meta_lock, flags);
+                do_invalidate = 1;
+        } else {
+                write_unlock_irqrestore (&lo->meta_lock, flags);
+        }
+
+        if (do_invalidate)
+	        invalidate_device (dev, 0);
+	ENBD_DEBUG (3, "exited OK\n");
+	return 0;
+}
+
+
+/*
+ * Return the first slot index free when asking for n new ones.
+ * If there s no such gap, then ENBD_MAXCONN will be returned.
+ * The return is always in the same argument address.
+ */
+static int
+enbd_get_nport (struct enbd_device *lo, int *arg)
+{
+    int err, nslot, i;
+
+    if (arg == NULL) {
+	        return -EINVAL;
+    }
+
+    nslot = *arg;
+    err = copy_from_user((char*)&nslot, arg, sizeof(int));
+    if (err < 0) {
+	        return err;
+    }
+
+    // should look for client sig
+    for (i = 0; i < ENBD_MAXCONN; i++) {
+	    struct enbd_slot *sloti = lo->slots[i];
+            int j;
+	    if (sloti->file) {
+                continue;
+            }
+            // have gap. ee how long it is
+            for (j = i; j < ENBD_MAXCONN && j < i + nslot; j++) {
+                if (sloti->file)
+                    break;
+            }
+            if (j == i + nslot) {
+                // perfect
+                break;
+            }
+    }
+
+    err = copy_to_user(arg,(char*)&i,sizeof(int));
+    return err;
+}
+
+/*
+ * Set the signature on the whole device, if not yet set.
+ *
+ * If it is set, compare.
+ */
+static int
+enbd_set_sig(struct enbd_device *lo, int* buf) {
+
+    if (!atomic_test_and_set_mask (&lo->flags, ENBD_SIGNED)) {
+	/* PTB first time grab sig */
+	memcpy ((char *) lo->signature, buf, ENBD_SIGLEN);
+	return 1;
+    }
+
+    /* PTB test for equality */
+    if (memcmp(buf, (char*)&lo->signature[0], ENBD_SIGLEN) != 0) {
+	return -EINVAL;
+    }
+    return 0;
+}
+
+/*
+ * Set the pid on the slot if unset, and set time, and then return 0. 
+ *
+ * If the pid is already set, compare and if it's ours, return 0.
+ * If the pid differs return -ve. If they hasn't touched us in a long
+ * while (the time is set on many ops), erase it too!
+ */
+static int
+enbd_set_pid (struct enbd_slot *slot)
+{
+        struct enbd_device *lo = slot->lo;
+        int islot = slot->i;
+
+	// PTB set pid if first time
+	if (slot->pid == 0) {
+		slot->pid = current->pid;
+		slot->cli_age = jiffies;
+		return 0;
+	}
+
+	if (slot->pid == current->pid)
+		return 0;
+
+	if (jiffies > slot->cli_age + 2 * HZ * lo->req_timeo) {
+		ENBD_ALERT
+		 ("(%d): dead process %d was setting sig, erasing pid\n",
+		  islot, slot->pid);
+		slot->pid = current->pid;
+		slot->cli_age = jiffies;
+		return 0;
+	}
+
+	ENBD_ALERT ("(%d): live process %d is trying to set sig\n",
+	  islot, slot->pid);
+	return -EINVAL;
+}
+
+/*
+ * PTB - if we're not signed, accept new sig and return success.
+ *     - if we are signed, compare the offer and return success if equal,
+ *     - and -ve for failure.
+ */
+static int
+my_nbd_set_sig (struct enbd_slot *slot, char *sig)
+{
+    int err = 0;
+    char buf[ENBD_SIGLEN];
+    int islot = slot->i;
+    struct enbd_device *lo = slot->lo;
+
+
+    ENBD_DEBUG (3, "entered\n");
+
+    if (!access_ok (VERIFY_READ, sig, ENBD_SIGLEN)) {
+	err = -EINVAL;
+	ENBD_DEBUG (3, "(%d) exited INVAL\n", islot);
+	return err;
+    }
+
+    // PTB semaphore not spinlock because copy_from_user might sleep?
+    down(&lo->pid_sem);
+    if (enbd_set_pid(slot) < 0) {
+        up(&lo->pid_sem);
+        return -EINVAL;
+    }
+    // PTB slot->pid is now set and matches ours
+    
+    copy_from_user (buf, sig, ENBD_SIGLEN);
+    err = enbd_set_sig(lo, (int *)buf);
+
+    if (err < 0) {
+        // PTB vamoosh our pid registration too
+        slot->pid = 0;
+	ENBD_ALERT ("(%d): failed sigcheck wth %d\n", islot, err);
+    } else {
+        ENBD_DEBUG (3, "(%d): set sig OK\n", islot);
+    }
+    up(&lo->pid_sem);
+    return err;
+}
+
+
+
+/*
+ * PTB set the max_sectors for a device
+ */
+static void
+set_max_sectors(struct enbd_device *lo, int sectors) {
+	int j;
+	lo->max_sectors = sectors;
+	for (j = 0; j < ENBD_MAXCONN; j++) {
+	    enbd_max_sectors[(lo->nbd << ENBD_SHIFT) + j] = sectors;
+	}
+}
+
+/*
+ * PTB - register a userspace buffer to a slot. Return 0 for success
+ *     - and -ve for failure. Null arg acts as erase.
+ */
+static int
+my_nbd_reg_buf (struct enbd_slot *slot, char *buffer)
+{
+
+    int err = 0, bufsiz;
+    struct enbd_device *lo = slot->lo;
+
+    ENBD_DEBUG (3, "entered\n");
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+    if (enbd_queue->request_fn != do_nbd_request) {
+	err = -EINVAL;
+	ENBD_DEBUG (3, "(%d): exited INVAL\n", slot->i);
+	return err;
+    }
+#endif
+
+    if (!buffer) {
+	slot->flags &= ~ENBD_SLOT_BUFFERED;
+	ENBD_DEBUG (1, "(%d): unregistered buffer %x size %d\n",
+		   slot->i, (unsigned) slot->buffer, slot->bufsiz);
+	slot->buffer = NULL;
+	slot->bufsiz = 0;
+	return 0;
+    }
+
+    // PTB this is how long we ideally would like it to be
+    bufsiz = lo->max_sectors << 9;
+
+    /* verify the buffer is in the process space */
+    if (!access_ok (VERIFY_WRITE, buffer, bufsiz)) {
+	err = -EINVAL;
+	ENBD_DEBUG (3, "(%d) exited with %d\n", slot->i, err);
+	return err;
+    }
+    /* PTB hope the buffer is as big as it should be - FIXME */
+    slot->buffer = buffer;
+    slot->bufsiz = bufsiz;
+
+    /* PTB let the device bufsiz be min of registered nonzero bufsizes */
+    if (!lo->bufsiz) {
+	// PTB first time
+	lo->bufsiz = bufsiz;
+    }
+    else {
+        // PTB new slot added, with new buffer
+	if (lo->bufsiz > bufsiz)
+	    lo->bufsiz = bufsiz;
+    }
+
+    // PTB just in case the buffer really is small, we reset all the
+    //     kernels request maxima if we have to adjust the device max
+    if (lo->max_sectors < (lo->bufsiz >> 9)) {
+        set_max_sectors(lo, lo->bufsiz >> 9);
+    }
+
+    slot->flags |= ENBD_SLOT_BUFFERED;
+    ENBD_DEBUG (1, "(%d): registered buffer %x size %d\n",
+	       slot->i, (unsigned) buffer, bufsiz);
+    ENBD_DEBUG (3, "exited OK\n");
+    return 0;
+}
+
+/*
+ * PTB - this unsets the enabled flag on the device and then clears the
+ *     - queue for the device if called with retries_max > 0. Call
+ *     - without spinlock.
+ */
+static int
+enbd_disable (struct enbd_device *lo)
+{
+	ENBD_DEBUG (1, "entered\n");
+	if (!lo || !(atomic_read (&lo->flags) & ENBD_INITIALISED)) {
+		ENBD_ALERT("enbd_disable called on bad device\n");
+		return 0;
+	}
+	if (atomic_test_and_clear_mask (&lo->flags, ENBD_ENABLED)) {
+	        ENBD_ALERT ("disabled device nd%s\n", lo->devnam);
+        }
+
+        enbd_notify_md_devices(lo, SET_DISK_FAULTY);
+
+        // PTB have to recheck partitions on next open
+	if (atomic_test_and_clear_mask (&lo->flags, ENBD_VALIDATED)) {
+	        ENBD_ALERT ("invalidated device nd%s\n", lo->devnam);
+        }
+	ENBD_DEBUG (1, "exited\n");
+	return 0;
+}
+
+
+/*
+ * PTB - if ! ENABLED, clear all queues and then resset ENABLED flag
+ * ( call without the spinlock held ) 
+ */
+static void
+enbd_reenable (struct enbd_device *lo)
+{
+
+    if (!(atomic_read (&lo->flags) & ENBD_INITIALISED))
+	return;
+
+    if ((atomic_read (&lo->flags) & ENBD_ENABLED)) {
+        return;
+    }
+
+    enbd_enable(lo);
+}
+
+/*
+ * This function launches a thread which wakes for a signal to reenable
+ * the device, and then sets the timer to deleiver the signal.
+ */
+static int
+enbd_reenable_delay (struct enbd_device *lo, int delay)
+{
+        write_lock(&lo->meta_lock);
+        if (lo->reenable_time == 0)
+                lo->reenable_time = jiffies + delay * HZ;
+        write_unlock(&lo->meta_lock);
+        return 0;
+}
+
+/*
+ * PTB - drains device queue. Disables device.
+ * At least rollback (which we call takes both the io spinlock and our
+ * spinlock, so we can hold neither when we are called. Also
+ * invalidate buffers, on request of Rogier Wolff.
+ */
+int
+enbd_soft_reset (struct enbd_device *lo)
+{
+    int j;
+    const int max_clrq_retries = 100;
+    ENBD_DEBUG (3, "entered\n");
+
+    if (!lo || !(atomic_read (&lo->flags) & ENBD_INITIALISED) || lo->nslot <= 0){
+	    ENBD_DEBUG (3, "exited INVAL\n");
+	    return -EINVAL;
+    }
+    // We push back the requests in the slot, in order to be able to
+    // vamoosh them in a moment. This is a race, surely? We ought to
+    // do this atomically or dsiable the slots first.
+    for (j = 0; j < lo->nslot; j++) {
+	    struct enbd_slot *slot = lo->slots[j];
+	    ENBD_ALERT ("rollback queue on slot nd%s%d\n", lo->devnam, j);
+	    enbd_rollback_all (slot);
+    }
+    ENBD_DEBUG (1, "clear queue\n");
+    // disable unsets the enabled flag and clears the queue
+    enbd_disable (lo);
+    for (j = 0; j < max_clrq_retries; j++) {
+	    int n = enbd_clr_queue (lo);
+            if (n <= 0)
+                    break;
+    }
+    // PTB WE used to renable in 5s but I couldn't see how that was
+    // triggered, so I got rid of the code (temporarily)
+    //lo->flags &= ~ENBD_SIGNED;   /* PTB unsign the device */
+    // PTB put back invalidate buffers for use when called from
+    // clr_sock from enbd_release on request of Rogier Wolff.
+    ENBD_ALERT ("invalidating buffers on device nd%s\n", lo->devnam);
+    for (j = 0; j < lo->nslot; j++) {
+	    invalidate_buffers (MKDEV (major, (lo->nbd << ENBD_SHIFT) + j));
+    }
+    ENBD_DEBUG (3, "exited OK\n");
+    return 0;
+}
+
+/*
+ * PTB - added a device/module reset for tidyness in face of rampant hacking
+ *     - this does a soft_reset of all devices, followed bu a clr sock
+ *     - on each, and then clears the kernel queue. It unsets the
+ *     - enabled flag on each device.
+ *       We have to be called without either the spinlock or the
+ *       spinlock held, as we call soft_reset which takes both, as
+ *       does clr_sock
+ */
+int
+enbd_hard_reset (void)
+{
+    int i;
+    int err = 0;
+    ENBD_DEBUG (3, "entered\n");
+
+    ENBD_DEBUG (1, "usage count is %d\n", GET_USE_COUNT (&__this_module));
+    for (i = 0; i < MAX_NBD; i++) {
+	struct enbd_device *lo = enbd_dev[i];
+	int j;
+        if (!lo)
+            continue;
+	enbd_soft_reset (lo);
+	for (j = 0; j < lo->nslot; j++) {
+	    struct enbd_slot *slot = lo->slots[j];
+	    //  PTB this takes the io spinlock and our spinlock.
+	    enbd_clr_sock (slot);
+	}
+    }
+    // PTB - have to call clr_kernel_queue without the io_spinlock held
+    enbd_clr_kernel_queue ();
+
+#ifdef MODULE
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
+    while (MOD_IN_USE)
+	MOD_DEC_USE_COUNT;
+#else
+    mod_use_count_ = 0;
+#endif
+#endif
+
+    ENBD_DEBUG (1, "altered usage count to 0\n");
+
+    ENBD_DEBUG (3, "exited\n");
+    return err;
+}
+
+/*
+ * Calls kmalloc to put a buffer in the request and reads the user
+ * space @buf into it. 
+ *
+ * If we error, we kfree the buffer and return  < 0, setting the req
+ * buffer entry to NULL. 
+ *
+ * If we succeed, we return the size of the copy >= 0
+ */
+static int
+indirect_ioctl_load (struct request *req, int cmd, char * buf)
+{
+
+            // PTB req->nr_sectors is at least one on return iff we kmalloc'ed
+            // and and only and then is req->buffer non null and the
+            // return value > 0. And we return the exact size, not the
+            // value rounded up to 512.
+            
+            int size;
+            int err;
+
+            // buf is only needed for special interps that need to
+            // trace the data. Normally the cms inof is enough
+            size = remote_ioctl->size_user(cmd, buf);
+
+            if (size < 0) {
+                   // PTB unauthorized ioctl
+                   err = -EINVAL;
+                   goto error_out;
+            }
+
+            if (size == 0) {
+                   // PTB we never use the nbd device's small buffer now
+                   req->nr_sectors = 0;
+                   req->buffer = NULL;
+                   return size;
+            }
+
+           // PTB we have to use an extra buffer or else block
+           // here and rendezvous directly with the get_req call
+           req->nr_sectors = (size + 511) >> 9;
+           req->buffer = kmalloc(req->nr_sectors << 9, GFP_KERNEL);
+
+           if (!req->buffer) {
+               err = -ENOMEM;
+               goto error_out;
+           }
+
+           if (_IOC_DIR(cmd) & _IOC_WRITE) {
+                err = remote_ioctl->cp_from_user(cmd, req->buffer, buf, size);
+                if (err < 0) {
+                        kfree(req->buffer);
+                        req->buffer = NULL;
+                        goto error_out;
+                }
+           }
+           return size;
+
+error_out:
+            req->buffer = NULL;
+            req->nr_sectors =0;
+            return err;
+}
+
+/*
+ * Write to usespace @buf from internal req buffer, then free req buffer
+ * and set to NULL.
+ */
+static int
+indirect_ioctl_store (struct request *req, int cmd, char * buf,
+		      int size)
+{
+        int err;
+        // PTB if we are reading, it should be to the local buffer
+        ENBD_DEBUG(1, "copying %d bytes from IOCTL %#x to buf %p\n",
+            size, cmd & 0xffff, buf);
+
+        if (size > 0) {
+                // PTB the buffer points at kmalloced area
+                if (!req->buffer)
+                        return -ENOMEM;
+                err = remote_ioctl->cp_to_user(cmd, buf, req->buffer, size);
+                kfree(req->buffer);
+                req->buffer = NULL;
+                if (err < size) {
+                        ENBD_DEBUG (1, "ioctl %dB copy to user errored out\n",
+					size);
+                        return -ENOMEM;
+                }
+        }
+        return size;
+}
+
+static int
+wait_on_condition_timeout(wait_queue_head_t *wq, int (*f)(void *), 
+        void *data, unsigned long timeout) {
+    unsigned long start_time = jiffies;
+
+    while (! f (data)) {
+
+	if (jiffies >= start_time + timeout) {
+            return -ETIME;
+        }
+        interruptible_sleep_on_timeout (wq, start_time + timeout - jiffies);
+    }
+    return 0;
+}
+
+static struct request *
+ioctl_make_request(struct enbd_device *lo, int cmd, unsigned long arg) {
+
+    unsigned long timeout = lo->req_timeo * HZ;
+    struct request *req;
+    int size;
+    struct enbd_ioctl_info * ioctl_info;
+
+    int local_condition(struct enbd_device *lo) {
+           if (down_trylock (&lo->req_sem) == 0)
+               return 1;
+           return 0;
+    }
+
+    // PTB we're waiting to be able to write the req safely
+    if (wait_on_condition_timeout(&lo->req_wq,
+                (int(*)(void*))local_condition, lo,timeout) < 0) {
+            // PTB it takes too long to get the ioctl lock
+            ENBD_ALERT("took too long to get a spare ioctl: TIMEOUT\n");
+            return NULL;
+    }
+
+    // PTB semaphore is now held, prepare the fake request for our queue
+
+    req = &lo->req;
+
+    memset(req, 0, sizeof(*req));
+    req->cmd     = IOCTL;
+
+    // PTB 1 block announced for accounting visibility
+    //lo->req.nr_sectors = lo->logblksize - 9;
+
+    req->errors = 0;
+
+    ENBD_DEBUG(1, "writing ioctl %#x and arg %#x into ioctl req %p\n",
+            (unsigned)cmd, (unsigned) arg, req);
+
+    // PTB this is the fixed-up command
+    ioctl_info = &lo->req_ioctl_info;
+    ioctl_info->cmd = cmd;
+    ioctl_info->arg = arg;
+
+    // PTB size is calculated next
+        
+
+    // PTB this is (arg if it is direct, else) the address of a local buffer
+    // PTB we need to store the arg or its dereference somewhere local
+    // for a while until the cnb-client thread can enter and pick it
+    // up. The alternative is to block the ioctl here until it is
+    // picked up, which IS possible.
+    if (_IOC_DIR(cmd) & _IOC_READ) {
+        // PTB indirect
+
+            // PTB this makes a buffer and pts req->buffer at it
+            size = indirect_ioctl_load (req, cmd, (char *)arg);
+            if (size < 0) {
+                up(&lo->req_sem);
+                return NULL;
+            }
+
+
+    } else {
+            // PTB direct - we just need to remember the value
+            size = 0;
+            req->buffer = (char *)arg; 
+    }
+
+    ioctl_info->size = size;
+
+    // putthe info we have got so far into the request
+    (struct enbd_ioctl_info *) req->ENBD_BLKREQ_SPECIAL = ioctl_info;
+
+    // PTB point the request buffer vaguely in the direction of where
+    // the data is, but it doesn't matter.
+    req->rq_dev  = MKDEV(major, lo->nbd << ENBD_SHIFT);
+
+    // PTB we queue the request for treatment and wait till treated
+#ifdef DECLARE_COMPLETION
+    init_completion(&lo->req_x);
+    req->waiting = &lo->req_x;
+#endif
+    req->rq_status = RQ_ACTIVE;
+    // PTB uh, we probably always want to send ioctls to the zero group
+    enbd_enqueue (lo, req);
+
+    ENBD_DEBUG(1, "queued req %p ioctl %#x, len %d, bits %x, arg %lu (%lx)\n",
+            req, cmd & 0xffff, (cmd >> 16) & 0x3fff,
+              cmd >> 30, arg, arg);
+    return req;
+}
+
+/*
+ * Wait for an enqueued request to be completed. Return -ve on timeout or
+ * errored request, 0 on success.
+ */
+int
+enbd_local_wait_on_request_timeout(struct request *req, unsigned long timeout) {
+
+    int err;
+
+    int minor = MINOR (req->rq_dev);
+    int nbd = minor >> ENBD_SHIFT;
+    struct enbd_device * lo = enbd_dev[nbd];
+
+    ENBD_DEBUG(1, "entered\n");
+
+    // PTB need the queue lock as we may unqueue it here for timeout
+   #ifdef COMPLETION_INITIALIZER
+    if (wait_for_completion_timeout(req->waiting, timeout) <=  0) {
+   #else
+    static int local_condition(struct request *req) {
+                spin_lock(&io_request_lock);
+                if (req->rq_status != RQ_ACTIVE) {
+                        spin_unlock(&io_request_lock);
+                        // completed
+                        return 1;
+                }
+                spin_unlock(&io_request_lock);
+                return 0;
+    }
+
+
+    if (wait_on_condition_timeout(&lo->wq, local_condition, req, timeout) <  0) {
+   #endif
+            // PTB it takes too long, so search and delete
+            
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+	    struct list_head *pos;
+#else
+	    struct request *pos;
+#endif
+            static void delete_req(struct request *req) {
+                // PTB reverse the inadvertent accounting in enqueue
+                if (lo->acct) {
+                        atomic_dec (&lo->acct->countq[rq_data_dir(req)]);
+                }
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+                list_del (&req->queue);
+#else
+                enbd_list_del (req);
+#endif
+                req->errors = -ETIME;
+            };
+
+            // PTB even with lock this is dangerous. We should scan
+            // the device queue and that would be safe!
+
+            write_lock(&lo->queue_lock);
+            list_for_each (pos, &lo->queue) {
+                        struct request *xreq = list_entry (pos, struct request, queue);
+		        if (req == xreq) {
+                                delete_req(req);
+                                write_unlock(&lo->queue_lock);
+                                ENBD_ALERT("took too long to treat queued ioctl: TIMEOUT\n");
+                                err = -ETIME;
+                                // PTB release memory here
+                                goto end;
+                        }
+            }
+            write_unlock(&lo->queue_lock);
+        
+    } // PTB end if takes too long
+
+    req->rq_status = 0;
+
+    // PTB lock is now held for normal exit
+    
+    if (req->errors != 0) {
+        err = req->errors;
+        err = err < 0 ? err : -EINVAL;
+    } else {
+        err = 0;
+    }
+end:
+    ENBD_DEBUG(1, "exited %s %d\n", err>=0?"OK":"INVAL", err);
+
+    return err;
+}
+
+
+static int
+ioctl_wait_on_request_timeout(struct request *req, unsigned long timeout) {
+
+    int err;
+    struct enbd_ioctl_info * ioctl_info =
+        (struct enbd_ioctl_info *) req->ENBD_BLKREQ_SPECIAL;
+
+    int cmd = ioctl_info ? ioctl_info->cmd : 0;
+    unsigned long arg = ioctl_info? ioctl_info->arg : 0;
+    // arg to size_user only needed for special, and we'll hope not used
+    int size = ioctl_info ? ioctl_info->size : 0;
+
+    int minor = MINOR (req->rq_dev);
+    int nbd = minor >> ENBD_SHIFT;
+    struct enbd_device * lo = enbd_dev[nbd];
+
+    ENBD_DEBUG(1, "entered\n");
+    err = enbd_local_wait_on_request_timeout(req, timeout);
+    if (err < 0)
+        goto end;
+
+    // PTB lock is now held for normal exit.
+    if (_IOC_DIR(cmd) & _IOC_READ) {
+        err = indirect_ioctl_store(req, cmd, (char *)arg, size);
+        if (err < 0)
+            goto end;
+    }
+    
+    if (req->errors != 0) {
+        err = req->errors;
+        err = err < 0 ? err : -EINVAL;
+    } else {
+        err = 0;
+    }
+
+end:
+    ENBD_DEBUG(1, "exited %s %d\n", err>=0?"OK":"INVAL", err);
+    up(&lo->req_sem);
+
+    return err;
+}
+
+
+static int
+enbd_remote_ioctl(struct enbd_device *lo, int minor, int cmd, unsigned long arg) {
+
+	unsigned long timeout;
+        int err;
+        struct request * req;
+        int sectors;
+        char *buffer;
+
+    ENBD_DEBUG(1, "entered\n");
+    // PTB here we have to treat remote ioctls. We should probably make
+    // a request and put it on the local queue, but where can we get
+    // the request from? We might have to keep one in reserve.
+    // That's not a bad idea, because
+    // we generate it here and we delete it here, and the daemon code
+    // is all set up to read that sort of thing. So that's what we do ...
+    
+    timeout = lo->req_timeo * HZ;
+
+    // if successful, this takes rhe req semaphore
+    req = ioctl_make_request(lo, cmd, arg);
+    if (!req)
+        return -EINVAL;
+
+    // PTB need to know if the size was zero because then the buffer is not
+    // a valid address
+    sectors = req->nr_sectors;
+    buffer  = req->buffer;
+
+    // PTB and this releases the semaphore . It needs to get arg somehow.
+    err = ioctl_wait_on_request_timeout(req, timeout);
+
+    // PTB deal with an error by removing the buffer made in make_request
+    if (err < 0) {
+        if (sectors > 0 && buffer)
+	      kfree (buffer);
+    }
+
+    ENBD_DEBUG(1, "exited %s %d\n", err>=0?"OK":"INVAL", err);
+    return err;
+
+}
+
+static int
+find_slot (struct enbd_device *lo, int pid)
+{
+        int i;
+	// go search
+	for (i = 0; i < ENBD_MAXCONN; i++) {
+                struct enbd_slot * slot =  lo->slots[i];
+		if (slot && slot->pid == pid)
+			break;
+	}
+	if (i < ENBD_MAXCONN)
+		return i;		// found it
+	// not found
+	return -1;
+}
+
+
+/*
+ * PTB - generic ioctl handling
+ */
+int
+enbd_ioctl (struct inode *inode, struct file *file,
+	   unsigned int cmd, unsigned long arg)
+{
+    struct enbd_device *lo = 0;  // PTB device pointer
+    int minor = -1;		// PTB minor on which we got the ioctl
+    int islot = -1;             // PTB slot number 0, 1, ...
+    int nbd = -1;		// PTB the count for the device group
+    struct enbd_slot *slot
+                       = NULL;  // PTB slot pointer
+    int err;
+
+    ENBD_DEBUG (1, "id %#x, len %d, bits %x, entered with arg %lu (%lx) pid %d\n",
+        cmd & 0xffff, (cmd >> 16) & 0x3fff, cmd >> 30, arg, arg, current->pid);
+
+    if (!suser ()) {
+	ENBD_ERROR ("caller must be root.\n");
+	ENBD_DEBUG (3, "exited ACCES\n");
+	return -EACCES;
+    }
+    if (!inode) {
+	ENBD_ERROR ("given bad inode.\n");
+	ENBD_DEBUG (3, "exited INVAL\n");
+	return -EINVAL;
+    }
+    if (MAJOR (inode->i_rdev) != major) {
+	ENBD_ERROR ("pseudo-major %d != %d\n", MAJOR (inode->i_rdev), major);
+	ENBD_DEBUG (3, "exited NODEV\n");
+	return -ENODEV;
+    }
+
+    minor = MINOR (inode->i_rdev);
+    nbd = minor >> ENBD_SHIFT;
+
+    if (nbd >= MAX_NBD) {
+	ENBD_ERROR ("tried to open too many devices, %d\n", minor);
+	ENBD_DEBUG (3, "exited NODEV\n");
+	return -ENODEV;
+    }
+
+    lo = enbd_dev[nbd];
+    lo->harderror = 0;
+    islot = minor - (nbd << ENBD_SHIFT) - 1;
+
+    if (islot >= 0 && islot < ENBD_MAXCONN)
+        slot = lo->slots[islot];
+    // PTB otherwise slot = NULL
+    
+    // PTB fixup breakage >= 2.5.44 caused by not being allowed to talk to
+    // minors. We deduce the slot number from hints in the call.
+    // Or we match against the known pids.
+    if (islot < 0) {
+	        switch (cmd) {
+		        int intval;
+
+                        // PTB get slot info from parameter if not given
+                    case ENBD_CLEAR_SOCK:
+	            case MY_NBD_CLR_REQ:
+	            case MY_NBD_ERR_REQ:
+                        if (arg > 0 && arg <= ENBD_MAXCONN) {
+                                // trust the arg
+                                if (!slot->pid || slot->pid == current->pid) {
+	                                islot = arg - 1;
+	                                slot = lo->slots[islot];
+                                        break;
+                                }
+                        }
+                        // see if we match a known slot pid
+                        if (arg == 0) {
+                                islot = find_slot(lo, current->pid);
+                                if (islot >= 0) {
+                                        slot = lo->slots[islot];
+                                        break;
+                                }
+                                islot = -1;
+                                ENBD_ALERT("failed to find slot for pid %d for ioctl %x arg %lx\n",
+                                        current->pid, cmd, arg);
+                                break;
+                        }
+                        break;
+
+                        // PTB get the slot from the 16 high bits
+	            case ENBD_SET_SOCK:
+	            case MY_NBD_SET_SPID:
+                        intval  = arg >> ((sizeof(int) - sizeof(short)) * 8);
+                        intval &= (1 << (sizeof(short) * 8)) - 1;
+                        if (intval > 0 && intval <= ENBD_MAXCONN)  {
+                                // inrange arg. Trust it
+                                if (!slot->pid || slot->pid == current->pid) {
+                                        islot = intval - 1;
+	                                slot = lo->slots[islot];
+
+                                        // PTB change arg !!
+                                        arg &= (1 << (sizeof(short) * 8)) - 1;
+                                        break;
+                                }
+                        }
+                        if (intval == 0) {
+                                // no clue in the pid high bits. Search
+                                islot = find_slot(lo, current->pid);
+                                if (islot >= 0) {
+                                        // PTB change arg !!
+                                        arg &= (1 << (sizeof(short) * 8)) - 1;
+                                        slot = lo->slots[islot];
+                                        break; // found it
+                                }
+                                // not found
+                                islot = -1;
+                                ENBD_ALERT("failed to find slot for pid %d for ioctl %x arg %lx\n",
+                                        current->pid, cmd, arg);
+                                break;
+                        }
+                        break;
+
+	            case MY_NBD_GET_REQ:
+	            case MY_NBD_ACK:
+                        if (0 < arg && arg <= ENBD_MAXCONN) {
+                                // inrange arg. Trust it
+                                if (!slot->pid || slot->pid == current->pid) {
+                                        islot = arg - 1;
+	                                slot = lo->slots[islot];
+                                        arg = 0;
+                                        break;
+                                }
+                        }
+                        islot = find_slot(lo, current->pid);
+                        if (islot >= 0) {
+                                slot = lo->slots[islot];
+                                break;
+                        }
+                        ENBD_ALERT("failed to find slot for pid %d for ioctl %x arg %lx\n",
+                                current->pid, cmd, arg);
+                        break;
+
+	            case MY_NBD_REG_BUF:
+	            case MY_NBD_SET_SIG:
+                        islot = find_slot(lo, current->pid);
+                        if (islot >= 0) {
+                                slot = lo->slots[islot];
+                                break;
+                        }
+                        // Otherwise they passed a buffer
+                        // and the slot number is in the first 4B
+                        // We need some magic here for safety!
+                        // set sig is the only call that really needs
+                        // to send its pid!
+                        if (!arg)
+                            break;
+                        intval = -1;
+                        // we need some magic here
+		        if (get_user (intval, (int *) arg))
+                            break;
+                        if (intval <= 0 || intval > ENBD_MAXCONN) {
+                            break;
+	                }
+                        islot = intval - 1;
+	                slot = lo->slots[islot];
+
+                        // check for following magic
+                        if (get_user (intval,
+                            (int *)(ENBD_SIGLEN + (char *)(1 + (int *) arg)))
+                                || intval != ENBD_DEV_MAGIC) {
+                            islot = -1;
+                            slot = NULL;
+                            break;
+                        }
+                        // PTB CHANGE ARG !!!!
+                        arg += sizeof(int);
+                        break;
+                }
+    } // end fixup code for post 2.5.44 no-ioctl-on-minors breakage
+       
+ 
+    ENBD_DEBUG (3, "slot is %d\n", islot);
+
+    // PTB these are all always local ioctls
+    switch (cmd) {
+	int err;
+        int intval;
+
+      case ENBD_CLEAR_SOCK:
+	ENBD_DEBUG (1, "ENBD_CLEAR_SOCK %ld\n", arg);
+        if (islot < 0) {
+	        ENBD_ALERT ("CLR_SOCK called on full device nd%s\n", lo->devnam);
+                return -EINVAL;
+        }
+	err = enbd_clr_sock (slot);
+	ENBD_DEBUG (1, "exited with %d\n", err);
+	return err;
+
+      case ENBD_SET_SOCK:
+	ENBD_DEBUG (3, "ENBD_SET_SOCK %ld\n", arg);
+        if (islot < 0) {
+	        ENBD_ALERT ("SET_SOCK called on full device nd%s\n", lo->devnam);
+                return -EINVAL;
+        }
+	err = enbd_set_sock (slot, arg);
+	ENBD_DEBUG (3, "exited with %d\n", err);
+	return err;
+
+#ifdef BLKBSZGET
+      case BLKBSZGET:
+	ENBD_DEBUG (3, "BLKBSZGET %lx\n", arg);
+#endif /* BLKBSZGET */
+      case ENBD_GET_BLKSIZE:
+	ENBD_DEBUG (3, "ENBD_GET_BLKSIZE %lx\n", arg);
+	if (!(atomic_read (&lo->flags) & ENBD_BLKSIZED)) {
+	    ENBD_DEBUG (1, "BLKBSZGET exited INVAL\n");
+	    return -EINVAL;
+	}
+	err = put_user (lo->blksize, (long *) arg);
+	ENBD_DEBUG (3, "exited OK\n");
+	return err;
+
+#ifdef BLKBSZGET
+      case BLKBSZSET:
+	ENBD_DEBUG (3, "BLKBSZSET %lx\n", arg);
+#endif /* BLKBSZSET */
+      case ENBD_SET_BLKSIZE:
+	ENBD_DEBUG (3, "ENBD_SET_BLKSIZE %lx\n", arg);
+        if (!arg)
+                return -EINVAL;
+        intval = -1;
+        if (get_user (intval, (int *)arg))
+                return -EFAULT;
+        if (intval == -1) {
+	        ENBD_ALERT ("BLKBSZSET got %d from user\n", intval);
+	}
+	err = enbd_set_blksize (lo, intval);
+	ENBD_DEBUG (3, "exited with %d\n", err);
+	return err;
+
+      case ENBD_SET_SIZE:
+	ENBD_DEBUG (3, "ENBD_SET_SIZE %ld\n", arg);
+	err = enbd_set_size (lo, (u64) arg);
+	ENBD_DEBUG (3, "exited with %d\n", err);
+	return err;
+
+      case ENBD_SET_SECTORS:
+	ENBD_DEBUG (3, "ENBD_SET_SECTORS %ld\n", arg);
+	err = enbd_set_size (lo, ((u64) arg) << 9);
+	ENBD_DEBUG (3, "exited with %d\n", err);
+	return err;
+
+      case MY_NBD_SET_INTVL:	/* WG */
+	ENBD_DEBUG (3, "MY_NBD_SET_INTVL %ld\n", arg);
+	err = my_nbd_set_intvl (lo, arg);
+	ENBD_DEBUG (3, "exited with %d\n", err);
+	return err;
+
+      case MY_NBD_SET_SPID:
+	ENBD_DEBUG (3, "MY_NBD_SET_SPID %ld\n", arg);
+        if (islot < 0) {
+	        ENBD_ALERT ("SET_SPID called on full device nd%s\n", lo->devnam);
+                return -EINVAL;
+        }
+	err = my_nbd_set_spid (slot, arg);
+	ENBD_DEBUG (3, "exited with %d\n", err);
+	return err;
+
+      case MY_NBD_SET_BUFFERWR:
+	ENBD_DEBUG (3, "MY_NBD_SET_BUFFERWR %ld\n", arg);
+	err = my_nbd_set_bufferwr (lo, arg);
+	ENBD_DEBUG (3, "exited with %d\n", err);
+	return err;
+
+      case MY_NBD_REG_BUF:	/* PTB register your buffer per socket here */
+	ENBD_DEBUG (3, "MY_NBD_REG_BUF %lx\n", arg);
+	if (!arg) {
+	    /* PTB serves as existence check for this ioctl */
+	    ENBD_DEBUG (3, "exited OK\n");
+	    return 0;
+	}
+        if (islot < 0) {
+	    ENBD_ALERT ("REG_BUF called on full device nd%s\n", lo->devnam);
+            return -EINVAL;
+        }
+	err = my_nbd_reg_buf (slot, (char *) arg);
+	ENBD_DEBUG (3, "(%d): exited with %d\n", islot, err);
+	return err;
+
+      case MY_NBD_SET_SIG:
+	ENBD_DEBUG (3, "MY_NBD_SET_SIG %lx\n", arg);
+        if (islot < 0) {
+            int sigbuf[(ENBD_SIGLEN + sizeof(int) -1)/sizeof(int)];
+	    ENBD_DEBUG (1, "SET_SIG called on full device nd%s\n", lo->devnam);
+            copy_from_user((char *)sigbuf, (char *)arg, ENBD_SIGLEN);
+	    err = enbd_set_sig (lo, sigbuf);
+	    ENBD_DEBUG (3, "(%d): exited with %d\n", islot, err);
+            return err;
+        }
+	err = my_nbd_set_sig (slot, (char *) arg);
+	ENBD_DEBUG (3, "(%d): exited with %d\n", islot, err);
+	return err;
+
+      case MY_NBD_GET_REQ:
+	ENBD_DEBUG (3, "MY_NBD_GET_REQ %lx\n", arg);
+        if (islot < 0) {
+	    ENBD_ALERT ("GET_REQ called on full device nd%s\n", lo->devnam);
+            return -EINVAL;
+        }
+	err = enbd_get_req (slot, (char *) arg);
+	ENBD_DEBUG (3, "exited with %d\n", err);
+	return err;
+
+      case MY_NBD_GET_NPORT:
+	ENBD_DEBUG (3, "MY_NBD_GET_NPORT %lx\n", arg);
+	err = enbd_get_nport (lo, (int *) arg);
+	ENBD_DEBUG (3, "exited with %d\n", err);
+	return err;
+
+      case MY_NBD_CLR_REQ:
+	ENBD_DEBUG (3, "MY_NBD_CLR_REQ %ld\n", arg);
+        if (islot < 0) {
+	    ENBD_ALERT ("CLR_REQ called on full device nd%s\n", lo->devnam);
+            return -EINVAL;
+        }
+	ENBD_DEBUG (1, "rollback queue on slot %d\n", islot);
+	enbd_rollback_all (slot);
+	err = 0;
+	ENBD_DEBUG (3, "exited with %d\n", err);
+	return err;
+
+      case MY_NBD_ERR_REQ:
+	ENBD_DEBUG (3, "MY_NBD_ERR_REQ %ld\n", arg);
+        if (islot < 0) {
+	    ENBD_ALERT ("ERR_REQ called on full device nd%s\n", lo->devnam);
+            return -EINVAL;
+        }
+	enbd_error_all (slot);
+	err = 0;
+	ENBD_DEBUG (3, "exited with %d\n", err);
+	return err;
+
+      case MY_NBD_SYNC:
+	ENBD_DEBUG (3, "MY_NBD_SYNC %ld\n", arg);
+	err = 0;
+
+        // PTB this would be better in set_sock but it may be needed here
+        // for revalidation purposes because the device may need
+        // revalidating even though we never lost the daemon?
+        if (check_partitions) {
+                int want_to_check_partitions = 0;
+                write_lock (&lo->meta_lock);
+                if ((atomic_read (&lo->flags) & ENBD_ENABLED)
+                // PTB don't launch unless we think we will do something
+                && !(atomic_read (&lo->flags) & (ENBD_VALIDATED|ENBD_VALIDATING)))
+                        want_to_check_partitions = 1;
+                write_unlock (&lo->meta_lock);
+                if (want_to_check_partitions)
+                        enbd_kernel_thread((int(*)(void*))enbd_reread_partitions, lo, CLONE_VM); 
+                        //enbd_reread_partitions(lo);
+        } else {
+                write_lock (&lo->meta_lock);
+                if (atomic_read (&lo->flags) & ENBD_ENABLED)
+                        atomic_set_mask(ENBD_VALIDATED, &lo->flags);
+                write_unlock (&lo->meta_lock);
+        }
+
+        // PTB maybe run the reenable function
+        if (1) {
+                int doit = 0;
+                write_lock(&lo->meta_lock);
+                if (lo->reenable_time != 0
+                        && time_before(lo->reenable_time,jiffies)) {
+                        // expired
+                        lo->reenable_time = 0;
+                        doit = 1;
+                } 
+                write_unlock(&lo->meta_lock);
+                if (doit)
+                        enbd_reenable(lo);
+        }
+
+	// PTB error too old reqs if show_errs is set, else roll them back
+
+	ENBD_DEBUG (2, "will do rollback old on device nd%s\n", lo->devnam);
+	enbd_rollback_old (lo);
+	ENBD_DEBUG (2, "did rollback old on device nd%s\n", lo->devnam);
+
+        // PTB opportunity to calculate speed
+	enbd_snapshot_speed (lo);
+
+	// PTB now sync the device if flags set
+	if (0 /* FIXME */ && atomic_read (&lo->flags) & ENBD_SYNC) {
+
+	    if ((long) arg > 0) {
+		enbd_sync_sync (lo);
+	    }
+	    else if ((long) arg == 0) {
+		enbd_async_sync (lo);
+	    }
+	    else if ((long) arg < 0) {
+		enbd_maybe_sync_sync (lo);
+	    }
+	}
+
+        // PTB report device state
+        if (!(atomic_read(&lo->flags) & ENBD_ENABLED))
+                err = -ENODEV;
+
+	ENBD_DEBUG (3, "exited with %d\n", err);
+	return err;
+
+      case MY_NBD_ACK:
+	ENBD_DEBUG (3, "MY_NBD_ACK %lx\n", arg);
+        if (islot < 0) {
+	    ENBD_ALERT ("ENBD_ACK called on full device nd%s\n", lo->devnam);
+            return -EINVAL;
+        }
+	err = enbd_ack (slot, (char *) arg);
+	ENBD_DEBUG (3, "exited with %d\n", err);
+	return err;
+
+	/* let this be compiled in always - it's useful. PTB */
+      case ENBD_PRINT_DEBUG:
+	ENBD_DEBUG (3, "ENBD_PRINT_DEBUG");
+	ENBD_INFO ("device %d: head = %p, tail = %p, in = %d, out = %d\n",
+		  minor,
+                  list_head (&lo->queue,struct request,queue),
+                  list_tail (&lo->queue, struct request, queue),
+                  lo->acct ?
+		  atomic_read (&lo->acct->requests_in[READ]) +
+		  atomic_read (&lo->acct->requests_in[WRITE])
+                  : 0,
+                  lo->acct ?
+		  atomic_read (&lo->acct->requests_out[READ]) +
+		  atomic_read (&lo->acct->requests_out[WRITE])
+                  : 0);
+	err = 0;
+	ENBD_DEBUG (3, "exited OK\n");
+	return err;
+      case ENBD_HARD_RESET:	/* PTB - debugging */
+	ENBD_DEBUG (3, "ENBD_HARD_RESET\n");
+	err = enbd_hard_reset ();
+	ENBD_DEBUG (3, "exited OK\n");
+	return err;
+
+      case ENBD_RESET:		/* PTB - debugging */
+	ENBD_DEBUG (3, "ENBD_RESET\n");
+	err = enbd_soft_reset (lo);
+        enbd_reenable_delay(lo, 5);
+	ENBD_DEBUG (3, "exited OK\n");
+	return err;
+
+      case ENBD_SET_MD5SUM:	/* PTB - change to do/plead md5summing */
+	ENBD_DEBUG (3, "ENBD_SET_MD5SUM %ld\n", arg);
+	if (arg) {
+	    atomic_set_mask (ENBD_MD5SUM, &lo->flags);
+	}
+	else {
+	    atomic_clear_mask (ENBD_MD5SUM, &lo->flags);
+	}
+	err = 0;
+	ENBD_DEBUG (3, "exited OK\n");
+	return err;
+
+      case MY_NBD_SET_SHOW_ERRS:	/* PTB/WG - change show error status */
+	ENBD_DEBUG (3, "ENBD_SET_SHOW_ERR %ld\n", arg);
+	if (arg) {
+	    atomic_set_mask (ENBD_SHOW_ERRS, &lo->flags);
+	} else {
+	    atomic_clear_mask (ENBD_SHOW_ERRS, &lo->flags);
+	}
+	ENBD_DEBUG (3, "exited OK\n");
+	return 0;
+
+      case MY_NBD_SET_DIRECT:	/* PTB - change o_direct status */
+	ENBD_DEBUG (3, "ENBD_SET_DIRECT %ld\n", arg);
+	if (arg) {
+	    atomic_set_mask (ENBD_DIRECT, &lo->flags);
+	} else {
+	    atomic_clear_mask (ENBD_DIRECT, &lo->flags);
+	}
+	ENBD_DEBUG (3, "exited OK\n");
+	return 0;
+
+
+      case MY_NBD_INVALIDATE:
+	ENBD_DEBUG (3, "MY_NBD_INVALIDATE %lx\n", arg);
+	err = my_nbd_set_remote_invalid (lo, (int) arg);
+	ENBD_DEBUG (3, "(%d): exited with %d\n", islot, err);
+	return err;
+
+      case ENBD_SET_PF_MEMALLOC:
+	ENBD_DEBUG (3, "ENBD_REQ_PF_MEMALLOC %lx\n", arg);
+        if (arg) {
+            current->flags |= PF_MEMALLOC;
+        } else {
+            current->flags &= ~PF_MEMALLOC;
+        }
+	return 0;
+    }
+
+    // PTB these are the standard ioctls, and we might get them from
+    // the other side
+
+    switch (cmd) {
+	int err;
+        int intval;
+
+      case BLKROSET:		/* PTB - change ro status */
+	ENBD_DEBUG (3, "BLKROSET %ld\n", arg);
+        if (get_user(intval, (int*)arg))
+                return -EFAULT;
+        // PTB local flags
+        if (intval) {
+	        atomic_set_mask (ENBD_READ_ONLY, &lo->flags);
+        }
+	else {
+	        atomic_clear_mask (ENBD_READ_ONLY, &lo->flags);
+	}
+	// PTB which device really doesn't matter. We do the checking.
+	set_device_ro (MKDEV (major, minor), intval);
+	ENBD_DEBUG (3, "exited OK\n");
+	return 0;
+
+      case BLKROGET:
+        intval =  (atomic_read(&lo->flags) & ENBD_READ_ONLY) != 0;
+        return put_user(intval, (int*)arg);
+
+      case BLKFLSBUF:
+	ENBD_DEBUG (1, "BLKFLSBUF %lx\n", arg);
+	enbd_maybe_sync_sync (lo);	// PTB normally fsync_dev
+	// PTB device likely has buffers or caches in kernel
+	ENBD_DEBUG (1, "invalidating buffers on device %d:%d\n", major, minor);
+	invalidate_buffers (MKDEV (major, minor));
+	ENBD_DEBUG (3, "invalidated buffers on device nd%s\n", lo->devnam);
+
+	if (atomic_read(&lo->flags) & ENBD_BUFFERWR) {
+	    // PTB got this from rd.c
+	    ENBD_DEBUG (1, "destroying buffers on device %d:%d\n", major,
+		       minor);
+	    destroy_buffers (MKDEV (major, minor));
+	    ENBD_DEBUG (3, "destroyed buffers on device nd%s\n", lo->devnam);
+	}
+
+	ENBD_DEBUG (3, "exited OK\n");
+	return 0;
+
+      case BLKRAGET:
+	ENBD_DEBUG (1, "BLKRAGET %lx\n", arg);
+	err = put_user (read_ahead[major], (long *) arg);
+	ENBD_DEBUG (3, "exited OK (%d)\n", err);
+	return err;
+
+      case BLKRASET:
+	ENBD_DEBUG (1, "BLKRASET %lx\n", arg);
+	if (arg > 0xff) {
+	    ENBD_DEBUG (1, "BLKRASET exited INVAL\n");
+	    return -EINVAL;
+	}
+	rahead = read_ahead[major] = arg;
+	ENBD_DEBUG (3, "exited OK\n");
+	return 0;
+
+      case BLKSSZGET:
+	ENBD_DEBUG (1, "BLKSSZGET %lx\n", arg);
+        err = put_user(512, (int*)arg);
+	ENBD_DEBUG (3, "exited OK\n");
+        return err;
+
+      case BLKSECTSET:
+        if (arg <= 0 || arg > (lo->bufsiz >> 9))  {
+	    ENBD_DEBUG (1, "BLKSECTSET exited INVAL\n");
+	    return -EINVAL;
+        }
+        set_max_sectors(lo, arg);
+	ENBD_DEBUG (3, "exited OK\n");
+	return 0;
+
+      case BLKSECTGET:
+	ENBD_DEBUG (1, "BLKSECTGET %lx\n", arg);
+        err = put_user(lo->max_sectors, (int*)arg);
+	ENBD_DEBUG (3, "exited OK\n");
+        return err;
+
+      case HDIO_GETGEO:
+	ENBD_DEBUG (1, "HDIO_GETGEO %lx\n", arg);
+	if (!arg) {
+	    ENBD_DEBUG (1, "HDIO_GETGEO exited INVAL\n");
+	    return -EINVAL;
+	}
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
+	if (1) {
+	    struct hd_geometry *geo = (struct hd_geometry *) arg;
+	    int sectors = enbd_sizes[nbd << ENBD_SHIFT] << 1;
+	    unsigned short c;
+	    unsigned char h, s;
+	    if (sectors < (1 << 22)) {
+		h = 4;
+		s = 16;
+		c = sectors >> 6;
+	    } else {
+		h = 255;
+		s = 63;
+		c = (sectors / h) / s;
+	    }
+	    err = 0;
+	    if ((err = put_user (c, &geo->cylinders), err < 0)
+		|| (err = put_user (h, &geo->heads), err < 0)
+		|| (err = put_user (s, &geo->sectors), err < 0)
+		|| (err = put_user (h, &geo->start), err < 0)) {
+		ENBD_DEBUG (1, "HDIO_GETGEO exited FAIL\n");
+		return err;
+	    }
+	}
+#else
+	err = verify_area (VERIFY_WRITE, (char *) arg,
+			   sizeof (struct hd_geometry));
+	if (err) {
+	    ENBD_DEBUG (1, "HDIO_GETGEO exited FAIL\n");
+	    return err;
+	} else {
+	    struct hd_geometry *geo = (struct hd_geometry *) arg;
+	    int sectors = enbd_sizes[nbd << ENBD_SHIFT] << 1;
+	    unsigned short c;
+	    unsigned char h, s;
+	    if (sectors < (1 << 22)) {
+		h = 4;
+		s = 16;
+		c = sectors >> 6;
+	    } else {
+		h = 255;
+		s = 63;
+		c = (sectors / h) / s;
+	    }
+	    put_user (c, &geo->cylinders);
+	    put_user (h, &geo->heads);
+	    put_user (s, &geo->sectors);
+	    put_user (h, &geo->start);
+	}
+#endif
+	ENBD_DEBUG (3, "exited OK\n");
+	return 0;
+
+      case BLKRRPART:
+	ENBD_DEBUG (1, "BLKRRPART %lx\n", arg);
+        write_lock(&lo->meta_lock);
+        if (!(atomic_read (&lo->flags) & ENBD_VALIDATING)
+          && (atomic_read (&lo->flags) & ENBD_ENABLED)) {
+                int pid;
+                write_unlock(&lo->meta_lock);
+                pid = enbd_kernel_thread((int(*)(void*))enbd_reread_partitions, lo, CLONE_VM); 
+                err = (pid < 0) ? -EINVAL : 0;
+        } else {
+                write_unlock(&lo->meta_lock);
+                err = -EINVAL;
+        }
+
+	ENBD_DEBUG (3, "exited %d\n", err);
+        return err;
+
+      case BLKGETSIZE:		/* PTB 132 */
+	/* PTB return nr sectors */
+	ENBD_DEBUG (1, "BLKGETSIZE %lx\n", arg);
+	if (!(atomic_read (&lo->flags) & ENBD_SIZED)) {
+	    ENBD_DEBUG (1, "BLKGETSIZE exited NODEV\n");
+	    return -ENODEV;
+	}
+        // PTB this is per partition 
+        if (islot < 0) {
+	        err = put_user ((unsigned long) lo->sectors,
+                        (unsigned long *) arg);
+        } else {
+	        err = put_user ((unsigned long) enbd_hd_struct[minor].nr_sects,
+                        (unsigned long *) arg);
+        }
+	// PTB this check is silly here and seems to trigger!
+	if (lo->size != 0 && (u32) (lo->bytesize >> 10) != lo->size) {
+	    ENBD_ALERT ("bytes %luKB mismatch with KB %u in BLKGETSIZE\n",
+		       (unsigned long) (lo->bytesize >> 10), lo->size);
+	}
+	else {
+	    ENBD_DEBUG (1, "bytes %luKB match with KB %u in BLKGETSIZE\n",
+		       (unsigned long) (lo->bytesize >> 10), lo->size);
+	}
+	ENBD_DEBUG (1, "exited OK (%d)\n", err);
+	return err;
+
+#ifdef BLKGETSIZE64
+      case BLKGETSIZE64:
+	/* PTB return real size in bytes */
+	ENBD_DEBUG (1, "BLKGETSIZE64 %lx\n", arg);
+	if (!(atomic_read (&lo->flags) & ENBD_SIZED)) {
+	    ENBD_DEBUG (1, "BLKGETSIZE64 exited NODEV\n");
+	    return -ENODEV;
+	} 
+        if (islot < 0) {
+	        err = put_user (lo->bytesize, (u64 *) arg);
+        } else {
+                u64 size64 = enbd_hd_struct[minor].nr_sects;
+                size64 <<= 9;
+	        err = put_user (size64, (u64 *) arg);
+        }
+	ENBD_DEBUG (1, "exited OK (%d)\n", err);
+	return err;
+#endif
+
+#ifndef BLKMDNTFY
+#define BLKMDNTFY _IOW(0x12,133,sizeof(int))
+#endif
+      case BLKMDNTFY:
+	ENBD_INFO ("received BLKMDNTFY, am now in raid %x\n", (unsigned) arg);
+	spin_lock (&md_access_lock);
+        if (md_doing_notify && md_notify_pid != current->pid) {
+                // PTB don't add if we didn't remove
+	        spin_unlock (&md_access_lock);
+                return -EBUSY;
+        }
+        md_count++;
+        // PTB count the individual partition and whole disk inclusions
+        if (slot)
+            slot->md_count++;
+        else
+            atomic_inc(&lo->md_count);
+        if (!atomic_test_and_set_mask (&lo->flags, ENBD_SHOW_ERRS)) {
+	        ENBD_INFO ("set show_errs on nd%s\n", lo->devnam);
+                atomic_set_mask (ENBD_RAID_SHOW_ERRS, &lo->flags);
+        }
+	spin_unlock (&md_access_lock);
+        return 0;
+
+#ifndef BLKMDUNTFY
+#define BLKMDUNTFY _IOW(0x12,134,sizeof(int))
+#endif
+      case BLKMDUNTFY:
+	ENBD_INFO ("received BLKMDUNTFY, now out of raid %x\n", (unsigned) arg);
+	spin_lock (&md_access_lock);
+        if (md_doing_notify && md_notify_pid != current->pid) {
+                // PTB don't remove if it's only going to be temporary
+	        spin_unlock (&md_access_lock);
+                return -EBUSY;
+        }
+        if (--md_count <= 0) {
+                md_notify_fn = NULL;
+                if (atomic_test_and_clear_mask(&lo->flags, ENBD_RAID_SHOW_ERRS)) {
+                        atomic_clear_mask (ENBD_SHOW_ERRS, &lo->flags);
+	                ENBD_INFO ("cleared show_errs on nd%s\n", lo->devnam);
+                }
+        }
+        // PTB count the individual partition and whole disk inclusions
+        if (slot)
+            slot->md_count--;
+        else
+            atomic_dec(&lo->md_count);
+	spin_unlock (&md_access_lock);
+        return 0;
+
+#ifndef BLKMDRGTR
+#define BLKMDRGTR _IOW(0x12,135,sizeof(unsigned long))
+#endif
+      case BLKMDRGTR:
+	spin_lock (&md_access_lock);
+        if (!md_notify_fn) {
+                md_notify_fn = (typeof(md_notify_fn))arg;
+        } 
+	spin_unlock (&md_access_lock);
+        return 0;
+
+    }
+
+
+    if (remote_ioctl == NULL)
+        return -EINVAL;
+
+    ENBD_DEBUG(1, "remote ioctl id %#x, len %d, bits %x, arg %lu (%lx)\n",
+            cmd & 0xffff, _IOC_SIZE(cmd), _IOC_DIR(cmd), arg, arg);
+    if (remote_ioctl->convert_inplace(&cmd) < 0) {
+            ENBD_ALERT("unauthorized ioctl %#x\n", cmd);
+            return -EINVAL;
+    }
+
+    ENBD_DEBUG(1, "ioctl converted to id %#x, len %d, bits %x, arg %lu (%lx)\n",
+            cmd & 0xffff, _IOC_SIZE(cmd), _IOC_DIR(cmd), arg, arg);
+
+    err = enbd_remote_ioctl(lo, minor, cmd, arg);
+
+    return err;
+}
+
+
+/*
+ * PTB - release the device. This happens when the last process closes
+ * or dies.
+ */
+release_t
+enbd_release (struct inode *inode, struct file *file)
+{
+    struct enbd_device *lo;
+    int dev;
+    int nbd;
+    int islot;
+
+    ENBD_DEBUG (1, "entered by pid %d\n", current->pid);
+
+    if (!inode) {
+	ENBD_ALERT ("null inode.\n");
+	ENBD_DEBUG (3, "exited NODEV\n");
+	release_return (-ENODEV);
+    }
+    dev = MINOR (inode->i_rdev);
+    nbd = dev >> ENBD_SHIFT;
+
+    /* PTB (nbd >= MAX_NBD)  is impossible as it wasn't opened  */
+
+    lo = enbd_dev[nbd];
+
+    islot = dev % ENBD_MAXCONN - 1;
+
+    ENBD_DEBUG (2, "want to release slot nd%s%d\n", lo->devnam, islot+1);
+
+    if (lo && (islot >= 0 || (islot = find_slot(lo, current->pid)) >= 0)) {
+        // PTB it's maybe a daemon closing the slot
+	    struct enbd_slot *slot = lo->slots[islot];
+
+	    --slot->refcnt;
+	    if (slot->pid == current->pid) {
+	        // PTB this was the last ref, so it's certain the daemon died
+	        int err = enbd_clr_sock (slot);
+	        slot->pid = 0;
+	        if (err < 0) {
+		        ENBD_DEBUG (2,
+			   "errored on clr_sock nd%s%d (and we don't care)\n",
+			   lo->devnam, islot + 1);
+	        }
+                if (slot->refcnt > 0) {
+                        ENBD_ALERT("slot owner process %d released slot nd%s%d while not last\n",
+			   slot->pid, lo->devnam, islot + 1);
+                }
+	    }
+
+	    ENBD_DEBUG (2, "decremented refcnt on slot nd%s%d\n",
+		   lo->devnam, islot + 1);
+    }
+
+    // PTB leave sync on close last ref to somebody else!
+
+    /* POSSIBLE change socket here PTB */
+
+    atomic_dec (&lo->refcnt);
+    ENBD_DEBUG (3, "decrement device nd%s reference count.\n", lo->devnam);
+    if (MOD_IN_USE)
+        MOD_DEC_USE_COUNT;
+
+    if (lo && (atomic_read (&lo->refcnt) <= 0 || !MOD_IN_USE)) {
+        if (atomic_read (&lo->flags) & ENBD_SHOW_ERRS) {
+                // PTB invalidate buffers on last close
+                int j;
+	        ENBD_DEBUG (2, "invalidating buffers\n");
+	        for (j = 0; j < ENBD_MAXCONN; j++) {
+	                int minor = (nbd << ENBD_SHIFT) + j;
+	                invalidate_buffers (MKDEV (major, minor));
+	        }
+	        ENBD_DEBUG (2, "destroying buffers\n");
+	        for (j = 0; j < ENBD_MAXCONN; j++) {
+	                int minor = (nbd << ENBD_SHIFT) + j;
+	                destroy_buffers (MKDEV (major, minor));
+	        }
+        }
+
+        // PTB in any case the daemons are dead!
+	lo->bufsiz = 0;
+	atomic_set (&lo->seqno_out, 0);
+    }
+
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,9) && defined(KERNEL_HAS_O_DIRECT)
+    if (file
+    &&  file->f_iobuf
+    && (file->f_flags & O_DIRECT)
+    // PTB se set NOFOLLOW to show we made iobuf
+    && (file->f_flags & O_NOFOLLOW))  {
+        free_kiovec(1, &file->f_iobuf);
+        //fops_put(file->f_op);
+        file->f_flags &= ~(O_DIRECT|O_NOFOLLOW);
+        ENBD_DEBUG(1, "have unset O_DIRECT and iobuf %p for dev nd%s%d\n",
+            file ? file->f_iobuf : NULL, lo? lo->devnam : "",
+            islot + 1);
+    }
+#endif
+
+    ENBD_DEBUG (2, "exited OK with %d requests in queue\n",
+               lo->acct ?
+	       atomic_read (&lo->acct->countq[WRITE]) +
+	       atomic_read (&lo->acct->countq[READ])
+               : 0);
+
+    if (lo && lo->lives <= 0
+            && !(atomic_read (&lo->flags) & (ENBD_ENABLED | ENBD_SIGNED))) {
+        // PTB can destroy the device as it was never enabled
+        static void enbd_destroy(struct enbd_device *lo);
+        enbd_destroy(lo);
+        enbd_dev[nbd] = NULL;
+    }
+    release_return (0);
+}
+
+
+static int
+enbd_media_changed(kdev_t dev) {
+        int minor = MINOR(dev);
+        int nbd = minor >> ENBD_SHIFT;
+        struct enbd_device *lo = enbd_dev[nbd];
+        if (!lo || lo->magic != ENBD_DEV_MAGIC)
+                return 0;
+        ENBD_ALERT("change nd%s\n", lo->devnam);
+        return (atomic_read (&lo->flags) & ENBD_VALIDATED) == 0;
+}
+
+static int
+enbd_revalidate(kdev_t dev) {
+        int minor = MINOR(dev);
+        int nbd = minor >> ENBD_SHIFT;
+        struct enbd_device *lo = enbd_dev[nbd];
+	unsigned long flags;
+        int err = -EINVAL;
+
+        if (!lo || lo->magic != ENBD_DEV_MAGIC){
+                return err;
+        }
+
+	write_lock_irqsave (&lo->meta_lock, flags);
+        ENBD_ALERT("revalidate called on nd%s\n", lo->devnam);
+        if (! (atomic_read (&lo->flags) & ENBD_REMOTE_INVALID)
+                &&    (atomic_read (&lo->flags) & ENBD_ENABLED)) {
+                        atomic_set_mask (ENBD_VALIDATED, &lo->flags);
+                        err = 0;
+        }
+	write_unlock_irqrestore (&lo->meta_lock, flags);
+
+        return err;
+}
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+static struct file_operations enbd_fops = {
+    llseek:NULL,		/* lseek - default */
+    read:block_read,		/* read - general block-dev read */
+    write:block_write,		/* write - general block-dev write */
+    readdir:NULL,		/* readdir - bad */
+    poll: NULL,			/* poll/select */
+    ioctl:enbd_ioctl,		/* ioctl */
+    mmap:NULL,			/* mmap */
+    open:enbd_open,		/* open */
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
+    flush:NULL,			/* flush */
+#endif
+    release:enbd_release,	/* release */
+    fsync:NULL,
+    fasync:NULL,
+    check_media_change:enbd_media_changed,
+    revalidate:enbd_revalidate,
+};
+#else
+static struct block_device_operations enbd_blkops = {
+    open:enbd_open,
+    release:enbd_release,
+    ioctl:enbd_ioctl,
+    check_media_change:enbd_media_changed,
+    revalidate:enbd_revalidate,
+};
+#endif
+
+/*
+ * And here should be modules and kernel interface 
+ *  (Just smiley confuses emacs :-)
+ */
+
+
+static void
+add_blockmap (int i)
+{
+
+	void ab (void) {
+                unsigned long blocks;
+		struct enbd_device *lo = enbd_dev[i];
+                if (!lo)
+                        return;
+		if (lo->nslot <= 0)
+			 return;
+		if (lo->blockmap)
+			 return;
+		 blocks = lo->size >> (lo->logblksize - 10);
+		 lo->blockmap = kmalloc (blocks >> 2, GFP_KERNEL);
+		if (!lo->blockmap)
+			 return;
+		 memset (lo->blockmap, 0xff, blocks >> 2);
+	};
+        
+        if (i >= 0 && i < MAX_NBD) {
+		ab ();
+		return;
+	}
+	// PTB add the bitmap
+	for (i = 0; i < MAX_NBD; i++) {
+		ab ();
+	}
+}
+
+static void
+del_blockmap (int i)
+{
+	void db (void) {
+		struct enbd_device *lo;
+		 lo = enbd_dev[i];
+                if (!lo)
+                        return;
+		if (!lo->blockmap)
+			 return;
+		 kfree (lo->blockmap);
+		 lo->blockmap = 0;
+	};
+        
+        if (i >= 0 && i < MAX_NBD) {
+		db ();
+		return;
+	}
+	// PTB delete the bitmap
+	for (i = 0; i < MAX_NBD; i++) {
+		db ();
+	}
+}
+
+static void
+enbd_set_blockmap (int debug, int i) {
+     if (debug)
+         add_blockmap(i);
+     else
+         del_blockmap(i);
+}
+
+static void
+set_generic (int x, int i, int X)
+{
+	void set_x (void) {
+		struct enbd_device *lo = enbd_dev[i];
+                if (!lo || lo->magic != ENBD_DEV_MAGIC)
+                        return;
+		if (x != 0) {
+			atomic_set_mask (X, &lo->flags);
+			return;
+		};
+                atomic_clear_mask (X, &lo->flags);
+	};
+
+	if (i >= 0 && i < MAX_NBD) {
+		set_x ();
+		return;
+	}
+	for (i = 0; i < MAX_NBD; i++) {
+		set_x ();
+	}
+}
+
+
+static void
+enbd_set_sync_intvl (int sync_intvl, int i)
+{
+    set_generic(sync_intvl, i, ENBD_SYNC);
+}
+
+
+static void
+enbd_set_show_errs (int show_errs, int i)
+{
+    set_generic(show_errs, i, ENBD_SHOW_ERRS);
+}
+
+static void
+enbd_set_md5sum (int md5sum, int i)
+{
+    set_generic(md5sum, i, ENBD_MD5SUM);
+}
+
+static void
+enbd_set_enabled (int enable, int i)
+{
+	void set_e (void) {
+		struct enbd_device *lo = enbd_dev[i];
+                if (!lo || lo->magic != ENBD_DEV_MAGIC)
+                        return;
+		if (enable != 0) {
+		        enbd_enable (lo);
+		        return;
+		};
+                enbd_disable(lo);
+	};
+
+        ENBD_DEBUG(1, "enable called with arg %d on device %i\n", enable, i);
+
+	if (i >= 0 && i < MAX_NBD) {
+		set_e ();
+		return;
+	}
+	for (i = 0; i < MAX_NBD; i++) {
+		set_e ();
+	}
+}
+
+
+static void
+enbd_set_direct (int direct, int i)
+{
+        set_generic(direct, i, ENBD_DIRECT);
+}
+
+static void
+enbd_zero_counters (int zs, int i)
+{
+	void z_s (void) {
+		struct enbd_device *lo = enbd_dev[i];
+                int blks;
+                if (zs == 0) {
+                    return;
+                }
+                if (!lo)
+                    return;
+                if (!lo->acct)
+                    return;
+		for (blks = 0; blks <= atomic_read (&lo->acct->maxreqblks); blks++) {
+		        atomic_set (&lo->acct->req_in[READ][blks], 0);
+		        atomic_set (&lo->acct->req_in[WRITE][blks], 0);
+	        }
+        };
+
+	if (i >= 0 && i < MAX_NBD) {
+		z_s ();
+		return;
+	}
+	for (i = 0; i < MAX_NBD; i++) {
+		z_s ();
+	}
+}
+
+
+static void
+enbd_set_buffer_writes (int buffer_writes, int i)
+{
+        set_generic(buffer_writes, i, ENBD_BUFFERWR);
+}
+
+/* ------------------------ begin proc support ----------------------------- */
+
+/*
+ * This is just to get a nice limited width integer printout in proc!
+ */
+static char *
+enbd_display (unsigned n, int endpos)
+{
+    // PTB  use endpos (<= 8) spaces at most
+    static char buf[16];
+    int units = 0;
+    int decimals = 0;
+    int decpos = endpos;
+    int wholepart = n, fractionpart = 0;
+    buf[endpos--] = 0;
+    // PTB  find the right units to display. U or K or M or G.
+    while (n >= 1 << 10) {
+	decimals = n & ((1 << 10) - 1);
+	n >>= 10;
+	units++;
+    }
+    switch (units) {
+      case 0:
+	break;
+      case 1:
+	buf[endpos--] = 'K';
+	break;
+      case 2:
+	buf[endpos--] = 'M';
+	break;
+      case 3:
+	buf[endpos--] = 'G';
+	break;
+      case 4:
+	buf[endpos--] = 'T';
+	break;
+    }
+    // after this wholepart = n && fractionpart = decimals
+    fractionpart = wholepart & ((1 << (units * 10)) - 1);
+    wholepart >>= units * 10;
+    // PTB  write the whole digits (something between 0 and 1023 inclusive)
+    if (n == 0) {
+	buf[endpos--] = '0';
+    }
+    else {
+	while (endpos >= 0 && n > 0) {
+	    buf[endpos--] = '0' + n % 10;
+	    n /= 10;
+	}
+    }
+    // PTB if there is space and cause, add decimal digits
+    if (endpos >= 1 && units > 0) {
+	int k = 0;
+	char unitchar = buf[--decpos];
+	buf[decpos + k++] = '.';
+	while (endpos >= k) {
+	    int digit = (decimals * 10) >> 10;
+	    buf[decpos + k++] = '0' + digit;
+	    decimals -= (digit << 10) / 10;
+	    decimals *= 10;
+	}
+	buf[decpos + k++] = unitchar;
+	buf[decpos + k] = 0;
+    }
+    // PTB report the start position
+    return buf + endpos + 1;
+}
+
+
+int
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
+enbd_get_info (char *buf, char **start, off_t offset, int len, int unused)
+#else
+enbd_read_proc (char *buf, char **start, off_t offset, int len, int *eof,
+	       void *data)
+#endif
+{
+
+#ifndef MIN
+#define MIN(x,y) ((x)<(y)?(x):(y))
+#endif
+
+    const int limit = MIN (PAGE_SIZE, len) - 80;
+    static int i;
+    struct enbd_device *lo;
+    static int last;
+    static void *next_label;
+    static char *next_label_name;
+    static int total;
+    unsigned long flags;
+
+    ENBD_DEBUG (2, "entered len=%d, offset=%d, next_label=%s\n",
+	       len, (int) offset, next_label_name ? : "null");
+
+    if (offset > 0 && !next_label) {
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,0)
+        if (len <= 0)
+	    *eof = 1;
+#endif
+	*start = (char *) 0;
+	ENBD_DEBUG (2, "exited OK after 0 bytes requested, total %d\n", total);
+	return 0;
+    }
+
+    if (offset <= 0) {
+	// PTB do static inits first time through
+	last = -1;
+	i = 0;
+	next_label = NULL;
+	next_label_name = NULL;
+	total = 0;
+    }
+
+    // PTB  start this bytecount
+    len = 0;
+
+    ENBD_DEBUG (2, "device=%d, last device=%d, next label %s\n",
+	       i, last, next_label_name ? : "null");
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
+#define ENBD_PROC_LABEL(n) \
+        next_label = &&label_##n; \
+        next_label_name = "label_" #n; \
+        if (len > limit) { \
+            total += len; \
+            ENBD_DEBUG (3, "short return in show device %d after %d bytes " \
+            "written to total %d bytes " \
+            "with next label %s\n", i, (int)len, total, next_label_name); \
+            return len;\
+        } \
+        ENBD_DEBUG (3, "passed %s in show device %d after %d bytes\n", \
+          next_label_name, i, (int)len); \
+        label_##n:
+#else
+#define ENBD_PROC_LABEL(n) \
+        next_label = &&label_##n; \
+        next_label_name = "label_" #n; \
+        if (len > limit) { \
+            *start = (char *) (unsigned long) len; \
+            total += len; \
+            ENBD_DEBUG (3, "short return in show device %d after %d bytes " \
+            "written to total %d bytes " \
+            "with next label %s\n", i, (int)len, total, next_label_name); \
+            return len;\
+        } \
+        ENBD_DEBUG (3, "passed %s in show device %d after %d bytes\n", \
+          next_label_name, i, (int)len); \
+        label_##n:
+#endif
+
+    for ( /* static init */ ; i < MAX_NBD; i++) {
+
+	lo = enbd_get_device(i);
+        if (!lo || lo->nslot <= 0) {
+	    next_label = NULL;
+	    continue;
+        }
+
+	// PTB computed goto next not-done
+	if (next_label) {
+	    void *label = next_label;
+	    ENBD_DEBUG (3,
+		       "did computed goto %s in show device %s on reentry\n",
+		       next_label_name, lo->devnam);
+	    next_label = NULL;
+	    next_label_name = NULL;
+	    len = 0;
+	    goto *label;
+	}
+
+	ENBD_PROC_LABEL (1);
+
+	if (last == i - 2) {
+	    char *prevdevnam = enbd_device_letter (i - 1);
+	    len += sprintf (buf + len, "Device %s:\tClosed\n", prevdevnam);
+	}
+	if (last < i - 2) {
+	    char lastdevnam[3];
+	    char prevdevnam[3];
+	    strncpy (lastdevnam, enbd_device_letter (last + 1), 3);
+	    strncpy (prevdevnam, enbd_device_letter (i - 1), 3);
+	    len += sprintf (buf + len, "Device %s-%s:\tClosed\n",
+			    lastdevnam, prevdevnam);
+	}
+
+	ENBD_PROC_LABEL (2);
+
+	len += sprintf (buf + len, "Device %s:\tOpen " "\n", lo->devnam);
+
+	ENBD_PROC_LABEL (3);
+
+	len += sprintf (buf + len,
+			"[%s] State:\t%s%s%s%s%s%s%s%s%s%s%s%s%s%slast error %d, lives %d, bp %d\n",
+			lo->devnam,
+			atomic_read (&lo->flags)
+                              & ENBD_INITIALISED ? "" : "uninitialized, ",
+			atomic_read (&lo->flags)
+                              & ENBD_SIGNED ? "signed, " : "unsigned, ",
+			atomic_read (&lo->flags)
+                              & ENBD_READ_ONLY ? "ro, " : "rw, ",
+                        enbd_get_merge_requests(lo) ? "merge requests, " : "",
+#ifndef NO_BUFFERED_WRITES
+			atomic_read (&lo->flags)
+                              & ENBD_BUFFERWR ? "buffer writes, " : "",
+#else
+			"",
+#endif		/* NO_BUFFERED_WRITES */
+			atomic_read (&lo->flags)
+                                & ENBD_ENABLED ? "enabled, " : "disabled, ",
+			atomic_read (&lo->flags)
+				& ENBD_VALIDATED ? "validated, " : "",
+			atomic_read (&lo->flags)
+                                & ENBD_REMOTE_INVALID ? "remote invalid, " : "",
+			atomic_read (&lo->flags)
+                                & ENBD_SHOW_ERRS ? "show_errs, " : "",
+			atomic_read (&lo->flags)
+                                & ENBD_DIRECT ? "direct, " : "",
+                        enbd_get_plug() ? "plug, " : "",
+			atomic_read (&lo->flags)
+                                & ENBD_SYNC ? "sync, " : "",
+			atomic_read (&lo->flags)
+                                & ENBD_MD5SUM ? "md5sum, " : "",
+			lo->acct ? "acct, " : "",
+                        lo->harderror,
+			lo->lives - ((atomic_read (&lo->flags) & ENBD_ENABLED) ? 1 : 0),
+                        0 //atomic_read(&buffermem_pages)
+                        );
+
+	ENBD_PROC_LABEL (4);
+
+	if (lo->acct) {			// PTB begin long do once block
+
+	    int countq[2]  = { 0, 0 };
+	    int lcountq[2] = { 0, 0 };
+	    int cmd;
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+	    struct request *pos;
+#else
+	    struct list_head *pos;
+#endif
+
+
+	        read_lock_irqsave (&lo->queue_lock, flags);
+
+	        ENBD_DEBUG (3, "counting queue length %d\n",
+		       atomic_read (&lo->acct->countq[WRITE]) +
+		       atomic_read (&lo->acct->countq[READ])
+                       );
+	        list_for_each (pos, &lo->queue) {
+		        struct request *req = list_entry (pos, struct request, queue);
+		        ENBD_DEBUG (3, "req %d on major queue is %x\n",
+			   countq[READ] + countq[WRITE], (unsigned) req);
+		        if (countq[READ] + countq[WRITE] > 1000)
+		                break;
+
+                        cmd = rq_data_dir(req);
+		        countq[cmd]++;
+	        }
+	        ENBD_DEBUG (3, "counted queue length %d\n",
+	        countq[READ] + countq[WRITE]);
+
+
+                lcountq[READ] = atomic_read (&lo->acct->countq[READ]);
+                lcountq[WRITE] = atomic_read (&lo->acct->countq[WRITE]);
+
+                if (countq[READ] != lcountq[READ]
+                ||  countq[WRITE] != lcountq[WRITE]) {
+		        /* PTB last ditch! HACK HACK HACK FIXME */
+		        atomic_set (&lo->acct->countq[READ], countq[READ]);
+		        atomic_set (&lo->acct->countq[WRITE], countq[WRITE]);
+	        }
+
+	        read_unlock_irqrestore (&lo->queue_lock, flags);
+
+		/* PTB last ditch! HACK HACK HACK FIXME */
+            if (countq[READ] != lcountq[READ]
+            || countq[WRITE] != lcountq[WRITE]) {
+	        ENBD_ALERT (": altered queued count to %d from %d\n",
+			   countq[READ]  +  countq[WRITE],
+			   lcountq[READ] + lcountq[WRITE]);
+            }
+
+	    ENBD_DEBUG (3, "queue length %d\n", countq[READ] + countq[WRITE]);
+	    len += sprintf (buf + len,
+			    "[%s] Queued:\t+%dR/%dW curr (check %dR/%dW) +%dR/%dW max\n",
+			    lo->devnam,
+                            lcountq[READ],
+			    lcountq[WRITE],
+                            countq[READ], countq[WRITE],
+                            atomic_read (&lo->acct->maxq[READ]),
+			    atomic_read (&lo->acct->maxq[WRITE]));
+        } // PTB end if acct
+
+	ENBD_PROC_LABEL (5);
+
+	len += sprintf (buf + len,
+			"[%s] Buffersize:\t%d\t(sectors=%d, blocks=%d)\n",
+			lo->devnam, lo->bufsiz, lo->max_sectors,
+			lo->max_sectors >> (lo->logblksize - 9));
+	len += sprintf (buf + len, "[%s] Blocksize:\t%d\t(log=%d)\n",
+			lo->devnam, lo->blksize, lo->logblksize);
+	len += sprintf (buf + len, "[%s] Size:\t%luKB\n",
+			lo->devnam, (unsigned long) (lo->bytesize >> 10));
+	len += sprintf (buf + len, "[%s] Blocks:\t%u\n",
+			lo->devnam, lo->size >> (lo->logblksize - 10));
+
+
+	ENBD_PROC_LABEL (6);
+
+
+	len += sprintf (buf + len, "[%s] Sockets:\t%d", lo->devnam, lo->nslot);
+
+	ENBD_PROC_LABEL (7);
+
+	do {			// PTB begin short do once block
+	    int j;
+	    for (j = 0; j < lo->nslot; j++) {
+		struct enbd_slot *slotj = lo->slots[j];
+		if (j != atomic_read (&lo->islot))
+		    len +=
+		     sprintf (buf + len, "\t(%s)", slotj->file ? "+" : "-");
+		else
+		    len +=
+		     sprintf (buf + len, "\t(%s)", slotj->file ? "*" : ".");
+	    }
+	} while (0);		// PTB end short do once block
+
+	len += sprintf (buf + len, "\n");
+
+	ENBD_PROC_LABEL (8);
+
+
+	ENBD_PROC_LABEL (9);
+
+        if (lo->acct) {
+
+	        int j;
+	        char buff[2][8];
+
+	        len += sprintf (buf + len, "[%s] Requested:\t%s", lo->devnam,
+			enbd_display (atomic_read (&lo->acct->requests_in[READ])
+				 + atomic_read (&lo->acct->requests_in[WRITE]), 7));
+	        for (j = 0; j < lo->nslot; j++) {
+		        struct enbd_slot *slotj = lo->slots[j];
+		        len += sprintf (buf + len, "\t(%s)", enbd_display (slotj->in, 5));
+	        }
+	        strncpy (buff[0],
+		     enbd_display (atomic_read (&lo->acct->requests_in[READ]), 6), 7);
+	        strncpy (buff[1],
+		     enbd_display (atomic_read (&lo->acct->requests_in[WRITE]), 6), 7);
+	        len += sprintf (buf + len, "\t%sR/%sW", buff[0], buff[1]);
+	        enbd_snapshot_speed (lo);
+	        len += sprintf (buf + len, "\tmax %d",
+			    atomic_read (&lo->acct->maxreqblks));
+
+	        len += sprintf (buf + len, "\n");
+        } // PTB end if acct
+
+
+	ENBD_PROC_LABEL (10);
+
+	if (lo->acct) {
+
+	    int j;
+	    char buff[2][8];
+
+	    len += sprintf (buf + len, "[%s] Despatched:\t%s", lo->devnam,
+		enbd_display (atomic_read (&lo->acct->requests_out[READ])
+			 + atomic_read (&lo->acct->requests_out[WRITE]),
+				 7));
+
+	    for (j = 0; j < lo->nslot; j++) {
+		struct enbd_slot *slotj = lo->slots[j];
+		len += sprintf (buf + len, "\t(%s)", enbd_display (slotj->out, 5));
+	    }
+	    strncpy (buff[0],
+		     enbd_display (atomic_read (&lo->acct->requests_out[READ]), 6), 7);
+	    strncpy (buff[1],
+		     enbd_display (atomic_read (&lo->acct->requests_out[WRITE]), 6), 7);
+	    len += sprintf (buf + len, "\t%sR/%sW", buff[0], buff[1]);
+	    len += sprintf (buf + len, "\tmd5 %sW",
+			    enbd_display (atomic_read (&lo->wrequests_5to), 5));
+	    len += sprintf (buf + len, " (%s eq,",
+			    enbd_display (atomic_read (&lo->wrequests_5so), 5));
+	    len += sprintf (buf + len, " %s ne,",
+			    enbd_display (atomic_read (&lo->wrequests_5wo), 5));
+	    len += sprintf (buf + len, " %s dn)",
+			    enbd_display (atomic_read (&lo->wrequests_5eo), 5));
+
+	    len += sprintf (buf + len, "\n");
+	} 	// PTB end if acct
+
+	ENBD_PROC_LABEL (11);
+
+	if (lo->acct) {
+
+	    int j;
+	    char buff[2][8];
+	    int toterrs = 0;
+
+	    len += sprintf (buf + len, "[%s] Errored:\t%s", lo->devnam,
+			enbd_display (atomic_read (&lo->acct->requests_err), 7));
+
+	    for (j = 0; j < lo->nslot; j++) {
+		struct enbd_slot *slotj = lo->slots[j];
+		len += sprintf (buf + len, "\t(%s)", enbd_display (slotj->err, 5));
+		toterrs += slotj->err;
+	    }
+	    strncpy (buff[0], enbd_display (toterrs, 6), 7);
+	    strncpy (buff[1],
+		     enbd_display (atomic_read (&lo->acct->requests_err) - toterrs, 6),
+		     7);
+	    len += sprintf (buf + len, "\t%s+%s\n", buff[0], buff[1]);
+
+	} // PTB end if acct
+
+	ENBD_PROC_LABEL (12);
+
+	if (lo->acct) {
+
+	    int pending_rblks = 0;      /* PTB  reads not reached slots yet */
+	    int pending_wblks = 0;	/* PTB  writes not reached slots yet */
+	    int blks = 0;
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+	    struct request *pos;
+#else
+	    struct list_head *pos;
+#endif
+	    int count = 0;
+	    struct request *req;
+	    int j;
+
+	        read_lock_irqsave (&lo->queue_lock, flags);
+
+	        list_for_each (pos, &lo->queue) {
+
+		    req = list_entry (pos, struct request, queue);
+		    ENBD_DEBUG (3, "req %d on major queue is %x\n", count,
+			       (unsigned) req);
+
+		    if (count++ > 1000)
+			    break;
+
+		    blks = enbd_nr_blks (req);
+		    if (blks > 0) {
+			    switch (rq_data_dir(req)) {
+			      case READ: pending_rblks += blks;
+			            break;
+			      case WRITE: pending_wblks += blks;
+			            break;
+			    }
+		    }
+
+                }
+	        read_unlock_irqrestore (&lo->queue_lock, flags);
+
+	    len += sprintf (buf + len, "[%s] Pending:\t%d", lo->devnam,
+			    atomic_read (&lo->acct->requests_req[READ]) +
+			    atomic_read (&lo->acct->requests_req[WRITE]));
+
+	    for (j = 0; j < lo->nslot; j++) {
+		    struct enbd_slot *slotj = lo->slots[j];
+		    len += sprintf (buf + len, "\t(%d)", slotj->req);
+	    }
+
+	    len += sprintf (buf + len,
+		    "\t%dR/%dW+%dR/%dW\n",
+		    atomic_read (&lo->acct->requests_req[READ]),
+		    atomic_read (&lo->acct->requests_req[WRITE]),
+		    pending_rblks, pending_wblks);
+
+	} // PTB end if acct
+
+	ENBD_PROC_LABEL (13);
+
+	do {			// PTB begin long do once block
+	    char buff[10][8];
+	    int shift = lo->logblksize;
+
+	    strncpy (buff[0],
+		     enbd_display (atomic_read (&lo->wspeed.speed) << shift, 5),
+		     7);
+	    strncpy (buff[1],
+		     enbd_display (atomic_read (&lo->wspeed.speedav) << shift, 5),
+		     7);
+	    strncpy (buff[2],
+		     enbd_display (atomic_read (&lo->wspeed.speedmax) << shift, 5),
+		     7);
+
+	    strncpy (buff[3],
+		     enbd_display (atomic_read (&lo->rspeed.speed) << shift, 5),
+		     7);
+	    strncpy (buff[4],
+		     enbd_display (atomic_read (&lo->rspeed.speedav) << shift, 5),
+		     7);
+	    strncpy (buff[5],
+		     enbd_display (atomic_read (&lo->rspeed.speedmax) << shift, 5),
+		     7);
+
+	    strncpy (buff[6],
+		     enbd_display (atomic_read (&lo->tspeed.speed) << shift, 5),
+		     7);
+	    strncpy (buff[7],
+		     enbd_display (atomic_read (&lo->tspeed.speedav) << shift, 5),
+		     7);
+	    strncpy (buff[8],
+		     enbd_display (atomic_read (&lo->tspeed.speedmax) << shift, 5),
+		     7);
+
+	    len += sprintf (buf + len, "[%s] B/s now:", lo->devnam);
+	    len += sprintf (buf + len, "\t%s\t(%sR+%sW)\n",
+			    buff[6], buff[3], buff[0]);
+	    len += sprintf (buf + len, "[%s] B/s ave:", lo->devnam);
+	    len += sprintf (buf + len, "\t%s\t(%sR+%sW)\n",
+			    buff[7], buff[4], buff[1]);
+	    len += sprintf (buf + len, "[%s] B/s max:", lo->devnam);
+	    len += sprintf (buf + len, "\t%s\t(%sR+%sW)\n",
+			    buff[8], buff[5], buff[2]);
+	} while (0);		// PTB end long do once block
+
+
+	if (lo->acct) {
+          int blks;
+          int tot_reqs = 0;
+
+	  len += sprintf (buf + len, "[%s] Spectrum:", lo->devnam);
+          for (blks = 0; blks <= atomic_read (&lo->acct->maxreqblks); blks++) {
+             tot_reqs += atomic_read (&lo->acct->req_in[READ][blks])
+                         + atomic_read (&lo->acct->req_in[WRITE][blks]);
+          }
+
+          for (blks = 0; blks <= atomic_read (&lo->acct->maxreqblks); blks++) {
+             int req_blks= atomic_read (&lo->acct->req_in[READ][blks])
+                         + atomic_read (&lo->acct->req_in[WRITE][blks]);
+             int percent = tot_reqs > 0 ? (100 * req_blks) / tot_reqs : 0;
+             if (percent <= 0)
+               continue;
+             len += sprintf (buf + len, "\t%u%%%d", percent, blks);
+          }
+	  len += sprintf (buf + len, "\n");
+	} // PTB end if acct
+
+
+	ENBD_PROC_LABEL (14);
+
+        if (lo->acct) {
+	        len += sprintf (buf + len, "[%s] Kthreads:\t%d", lo->devnam,
+			atomic_read (&lo->acct->kthreads));
+	        len += sprintf (buf + len, "\t(%d waiting/%d running/%d max)\n",
+			atomic_read (&lo->acct->kwaiters),
+			atomic_read (&lo->acct->kthreads) - atomic_read (&lo->acct->kwaiters),
+                        atomic_read (&lo->kmax));
+        }
+
+	ENBD_PROC_LABEL (15);
+
+
+	ENBD_PROC_LABEL (16);
+
+        if (lo->acct) {
+	    int j;
+
+	    len += sprintf (buf + len, "[%s] Cthreads:\t%d", lo->devnam,
+		atomic_read (&lo->acct->cthreads));
+
+	    for (j = 0; j < lo->nslot; j++) {
+		struct enbd_slot *slotj = lo->slots[j];
+		int state = ((slotj->flags & ENBD_SLOT_RUNNING) ? 1 : 0)
+		 + ((slotj->flags & ENBD_SLOT_WAITING) ? 2 : 0);
+		char *desc = "?";
+		switch (state) {
+		  case 0:
+		    desc = "-";
+		    break;	/* PTB not in */
+		  case 1:
+		    desc = "*";
+		    break;	/* PTB in and not waiting */
+		  case 2:
+		    desc = "?";
+		    break;	/* PTB impossible */
+		  case 3:
+		    desc = "+";
+		    break;	/* PTB in and waiting */
+		}
+		len += sprintf (buf + len, "\t(%s)", desc);
+	    }
+
+	    len += sprintf (buf + len, "\n");
+	} // PTB end if acct
+
+	ENBD_PROC_LABEL (17);
+
+	last = i;
+
+        if (lo->acct) {
+	        int j;
+	        len += sprintf (buf + len, "[%s] Cpids:\t%d", lo->devnam,
+			atomic_read (&lo->acct->cthreads));
+
+	        for (j = 0; j < lo->nslot; j++) {
+		        struct enbd_slot *slotj = lo->slots[j];
+		        len += sprintf (buf + len, "\t(%u)", slotj->pid);
+	        }
+	        len += sprintf (buf + len, "\n");
+	} // PTB end if acct
+
+	if (lo->acct) {
+	        int j, k;
+	        for (j = 0; j < lo->nslot; j++) {
+	                struct enbd_slot *slotj = lo->slots[j];
+	                if (slotj->spid != 0)
+                                 break;
+	        }
+                if (j < lo->nslot) {
+                        len += sprintf (buf + len, "[%s] Kpids:\t%d", lo->devnam,
+		        atomic_read (&lo->acct->cthreads));
+       	                for (k = 0; k < lo->nslot; k++) {
+                                struct enbd_slot *slotk = lo->slots[k];
+                                len += sprintf (buf + len, "\t(%u)", slotk->spid);
+       	                }
+       	                len += sprintf (buf + len, "\n");
+                }
+        } // PTB end if acct
+
+
+	ENBD_PROC_LABEL (18);
+
+
+#if DEBUG > 0
+
+	if (lo->blockmap) {
+
+	    static int j;
+	    static int blocks;
+
+	    if (blocks <= 0) {
+		// first time
+		blocks = lo->size >> (lo->logblksize - 10);
+		j = 0;
+	    }
+
+	    len += sprintf (buf + len, "[%s] blkmap:\n", lo->devnam);
+
+	    while (j < blocks) {
+		int k;
+
+		ENBD_PROC_LABEL (18_5);
+
+		len +=
+		 sprintf (buf + len, "[%s] 0x%x:\t", lo->devnam, j * lo->blksize);
+		for (k = 0; k < 64; k++) {
+		    int offset = j >> 2;
+		    int shift = (j & 3) << 1;
+		    if (j >= blocks)
+			break;
+		    switch ((lo->blockmap[offset] >> shift) & 3) {
+		      case READ:
+			len += sprintf (buf + len, "r");
+			break;
+		      case READ | 2:
+			len += sprintf (buf + len, "R");
+			break;
+		      case WRITE:
+			len += sprintf (buf + len, "w");
+			break;
+		      default:
+			len += sprintf (buf + len, ".");
+			break;
+		    }
+		    j++;
+		}
+		len += sprintf (buf + len, "\n");
+	    }
+	    j = 0;
+	}
+
+#endif
+
+	ENBD_PROC_LABEL (19);
+
+	// PTB have to tell loop head that we are not reentering 
+	next_label = NULL;
+	next_label_name = NULL;
+    }
+
+    ENBD_PROC_LABEL (20);
+
+    if (last == i - 2) {
+	char *prevnam = enbd_device_letter (i - 1);
+	len += sprintf (buf + len, "Device %s:\tClosed\n", prevnam);
+    }
+
+    if (last < i - 2) {
+	char lastnam[3];
+	char prevnam[3];
+	strncpy (lastnam, enbd_device_letter (last + 1), 3);
+	strncpy (prevnam, enbd_device_letter (i - 1), 3);
+	len += sprintf (buf + len, "Device %s-%s:\tClosed\n",
+			lastnam, prevnam);
+    }
+
+    ENBD_PROC_LABEL (21);
+
+    // PTB re-init vital statics for next time 
+    next_label = NULL;
+    next_label_name = NULL;
+
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,0)
+    if (len <= 0)
+        *eof = 1;
+#endif
+    *start = (char *)(unsigned long) len;
+    total += len;
+
+    ENBD_DEBUG (2, "exited OK after %d bytes total %d\n", len, total);
+    return len;
+}
+
+/*
+ * PTB read an int from a string. Return number of ints read (0 or 1).
+ */
+static int
+sscani (char *buf, int len, int *n)
+{
+
+    int i, a = 0;
+    short has_digits = 0;
+    short is_signed = 0;
+
+    // PTB look for first significant character
+    for (i = 0; i < len; i++) {
+	char c = buf[i];
+	if (c == ' ' || c == '\t') {
+	    if (is_signed)
+		return 0;
+	}
+	else if (c == '-') {
+	    if (is_signed)
+		return 0;
+	    is_signed = -1;
+	}
+	else if (c == '+') {
+	    if (is_signed)
+		return 0;
+	    is_signed = 1;
+	}
+	else if (c >= '0' && c <= '9') {
+	    is_signed = 1;
+	    has_digits = 1;
+	    break;
+	}
+	else {
+	    return 0;
+	}
+    }
+    // PTB i now points at first digit if there is one
+    if (!has_digits)
+	return 0;
+    for (; i < len; i++) {
+	char c = buf[i];
+	if (c < '0' || c > '9')
+	    break;
+	a *= 10;
+	a += c - '0';
+    }
+    if (is_signed >= 0)
+	*n = a;
+    else
+	*n = -a;
+    return 1;
+}
+
+/*
+ * look for a 1 or 2 letter device code ("a" or "aa") and save the
+ * device number to which it refers. Return number of device letter
+ * codes found (0 or 1).
+ */
+static int
+sscana (char *buf, int len, int *n)
+{
+
+    int i, a = 0;
+    short has_letters = 0;
+
+    for (i = 0; i < len; i++) {
+	char c = buf[i];
+	if (c >= 'a' && c <= 'z') {
+	    has_letters = 1;
+	    break;
+	}
+	else if (c == ' ') {
+	    if (has_letters)
+		return 0;
+	}
+	else {
+	    return 0;
+	}
+    }
+    if (!has_letters)
+	return 0;
+    for (; i < len; i++) {
+	char c = buf[i];
+	if (c < 'a' || c > 'z')
+	    break;
+	a *= 26;
+	a += c - 'a';
+    }
+    *n = a;
+    return 1;
+}
+
+/*
+ * read an interger (or 2-letter ascii) arg into an int. Return numner
+ * of integers read (0 or 1) and -1 for no keymatch. The first arg is a
+ * preceding key.
+ * @i is the integer value that results
+ * @j is an index if one is supplied (foo[j] = i ), else -1
+ */
+static int
+getarg (const char *buffer, int buflen, const char *key, 
+        int *i, int *j)
+{
+
+    int keylen;
+
+    void skip_ws (void) {
+	while (buflen > 0)
+	{
+	    if (*buffer != ' ' && *buffer != '\t')
+		break;
+	    buffer++;
+	    buflen--;
+	}
+    };
+
+    skip_ws ();
+
+    keylen = strlen (key);
+    if (strncmp (buffer, key, keylen))
+	return -1;
+
+    buffer += keylen;
+    buflen -= keylen;
+
+    skip_ws ();
+
+    *j = -1;
+    if (*buffer == '[') {
+        char *closing;
+        int indexlen;
+
+        buffer++;
+        buflen--;
+
+        skip_ws();
+
+        closing = strchr(buffer, ']');
+        if (!closing)
+            return -1;
+        indexlen = closing - buffer;
+        *closing = 0;
+
+        if (sscani ((char *) buffer, indexlen, j) < 1) {
+          if (sscana ((char *) buffer, buflen, j) < 1) {
+	    return 0;
+          } else {
+            ENBD_DEBUG(1, "getarg saw char index %d for key %s\n", *j,  key);
+          }
+        } else {
+          ENBD_DEBUG(1, "getarg saw int index %d for key %s\n", *j,  key);
+	  return 0;
+        }
+
+        buffer = closing;
+        buflen -= indexlen;
+
+        buffer++;
+        buflen--;
+
+        skip_ws();
+    }
+
+    if (*buffer != '=')
+	return -1;
+
+    buffer++;
+    buflen--;
+
+    skip_ws ();
+
+    if (sscani ((char *) buffer, buflen, i) < 1) {
+        if (sscana ((char *) buffer, buflen, i) < 1) {
+	    return 0;
+        } else {
+            ENBD_DEBUG(1, "getarg saw int value %d for key %s\n", *i,  key);
+        }
+    } else {
+        ENBD_DEBUG(1, "getarg saw char value %d for key %s\n", *i,  key);
+    }
+    return 1;
+}
+
+static struct procfntable {
+    char *name;
+    void (*fn)(int, int);
+} procfns[] = {
+        { "merge_requests", enbd_set_merge_requests, },
+        { "debug", enbd_set_debug, },
+        { "dbg_blockmap", enbd_set_blockmap, },
+        { "sync_intvl", enbd_set_sync_intvl, },
+        { "sync", enbd_set_sync_intvl, },
+        { "show_errs", enbd_set_show_errs, },
+        { "plug", enbd_set_plug, },
+        { "md5sum", enbd_set_md5sum, },
+        { "rahead", enbd_set_ra, },
+        { "acct", enbd_set_acct, },
+#ifndef NO_BUFFERED_WRITES
+        { "buffer_writes", enbd_set_buffer_writes, },
+#endif		/* NO_BUFFERED_WRITES */
+        { "enable", enbd_set_enabled, },
+        { "direct", enbd_set_direct, },
+        { "zero", enbd_zero_counters, },
+        { NULL, NULL, },
+};
+
+/*  
+ * PTB - write a 0 with echo -n 0 to /proc/nbdinfo to do a hard reset.
+ */
+static int
+enbd_write_proc (struct file *file, const char *buffer, unsigned long count,
+		void *data)
+{
+
+	ENBD_DEBUG (2, "entered with count %lu\n", count);
+
+	switch (count) {
+
+		int i;
+
+	  case 2:
+		if (buffer[1] != '\n')
+			break;
+		/* else fallthru to case 1 */
+	  case 1:
+		switch (*buffer) {
+		  case '1':
+			enbd_hard_reset ();
+			break;
+		  case '0':
+			for (i = 0; i < MAX_NBD; i++) {
+				//  PTB this takes the io spinlock and our spinlock.
+				struct enbd_device *lo = enbd_get_device(i);
+                                if (!lo)
+                                    continue;
+				enbd_soft_reset (lo);
+                                enbd_reenable_delay(lo, 5);
+			}
+			break;
+		}
+		break;
+	  default:
+                do {
+                        struct procfntable * ptr;
+                        int index, intval;
+                        for (ptr = &procfns[0]; ptr->name; ptr++) {
+	                        if (getarg (buffer, count, ptr->name,
+				        &intval, &index) >= 0) {
+				        break;
+			        }
+                        }
+                        if (!ptr->name) {
+			        ENBD_ERROR ("illegal %ld character command\n",
+				   count);
+			        return -EINVAL;
+                        }
+                        if (ptr->fn)
+                                ptr->fn(intval, index);
+                } while (0);
+		break;
+	}
+	ENBD_DEBUG (2, "exited OK\n");
+	return count;
+}
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+struct proc_dir_entry enbd_proc_entry = {
+    low_ino:0, namelen:7, name:"nbdinfo",
+    mode:S_IFREG | S_IRUGO | S_IWUSR,
+    nlink:1,			// LNK, DIR or FIL ?
+    uid:0, gid:0,		// uid, gid
+    size:0,			// size
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
+    get_info:&enbd_get_info,	// get_info 
+#else
+    get_info:NULL,
+#endif				/* LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0) */
+    next:NULL,			// next entry
+    parent:NULL,		// parent entry
+    subdir:NULL,		// subdir entry
+    data:NULL,			// void *data
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,0)
+    read_proc:&enbd_read_proc,
+    write_proc:&enbd_write_proc,	// write_proc
+    count:0,			// usage count
+    deleted:0,			// delete flag
+#endif
+};
+#else
+  // PTB this struct is created dynamically
+#endif		/* LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30) */
+
+int
+enbd_proc_init (void)
+{
+
+	struct proc_dir_entry *res;
+	ENBD_DEBUG (3, "creating proc entry\n");
+
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+	res =
+	 create_proc_read_entry ("nbdinfo", 0, NULL, &enbd_read_proc, NULL);
+	if (!res) {
+		ENBD_ALERT ("creation of proc entry failed\n");
+		ENBD_DEBUG (3, "exited INVAL\n");
+		return -EINVAL;
+	}
+#else
+	res = &enbd_proc_entry;
+	proc_register (&proc_root, res);
+#endif
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
+	// PTB additional write_proc entry in struct
+	res->write_proc = &enbd_write_proc;
+#endif
+        return 0;
+}
+
+void
+enbd_proc_cleanup (void)
+{
+	ENBD_DEBUG (3, "removing proc entry\n");
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+	proc_unregister (&proc_root, enbd_proc_entry.low_ino);
+#else
+	remove_proc_entry ("nbdinfo", &proc_root);
+#endif
+}
+
+/* -------------------------- end proc support ----------------------------- */
+
+
+#ifdef MODULE
+  #if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
+    MODULE_AUTHOR ("Peter T. Breuer, Andres Marin");
+    MODULE_DESCRIPTION ("Enhanced Network Block Device " ENBD_VERSION);
+    #ifdef MODULE_LICENSE
+      MODULE_LICENSE("GPL");
+    #endif
+  #endif
+#endif		/* MODULE */
+
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+// PTB we steal these from the queue struct at init
+static merge_requests_fn *ll_merge_requests_fn;
+static merge_request_fn *ll_front_merge_fn;
+static merge_request_fn *ll_back_merge_fn;
+
+/*
+ * PTB -
+ * These functions are needed when the kernel does request merging in
+ * order to stop it making requests that are bigger than our buffer.
+ *
+ * To turn OFF merging (once these functions are in place), set
+ * merge_requests=0.
+ */
+static int
+enbd_merge_requests_fn (request_queue_t * q, struct request *req,
+		       struct request *req2, int max_segments)
+{
+    int dev = MINOR (req->rq_dev);
+    int nbd = dev >> ENBD_SHIFT;
+    struct enbd_device *lo = enbd_dev[nbd];
+
+    if (!atomic_read(&lo->merge_requests))
+	return 0;
+
+    if (!ll_merge_requests_fn)
+	return 0;
+
+    if (req->nr_sectors + req2->nr_sectors > lo->max_sectors)
+	return 0;
+
+    if (req->nr_sectors + req2->nr_sectors >
+	((atomic_read(&lo->merge_requests) + 1) << (lo->logblksize - 9)))
+	return 0;
+
+    return ll_merge_requests_fn (q, req, req2, max_segments);
+}
+static int
+enbd_front_merge_fn (request_queue_t * q, struct request *req,
+		    struct buffer_head *bh, int max_segments)
+{
+    int dev = MINOR (req->rq_dev);
+    int nbd = dev >> ENBD_SHIFT;
+    struct enbd_device *lo = enbd_dev[nbd];
+
+    if (!atomic_read(&lo->merge_requests))
+	return 0;
+
+    if (!ll_front_merge_fn)
+	return 0;
+
+    if (req->nr_sectors > lo->max_sectors)
+	return 0;
+
+    if (req->nr_sectors > ((atomic_read(&lo->merge_requests) + 1) << (lo->logblksize - 9)))
+	return 0;
+
+    return ll_front_merge_fn (q, req, bh, max_segments);
+}
+static int
+enbd_back_merge_fn (request_queue_t * q, struct request *req,
+		   struct buffer_head *bh, int max_segments)
+{
+    int dev = MINOR (req->rq_dev);
+    int nbd = dev >> ENBD_SHIFT;
+    struct enbd_device *lo = enbd_dev[nbd];
+
+    if (!atomic_read(&lo->merge_requests))
+	return 0;
+
+    if (!ll_back_merge_fn)
+	return 0;
+
+    if (req->nr_sectors > lo->max_sectors)
+	return 0;
+
+    if (req->nr_sectors > ((atomic_read(&lo->merge_requests) + 1) << (lo->logblksize - 9)))
+	return 0;
+
+    return ll_back_merge_fn (q, req, bh, max_segments);
+}
+
+#endif		// LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+
+
+
+// PTB - and now to play with the sysctl interface ...
+static struct ctl_table_header *enbd_table_header;
+// the above was set by the register call of the root table
+static ctl_table enbd_table[] = {
+    {1, "rahead",
+     &rahead, sizeof (int), 0644, NULL, &proc_dointvec},
+    {2, "plug",
+     &plug, sizeof (int), 0644, NULL, &proc_dointvec},
+    {3, "sync_intvl",
+     &sync_intvl, sizeof (int), 0644, NULL, &proc_dointvec},
+    {4, "merge_requests",
+     // PTB FIXME needs proc_doatomicintvec
+     (int*)&atomic_merge_requests.counter, sizeof (int), 0644, NULL, &proc_dointvec},
+    {5, "md5sum",
+     &md5sum, sizeof (int), 0644, NULL, &proc_dointvec},
+    {6, "debug",
+     &debug, sizeof (int), 0644, NULL, &proc_dointvec},
+    {7, "paranoia",
+     &paranoia, sizeof (int), 0644, NULL, &proc_dointvec},
+    {8, "md5_on_threshold",
+     &md5_on_threshold, sizeof (int), 0644, NULL, &proc_dointvec},
+    {9, "md5_off_threshold",
+     &md5_off_threshold, sizeof (int), 0644, NULL, &proc_dointvec},
+    {0}
+};
+static ctl_table enbd_dir_table[] = {
+    {6, "enbd", NULL, 0, 0555, enbd_table},
+    {0}
+};
+static ctl_table enbd_root_table[] = {
+    {CTL_DEV, "dev", NULL, 0, 0555, enbd_dir_table},
+    {0}
+};
+
+#ifdef CONFIG_DEVFS_FS
+static devfs_handle_t devfs_handle;
+static devfs_handle_t devfs_handles[MAX_NBD];
+#endif
+
+
+static void
+acct_remove(struct enbd_device *lo) {
+        if (!lo->acct)
+            return;
+        acct_destroy(lo->acct);
+        lo->acct = NULL;
+}
+static void
+enbd_destroy(struct enbd_device *lo) {
+        int j;
+	for (j = ENBD_MAXCONN - 1; j >= 0; j--) {	/* PTB */
+	    struct enbd_slot *slot;
+            write_lock(&lo->meta_lock);
+	    slot = lo->slots[j];
+            if (slot) {
+                lo->slots[j] = NULL;
+                kfree(slot);
+            }
+            acct_remove(lo);
+            write_unlock(&lo->meta_lock);
+	}
+}
+
+
+
+static int
+enbd_setup(struct enbd_device *lo, int i) {
+        int j;
+
+	memset (lo, 0, sizeof (struct enbd_device));
+	lo->magic = ENBD_DEV_MAGIC;
+
+	lo->nbd = i;
+	strncpy (lo->devnam, enbd_device_letter (i), 4);
+	for (j = 0; j < ENBD_MAXCONN; j++) {	/* PTB */
+	    struct enbd_slot *slot = lo->slots[j];
+            if (!slot) {
+                lo->slots[j] = slot = kmalloc(sizeof(*slot), GFP_KERNEL);
+                if (slot) {
+                    memset((char*)slot, 0, sizeof(*slot));
+                } else {
+                    while (--j >= 0) {
+	                slot = lo->slots[j];
+	                lo->slots[j] = NULL;
+                        if (slot) kfree(slot);
+                    }
+                    return -ENOMEM;
+                }
+            }
+            slot->lo = lo;
+	    slot->i = j;
+	    INIT_LIST_HEAD (&slot->queue);
+	}
+	lo->blksize = 1024;	/* PTB 132 */
+	lo->logblksize = 10;	/* PTB */
+	lo->bytesize = 0x7fffffff00000;	/* PTB 132 */
+	lo->size = 0x7fffffff;	/* PTB (bytesizes >> 10) */
+	lo->sectors = 0xfffffffe;	/* PTB sectors */
+	lo->req_timeo = ENBD_REQ_TIMEO;	/* PTB default pulse intvl */
+	lo->max_sectors = buf_sectors;
+
+        lo->acct = acct_create();
+
+	INIT_LIST_HEAD (&lo->queue);
+	rwlock_init (&lo->queue_lock);
+	rwlock_init (&lo->meta_lock);
+	init_waitqueue_head (&lo->wq);
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+        INIT_LIST_HEAD (&lo->req.queue);
+#endif
+
+	init_waitqueue_head (&lo->req_wq);
+        init_MUTEX(&lo->req_sem);
+        init_MUTEX(&lo->pid_sem);
+
+	for (j = 0; j < ENBD_MAXCONN; j++) {
+	    enbd_blksizes[i * ENBD_MAXCONN + j] = lo->blksize;
+	    enbd_bytesizes[i * ENBD_MAXCONN + j] = lo->bytesize;
+	    enbd_sizes[i * ENBD_MAXCONN + j] = lo->size;
+	    enbd_max_sectors[i * ENBD_MAXCONN + j] = lo->max_sectors;
+	}
+	if (md5sum) {
+	    atomic_set_mask (ENBD_MD5SUM, &lo->flags);
+	}
+	if (sync_intvl) {
+	    atomic_set_mask (ENBD_SYNC, &lo->flags);
+	}
+	if (show_errs) {
+	    atomic_set_mask (ENBD_SHOW_ERRS, &lo->flags);
+	}
+	if (direct) {
+	    atomic_set_mask (ENBD_DIRECT, &lo->flags);
+	}
+	if (buffer_writes) {
+	    atomic_set_mask (ENBD_BUFFERWR, &lo->flags);
+	}
+        if (atomic_read(&atomic_merge_requests)) {
+            atomic_set(&lo->merge_requests,atomic_read(&atomic_merge_requests));
+        }
+        return 0;
+
+}
+
+#ifdef CONFIG_DEVFS_FS
+static void
+enbd_devfs_init (void)
+{
+
+	int i;
+	ENBD_DEBUG (3, "creating devfs entry\n");
+	devfs_handle = devfs_mk_dir (NULL, "nd", NULL);
+	if (!devfs_handle)
+		return;
+	for (i = 0; i < MAX_NBD; i++) {
+		int j;
+		// PTB make the directory "a" "b" etc.
+		devfs_handles[i] =
+		 devfs_mk_dir (devfs_handle, enbd_device_letter (i), NULL);
+		// PTB add the blk specials, called "0" "1" to ENBD_MAXCONN-1
+		if (devfs_handles[i]) {
+			devfs_register_series (devfs_handles[i],
+					       "%u", ENBD_MAXCONN,
+					       DEVFS_FL_DEFAULT,
+					       major,
+					       i * ENBD_MAXCONN,
+					       S_IFBLK | S_IRUSR | S_IWUSR,
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+					       &enbd_blkops,
+#else
+					       &enbd_fops,
+#endif
+					       NULL);
+		}
+		// PTB do the whole disk symlink ..
+		devfs_mk_symlink (devfs_handles[i], "disc",
+				  DEVFS_FL_DEFAULT, "0", NULL, NULL);
+		// PTB .. and the channel symlinks
+		for (j = 1; j < MAX_NBD; j++) {
+			char link[4];
+			char name[8];
+			sprintf (link, "%u", j);
+			sprintf (name, "part%u", j);
+			devfs_mk_symlink (devfs_handles[i], name,
+					  DEVFS_FL_DEFAULT, link,
+					  NULL, NULL);
+		}
+	}
+}
+#endif		/* CONFIG_DEVFS_FS */
+
+int __init
+enbd_init (void)
+{
+    ENBD_DEBUG (3, "entered\n");
+
+    ENBD_INFO ("Network Block Device support by pavel@elf.mj.gts.cz\n");
+    ENBD_INFO ("Network Block Device port to 2.0 by ptb@it.uc3m.es\n");
+    ENBD_INFO ("Network Block Device move networking to user space by "
+                 "amarin@it.uc3m.es\n");
+    ENBD_INFO ("Enhanced Network Block Device " ENBD_VERSION " by "
+	         "ptb@it.uc3m.es\n");
+
+    down(&enbd_sem);
+
+    // PTB make queue instead of borrowing it as a start on independt queues
+    enbd_queue = BLK_DEFAULT_QUEUE(major);
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+    if (register_blkdev (major, "enbd", &enbd_fops)) {
+#else
+    if (register_blkdev (major, "enbd", &enbd_blkops)) {
+#endif
+	ENBD_ERROR ("Unable to register major number %d for ENBD\n", major);
+        up(&enbd_sem);
+	return -EIO;
+    }
+
+#ifdef MODULE
+    ENBD_INFO ("registered ENBD at major %d\n", major);
+#endif
+    blksize_size[major] = enbd_blksizes;	/* blksize in B */
+    blk_size[major] = enbd_sizes;	/* size in KB */
+    max_sectors[major] = enbd_max_sectors;	/* max per request */
+
+// PTB - set up kernel queue struct with default methods
+    blk_init_queue (enbd_queue, do_nbd_request);
+// PTB - I think that put:
+//     - q->plug_device_fn    = generic_plug_device    (static ll_rw_blk)
+//     - q->plug_tq.routine   = generic_unplug_device  (static ll_rw_blk)
+//     - q->back_merge_fn     = ll_back_merge_fn       (static ll_rw_blk)
+//     - q->front_merge_fn    = ll_front_merge_fn      (static ll_rw_blk)
+//     - q->merge_requests_fn = ll_merge_requests_fn   (static ll_rw_blk)
+//     - q->request_fn        = do_nbd_request         (param)
+
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
+// PTB - we have to do some more init magic in 2.4.*. This says that we
+//     - take all stuff off the kernel queue before processing it, so in
+//     - particular it's OK for kernel to do merges with the queue head.
+    blk_queue_headactive (enbd_queue, 0);
+
+#endif
+
+// LA - moved the next #if higher;
+//    - kernel 2.2.* doesn't know about plug_device_fn
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+
+    atomic_set(&atomic_merge_requests, merge_requests);
+    // PTB control merge attempts so we don't overflow our buffer
+    ll_merge_requests_fn = enbd_queue->merge_requests_fn;
+    ll_front_merge_fn = enbd_queue->front_merge_fn;
+    ll_back_merge_fn = enbd_queue->back_merge_fn;
+
+// JSA - Add this line because under >=2.4.1, merge optimizations are in flux
+// PTB - however it's not this which does damage, I believe. Data: plugging
+//     - simply has to be enabled in these kernels. Without it, requests just
+//     - sit on the kernel queue and never come off and into our request_fn.
+// PTB - commented the ifdef again after talks with Jens Axboe.
+//     - Apparently plug_fn will disappear in 2.4.4 and merge functions are
+//       the only way to control merges, so they MUST be included.
+//#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,1)
+// PTB - The functions below just impose our own stricter size limit before
+//     - calling the defaults if all seems OK sizewise.
+
+    enbd_queue->merge_requests_fn = &enbd_merge_requests_fn;
+    enbd_queue->front_merge_fn = &enbd_front_merge_fn;
+    enbd_queue->back_merge_fn = &enbd_back_merge_fn;
+
+//#endif // LINUX_VERSION_CODE < KERNEL_VERSION(2,4,1) 
+
+#endif
+
+    read_ahead[major] = rahead;	/* AMARIN/PTB */
+
+    enbd_gendisk.major        = major;
+    enbd_gendisk.major_name   = "nd";
+    enbd_gendisk.minor_shift  = ENBD_SHIFT;
+    enbd_gendisk.max_p        = ENBD_MAXCONN;
+    //enbd_gendisk.max_nr       = MAX_NBD;
+    //enbd_gendisk.init         = NULL;
+    enbd_gendisk.part         = enbd_hd_struct;
+    enbd_gendisk.sizes        = enbd_sizes;
+    enbd_gendisk.nr_real      = 0;
+    enbd_gendisk.real_devices = NULL;
+    enbd_gendisk.next         = NULL;
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+    enbd_gendisk.fops         = &enbd_blkops;
+#ifdef CONFIG_DEVFS_FS
+    enbd_gendisk.de_arr       = devfs_handles;
+#endif
+#endif
+    add_gendisk(&enbd_gendisk);
+
+    enbd_proc_init();
+
+#ifdef CONFIG_DEVFS_FS
+    enbd_devfs_init();
+#endif		/* CONFIG_DEVFS_FS */
+
+    // PTB - sysctl interface
+    enbd_table_header = register_sysctl_table (enbd_root_table, 1);
+
+
+    spin_lock_init(&md_access_lock);
+
+    up(&enbd_sem);
+
+    ENBD_DEBUG (3, "exited OK\n");
+    return 0;
+
+}
+
+#ifdef CONFIG_DEVFS_FS
+static void
+enbd_devfs_cleanup (void)
+{
+        int i;
+	if (!devfs_handle)
+		return;
+	for (i = 0; i < MAX_NBD; i++) {
+		int j;
+		if (!devfs_handles[i])
+			continue;
+		for (j = 0; j < ENBD_MAXCONN; j++) {
+			devfs_handle_t x;
+			char s[3];
+			s[0] = '0' + j;
+			s[1] = 0;
+			if (j >= 10) {
+				s[0] = '1';
+				s[1] = '0' + (j - 10);
+				s[2] = 0;
+			}
+			x = devfs_find_handle (devfs_handles[i], s,
+					       major,
+					       i * ENBD_MAXCONN + j,
+					       DEVFS_SPECIAL_BLK, 0);
+			if (x)
+				devfs_unregister (x);
+		}
+		// PTB should we also search for links? No - they're not inodes
+		devfs_unregister (devfs_handles[i]);
+	}
+	devfs_unregister (devfs_handle);
+}
+#endif /* CONFIG_DEVFS_FS */
+
+void __exit
+enbd_cleanup (void)
+{
+    int i;
+
+
+    down(&enbd_sem);
+
+    for (i = 0; i < MAX_NBD; i++) {
+
+	struct enbd_device *lo = enbd_dev[i];
+	int j;
+
+        if (!lo || !(atomic_read (&lo->flags) & ENBD_INITIALISED))
+	    continue;
+
+	ENBD_INFO ("invalidating buffers on device nd%s%d-%d\n",
+		  lo->devnam, 0, ENBD_MAXCONN);
+
+	for (j = 0; j < ENBD_MAXCONN; j++) {
+	    int minor = i * ENBD_MAXCONN + j;
+	    invalidate_buffers (MKDEV (major, minor));
+	}
+
+	ENBD_INFO ("destroying buffers on device nd%s%d-%d\n",
+		  lo->devnam, 0, ENBD_MAXCONN);
+
+	for (j = 0; j < ENBD_MAXCONN; j++) {
+	    int minor = i * ENBD_MAXCONN + j;
+            struct enbd_device * lo = enbd_dev[i];
+            if (!lo)
+                continue;
+	    destroy_buffers (MKDEV (major, minor));
+	}
+    }
+
+    unregister_sysctl_table (enbd_table_header);
+
+#ifdef CONFIG_DEVFS_FS
+    enbd_devfs_cleanup();
+#endif
+
+    enbd_proc_cleanup();
+
+    del_gendisk(&enbd_gendisk);
+
+    for (i = 0; i < MAX_NBD; i++) {
+	struct enbd_device *lo = enbd_dev[i];
+        if (!lo)
+            continue;
+	atomic_clear_mask (ENBD_ENABLED, &lo->flags);
+	ENBD_DEBUG (3, "disabled device nd%s\n", lo->devnam);
+	if (lo->blockmap) {
+	    kfree (lo->blockmap);
+	    lo->blockmap = NULL;
+	}
+	enbd_sync_sync (lo);
+        enbd_dev[i] = NULL;
+        enbd_destroy(lo);
+        kfree(lo);
+    }
+
+    blk_cleanup_queue (enbd_queue);
+    blk_size[major] = NULL;
+    read_ahead[major] = 0;
+
+    if (unregister_blkdev (major, "enbd") != 0) {
+	ENBD_ALERT ("cleanup_module failed\n");
+    } else {
+	ENBD_INFO ("module cleaned up.\n");
+    }
+    up(&enbd_sem);
+}
+
+module_init (enbd_init);
+module_exit (enbd_cleanup);
+
+/* Compile line:
+
+ *  gcc -O2 -D__KERNEL__ -DMODULE -xc -c nbd.c -o nbd.o
+ *
+ *  (possibly with -DMODVERSIONS also). PTB
+ */
--- linux-2.4.17rc2-xfs/drivers/block/enbd_bufferwr.c.pre-enbd	Sat Mar 29 18:29:42 2003
+++ linux-2.4.17rc2-xfs/drivers/block/enbd_bufferwr.c	Sat Sep  6 19:52:55 2003
@@ -0,0 +1,240 @@
+
+#include <linux/major.h>
+#include <linux/module.h>
+#include <linux/version.h>
+#include <linux/fs.h>
+#include <linux/stat.h>
+#include <linux/errno.h>
+#include <linux/fd.h>
+#include <linux/wrapper.h>
+#include <linux/init.h>
+#include <linux/blkdev.h>
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,0)
+  #include <linux/iobuf.h>
+#endif
+#include <linux/sched.h>
+#include <linux/file.h>
+#include <linux/pagemap.h>
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
+  #define rq_data_dir(req) ((req)->cmd & 0x01)
+#endif
+#define __NBD_FILE "enbd_bufferwr.c"
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)
+  #define  init_waitqueue_head(x) *(x) = NULL
+  typedef struct wait_queue *wait_queue_head_t;
+#endif
+
+#include <linux/enbd.h>
+#ifndef KERNEL_VERSION
+#define KERNEL_VERSION(a,b,c)  (((a) << 16) + ((b) << 8) + (c))
+#endif
+
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,9) 
+  // BH_Protected disappeared somewhere around 2.4.10
+  #define mark_buffer_protected(rbh) \
+      { \
+  	mark_buffer_dirty (rbh); \
+  	mark_buffer_uptodate (rbh, 1); \
+  	refile_buffer (rbh); \
+       }
+
+#endif
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
+// LA a hack to allow the (writebuffer) code to compile w/ kernel 2.2
+// these are not defined in 2.2.*;
+// these definitions are taken from kernel source 2.4.*/include/linux/fs.h:
+#define bh_kmap(bh)     ((bh)->b_data)
+#define bh_kunmap(bh)   do { } while (0)// and these from include/linux/fs.h:
+// PTB grrrr. They're now back in 2.2.20
+/*
+#define atomic_set_buffer_protected(bh) test_and_set_bit(BH_Protected, &(bh)->b_state)
+#define mark_buffer_protected(bh) \
+        if (!atomic_set_buffer_protected(bh)) \
+                refile_buffer(bh)
+
+*/
+#endif
+
+
+
+extern int
+enbd_register_bufferwr(int (*f)(struct enbd_device *,struct request *));
+extern int
+enbd_unregister_bufferwr(int (*f)(struct enbd_device *,struct request *));
+
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,9) 
+  /*
+   * Magic function from rd.c that we hope saves a buffer head
+   * permanently somewhere in the kernel VM system.
+   */
+  static int
+  buffered_write_pagecache_IO(struct buffer_head *sbh, struct address_space *mapping) {
+        unsigned long index;
+        int offset, size, err;
+        err = 0;
+
+
+        // PTB index appears to be the page number
+        index = sbh->b_rsector >> (PAGE_CACHE_SHIFT - 9);
+        // PTB offset is in bytes, and says where in the page the sector starts
+        offset = (sbh->b_rsector << 9) & ~PAGE_CACHE_MASK;
+        // PTB well, an abbreviation for the buffer size, in bytes
+        size = sbh->b_size;
+
+        do {
+            // PTB we mark each page that we should write to Uptodate
+            
+            int count;
+            struct page ** hash;
+            struct page * page;
+            char * src, * dst;
+
+            int unlock = 0;
+
+            // PTB ummm, how much of the page is left to traverse
+            count = PAGE_CACHE_SIZE - offset;
+            // PTB reduce it to how much we actually need to traverse
+            if (count > size)
+                count = size;
+            // PTB say NOW? that we have traversed what we want of the page
+            size -= count;
+
+            hash = page_hash(mapping, index);
+            page = __find_get_page(mapping, index, hash);
+
+            if (!page) {
+                // PTB we get to make a new page
+                page = grab_cache_page(mapping, index);
+                if (!page) {
+                    // PTB failed to get new page
+                    err = -ENOMEM;
+                    goto out;
+                }
+                // PTB magic
+                if (!Page_Uptodate(page)) {
+                    memset(kmap(page), 0, PAGE_CACHE_SIZE);
+                    kunmap(page);
+                    SetPageUptodate(page);
+                }
+                // PTB the new page is locked. We need to unlock it later
+                unlock = 1;
+            }
+
+            // PTB prepare already for next page
+            index++;
+
+            // PTB set up for copy
+            dst = kmap(page);
+            dst+= offset;
+            src = bh_kmap(sbh);
+
+            // PTB prepare for next round
+            offset = 0;
+
+            // PTB do a copy
+            memcpy(dst, src, count);
+
+            kunmap(page);
+            bh_kunmap(sbh);
+
+            if (unlock) {
+                UnlockPage(page);
+            }
+            SetPageDirty(page);
+            __free_page(page);
+
+        } while (size > 0);
+
+out:
+        return err;
+
+  }
+#endif
+
+#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,9) 
+static int
+buffered_write (struct enbd_device *lo, struct request *req)
+{
+
+    struct buffer_head *bh;
+    struct address_space * mapping = lo->inode->i_mapping;
+    int err = 0;
+
+    // PTB go through and copy and protect the written buffers
+    for (bh = req->bh; bh; bh = bh->b_reqnext) {
+	struct buffer_head *rbh;
+	rbh =
+	 getblk (bh->b_rdev, bh->b_rsector / (bh->b_size >> 9), bh->b_size);
+	if (bh != rbh) {
+	    char *bdata = bh_kmap (bh);
+	    memcpy (rbh->b_data, bdata, rbh->b_size);
+	}
+	bh_kunmap (bh);
+	mark_buffer_protected (rbh); // PTB equals dirty, uptodate
+        // PTB we need to save the /dev/nda inode
+        err = buffered_write_pagecache_IO(bh, mapping);
+        if (err < 0) {
+            break;
+        }
+	brelse (rbh);
+    }
+    return err;
+}
+#else
+static int
+buffered_write (struct enbd_device *lo, struct request * req)
+{
+
+    struct buffer_head *bh;
+
+    // PTB go through and copy and protect the written buffers
+    for (bh = req->bh; bh; bh = bh->b_reqnext) {
+	struct buffer_head *rbh;
+	char *bdata;
+	rbh =
+	 getblk (bh->b_rdev, bh->b_rsector / (bh->b_size >> 9), bh->b_size);
+	bdata = bh_kmap (bh);
+	if (bh != rbh) {
+	    memcpy (rbh->b_data, bdata, rbh->b_size);
+	}
+	bh_kunmap (bh);
+	mark_buffer_protected (rbh);
+	brelse (rbh);
+
+    }
+    return 0;
+}
+#endif /* LINUX_VERSION_CODE > KERNEL_VERSION(2,4,9)  */
+
+
+
+static int __init
+enbd_bufferwr_init (void)
+{
+    enbd_register_bufferwr(&buffered_write);
+    return 0;
+}
+
+static void __exit
+enbd_bufferwr_cleanup (void) {
+    enbd_unregister_bufferwr(&buffered_write);
+}
+
+module_init (enbd_bufferwr_init);
+module_exit (enbd_bufferwr_cleanup);
+
+int linux_version_code = LINUX_VERSION_CODE;
+
+#ifdef MODULE
+  #if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
+    MODULE_AUTHOR ("Peter T. Breuer");
+    MODULE_DESCRIPTION ("Enhanced Network Block Device Local Buffered Writes driver");
+    #ifdef MODULE_LICENSE
+      MODULE_LICENSE("GPL");
+    #endif
+  #endif
+#endif		/* MODULE */
+
+
+
--- linux-2.4.17rc2-xfs/drivers/block/enbd_ioctl.c.pre-enbd	Sat Mar 29 18:29:42 2003
+++ linux-2.4.17rc2-xfs/drivers/block/enbd_ioctl.c	Sat Sep  6 19:53:00 2003
@@ -0,0 +1,424 @@
+#ifndef __KERNEL__
+#include <sys/time.h>
+#include <unistd.h>
+#endif
+
+#include <linux/ioctl.h>
+#include <linux/fs.h>
+#include <linux/fd.h>
+#ifndef _CADDR_T
+#define caddr_t char*
+#endif
+#include <linux/cdrom.h>
+#include <asm/uaccess.h>
+#include <linux/module.h>
+#include <linux/version.h>
+#include <linux/init.h>
+#ifndef KERNEL_VERSION
+#define KERNEL_VERSION(a,b,c)  (((a) << 16) + ((b) << 8) + (c))
+#endif
+#include <linux/blk.h>
+#define __NBD_FILE "enbd_ioctl.c"
+
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)
+  #define  init_waitqueue_head(x) *(x) = NULL
+  typedef struct wait_queue *wait_queue_head_t;
+#endif
+
+#include <linux/enbd.h>
+#include <linux/enbd_ioctl.h>
+
+
+/*
+ * This is the whitelist of remote ioctls - an entry here tells the
+ * driver that it's OK to send this ioctl out over the net, because we
+ * have the right info on it.
+ *
+ * "The right info" is what is on the right hand side of the table (a 0
+ * stands for a repetition of the LHS info). We have to fixup something
+ * that a lot of kernel authors forgot to do or got worng - namely
+ * declare their ioctls in a way that conveys information about their
+ * intended mode of use (see iotcl.h in the kernel sources).
+ *
+ * We need all ioctls to be delared as either
+ *
+ *    _IO(class,id)         -- default. Means no args. The call is enough.
+ *    _IOW(class,id,type)   -- we write a value to kernel that is sizeof(type)
+ *    _IOR(class,id,type)   -- we read a value from kernel sizeof(type)
+ *    _IOWR(class,id,type)  -- ibid, but both ways
+ *
+ *  The "R" bit is crucial because it lets us know that the data is
+ *  _indirected_. I.e. it's an address of somewhere in userspace where
+ *  we want to read data from or write data to. 
+ *
+ *  The "type" part should be the type of the indirected argument, NOT
+ *  the type of its address!
+ *
+ *  Kernel authors typically make two mistakes:
+ *
+ *     1) they write _IO instead of _IOR or IOWR, and hence forget the
+ *        type info. Well, not telling me if the argument data is
+ *        direct or indirectly accessible was already bad enough!
+ *     2) they get the type argument _wrong_ when they do remember to
+ *        put it. They write "int *" instead  of "int", for example,
+ *        when the argument to the ioctl is a pointer to an integer.
+ *        OK, so it's a natural mistake to make! But in that case the
+ *        argument should be "int" so that the kernel macro picks up
+ *        sizeof(int) instead of sizeof(int*).
+ *
+ *  Those "errors" have to be repaired via this table. Wrong at left,
+ *  corrected at right. A 0 for the new entry indicates that the old
+ *  was alright. If there isn't an entry, the ioctl won't be treated.
+ *  If the size info works out at the max for the field  (2^14 - 1)
+ *  then a extra table is consulted for size and copy methods.
+ */
+
+
+// PTB the space before the final comma is important as the ##
+// discards the preceding token when D is empty
+#define _NEW_IO_(B,C,D...) C(_IOC_TYPE(B), _IOC_NR(B) , ## D)
+#define _NEW_IO(B,D...)   _IO(_IOC_TYPE(B), _IOC_NR(B) , ## D)
+#define _NEW_IOW(B,D...)  _IOW(_IOC_TYPE(B), _IOC_NR(B) , ## D)
+#define _NEW_IOR(B,D...)  _IOR(_IOC_TYPE(B), _IOC_NR(B) , ## D)
+#define _NEW_IOWR(B,D...) _IOWR(_IOC_TYPE(B), _IOC_NR(B) , ## D)
+#define _NEW_IORS(B) _IOC(_IOC_READ,_IOC_TYPE(B), _IOC_NR(B), _IOC_SIZEMASK)
+#define _NEW_IOWRS(B) _IOC(_IOC_READ|_IOC_WRITE,_IOC_TYPE(B), _IOC_NR(B), _IOC_SIZEMASK)
+
+static struct ioctl_conv ioctl_conv_tab[] = {
+// fs.h
+   { BLKROSET, _NEW_IOW(BLKROSET,int), },
+   { BLKROGET, _NEW_IOR(BLKROGET,int), },
+//#define BLKRRPART  _IO(0x12,95) /* re-read partition table */
+   { BLKRRPART,  0, },
+   { BLKGETSIZE, _NEW_IOR(BLKGETSIZE,int), },
+//#define BLKFLSBUF  _IO(0x12,97) /* flush buffer cache */
+   { BLKFLSBUF,  0, },
+   { BLKRASET,   _NEW_IOW(BLKRASET,int), },
+   { BLKRAGET,   _NEW_IOR(BLKRAGET,int), },
+   { BLKFRASET,  _NEW_IOW(BLKFRASET,int), },
+   { BLKFRAGET,  _NEW_IOR(BLKFRAGET,int), },
+   { BLKSECTSET, _NEW_IOW(BLKSECTSET,int), },
+   { BLKSECTGET, _NEW_IOR(BLKSECTGET,int), },
+   { BLKSSZGET,  _NEW_IOR(BLKSSZGET,int), },
+//  fd.h
+   { FDCLRPRM,  0, },
+   { FDSETPRM, _NEW_IOWR(FDSETPRM, struct floppy_struct), },
+   { FDDEFPRM, _NEW_IOWR(FDDEFPRM, struct floppy_struct), }, 
+   { FDGETPRM, _NEW_IOR(FDGETPRM, struct floppy_struct), }, 
+   { FDMSGON,   0, }, 
+   { FDMSGOFF,  0, }, 
+   { FDFMTBEG,  0, }, 
+   { FDFMTTRK, _NEW_IOWR(FDFMTTRK, struct format_descr), }, 
+   { FDFMTEND,  0, }, 
+   { FDSETEMSGTRESH, _NEW_IOW(FDSETEMSGTRESH, unsigned), }, 
+   { FDFLUSH,  0, }, 
+   { FDSETMAXERRS, _NEW_IOWR(FDSETMAXERRS, struct floppy_max_errors), }, 
+   { FDGETMAXERRS, _NEW_IOR(FDGETMAXERRS, struct floppy_max_errors), }, 
+   { FDGETDRVTYP, _NEW_IOR(FDGETDRVTYP, floppy_drive_name), }, // 16 bytes
+   { FDSETDRVPRM, _NEW_IOWR(FDSETDRVPRM, struct floppy_drive_params), }, 
+   { FDGETDRVPRM, _NEW_IOR(FDGETDRVPRM, struct floppy_drive_params), }, 
+   { FDGETDRVSTAT, _NEW_IOR(FDGETDRVSTAT, struct floppy_drive_struct), }, 
+   { FDPOLLDRVSTAT, _NEW_IOR(FDPOLLDRVSTAT, struct floppy_drive_struct), }, 
+   { FDRESET,  0, }, 
+   { FDGETFDCSTAT, _NEW_IOR(FDGETFDCSTAT, struct floppy_fdc_state), }, 
+   { FDWERRORCLR,  0, }, 
+   { FDWERRORGET, _NEW_IOR(FDWERRORGET, struct floppy_write_errors), }, 
+   { FDRAWCMD, _NEW_IOWR(FDRAWCMD, struct floppy_raw_cmd[1]) },  // FIXME linked list
+   { FDTWADDLE,  0, }, 
+   { FDEJECT,  0, }, 
+// cdrom.h
+   { CDROMPAUSE, _NEW_IO(CDROMPAUSE), }, 
+   { CDROMRESUME, _NEW_IO(CDROMRESUME), }, 
+   { CDROMPLAYMSF, _NEW_IOR(CDROMPLAYMSF, struct cdrom_msf), }, 
+   { CDROMPLAYTRKIND, _NEW_IOR(CDROMPLAYTRKIND, struct cdrom_ti), }, 
+   { CDROMREADTOCHDR, _NEW_IOWR(CDROMREADTOCHDR, struct cdrom_tochdr), }, 
+   { CDROMREADTOCENTRY, _NEW_IOWR(CDROMREADTOCENTRY, struct cdrom_tocentry), }, 
+   { CDROMSTOP, _NEW_IO(CDROMSTOP), }, 
+   { CDROMSTART, _NEW_IO(CDROMSTART), }, 
+   { CDROMEJECT, _NEW_IO(CDROMEJECT), }, 
+   { CDROMVOLCTRL, _NEW_IOR(CDROMVOLCTRL, struct cdrom_volctrl), }, 
+   { CDROMSUBCHNL, _NEW_IOWR(CDROMSUBCHNL, struct cdrom_subchnl), }, 
+   { CDROMREADMODE2, _NEW_IOR(CDROMREADMODE2, struct cdrom_read), },  // INDIRECT 2336B
+   { CDROMREADMODE1, _NEW_IOR(CDROMREADMODE1, struct cdrom_read), },  // INDIRECT 2048B
+   { CDROMREADAUDIO, _NEW_IOR(CDROMREADAUDIO, struct cdrom_read_audio), }, 
+   { CDROMEJECT_SW, _NEW_IO(CDROMEJECT_SW), }, 
+   { CDROMMULTISESSION, _NEW_IOWR(CDROMMULTISESSION, struct cdrom_multisession), }, 
+   { CDROM_GET_MCN, _NEW_IOWR(CDROM_GET_MCN, struct cdrom_mcn), }, 
+   { CDROMRESET, _NEW_IO(CDROMRESET), }, 
+   { CDROMVOLREAD, _NEW_IOWR(CDROMVOLREAD, struct cdrom_volctrl), }, 
+   { CDROMREADRAW, _NEW_IOR(CDROMREADRAW, struct cdrom_read), },  // INDIRECT 2352B
+   // aztcd.c optcd.c
+   { CDROMREADCOOKED, _NEW_IOR(CDROMREADCOOKED, struct cdrom_msf), }, // INDIRECT FIXME
+   { CDROMSEEK, _NEW_IOR(CDROMSEEK, struct cdrom_msf), }, 
+   // scsi-cd.c
+   { CDROMPLAYBLK, _NEW_IOWR(CDROMPLAYBLK, struct cdrom_blk), }, 
+   // optcd.c
+   { CDROMREADALL, _NEW_IOR(CDROMREADALL, char[2646]), }, 
+   // ide-cd.c
+#ifdef CDROMGETSPINDOWN
+   { CDROMGETSPINDOWN, _NEW_IOWR(CDROMGETSPINDOWN, char), },  // one byte
+#endif
+#ifdef CDROMSETSPINDOWN
+   { CDROMSETSPINDOWN, _NEW_IOWR(CDROMSETSPINDOWN, char), },  // one byte
+#endif
+   // cdrom.c
+   { CDROMCLOSETRAY, _NEW_IO(CDROMCLOSETRAY), },
+   { CDROM_SET_OPTIONS, _NEW_IOW(CDROM_SET_OPTIONS, int), },
+   { CDROM_CLEAR_OPTIONS, _NEW_IOW(CDROM_CLEAR_OPTIONS, int), },
+   { CDROM_SELECT_SPEED, _NEW_IOW(CDROM_SELECT_SPEED, int), }, // FIXME - don't know
+   { CDROM_SELECT_DISC, _NEW_IOW(CDROM_SELECT_DISC, int), },
+   { CDROM_MEDIA_CHANGED, _NEW_IOW(CDROM_MEDIA_CHANGED, int), },
+   { CDROM_DRIVE_STATUS, _NEW_IOW(CDROM_DRIVE_STATUS, int), },
+   { CDROM_DISC_STATUS, _NEW_IO(CDROM_DISC_STATUS), },
+   { CDROM_CHANGER_NSLOTS, _NEW_IO(CDROM_CHANGER_NSLOTS), },
+   { CDROM_LOCKDOOR, _NEW_IOW(CDROM_LOCKDOOR, int), },
+   { CDROM_DEBUG, _NEW_IOW(CDROM_DEBUG, int), },
+   { CDROM_GET_CAPABILITY, _NEW_IO(CDROM_GET_CAPABILITY), },
+   // sbpcd
+   { CDROMAUDIOBUFSIZ, _NEW_IOW(CDROMAUDIOBUFSIZ, int), },
+   // dvd
+#ifdef DVD_READ_STRUCT
+   { DVD_READ_STRUCT, _NEW_IOR(DVD_READ_STRUCT, dvd_struct), },
+#endif
+#ifdef DVD_WRITE_STRUCT
+   { DVD_WRITE_STRUCT, _NEW_IOWR(DVD_WRITE_STRUCT, dvd_struct), },
+#endif
+#ifdef DVD_AUTH
+   { DVD_AUTH, _NEW_IOWR(DVD_AUTH, dvd_authinfo), },
+#endif
+#ifdef CDROM_SEND_PACKET
+   { CDROM_SEND_PACKET, _NEW_IOR(CDROM_SEND_PACKET, struct cdrom_generic_command), },
+#endif
+#ifdef CDROM_NEXT_WRITABLE
+   { CDROM_NEXT_WRITABLE, _NEW_IOWR(CDROM_NEXT_WRITABLE, long), },
+#endif
+#ifdef CDROM_LAST_WRITTEN
+   { CDROM_LAST_WRITTEN, _NEW_IOWR(CDROM_LAST_WRITTEN, long), },
+#endif
+   // PTB local test ioctls
+   { ENBD_TEST_IOCTL1, 0, },   // write an int
+   { ENBD_TEST_IOCTL2, 0, },   // read an int
+   { ENBD_TEST_IOCTL3, 0, },   // write and read an int
+   { ENBD_TEST_IOCTL4, 0, },   // read 256B
+   { ENBD_TEST_IOCTL5, 0, },   // r/w 256B
+   { ENBD_TEST_IOCTL6, _NEW_IORS(ENBD_TEST_IOCTL6), },    // read special
+   { ENBD_TEST_IOCTL7, _NEW_IORS(ENBD_TEST_IOCTL7), },    // r/w special
+   // PTB we must terminate with a 0,0 entry.
+   {0 , 0, },
+};
+
+/*
+ * This should be the table of special methods for certain ioctls.
+ * The "new" code is the real index. It will have a size count of
+ * _IOC_SIZEMASK but the rest of it should be meaningful. The size is
+ * gotten by dynamic lookup using the size() function.
+ */
+static struct ioctl_special ioctl_special_tab[] = {
+    // PTB last entry must be all zeros
+    { 0, NULL, NULL, NULL, NULL, },
+};
+
+
+static struct ioctl_conv *
+ioctl_lookup_old (int ioctl)
+{
+	int i;
+        unsigned old;
+        if (ioctl == -1)
+            return NULL;
+	for (i = 0; old = ioctl_conv_tab[i].old, old; i++) {
+		if (old == ioctl)
+		        return &ioctl_conv_tab[i];
+	}
+	// PTB not there
+	return NULL;
+}
+
+int
+enbd_ioctl_convert (int ioctl)
+{
+	struct ioctl_conv *conv = ioctl_lookup_old (ioctl);
+	if (!conv)
+		// PTB not there
+		return -1;
+        return conv->new ? : ioctl;
+}
+
+int
+enbd_ioctl_convert_inplace(int *ioctl) {
+
+       int new_ioctl;
+       if (!ioctl)
+           return -EINVAL;
+       new_ioctl = enbd_ioctl_convert(*ioctl);
+       if (new_ioctl == -1)
+           return -EINVAL;
+       *ioctl = new_ioctl;
+       return 0;
+}
+
+static struct ioctl_conv *
+ioctl_lookup_new (int ioctl)
+{
+	int i = 0;
+	unsigned old;
+	for (i = 0; old = ioctl_conv_tab[i].old, old; i++) {
+		unsigned new = ioctl_conv_tab[i].new;
+		if (new == ioctl || (new == 0 && old == ioctl)) 
+			return &ioctl_conv_tab[i];
+	}
+	// PTB not there
+	return NULL;
+}
+
+int
+enbd_ioctl_revert (int ioctl)
+{
+	struct ioctl_conv *conv = ioctl_lookup_new (ioctl);
+	if (!conv)
+		// PTB not there
+		return -1;
+	return conv->old;
+}
+
+static struct ioctl_special *
+ioctl_special_lookup_new (int ioctl)
+{
+	int i;
+        unsigned new;
+	for (i = 0; new = ioctl_special_tab[i].new, new; i++) {
+		if (new == ioctl) 
+			return &ioctl_special_tab[i];
+	}
+	// PTB not there
+	return NULL;
+}
+
+int
+enbd_ioctl_size (int cmd, char *arg)
+{
+	int size = _IOC_SIZE (cmd);
+	if (size == _IOC_SIZEMASK) {
+		// PTB special hadling required. 
+                struct ioctl_special *special = ioctl_special_lookup_new(cmd);
+                if (!special)
+                        return -1;
+	        return special->size (arg);
+	}
+	return size;
+}
+
+int
+enbd_ioctl_size_user (int cmd, char *arg)
+{
+	int size = _IOC_SIZE (cmd);
+	if (size == _IOC_SIZEMASK) {
+		// PTB special hadling required. 
+                struct ioctl_special *special = ioctl_special_lookup_new(cmd);
+                if (!special)
+                        return -1;
+	        return special->size_user (arg);
+	}
+	return size;
+}
+
+
+#ifdef __KERNEL__
+int
+enbd_ioctl_copy_to_user (int cmd, char *arg, char *buf, int size)
+{
+
+	if (_IOC_SIZE (cmd) == _IOC_SIZEMASK) {
+                struct ioctl_special *special = ioctl_special_lookup_new(cmd);
+                if (!special)
+                        return -1;
+	        return special->ioctl_copy_to_user (arg, buf, size);
+	}
+
+	if (_IOC_DIR (cmd) & _IOC_READ) {
+		// indirect
+		copy_to_user (arg, buf, size);
+		return size;
+	}
+
+	return -1;
+}
+
+
+
+int
+enbd_ioctl_copy_from_user (int cmd, char *buf, char *arg, int size)
+{
+
+	if (_IOC_SIZE (cmd) == _IOC_SIZEMASK) {
+                struct ioctl_special *special = ioctl_special_lookup_new(cmd);
+                if (!special)
+                        return -1;
+	        return special->ioctl_copy_from_user (buf, arg, size);
+	}
+
+	if (_IOC_DIR (cmd) & _IOC_READ) {
+		// indirect
+		copy_from_user (buf, arg, size);
+		return size;
+	}
+
+	// direct
+	if (size > sizeof (arg)) {
+		return -1;
+	}
+
+	memcpy (buf, &arg, size);
+	return size;
+}
+
+static struct enbd_ioctl struct_ioctl = {
+        convert : enbd_ioctl_convert,
+        convert_inplace : enbd_ioctl_convert_inplace,
+        revert  : enbd_ioctl_revert,
+        size    : enbd_ioctl_size,
+        size_user : enbd_ioctl_size_user,
+        cp_to_user : enbd_ioctl_copy_to_user,
+        cp_from_user : enbd_ioctl_copy_from_user,
+};
+
+static int __init
+enbd_ioctl_init (void)
+{
+    enbd_register_remote_ioctl(&struct_ioctl);
+    return 0;
+}
+
+static void __exit
+enbd_ioctl_cleanup (void) {
+    enbd_unregister_remote_ioctl(&struct_ioctl);
+}
+
+module_init (enbd_ioctl_init);
+module_exit (enbd_ioctl_cleanup);
+
+int linux_version_code = LINUX_VERSION_CODE;
+
+#ifdef MODULE
+  #if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
+    MODULE_AUTHOR ("Peter T. Breuer");
+    MODULE_DESCRIPTION ("Enhanced Network Block Device Remote Ioctl");
+    #ifdef MODULE_LICENSE
+      MODULE_LICENSE("GPL");
+    #endif
+  #endif
+#endif		/* MODULE */
+
+#endif /* __KERNEL__ */
+
+
+/*
+static
+int ioctl_init(struct ioctl_conv *self, int old, int new) {
+    self->old = old;
+    self->new = new;
+    self->serialize = ioctl_serialize;
+    self->deserialize = ioctl_deserialize;
+    self->size = ioctl_size;
+}
+*/
--- linux-2.4.17rc2-xfs/include/linux/enbd.h.pre-enbd	Sat Mar 29 18:29:42 2003
+++ linux-2.4.17rc2-xfs/include/linux/enbd.h	Sat Sep  6 19:53:17 2003
@@ -0,0 +1,449 @@
+#ifndef LINUX_NBD_H
+#define LINUX_NBD_H
+
+  /* unsigned comments are Pavel's originals for 2.1.*
+   *   pavel@atrey.karlin.mff.cuni.cz (Pavel Machek)
+   * comments marked PTB are from
+   *   ptb@it.uc3m.es (Peter T. Breuer)
+   * comments marked AMARIN are from
+   *   amarin@it.uc3m.es (Andres Marin Lopez)
+   */
+
+  #include <asm/types.h>
+
+  #ifndef ENBD_VERSION
+  # define ENBD_VERSION "2.4.31 $Date: 2003/08/24 09:41:29 $"
+  #endif /*ENBD_VERSION*/
+
+
+  /*
+   * Third type of request apart from READ or WRITE
+   */
+  #ifndef IOCTL
+  # define IOCTL 2
+  #endif
+
+  /* PTB - new style ioctl assignments */
+  #define ENBD_SET_SOCK         _IOW(0xab, 0x00, int)
+  #define ENBD_TEST_IOCTL1      _IOW(0xab, 0x01, int)
+  #define ENBD_SET_SIZE         _IOW(0xab, 0x02, int)
+  #define ENBD_DO_IT            _IOW(0xab, 0x03, int)
+  #define ENBD_CLEAR_SOCK       _IOW(0xab, 0x04, int)
+  #define ENBD_CLEAR_QUE        _IO (0xab, 0x05)
+  #define ENBD_PRINT_DEBUG      _IO (0xab, 0x06)
+  #define ENBD_TEST_IOCTL2      _IOR(0xab, 0x07, int)
+  #define ENBD_HARD_RESET       _IO (0xab, 0x09)
+  #define ENBD_DEC_USE_COUNT    _IO (0xab, 0x09)
+  #define MY_NBD_ACK           _IOW(0xab, 0x0a, char *)
+  #define MY_NBD_GET_REQ       _IOW(0xab, 0x0b, char *)
+  #define MY_NBD_REG_BUF       _IOW(0xab, 0x0c, char *)
+  #define MY_NBD_CLR_REQ       _IOW(0xab, 0x0d, int)
+  #define MY_NBD_SYNC          _IOW(0xab, 0x0e, int)
+  #define ENBD_SET_SECTORS      _IOW(0xab, 0x0f, int)
+  #define MY_NBD_SET_SIG       _IOW(0xab, 0x10, int *)
+  #define ENBD_RESET            _IO (0xab, 0x11)
+  #define ENBD_TEST_IOCTL3      _IOWR(0xab, 0x12, int)
+  #define MY_NBD_ERR_REQ       _IOW(0xab, 0x13, int)
+  #define MY_NBD_SET_INTVL     _IOW(0xab, 0x14, int)
+  #define MY_NBD_SET_SHOW_ERRS _IOW(0xab, 0x15, int) 
+  #define ENBD_SET_MD5SUM       _IOW(0xab, 0x16, int) 
+  #define MY_NBD_SET_BUFFERWR  _IOW(0xab, 0x17, int) 
+  #define MY_NBD_INVALIDATE    _IOW(0xab, 0x18, int)
+  #define MY_NBD_SET_SPID      _IOW(0xab, 0x19, int) 
+  #define MY_NBD_SET_RQ_HANDLE _IOW(0xab, 0x1a, void*) 
+  #define MY_NBD_SET_RQ_SEQNO  _IOW(0xab, 0x1b, int) 
+  #define MY_NBD_SET_RQ_DIGEST _IOWR(0xab, 0x1d, enbd_digest_t) 
+  #define ENBD_TEST_IOCTL4      _IOR(0xab, 0x1e, char[256])
+  #define ENBD_TEST_IOCTL5      _IOWR(0xab, 0x1f, char[256])
+  #define ENBD_TEST_IOCTL6      _IO(0xab, 0x20) // special r 256B
+  #define ENBD_TEST_IOCTL7      _IO(0xab, 0x21) // special rw 256B
+  #define ENBD_SET_BLKSIZE      _IOW(0xab, 0x22, int)
+  #define ENBD_GET_BLKSIZE      _IOR(0xab, 0x23, long)
+  #define ENBD_SET_PF_MEMALLOC  _IOW(0xab, 0x24, int)
+  #define MY_NBD_SET_DIRECT    _IOW(0xab, 0x25, int) 
+  #define MY_NBD_GET_NPORT     _IOR(0xab, 0x26, int)
+  #define ENBD_SETFAULTY        _IOW(0xab, 0x27, int)
+  #define ENBD_HOTREMOVE        _IOW(0xab, 0x28, int)
+  #define ENBD_HOTADD           _IOW(0xab, 0x29, int)
+
+  #define ENBD_SHIFT 4         /* PTB 16 partitions/sockets/slots per device */
+                              /* PTB number of socket slots per device */
+  #define ENBD_MAXCONN (1<<ENBD_SHIFT)
+  #define MAX_NBD (256>>ENBD_SHIFT) /* PTB MAX was 128, but that's a lot */
+  #define ENBD_SIGLEN 128      /* PTB length of sig on device */
+  #define ENBD_MAX_SECTORS 512 /* PTB max number of 512B sectors in a buffer */
+  #define ENBD_CMDBITS 2       /* PTB significant bits of req->cms */
+  #define ENBD_CMDMASK 0x03    /* PTB mask pertaining to CMDBITS */
+  //#define ENBD_MAXGROUP 2      /* PTB number of client groups per device */
+
+
+
+  #ifdef __KERNEL__
+    /* PTB various module defaults */
+    #define ENBD_RAHEAD_DFLT    24 /* PTB slow medium                  */
+    #define ENBD_SYNC_INTVL      0 /* PTB sync every nK reqs (default disable) */
+    #define ENBD_REQ_TIMEO       5 /* PTB client inactivity check (rollback) */
+    #define ENBD_SPEED_LIM  100000 /* PTB limit to 100M write reqs/s */
+    #define ENBD_MERGE_REQ_DFLT  0 /* PTB until accounting fixed! */
+    #if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
+      #define ENBD_PLUG_DFLT     0 /* PTB until accounting fixed! */
+    #else
+     /* PTB Jens Axboe says that plug should always be set in 2.4.* */
+      #define ENBD_PLUG_DFLT     1 
+    #endif
+    #define ENBD_MD5SUM_DFLT     0 
+
+
+    struct enbd_slot {
+      struct file * file;      /* PTB add - for refcnt, NULL if slot empty */
+      struct socket * sock;    /* PTB add                          */
+      int in;                  /* PTB add - tot blocks entered     */
+      int out;                 /* PTB add - tot blocks released    */
+      int err;                 /* PTB add - tot blocks errored     */
+      int req;                 /* PTB add - tot blocks pending     */
+      char * buffer;           /* PTB add - user space buffer      */
+      int  bufsiz;             /* PTB add - user space buffer size */
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+      struct list_head queue;
+#else
+      struct request queue;
+#endif
+      unsigned long req_age;   /* PTB add - age of pending req     */
+      unsigned long cli_age;   /* PTB add - age of client          */
+      struct enbd_device *lo;  /* PTB add - parent device          */
+    #define ENBD_SLOT_RUNNING   0x0001
+    #define ENBD_SLOT_WAITING   0x0002
+    #define ENBD_SLOT_BUFFERED  0x0004
+    #define ENBD_SLOT_MD5SUM    0x8000 /* slot reply has a digest in it ..*/
+    #define ENBD_SLOT_MD5_OK   0x10000 /* .. and equaled req's */
+      int flags;               /* PTB add */
+      int i;                   /* PTB add - slot number */
+      int buflen;              /* PTB add - buffer byte count */
+      int pid;                 /* PTB add - client process */
+      int refcnt;              /* PTB add - so can set_sock/clr_sock ourself */
+      int nerrs;               /* PTB add - local error count */
+      int spid;                /* PTB add - server pid */
+      //int group;               /* PTB add - for dual clients */
+      int md_count;            /* PTB really partition-in-raid count */
+    };
+
+    
+    struct enbd_acct;   // forward decl
+
+    struct enbd_speed {
+      atomic_t speed;                      /* PTB add - current speed in KB/s */
+      atomic_t speedmax;                   /* PTB add - max speed */
+      atomic_t speedav;                    /* PTB add - average speed */
+      atomic_t distance;                   /* PTB add - last distance measure */
+      atomic_t jiffy;                      /* PTB add - last jiffies speed */
+      atomic_t frstj;                      /* PTB add - first jiffy seen */
+    };
+
+    struct enbd_ioctl_info {
+        int cmd;
+        unsigned long arg;
+        int size;
+    };
+
+    struct enbd_acct {
+      atomic_t requests_in[2];             /* PTB add - blocks put on queue */
+      atomic_t requests_out[2];            /* PTB add - blocks out from queue */
+      atomic_t requests_err;               /* PTB add - blocks erred on queue */
+      atomic_t requests_req[2];            /* PTB add - read blocks pending */
+      atomic_t kwaiters;                   /* PTB add - kernel thrds waiting */
+      atomic_t kthreads;                   /* PTB add - kernel threads in */
+      atomic_t maxq[2];                    /* PTB add - max req queue depth */
+      atomic_t countq[2];                  /* PTB add - request queue depth */
+      //atomic_t errors;                     /* PTB add - tot requests errored */
+      atomic_t cwaiters;                   /* PTB add - client thrds waiting */
+      atomic_t cthreads;                   /* PTB add - client threads in */
+      atomic_t req_in[2][1 + ENBD_MAX_SECTORS/2];
+      atomic_t maxreqblks;                 /* PTB add - maximum req size seen */
+    };
+
+    struct enbd_bitmap {
+        unsigned char **map;
+        unsigned long pages;
+        int (*make) (struct enbd_bitmap *bitmap);
+        void (*destroy) (struct enbd_bitmap *bitmap);
+        int (*checkpage) (struct enbd_bitmap *bitmap, unsigned long page);
+        int (*set_mask) (struct enbd_bitmap *bitmap, unsigned long offset, unsigned char mask);
+        int (*test_mask) (struct enbd_bitmap *bitmap, unsigned long offset, unsigned char mask);
+        int (*clearbit) (struct enbd_bitmap *bitmap, unsigned long block);
+        int (*testbit) (struct enbd_bitmap *bitmap, unsigned long block);
+        rwlock_t lock;                /* PTB add - spinlock bitmap */
+    };
+
+    struct enbd_device {
+      atomic_t refcnt;	
+    #define ENBD_READ_ONLY   0x0001
+    #define ENBD_REENABLE    0x0002
+    #define ENBD_INITIALISED 0x0004
+    #define ENBD_SIGNED      0x0008
+
+    #define ENBD_ENABLED     0x0010
+    #define ENBD_SIZED       0x0020
+    #define ENBD_BLKSIZED    0x0040
+    #define ENBD_RESYNCING   0x0080         /* device is resyncing */
+
+    #define ENBD_VALIDATING  0x0100         /* reading partition table */
+    #define ENBD_SHOW_ERRS   0x0200         /* showing errs, not blocking */
+    #define ENBD_SYNC        0x0400
+    #define ENBD_VALIDATED   0x0800         /* read partition table */
+
+    #define ENBD_BUFFERWR    0x1000         /* buffer writes to device */
+    #define ENBD_REMOTE_INVALID \
+                            0x2000         /* remote resource vanished */
+    #define ENBD_DIRECT      0x4000         /* convert opens to O_DIRECT */
+    #define ENBD_MD5SUM      0x8000
+    #define ENBD_RAID_SHOW_ERRS  \
+                           0x10000         /* set show_errs for raid */
+    #define ENBD_SET_SHOW_ERRS  \
+                           0x20000         /* set show_errs for remote inval */
+
+
+      atomic_t flags;
+      int harderror;		           /* Code of hard error	    */
+      int magic;			   /* FIXME: not if debugging is off  */
+#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
+      struct list_head queue;
+#else
+      struct request queue;
+#endif
+      rwlock_t queue_lock;                 /* PTB add - spinlock */
+      int nslot;                           /* PTB add - total slots */
+      atomic_t islot;                      /* PTB add - current slot */
+      atomic_t aslot;                      /* PTB add - total active slots*/
+      struct enbd_acct *acct;
+      atomic_t wrequests_5so;              /* PTB add - write blocks md5 skip */
+      atomic_t wrequests_5wo;              /* PTB add - write blocks md5 wr */
+      atomic_t wrequests_5eo;              /* PTB add - write blocks md5 refus*/
+      atomic_t wrequests_5to;              /* PTB add - write blocks md5sum */
+      atomic_t wrequests_5co;              /* PTB add - write blocks md5 tot */
+      atomic_t wrequests_5no;              /* PTB add - write blocks not md5 */
+      atomic_t seqno_out;                  /* PTB add - sequence number */
+      wait_queue_head_t wq;                /* PTB add */
+      struct enbd_slot *slots[ENBD_MAXCONN]; /* PTB add - client array */
+      unsigned blksize;                    /* PTB add - device blksize in B */
+      u64 bytesize;                        /* PTB add - device size in B */
+      u64 sectors;                         /* PTB add - device size (sectors) */
+      unsigned size;                       /* PTB add - device size in blks */
+      unsigned logblksize;                 /* PTB add - log2 blksize */
+      unsigned nbd;                        /* PTB add - this array index */
+      int signature[ENBD_SIGLEN/sizeof(int)];
+                                           /* PTB add - server sig */
+      struct file * file;                  /* PTB add - for ref */
+      struct inode * inode;                /* PTB add - for ref */
+      int  bufsiz;                         /* PTB add - userspace buffer size */
+      atomic_t kmax;                       /* PTB add - max kernel threads */
+      char *blockmap;                      /* PTB add - map of block states */
+      unsigned long disabled;              /* PTB add - when was it disabled */
+      int req_timeo;                       /* PTB add - inactivity timeout */
+      struct timer_list run_queue;         /* PTB add - run queue */
+      struct tq_struct task_queue;         /* PTB add - task queue */
+      char devnam[4];                      /* PTB add - drive letters */
+      int max_sectors;                     /* PTB add - max req size allowed! */
+      int lives;                           /* PTB add - # times enabled */
+      atomic_t seqno_in;                   /* PTB add - wreq sequence number */
+      // PTB speed measurement settings
+      struct enbd_speed tspeed;
+      struct enbd_speed wspeed;
+      struct enbd_speed rspeed;
+      struct request req;                  /* PTB fake request for ioctls */
+   #ifdef COMPLETION_INITIALIZER
+      struct completion req_x;
+   #endif
+      wait_queue_head_t req_wq;
+      struct semaphore req_sem;            /* PTB control fake req resource */
+      struct semaphore pid_sem;            /* PTB control setting pid */
+      //atomic_t ngroup;                     /* PTB number of client groups */
+      rwlock_t meta_lock;                  /* PTB add - spinlock meta data */
+      //atomic_t agroup;                     /* PTB number of active groups */
+      //atomic_t igroup;                     /* PTB lowest active group */
+      //atomic_t bgroup;                     /* PTB active group bitmap */
+      //struct enbd_bitmap *bitmap[ENBD_MAXGROUP];
+                                           /* PTB missed blocks map */
+      //atomic_t cgroup;                     /* PTB count of notuptodate groups */
+      //atomic_t fgroup;                     /* PTB mask of notuptodate groups */
+      //unsigned short ggroup[ENBD_MAXGROUP]; /* PTB list of notuptodate groups */
+      rwlock_t bitmap_lock;                /* PTB add - spinlock bitmap */
+      struct enbd_ioctl_info req_ioctl_info;/* PTB add - to hold ioctl data */
+      //unsigned progress[ENBD_MAXGROUP];     /* PTB resync progress */
+      atomic_t merge_requests;             /* PTB local req blks limit - 1 */
+      atomic_t md_count;                   /* PTB count of raids we are in */
+      unsigned long reenable_time;         /* PTB time to delayed reenable */
+    };
+
+  /* COMPATIBILITY */
+#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
+// PTB the ifndef's are because Marcello in 2.2.19 ported back stuff from
+// 2.4.* that I also ported back, thus causing conflicts.
+  #ifndef schedule_task
+    #define schedule_task(x) queue_task(x,&tq_scheduler)
+  #endif
+  #ifndef module_init
+    #define module_init(x) int init_module(void) { return x(); }
+  #endif
+  #ifndef module_exit
+    #define module_exit(x) int cleanup_module(void) { x(); return 0; }
+  #endif
+  #ifndef __exit
+    #define __exit  __attribute__ ((unused, __section__(".text.exit")))
+  #endif
+  #ifndef __init
+    #define __init  __attribute__ ((__section__ (".text.init")))
+  #endif
+#endif
+
+  #ifndef __NBD_FILE
+    #define __NBD_FILE __FILE__
+  #endif
+
+  #define ENBD_ID "ENBD %s #%d[%d]: %s "
+  #if ENBD_COMPILED_DEBUG_LEVEL > 0
+  #define ENBD_DEBUG(level, s...) \
+     if(1 || debug>=(level)) \
+             { static int icnt; printk( KERN_DEBUG ENBD_ID, __NBD_FILE, __LINE__, icnt++, __FUNCTION__); printk(s);}
+  #else
+    #define ENBD_DEBUG(level, s...)
+  #endif
+
+  #define ENBD_ERROR( s...) { static int icnt; printk( KERN_ERR   ENBD_ID, __NBD_FILE, __LINE__, icnt++, __FUNCTION__); printk(s);}
+  #define ENBD_ALERT( s...) { static int icnt; printk( KERN_ALERT ENBD_ID, __NBD_FILE, __LINE__, icnt++, __FUNCTION__); printk(s);}
+  #define ENBD_INFO( s...)  { static int icnt; printk( KERN_INFO  ENBD_ID, __NBD_FILE, __LINE__, icnt++, __FUNCTION__); printk(s);}
+
+  // PTB forward declarations, mostly exported to enbd_proc
+  //char * enbd_device_letter (int i);
+  //int enbd_get_merge_requests(void);
+  //void enbd_set_merge_requests (int merge_requests, int index);
+  //int enbd_get_plug(void);
+  //void enbd_set_plug (int plug, int index);
+  //void enbd_snapshot_speed (struct enbd_device *lo);
+  //long enbd_nr_blks (struct request *req);
+  //int enbd_hard_reset (void);
+  //int enbd_soft_reset (struct enbd_device *lo);
+  //static int enbd_reenable_delay (struct enbd_device *lo, int delay);
+  //int enbd_get_debug(void);
+  //void enbd_set_debug (int d, int index);
+  //void enbd_set_bitmap (int debug, int i);
+  //void enbd_set_sync_intvl (int sync_intvl, int i);
+  //void enbd_set_show_errs (int show_errs, int i);
+  //void enbd_set_md5sum (int md5sum, int i);
+  //void enbd_set_ra (int ra, int index);
+  //void enbd_set_buffer_writes (int buffer_writes, int i);
+  //void enbd_set_enabled (int enable, int i);
+  //void enbd_set_direct (int direct, int i);
+  //void enbd_zero_counters (int zs, int i);
+  struct enbd_device * enbd_get_device(int i);
+  void enbd_enqueue (struct enbd_device *lo, struct request *req);
+  int enbd_open (struct inode *inode, struct file *file);
+  int enbd_local_wait_on_request_timeout(struct request *req, unsigned long timeout);
+  #ifndef release_t
+        #if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
+                #define release_t void
+        #else
+                #define release_t int
+        #endif
+  #endif
+  release_t enbd_release (struct inode *inode, struct file *file);
+  int enbd_ioctl (struct inode *inode, struct file *file,
+	   unsigned int cmd, unsigned long arg);
+
+  #endif /* __KERNEL__ */
+
+  /* This now IS in some kind of include file...	*/
+
+  /* PTB 132 */ 
+  #define ENBD_INIT_MAGIC 0x12345678       /* AMARIN */
+  #define ENBD_REQUEST_MAGIC 0x25609513
+  #define ENBD_REPLY_MAGIC 0x67446698     
+  /* Do *not* use magics: 0x12560953 0x96744668. 
+   */
+  #define ENBD_DEV_MAGIC 0x68797548
+
+  #define ENBD_REQUEST_MAGIC_T  __u32
+  #define ENBD_REQUEST_TYPE_T   __u32
+  #define ENBD_REQUEST_FROM_T   __u64
+  #define ENBD_REQUEST_LEN_T    __u32
+  #define ENBD_REQUEST_FLAGS_T  __u32
+  #define ENBD_REQUEST_TIME_T   __u64
+  #define ENBD_REQUEST_ZONE_T   __s64
+  #define ENBD_REQUEST_SPECIAL_T  __u32
+
+  #define ENBD_REPLY_MAGIC_T    __u32
+  #define ENBD_REPLY_ERROR_T    __s32
+  #define ENBD_REPLY_FLAGS_T    __u32
+  #define ENBD_REPLY_TIME_T     __u64
+  #define ENBD_REPLY_ZONE_T     __s64
+
+  #define ENBD_REQUEST_HANDLE_T __u32
+  #define ENBD_REPLY_HANDLE_T   __u32
+
+  typedef __u32 enbd_digest_t[4];
+
+  #define ENBD_DIGEST_T   enbd_digest_t
+
+  #define ENBD_REQUEST_DIGEST_T   ENBD_DIGEST_T
+  #define ENBD_REPLY_DIGEST_T   ENBD_DIGEST_T
+
+  #define ENBD_DIGEST_BITS      128
+  #define ENBD_DIGEST_LENGTH    ((ENBD_DIGEST_BITS)/8)
+  #define ENBD_REQUEST_SEQNO_T  __u32
+
+  struct enbd_request {
+    ENBD_REQUEST_MAGIC_T  magic;
+    ENBD_REQUEST_TYPE_T   type;			/* == READ || == WRITE 	*/
+    ENBD_REQUEST_HANDLE_T handle;
+    ENBD_REQUEST_FROM_T   from;                    /* 64 bit PTB 132 */
+    ENBD_REQUEST_LEN_T    len;                     /* 32 bit or ioctl code */
+
+
+
+  #define ENBD_REQUEST_ERRORED    0x0800
+  #define ENBD_REQUEST_MD5SUM     0x8000         /* has a digest in it ..*/
+  #define ENBD_REQUEST_MD5_OK    0x10000         /* .. and equaled req's */
+  #define ENBD_REQUEST_IOCTL     0x40000         /* ioctl+arg in from, len=0 */
+  #define ENBD_REQUEST_SPECIALRW 0x80000         /* 1 for w 0 for r on special */
+    ENBD_REQUEST_FLAGS_T  flags;
+    ENBD_REQUEST_TIME_T   time;
+    ENBD_REQUEST_ZONE_T   zone;
+    ENBD_REQUEST_SEQNO_T  seqno;
+    union {
+       ENBD_REQUEST_DIGEST_T digest;
+    } data;
+    ENBD_REQUEST_SPECIAL_T special;
+    char dummy0[0];
+    char dummy1[0] __attribute__ ((aligned (64)));
+  }  __attribute__ ((packed)) ;
+
+  #define ENBD_REQUEST_LENGTH sizeof(struct enbd_request)
+
+  struct enbd_reply {
+    ENBD_REPLY_MAGIC_T    magic;
+    ENBD_REPLY_ERROR_T    error;		      /* 0 = ok, else error	*/
+    ENBD_REPLY_HANDLE_T   handle;	      /* handle you got from request */
+
+
+  #define ENBD_REPLY_ERRORED      0x0800
+  #define ENBD_REPLY_MD5SUM       0x8000         /* has a digest in it .. */
+  #define ENBD_REPLY_MD5_OK      0x10000         /* .. and equaled req's  */
+  #define ENBD_REPLY_CLOSE       0x20000         /* close cmd from server */
+  #define ENBD_REPLY_IOCTL       0x40000         /* ioctl+arg in from, len=0 */
+    ENBD_REPLY_FLAGS_T    flags;
+    ENBD_REPLY_TIME_T     time;
+    ENBD_REPLY_ZONE_T     zone;
+    union {
+       ENBD_REPLY_DIGEST_T digest;
+    } data;
+    char dummy0[0];
+    char dummy1[0] __attribute__ ((aligned (64)));
+  } __attribute__ ((packed)) ;
+
+  #define ENBD_REPLY_LENGTH sizeof(struct enbd_reply)
+
+  #define ENBD_BUFFER_DATA_OFFSET \
+   ((ENBD_REQUEST_LENGTH>ENBD_REPLY_LENGTH)?ENBD_REQUEST_LENGTH:ENBD_REPLY_LENGTH)
+
+
+#endif /* LINUX_NBD_H */
+
--- linux-2.4.17rc2-xfs/include/linux/enbd_ioctl.h.pre-enbd	Sat Mar 29 18:29:42 2003
+++ linux-2.4.17rc2-xfs/include/linux/enbd_ioctl.h	Sat Sep  6 19:53:13 2003
@@ -0,0 +1,45 @@
+#ifndef ENBD_IOCTL_H
+#define ENBD_IOCTL_H 1
+
+int enbd_ioctl_convert(int ioctl);
+int enbd_ioctl_convert_inplace(int *ioctl);
+int enbd_ioctl_revert(int ioctl);
+int enbd_ioctl_size (int cmd, char *arg);
+int enbd_ioctl_size_user (int cmd, char *arg);
+#ifdef __KERNEL__
+int enbd_ioctl_copy_to_user (int cmd, char *arg, char *buf, int size);
+int enbd_ioctl_copy_from_user (int cmd, char *buf, char *arg, int size);
+
+// PTB object containing all the above methods, to be registered with
+// the enbd.o module
+struct enbd_ioctl {
+        int (*convert)        (int ioctl);
+        int (*convert_inplace)(int *ioctl);
+        int (*revert)         (int ioctl);
+        int (*size)           (int cmd, char *arg);
+        int (*size_user)      (int cmd, char *arg);
+        int (*cp_to_user)     (int cmd, char *arg, char *buf, int size);
+        int (*cp_from_user)   (int cmd, char *buf, char *arg, int size);
+};
+
+extern int enbd_register_remote_ioctl(struct enbd_ioctl *);
+extern int enbd_unregister_remote_ioctl(struct enbd_ioctl *);
+#endif
+
+// PTB conversion table entries
+struct ioctl_conv {
+   unsigned int old; // ioctl id, _IO or _IOR or _IOW or _IOWR
+   unsigned int new; // ioctl id
+};
+
+// PTB extended conversion table entries for special cases
+struct ioctl_special {
+    int new;
+    int (*size) (char *arg);
+    int (*size_user) (char *arg);
+    int (*ioctl_copy_from_user)(char *buf, char*arg, int size);
+    int (*ioctl_copy_to_user)(char *arg, char*buf, int size);
+};
+
+
+#endif
