#ifndef NBD_IOCTL_H
#define NBD_IOCTL_H 1

int nbd_ioctl_convert(int ioctl);
int nbd_ioctl_convert_inplace(int *ioctl);
int nbd_ioctl_revert(int ioctl);
int nbd_ioctl_size (int cmd, char *arg);
int nbd_ioctl_size_user (int cmd, char *arg);
#ifdef __KERNEL__
int nbd_ioctl_copy_to_user (int cmd, char *arg, char *buf, int size);
int nbd_ioctl_copy_from_user (int cmd, char *buf, char *arg, int size);

// PTB object containing all the above methods, to be registered with
// the enbd.o module
struct nbd_ioctl {
        int (*convert)        (int ioctl);
        int (*convert_inplace)(int *ioctl);
        int (*revert)         (int ioctl);
        int (*size)           (int cmd, char *arg);
        int (*size_user)      (int cmd, char *arg);
        int (*cp_to_user)     (int cmd, char *arg, char *buf, int size);
        int (*cp_from_user)   (int cmd, char *buf, char *arg, int size);
};

extern int nbd_register_remote_ioctl(struct nbd_ioctl *);
extern int nbd_unregister_remote_ioctl(struct nbd_ioctl *);
#endif

// PTB conversion table entries
struct ioctl_conv {
   unsigned int old; // ioctl id, _IO or _IOR or _IOW or _IOWR
   unsigned int new; // ioctl id
};

// PTB extended conversion table entries for special cases
struct ioctl_special {
    int new;
    int (*size) (char *arg);
    int (*size_user) (char *arg);
    int (*ioctl_copy_from_user)(char *buf, char*arg, int size);
    int (*ioctl_copy_to_user)(char *arg, char*buf, int size);
};


#endif
