#ifndef LINUX_ENBD_H
#define LINUX_ENBD_H

/* unsigned comments are Pavel's originals for 2.1.*
 *   pavel@atrey.karlin.mff.cuni.cz (Pavel Machek)
 * comments marked PTB are from
 *   ptb@it.uc3m.es (Peter T. Breuer)
 * comments marked AMARIN are from
 *   amarin@it.uc3m.es (Andres Marin Lopez)
 */

#include <asm/types.h>

#ifndef ENBD_VERSION
#define ENBD_VERSION "2.4.30 $Date: 2002/09/17 16:33:22 $"
#endif /*ENBD_VERSION*/

  /*
   * Third type of request apart from READ or WRITE
   */
  #ifndef IOCTL
  # define IOCTL 2
  #endif
  /*
   * and fourth ..
   */
  #ifndef MD5SUM
  # define MD5SUM 3
  #endif
  /*
   * and fifth ..
   */
  #ifndef SPECIAL
  # define SPECIAL 4
  #endif

  /*
   * We need extra bits of req->flags
   * */
  # define __REQ_NBD       __REQ_NR_BITS
  # define REQ_NBD         (1 << __REQ_NBD)
  # define __REQ_NBDSEQNO  (__REQ_NR_BITS + 1)
  # define REQ_NBDSEQNO    (1 << __REQ_NBDSEQNO)
  // PTB ... and all the other bits are seqno too!

/* PTB - new style ioctl assignments */
  #define ENBD_SET_SOCK         _IOW(0xab, 0x00, int)
  #define ENBD_TEST_IOCTL1      _IOW(0xab, 0x01, int)
  #define ENBD_SET_SIZE         _IOW(0xab, 0x02, int)
  #define ENBD_DO_IT            _IOW(0xab, 0x03, int)
  #define ENBD_CLEAR_SOCK       _IOW(0xab, 0x04, int)
  #define ENBD_CLEAR_QUE        _IO (0xab, 0x05)
  #define ENBD_PRINT_DEBUG      _IO (0xab, 0x06)
  #define ENBD_TEST_IOCTL2      _IOR(0xab, 0x07, int)
  #define ENBD_HARD_RESET       _IO (0xab, 0x09)
  #define ENBD_DEC_USE_COUNT    _IO (0xab, 0x09)
  #define MY_NBD_ACK           _IOW(0xab, 0x0a, char *)
  #define MY_NBD_GET_REQ       _IOW(0xab, 0x0b, char *)
  #define MY_NBD_REG_BUF       _IOW(0xab, 0x0c, char *)
  #define MY_NBD_CLR_REQ       _IOW(0xab, 0x0d, int)
  #define MY_NBD_SYNC          _IOW(0xab, 0x0e, int)
  #define ENBD_SET_SECTORS      _IOW(0xab, 0x0f, int)
  #define MY_NBD_SET_SIG       _IOW(0xab, 0x10, int *)
  #define ENBD_RESET            _IO (0xab, 0x11)
  #define ENBD_TEST_IOCTL3      _IOWR(0xab, 0x12, int)
  #define MY_NBD_ERR_REQ       _IOW(0xab, 0x13, int)
  #define MY_NBD_SET_INTVL     _IOW(0xab, 0x14, int)
  #define MY_NBD_SET_SHOW_ERRS _IOW(0xab, 0x15, int) 
  #define ENBD_SET_MD5SUM       _IOW(0xab, 0x16, int) 
  #define MY_NBD_SET_BUFFERWR  _IOW(0xab, 0x17, int) 
  #define MY_NBD_INVALIDATE    _IOW(0xab, 0x18, int)
  #define MY_NBD_SET_SPID      _IOW(0xab, 0x19, int) 
  #define MY_NBD_SET_RQ_HANDLE _IOW(0xab, 0x1a, void*) 
  #define MY_NBD_SET_RQ_SEQNO  _IOW(0xab, 0x1b, int) 
  #define MY_NBD_SET_RQ_DIGEST _IOWR(0xab, 0x1d, enbd_digest_t) 
  #define ENBD_TEST_IOCTL4      _IOR(0xab, 0x1e, char[256])
  #define ENBD_TEST_IOCTL5      _IOWR(0xab, 0x1f, char[256])
  #define ENBD_TEST_IOCTL6      _IO(0xab, 0x20) // special r 256B
  #define ENBD_TEST_IOCTL7      _IO(0xab, 0x21) // special rw 256B
  #define ENBD_SET_BLKSIZE      _IOW(0xab, 0x22, int)
  #define ENBD_GET_BLKSIZE      _IOR(0xab, 0x23, long)
  #define ENBD_SET_PF_MEMALLOC  _IOW(0xab, 0x24, int)
  #define MY_NBD_SET_DIRECT    _IOW(0xab, 0x25, int) 
  #define MY_NBD_GET_NPORT     _IOR(0xab, 0x26, int)

#define MAX_NBD 16          /* PTB MAX was 128, but that's a lot */
#define ENBD_SHIFT 4         /* PTB 16 partitions/sockets/slots per device */
                            /* PTB number of socket slots per device */
#define ENBD_MAXCONN (1<<ENBD_SHIFT)
#define ENBD_SIGLEN 128      /* PTB length of sig on device */
#define ENBD_MAX_SECTORS 512 /* PTB max number of 512B sectors in a buffer */


#if defined(MAJOR_NR) || defined(__KERNEL__)
  /* PTB we are included from the kernel nbd.c file so put kernel stuff here */

  #include <linux/config.h>

  #define ENDREQ_NOCURRENT
  #define LOCAL_END_REQUEST
  #include <linux/blk.h>


  /* PTB various defaults */
  #define ENBD_RAHEAD_DFLT    24 /* PTB slow medium                  */
  #define ENBD_SYNC_INTVL      0 /* PTB sync every nK reqs (default disable) */
  #define ENBD_REQ_TIMEO       5 /* PTB client inactivity chk intvl (rollback) */
  #define ENBD_SPEED_LIM  100000 /* PTB limit to 100M write reqs/s */
  #define ENBD_MERGE_REQ_DFLT  0 /* PTB until accounting fixed! */
   /* PTB Jens Axboe says that plug should always be set in 2.4.* */
  #define ENBD_PLUG_DFLT       1 
  #define ENBD_MD5SUM_DFLT     0 

/*
 * PTB User messaging defs.
 */

  #define ENBD_ID "NBD #%d[%d]: %s "

  #define ENBD_DEBUG(level, s...) \
  { static int icnt; printk( KERN_DEBUG ENBD_ID, __LINE__, icnt++, __FUNCTION__); printk(s);}
  #define ENBD_ERROR( s...) \
  { static int icnt; printk( KERN_ERR   ENBD_ID, __LINE__, icnt++, __FUNCTION__); printk(s);}
  #define ENBD_ALERT( s...) \
  { static int icnt; printk( KERN_ALERT ENBD_ID, __LINE__, icnt++, __FUNCTION__); printk(s);}
  #define ENBD_INFO( s...)  \
  { static int icnt; printk( KERN_INFO  ENBD_ID, __LINE__, icnt++, __FUNCTION__); printk(s);}



    struct enbd_slot {
      struct file * file;      /* PTB add - for refcnt, NULL if slot empty */
      struct socket * sock;    /* PTB add                          */
      int in;                  /* PTB add - tot blocks entered     */
      int out;                 /* PTB add - tot blocks released    */
      int err;                 /* PTB add - tot blocks errored     */
      int req;                 /* PTB add - tot blocks pending     */
      char * buffer;           /* PTB add - user space buffer      */
      int  bufsiz;             /* PTB add - user space buffer size */
      struct list_head queue;
      unsigned long req_age;   /* PTB add - age of pending req     */
      unsigned long cli_age;   /* PTB add - age of client          */
      struct enbd_device *lo;   /* PTB add - parent device          */
    #define ENBD_SLOT_RUNNING   0x0001
    #define ENBD_SLOT_WAITING   0x0002
    #define ENBD_SLOT_BUFFERED  0x0004
    #define ENBD_SLOT_MD5SUM    0x8000 /* slot reply has a digest in it ..*/
    #define ENBD_SLOT_MD5_OK   0x10000 /* .. and equaled req's */
      int flags;               /* PTB add */
      int i;                   /* PTB add - slot number */
      int buflen;              /* PTB add - buffer byte count */
      int pid;                 /* PTB add - client process */
      int refcnt;              /* PTB add - so can set_sock/clr_sock ourself */
      int nerrs;               /* PTB add - local error count */
      int spid;                /* PTB add - server pid */
    };

  struct enbd_md;
  struct enbd_md {
    int count;
    struct semaphore access_sem;
    int (*notify_fn)(kdev_t, int);
    int (*notify)(struct enbd_md *,kdev_t);
    int (*unnotify)(struct enbd_md *,kdev_t);
    void (*dec)(struct enbd_md *);
    void (*inc)(struct enbd_md *);
    void (*reg)(struct enbd_md *, int(*)(kdev_t, int));
  };

  struct enbd_speed {
    atomic_t speed;                      /* PTB add - current speed in KB/s */
    atomic_t speedmax;                   /* PTB add - max speed */
    atomic_t speedav;                    /* PTB add - average speed */
    atomic_t distance;                   /* PTB add - last distance measure */
    atomic_t jiffy;                      /* PTB add - last jiffies speed set */
    atomic_t frstj;                      /* PTB add - first jiffies */
    void (*update)(struct enbd_speed*, int);
  };

  struct enbd_md_list {
    struct list_head list;
    kdev_t dev;
  };

  struct enbd_seqno;  // forward decl
  struct enbd_seqno {
      unsigned int seqno;                  /* PTB add - sequence number */
      atomic_t seqno_gen;                  /* PTB add - seqno genration */
      void (*inc)(struct enbd_seqno *);
      int  (*get)(struct enbd_seqno *);
      void (*reset)(struct enbd_seqno *);
      unsigned (*calc)(struct enbd_seqno *, unsigned);
  };


  struct enbd_acct {
      atomic_t requests_in[2];             /* PTB add - blocks put on queue */
      atomic_t requests_out[2];            /* PTB add - blocks out from queue */
      atomic_t requests_err;               /* PTB add - blocks erred on queue */
      atomic_t requests_req[2];            /* PTB add - read blocks pending */
      atomic_t kwaiters;                   /* PTB add - kernel thrds waiting */
      atomic_t kthreads;                   /* PTB add - kernel threads in */
      atomic_t maxq[2];                    /* PTB add - max req queue depth */
      atomic_t countq[2];                  /* PTB add - request queue depth */
      atomic_t cwaiters;                   /* PTB add - client thrds waiting */
      atomic_t cthreads;                   /* PTB add - client threads in */
      atomic_t req_in[2][1 + ENBD_MAX_SECTORS/2];
      atomic_t maxreqblks;                 /* PTB add - maximum req size seen */
      atomic_t kmax;                       /* PTB add - max kernel threads */
  };


  struct enbd_device {
      atomic_t refcnt;	

    #define ENBD_READ_ONLY   0x0001
    #define ENBD_WRITE_NOCHK 0x0002
    #define ENBD_INITIALISED 0x0004
    #define ENBD_SIGNED      0x0008

    #define ENBD_ENABLED     0x0010
    #define ENBD_SIZED       0x0020
    #define ENBD_BLKSIZED    0x0040

    #define ENBD_QBLOCKED    0x0100
    #define ENBD_SHOW_ERRS   0x0200
    #define ENBD_SYNC        0x0400
    #define ENBD_VALIDATED   0x0800         /* read partition table */

    #define ENBD_BUFFERWR    0x1000         /* buffer writes to device */
    #define ENBD_REMOTE_INVALID \
                            0x2000         /* remote resource vanished */
    #define ENBD_DIRECT      0x4000         /* convert opens to O_DIRECT */
    #define ENBD_MD5SUM      0x8000


      atomic_t flags;
      int harderror;		           /* Code of hard error	    */
      int magic;			   /* FIXME: not if debugging is off  */
      struct list_head queue;
      rwlock_t queue_lock;                 /* PTB add - spinlock */
      int nslot;                           /* PTB add - total slots */
      atomic_t islot;                      /* PTB add - current slot */
      int aslot;                           /* PTB add - total active slots*/
      struct enbd_acct acct;
      atomic_t wrequests_5so;              /* PTB add - write blocks md5 skip */
      atomic_t wrequests_5wo;              /* PTB add - write blocks md5 wr */
      atomic_t wrequests_5eo;              /* PTB add - write blocks md5 refus*/
      atomic_t wrequests_5to;              /* PTB add - write blocks md5sum */
      atomic_t wrequests_5co;              /* PTB add - write blocks md5 tot */
      atomic_t wrequests_5no;              /* PTB add - write blocks not md5 */
      struct enbd_seqno seqno_out;          /* PTB add - seq number */
      wait_queue_head_t wq;                /* PTB add */
      struct enbd_slot slots[ENBD_MAXCONN];  /* PTB add - client array */
      unsigned blksize;                    /* PTB add - device blksize in B */
      u64 bytesize;                        /* PTB add - device size in B */
      u64 sectors;                         /* PTB add - device size (sectors) */
      unsigned size;                       /* PTB add - device size in blks */
      unsigned logblksize;                 /* PTB add - log2 blksize */
      unsigned nbd;                        /* PTB add - this array index */
      int signature[ENBD_SIGLEN/sizeof(int)];
                                           /* PTB add - server sig */
      struct file * file;                  /* PTB add - for ref */
      struct inode * inode;                /* PTB add - for ref */
      int  bufsiz;                         /* PTB add - userspace buffer size */
      char *blockmap;                      /* PTB add - map of block states */
      unsigned long disabled;              /* PTB add - when was it disabled */
      int req_timeo;                       /* PTB add - inactivity timeout */
      struct timer_list run_queue;         /* PTB add - run queue */
      struct work_struct task_queue;       /* PTB add - task queue */
      char devnam[4];                      /* PTB add - drive letters */
      int max_sectors;                     /* PTB add - max req size allowed! */
      int lives;                           /* PTB add - # times enabled */
      // PTB speed measurement settings
      struct enbd_speed tspeed;
      struct enbd_speed wspeed;
      struct enbd_speed rspeed;
      int dummy;                           /* PTB add - unused */
      struct request *req;                 /* PTB fake request for ioctls */
      wait_queue_head_t req_wq;            /* PTB req done notifications */
      struct request *rq;                  /* PTB special request ptr */
      struct list_head altqueue;           /* PTB diverted requests */
      rwlock_t altqueue_lock;              /* PTB add - diverted reqs lock */
      atomic_t seqno_in;                   /* PTB add - unacked reqs */
      struct semaphore pid_sem;            /* PTB control setting pid */
      struct gendisk *disk;                /* PTB for partitions */
      struct request_queue *q;             /* PTB make queue internal */
      rwlock_t meta_lock;                  /* PTB add - spinlock meta data */
      atomic_t merge_requests;             /* PTB local req blks limit - 1 */
      unsigned long reenable_time;         /* PTB time to delayed reenable */
      void (*enable)    (struct enbd_device *lo);
      void (*reset)     (struct enbd_device *lo, int i);
      int  (*disable)   (struct enbd_device *lo);
      int  (*read_only) (struct enbd_device *lo);
      void (*set_speed) (struct enbd_device *lo);
      int  (*hard_reset)(struct enbd_device *lo);
      int  (*soft_reset)(struct enbd_device *lo);
      int  (*reenable_delay) (struct enbd_device *lo, int delay);
    };

#endif  /* MAJOR_NR */



/* Pavel - This now IS in some kind of include file...	*/

/* PTB 132 */ 
#define ENBD_INIT_MAGIC 0x12345678       /* AMARIN */
#define ENBD_REQUEST_MAGIC 0x25609513
#define ENBD_REPLY_MAGIC 0x67446698     
/* Pavel - Do *not* use magics: 0x12560953 0x96744668. 
 */

#define ENBD_DEV_MAGIC 0x68797548

#define ENBD_REQUEST_MAGIC_T  __u32
#define ENBD_REQUEST_TYPE_T   __u32
#define ENBD_REQUEST_FROM_T   __u64
#define ENBD_REQUEST_LEN_T    __u32
#define ENBD_REQUEST_FLAGS_T  __u32
#define ENBD_REQUEST_TIME_T   __u64
#define ENBD_REQUEST_ZONE_T   __u64
#define ENBD_REQUEST_SPECIAL_T  __u32

#define ENBD_REPLY_MAGIC_T    __u32
#define ENBD_REPLY_ERROR_T    __s32
#define ENBD_REPLY_FLAGS_T    __u32
#define ENBD_REPLY_TIME_T     __u64
#define ENBD_REPLY_ZONE_T     __u64

#define ENBD_REQUEST_HANDLE_T __u32
#define ENBD_REPLY_HANDLE_T   __u32

  typedef __u32 enbd_digest_t[4];

  #define ENBD_DIGEST_T   enbd_digest_t

#define ENBD_REQUEST_DIGEST_T enbd_digest_t
#define ENBD_REPLY_DIGEST_T   enbd_digest_t


#define ENBD_DIGEST_BITS      128
#define ENBD_DIGEST_LENGTH    ((ENBD_DIGEST_BITS)/8)
#define ENBD_REQUEST_SEQNO_T  __u32

struct enbd_request {
  ENBD_REQUEST_MAGIC_T  magic;
  ENBD_REQUEST_TYPE_T   type;			/* == READ || == WRITE 	*/
  ENBD_REQUEST_HANDLE_T handle;
  ENBD_REQUEST_FROM_T   from;                    /* 64 bit PTB 132 */
  ENBD_REQUEST_LEN_T    len;



#define ENBD_REQUEST_ERRORED    0x0800
#define ENBD_REQUEST_MD5SUM     0x8000         /* has a digest in it ..*/
#define ENBD_REQUEST_MD5_OK    0x10000         /* .. and equaled req's */
#define ENBD_REQUEST_IOCTL     0x40000         /* ioctl in len, arg in from */
#define ENBD_REQUEST_SPECIALRW 0x80000         /* 1 for w 0 for r on special */
  ENBD_REQUEST_FLAGS_T  flags;
  ENBD_REQUEST_TIME_T   time;
  ENBD_REQUEST_ZONE_T   zone;
  ENBD_REQUEST_SEQNO_T  seqno;
  union {
       ENBD_REQUEST_DIGEST_T digest;
  } data;
  ENBD_REQUEST_SPECIAL_T special;
  char dummy0[0];
  char dummy1[0] __attribute__ ((aligned (64)));
} __attribute__ ((packed)) ;

  #define ENBD_REQUEST_LENGTH sizeof(struct enbd_request)

struct enbd_reply {
  ENBD_REPLY_MAGIC_T    magic;
  ENBD_REPLY_ERROR_T    error;		      /* 0 = ok, else error	*/
  ENBD_REPLY_HANDLE_T   handle;	              /* handle you got from request */



#define ENBD_REPLY_ERRORED      0x0800
#define ENBD_REPLY_MD5SUM       0x8000         /* has a digest in it .. */
#define ENBD_REPLY_MD5_OK      0x10000         /* .. and equaled req's  */
#define ENBD_REPLY_CLOSE       0x20000         /* close cmd from server */
#define ENBD_REPLY_IOCTL       0x40000         /* ioctl in len, arg in from */
  ENBD_REPLY_FLAGS_T    flags;
  ENBD_REPLY_TIME_T     time;
  ENBD_REPLY_ZONE_T     zone;
  union {
       ENBD_REPLY_DIGEST_T digest;
  } data;
  char dummy0[0];
  char dummy1[0] __attribute__ ((aligned (64)));
} __attribute__ ((packed)) ;

  #define ENBD_REPLY_LENGTH sizeof(struct enbd_reply)

  #define ENBD_BUFFER_DATA_OFFSET \
   ((ENBD_REQUEST_LENGTH>ENBD_REPLY_LENGTH)?ENBD_REQUEST_LENGTH:ENBD_REPLY_LENGTH)

  #ifdef MAJOR_NR

  // PTB forward declaration
  static struct enbd_device enbd_dev[];


  static long wait_for_completion_timeout(struct completion *x, long timeout)
  {
	spin_lock_irq(&x->wait.lock);
	if (!x->done && timeout > 0) {
		DECLARE_WAITQUEUE(wait, current);

		wait.flags |= WQ_FLAG_EXCLUSIVE;
		__add_wait_queue_tail(&x->wait, &wait);
		do {
			__set_current_state(TASK_UNINTERRUPTIBLE);
			spin_unlock_irq(&x->wait.lock);
			timeout = schedule_timeout(timeout);
			spin_lock_irq(&x->wait.lock);
		} while (!x->done && timeout > 0);
		__remove_wait_queue(&x->wait, &wait);
	}
        if (x->done) {
	        x->done--;
                if (timeout <= 0)
                        timeout = 1;
        }
	spin_unlock_irq(&x->wait.lock);
        return timeout;
  }

  static void end_request(struct request *req, int uptodate) {  

     struct bio *bio;
     struct enbd_device *lo = req->rq_disk->private_data;
     static int rq_type(struct request *);
     struct enbd_acct * acct = &lo->acct;

     if (rq_type(req) == IOCTL) {
            // PTB this is the devices ioctl request 
            complete(req->waiting);
            // PTB let the driver code return the req, etc.
            return;
     }

     /* unlock chained buffers */
     while ((bio = req->bio) != NULL) {
            unsigned nsect = bio_sectors(bio);
            blk_finished_io(nsect);
            req->bio = bio->bi_next;
            bio->bi_next = NULL;
            bio_endio(bio, nsect << 9, uptodate ? 0 : -EIO);
     }

     if (req->flags & REQ_SPECIAL)
            // don't account specials
            return;

     write_lock(&lo->altqueue_lock);
     if (atomic_read(&acct->countq[READ])
       + atomic_read(&acct->countq[WRITE]) <= 0) {
            if (atomic_read(&lo->flags) & ENBD_QBLOCKED) {
                    static int enbd_requeue(struct enbd_device *);
                    enbd_requeue(lo);
                    atomic_clear_mask(ENBD_QBLOCKED, &lo->flags);
             } 
     }
     write_unlock(&lo->altqueue_lock);
  }
     
 /* 
  * PTB This takes the spinlock itself! So call it with the io spinlock
  * not held.
  */
  static void end_request_lock(struct request *req, int uptodate) {  

     unsigned long flags;
     request_queue_t *q = req->q;

     spin_lock_irqsave(q->queue_lock, flags);
     end_request(req, uptodate);
     spin_unlock_irqrestore(q->queue_lock, flags);
  }

 /*
  * PTB Call this only with the io spinlock * held.
  */
  static inline void enbd_end_request(struct request *req) {

    // PTB the kernel has only 2 queues, read and write, and it uses
    // the cmd field to determine to which the req belongs. We add a
    // seqno to it in enbd_do_req, so we reestablish it here.
    static void rq_set_seqno(struct request *, int);

    rq_set_seqno(req, 0); // PTB Zero extra seqno info
    end_request( req, (req->errors == 0) ? 1 : 0 );
  }

 /* 
  * PTB This takes the spinlock itself! So call it with the io spinlock
  * not held.
  */
  static void enbd_end_request_lock(struct request *req) {  

    // PTB the kernel has only 2 queues, read and write, and it uses
    // the cmd field to determine to which the req belongs. We add a
    // seqno to it in enbd_do_req, so we reestablish it here.
    static void rq_set_seqno(struct request *, int);

    rq_set_seqno(req, 0); // PTB Zero extra seqno info
    end_request_lock( req, !req->errors );
  }

  extern int enbd_init_seqno(struct enbd_seqno *);
  extern int enbd_init_speed(struct enbd_speed *);
  extern int enbd_init_md(struct enbd_md *);
  extern void enbd_init_proc(struct proc_dir_entry *res);

  #endif /* MAJOR_NR */

#endif /* LINUX_ENBD_H */


