/* 
 * Copyright (C) 1999-2001 Peter T. Breuer <ptb@it.uc3m.es>
 */


#ifndef CLISERV_H
#define CLISERV_H

/* This header file is shared by client & server. They really have
 * something to share...
 * */

/* Client/server protocol is as follows:
   Send INIT_PASSWD
   Send 64-bit cliserv_magic
   Send 32-bit blocksize
   Send 64-bit size of exported device
   Send 16 bit total daemons requested
 */

#include "config.h"

#ifndef u8
#if SIZEOF_UNSIGNED_CHAR==1
  typedef unsigned char u8;
#elif SIZEOF_UNSIGNED_SHORT_INT==1
  typedef unsigned short u8;
#else
#error I need at least some 8-bit unsigned type
#endif
#endif

#ifndef u16
#if SIZEOF_UNSIGNED_SHORT_INT==2
  typedef unsigned short u16;
#elif SIZEOF_UNSIGNED_CHAR==2
  typedef unsigned char u16;
#else
#error I need at least some 16-bit unsigned type
#endif
#endif

#ifndef u32
#if SIZEOF_UNSIGNED_SHORT_INT==4
  typedef unsigned short u32;
#elif SIZEOF_UNSIGNED_INT==4
  typedef unsigned int u32;
#elif SIZEOF_UNSIGNED_LONG_INT==4
  typedef unsigned long u32;
#else
#error I need at least some 32-bit unsigned type
#endif
#endif

#ifndef u64
#if SIZEOF_UNSIGNED_INT==8
  typedef unsigned int u64;
#elif SIZEOF_UNSIGNED_LONG_INT==8
  typedef unsigned long u64;
#elif SIZEOF_UNSIGNED_LONG_LONG_INT==8
  typedef unsigned long long u64;
#else
#error I need at least some 64-bit unsigned type
#endif
#endif

#ifndef s64
#if SIZEOF_UNSIGNED_INT==8
  typedef int s64;
#elif SIZEOF_UNSIGNED_LONG_INT==8
  typedef long s64;
#elif SIZEOF_UNSIGNED_LONG_LONG_INT==8
  typedef long long s64;
#else
#error I need at least some 64-bit signed type
#endif
#endif

#define MAXDEV  8            /* number of nbd whole devices */
#define ENBD_MAX_LIVES 30     /* number of internal rebirths per daemon */

static const u64 cliserv_magic = 0x00420281861253LL;
#define INIT_PASSWD "NBDMAGIC"

#if DEBUG > 0
  #if DEBUG > 1
    #define DODBG
  #endif
  #define DEBUG_DFLT 1
  #undef DEBUG
  #define DEBUG( a... ) if(debug_level > 0) PERR(a) /**/
#else
  #undef DEBUG
  #define DEBUG( a... )
  #define DEBUG_DFLT 0
#endif

#define MSG(s...) { \
          syslog(LOG_DAEMON|LOG_INFO|LOG_CONS|LOG_PERROR, MY_NAME ": " s) ; \
	  fflush(stderr); \
	  fprintf(stderr, MY_NAME " %5d:", getpid()); \
	  fprintf(stderr, " " s); \
	  fflush(stderr); \
   }
/* syslog logging client side too seems to be better! */
#define RETRIES 3
#define TRY_RESET 100
#define PERR(s1, s2...) { \
          static int nerrs; \
          if (nerrs >= TRY_RESET) \
            nerrs = 0; \
          if (nerrs++ < RETRIES) { \
            syslog(LOG_DAEMON|LOG_INFO|LOG_CONS|LOG_PERROR, \
                    MY_NAME " %5d: <#%4d> %s " s1, \
                    getpid(), __LINE__, __FUNCTION__ ,## s2); \
	    fflush(stderr); \
	    fprintf(stderr, \
                    MY_NAME " %5d: <#%4d> %s " s1, \
                    getpid(), __LINE__, __FUNCTION__ ,## s2); \
	    fflush(stderr); \
	  } \
	}

//#include <netinet/in.h>

#ifdef WORDS_BIGENDIAN
static inline u64 ntohll(u64 a)
{
	return a;
}
#else
static inline u64 ntohll(u64 a)
{
	u32 lo = a & 0xffffffff;
	u32 hi = a >> 32U ;
	lo = ntohl(lo);
	hi = ntohl(hi);
	return ((u64) lo) << 32U | hi;
}
#endif
#define htonll ntohll

#define id(n) n
#define strfy(n) #n

#ifndef WRITE
  #define WRITE 0x01
#endif
#ifndef READ
  #define READ  0x00
#endif
#ifndef IOCTL
  #define IOCTL 0x02
#endif
#define CKSUM 0x03
#ifndef SPECIAL
  #define SPECIAL 0x04
#endif

#define PIDDIR "/var/run"
#define STATDIR "/var/state"

// PTB negotiation data string lengths
#define ENBD_NPORT_LEN 4        /* 4 decmial digits */
#define ENBD_BLKSIZE_LEN 4      /* 4 decmial digits */
#define ENBD_PULSE_INTVL_LEN 4  /* 4 decmial digits */
#define ENBD_RDEV_LEN 4         /* 4 hex digits */
#define ENBD_MAGIC_LEN 16       /* 16 hex digits */
#define ENBD_PASSWD_LEN 8       /* 8 ascii chars */
#define ENBD_SIZE_LEN 31        /* 31 decmial digits */
#define ENBD_RO_LEN 3           /* 3 ascii chars */
#define ENBD_PORT_LEN 5         /* 5 decmial digits */



#endif /* CLISERV_H */
