/* 
 * Copyright (C) 1999-2001 Peter T. Breuer <ptb@it.uc3m.es>
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <netdb.h>
#include <net/if.h>             /* ifreq, IFNAMSIZ */
#include <sys/socket.h>         /* inet_network    */
#include <netinet/in.h>         /* inet_network    */
#include <arpa/inet.h>          /* inet_network    */
#include <unistd.h>             /* close           */
   
#include "enbd_conf.h"


static void setconfent(struct nbd_confent * self) {
   if (!self->fp)
     self->fp = fopen(NBD_CONFIG_FILE, "r");
   if (!self->fp)
     return;
   rewind(self->fp);
}
static void endconfent(struct nbd_confent * self) {
   if (!self->fp)
     return;
   fclose(self->fp);
   self->fp = NULL;
}

static int getconfent(struct nbd_confent * self) {

   # define NBD_CONFIG_BUFLEN 1024

   static const int buflen = NBD_CONFIG_BUFLEN;
   static char buffer[NBD_CONFIG_BUFLEN];
   static char * wordv[NBD_CONFIG_BUFLEN/2];

   if (!self->fp)
     return -1;
 next_line:
   if (!fgets(buffer,buflen,self->fp))
     return -1;
   self->target = strtok(buffer," \t\r\n");
   if (!self->target)
     goto next_line;
   if (0 != strcmp("module",self->target)
   &&  0 != strcmp("server",self->target)
   &&  0 != strcmp("client",self->target)
   )
     goto next_line;

   self->id = strtok(NULL," \t\r\n");
   if (!self->id)
     goto next_line;

   if (0 == strcmp("module",self->target)) {

     char * word = strtok(NULL," \t\r\n");
     int wordc = 0;

     while (word && wordc < NBD_CONFIG_BUFLEN/2 - 1) {
        wordv[wordc++] = word;
        word = strtok(NULL," \t\r\n");
     }
     wordv[wordc] = NULL;
     self->options = wordv;
     return 0;
   }

   if (0 == strcmp("client",self->target)) {

     char * port;
     char * word;
     int wordc = 0;

     self->device = strtok(NULL," \t\r\n");
     if (!self->device)
       goto next_line;

     self->server = strtok(NULL," \t\r\n");
     if (!self->server)
       goto next_line;

     port   = strtok(NULL," \t\r\n");
     if (!port)
       goto next_line;

     if (sscanf(port," %hd ",&self->port) < 1)
       goto next_line;

     if (self->port < 0)
       goto next_line;

     word = strtok(NULL," \t\r\n");

     while (word && wordc < NBD_CONFIG_BUFLEN/2 - 1) {
        wordv[wordc++] = word;
        word = strtok(NULL," \t\r\n");
     }
     wordv[wordc] = NULL;
     self->options = wordv;
     return 0;
   }
   if (0 == strcmp("server",self->target)) {

     char * resources, *word;
     char * port   = strtok(NULL," \t\r\n");
     int wordc = 0;

     if (!port)
       goto next_line;

     if (sscanf(port," %hd ",&self->port) < 1)
       goto next_line;

     if (self->port < 0)
       goto next_line;

     resources   = strtok(NULL," \t\r\n");
     if (!resources)
       goto next_line;

     word = strtok(NULL," \t\r\n");

     while (word && wordc < NBD_CONFIG_BUFLEN/2 - 1) {
        wordv[wordc++] = word;
        word = strtok(NULL," \t\r\n");
     }
     wordv[wordc] = NULL;
     self->options = wordv;

     {
       static char* resourcev[64];
       int resourcec = 0;
       char * resource;

       resource = strtok(resources,",");
       while (resource) {
            resourcev[resourcec++] = resource;
            resource = strtok(NULL," \t\r\n");
       }
       resourcev[resourcec] = NULL;
       self->resources = resourcev;
     }

     return 0;
   }
   return -1;

}

void init_nbd_conf(struct nbd_confent * self) {

  self->fp = NULL;
  self->set = setconfent;
  self->end = endconfent;
  self->get = getconfent;

}


