/* 
 * Copyright (C) 1999-2001 Peter T. Breuer <ptb@it.uc3m.es>
 */

#ifndef ENBD_CLIENT_H
#define ENBD_CLIENT_H 1

// for client/kernel interface only
#define SYNC_INTVL 1

struct nbd_client {
   char*       hostname; /* PTB local host */
   int         ctlp;     /* PTB control port */
   int         port;     /* PTB session port */
   int         saddr;    /* PTB local addr */
   int         daddr;    /* PTB dest addr */
   int         pid;      /* PTB daemon pid */
   int         slot;     /* PTB kernel slot */
   int*        sig;      /* PTB imported device signature */
   int         i;        /* PTB client identifier */
   struct nbd_stream stream;
                         /* PTB open socket descriptor */
                         /* AMARIN SSL open socket descriptor */
   int         dev;      /* PTB nbd device descriptor */
#define ENBD_CLIENT_READONLY    0x0001    /* same as ENBD_READ_ONLY */
#define ENBD_CLIENT_INITIALISED 0x0004
#define ENBD_CLIENT_SIGNED      0x0008

#define ENBD_CLIENT_DEBUG       0x0010
#define ENBD_CLIENT_NEGOTIATED  0x0020
#define ENBD_CLIENT_SERVER_RO   0x0040
#define ENBD_CLIENT_PREFER_BM   0x0080

#define ENBD_CLIENT_SHOW_ERRS   0x0100    /* same as ENBD_SHOW_ERRS */
#define ENBD_CLIENT_USING_SSL   0x0200
#define ENBD_CLIENT_INTRODUCED  0x0400
#define ENBD_CLIENT_ASYNC       0x0800    /* ack writes before waiting     */

#define ENBD_CLIENT_WRPLY_PEND  0x1000    /* write ack is pending      */
#define ENBD_CLIENT_SESSION     0x2000
#define ENBD_CLIENT_SLAVE       0x4000
#define ENBD_CLIENT_MD5SUM      0x8000    /* ENBD_MD5SUM checksumming protocol */

#define ENBD_CLIENT_RETRY      0x10000    /* retry opens on device as needed*/
#define ENBD_CLIENT_OPEN       0x20000    /* main device is open OK */
#define ENBD_CLIENT_OPENWANTED 0x40000    /* main device wants open */
#define ENBD_CLIENT_INVALID    0x80000    /* remote resource disappeared */

#define ENBD_CLIENT_SWAPPING  0x100000    /* doing mlockall for swapping */
#define ENBD_CLIENT_BUFFERWR  0x200000    /* doing write buffering in kernel */
#define ENBD_CLIENT_USE_MAIN  0x400000    /* ioctls go to whole disk device */

#ifndef ENBD_SHOW_ERRS_DFLT
#  define ENBD_SHOW_ERRS_DFLT 0
#endif
#ifndef ENBD_BUFFER_WRITES_DFLT
#  define ENBD_BUFFER_WRITES_DFLT 0
#endif
#ifndef ENBD_RO_DFLT
#  define ENBD_RO_DFLT 0
#endif
#ifndef ENBD_ASYNC_DFLT
#  define ENBD_ASYNC_DFLT 0
#endif
#ifndef ENBD_CKSUM_DFLT
#  define ENBD_CKSUM_DFLT 0
#endif
#ifndef ENBD_SWAP_DFLT
#  define ENBD_SWAP_DFLT 0
#endif
   int         flags;    /* PTB are we a client daemon? */
   int         ppid;     /* PTB parent pid */
   int         pgid;     /* PTB process group */
   u64         size;     /* PTB size of device in bytes */
   //int         nmirror;
   //int         mirror[MAXDEV];

# define ENBD_CLIENT_WO 1
# define ENBD_CLIENT_RO 2
# define ENBD_CLIENT_RW 3
//# define ENBD_CLIENT_MR 4    /* PTB mirror */
# define ENBD_CLIENT_DR 8    /* PTB direct */

   int         type;
   char *      ioctlbuf; /* used to ferry info to/from kernel */
#ifndef ENBD_MAX_LIVES
#  define ENBD_MAX_LIVES 30
#endif
   int         count;    /* PTB how often have we renegotiated */
#ifndef ENBD_NEGOTIATE_TIMEOUT_DFLT
#  define ENBD_NEGOTIATE_TIMEOUT_DFLT 120
#endif
   int         negotiate_timeout;
                         /* PTB and what was the timeout each time! */
   int         data_timeout;
                         /* PTB how long we wait for a server reply */
#ifndef ENBD_PULSE_INTVL_DFLT
#  define ENBD_PULSE_INTVL_DFLT 10
#endif
   int         pulse_intvl;
                         /* PTB how long bwtween heartbeats? */
   struct nbd_stub_server server;
   dev_t       rdev;    /* PTB in order to tell to the server */
#ifndef ENBD_BLKSIZE_DFLT
#  define ENBD_BLKSIZE_DFLT 1024
#endif
   int   blksize;       /* PTB device blocksize - shared, dflt 1024 */
   char  *cid;          /* PTB client identifier (-i flag) */
   struct  nbd_pidfile
         pidfile;       /* PTB where we keep our chiefs pid */
   int   pfd;           /* PTB descriptor for where we keep our chiefs pid */
   char *name;          /* PTB /dev/nda or /dev/nd/a  base */
   int (*open)(struct nbd_client *self);
   int (*ioctl)(struct nbd_client *self, int request, char *argp);
   int (*close)(struct nbd_client *self);
   int (*start)(struct nbd_client *self);
   int port0;           /* PTB offset for first port */
#ifndef ENBD_MAX_LIVES_DFLT
#  define ENBD_MAX_LIVES_DFLT 0
#endif
   int max_lives;
   int group;           /* PTB indicates which group of clients we are in */
   struct nbd_client_session * session;
   unsigned long sigvector; /* PTB signals that we need to treat */
   void (*sighandler)(struct nbd_client *, int n);
};


struct nbd_client_session {
   struct nbd_client client; // PTB generic cmdline data
   struct {
     int pid;
     int count;
     struct timeval tv;
   }  pids[ENBD_MAXCONN];
   int   nport;               // PTB total number of ports - shared 
   // PTB clients is really only needed to hold particular cmdline data
   struct nbd_client clients[ENBD_MAXCONN+1];
   //char *hostname[ENBD_MAXGROUP];
   //int ctlp[ENBD_MAXGROUP];
   //int ngroup;
 };

extern int debug_level;

#endif
