#ifndef NBD_HASH_H
#define NBD_HASH_H 1

#define NBD_HASH_INSERT  0
#define NBD_HASH_REPLACE 1

struct hash_datum {
    int  dsize;
    char *dptr;
};

struct nbd_hash_entry {
    struct list_head  q;        // hash queue linking
    struct list_head  u;        // used entry linking
    struct hash_datum k;
    struct hash_datum d;
};

struct nbd_hash {
      int dsize;
      int nbuckets; // 64
      int nfreebkt; // 32
# define NBD_HASH_MODE_LIMIT 1
      int mode;                  // decides whether we drop old entries
      int count;                 // used list and count
      int hiwater;               // used list hiwater mark
      int lowater;               // used list lowater mark
      int max;                   // used list max so far
      struct list_head used;
      struct list_head hash[64]; // linked from hash buckes
      int freecount[32];
      struct list_head free[32]; // size of items in powers of 4
      struct hash_datum (*fetch)(struct nbd_hash *hash, struct hash_datum hkey);
      int (*store)(struct nbd_hash *hash, struct hash_datum hkey, struct hash_datum hdata, unsigned flags);
      int (*delete)(struct nbd_hash *hash, struct hash_datum hkey);
      struct hash_datum (*firstkey)(struct nbd_hash *hash);
      struct hash_datum (*nextkey)(struct nbd_hash *hash, struct hash_datum hkey);
      //int (*shrink)(struct nbd_hash *hash);
      int (*shrink_test)(void *);
      int (*register_shrink_test)(struct nbd_hash *hash, int (*test)(void *));
      int (*unregister_shrink_test)(struct nbd_hash *hash);
      struct nbd_lock lock;
      int hfd; // file descriptor
      int off; // offset in file descriptor
      int data[0];
};

void init_hash(struct nbd_hash *hash, int size, int hfd, int off, int limit, unsigned mode);

#endif /*  NBD_HASH_H */
