/* 
 * Copyright (C) 1999-2001 Peter T. Breuer <ptb@it.uc3m.es>
 */

#ifndef ENBD_CLIENT_SERVER
#define ENBD_CLIENT_SERVER 1

struct nbd_client;

struct nbd_stub_server {

#define ENBD_CLIENT_CACHE_NETMAGIC     0xabaddaba
#define ENBD_CLIENT_CACHE_CACHEMAGIC   0xabbadbac
#define ENBD_CLIENT_CACHE_FILEMAGIC    0xabcdeffa
#define ENBD_CLIENT_CACHE_GENMAGIC     0xbbcdabaf
  unsigned long magic;

#define ENBD_CLIENT_CACHE_WRITETHROUGH 0x01
#define ENBD_CLIENT_CACHE_WRITEBACK    0x02
#define ENBD_CLIENT_CACHE_READTHROUGH  0x04
#define ENBD_CLIENT_CACHE_READBACK     0x08
#define ENBD_CLIENT_CACHE_ENABLED      0x10
#define ENBD_CLIENT_CACHE_INITIALIZED  0x20


#ifndef ENBD_CLIENT_WRPLY_PEND
  #define ENBD_CLIENT_WRPLY_PEND       0x1000
#endif

   unsigned long flags;
   short i;                              // PTB client identifier
   void *media;                          // PTB this is what we write to
   void *altmedia;                       // PTB this can be anything, shucks
   void *nextmedia;                      // PTB this can be anything, shucks
   s64   size;
   int seqno;                            // PTB current req seqno
   u32 handle;                           // PTB currentr req handle 
   enbd_digest_t digest;                 // PTB currentr req digest

   int (*write)(struct nbd_stub_server *self,char *buf,int len,s64 from);
   int (*read)(struct nbd_stub_server *self,char *buf,int len,s64 from);
   int (*check)(struct nbd_stub_server *self);
                                         // PTB how = 1 for one flush attempt
                                         // PTB how = n for many flush attempts
                                         // PTB how = 0 for invalidate alone
   int (*sync)(struct nbd_stub_server *self, unsigned how);
                                         // PTB flags =
                                         // ENBD_CLIENT_CACHE_ENABLED for cache on
                                         // PTB flags = 0 for cache off
   int (*sum)(struct nbd_stub_server *self, u32 digest[4], int len, s64 from);
   unsigned long (*setflags)(struct nbd_stub_server *self, unsigned long flags);
   unsigned long (*getflags)(struct nbd_stub_server *self);
   unsigned long (*resetflags)(struct nbd_stub_server *self, unsigned long flags);
   int (*ioctl)(struct nbd_stub_server *self, int ioctl, char * arg);
   int (*special)(struct nbd_stub_server *self, int rw, int len, u64 from);
};

extern void
init_netserver(struct nbd_stub_server *self, short i,
     s64 size, void * stream_resource, short ro,
     void *alternate, short async);

extern void
init_cacheserver(struct nbd_stub_server *self,
     short i, s64 size, void * resource, short alternate_ro,
     void *alternate);

extern void
init_fileserver(struct nbd_stub_server *self,
     short i, s64 size, void * file_resource, short ro,
     void *alternate);

extern void
init_stub_server(struct nbd_stub_server *self,
    unsigned long flags, int i, u64 size, int journal,
    struct nbd_stub_server * netserver, struct nbd_stub_server * cacheserver
    );

#endif /* ENBD_CLIENT_SERVER */
