#include "encompass.h"

void encompass_save_prefs (BrowserWindow * window) {
}

void encompass_load_prefs (BrowserWindow * window) {
  GError * gconf_error = NULL;

  window->prefs->gconf_client = gconf_client_get_default ();
  if (!window->prefs->gconf_client)
    g_error ("cannot create gconf_client\n");
  gconf_client_add_dir (window->prefs->gconf_client,
			"/system/gnome-vfs",
			GCONF_CLIENT_PRELOAD_ONELEVEL, &gconf_error);
  if (gconf_error)
    g_error ("gconf error: %s\n", gconf_error->message);
 
  window->prefs->use_proxy = gconf_client_get_bool (window->prefs->gconf_client,
						    "/system/gnome-vfs/use-http-proxy",
						    NULL);
  window->prefs->use_pauth = gconf_client_get_bool (window->prefs->gconf_client,
						    "/system/gnome-vfs/use-http-proxy-authorization",
						    NULL);
  window->prefs->proxy_host = gconf_client_get_string (window->prefs->gconf_client,
						       "/system/gnome-vfs/http-proxy-host",
						       NULL);
  window->prefs->proxy_port = gconf_client_get_int (window->prefs->gconf_client,
						       "/system/gnome-vfs/http-proxy-port",
						       NULL);

  gnome_config_push_prefix ("Encompass/");

  window->prefs->themename = gnome_config_get_string ("Options/Theme=default");

  gnome_config_pop_prefix ();
}
