#include "encompass.h"

struct _ESSLCert {
  gchar * from;
  gchar * to;

  gchar * sCountry;
  gchar * sState;
  gchar * sLocality;
  gchar * sOrganization;
  gchar * sOrgUnit;
  gchar * sCNAME;

  gchar * iCountry;
  gchar * iState;
  gchar * iLocality;
  gchar * iOrganization;
  gchar * iOrgUnit;
  gchar * iCNAME;
};

static gboolean IS_THIS_SSL_CERT_GOOD_BECAUSE_NEON_IS_ON_CRACK;

void e_free_certs (gchar * name, ESSLCert * key, BrowserWindow * window) {
  g_free (key->from);
  g_free (key->to);

  g_free (key->sCountry);
  g_free (key->sState);
  g_free (key->sLocality);
  g_free (key->sOrganization);
  g_free (key->sOrgUnit);
  g_free (key->sCNAME);

  g_free (key->iCountry);
  g_free (key->iState);
  g_free (key->iLocality);
  g_free (key->iOrganization);
  g_free (key->iOrgUnit);
  g_free (key->iCNAME);
}

static void * e_for_each (gchar * key, ESSLCert * value,
			  const ne_ssl_certificate * cert) {
  const ESSLCert * crack;

  crack = g_hash_table_lookup (ECerts, key);

  if (!strcmp (crack->sCNAME, cert->subject->commonName) &&
      !strcmp (key, cert->subject->commonName)) {
    IS_THIS_SSL_CERT_GOOD_BECAUSE_NEON_IS_ON_CRACK = TRUE;
  } else {
    IS_THIS_SSL_CERT_GOOD_BECAUSE_NEON_IS_ON_CRACK = FALSE;
  }
}

gint encompass_ssl_verify (BrowserWindow * window, int failures,
			   const ne_ssl_certificate * cert) {
  GtkWidget * mbox, * label;
  gchar * errmsg;
  gint retval;
  ESSLCert * foobar;

  /* TODO: Implement a real dialog and better error checking */

  if (failures & ~NE_SSL_FAILMASK) {
    printf ("ERROR: Unknown SSL Certificate failure.\n");
    return -1;
  }

  g_hash_table_foreach (ECerts, (GHFunc) e_for_each, (gpointer) cert);

  if (IS_THIS_SSL_CERT_GOOD_BECAUSE_NEON_IS_ON_CRACK) {
    return 0;
  }

  if (failures & NE_SSL_EXPIRED) {
    errmsg = g_strdup (_("Certificate has expired.\n\n"
			 "Do you wish to continue?"));
  }
  if (failures & NE_SSL_UNKNOWNCA) {
    errmsg = g_strdup (_("The security certificate was issued by a company\n"
			 "you have not chosen to trust.\n\n"
			 "Do you wish to continue?"));
  }
  if (failures & NE_SSL_CNMISMATCH) {
    errmsg = g_strdup (_("The hostname of the certificate does not match\n"
			 "the hostname of the server.\n\n"
			 "Do you wish to continue?"));
  }
  if (failures & NE_SSL_NOTYETVALID) {
    errmsg = g_strdup (_("The security certificate is not yet valid.\n\n"
			 "Do you wish to continue?"));
  }

  /* TODO: These need to go in some sort of "View Cert" dialog instead */

  printf ("DEBUG: Valid from %s until %s\n", cert->from, cert->until);
  printf ("DEBUG: Issued by: %s\n", cert->issuer->organization);
  printf ("DEBUG: Issued to: %s\n", cert->subject->organization);
  printf ("DEBUG: Domain: %s\n", cert->subject->commonName);

  mbox = gnome_message_box_new (errmsg, GNOME_MESSAGE_BOX_WARNING,
				GNOME_STOCK_BUTTON_YES,
				GNOME_STOCK_BUTTON_NO, NULL);
  retval = gnome_dialog_run_and_close (GNOME_DIALOG (mbox));

  if (retval == 0) {
    ESSLCert * ecert;

    ecert = g_new0 (ESSLCert, 1);

    ecert->from = g_strdup (cert->from);
    ecert->to = g_strdup (cert->until);

    ecert->sCountry = g_strdup (cert->subject->country);
    ecert->sState = g_strdup (cert->subject->state);
    ecert->sLocality = g_strdup (cert->subject->locality);
    ecert->sOrganization = g_strdup (cert->subject->organization);
    ecert->sOrgUnit = g_strdup (cert->subject->organizationalUnit);
    ecert->sCNAME = g_strdup (cert->subject->commonName);

    ecert->iCountry = g_strdup (cert->issuer->country);
    ecert->iState = g_strdup (cert->issuer->state);
    ecert->iLocality = g_strdup (cert->issuer->locality);
    ecert->iOrganization = g_strdup (cert->issuer->organization);
    ecert->iOrgUnit = g_strdup (cert->issuer->organizationalUnit);
    ecert->iCNAME = g_strdup (cert->issuer->commonName);

    g_hash_table_insert (ECerts, ecert->sCNAME, ecert);
  }

  return retval;
}

void * encompass_ssl_provide_cert (BrowserWindow * window,
				   ne_session * session,
				   const ne_ssl_dname * dname) {
  printf ("DEBUG: server: %s\n", ne_ssl_readable_dname (dname));
}
