#include "encompass.h"

void encompass_create_toolbars (BrowserWindow * window) {
  GtkWidget * label;
  GtkWidget * hbox;
  GtkWidget * urlpixmap;
  GtkWidget * toolbar;
  gchar * temp;

  /* Create the Navigation toolbar */
  window->navbar = bonobo_dock_item_new ("navbar",
					 BONOBO_DOCK_ITEM_BEH_EXCLUSIVE);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window->navbar), hbox);

  toolbar = gtk_toolbar_new ();
  gtk_container_set_border_width (GTK_CONTAINER (toolbar), 2);
  gtk_box_pack_start (GTK_BOX (hbox), toolbar, TRUE, TRUE, 0);

  window->back_tool_item =
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
			      GTK_STOCK_GO_BACK,
			      _("Go Back"), NULL,
			      G_CALLBACK (encompass_history_go_back),
			      window, 0);
  gtk_widget_show (window->back_tool_item);
  gtk_widget_set_sensitive (window->back_tool_item, FALSE);

  gtk_widget_show (toolbar);
  gtk_widget_show (hbox);
  
  window->fore_tool_item =
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
			      GTK_STOCK_GO_FORWARD,
			      _("Go Forward"), NULL,
			      G_CALLBACK (encompass_history_go_forward),
			      window, 1);
  gtk_widget_show (window->fore_tool_item);
  gtk_widget_set_sensitive (window->fore_tool_item, FALSE);

  gtk_widget_show (toolbar);
  gtk_widget_show (hbox);

  window->stop_tool_item =
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
			      GTK_STOCK_STOP,
			      _("Stop Loading"), NULL,
			      G_CALLBACK (encompass_http_stop), window, 2);
  gtk_widget_show (window->stop_tool_item);
  gtk_widget_set_sensitive (window->stop_tool_item, FALSE);

  gtk_widget_show (toolbar);
  gtk_widget_show (hbox);
  
  bonobo_dock_add_item (BONOBO_DOCK (GNOME_APP (window->window)->dock),
			BONOBO_DOCK_ITEM (window->navbar), BONOBO_DOCK_TOP,
			2, 0, 0, FALSE);
  gtk_widget_show (window->navbar);

  /* Create the URL Toolbar */
  window->urlbar = bonobo_dock_item_new ("urlbar",
					 BONOBO_DOCK_ITEM_BEH_EXCLUSIVE);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (window->urlbar), hbox);
  gtk_container_border_width (GTK_CONTAINER (window->urlbar), 2);

  temp = elysium_pixmap_file ("encompass/url.png");
  urlpixmap = gnome_pixmap_new_from_file_at_size (temp, 22, 22);
  gtk_box_pack_start (GTK_BOX (hbox), urlpixmap, FALSE, FALSE, 0);
  gtk_widget_show (urlpixmap);
  g_free (temp);

  label = gtk_label_new (_("Location:"));
  gtk_box_pack_start (GTK_BOX (hbox), label,
		      FALSE, FALSE, 0);
  gtk_widget_show (label);

  window->entry = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (window->entry), "activate",
		      GTK_SIGNAL_FUNC (encompass_entry_goto_url), window);
  gtk_box_pack_start (GTK_BOX (hbox), window->entry, TRUE, TRUE, 0);
  gtk_widget_show (window->entry);
  gtk_widget_show (hbox);

  bonobo_dock_add_item (BONOBO_DOCK (GNOME_APP (window->window)->dock),
			BONOBO_DOCK_ITEM (window->urlbar), BONOBO_DOCK_TOP,
			2, 0, 0, FALSE);
  gtk_widget_show (window->urlbar);
}
