#include "encompass.h"
#include <libgnomeui/gnome-window-icon.h>

static void encompass_selection_get (GtkWidget *widget,
				     GtkSelectionData *selection_data,
				     guint info, guint time_stamp,
				     BrowserWindow * window) {
  gchar *text;

  text = gtk_object_get_data (GTK_OBJECT(window->window), "selection");
  g_return_if_fail (text != NULL);

  gtk_selection_data_set (selection_data, GDK_SELECTION_TYPE_STRING,
			  8, text, strlen (text));
  g_free (text);
}

static void encompass_window_destroy (GtkWidget * widget, GdkEvent * event,
				      BrowserWindow * window) {
  if (num_wins > 1) {
    num_wins--;
    gtk_widget_destroy (window->window);
    g_free (window);
  } else {
    encompass_main_quit (widget, window);
  }
}

void encompass_window_close (GtkWidget * widget, BrowserWindow * window) {
  encompass_window_destroy (widget, NULL, window);
}

void encompass_toggle_statusbar (GtkWidget * widget, BrowserWindow * window) {
  if (!GTK_CHECK_MENU_ITEM (widget)->active) {
    gtk_widget_hide (GNOME_APP (window->window)->statusbar);
    gtk_widget_queue_resize (window->window);
  } else {
    gtk_widget_show (GNOME_APP (window->window)->statusbar);
    gtk_widget_queue_resize (window->window);
  }
  window->prefs->hidestatusbar = GTK_CHECK_MENU_ITEM (widget)->active;
}

void encompass_create_window (GtkWidget * widget, gchar * url) {

  BrowserWindow * window;
  GtkWidget * scrwin;

  window = g_new0 (BrowserWindow, 1);

  window->prefs = g_new0 (EncompassPrefs, 1);

  window->window = NULL;
  window->tips = NULL;
  window->status = NULL;
  window->animator = NULL;
  window->entry = NULL;

  window->go_position = 0;
  window->group = NULL;
  window->go_list = NULL;
  window->sessions = NULL;

  window->window = gnome_app_new ("Encompass",
				  _("Encompass: <Untitled>"));
  gtk_widget_realize (window->window);
  
  encompass_load_prefs (window);

  window->tips = gtk_tooltips_new ();
  gtk_signal_connect (GTK_OBJECT (window->window), "delete_event",
		      GTK_SIGNAL_FUNC (encompass_window_destroy), window);

  window->status = gnome_appbar_new (TRUE, TRUE, GNOME_PREFERENCES_NEVER);
  gnome_app_set_statusbar (GNOME_APP (window->window), window->status);

  gnome_window_icon_set_from_file (GTK_WINDOW (window->window),
				   elysium_pixmap_file ("encompass.png"));

  scrwin = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrwin),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);
  gnome_app_set_contents (GNOME_APP (window->window), scrwin);
  gtk_widget_show (scrwin);
  
  encompass_create_menus (window);
  encompass_create_toolbars (window);

  window->html = gtk_html_new ();
  gtk_container_add (GTK_CONTAINER (scrwin), window->html);
  gtk_signal_connect (GTK_OBJECT (window->html), "on_url",
		     GTK_SIGNAL_FUNC (encompass_url_hover), window);
  gtk_signal_connect (GTK_OBJECT (window->html), "title_changed",
		      GTK_SIGNAL_FUNC (encompass_title_changed), window);
  gtk_signal_connect (GTK_OBJECT (window->html), "url_requested",
		      GTK_SIGNAL_FUNC (encompass_url_requested), window);
  gtk_signal_connect (GTK_OBJECT (window->html), "button_press_event",
		      GTK_SIGNAL_FUNC (encompass_button_pressed), window);
  gtk_signal_connect (GTK_OBJECT (window->html), "set_base",
		      GTK_SIGNAL_FUNC (encompass_set_base), window);
  gtk_signal_connect (GTK_OBJECT (window->html), "link_clicked",
		      GTK_SIGNAL_FUNC (encompass_link_clicked), window);
  gtk_signal_connect (GTK_OBJECT (window->html), "size_changed",
		      GTK_SIGNAL_FUNC (encompass_refresh), window);
  gtk_signal_connect (GTK_OBJECT (window->html), "load_done",
		      GTK_SIGNAL_FUNC (encompass_load_done), window);
  gtk_signal_connect (GTK_OBJECT (window->html), "submit",
		      GTK_SIGNAL_FUNC (encompass_submit_form), window);
  gtk_signal_connect (GTK_OBJECT (window->html), "redirect",
		      GTK_SIGNAL_FUNC (encompass_url_redirect), window);

  gtk_widget_show (window->html);
  gtk_html_load_empty (GTK_HTML (window->html));
  gtk_widget_show (window->window);

  gtk_signal_connect (GTK_OBJECT(window->window), "selection_get",
		      GTK_SIGNAL_FUNC (encompass_selection_get), window);

  encompass_parse_bookmarks (window);

  if (url && *url) {
    encompass_goto_url (window, url, 0);
  }
  num_wins++;
}
