/*
 * Decompiled with CFR 0.152.
 */
public class HistoryList {
    int size;
    int maxSize;
    HistoryNode latest;
    HistoryNode earliest;
    HistoryNode current;
    Object defaultElement;

    HistoryList(Object object, int n) {
        this.defaultElement = object;
        this.maxSize = n;
        this.earliest = new HistoryNode();
        this.earliest.setPrev(this.earliest);
        this.earliest.setNext(this.earliest);
        this.earliest.setElement(this.defaultElement);
        this.latest = this.earliest;
        this.current = this.earliest;
        this.size = 0;
    }

    public Object getCurrentItem() {
        return this.current.getElem();
    }

    public Object getNextItem() {
        if (this.current.getNext() != null) {
            this.current = this.current.getNext();
        } else if (!this.current.getElem().equals(this.defaultElement)) {
            this.current = this.appendEmptyItem();
        }
        return this.getCurrentItem();
    }

    public void replaceCurrentItem(Object object) {
        this.current.setElement(object);
    }

    public Object getPreviousItem() {
        if (this.current != this.earliest) {
            this.current = this.current.getPrev();
        }
        return this.getCurrentItem();
    }

    public void insertItem(Object object) {
        this.latest.setElement(object);
        ++this.size;
        this.appendEmptyItem();
    }

    public HistoryNode appendEmptyItem() {
        HistoryNode historyNode = new HistoryNode(this.defaultElement, this.latest, null);
        this.latest.setNext(historyNode);
        this.current = this.latest = historyNode;
        if (this.size > this.maxSize) {
            this.removeEarliestItem();
        }
        return this.current;
    }

    void removeEarliestItem() {
        this.earliest = this.earliest.getNext();
    }
}

