#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "../include/string.h"
#include "../include/disk.h"

#include "guiutils.h"
#include "toolbar.h"

#include "edvtypes.h"
#include "edvcfg.h"
#include "edvobj.h"
#include "edvdevices.h"
#include "edvstatusbar.h"
#include "fopdialog.h"
#include "browser.h"
#include "browsercb.h"
#include "browseropcb.h"
#include "browserdirtree.h"
#include "browsercontents.h"
#include "browserdnd.h"
#include "endeavour.h"
#include "edvcb.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "edvcfglist.h"
#include "config.h"

#include "images/icon_terminal_20x20.xpm"
#include "images/icon_copy_20x20.xpm"
#include "images/icon_save_20x20.xpm"
#include "images/icon_close_20x20.xpm"
#include "images/icon_exit_20x20.xpm"
#include "images/icon_eject_20x20.xpm"
#include "images/icon_move_file_20x20.xpm"
#include "images/icon_copy_file_20x20.xpm"
#include "images/icon_rename_20x20.xpm"
#include "images/icon_cancel_20x20.xpm"
#include "images/icon_chmod_20x20.xpm"
#include "images/icon_owned_20x20.xpm"
#include "images/icon_properties2_20x20.xpm"
#include "images/icon_select_20x20.xpm"
#include "images/icon_executable_20x20.xpm"
#include "images/icon_reload_20x20.xpm"
#include "images/icon_planet_20x20.xpm"
#include "images/icon_search_20x20.xpm"
#include "images/icon_processes_20x20.xpm"
#include "images/icon_mimetypes_20x20.xpm"
#include "images/icon_device_misc_20x20.xpm"
#include "images/icon_tool_bar_20x20.xpm"
#include "images/icon_status_bar_20x20.xpm"
#include "images/icon_options2_20x20.xpm"
#include "images/icon_customize_20x20.xpm"
#include "images/icon_insecure_20x20.xpm"
#include "images/icon_secure_20x20.xpm"
#include "images/icon_fsck_20x20.xpm"
#include "images/icon_tools_20x20.xpm"
#include "images/icon_floppy_20x20.xpm"

#include "images/icon_open_20x20.xpm"
#include "images/icon_file_20x20.xpm"
#include "images/icon_folder_closed_20x20.xpm"
#include "images/icon_folder_parent_20x20.xpm"
#include "images/icon_link2_20x20.xpm"
#include "images/icon_pipe_20x20.xpm"
#include "images/icon_device_block_20x20.xpm"
#include "images/icon_device_character_20x20.xpm"
#include "images/icon_socket_20x20.xpm"

#include "images/icon_trash_empty_20x20.xpm"
#include "images/icon_trash_20x20.xpm"
#include "images/icon_help_20x20.xpm"
#include "images/icon_about_20x20.xpm"

#include "images/endeavour_20x20.xpm"
#include "images/endeavour_48x48.xpm"
#include "images/image_browser_20x20.xpm"
#include "images/archiver_20x20.xpm"


static edv_browser_opid_struct *EDVBrowserMatchOPID(
	edv_browser_struct *browser, gint op
);

void EDVBrowserSetTitle(
        edv_browser_struct *browser, const gchar *path
);

gchar *EDVBrowserCurrentLocation(edv_browser_struct *browser);
void EDVBrowserSetLocation(
	edv_browser_struct *browser,
	const gchar *path, gbool record_history
);
void EDVBrowserUpdateLocationIcon(
        edv_browser_struct *browser, const gchar *path
);

void EDVBrowserToolbarRegenerate(edv_browser_struct *browser);
void EDVBrowserDirectoryMenuRegenerate(edv_browser_struct *browser);
void EDVBrowserContentsMenuRegenerate(edv_browser_struct *browser);

void EDVBrowserSyncConfiguration(edv_browser_struct *browser);

edv_browser_opid_struct **EDVBrowserOPIDListNew(
	edv_browser_struct *browser,	/* Can be NULL. */
	gint *total
);
void EDVBrowserOPIDListDelete(
	edv_browser_opid_struct **list, gint total
);

static void EDVBrowserCreateMenuBar(
	edv_browser_struct *browser, GtkWidget *parent
);
edv_browser_struct *EDVBrowserNew(gpointer core_ptr);
void EDVBrowserReset(edv_browser_struct *browser, gbool need_unmap);
void EDVBrowserSyncData(edv_browser_struct *browser);
void EDVBrowserUpdateMenus(edv_browser_struct *browser);
void EDVBrowserSetBusy(edv_browser_struct *browser, gbool is_busy);
void EDVBrowserMap(edv_browser_struct *browser);
void EDVBrowserUnmap(edv_browser_struct *browser);
void EDVBrowserDelete(edv_browser_struct *browser);



/*
 *	Returns the operation id structure on the given browser that
 *	matches the given id.
 */
static edv_browser_opid_struct *EDVBrowserMatchOPID(
        edv_browser_struct *browser, gint op
)
{
	gint i;
	edv_browser_opid_struct *opid;


	if(browser == NULL)
	    return(NULL);

	for(i = 0; i < browser->total_opids; i++)
	{
	    opid = browser->opid[i];
	    if((opid != NULL) ? (opid->op == op) : FALSE)
		return(opid);
	}

	return(NULL);
}


/*
 *	Updates the WM title on the given browser's toplevel window.
 *
 *	The given path is optional, it can be either the current
 *	selected location or the last selected object.
 */
void EDVBrowserSetTitle(
        edv_browser_struct *browser, const gchar *path
)
{
	gbool include_user_name, include_location;
        const gchar *prog_name = PROG_NAME;
	gchar *title;
	GtkWidget *w;
	edv_core_struct *core_ptr;


	if(browser == NULL)
	    return;

	core_ptr = (edv_core_struct *)browser->core_ptr;
	if(core_ptr == NULL)
	    return;

        if(core_ptr->title != NULL)
            prog_name = core_ptr->title;

        w = browser->toplevel;
        if(w == NULL)
            return;

	include_user_name = EDVCFGItemListGetValueI(
	    core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_TITLE_WITH_USER
	);
	include_location = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_TITLE_WITH_LOCATION
        );

	/* Generate new title string. */
	if(include_user_name && include_location &&
	   (path != NULL)
	)
	    title = g_strdup_printf(
		"%s: %s %s",
		prog_name,
		core_ptr->effective_user_id_location_str,
		path
	    );
	else if(include_location && (path != NULL))
	    title = g_strdup_printf(
                "%s: %s",
		prog_name, path
            );
	else if(include_user_name)
	    title = g_strdup_printf(
                "%s: %s",
		prog_name,
                core_ptr->effective_user_id_location_str
            );
	else
	    title = g_strdup(prog_name);

	/* Set new title. */
	gtk_window_set_title(GTK_WINDOW(w), title);

	/* Deallocate title string, it is no longer needed. */
	g_free(title);
}

/*
 *	Returns the path to the current location of the browser.
 *
 *	Can return NULL on error.
 */
gchar *EDVBrowserCurrentLocation(edv_browser_struct *browser)
{
	GtkCombo *combo;


	if(browser == NULL)
	    return(NULL);

	combo = (GtkCombo *)browser->location_combo;
	if(combo == NULL)
	    return(NULL);

	return(gtk_entry_get_text(GTK_ENTRY(combo->entry)));
}

/*
 *	Sets the location combo of the given browser to the value of
 *	path.
 *
 *	If record_history is TRUE then the current value will be recorded
 *	on the combo's list before setting of the new value.
 *	Duplicate values will not be recorded.
 */
void EDVBrowserSetLocation(
        edv_browser_struct *browser,
        const gchar *path, gbool record_history
)
{
        GtkCombo *combo;
	gchar *new_path;


        if((browser == NULL) || (path == NULL))
            return;

        combo = (GtkCombo *)browser->location_combo;
        if(combo == NULL)
            return;

        /* Copy given path as the new path. */
        new_path = g_strdup(path);

	/* Simplify new path, reducing occurances of /.. */
	SimplifyPath(new_path);


	/* Check for no change in value. */
	if(new_path != NULL)
	{
	    const gchar *cstrptr = gtk_entry_get_text(GTK_ENTRY(combo->entry));
	    if(cstrptr != NULL)
	    {
		/* No change in value? */
		if(!strcmp(cstrptr, new_path))
		{
		    g_free(new_path);
		    new_path = NULL;
		    return;
		}
	    }
	}

	/* Get old value from combo's entry and record it on the list. */
	if(record_history)
	{
	    gchar *old_path;
	    const gchar *cstrptr = gtk_entry_get_text(GTK_ENTRY(combo->entry));
	    old_path = (cstrptr != NULL) ? g_strdup(cstrptr) : NULL;
	    if(old_path != NULL)
	    {
		GUIComboAddItem(combo, old_path);
		g_free(old_path);
		old_path = NULL;
	    }
	}

	/* Set new value on entry and deallocate coppied new_path. */
	if(new_path != NULL)
	{
	    gtk_entry_set_text(GTK_ENTRY(combo->entry), new_path);
	    g_free(new_path);
	    new_path = NULL;
	}
}

/*
 *	Updates the location bar's icon pixmap with respect to the path
 *	specified by path.
 *
 *	If the given path is NULL then the icon will be set as unknown.
 */
void EDVBrowserUpdateLocationIcon(
        edv_browser_struct *browser, const gchar *path
)
{
	gint type, width, height;
	guint permissions;
	GdkPixmap *pixmap_closed, *pixmap_opened;
	GdkBitmap *mask_closed, *mask_opened;
        GtkWidget *parent, *w;
	edv_core_struct *core_ptr;


	if(browser == NULL)
	    return;

	core_ptr = (edv_core_struct *)browser->core_ptr;
	if(core_ptr == NULL)
	    return;

	/* Get icon fixed widget as the parent. */
	parent = browser->location_icon_fixed;
	if(parent == NULL)
	    return;


	/* Get type and permissions of object that the given path reffers
	 * to.
	 */
	type = EDV_OBJECT_TYPE_DIRECTORY;
	permissions = 0x00000000;
	if(path != NULL)
	{
	    struct stat lstat_buf;

	    /* Try to get local stats of the given path. */
	    if(!lstat(path, &lstat_buf))
	    {
		type = EDVObjectGetTypeFromStatMode(lstat_buf.st_mode);
		permissions = EDVObjectGetPermissionsFromStatMode(lstat_buf.st_mode);
	    }
	}

	/* Get pixmap and mask for icon. */
	EDVMatchObjectIcon(
	    core_ptr->device, core_ptr->total_devices,
	    core_ptr->mimetype, core_ptr->total_mimetypes,
	    type,
	    path,
	    TRUE, permissions,
	    0,			/* Small icons. */
	    &pixmap_closed, &mask_closed,
	    &pixmap_opened, &mask_opened,
	    NULL, NULL
	);
	/* If `opened' pixmap is not available then revert to `closed'. */
	if(pixmap_opened == NULL)
	{
	    pixmap_opened = pixmap_closed;
	    mask_opened = mask_closed;
	}

	/* If no `opened' version of pixmap available then give up. */
	if(pixmap_opened == NULL)
	    return;


	/* Create new icon pixmap widget as needed. */
	w = browser->location_icon_pm;
	if(w == NULL)
	{
	    browser->location_icon_pm = w = gtk_pixmap_new(
		pixmap_opened, mask_opened
	    );
	    gtk_fixed_put(GTK_FIXED(parent), w, 0, 0);
	    gtk_widget_show(w);
	}
	else
	{
	    gtk_pixmap_set(GTK_PIXMAP(w), pixmap_opened, mask_opened);
	}

        gdk_window_get_size(
	    (GdkWindow *)pixmap_opened, &width, &height
	);

        /* Adjust size of fixed widget to fit pixmap. */
/*
        gtk_widget_set_usize(parent, width, height);
	gtk_widget_queue_resize(parent);
 */

        /* Set new shape of fixed widget parent. */
/*
        gtk_widget_shape_combine_mask(parent, mask_opened, 0, 0);
 */
}


/*
 *	Recreates the tool bar on the given browser.
 */
void EDVBrowserToolbarRegenerate(edv_browser_struct *browser)
{
	gint i;
        GtkWidget *w, *parent;
        edv_core_struct *core_ptr;
	edv_intlist_struct *intlist;
	edv_browser_opid_struct *opid;
	gint tb_display, tb_relief;
	toolbar_item_struct **item, *item_ptr;
	gint total_items;


        if(browser == NULL)
            return;

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

	/* Get browser tool bar display and relief settings. */
	tb_display = EDVCFGItemListGetValueI(
	    core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY
	);
	tb_relief = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF
        );


	/* Get parent for tool bar. */
	parent = browser->tool_bar_handle;
	if(parent == NULL)
	    return;


        /* Delete old tool bar (if any). */
        ToolBarDelete(browser->toolbar);
	browser->toolbar = NULL;


	/* Get tool bar arrangement from configuration list. */
	intlist = EDVCFGItemListGetValueIntList(
	    core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_TOOL_BAR
	);
	if(intlist == NULL)
	    return;

	/* Create tool bar items list. */
	total_items = intlist->total;
	if(total_items > 0)
	{
	    item = (toolbar_item_struct **)g_malloc0(
		total_items * sizeof(toolbar_item_struct *)
	    );
	    if(item == NULL)
		total_items = 0;
	}
	else
	{
	    item = NULL;
	}
	for(i = 0; i < total_items; i++)
	{
	    /* Get opid structure that matches the operation id specified
	     * on the intlist.
	     */
	    opid = EDVBrowserMatchOPID(browser, intlist->i[i]);
	    if(opid == NULL)
		continue;

	    switch(opid->op)
	    {
	      case EDV_BROWSER_OP_NONE:
		item[i] = item_ptr = NULL;
		break;

	      default:
                item[i] = item_ptr = ToolBarItemNew(
                    opid->toolbar_item_type,
                    opid->button_name,
		    opid->button_icon_data,
		    opid->tooltip,
                    opid->op,
                    EDVBrowserOPCB, opid,
		    EDVBrowserOPEnterCB, opid,                    
		    EDVBrowserOPLeaveCB, opid
                );
                break;
	    }

	}

	/* Create new tool bar. */
	browser->toolbar = ToolBarNew(
	    item, total_items, parent,
	    tb_display, tb_relief, FALSE
	);
	ToolBarMap(browser->toolbar);


	/* Deallocate tool bar items list, it is no longer needed. */
        for(i = 0; i < total_items; i++)
	    ToolBarItemDelete(item[i]);
	g_free(item);
	item = NULL;
	total_items = 0;


	/* Need to tell toplevel to resize since tool bar may change size. */
	w = browser->toplevel;
	if(w != NULL)
	    gtk_widget_queue_resize(w);
}

/*
 *	Recreates the directory ctree right click menu on the given
 *	browser.
 */
void EDVBrowserDirectoryMenuRegenerate(edv_browser_struct *browser)
{
	if(browser == NULL)
	    return;


	/* Destroy existing menu if it already exists. */
	if(1)
	{
	    GtkWidget **w;

#define DO_DESTROY_WIDGET       \
{ \
 if((*w) != NULL) \
 { \
  GtkWidget *tmp_w = *w; \
  (*w) = NULL; \
  gtk_widget_destroy(tmp_w); \
 } \
}

	    w = &browser->directory_ctree_menu;
	    DO_DESTROY_WIDGET

#undef DO_DESTROY_WIDGET
	}


	/* Create new menu. */
	if(1)
	{
	    gint op;
	    guint8 **icon_data = NULL;
	    GtkAccelGroup *accelgrp = NULL;	/* No acceleraters wanted. */
	    GtkWidget *menu, *w, **w_record, **fw_record;

#define DO_ADD_MENU_ITEM_LABEL  \
{ \
 edv_browser_opid_struct *opid = EDVBrowserMatchOPID(browser, op); \
 if(opid != NULL) \
 { \
  w = GUIMenuItemCreate( \
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp, \
   (u_int8_t **)((icon_data != NULL) ? icon_data : opid->menu_icon_data), \
   opid->menu_name, \
   opid->accel_key, opid->accel_mods, \
   (void **)fw_record, \
   (gpointer)opid, EDVBrowserMenuItemCB \
  ); \
  GUISetMenuItemCrossingCB( \
   w, \
   (gpointer)EDVBrowserMenuItemEnterCB, (gpointer)opid, \
   (gpointer)EDVBrowserMenuItemLeaveCB, (gpointer)opid \
  ); \
  if(w_record != NULL) *w_record = w; \
 } \
}

#define DO_ADD_MENU_SEP \
{ \
 w = GUIMenuItemCreate( \
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL, \
  NULL, NULL, 0, 0, NULL, \
  NULL, NULL \
 ); \
}

	    /* Create menu. */
	    browser->directory_ctree_menu = menu = GUIMenuCreate();

            op = EDV_BROWSER_OP_EXPAND;
            w_record = &browser->directory_ctree_expand_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_MOUNT;
            w_record = &browser->directory_ctree_mount_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_EJECT;
            w_record = &browser->directory_ctree_eject_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP
	    browser->directory_ctree_mount_misep = w;

            op = EDV_BROWSER_OP_MOVE;
            w_record = &browser->directory_ctree_move_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_COPY;
            w_record = &browser->directory_ctree_copy_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_LINK;
            w_record = &browser->directory_ctree_link_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_RENAME;
            w_record = &browser->directory_ctree_rename_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_CHMOD;
            w_record = &browser->directory_ctree_chmod_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_CHOWN;
            w_record = &browser->directory_ctree_chown_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_DELETE;
            w_record = &browser->directory_ctree_delete_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_PROPERTIES;
            w_record = &browser->directory_ctree_properties_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_SEP
	}
}

/*
 *	Recreates the contents clist right click menu on the given
 *	browser.
 */
void EDVBrowserContentsMenuRegenerate(edv_browser_struct *browser)
{
        if(browser == NULL)
            return;


        /* Destroy existing menu if it already exists. */
        if(1)
        {
            GtkWidget **w;

#define DO_DESTROY_WIDGET       \
{ \
 if((*w) != NULL) \
 { \
  GtkWidget *tmp_w = *w; \
  (*w) = NULL; \
  gtk_widget_destroy(tmp_w); \
 } \
}

            w = &browser->contents_clist_menu;
            DO_DESTROY_WIDGET

#undef DO_DESTROY_WIDGET
        }


        /* Create new menu. */
        if(1)
        {
            gint op;
            guint8 **icon_data = NULL;
            GtkAccelGroup *accelgrp = NULL;     /* No acceleraters wanted. */
            GtkWidget *menu, *w, **w_record, **fw_record;

#define DO_ADD_MENU_ITEM_LABEL  \
{ \
 edv_browser_opid_struct *opid = EDVBrowserMatchOPID(browser, op); \
 if(opid != NULL) \
 { \
  w = GUIMenuItemCreate( \
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp, \
   (u_int8_t **)((icon_data != NULL) ? icon_data : opid->menu_icon_data), \
   opid->menu_name, \
   opid->accel_key, opid->accel_mods, \
   (void **)fw_record, \
   (gpointer)opid, EDVBrowserMenuItemCB \
  ); \
  GUISetMenuItemCrossingCB( \
   w, \
   (gpointer)EDVBrowserMenuItemEnterCB, (gpointer)opid, \
   (gpointer)EDVBrowserMenuItemLeaveCB, (gpointer)opid \
  ); \
  if(w_record != NULL) *w_record = w; \
 } \
}

#define DO_ADD_MENU_SEP \
{ \
 w = GUIMenuItemCreate( \
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL, \
  NULL, NULL, 0, 0, NULL, \
  NULL, NULL \
 ); \
}

            /* Create menu. */
            browser->contents_clist_menu = menu = GUIMenuCreate();

            op = EDV_BROWSER_OP_OPEN;
            w_record = &browser->contents_clist_open_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_OPEN_WITH;
            w_record = &browser->contents_clist_openwith_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_MOVE;
            w_record = &browser->contents_clist_move_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_COPY;
            w_record = &browser->contents_clist_copy_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_LINK;
            w_record = &browser->contents_clist_link_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_RENAME;
            w_record = &browser->contents_clist_rename_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_CHMOD;
            w_record = &browser->contents_clist_chmod_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_CHOWN;
            w_record = &browser->contents_clist_chown_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_DELETE;
            w_record = &browser->contents_clist_delete_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_PROPERTIES;
            w_record = &browser->contents_clist_properties_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL


#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_SEP
        }
}



/*
 *	Sets values on the given browser to the configuration list on the
 *	core structure of the given browser.
 */
void EDVBrowserSyncConfiguration(edv_browser_struct *browser)
{
	GtkWidget *w;
	edv_core_struct *core_ptr;


	if(browser == NULL)
	    return;

	core_ptr = (edv_core_struct *)browser->core_ptr;
	if(core_ptr == NULL)
	    return;

	/* Get size of toplevel. */
	w = browser->toplevel;
	if(w != NULL)
	{
	    GdkWindow *window = w->window;
	    gint x = 0, y = 0, width, height;


	    if(window != NULL)
		gdk_window_get_root_origin(window, &x, &y);
            EDVCFGItemListSetValueI(
                core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_X,
                x, FALSE
            );
            EDVCFGItemListSetValueI(
                core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_Y,
                y, FALSE
            );
	    gtk_widget_set_uposition(w, x, y);

	    width = w->allocation.width;
	    height = w->allocation.height;
	    EDVCFGItemListSetValueI(
		core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_WIDTH,
		width, FALSE
	    );
            EDVCFGItemListSetValueI(
                core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_HEIGHT,
                height, FALSE
            );
	    gtk_widget_set_usize(w, width, height);
	}

	/* Get position of main paned. */
        w = browser->main_paned;
        if(w != NULL)
        {
	    gint width = GTK_PANED(w)->child1_size;
            EDVCFGItemListSetValueI(
                core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_PANED_POSITION,
                width, FALSE
            );
        }

	/* EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN_WIDTH parameter is updated
	 * as they change in EDVBrowserResizeColumnCB() or when the
	 * configuration list is changed directly.
	 */

	/* EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN parameter is updated
	 * when the configuration list is changed directly.
	 */


	/* Set new startup directory as the last directory of this
	 * window's location.
	 */
	if(EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECORD_START_UP_DIR
	))
	    EDVCFGItemListSetValueS(
		core_ptr->cfg_list, EDV_CFG_PARM_DIR_START_UP,
		EDVBrowserCurrentLocation(browser), FALSE
	    );

}



/*
 *	Creates a new standard list of browser op ids.
 */
edv_browser_opid_struct **EDVBrowserOPIDListNew(
        edv_browser_struct *browser,    /* Can be NULL. */
        gint *total
)
{
	gint i;
	edv_browser_opid_struct **list, *opid;
        gint op, toolbar_item_type;
	gbool allow_multiple;
        void (*func_cb)(gpointer);
        void (*enter_func_cb)(gpointer);
        const gchar *button_name, *menu_name, *tooltip;
        gint accel_key;
        guint accel_mods;
	guint8 **button_icon_data, **menu_icon_data;


	if(total == NULL)
	    return(NULL);

	*total = 0;
	list = NULL;

#define DO_APPEND_OPID	\
{ \
 i = *total; \
 *total = i + 1; \
 list = (edv_browser_opid_struct **)g_realloc( \
  list, \
  (*total) * sizeof(edv_browser_opid_struct *) \
 ); \
 if(list == NULL) \
 { \
  *total = 0; \
  return(list); \
 } \
 else \
 { \
  list[i] = opid = (edv_browser_opid_struct *)g_malloc0( \
   sizeof(edv_browser_opid_struct) \
  ); \
  if(opid != NULL) \
  { \
   opid->browser = browser; \
   opid->op = op; \
   opid->allow_multiple = allow_multiple; \
   opid->toolbar_item_type = toolbar_item_type; \
   opid->func_cb = func_cb; \
   opid->enter_func_cb = enter_func_cb; \
   opid->button_name = (button_name != NULL) ? g_strdup(button_name) : NULL; \
   opid->menu_name = (menu_name != NULL) ? g_strdup(menu_name) : NULL; \
   opid->tooltip = (tooltip != NULL) ? g_strdup(tooltip) : NULL; \
   opid->accel_key = accel_key; \
   opid->accel_mods = accel_mods; \
   opid->button_icon_data = button_icon_data; \
   opid->menu_icon_data = menu_icon_data; \
  } \
 } \
}

	func_cb = EDVBrowserOPCB;
	enter_func_cb = EDVBrowserOPEnterCB;


        op = EDV_BROWSER_OP_SEPARATOR;
	toolbar_item_type = TOOLBAR_ITEM_SEPARATOR;
	allow_multiple = TRUE;
	button_icon_data = NULL;
        menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Separator";
        menu_name = "Separator";
        tooltip = "Separator";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Separador";
        menu_name = "Separador";
        tooltip = "Separador";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Sparateur";
        menu_name = "Sparateur";
        tooltip = "Sparateur";
#endif
	accel_key = 0;
	accel_mods = 0;
        DO_APPEND_OPID


        op = EDV_BROWSER_OP_CLOSE;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_close_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Close";
        menu_name = "Close";
        tooltip = "Close this window";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Cierre";
        menu_name = "Cierre";
        tooltip = "Cierre esta ventana";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Proche";
        menu_name = "Proche";
        tooltip = "Fermer cette fentre";
#endif
        accel_key = 'w';
        accel_mods = GDK_CONTROL_MASK;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_EXIT;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_exit_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Exit";
        menu_name = "Exit";
        tooltip = "Close all windows in the application and exit";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "La Salida";
        menu_name = "La Salida";
        tooltip = "Cierra todas ventanas en la aplicacin y la";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Sortie";
        menu_name = "Sortie";
        tooltip = "Ferme toutes fentres dans l'application et sortie";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID


        op = EDV_BROWSER_OP_WRITE_PROTECT;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_secure_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Protect";
        menu_name = "Write Protect";
        tooltip = "Enable/disable write protect";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Proteja";
        menu_name = "Escriba Proteja";
        tooltip = "Habilite/incapacita escribe protege";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Protge";
        menu_name = "Protge En criture";
        tooltip = "Rend capable/rend infirme protge en criture";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_SYNC_DISKS;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_save_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Sync Disks";
        menu_name = "Sync Disks";
        tooltip = "Flush any pending data transfers to disk";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Discos Sincro";
        menu_name = "Discos Sincro";
        tooltip = "Limpan cualquiera transferencias pendientes de datos al disco";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Disq Syn";
        menu_name = "Les Disques De Syn";
        tooltip = "Rincer des transferts de donnes en attente au disque";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_RUN;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_executable_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Run";
        menu_name = "Run...";
        tooltip = "Run a program";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Corra";
        menu_name = "Corra...";
        tooltip = "Corra un programa";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Courir";
        menu_name = "Courir...";
        tooltip = "Excute un programme";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_RUN_TERMINAL;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_terminal_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Terminal";
        menu_name = "Terminal";
        tooltip = "Run a terminal";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "La Terminal";
        menu_name = "La Terminal";
        tooltip = "Corre una terminal";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Le Terminal";
        menu_name = "Le Terminal";
        tooltip = "Courir un terminal";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID


        op = EDV_BROWSER_OP_NEW;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_file_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "New";
        menu_name = "New";
        tooltip = "Create a new object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Nuevo";
        menu_name = "Nuevo";
        tooltip = "Crea un objeto nuevo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Nouveau";
        menu_name = "Nouveau";
        tooltip = "Crer un nouvel objet";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

	op = EDV_BROWSER_OP_NEW_FILE;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_file_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "New File";
	menu_name = "File";
	tooltip = "Create a new file object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Archivo";
        menu_name = "El Archivo";
        tooltip = "Crea un objeto nuevo del archivo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Fichier";
        menu_name = "Fichier";
        tooltip = "Crer un nouvel objet de fichier";
#endif
        accel_key = 0;
        accel_mods = 0;
	DO_APPEND_OPID

        op = EDV_BROWSER_OP_NEW_DIRECTORY;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_folder_closed_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "New Dir";
        menu_name = "Directory";
        tooltip = "Create a new directory object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "La Gua";
        menu_name = "La Gua";
        tooltip = "Crea un objeto nuevo de gua";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Annuaire";
        menu_name = "Annuaire";
        tooltip = "Crer un nouvel objet d'annuaire";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_NEW_LINK;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_link2_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "New Lnk";
        menu_name = "Link";
        tooltip = "Create a new symbolic link object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Eslabn";
        menu_name = "El Eslabn";
        tooltip = "Crea un objeto simblico nuevo del eslabn";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Lien";
        menu_name = "Lien";
        tooltip = "Cre un nouveau symbolique lien";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_NEW_FIFO;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_pipe_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "New FIFO";
        menu_name = "FIFO Pipe";
        tooltip = "Create a new FIFO pipe object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "FIFO";
        menu_name = "FIFO Tubo";
        tooltip = "Crea un objeto nuevo de tubo de FIFO";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "FIFO";
        menu_name = "FIFO Tuyau";
        tooltip = "Crer un nouvel objet de tuyau de FIFO";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_NEW_DEVICE_BLOCK;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_device_block_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "New BDev";
        menu_name = "Block Device";
        tooltip = "Create a new block (buffered) device node object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "BArtefacto";
        menu_name = "El Artefacto Del Bloque";
        tooltip = "Crea un objeto nuevo de nodo de artefacto de bloque (buffered)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "BL'Appareil";
        menu_name = "Le Priphrique  Blocs";
        tooltip = "Crer un nouveau bloc (buffered) l'objet de noeu";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_NEW_DEVICE_CHARACTER;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_device_character_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "New CDev";
        menu_name = "Character Device";
        tooltip = "Create a new character (unbuffered) device node object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "CArtefacto";
        menu_name = "El Artefacto Del Carcter";
        tooltip = "Crea un objeto nuevo de nodo de artefacto de carcter (unbuffered)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "CL'Appareil";
        menu_name = "Le Priphrique  Caractres";
        tooltip = "Crer un nouveau caractre (unbuffered) l'objet de noeud d'appareil";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_NEW_SOCKET;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_socket_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "New Sock";
        menu_name = "Socket";
        tooltip = "Create a new socket object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Enchufe";
        menu_name = "El Enchufe";
        tooltip = "Crea un objeto nuevo del enchufe";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Douille";
        menu_name = "La Douille";
        tooltip = "Crer un nouvel objet de douille";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID


	op = EDV_BROWSER_OP_OPEN;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_open_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Open";
        menu_name = "Open";
        tooltip = "Open selected object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Abierto";
        menu_name = "Abierto";
        tooltip = "Abre escogido se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Ouvert";
        menu_name = "Ouvert";
        tooltip = "Ouvrir l'objet choisi";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_OPEN_WITH;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_open_20x20_xpm;
        menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Open With";
        menu_name = "Open With...";
        tooltip = "Open selected object using a specific method";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Abra Con";
        menu_name = "Abra Con...";
        tooltip = "Abre escogido se opone usar un mtodo especfico";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Ouvrir Avec";
        menu_name = "Ouvrir Avec...";
        tooltip = "Ouvrir l'objet choisi pour utiliser une mthode spcifique";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID


	op = EDV_BROWSER_OP_GOTO_PARENT;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_folder_parent_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Parent";
        menu_name = "Go To Parent";
        tooltip = "Go to the parent directory";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "El Padre";
        menu_name = "Va A Actuar Como Padre";
        tooltip = "Para Ir a la gua del padre";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Parent";
        menu_name = "Aller Au Parent";
        tooltip = "Aller  l'annuaire de parent";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

	op = EDV_BROWSER_OP_EXPAND;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = NULL;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Expand";
        menu_name = "Expand";
        tooltip = "Expand/collapse selected tree branch";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Ensanchar";
        menu_name = "Ensanchar";
        tooltip = "Ensanchar/el desplome escogi rama de rbol";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Augmenter";
        menu_name = "Augmenter";
        tooltip = "L'Augmente/Effondrement branche d'arbre choisie";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_MOUNT;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = NULL;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Mount";
        menu_name = "Mount";
        tooltip = "Mount/unmount selected mount point directory";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Monte";
        menu_name = "El Monte";
        tooltip = "El Monte/unmount escogi gua de punto de monte";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Le Mont";
        menu_name = "Le Mont";
        tooltip = "Le Mont/unmount a choisi l'annuaire de point de mont";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_EJECT;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_eject_20x20_xpm;
        menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Eject";
        menu_name = "Eject";
        tooltip = "Eject media from device";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Expulse";
        menu_name = "Expulse";
        tooltip = "Expulse medios del artefacto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Ejecter";
        menu_name = "Ejecter";
        tooltip = "Ejecter le presse de l'appareil";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID


        op = EDV_BROWSER_OP_MOVE;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_move_file_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Move";
        menu_name = "Move...";
        tooltip = "Move selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Mueva";
        menu_name = "Mueva...";
        tooltip = "Mueva escogido se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Mouvement";
        menu_name = "Le mouvement...";
        tooltip = "Le Mouvement a choisi l'objet(s)";
#endif
        accel_key = GDK_F7;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_COPY;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_copy_file_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Copy";
        menu_name = "Copy...";
        tooltip = "Copy selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Copia";
        menu_name = "La Copia...";
        tooltip = "La Copia escogi se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Copia";
        menu_name = "La Copie...";
        tooltip = "La Copie a choisi l'objet(s)";
#endif
        accel_key = GDK_F8;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_LINK;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_link2_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Link";
        menu_name = "Link...";
        tooltip = "Link selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Eslabn";
        menu_name = "El Eslabn...";
        tooltip = "El Eslabn escogi se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Le Lien";
        menu_name = "Le Lien...";
        tooltip = "Le Lien a choisi l'objet(s)";
#endif
        accel_key = GDK_F6;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_RENAME;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_rename_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Rename";
        menu_name = "Rename";
        tooltip = "Rename selected object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Reagrupe";
        menu_name = "Reagrupe";
        tooltip = "Reagrupe escogido se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Renommer";
        menu_name = "Renommer";
        tooltip = "Renomme l'objet choisi";
#endif
        accel_key = GDK_F2;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_CHMOD;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_chmod_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "ChMod";
        menu_name = "Change Mode...";
        tooltip = "Change selected objects' permissions";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "ChMod";
        menu_name = "Cambie El Modo...";
        tooltip = "El Cambio escogi los permisos de objetos";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "ChMod";
        menu_name = "Changer Le Mode...";
        tooltip = "Le Changement a choisi des permissions des objets";
#endif
        accel_key = GDK_F9;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_CHOWN;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_owned_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Chown";
        menu_name = "Chown...";
        tooltip = "Chown selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Chown";
        menu_name = "Chown...";
        tooltip = "Chown escogi se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Chown";
        menu_name = "Chown...";
        tooltip = "Chown a choisi l'objet(s)";
#endif
        accel_key = GDK_F10;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_DELETE;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_cancel_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Delete";
        menu_name = "Delete";
        tooltip = "Delete selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Borre";
        menu_name = "Borre";
        tooltip = "Borre escogido se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Effacer";
        menu_name = "Effacer";
        tooltip = "Efface l'objet choisi(s)";
#endif
        accel_key = GDK_Delete;
        accel_mods = GDK_CONTROL_MASK;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_SELECT_ALL;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_select_20x20_xpm;
        menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "SelAll";
        menu_name = "Select All";
        tooltip = "Select all objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "SelAll";
        menu_name = "Escoja Todo";
        tooltip = "Escoge todo se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "SelAll";
        menu_name = "Choisir Tout";
        tooltip = "Choisir tous objets";
#endif
        accel_key = 'a';
        accel_mods = GDK_CONTROL_MASK;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_UNSELECT_ALL;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_select_20x20_xpm;
        menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "UnSelAll";
        menu_name = "Unselect All";
        tooltip = "Unselect all objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "UnSelAll";
        menu_name = "Unescoja Todo";
        tooltip = "Unescoge todo se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "UnSelAll";
        menu_name = "Unchoisir Tout";
        tooltip = "Unchoisir tous objets";
#endif
        accel_key = 'u';
        accel_mods = GDK_CONTROL_MASK;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_INVERT_SELECTION;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_select_20x20_xpm;
        menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "InvSel";
        menu_name = "Invert Selection";
        tooltip =
 "Select all unselected objects and unselect all selected objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "InvSel";
        menu_name = "Invierta Seleccin";
        tooltip =
 "Selectos todos objetos y unselect no seleccionados todos objetos escogidos";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "InvSel";
        menu_name = "Inverser Slection";
        tooltip =
 "Choisir tous objets dslections et deslectionner tous objets choisis";
#endif
        accel_key = 'i';
        accel_mods = GDK_CONTROL_MASK;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_PROPERTIES;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_properties2_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Properties";
        menu_name = "Properties...";
        tooltip = "Modify selected object's properties";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Props";
        menu_name = "Las Propiedades";
        tooltip = "Modifican escogi las propiedades de objeto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Props";
        menu_name = "Les Proprits";
        tooltip = "Modifier a choisi les proprits de l'objet";
#endif
        accel_key = GDK_Return;
        accel_mods = GDK_CONTROL_MASK;
        DO_APPEND_OPID

	op = EDV_BROWSER_OP_FIND;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_search_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Find";
	menu_name = "Find...";
        tooltip = "Find object(s) by specific attributes";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Hallazgo";
        menu_name = "El Hallazgo";
        tooltip = "El Hallazgo se opone (s) por atributos especificados";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Dcouverte";
        menu_name = "La Dcouverte";
        tooltip = "L'objet de Dcouverte (s) par les attributs spcifis ";
#endif
        accel_key = 'f';
        accel_mods = GDK_CONTROL_MASK;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_HISTORY;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_processes_20x20_xpm;
        menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "History";
        menu_name = "History...";
        tooltip = "History of commands processed by this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Historia";
        menu_name = "La Historia...";
        tooltip = "La Historia de rdenes procesadas por esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "L'Histoire";
        menu_name = "L'Histoire...";
        tooltip = "L'Histoire d'ordres traits par cette application";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_COPY_PATH;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_copy_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "CopyPath";
        menu_name = "Copy Path";
        tooltip = "Copy the location of the selected object(s) as path(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "CopiSende";
        menu_name = "Copie Sendero";
        tooltip = "Copia la ubicacin del objeto(s) escogido como sendero(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "CopiSenti";
        menu_name = "Copier Le Sentier";
        tooltip = "Copier l'emplacement de l'objet choisi(s) comme le sentier(s)";
#endif
        accel_key = 'c';
        accel_mods = GDK_CONTROL_MASK;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_COPY_URL;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_copy_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "CopyURL";
        menu_name = "Copy URL";
        tooltip = "Copy the location of the selected object(s) as url(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "CopiURL";
        menu_name = "Copie URL";
        tooltip = "Copie la ubicacin del objeto(s) escogido como url(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "CopiURL";
        menu_name = "Copier URL";
        tooltip = "Copier l'emplacement de l'objet choisi(s) comme url(s)";
#endif
        accel_key = 'c';
        accel_mods = GDK_CONTROL_MASK | GDK_SHIFT_MASK;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_REFRESH;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_reload_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Refresh";
        menu_name = "Refresh";
        tooltip = "Refresh selected directory's listing";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Refresque";
        menu_name = "Refresque";
        tooltip = "Refresque gua escogida es listar";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Rafrachir";
        menu_name = "Rafrachir";
        tooltip = "Rafrachit a choisi l'numrer de l'annuaire";
#endif
        accel_key = GDK_F5;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_REFRESH_ALL;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_reload_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Refresh All";
        menu_name = "Refresh All";
        tooltip = "Refresh all listings";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Refresque Todo";
        menu_name = "Refresque Todo";
        tooltip = "Refresca todas listas";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Rafrachir Tout";
        menu_name = "Rafrachir Tout";
        tooltip = "Rafrachir toutes listes";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID


        op = EDV_BROWSER_OP_DOWNLOAD;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_planet_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Download";
        menu_name = "Download";
        tooltip = "Download an object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Download";
        menu_name = "Download";
        tooltip = "Download del objeto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Download";
        menu_name = "Download";
        tooltip = "Download de l'objet";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID


        op = EDV_BROWSER_OP_SHOW_TOOL_BAR;
        toolbar_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "ToolBar";
        menu_name = "Tool Bar";
        tooltip = "Show/hide tool bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "ToolBar";
        menu_name = "Tool Bar";
        tooltip = "La Exposicin/la barra de herramienta de cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "ToolBar";
        menu_name = "Tool Bar";
        tooltip = "La barre d'outil de montre/peau";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_SHOW_LOCATION_BAR;
        toolbar_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "LocBar";
        menu_name = "Location Bar";
        tooltip = "Show/hide location bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "LocBar";
        menu_name = "Location Bar";
        tooltip = "La exposicin/la barra de la ubicacin del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "LocBar";
        menu_name = "Location Bar";
        tooltip = "La barre d'emplacement de montre/peau";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_SHOW_MOUNT_BAR;
        toolbar_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "MountBar";
        menu_name = "Mount Bar";
        tooltip = "Show/hide mount bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "MountBar";
        menu_name = "Mount Bar";
        tooltip = "La Exposicin/la barra del monte del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "MountBar";
        menu_name = "Mount Bar";
        tooltip = "La barre de mont de Show/Peau";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_SHOW_FIND_BAR;
        toolbar_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "FindBar";
        menu_name = "Find Bar";
        tooltip = "Show/hide find bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "FindBar";
        menu_name = "Find Bar";
        tooltip = "La exposicin/la barra del hallazgo del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "FindBar";
        menu_name = "Find Bar";
        tooltip = "La barre de dcouverte de montre/peau";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_SHOW_STATUS_BAR;
        toolbar_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_status_bar_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "StatusBar";
        menu_name = "Status Bar";
        tooltip = "Show/hide status bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "StatusBar";
        menu_name = "Status Bar";
        tooltip = "La exposicin/la barra de la posicin del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "StatusBar";
        menu_name = "Status Bar";
        tooltip = "La barre de statut de montre/peau";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_MIME_TYPES;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_mimetypes_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "MIMETypes";
        menu_name = "MIME Types...";
        tooltip = "View/modify MIME Types";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "MIMETypes";
        menu_name = "MIME Types...";
        tooltip = "El panorama/modifica MIME Types";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "MIMETypes";
        menu_name = "MIME Types...";
        tooltip = "Vue/modifie MIME Types";
#endif
        accel_key = 'm';
        accel_mods = GDK_CONTROL_MASK;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_DEVICES;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_device_misc_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Devices";
        menu_name = "Devices...";
        tooltip = "View/modify file system device references";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Artefactos";
        menu_name = "Los Artefactos...";
        tooltip = "El Panorama/modifica las referencias de artefacto de sistema de archivo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Appareils";
        menu_name = "Les Appareils...";
        tooltip = "Les rfrences de priphrique-systme de fichier de Vue/Modifie ";
#endif
        accel_key = 'd';
        accel_mods = GDK_CONTROL_MASK;
        DO_APPEND_OPID


        op = EDV_BROWSER_OP_NEW_BROWSER;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)endeavour_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "FBrowser";
        menu_name = "New File Browser";
        tooltip = "Create a new file browser";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "FBrowser";
        menu_name = "El Examinador Nuevo Del Archivo";
        tooltip = "Crea a un examinador nuevo del archivo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "FBrowser";
        menu_name = "Nouveau Browser de Fichier";
        tooltip = "Crer un nouveau browser de fichier";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_NEW_IMBR;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)image_browser_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "IBrowser";
        menu_name = "New Image Browser";
        tooltip = "Create a new image browser";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "IBrowser";
        menu_name = "El Examinador Nuevo De La Imagen";
        tooltip = "Crea a un examinador nuevo de la imagen";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "IBrowser";
        menu_name = "Nouveau Browser D'Image";
        tooltip = "Crer un nouveau browser d'image";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_NEW_ARCHIVER;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)archiver_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Archiver";
        menu_name = "New Archiver";
        tooltip = "Create a new archiver";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Archiver";
        menu_name = "Archiver Nuevo";
        tooltip = "Crea un archiver nuevo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Archiver";
        menu_name = "Nouveau Archiver";
        tooltip = "Crer un nouveau archiver";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_RECYCLE_BIN;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_trash_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "RecBin";
        menu_name = "Recycle Bin";
        tooltip = "Recycle bin (trash can)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "RecBin";
        menu_name = "El Cajn De La Recirculacin";
        tooltip = "Cajn de Recirculacin (basura puede)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "RecBin";
        menu_name = "Recycler L'Huche";
        tooltip = "Recycler l'huche (la poubelle)";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID


        op = EDV_BROWSER_OP_OPTIONS;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_options2_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Options";
        menu_name = "Options...";
        tooltip = "Modify this application's options";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Las Opciones";
        menu_name = "Las Opciones...";
        tooltip = "Modifican estas opciones de la aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Les Options";
        menu_name = "Les Options";
        tooltip = "Modifier ces options de l'application";
#endif
        accel_key = 'o';
        accel_mods = GDK_CONTROL_MASK;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_CUSTOMIZE;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_customize_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Custom";
        menu_name = "Customize...";
        tooltip = "Customize the look and feel of this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Personal";
        menu_name = "Personaliza...";
        tooltip = "Personaliza la mirada y se siente de esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Personnal";
        menu_name = "Personnalise...";
        tooltip = "Personnalise le regard et sens de cette application";
#endif
        accel_key = 't';
        accel_mods = GDK_CONTROL_MASK;
        DO_APPEND_OPID


        op = EDV_BROWSER_OP_DEVICE_CHECK;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_fsck_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "FSCK";
        menu_name = "File System Check...";
        tooltip = "Check the device's file system";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "FSCK";
        menu_name = "Archive Cheque De Sistema...";
        tooltip = "Verifique el sistema del archivo de artefacto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "FSCK";
        menu_name = "Classer Le Chque De Systme...";
        tooltip = "Vrifier le systme de fichier de l'appareil";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_DEVICE_TOOLS;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_tools_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "DevTool";
        menu_name = "Device Tools...";
        tooltip = "Run the device's tools program";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "DevTool";
        menu_name = "Artefacto Equipar Herramienta...";
        tooltip = "Corra el programa de herramientas de artefacto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "DevTool";
        menu_name = "Outils D'Appareil...";
        tooltip = "Courir le programme d'outils de l'appareil";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_DEVICE_FORMAT;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_floppy_20x20_xpm;
        menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Format";
        menu_name = "Format Media...";
        tooltip = "Format the media in the device";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Format";
        menu_name = "Formatear Medios...";
        tooltip = "Formatear los medios en el artefacto";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "Format";
        menu_name = "Met Format Presse...";
        tooltip = "Met en format le presse dans l'appareil";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID


        op = EDV_BROWSER_OP_HELP_CONTENTS;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_help_20x20_xpm;
        menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "Help";
        menu_name = "Contents";
        tooltip = "Index of all help pages";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "La Ayuda";
        menu_name = "El Contenido";
        tooltip = "El Indice de toda ayuda pagina";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "L'Aide";
        menu_name = "Les Contenus";
        tooltip = "L'Index de toutes pages d'aide";
#endif
        accel_key = GDK_F1;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_HELP_FILE_BROWSER;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_help_20x20_xpm;
        menu_icon_data = NULL;
        button_name = "Help";
        menu_name = "File Browser";
        tooltip = "Help on using the file browser";
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_HELP_IMAGE_BROWSER;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_help_20x20_xpm;
        menu_icon_data = NULL;
        button_name = "Help";
        menu_name = "Image Browser";
        tooltip = "Help on using the image browser";
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_HELP_ARCHIVER;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_help_20x20_xpm;
        menu_icon_data = NULL;
        button_name = "Help";
        menu_name = "Archiver";
        tooltip = "Help on using the archiver";
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_HELP_RECYCLE_BIN;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_help_20x20_xpm;
        menu_icon_data = NULL;
        button_name = "Help";
        menu_name = "Recycle Bin";
        tooltip = "Help on using the recycle bin";
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_HELP_KEYS_LIST;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_help_20x20_xpm;
        menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "HelpKeys";
        menu_name = "Keys List";
        tooltip = "List of all keyboard key operations";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "HelpKeys";
        menu_name = "La Lista De Llaves";
        tooltip = "La Lista de todo teclado las operaciones claves";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "HelpKeys";
        menu_name = "La Liste De Clefs";
        tooltip = "La Liste de tout clavier toutes oprations principales";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_HELP_MIME_TYPES;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_help_20x20_xpm;
        menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "HelpMIME";
        menu_name = "Mime Types";
        tooltip = "Help on setting up MIME Types";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "HelpMIME";
        menu_name = "Mime Types";
        tooltip = "Ayude a establecer MIME Types";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "HelpMIME";
        menu_name = "Mime Types";
        tooltip = "Aider sur montant MIME Types";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_HELP_DEVICES;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_help_20x20_xpm;
        menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "HelpDev";
        menu_name = "Devices";
        tooltip = "Help on setting up devices";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "HelpDev";
        menu_name = "Los Artefactos";
        tooltip = "La Ayuda a establecer artefactos";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "HelpDev";
        menu_name = "Les Appareils";
        tooltip = "L'Aide sur montant des appareils";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_HELP_COMMON_OPERATIONS;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_help_20x20_xpm;
        menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "HelpOp";
        menu_name = "Common Operations";
        tooltip = "Help on the most common operations";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "HelpOp";
        menu_name = "Las Operaciones Comunes";
        tooltip = "La Ayuda en las operaciones ms comunes";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "HelpOp";
        menu_name = "Les Oprations Communes";
        tooltip = "L'Aide sur montant des appareils";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID

        op = EDV_BROWSER_OP_HELP_ABOUT;
        toolbar_item_type = TOOLBAR_ITEM_BUTTON;
        allow_multiple = FALSE;
        button_icon_data = (guint8 **)icon_about_20x20_xpm;
        menu_icon_data = (guint8 **)icon_about_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
        button_name = "About";
        menu_name = "About";
        tooltip = "About this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        button_name = "Acerca";
        menu_name = "Acerca De";
        tooltip = "Acerca de esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        button_name = "De";
        menu_name = "De";
        tooltip = "De cette application";
#endif
        accel_key = 0;
        accel_mods = 0;
        DO_APPEND_OPID


#undef DO_APPEND_OPID

	return(list);
}

/*
 *	Deallocates the given list of browser op ids.
 */
void EDVBrowserOPIDListDelete(
        edv_browser_opid_struct **list, gint total
)
{
	gint i;
	edv_browser_opid_struct *opid;


	if(list == NULL)
	    return;

        for(i = 0; i < total; i++)
        {
            opid = list[i];
            if(opid == NULL)
                continue;

            g_free(opid->button_name);
            g_free(opid->menu_name);
            g_free(opid->tooltip);

            g_free(opid);
        }
        g_free(list);
	list = NULL;
	total = 0;
}


/*
 *	Creates the menu bar for the given browser.
 *
 *	This function should be called by EDVBrowserNew().
 */
static void EDVBrowserCreateMenuBar(
	edv_browser_struct *browser, GtkWidget *parent
)
{
	gint op;
	guint8 **icon_data = NULL;
        GtkAccelGroup *accelgrp;
        GtkWidget *menu_bar, *menu, *submenu, *w, **w_record, **fw_record;


	/* Get keyboard accelerator group. */
	accelgrp = browser->accelgrp;

        /* Create menu bar. */
        menu_bar = (GtkWidget *)GUIMenuBarCreate(NULL);
	browser->menu_bar = menu_bar;
        gtk_container_add(GTK_CONTAINER(parent), menu_bar);
        gtk_widget_show(menu_bar);

#define DO_ADD_MENU_ITEM_LABEL  \
{ \
 edv_browser_opid_struct *opid = EDVBrowserMatchOPID(browser, op); \
 if(opid != NULL) \
 { \
  w = GUIMenuItemCreate( \
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp, \
   (u_int8_t **)((icon_data != NULL) ? icon_data : opid->menu_icon_data), \
   opid->menu_name, \
   opid->accel_key, opid->accel_mods, \
   (void **)fw_record, \
   (gpointer)opid, EDVBrowserMenuItemCB \
  ); \
  GUISetMenuItemCrossingCB( \
   w, \
   (gpointer)EDVBrowserMenuItemEnterCB, (gpointer)opid, \
   (gpointer)EDVBrowserMenuItemLeaveCB, (gpointer)opid \
  ); \
  if(w_record != NULL) *w_record = w; \
 } \
}
#define DO_ADD_MENU_ITEM_SUBMENU        \
{ \
 edv_browser_opid_struct *opid = EDVBrowserMatchOPID(browser, op); \
 if(opid != NULL) \
 { \
  w = GUIMenuItemCreate( \
   menu, GUI_MENU_ITEM_TYPE_SUBMENU, accelgrp, \
   (u_int8_t **)((icon_data != NULL) ? icon_data : opid->menu_icon_data), \
   opid->menu_name, \
   opid->accel_key, opid->accel_mods, \
   (void **)fw_record, \
   (gpointer)opid, NULL \
  ); \
  GUISetMenuItemCrossingCB( \
   w, \
   (gpointer)EDVBrowserMenuItemEnterCB, (gpointer)opid, \
   (gpointer)EDVBrowserMenuItemLeaveCB, (gpointer)opid \
  ); \
  if(w != NULL) \
   GUIMenuItemSetSubMenu(w, submenu); \
  if(w_record != NULL) *w_record = w; \
 } \
}

#define DO_ADD_MENU_ITEM_CHECK  \
{ \
 edv_browser_opid_struct *opid = EDVBrowserMatchOPID(browser, op); \
 if(opid != NULL) \
 { \
  w = GUIMenuItemCreate( \
   menu, GUI_MENU_ITEM_TYPE_CHECK, accelgrp, \
   (u_int8_t **)((icon_data != NULL) ? icon_data : opid->menu_icon_data), \
   opid->menu_name, \
   opid->accel_key, opid->accel_mods, \
   (void **)fw_record, \
   (gpointer)opid, EDVBrowserMenuItemCB \
  ); \
  GUISetMenuItemCrossingCB( \
   w, \
   (gpointer)EDVBrowserMenuItemEnterCB, (gpointer)opid, \
   (gpointer)EDVBrowserMenuItemLeaveCB, (gpointer)opid \
  ); \
  if(w_record != NULL) *w_record = w; \
 } \
}

#define DO_ADD_MENU_SEP \
{ \
 w = GUIMenuItemCreate( \
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL, \
  NULL, NULL, 0, 0, NULL, \
  NULL, NULL \
 ); \
}

	/* Create new object submenu. */
        menu = GUIMenuCreate();
	if(menu != NULL)
	{
            op = EDV_BROWSER_OP_NEW_FILE;
            w_record = &browser->new_file_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

	    op = EDV_BROWSER_OP_NEW_DIRECTORY;
	    w_record = &browser->new_directory_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_NEW_LINK;
            w_record = &browser->new_link_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_NEW_FIFO;
            w_record = &browser->new_fifo_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_NEW_DEVICE_BLOCK;
            w_record = &browser->new_device_block_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_NEW_DEVICE_CHARACTER;
            w_record = &browser->new_device_character_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_NEW_SOCKET;
            w_record = &browser->new_socket_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL
	}
	browser->new_object_submenu = submenu = menu;

        /* Create file menu. */
        menu = GUIMenuCreateTearOff();
        if(menu != NULL)
        {
	    op = EDV_BROWSER_OP_OPEN;
	    w_record = &browser->open_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_OPEN_WITH;
            w_record = &browser->openwith_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_NEW;
            w_record = &browser->new_object_submi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_SUBMENU

	    DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_SYNC_DISKS;
            w_record = &browser->sync_disks_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_HISTORY;
            w_record = &browser->history_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_RUN;
            w_record = &browser->run_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_CLOSE;
            w_record = &browser->close_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL
        }
        GUIMenuAddToMenuBar(
            menu_bar, menu,
#ifdef PROG_LANGUAGE_ENGLISH
            "File",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Archivo",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Fichier",
#endif
            GUI_MENU_BAR_ALIGN_LEFT
        );


        /* Create edit menu. */
        menu = GUIMenuCreateTearOff();
        if(menu != NULL)
        {
            op = EDV_BROWSER_OP_MOVE;
            w_record = &browser->move_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_COPY;
            w_record = &browser->copy_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_LINK;
            w_record = &browser->link_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_RENAME;
            w_record = &browser->rename_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_CHMOD;
            w_record = &browser->chmod_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_CHOWN;
            w_record = &browser->chown_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_DELETE;
            w_record = &browser->delete_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_SELECT_ALL;
            w_record = &browser->select_all_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_UNSELECT_ALL;
            w_record = &browser->unselect_all_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_INVERT_SELECTION;
            w_record = &browser->invert_selection_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_FIND;
            w_record = &browser->find_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_PROPERTIES;
            w_record = &browser->properties_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL
        }
        GUIMenuAddToMenuBar(
            menu_bar, menu,
#ifdef PROG_LANGUAGE_ENGLISH
            "Edit",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Redacta",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "diter",
#endif
            GUI_MENU_BAR_ALIGN_LEFT
        );


        /* Create view menu. */
        menu = GUIMenuCreateTearOff();
        if(menu != NULL)
        {
            op = EDV_BROWSER_OP_REFRESH;
            w_record = &browser->refresh_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_REFRESH_ALL;
            w_record = &browser->refresh_all_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_SHOW_TOOL_BAR;
            w_record = &browser->show_tool_bar_micheck;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_CHECK

            op = EDV_BROWSER_OP_SHOW_LOCATION_BAR;
            w_record = &browser->show_location_bar_micheck;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_CHECK

            op = EDV_BROWSER_OP_SHOW_MOUNT_BAR;
            w_record = &browser->show_mount_bar_micheck;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_CHECK

            op = EDV_BROWSER_OP_SHOW_FIND_BAR;
            w_record = &browser->show_find_bar_micheck;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_CHECK

            op = EDV_BROWSER_OP_SHOW_STATUS_BAR;
            w_record = &browser->show_status_bar_micheck;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_CHECK

            DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_MIME_TYPES;
            w_record = &browser->mime_types_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL
        }
        GUIMenuAddToMenuBar(
            menu_bar, menu,
#ifdef PROG_LANGUAGE_ENGLISH
            "View",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Panorama",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Vue",
#endif
            GUI_MENU_BAR_ALIGN_LEFT
        );


        /* Create device menu. */
        menu = GUIMenuCreateTearOff();
        if(menu != NULL)
        {
            op = EDV_BROWSER_OP_MOUNT;
            w_record = &browser->mount_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_EJECT;
            w_record = &browser->eject_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_DEVICE_CHECK;
            w_record = &browser->device_check_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_DEVICE_TOOLS;
            w_record = &browser->device_tools_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_DEVICE_FORMAT;
            w_record = &browser->device_format_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_DEVICES;
            w_record = &browser->devices_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL
        }
        GUIMenuAddToMenuBar(
            menu_bar, menu,
#ifdef PROG_LANGUAGE_ENGLISH
            "Device",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Artefacto",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Appareil",
#endif
            GUI_MENU_BAR_ALIGN_LEFT
        );


        /* Create settings menu. */
        menu = GUIMenuCreateTearOff();
        if(menu != NULL)
        {
            op = EDV_BROWSER_OP_WRITE_PROTECT;
            w_record = &browser->write_protect_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_OPTIONS;
            w_record = &browser->options_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_CUSTOMIZE;
            w_record = &browser->customize_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL
        }
        GUIMenuAddToMenuBar(
            menu_bar, menu,
#ifdef PROG_LANGUAGE_ENGLISH
            "Settings",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Colocaciones",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Montages",
#endif
            GUI_MENU_BAR_ALIGN_LEFT
        );


        /* Create windows menu. */
        menu = GUIMenuCreateTearOff();
        if(menu != NULL)
        {
            op = EDV_BROWSER_OP_NEW_BROWSER;
            w_record = &browser->window_new_browser_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_NEW_IMBR;
            w_record = &browser->window_new_imbr_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_NEW_ARCHIVER;
            w_record = &browser->window_new_archiver_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_RECYCLE_BIN;
            w_record = &browser->window_recycle_bin_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL
        }
        GUIMenuAddToMenuBar(
            menu_bar, menu,
#ifdef PROG_LANGUAGE_ENGLISH
            "Windows",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Ventanas",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Fentres",
#endif
            GUI_MENU_BAR_ALIGN_LEFT
        );





        /* Create help menu. */
        menu = GUIMenuCreateTearOff();
        if(menu != NULL)
        {
            op = EDV_BROWSER_OP_HELP_CONTENTS;
            w_record = &browser->help_contents_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_HELP_FILE_BROWSER;
            w_record = &browser->help_file_browser_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_HELP_KEYS_LIST;
            w_record = &browser->help_keys_list_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_HELP_MIME_TYPES;
            w_record = &browser->help_mime_types_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_HELP_DEVICES;
            w_record = &browser->help_devices_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            op = EDV_BROWSER_OP_HELP_COMMON_OPERATIONS;
            w_record = &browser->help_common_operations_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL

            DO_ADD_MENU_SEP

            op = EDV_BROWSER_OP_HELP_ABOUT;
            w_record = &browser->help_about_mi;
            fw_record = NULL;
            DO_ADD_MENU_ITEM_LABEL
        }
        GUIMenuAddToMenuBar(
            menu_bar, menu,
#ifdef PROG_LANGUAGE_ENGLISH
            "Help",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Ayuda",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "L'Aide",
#endif
            GUI_MENU_BAR_ALIGN_RIGHT
        );


#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_ITEM_SUBMENU
#undef DO_ADD_MENU_ITEM_CHECK
#undef DO_ADD_MENU_SEP

}

/*
 *	Creates a new file browser.
 */
edv_browser_struct *EDVBrowserNew(gpointer core_ptr)
{
	gint	toplevel_x = 0,
		toplevel_y = 0,
		toplevel_width = EDV_DEF_BROWSER_WIDTH,
		toplevel_height = EDV_DEF_BROWSER_HEIGHT,
		paned_position = EDV_DEF_BROWSER_PANED_POSITION;
	gbool	tool_bar_map_state = TRUE,
		location_bar_map_state = TRUE,
		mount_bar_map_state = TRUE,
                find_bar_map_state = TRUE,
		status_bar_map_state = TRUE;
	gint i, state;
	edv_status_bar_struct *status_bar;
	const gchar	*font_name = NULL,
			*fg_color_name = NULL,
			*bg_color_name = NULL,
			*sfg_color_name = NULL,
			*sbg_color_name = NULL,
			*bg_pixmap_path = NULL,
			*sbg_pixmap_path = NULL,
			*wm_name = NULL,
			*wm_class = NULL;
	GdkColor *c;
	GdkColormap *colormap = NULL;
	GdkCursor *cursor;
	GList *glist;
	GtkStyle *style, *src_style;
	GtkRcStyle *rcstyle;
        GtkWidget *w, *parent, *parent2, *parent3, *parent4;
	gpointer combo_rtn;
	GtkCombo *combo;
	GtkCList *clist;
	GtkCTree *ctree;
        GdkWindow *window;
        GtkAccelGroup *accelgrp;
	const GtkTargetEntry dnd_tar_types[] = {
{"text/plain",				0,	EDV_DND_TYPE_INFO_TEXT_PLAIN},
{"text/uri-list",			0,	EDV_DND_TYPE_INFO_TEXT_URI_LIST},
{"STRING",				0,	EDV_DND_TYPE_INFO_STRING},
{EDV_DND_TYPE_STRING_RECYCLED_OBJECT,	0,	EDV_DND_TYPE_INFO_RECYCLED_OBJECT},
{EDV_DND_TYPE_STRING_ARCHIVE_OBJECT,	0,	EDV_DND_TYPE_INFO_ARCHIVE_OBJECT}
	};
        const GtkTargetEntry dnd_src_types[] = {
{"text/plain",				0,      EDV_DND_TYPE_INFO_TEXT_PLAIN},
{"text/uri-list",			0,      EDV_DND_TYPE_INFO_TEXT_URI_LIST},
{"STRING",				0,      EDV_DND_TYPE_INFO_STRING}
        };
	edv_browser_struct *browser = (edv_browser_struct *)g_malloc0(
	    sizeof(edv_browser_struct)
	);
	if(browser == NULL)
	    return(browser);


	/* Get values from core structure. */
	if(core_ptr != NULL)
	{
	    edv_core_struct *c_ptr = EDV_CORE(core_ptr);

	    font_name = c_ptr->font_name;
	    fg_color_name = c_ptr->fg_color_name;
	    bg_color_name = c_ptr->bg_color_name;
            sfg_color_name = c_ptr->sfg_color_name;
            sbg_color_name = c_ptr->sbg_color_name;
	    bg_pixmap_path = c_ptr->bg_pixmap_path;
	    sbg_pixmap_path = c_ptr->sbg_pixmap_path;
	    wm_name = c_ptr->wm_name;
	    wm_class = c_ptr->wm_class;
	    if(c_ptr->geometry_set)
	    {
		GdkRectangle *rect = &c_ptr->geometry;
		toplevel_x = rect->x;
                toplevel_y = rect->y;
                toplevel_width = rect->width;
                toplevel_height = rect->height;
	    }
	    else
	    {
		toplevel_x = EDVCFGItemListGetValueI(
		    c_ptr->cfg_list, EDV_CFG_PARM_BROWSER_X
		);
		toplevel_y = EDVCFGItemListGetValueI(
		    c_ptr->cfg_list, EDV_CFG_PARM_BROWSER_Y
		);
		toplevel_width = EDVCFGItemListGetValueI(
		    c_ptr->cfg_list, EDV_CFG_PARM_BROWSER_WIDTH
		);
		toplevel_height = EDVCFGItemListGetValueI(
		    c_ptr->cfg_list, EDV_CFG_PARM_BROWSER_HEIGHT
		);
	    }

            paned_position = EDVCFGItemListGetValueI(
                c_ptr->cfg_list, EDV_CFG_PARM_BROWSER_PANED_POSITION
            );

	    tool_bar_map_state = EDVCFGItemListGetValueI(
                c_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR
            );
	    location_bar_map_state = EDVCFGItemListGetValueI(
                c_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR
            );
            mount_bar_map_state = EDVCFGItemListGetValueI(
                c_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR
            );
            find_bar_map_state = EDVCFGItemListGetValueI(
                c_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR
            );
	    status_bar_map_state = EDVCFGItemListGetValueI(
                c_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR
            );
	}

	/* Begin resetting values. */
	browser->initialized = TRUE;
	browser->map_state = FALSE;
        browser->processing = FALSE;
	browser->ignore_input = FALSE;
	browser->busy_count = 0;
        browser->core_ptr = core_ptr;
	browser->opid = NULL;
	browser->total_opids = 0;
	browser->tool_bar_map_state = tool_bar_map_state;
	browser->location_bar_map_state = location_bar_map_state;
        browser->mount_bar_map_state = mount_bar_map_state;
        browser->find_bar_map_state = find_bar_map_state;
	browser->status_bar_map_state = status_bar_map_state;
	browser->directory_ctree_selected_node = NULL;
	browser->contents_clist_selected_row = -1;
	browser->selected_dev_num = -1;
	browser->last_recbin_items = -1;
	browser->last_write_protect_state = -1;
	browser->status_bar = NULL;
	browser->fopdialog = NULL;

	/* Create operation ids. */
	browser->opid = EDVBrowserOPIDListNew(
	    browser, &browser->total_opids
	);

        /* Keyboard accelerator group. */
        browser->accelgrp = accelgrp = gtk_accel_group_new();

	/* Begin creating widgets. */
	/* Toplevel. */
	browser->toplevel = w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_widget_set_uposition(
            w, toplevel_x, toplevel_y
        );
        gtk_widget_set_usize(
            w, toplevel_width, toplevel_height
        );
	gtk_window_set_wmclass(GTK_WINDOW(w), wm_name, wm_class);
        gtk_window_set_policy(
            GTK_WINDOW(w),
            TRUE, TRUE, TRUE
        );
	gtk_widget_realize(w);
	window = w->window;
        if(window != NULL)
        {
            GdkGeometry geometry;

            geometry.min_width = 100;
            geometry.min_height = 70;

            geometry.base_width = 0;
            geometry.base_height = 0;

            geometry.width_inc = 1;
            geometry.height_inc = 1;
/*
            geometry.min_aspect = 1.3;
            geometry.max_aspect = 1.3;
 */
            gdk_window_set_geometry_hints(
                window, &geometry,
                GDK_HINT_MIN_SIZE |
                GDK_HINT_BASE_SIZE |
                /* GDK_HINT_ASPECT | */
                GDK_HINT_RESIZE_INC
            );

	    colormap = gdk_window_get_colormap(window);

	    GUISetWMIcon(window, (u_int8_t **)endeavour_48x48_xpm);
        }
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(EDVBrowserDeleteEventCB), browser
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "destroy",
	    GTK_SIGNAL_FUNC(EDVBrowserDestroyCB), browser
        );
        gtk_accel_group_attach(accelgrp, GTK_OBJECT(w));
        gtk_container_set_border_width(GTK_CONTAINER(w), 0);
        parent = w;


	/* Main vbox. */
	browser->main_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;


	/* Vbox for tool bars. */
	browser->bars_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
        parent2 = w;


	/* Handle for menu bar. */
        browser->menu_bar_handle = w = gtk_handle_box_new();
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_signal_connect_after(
            GTK_OBJECT(w), "child_attached",
            GTK_SIGNAL_FUNC(EDVBrowserHandleChildAttachedCB), browser
        );
        gtk_signal_connect_after(
            GTK_OBJECT(w), "child_detached",
            GTK_SIGNAL_FUNC(EDVBrowserHandleChildDetachedCB), browser
        );
	gtk_widget_show(w);
	/* Create menu bar. */
	EDVBrowserCreateMenuBar(browser, w);


	/* Handle for tool bar. */
	browser->tool_bar_handle = w = gtk_handle_box_new();
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_signal_connect_after(
            GTK_OBJECT(w), "child_attached",
            GTK_SIGNAL_FUNC(EDVBrowserHandleChildAttachedCB), browser
        );
        gtk_signal_connect_after(
            GTK_OBJECT(w), "child_detached",
            GTK_SIGNAL_FUNC(EDVBrowserHandleChildDetachedCB), browser
        );
	if(browser->tool_bar_map_state)
	    gtk_widget_show(w);
	/* Build tool bar later. */
	browser->toolbar = NULL;


	/* Location bar handle box. */
	browser->location_bar_handle = w = gtk_handle_box_new();
        gtk_signal_connect_after(
            GTK_OBJECT(w), "child_attached",
            GTK_SIGNAL_FUNC(EDVBrowserHandleChildAttachedCB), browser
        );
        gtk_signal_connect_after(
            GTK_OBJECT(w), "child_detached",
            GTK_SIGNAL_FUNC(EDVBrowserHandleChildDetachedCB), browser
        );
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	if(browser->location_bar_map_state)
	    gtk_widget_show(w);
	parent2 = w;

	/* Location bar hbox for location bar. */
	browser->location_bar_hbox = w = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_widget_show(w);
	parent2 = w;


	/* Hbox for location icon and combo. */
	w = gtk_hbox_new(FALSE, 0);	/* Don't need spacing between icon
					 * and combo because combo has it
					 * already.
					 */
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Vbox to orient location icon fixed parent. */
	w = gtk_vbox_new(TRUE, 0);
        gtk_widget_set_usize(w, 20, 20);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Location icon fixed parent. */
        browser->location_icon_fixed = w = gtk_fixed_new();
	gtk_widget_add_events(
	    w,
            GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
            GDK_POINTER_MOTION_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK
	);
        gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "enter_notify_event",
            GTK_SIGNAL_FUNC(EDVBrowserLocBarIconCrossingCB), browser
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "leave_notify_event",
            GTK_SIGNAL_FUNC(EDVBrowserLocBarIconCrossingCB), browser
        );
        gtk_widget_realize(w);
        cursor = EDVGetCursor(
            (edv_core_struct *)core_ptr, EDV_CURSOR_CODE_HAND
        );
        gdk_window_set_cursor(w->window, cursor);
        GUISetWidgetTip(
            w,
#ifdef PROG_LANGUAGE_ENGLISH
"Drag this to create a link to this location"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Arrastre esto crear un eslabn a esta ubicacin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Traner ceci pour crer un lien  cet emplacement"
#endif
        );
        gtk_widget_show(w);

	/* Reset location icon pixmap. */
	browser->location_icon_pm = NULL;

	/* Location combo. */
	glist = NULL;
	w = (GtkWidget *)GUIComboCreate(
#ifdef PROG_LANGUAGE_ENGLISH
            "Location:",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Ubicacin:",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Emplacement:",
#endif
	    "/",
	    glist,
	    20, 	/* Maximum items. */
	    &combo_rtn,
	    browser,
	    EDVBrowserComboActivateCB,
	    NULL
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);

	browser->location_combo = w = (GtkWidget *)combo_rtn;
	combo = GTK_COMBO(w);
        gtk_combo_set_case_sensitive(combo, TRUE);
        GUIDNDSetSrc(
            browser->location_icon_fixed,
            dnd_src_types,
            sizeof(dnd_src_types) / sizeof(GtkTargetEntry),
            GDK_ACTION_COPY | GDK_ACTION_MOVE |
	    GDK_ACTION_LINK,			/* Actions. */
            GDK_BUTTON1_MASK | GDK_BUTTON2_MASK,/* Buttons. */
            NULL,
            EDVLocBarIconDragDataGet,
            NULL,
            NULL,
            combo
        );
	EDVEntrySetDND((edv_core_struct *)core_ptr, combo->entry);


        /* Mount bar handle box. */
        browser->mount_bar_handle = w = gtk_handle_box_new();
        gtk_signal_connect_after(
            GTK_OBJECT(w), "child_attached",
            GTK_SIGNAL_FUNC(EDVBrowserHandleChildAttachedCB), browser
        );
        gtk_signal_connect_after(
            GTK_OBJECT(w), "child_detached",
            GTK_SIGNAL_FUNC(EDVBrowserHandleChildDetachedCB), browser
        );
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        if(browser->mount_bar_map_state)
            gtk_widget_show(w);
        parent2 = w;

	/* Create mount bar. */
	browser->mountbar = EDVMountBarNew(
	    core_ptr, parent2,
	    EDVBrowserMountBarMountCB,
	    EDVBrowserMountBarEjectCB,
	    EDVBrowserMountBarGoToCB,
	    EDVBrowserBarStatusMessageCB,
	    browser
	);
	EDVMountBarMap(browser->mountbar);


        /* Find bar handle box. */
        browser->find_bar_handle = w = gtk_handle_box_new();
        gtk_signal_connect_after(
            GTK_OBJECT(w), "child_attached",
            GTK_SIGNAL_FUNC(EDVBrowserHandleChildAttachedCB), browser
        );
        gtk_signal_connect_after(
            GTK_OBJECT(w), "child_detached",
            GTK_SIGNAL_FUNC(EDVBrowserHandleChildDetachedCB), browser
        );
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        if(browser->find_bar_map_state)
            gtk_widget_show(w);
        parent2 = w;

        /* Create find bar. */
        browser->findbar = EDVFindBarNew(
            core_ptr, parent2,
	    EDV_FINDBAR_ROLE_DISK_OBJECT,
            EDVBrowserBarStatusMessageCB,
	    EDVBrowserBarStatusProgressCB,
            EDVBrowserFindBarLocationCB,
	    EDVBrowserFindBarStartCB,
	    EDVBrowserFindBarEndCB,
	    EDVBrowserFindBarMatchCB,
            browser
        );
        EDVFindBarMap(browser->findbar);


	/* Main paned. */
	browser->main_paned = w = gtk_hpaned_new();
	gtk_paned_set_position(GTK_PANED(w), paned_position);
	gtk_paned_set_handle_size(
	    GTK_PANED(w), EDV_DEF_PANED_HANDLE_SIZE
	);
	gtk_paned_set_gutter_size(
	    GTK_PANED(w), EDV_DEF_PANED_GUTTER_SIZE
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Scrolled window for directory ctree. */
        w = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(
            GTK_SCROLLED_WINDOW(w),
            GTK_POLICY_AUTOMATIC,
            GTK_POLICY_AUTOMATIC
        );
	gtk_paned_add1(GTK_PANED(parent2), w);
        gtk_widget_show(w);
        parent3 = w;

	/* Create directory ctree. */
	browser->directory_ctree = w = gtk_ctree_new(1, 0);
        clist = GTK_CLIST(w);
	ctree = GTK_CTREE(w);
	gtk_widget_add_events(
	    w,
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
        gtk_signal_connect(
            GTK_OBJECT(w), "key_press_event",
            GTK_SIGNAL_FUNC(EDVBrowserKeyEventCB), browser
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "key_release_event",
            GTK_SIGNAL_FUNC(EDVBrowserKeyEventCB), browser
        );
        gtk_signal_connect_after(
            GTK_OBJECT(w), "button_press_event",
            GTK_SIGNAL_FUNC(EDVBrowserButtonPressEventCB), browser
        );
/*      gtk_clist_set_selection_mode(clist, GTK_SELECTION_BROWSE); */
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_SINGLE);
	gtk_ctree_set_line_style(ctree, GTK_CTREE_LINES_DOTTED);
	gtk_clist_set_column_auto_resize(clist, 0, TRUE);
	gtk_clist_set_column_justification(
	    clist, 0, GTK_JUSTIFY_LEFT
	);
        gtk_clist_set_row_height(clist, EDV_LIST_ROW_SPACING);
        gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_signal_connect(
            GTK_OBJECT(w), "tree_select_row",
            GTK_SIGNAL_FUNC(EDVBrowserTreeSelectRowCB), browser
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "tree_unselect_row",
            GTK_SIGNAL_FUNC(EDVBrowserTreeUnselectRowCB), browser
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "tree_expand",
            GTK_SIGNAL_FUNC(EDVBrowserTreeExpandCB), browser
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "tree_collapse",
            GTK_SIGNAL_FUNC(EDVBrowserTreeCollapseCB), browser
        );
        /* Set up DND for the directory ctree. */
        GUIDNDSetSrc(
            w,
	    dnd_src_types,
	    sizeof(dnd_src_types) / sizeof(GtkTargetEntry),
            GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,		/* Actions. */
            GDK_BUTTON1_MASK | GDK_BUTTON2_MASK,/* Buttons. */
            NULL,
            EDVBrowserDirTreeDragDataGetCB,
            EDVBrowserDirTreeDragDataDeleteCB,
            NULL,
            browser
        );
        GUIDNDSetTar(
            w,
            dnd_tar_types,
            sizeof(dnd_tar_types) / sizeof(GtkTargetEntry),
            GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,		/* Actions. */
            GDK_ACTION_MOVE,			/* Default action if same. */
            GDK_ACTION_MOVE,			/* Default action. */
            EDVBrowserDirTreeDragDataReceivedCB,
            browser
        );
        rcstyle = gtk_rc_style_new();
        rcstyle->font_name = (font_name != NULL) ? g_strdup(font_name) : NULL;
	state = GTK_STATE_NORMAL;
	rcstyle->color_flags[state] =
	    ((fg_color_name != NULL) ? GTK_RC_FG | GTK_RC_TEXT : 0) |
	    ((bg_color_name != NULL) ? GTK_RC_BG | GTK_RC_BASE : 0);
	if(fg_color_name != NULL)
	{
            gdk_color_parse(fg_color_name, &rcstyle->fg[state]);
	    gdk_color_parse(fg_color_name, &rcstyle->text[state]);
	}
	if(bg_color_name != NULL)
	{
            gdk_color_parse(bg_color_name, &rcstyle->bg[state]);
	    gdk_color_parse(bg_color_name, &rcstyle->base[state]);
	}
	if(bg_pixmap_path != NULL)
	    rcstyle->bg_pixmap_name[state] = g_strdup(bg_pixmap_path);
        state = GTK_STATE_SELECTED;
        rcstyle->color_flags[state] =
            ((sfg_color_name != NULL) ? GTK_RC_FG | GTK_RC_TEXT : 0) |
            ((sbg_color_name != NULL) ? GTK_RC_BG | GTK_RC_BASE : 0);
        if(sfg_color_name != NULL)
        {
            gdk_color_parse(sfg_color_name, &rcstyle->fg[state]);
            gdk_color_parse(sfg_color_name, &rcstyle->text[state]);
        }
        if(sbg_color_name != NULL)
        {
            gdk_color_parse(sbg_color_name, &rcstyle->bg[state]);
            gdk_color_parse(sbg_color_name, &rcstyle->base[state]);
        }
        if(sbg_pixmap_path != NULL)
            rcstyle->bg_pixmap_name[state] = g_strdup(sbg_pixmap_path);
        gtk_widget_modify_style(w, rcstyle);
        GUIRCStyleDeallocUnref(rcstyle);
        gtk_widget_show(w);


        /* Scrolled window for contents clist. */
        w = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(
            GTK_SCROLLED_WINDOW(w),
            GTK_POLICY_AUTOMATIC,
            GTK_POLICY_AUTOMATIC
        );
        gtk_paned_add2(GTK_PANED(parent2), w);
        gtk_widget_show(w);
        parent3 = w;

	/* Contents clist. */
	browser->contents_clist = w = gtk_clist_new(EDV_BROWSER_CONTENTS_CLIST_COLUMNS_MAX);
        clist = GTK_CLIST(w);
        gtk_widget_add_events(
            w,
            GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
            GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
            GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
            GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "key_press_event",
            GTK_SIGNAL_FUNC(EDVBrowserKeyEventCB), browser
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "key_release_event",
            GTK_SIGNAL_FUNC(EDVBrowserKeyEventCB), browser
        );
        gtk_signal_connect_after(
            GTK_OBJECT(w), "button_press_event",
            GTK_SIGNAL_FUNC(EDVBrowserButtonPressEventCB), browser
        );
        gtk_clist_set_selection_mode(clist, GTK_SELECTION_EXTENDED);
	for(i = 0; i < clist->columns; i++)
	    gtk_clist_set_column_width(clist, i, 10);
        gtk_clist_set_row_height(clist, EDV_LIST_ROW_SPACING);
        gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_signal_connect(
            GTK_OBJECT(w), "resize_column",
            GTK_SIGNAL_FUNC(EDVBrowserResizeColumnCB), browser
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "click_column",
            GTK_SIGNAL_FUNC(EDVBrowserClickColumnCB), browser
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "select_row",
            GTK_SIGNAL_FUNC(EDVBrowserSelectRowCB), browser
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "unselect_row",
            GTK_SIGNAL_FUNC(EDVBrowserUnselectRowCB), browser
        );
	/* Set up DND for the contents list. */
        GUIDNDSetSrc(
            w,
            dnd_src_types,
            sizeof(dnd_src_types) / sizeof(GtkTargetEntry),
            GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,		/* Actions. */
            GDK_BUTTON1_MASK | GDK_BUTTON2_MASK,/* Buttons. */
            NULL,
            EDVBrowserContentsDragDataGetCB,
            EDVBrowserContentsDragDataDeleteCB,
            NULL,
            browser
        );
        GUIDNDSetTar(
            w,
            dnd_tar_types,
            sizeof(dnd_tar_types) / sizeof(GtkTargetEntry),
            GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,		/* Actions. */
            GDK_ACTION_MOVE,			/* Default action if same. */
            GDK_ACTION_MOVE,			/* Default action. */
            EDVBrowserContentsDragDataReceivedCB,
            browser
        );
	rcstyle = gtk_rc_style_new();
	rcstyle->font_name = (font_name != NULL) ? g_strdup(font_name) : NULL;
        state = GTK_STATE_NORMAL;
        rcstyle->color_flags[state] =
            ((fg_color_name != NULL) ? GTK_RC_FG | GTK_RC_TEXT : 0) |
            ((bg_color_name != NULL) ? GTK_RC_BG | GTK_RC_BASE : 0);
        if(fg_color_name != NULL)
        {
            gdk_color_parse(fg_color_name, &rcstyle->fg[state]);
            gdk_color_parse(fg_color_name, &rcstyle->text[state]);
        }
        if(bg_color_name != NULL)
        {
            gdk_color_parse(bg_color_name, &rcstyle->bg[state]);
            gdk_color_parse(bg_color_name, &rcstyle->base[state]);
        }
        if(bg_pixmap_path != NULL)
            rcstyle->bg_pixmap_name[state] = g_strdup(bg_pixmap_path);
        state = GTK_STATE_SELECTED;
        rcstyle->color_flags[state] =
            ((sfg_color_name != NULL) ? GTK_RC_FG | GTK_RC_TEXT : 0) |
            ((sbg_color_name != NULL) ? GTK_RC_BG | GTK_RC_BASE : 0);
        if(sfg_color_name != NULL)
        {
            gdk_color_parse(sfg_color_name, &rcstyle->fg[state]);
            gdk_color_parse(sfg_color_name, &rcstyle->text[state]);
        }
        if(sbg_color_name != NULL)
        {
            gdk_color_parse(sbg_color_name, &rcstyle->bg[state]);
            gdk_color_parse(sbg_color_name, &rcstyle->base[state]);
        }
        if(sbg_pixmap_path != NULL)
            rcstyle->bg_pixmap_name[state] = g_strdup(sbg_pixmap_path);
	gtk_widget_modify_style(w, rcstyle);
	GUIRCStyleDeallocUnref(rcstyle);
	gtk_widget_show(w);


        /* Get source style from contents clist as a template. */
        src_style = gtk_widget_get_style(browser->contents_clist);

	/* Begin creating cell styles. */
	/* No access. */
	style = (src_style != NULL) ? gtk_style_copy(src_style) : NULL;
	if(style != NULL)
	{
	    gint state = GTK_STATE_NORMAL;
	    c = &style->fg[state];
	    gdk_colormap_free_colors(colormap, c, 1);
	    c->red = 1.0 * (guint16)-1;
            c->green = 0.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
	    gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

	    state = GTK_STATE_ACTIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 1.0 * (guint16)-1;
            c->green = 0.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

	    state = GTK_STATE_PRELIGHT;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 1.0 * (guint16)-1;
            c->green = 0.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

	    state = GTK_STATE_SELECTED;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 1.0 * (guint16)-1;
            c->green = 0.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

	    state = GTK_STATE_INSENSITIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.75 * (guint16)-1;
            c->green = 0.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);


	    browser->cell_style[EDV_BROWSER_CELL_STYLE_NO_ACCESS] = style;
	}

	/* Dangling link. */
        style = (src_style != NULL) ? gtk_style_copy(src_style) : NULL;
        if(style != NULL)
        {
            gint state = GTK_STATE_NORMAL;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.5 * (guint16)-1;
            c->green = 0.5 * (guint16)-1;
            c->blue = 0.5 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_ACTIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.5 * (guint16)-1;
            c->green = 0.5 * (guint16)-1;
            c->blue = 0.5 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_PRELIGHT;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.5 * (guint16)-1;
            c->green = 0.5 * (guint16)-1;
            c->blue = 0.5 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_SELECTED;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.75 * (guint16)-1;
            c->green = 0.75 * (guint16)-1;
            c->blue = 0.75 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_INSENSITIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.75 * (guint16)-1;
            c->green = 0.75 * (guint16)-1;
            c->blue = 0.75 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);


            browser->cell_style[EDV_BROWSER_CELL_STYLE_DANGLING_LINK] = style;
        }

        /* Hidden object. */
        style = (src_style != NULL) ? gtk_style_copy(src_style) : NULL;
        if(style != NULL)
        {
            gint state = GTK_STATE_NORMAL;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.75 * (guint16)-1;
            c->green = 0.75 * (guint16)-1;
            c->blue = 0.75 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_ACTIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 1.0 * (guint16)-1;
            c->green = 1.0 * (guint16)-1;
            c->blue = 1.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_PRELIGHT;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 1.0 * (guint16)-1;
            c->green = 1.0 * (guint16)-1;
            c->blue = 1.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_SELECTED;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 1.0 * (guint16)-1;
            c->green = 1.0 * (guint16)-1;
            c->blue = 1.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_INSENSITIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.75 * (guint16)-1;
            c->green = 0.75 * (guint16)-1;
            c->blue = 0.75 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);
            browser->cell_style[EDV_BROWSER_CELL_STYLE_HIDDEN] = style;
        }

        /* Executable. */
        style = (src_style != NULL) ? gtk_style_copy(src_style) : NULL;
        if(style != NULL)
        {
            gint state = GTK_STATE_NORMAL;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.0 * (guint16)-1;
            c->green = 1.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_ACTIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.0 * (guint16)-1;
            c->green = 1.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_PRELIGHT;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.0 * (guint16)-1;
            c->green = 1.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_SELECTED;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.0 * (guint16)-1;
            c->green = 1.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_INSENSITIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.75 * (guint16)-1;
            c->green = 0.75 * (guint16)-1;
            c->blue = 0.75 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);
            browser->cell_style[EDV_BROWSER_CELL_STYLE_EXECUTABLE] = style;
        }


	/* Create tool bar. */
        EDVBrowserToolbarRegenerate(browser);

	/* Create directory ctree menu. */
	EDVBrowserDirectoryMenuRegenerate(browser);

	/* Create contents clist menu. */
	EDVBrowserContentsMenuRegenerate(browser);


	/* Create status bar. */
	browser->status_bar = status_bar = EDVStatusBarNew(
	    core_ptr, browser->main_vbox
	);
	if(status_bar != NULL)
	{
	    if(browser->status_bar_map_state)
		EDVStatusBarMap(status_bar);
	    else
		EDVStatusBarUnmap(status_bar);
	}

	/* Reset all values. */
	EDVBrowserReset(browser, FALSE);

	/* Update menus. */
	EDVBrowserUpdateMenus(browser);

	return(browser);
}

/*
 *	Resets all values on the given browser.
 */
void EDVBrowserReset(edv_browser_struct *browser, gbool need_unmap)
{
        if(browser == NULL)
            return;

        if(!browser->initialized)
            return;


	EDVBrowserSetTitle(browser, NULL);


	if(need_unmap)
	    EDVBrowserUnmap(browser);
}

/*
 *	Syncronizes all data in the browser's widgets to internal data
 *	on the browser.
 */
void EDVBrowserSyncData(edv_browser_struct *browser)
{
        if(browser == NULL)
            return;

        if(!browser->initialized)
            return;

/* This function may be removed in the future, since there really is
 * no floating data from widgets to be synced to disk on the browser.
 */


}


/*
 *	Updates all widgets on the given browser to reflect the current
 *	data.
 */
void EDVBrowserUpdateMenus(edv_browser_struct *browser)
{
	gbool write_protect, write_protect_changed = FALSE;
	gbool sensitive, state;
	gint selected_dev_num;
	edv_device_struct *selected_dev_ptr;
	guint8 **icon_data, **recbin_icon_data;
	GtkWidget *w;
	gbool	selected_dir_node_expanded = FALSE,
		selected_dir_node_has_child = FALSE;
	GtkCTreeNode *selected_dir_node;
	gint selected_obj_row;
	toolbar_struct *tb;
	edv_core_struct *core_ptr;


	if(browser == NULL)
	    return;

        if(!browser->initialized)
            return;

	core_ptr = (edv_core_struct *)browser->core_ptr;
	if(core_ptr == NULL)
	    return;

        tb = browser->toolbar;

#define DO_SET_SENSITIVE	\
{ \
 if(w != NULL) \
  gtk_widget_set_sensitive(w, sensitive); \
}
#define DO_SHOW	\
{ \
 if(w != NULL) \
  gtk_widget_show(w); \
}
#define DO_HIDE \
{ \
 if(w != NULL) \
  gtk_widget_hide(w); \
}
#define DO_SET_CHECK_STATE	\
{ \
 if((w != NULL) ? GTK_IS_CHECK_MENU_ITEM(w) : FALSE) \
  GTK_CHECK_MENU_ITEM(w)->active = state; \
}
	/* Get global write protect state. */
	write_protect = EDVCFGItemListGetValueI(
	    core_ptr->cfg_list, EDV_CFG_PARM_WRITE_PROTECT
	);
	if(browser->last_write_protect_state < 0)
	{
	    write_protect_changed = TRUE;
	}
	else
	{
	    if((write_protect && !browser->last_write_protect_state) ||
	       (!write_protect && browser->last_write_protect_state)
	    )
		write_protect_changed = TRUE;
	}
	browser->last_write_protect_state = write_protect ? 1 : 0;

	/* Get last selected directory node and contents row, note
	 * that even not NULL or positive does not mean they are
	 * valid. Check if they actually exist on the list before
	 * referencing them.
	 */
	selected_dir_node = browser->directory_ctree_selected_node;
	selected_obj_row = browser->contents_clist_selected_row;

	/* Get last selected device (if any). */
	selected_dev_num = browser->selected_dev_num;
	if((selected_dev_num >= 0) && (selected_dev_num < core_ptr->total_devices))
	    selected_dev_ptr = core_ptr->device[selected_dev_num];
	else
	    selected_dev_ptr = NULL;

	/* Update recycle bin icon data, setting it to not NULL if it
	 * needs to be changed and update the browser's last_recbin_items
	 * to match the value on the core structure.
	 */
        icon_data = NULL;
        if(browser->last_recbin_items < 0)
        {
            if(core_ptr->last_recbin_items > 0)
                icon_data = (guint8 **)icon_trash_20x20_xpm;
            else
                icon_data = (guint8 **)icon_trash_empty_20x20_xpm;
        }
        else
        {
            if(!browser->last_recbin_items &&
               core_ptr->last_recbin_items
            )
                icon_data = (guint8 **)icon_trash_20x20_xpm;
            else if(browser->last_recbin_items &&
                    !core_ptr->last_recbin_items
            )
                icon_data = (guint8 **)icon_trash_empty_20x20_xpm;
        }
        browser->last_recbin_items = core_ptr->last_recbin_items;
	recbin_icon_data = icon_data;


	/* Get selected directory node expand state (if any). */
	if(browser->directory_ctree != NULL)
	{
	    GtkCTreeNode *node;
	    GtkCTreeRow *row_ptr;
	    GtkCTree *ctree = GTK_CTREE(browser->directory_ctree);

	    node = EDVCTreeGetSelectedLast(ctree, &row_ptr);
	    if(row_ptr != NULL)
	    {
		selected_dir_node_expanded = row_ptr->expanded;
		selected_dir_node_has_child = (row_ptr->children != NULL) ?
		    TRUE : FALSE;
	    }
	}


	/* Update mount bar. */
	EDVMountBarUpdateMenus(browser->mountbar);

        /* Update find bar. */
        EDVFindBarUpdateMenus(browser->findbar);



	/* Begin updating menu items and tool bar items. */

	/* File. */
	/* Open and open with. */
        sensitive = (selected_obj_row > -1) ? TRUE : FALSE;
	/* Open. */
	w = browser->open_mi;
	DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_OPEN, sensitive
        );
	/* Open with. */
        w = browser->openwith_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_OPEN_WITH, sensitive
        );

	/* New object sub menu item. */
        sensitive = ((selected_dir_node != NULL) ||
            (selected_obj_row > -1)) ? TRUE : FALSE;
        w = browser->new_object_submi;
	DO_SET_SENSITIVE
	/* New file. */
        w = browser->new_file_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_NEW_FILE, sensitive
        );
	/* New directory. */
        w = browser->new_directory_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_NEW_DIRECTORY, sensitive
        );
	/* New link. */
        w = browser->new_link_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_NEW_LINK, sensitive
        );
	/* New fifo. */
        w = browser->new_fifo_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_NEW_FIFO, sensitive
        );
	/* New block device. */
        w = browser->new_device_block_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_NEW_DEVICE_BLOCK, sensitive
        );
	/* New character device. */
        w = browser->new_device_character_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_NEW_DEVICE_CHARACTER, sensitive
        );
	/* New socket. */
        w = browser->new_socket_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_NEW_SOCKET, sensitive
        );

	/* Go to parent. */
	sensitive = (selected_dir_node != NULL) ? TRUE : FALSE;
	ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_GOTO_PARENT, sensitive
        );

	/* Edit. */
        sensitive = ((selected_dir_node != NULL) ||
            (selected_obj_row > -1)) ? TRUE : FALSE;
	/* Move. */
        w = browser->move_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_MOVE, sensitive
        );
	/* Copy. */
        w = browser->copy_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_COPY, sensitive
        );
	/* Link. */
        w = browser->link_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_LINK, sensitive
        );
	/* Rename. */
        w = browser->rename_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_RENAME, sensitive
        );
	/* Change mode. */
        w = browser->chmod_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_CHMOD, sensitive
        );
	/* Chown. */
        w = browser->chown_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_CHOWN, sensitive
        );
	/* Delete. */
        w = browser->delete_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_DELETE, sensitive
        );
	/* Properties. */
        w = browser->properties_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_PROPERTIES, sensitive
        );
	/* Copy path. */
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_COPY_PATH, sensitive
        );
	/* Copy URL. */
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_COPY_URL, sensitive
        );

	/* View. */
	/* Show tool bar. */
	w = browser->show_tool_bar_micheck;
	state = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR
	);
	DO_SET_CHECK_STATE
        ToolBarItemSetToggleID(
            tb, EDV_BROWSER_OP_SHOW_TOOL_BAR, state
	);
	/* Show location bar. */
        w = browser->show_location_bar_micheck;
        state = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR
        );
        DO_SET_CHECK_STATE
        ToolBarItemSetToggleID(
            tb, EDV_BROWSER_OP_SHOW_LOCATION_BAR, state
        );
	/* Show mount bar. */
        w = browser->show_mount_bar_micheck;
        state = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR
        );
        DO_SET_CHECK_STATE
        ToolBarItemSetToggleID(
            tb, EDV_BROWSER_OP_SHOW_MOUNT_BAR, state
        );
	/* Show find bar. */
        w = browser->show_find_bar_micheck;
        state = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR
        );
        DO_SET_CHECK_STATE
        ToolBarItemSetToggleID(
            tb, EDV_BROWSER_OP_SHOW_FIND_BAR, state
        );
	/* Show status bar. */
        w = browser->show_status_bar_micheck;
        state = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR
        );
        DO_SET_CHECK_STATE
        ToolBarItemSetToggleID(
            tb, EDV_BROWSER_OP_SHOW_STATUS_BAR, state
        );


	/* Device. */
	w = browser->mount_mi;
	sensitive = (selected_dev_ptr != NULL) ?
	    !selected_dev_ptr->no_unmount : FALSE;
	DO_SET_SENSITIVE
        if(w != NULL)
        {
            const gchar *text;

            if(selected_dev_ptr != NULL)
                text =  selected_dev_ptr->is_mounted ?
                    "Unmount" : "Mount";
            else
                text = "Mount/Unmount";
            GUIMenuItemSetLabel(w, text);
            ToolBarItemUpdateByID(
                tb, EDV_BROWSER_OP_MOUNT, text, NULL, NULL
	    );
        }
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_MOUNT, sensitive
        );

	/* Eject. */
	if(selected_dev_ptr != NULL)
	    sensitive = (selected_dev_ptr->command_eject != NULL) ?
		(*selected_dev_ptr->command_eject != '\0') : FALSE;
	else
	    sensitive = FALSE;
	w = browser->eject_mi;
	DO_SET_SENSITIVE
	ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_EJECT, sensitive
        );

	/* Device check, tools, and format commands. */
	if(selected_dev_ptr != NULL)
	    sensitive = (selected_dev_ptr->command_check != NULL) ?
	       (*selected_dev_ptr->command_check != '\0') : FALSE;
	else
	    sensitive = FALSE;
	w = browser->device_check_mi;
	DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_DEVICE_CHECK, sensitive
        );

        if(selected_dev_ptr != NULL)
            sensitive = (selected_dev_ptr->command_tools != NULL) ?
               (*selected_dev_ptr->command_tools != '\0') : FALSE;
        else
            sensitive = FALSE;
        w = browser->device_tools_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_DEVICE_TOOLS, sensitive
        );

        if(selected_dev_ptr != NULL)
            sensitive = (selected_dev_ptr->command_format != NULL) ?
               (*selected_dev_ptr->command_format != '\0') : FALSE;
        else
            sensitive = FALSE;
        w = browser->device_format_mi;
        DO_SET_SENSITIVE
        ToolBarItemSetSensitiveID(
            tb, EDV_BROWSER_OP_DEVICE_FORMAT, sensitive
        );


	/* Settings. */
	if(write_protect_changed)
	{
	    w = browser->write_protect_mi;
	    if(w != NULL)
		GUIMenuItemSetPixmap(
		    w,
		    (u_int8_t **)(write_protect ?
			icon_secure_20x20_xpm : icon_insecure_20x20_xpm)
		);
            ToolBarItemUpdateByID(
                tb, EDV_BROWSER_OP_WRITE_PROTECT,
                NULL,
                (guint8 **)(write_protect ?
                    icon_secure_20x20_xpm : icon_insecure_20x20_xpm),
                NULL
            );
	}


	/* Windows. */
	if(recbin_icon_data != NULL)
	{
	    GUIMenuItemSetPixmap(
		browser->window_recycle_bin_mi, recbin_icon_data
	    );
            ToolBarItemUpdateByID(
                tb, EDV_BROWSER_OP_RECYCLE_BIN,
                NULL, recbin_icon_data, NULL
            );
	}


	/* Update directory ctree menu. */
        sensitive = (selected_dir_node != NULL) ? TRUE : FALSE;
	w = browser->directory_ctree_move_mi;
        DO_SET_SENSITIVE
        w = browser->directory_ctree_copy_mi;
        DO_SET_SENSITIVE
        w = browser->directory_ctree_link_mi;
        DO_SET_SENSITIVE
        w = browser->directory_ctree_rename_mi;
        DO_SET_SENSITIVE
        w = browser->directory_ctree_chmod_mi;
        DO_SET_SENSITIVE
        w = browser->directory_ctree_chown_mi;
        DO_SET_SENSITIVE
        w = browser->directory_ctree_delete_mi;
        DO_SET_SENSITIVE
        w = browser->directory_ctree_properties_mi;
        DO_SET_SENSITIVE

        w = browser->directory_ctree_expand_mi;
	if(selected_dir_node != NULL)
	    sensitive = selected_dir_node_has_child;
	else
	    sensitive = FALSE;
        DO_SET_SENSITIVE
	if(1)
	{
	    const gchar *text;

	    if(sensitive)
		text = selected_dir_node_expanded ?
		    "Collapse" : "Expand";
	    else
		text = "Expand/Collapse";
	    GUIMenuItemSetLabel(w, text);
	}

	w = browser->directory_ctree_mount_mi;
	if(selected_dev_ptr == NULL)
	    DO_HIDE
	else
	    DO_SHOW
        sensitive = (selected_dev_ptr != NULL) ?
            !selected_dev_ptr->no_unmount : FALSE;
        DO_SET_SENSITIVE
        if(selected_dev_ptr != NULL)
        {
            const gchar *text = selected_dev_ptr->is_mounted ?
		"Unmount" : "Mount";
            GUIMenuItemSetLabel(w, text);
        }

        w = browser->directory_ctree_mount_misep;
        if(selected_dev_ptr == NULL)
            DO_HIDE
        else
            DO_SHOW

	/* Eject. */
	w = browser->directory_ctree_eject_mi;
        if(selected_dev_ptr == NULL)
            DO_HIDE
        else
            DO_SHOW
        if(selected_dev_ptr != NULL)
            sensitive = (selected_dev_ptr->command_eject != NULL) ?
                (*selected_dev_ptr->command_eject != '\0') : FALSE;
        else
            sensitive = FALSE;
	DO_SET_SENSITIVE


        /* Update contents clist menu. */
        sensitive = (selected_obj_row > -1) ? TRUE : FALSE;
        w = browser->contents_clist_open_mi;
        DO_SET_SENSITIVE
        w = browser->contents_clist_openwith_mi;
        DO_SET_SENSITIVE
        w = browser->contents_clist_move_mi;
        DO_SET_SENSITIVE
        w = browser->contents_clist_copy_mi;
        DO_SET_SENSITIVE
        w = browser->contents_clist_link_mi;
        DO_SET_SENSITIVE
        w = browser->contents_clist_rename_mi;
        DO_SET_SENSITIVE
        w = browser->contents_clist_chmod_mi;
        DO_SET_SENSITIVE
        w = browser->contents_clist_chown_mi;
        DO_SET_SENSITIVE
        w = browser->contents_clist_delete_mi;
        DO_SET_SENSITIVE
        w = browser->contents_clist_properties_mi;
        DO_SET_SENSITIVE




	/* Update status bar. */
        EDVStatusBarUpdateMenus(browser->status_bar);

#undef DO_SHOW
#undef DO_HIDE
#undef DO_SET_SENSITIVE
#undef DO_SET_CHECK_STATE
}

/*
 *	Marks the browser as busy or ready.
 */
void EDVBrowserSetBusy(edv_browser_struct *browser, gbool is_busy)
{
	GdkCursor *cursor;
        GtkWidget *w;
	edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

        if(!browser->initialized)
            return;

	core_ptr = (edv_core_struct *)browser->core_ptr;
	if(core_ptr == NULL)
	    return;

	w = browser->toplevel;
	if(w != NULL)
	{
	    if(is_busy)
	    {
		/* Increase busy count. */
		browser->busy_count++;

		/* If already busy then don't change anything. */
		if(browser->busy_count > 1)
		    return;

		cursor = EDVGetCursor(core_ptr, EDV_CURSOR_CODE_BUSY);
	    }
	    else
	    {
		/* Reduce busy count. */
		browser->busy_count--;
		if(browser->busy_count < 0)
		    browser->busy_count = 0;

		/* If still busy do not change anything. */
		if(browser->busy_count > 0)
                    return;

		cursor = NULL;	/* Use default cursor. */
	    }

	    /* Update toplevel window's cursor. */
	    if(w->window != NULL)
	    {
		gdk_window_set_cursor(w->window, cursor);
		gdk_flush();
	    }
	}
}


/*
 *	Maps the given browser.
 */
void EDVBrowserMap(edv_browser_struct *browser)
{
        GtkWidget *w;


        if(browser == NULL)
            return;

        if(!browser->initialized)
            return;

	w = browser->toplevel;
	gtk_widget_show_raise(w);
	browser->map_state = TRUE;
}

/*
 *	Unmaps the given browser.
 */
void EDVBrowserUnmap(edv_browser_struct *browser)
{
        GtkWidget *w;


        if(browser == NULL)
            return;

        if(!browser->initialized)
            return;

        if(browser->map_state)
        {
            w = browser->toplevel;
            if(w != NULL)
                gtk_widget_hide(w);

            browser->map_state = FALSE;
        }
}

/*
 *	Destroys all resources on the given browser and deallocates the
 *	structure itself.
 */
void EDVBrowserDelete(edv_browser_struct *browser)
{
	gint i;
	GtkStyle **style;
        GtkWidget **w;


	if(browser == NULL)
	    return;

	if(browser->initialized)
	{
#define DO_UNREF_STYLE		\
{ \
 if((*style) != NULL) \
 { \
  GtkStyle *ts = *style; \
  (*style) = NULL; \
  gtk_style_unref(ts); \
 } \
}

#define DO_DESTROY_WIDGET	\
{ \
 if((*w) != NULL) \
 { \
  GtkWidget *tmp_w = *w; \
  (*w) = NULL; \
  gtk_widget_destroy(tmp_w); \
 } \
}

	    /* Reset last selected item references. */
	    browser->directory_ctree_selected_node = NULL;
	    browser->contents_clist_selected_row = -1;

	    /* Delete file operation dialog. */
	    EDVFOPDialogDelete(browser->fopdialog);
	    browser->fopdialog = NULL;


	    /* Right click menus. */
	    w = &browser->directory_ctree_menu;
	    browser->directory_ctree_expand_mi = NULL;
	    browser->directory_ctree_mount_mi = NULL;
	    browser->directory_ctree_eject_mi = NULL;
	    browser->directory_ctree_mount_misep = NULL;
            browser->directory_ctree_move_mi = NULL;
            browser->directory_ctree_copy_mi = NULL;
            browser->directory_ctree_link_mi = NULL;
            browser->directory_ctree_rename_mi = NULL;
            browser->directory_ctree_chmod_mi = NULL;
            browser->directory_ctree_chown_mi = NULL;
            browser->directory_ctree_delete_mi = NULL;
            browser->directory_ctree_properties_mi = NULL;
	    DO_DESTROY_WIDGET

	    w = &browser->contents_clist_menu;
            browser->contents_clist_open_mi = NULL;
            browser->contents_clist_openwith_mi = NULL;
            browser->contents_clist_move_mi = NULL;
            browser->contents_clist_copy_mi = NULL;
            browser->contents_clist_link_mi = NULL;
            browser->contents_clist_rename_mi = NULL;
            browser->contents_clist_chmod_mi = NULL;
            browser->contents_clist_chown_mi = NULL;
            browser->contents_clist_delete_mi = NULL;
            browser->contents_clist_properties_mi = NULL;
	    DO_DESTROY_WIDGET


	    /* Delete status bar. */
	    EDVStatusBarDelete(browser->status_bar);
	    browser->status_bar = NULL;

	    /* Delete tool bar. */
	    ToolBarDelete(browser->toolbar);
	    browser->toolbar = NULL;

	    /* Delete mount bar. */
	    EDVMountBarDelete(browser->mountbar);
	    browser->mountbar = NULL;

            /* Delete find bar. */
            EDVFindBarDelete(browser->findbar);
            browser->findbar = NULL;

	    /* Destroy location bar widgets. */
	    w = &browser->location_icon_pm;
	    DO_DESTROY_WIDGET
	    w = &browser->location_icon_fixed;
	    DO_DESTROY_WIDGET
	    w = &browser->location_combo;
	    DO_DESTROY_WIDGET
	    w = &browser->location_bar_hbox;
	    DO_DESTROY_WIDGET


	    /* Destroy menu bar and submenus. */
	    w = &browser->new_object_submenu;
            browser->new_file_mi = NULL;
            browser->new_directory_mi = NULL;
            browser->new_link_mi = NULL;
            browser->new_fifo_mi = NULL;
            browser->new_device_block_mi = NULL;
            browser->new_device_character_mi = NULL;
            browser->new_socket_mi = NULL;
	    DO_DESTROY_WIDGET

	    w = &browser->menu_bar;
            browser->open_mi = NULL;
            browser->openwith_mi = NULL;
	    browser->new_object_submi = NULL;
            browser->sync_disks_mi = NULL;
	    browser->history_mi = NULL;
            browser->close_mi = NULL;

	    browser->move_mi = NULL;
	    browser->copy_mi = NULL;
	    browser->link_mi = NULL;
            browser->rename_mi = NULL;
            browser->chmod_mi = NULL;
            browser->chown_mi = NULL;
            browser->delete_mi = NULL;
            browser->select_all_mi = NULL;
            browser->unselect_all_mi = NULL;
	    browser->invert_selection_mi = NULL;
            browser->find_mi = NULL;
	    browser->properties_mi = NULL;

	    browser->mount_mi = NULL;
	    browser->eject_mi = NULL;
            browser->device_check_mi = NULL;
            browser->device_tools_mi = NULL;
            browser->device_format_mi = NULL;
	    browser->devices_mi = NULL;

	    browser->refresh_mi = NULL;
	    browser->refresh_all_mi = NULL;
            browser->show_tool_bar_micheck = NULL;
            browser->show_location_bar_micheck = NULL;
            browser->show_mount_bar_micheck = NULL;
            browser->show_find_bar_micheck = NULL;
            browser->show_status_bar_micheck = NULL;
            browser->mime_types_mi = NULL;

            browser->write_protect_mi = NULL;
            browser->options_mi = NULL;
            browser->customize_mi = NULL;

            browser->window_new_browser_mi = NULL;
            browser->window_new_imbr_mi = NULL;
	    browser->window_new_archiver_mi = NULL;
	    browser->window_recycle_bin_mi = NULL;

            browser->help_contents_mi = NULL;
            browser->help_file_browser_mi = NULL;
            browser->help_keys_list_mi = NULL;
            browser->help_mime_types_mi = NULL;
            browser->help_devices_mi = NULL;
            browser->help_common_operations_mi = NULL;
            browser->help_about_mi = NULL;

	    DO_DESTROY_WIDGET


	    /* Destroy toplevel and the rest of the widgets. */
            w = &browser->toplevel;
            browser->main_vbox = NULL;
	    browser->menu_bar = NULL;
	    browser->bars_vbox = NULL;
            browser->location_bar_handle = NULL;
            browser->tool_bar_handle = NULL;
            browser->menu_bar_handle = NULL;
	    browser->main_paned = NULL;
	    browser->directory_ctree = NULL;
	    browser->contents_clist = NULL;
            DO_DESTROY_WIDGET

	    /* Unref all cell styles. */
	    for(i = 0; i < EDV_BROWSER_TOTAL_CELL_STYLES; i++)
	    {
		style = &browser->cell_style[i];
		DO_UNREF_STYLE
	    }

            if(browser->accelgrp != NULL)
            {
                gtk_accel_group_unref(browser->accelgrp);
                browser->accelgrp = NULL;
            }

#undef DO_UNREF_STYLE
#undef DO_DESTROY_WIDGET
	}


	/* Deallocate other memory on browser structure. */

	/* Operation id structures. */
	EDVBrowserOPIDListDelete(
	    browser->opid, browser->total_opids
	);



	/* Deallocate structure itself. */
	g_free(browser);
}
