#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
/* #include <gdk/gdkprivate.h> */

#include "../include/string.h"
#include "../include/disk.h"
#include "../include/prochandle.h"

#include "guiutils.h"
#include "cdialog.h"

#include "edvtypes.h"
#include "edvcfg.h"
#include "edvdevices.h"
#include "deviceswin.h"
#include "endeavour.h"
#include "edvmount.h"
#include "edvcb.h"
#include "edvop.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "edvcfglist.h"
#include "config.h"

#include "images/icon_add_20x20.xpm"
#include "images/icon_edit_20x20.xpm"
#include "images/icon_remove_20x20.xpm"
#include "images/icon_close_20x20.xpm"
#include "images/icon_mount_20x20.xpm"
#include "images/icon_unmount_20x20.xpm"
#include "images/icon_eject_20x20.xpm"
#include "images/icon_properties2_20x20.xpm"
#include "images/icon_fsck_20x20.xpm"
#include "images/icon_tools_20x20.xpm"
#include "images/icon_floppy_20x20.xpm"

#include "images/icon_device_misc_48x48.xpm"



static gint EDVDevicesListWinDeleteEventCB(
        GtkWidget *widget, GdkEvent *event, gpointer data
);
static gint EDVDevicesListWinKeyEventCB(
        GtkWidget *widget, GdkEventKey *key, gpointer data
);
static gint EDVDevicesListWinButtonPressEventCB(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);
static void EDVDevicesListWinSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
);
static void EDVDevicesListWinUnselectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
);
static void EDVDevicesListWinMountCB(GtkWidget *widget, gpointer data);
static void EDVDevicesListWinEjectCB(GtkWidget *widget, gpointer data);
static void EDVDevicesListWinPropertiesCB(GtkWidget *widget, gpointer data);
static void EDVDevicesListWinFSCKCB(GtkWidget *widget, gpointer data);
static void EDVDevicesListWinToolsCB(GtkWidget *widget, gpointer data);
static void EDVDevicesListWinFormatCB(GtkWidget *widget, gpointer data);

static void EDVDevicesListWinFindCB(GtkWidget *widget, gpointer data);

static void EDVDevicesListWinAddCB(GtkWidget *widget, gpointer data);
static void EDVDevicesListWinEditCB(GtkWidget *widget, gpointer data);
static void EDVDevicesListWinRemoveCB(GtkWidget *widget, gpointer data);
static void EDVDevicesListWinUpCB(GtkWidget *widget, gpointer data);
static void EDVDevicesListWinDownCB(GtkWidget *widget, gpointer data);
static void EDVDevicesListWinCloseCB(GtkWidget *widget, gpointer data);

static void EDVDevicesListWinUpdateDisplay(
	edv_device_listwin_struct *lw, edv_device_struct *dev_ptr
);
void EDVDevicesListWinSetRow(
        edv_device_listwin_struct *lw, gint row, edv_device_struct *dev_ptr
);
void EDVDevicesListWinFetchValues(edv_device_listwin_struct *lw);

void EDVDevicesListWinMountNotifyCB(
	edv_device_listwin_struct *lw,
        gint dev_num, edv_device_struct *dev_ptr,
        gbool is_mounted
);
void EDVDevicesListWinDeviceAddedCB(
        edv_device_listwin_struct *lw,
        gint dev_num, edv_device_struct *dev_ptr
);
void EDVDevicesListWinDeviceModifiedCB(
        edv_device_listwin_struct *lw,
	gint dev_num, edv_device_struct *dev_ptr
);
void EDVDevicesListWinDeviceRemovedCB(
        edv_device_listwin_struct *lw, gint dev_num
);

edv_device_listwin_struct *EDVDevicesListWinNew(
        gpointer core_ptr
);
void EDVDevicesListWinUpdateMenus(
        edv_device_listwin_struct *lw
);
void EDVDevicesListSetBusy(
        edv_device_listwin_struct *lw, gbool is_busy
);
void EDVDevicesListWinMap(
        edv_device_listwin_struct *lw
);
void EDVDevicesListWinUnmap(
        edv_device_listwin_struct *lw
);
void EDVDevicesListWinDelete(
        edv_device_listwin_struct *lw
);


#define LISTWIN_WIDTH	550
#define LISTWIN_HEIGHT	450

#define LISTWIN_BTN_WIDTH	(100 + (2 * 3))
#define LISTWIN_BTN_HEIGHT	(30 + (2 * 3))

#define LISTWIN_ARROW_WIDTH	20
#define LISTWIN_ARROW_HEIGHT	20

#ifdef PROG_LANGUAGE_ENGLISH
# define LISTWIN_TITLE	"Devices"
#endif
#ifdef PROG_LANGUAGE_SPANISH
# define LISTWIN_TITLE	"Artefactos"
#endif
#ifdef PROG_LANGUAGE_FRENCH
# define LISTWIN_TITLE	"D'appareils"
#endif


/*
 *	Devices list window "delete_event" signal callback.
 */
static gint EDVDevicesListWinDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
	if(lw == NULL)
	    return(TRUE);

	EDVDevicesListWinCloseCB(NULL, lw);

	return(TRUE);
}

/*
 *      Device list window "key_press_event" signal callback.
 */
static gint EDVDevicesListWinKeyEventCB(
        GtkWidget *widget, GdkEventKey *key, gpointer data
)
{
        static gbool reenterent = FALSE;
        gint status = FALSE;
        gint etype;
        guint keyval, state;
        gbool press;
        edv_core_struct *core_ptr;
        GtkCList *clist;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return(status);

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return(status);

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return(status);

        if(reenterent)
            return(status);
        else
            reenterent = TRUE;

        /* Get event type. */
        etype = key->type;

        /* Get other key event values. */
        press = (etype == GDK_KEY_PRESS) ? TRUE : FALSE;
        keyval = key->keyval;
        state = key->state;

/* Macro to emit a signal stop for a key press or release depending
 * on the current event's type.
 */
#define DO_STOP_KEY_SIGNAL_EMIT \
{ \
 gtk_signal_emit_stop_by_name( \
  GTK_OBJECT(widget), \
  press ? "key_press_event" : "key_release_event" \
 ); \
}

/* Macro to clamp the GtkAdjustment adj and emit a "value_changed"
 * signal.
 */
#define DO_ADJ_CLAMP_EMIT       \
{ \
 if(adj->value > (adj->upper - adj->page_size)) \
  adj->value = adj->upper - adj->page_size; \
\
 if(adj->value < adj->lower) \
  adj->value = adj->lower; \
\
 gtk_signal_emit_by_name( \
  GTK_OBJECT(adj), "value_changed" \
 ); \
}

/* Macro to clamp the GtkCList clist's focus_row. */
#define DO_CLIST_FOCUS_ROW_CLAMP	\
{ \
 if(clist->focus_row >= clist->rows) \
  clist->focus_row = clist->rows - 1; \
 if(clist->focus_row < 0) \
  clist->focus_row = 0; \
}

        if(1)
        {
            gint row;
            GList *glist;
            GtkCList *clist = GTK_CLIST(widget);

            /* Get last selected row. */
            row = EDVCListGetSelectedLast(clist, NULL);

            /* Handle by key value. */
            switch(keyval)
            {
              case GDK_Return:
              case GDK_KP_Enter:
              case GDK_ISO_Enter:
              case GDK_3270_Enter:
                if(press)
                {
		    EDVDevicesListWinEditCB(NULL, lw);
		}
		DO_STOP_KEY_SIGNAL_EMIT
		status = TRUE;
                break;

              case GDK_Delete:
                if(press)
                {
                    EDVDevicesListWinRemoveCB(NULL, lw);
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_space:
              case GDK_KP_Space:
                row = clist->focus_row;
                if((row >= 0) && (row < clist->rows) && press)
                {
                    gbool already_selected = FALSE;

                    /* Check if this row is already selected. */
                    glist = clist->selection;
                    while(glist != NULL)
                    {
                        if(row == (gint)glist->data)
                        {
                            already_selected = TRUE;
                            break;
                        }
                        glist = glist->next;
                    }

                    gtk_clist_freeze(clist);
                    if(already_selected)
                        gtk_clist_unselect_row(clist, row, 0);
                    else
                        gtk_clist_select_row(clist, row, 0);
                    gtk_clist_thaw(clist);
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Up:
              case GDK_KP_Up:
                if(state & GDK_CONTROL_MASK)
                {
                    /* Get adjustment and scroll up. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value -= adj->step_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                    DO_STOP_KEY_SIGNAL_EMIT
                    status = TRUE;
                }
		else
                {
                    if(press)
                    {
                        gtk_clist_freeze(clist);
                        clist->focus_row--;
                        DO_CLIST_FOCUS_ROW_CLAMP

                        if(gtk_clist_row_is_visible(
                            clist, clist->focus_row) != GTK_VISIBILITY_FULL
                        )
                            gtk_clist_moveto(
                                clist,
                                clist->focus_row, -1,   /* Row, column. */
                                0.5, 0.0                /* Row, column. */
                            );

                        if(state & GDK_SHIFT_MASK)
                            gtk_clist_select_row(
                                clist, clist->focus_row, 0
                            );
                        gtk_clist_thaw(clist);
                    }
                    DO_STOP_KEY_SIGNAL_EMIT
                    status = TRUE;
                }
                break;

              case GDK_Down:
              case GDK_KP_Down:
                if(state & GDK_CONTROL_MASK)
                {
                    /* Get adjustment and scroll down. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value += adj->step_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                    DO_STOP_KEY_SIGNAL_EMIT
                    status = TRUE;
                }
                else
                {
                    if(press)
                    {
                        gtk_clist_freeze(clist);
                        clist->focus_row++;
                        DO_CLIST_FOCUS_ROW_CLAMP

                        if(gtk_clist_row_is_visible(
                            clist, clist->focus_row) != GTK_VISIBILITY_FULL
                        )
                            gtk_clist_moveto(
                                clist,
                                clist->focus_row, -1,   /* Row, column. */
                                0.5, 0.0                /* Row, column. */
                            );

                        if(state & GDK_SHIFT_MASK)
                            gtk_clist_select_row(
                                clist, clist->focus_row, 0
                            );
                        gtk_clist_thaw(clist);
                    }
                    DO_STOP_KEY_SIGNAL_EMIT
                    status = TRUE;
                }
                break;

              case GDK_Left:
              case GDK_KP_Left:
                if(1)
                {
                    /* Get adjustment and scroll left. */
                    GtkAdjustment *adj = clist->hadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        if(state & GDK_CONTROL_MASK)
                            adj->value -= adj->step_increment * 4;
                        else if(state & GDK_SHIFT_MASK)
                            adj->value = adj->lower;
                        else
                            adj->value -= adj->step_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Right:
              case GDK_KP_Right:
                if(1)
                {
                    /* Get adjustment and scroll right. */
                    GtkAdjustment *adj = clist->hadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        if(state & GDK_CONTROL_MASK)
                            adj->value += adj->step_increment * 4;
                        else if(state & GDK_SHIFT_MASK)
                            adj->value = adj->upper - adj->page_size;
                        else
                            adj->value += adj->step_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Page_Up:
              case GDK_KP_Page_Up:
                if(1)
                {
                    /* Get adjustment and scroll up one page. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value -= adj->page_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Page_Down:
              case GDK_KP_Page_Down:
                if(1)
                {
                    /* Get adjustment and scroll down one page. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value += adj->page_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Home:
              case GDK_KP_Home:
                if(1)
                {
                    /* Get adjustment and scroll all the way up. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value = adj->lower;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_End:
              case GDK_KP_End:
                if(1)
                {
                    /* Get adjustment and scroll all the way down. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value = adj->upper - adj->page_size;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

            }
        }

#undef DO_CLIST_FOCUS_ROW_CLAMP
#undef DO_ADJ_CLAMP_EMIT
#undef DO_STOP_KEY_SIGNAL_EMIT

        reenterent = FALSE;
        return(status);
}

/*
 *	Device list window "button_press_event" signal callback.
 */
static gint EDVDevicesListWinButtonPressEventCB(
        GtkWidget *widget, GdkEventButton *button, gpointer data
)
{
        static gbool reenterent = FALSE;
        gint etype;
	edv_core_struct *core_ptr;
        GtkCList *clist;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return(TRUE);

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return(TRUE);

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return(TRUE);

        if(reenterent)
            return(TRUE);
        else
            reenterent = TRUE;

	if(clist->clist_window != ((GdkEventAny *)button)->window)
	{
	    reenterent = FALSE;
	    return(TRUE);
	}

        /* Get event type. */
        etype = button->type;

        if(1)
        {
            gint row, column;
            GtkWidget *w;


            /* Find row and column based on given coordinates. */
            if(!gtk_clist_get_selection_info(
                clist, button->x, button->y, &row, &column
            ))
            {
                row = -1;
                column = 0;
            }

            /* Handle by event type. */
            switch(etype)
            {
	      case GDK_2BUTTON_PRESS:
		/* Handle by button number. */
                switch(button->button)
                {
                  case 1:
		    EDVDevicesListWinEditCB(NULL, lw);
		    break;
		}
		break;

              case GDK_BUTTON_PRESS:
                /* Handle by button number. */
                switch(button->button)
                {
                  case 3:
                    /* Select row before mapping menu? */
                    if(EDVCFGItemListGetValueI(
                        core_ptr->cfg_list, EDV_CFG_PARM_RIGHT_CLICK_MENU_SELECTS
                    ) && (row >= 0) && (row < clist->rows))
                    {
                        gtk_clist_freeze(clist);
			gtk_clist_select_row(clist, row, column);
                        gtk_clist_thaw(clist);
		    }

                    /* Get right click menu widget and map it. */
                    w = lw->menu;
                    if(w != NULL)
                        gtk_menu_popup(
                            GTK_MENU(w), NULL, NULL,
                            NULL, NULL,
                            button->button, button->time
                        );
                    break;
                }
                break;
            }
        }


        reenterent = FALSE;

	return(TRUE);
}

/*
 *	Devices list window "select_row" signal callback.
 */
static void EDVDevicesListWinSelectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
)
{
        static gbool reenterent = FALSE;
	edv_core_struct *core_ptr;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

	core_ptr = (edv_core_struct *)lw->core_ptr;
	if(core_ptr == NULL)
	    return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

	/* Check which clist this event is for. */
	if(GTK_WIDGET(clist) == lw->devices_clist)
	{
	    /* Check if selected row is fully visible, if not then
	     * adjust scroll position to try and make it visible.
	     */
	    if(gtk_clist_row_is_visible(clist, row) !=
		GTK_VISIBILITY_FULL
	    )
		gtk_clist_moveto(
		    clist,
		    row, -1,	/* Row, column. */
		    0.5, 0.0	/* Row, column. */
		);

	    /* Update displayed device structure. */
            if((row >= 0) && (row < core_ptr->total_devices))
                EDVDevicesListWinUpdateDisplay(
                    lw,  core_ptr->device[row]
                );

	    EDVDevicesListWinUpdateMenus(lw);
	}

        reenterent = FALSE;
}

/*
 *	Device list window "unselect_row" signal callback.
 */
static void EDVDevicesListWinUnselectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
)
{
        static gbool reenterent = FALSE;
        edv_core_struct *core_ptr;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Check which clist this event is for. */
        if(GTK_WIDGET(clist) == lw->devices_clist)
        {
	    EDVDevicesListWinUpdateDisplay(lw, NULL);
            EDVDevicesListWinUpdateMenus(lw);
        }

        reenterent = FALSE;
}

/*
 *	Device mount/unmunt button callback.
 */
static void EDVDevicesListWinMountCB(GtkWidget *widget, gpointer data)
{
        static gbool reenterent = FALSE;
	gbool original_mount_state;
        gint status, row, dev_num;
        GtkCList *clist;
        edv_device_struct *dev_ptr;
        edv_core_struct *core_ptr;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = EDV_CORE(lw->core_ptr);
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Get selected row and device number index as the row index. */
        dev_num = row = EDVCListGetSelectedLast(clist, NULL);
        if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
            dev_ptr = core_ptr->device[dev_num];
        else
            dev_ptr = NULL;
        if(dev_ptr == NULL)
        {
            reenterent = FALSE;
            return;
        }

	original_mount_state = dev_ptr->is_mounted;

	EDVDevicesListSetBusy(lw, TRUE);

        /* Unmount or mount? */
        if(dev_ptr->is_mounted)
            status = EDVMountDoUnmount(dev_ptr);
        else
            status = EDVMountDoMount(dev_ptr);

        /* Update all device mount states and stats. */
        EDVDevicesListUpdateMountStates(
            core_ptr->device, core_ptr->total_devices
        );
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );

        EDVDevicesListSetBusy(lw, FALSE);

        /* Mount error? */
        if(status)
        {
            const gchar *last_error = EDVMountGetError();
            if(last_error != NULL)
            {
                CDialogSetTransientFor(lw->toplevel);
                CDialogGetResponse(
                    original_mount_state ?
                        "Unmount Failed" : "Mount Failed",
                    last_error,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }
        }
        else
        {
            /* Report mount signal to all of endeavour's resources. */
            EDVObjectMountEmit(core_ptr, dev_num, dev_ptr, dev_ptr->is_mounted);
/* Warning, some widgets on this devices list may be invalid at this
 * point if fetched earlier in this function.
 */
        }

        reenterent = FALSE;
}

/*
 *	Device eject button callback.
 */
static void EDVDevicesListWinEjectCB(GtkWidget *widget, gpointer data)
{
        static gbool reenterent = FALSE;
	gbool original_mount_state;
        gint status, row, dev_num;
        GtkCList *clist;
        edv_device_struct *dev_ptr;
        edv_core_struct *core_ptr;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = EDV_CORE(lw->core_ptr);
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Get selected row and device number index as the row index. */
        dev_num = row = EDVCListGetSelectedLast(clist, NULL);
        if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
            dev_ptr = core_ptr->device[dev_num];
        else
            dev_ptr = NULL;
        if(dev_ptr == NULL)
        {
            reenterent = FALSE;
            return;
        }

        original_mount_state = dev_ptr->is_mounted;

        EDVDevicesListSetBusy(lw, TRUE);

        /* Need to unmount first? */
        if(dev_ptr->is_mounted)
            status = EDVMountDoUnmount(dev_ptr);
        /* So now eject. */
        status = EDVMountDoEject(dev_ptr);

        /* Update all device mount states and stats. */
        EDVDevicesListUpdateMountStates(
            core_ptr->device, core_ptr->total_devices
        );
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );

        EDVDevicesListSetBusy(lw, FALSE);

        /* Mount error? */
        if(status)
        {
            const gchar *last_error = EDVMountGetError();
            if(last_error != NULL)
            {
                CDialogSetTransientFor(lw->toplevel);
                CDialogGetResponse(
                    "Eject Failed",
                    last_error,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }
        }
        else
        {
            /* Report eject (unmount) signal to all of endeavour's
             * resources.
             */
            EDVObjectMountEmit(core_ptr, dev_num, dev_ptr, dev_ptr->is_mounted);
        }

        reenterent = FALSE;
}

/*
 *	Device mount path disk object properties button callback.
 */
static void EDVDevicesListWinPropertiesCB(GtkWidget *widget, gpointer data)
{
        static gbool reenterent = FALSE;
	gint row, dev_num;
	const gchar *mount_path;
	GtkCList *clist;
	edv_device_struct *dev_ptr;
        edv_core_struct *core_ptr;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

	core_ptr = (edv_core_struct *)lw->core_ptr;
	if(core_ptr == NULL)
	    return;

	clist = (GtkCList *)lw->devices_clist;
	if(clist == NULL)
	    return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Get selected row and device number index as the row index. */
	dev_num = row = EDVCListGetSelectedLast(clist, NULL);
	if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
	    dev_ptr = core_ptr->device[dev_num];
	else
	    dev_ptr = NULL;
	if(dev_ptr == NULL)
	{
	    reenterent = FALSE;
	    return;
	}

	/* Get mount path. */
	mount_path = dev_ptr->mount_path;
	if(mount_path != NULL)
	{
	    struct stat lstat_buf;


	    /* Check if mount path exists locally. */
	    if(!lstat(mount_path, &lstat_buf))
	    {
		edv_object_struct *obj = EDVObjectNew();
		if(obj != NULL)
		{
		    EDVObjectSetPath(obj, mount_path);
		    EDVObjectSetStat(obj, &lstat_buf);
		    EDVObjectValidateLink(obj);

		    /* Create a new properties window on the core
		     * structure and instruct it to load the destination
		     * disk object.
		     */
		    EDVDoPropWinAndSwitchPage(
			core_ptr, obj, lw->toplevel, "Device"
		    );
		}
		EDVObjectDelete(obj);
		obj = NULL;
	    }
	}

	reenterent = FALSE;
}

/*
 *      Device fsck button callback.
 */
static void EDVDevicesListWinFSCKCB(GtkWidget *widget, gpointer data)
{
        static gbool reenterent = FALSE;
	const gchar *cmd;
        gint row, dev_num;
        GtkCList *clist;
        edv_device_struct *dev_ptr;
        edv_core_struct *core_ptr;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = EDV_CORE(lw->core_ptr);
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Get selected row and device number index as the row index. */
        dev_num = row = EDVCListGetSelectedLast(clist, NULL);
        if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
            dev_ptr = core_ptr->device[dev_num];
        else
            dev_ptr = NULL;
        if(dev_ptr == NULL)
        {
            reenterent = FALSE;
            return;
        }

        /* Get fsck command. */
	cmd = dev_ptr->command_check;
	if((cmd != NULL) ? (*cmd != '\0') : FALSE)
	{
	    Exec(cmd);
	}

        reenterent = FALSE;
}

/*
 *      Device tools button callback.
 */
static void EDVDevicesListWinToolsCB(GtkWidget *widget, gpointer data)
{
        static gbool reenterent = FALSE;
        const gchar *cmd;
        gint row, dev_num;
        GtkCList *clist;
        edv_device_struct *dev_ptr;
        edv_core_struct *core_ptr;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = EDV_CORE(lw->core_ptr);
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Get selected row and device number index as the row index. */
        dev_num = row = EDVCListGetSelectedLast(clist, NULL);
        if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
            dev_ptr = core_ptr->device[dev_num];
        else
            dev_ptr = NULL;
        if(dev_ptr == NULL)
        {
            reenterent = FALSE;
            return;
        }

        /* Get tools command. */
        cmd = dev_ptr->command_tools;
        if((cmd != NULL) ? (*cmd != '\0') : FALSE)
        {
            Exec(cmd);
        }

        reenterent = FALSE;
}

/*
 *      Device format button callback.
 */
static void EDVDevicesListWinFormatCB(GtkWidget *widget, gpointer data)
{
        static gbool reenterent = FALSE;
        const gchar *cmd;
        gint row, dev_num;
        GtkCList *clist;
        edv_device_struct *dev_ptr;
        edv_core_struct *core_ptr;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = EDV_CORE(lw->core_ptr);
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Get selected row and device number index as the row index. */
        dev_num = row = EDVCListGetSelectedLast(clist, NULL);
        if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
            dev_ptr = core_ptr->device[dev_num];
        else
            dev_ptr = NULL;
        if(dev_ptr == NULL)
        {
            reenterent = FALSE;
            return;
        }

        /* Get format command. */
        cmd = dev_ptr->command_format;
        if((cmd != NULL) ? (*cmd != '\0') : FALSE)
        {
            Exec(cmd);
        }

        reenterent = FALSE;
}

/*
 *	Devices find by device path entry "activate" signal callback.
 */
static void EDVDevicesListWinFindCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
	gint find_itterations = 0;
	gint row, column, sel_row;
	const gchar *find_str;
	GtkEntry *entry;
        GtkCList *clist;

        gchar *cell_text;
        guint8 spacing;
        GdkPixmap *pixmap;
        GdkBitmap *mask;

        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

	entry = (GtkEntry *)lw->find_entry;
	if(entry == NULL)
	    return;

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;


	/* Get string to match for from entry. */
        find_str = gtk_entry_get_text(entry);
        if(find_str == NULL)
	{
	    reenterent = FALSE;
            return;
	}
	if(*find_str == '\0')
	{
            reenterent = FALSE;
            return;
        }

	/* Get selected row + 1 or 0 if none. */
	sel_row = EDVCListGetSelectedLast(clist, NULL);
	if(sel_row < 0)
	    sel_row = 0;
	else
	    sel_row++;

	/* Iterate through rows, checking each Type column to see if
	 * therer is any partial patches.
	 */
	do
	{
	    /* Iterate from selected row to end. */
	    for(row = sel_row; row < clist->rows; row++)
	    {
		/* Iterate through all cells on this row. */
		for(column = 0; column < clist->columns; column++)
		{
		    cell_text = NULL;
		    switch((gint)gtk_clist_get_cell_type(clist, row, column))
		    {
		      case GTK_CELL_TEXT:
			gtk_clist_get_text(clist, row, column, &cell_text);
			break;

		      case GTK_CELL_PIXTEXT:
			gtk_clist_get_pixtext(
			    clist, row, column, &cell_text,
			    &spacing, &pixmap, &mask
			);
			break;
		    }
		    /* Got cell text? */
		    if(cell_text != NULL)
		    {
			/* Find string found inside cell text string? */
			if(strcasestr(cell_text, find_str))
			    break;
		    }
		}
		/* If column itteration broke before all columns were
		 * iterated through then that implies a match was made.
		 */
		if(column < clist->columns)
		    break;
	    }
	    /* Got match? */
            if(row < clist->rows)
		break;
	    else
		find_itterations++;

	    /* Reset sel_row to 0 so that find starts at beginning. */
	    sel_row = 0;

	} while(find_itterations < 2);

	/* Got match? */
	if(row < clist->rows)
	{
	    /* Select new matched row. */
	    gtk_clist_select_row(clist, row, 0);
	}

        reenterent = FALSE;
}

/*
 *      Devices list window add button callback.
 */
static void EDVDevicesListWinAddCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
	gint row, dev_num;
	edv_device_struct *dev_ptr;
	GtkCList *clist;
	edv_core_struct *core_ptr;
	edv_device_editwin_struct *ew;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

	EDVDevicesListSetBusy(lw, TRUE);

        /* Get last selected row. */
        row = EDVCListGetSelectedLast(clist, NULL);

        /* Get device number index as the selected row's index. */
	dev_num = row;

	/* Create a new device at the selected position specified by
	 * dev_num relative to the core structure.
	 */
	if((dev_num < 0) || (dev_num >= core_ptr->total_devices))
	{
	    /* Append. */
	    gint n;

	    /* Sanitize total. */
	    if(core_ptr->total_devices < 0)
		core_ptr->total_devices = 0;

	    /* Allocate more pointers. */
	    n = core_ptr->total_devices;
	    core_ptr->total_devices = n + 1;
	    core_ptr->device = (edv_device_struct **)g_realloc(
		core_ptr->device,
		core_ptr->total_devices * sizeof(edv_device_struct *)
	    );
	    if(core_ptr->device == NULL)
	    {
		core_ptr->total_devices = 0;
		EDVDevicesListSetBusy(lw, FALSE);
		reenterent = FALSE;
		return;
	    }

	    /* Create new device structure. */
            dev_num = n;
	    core_ptr->device[dev_num] = dev_ptr = EDVDeviceNew(
		EDV_FS_TYPE_EMPTY,
		"New Device",
		"/dev/null",
		"/mnt"
	    );
	    if(dev_ptr == NULL)
	    {
		EDVDevicesListSetBusy(lw, FALSE);
                reenterent = FALSE;
                return;
	    }
	}
	else
	{
	    /* Insert. */
            gint i, n;

            /* Sanitize total. */
            if(core_ptr->total_devices < 0)
                core_ptr->total_devices = 0;

            /* Allocate more pointers. */
            n = core_ptr->total_devices;
            core_ptr->total_devices = n + 1;
            core_ptr->device = (edv_device_struct **)g_realloc(
                core_ptr->device,
                core_ptr->total_devices * sizeof(edv_device_struct *)
            );
            if(core_ptr->device == NULL)
            {
                core_ptr->total_devices = 0;
		EDVDevicesListSetBusy(lw, FALSE);
                reenterent = FALSE;
                return;
            }

	    /* Shift pointers. */
	    for(i = n; i > dev_num; i--)
		core_ptr->device[i] = core_ptr->device[i - 1];

            /* Create new device structure. */
            core_ptr->device[dev_num] = dev_ptr = EDVDeviceNew(
                EDV_FS_TYPE_EMPTY,
		"New Device",
                "/dev/null",
                "/mnt"
            );
            if(dev_ptr == NULL)
            {
                EDVDevicesListSetBusy(lw, FALSE);
                reenterent = FALSE;
                return;
            }
	}

        /* Update all device mount states and stats. */
        EDVDevicesListUpdateMountStates(
            core_ptr->device, core_ptr->total_devices
        );
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );


        /* Send device added signal to all of endeavour's resources. */
        EDVDeviceAddedEmit(core_ptr, dev_num, dev_ptr);

	EDVDevicesListSetBusy(lw, FALSE);

	/* Map devices edit window, creating it as needed. */
	ew = lw->editwin;
	if(ew == NULL)
	    lw->editwin = ew = EDVDevicesEditWinNew(
		core_ptr, lw
	    );
	if(ew != NULL)
	{
	    EDVCenterWindowToWindow(lw->toplevel, ew->toplevel);
	    EDVDevicesEditWinMap(ew);
	    EDVDevicesEditWinFetchValues(ew, dev_num);
	}

        reenterent = FALSE;
}

/*
 *      Devices list window edit button callback.
 */
static void EDVDevicesListWinEditCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
        gint row, dev_num;
	edv_device_struct *dev_ptr;
        GtkCList *clist;
        edv_core_struct *core_ptr;
        edv_device_editwin_struct *ew;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Get last selected row. */
        row = EDVCListGetSelectedLast(clist, NULL);

        /* Get device number index as the selected row's index. */
        dev_num = row;

        if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
            dev_ptr = core_ptr->device[dev_num];
        else
            dev_ptr = NULL;
        if(dev_ptr == NULL)
        {
            reenterent = FALSE;
            return;
        }

	/* Check if this device is internally created by this program
	 * which means it cannot be edited.
	 */
        if(dev_ptr->internal)
        {
            CDialogSetTransientFor(lw->toplevel);
            CDialogGetResponse(
"Edit Failed",
"This device is internally created by this program\n\
and cannot be edited.",
                NULL,
                CDIALOG_ICON_WARNING,
                CDIALOG_BTNFLAG_OK,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);

            reenterent = FALSE;
            return;
        }


        /* Map device edit window, creating it as needed. */
        ew = lw->editwin;
        if(ew == NULL)
            lw->editwin = ew = EDVDevicesEditWinNew(
                core_ptr, lw
            );
        if(ew != NULL)
        {
            EDVCenterWindowToWindow(lw->toplevel, ew->toplevel);
            EDVDevicesEditWinMap(ew);
            EDVDevicesEditWinFetchValues(ew, dev_num);
        }

        reenterent = FALSE;
}

/*
 *      Devices list window remove button callback.
 */
static void EDVDevicesListWinRemoveCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
	gint row, dev_num;
	edv_device_struct *dev_ptr;
        GtkCList *clist;
        edv_core_struct *core_ptr;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Get last selected row. */
        row = EDVCListGetSelectedLast(clist, NULL);

        /* Get device number index as the selected row's index. */
        dev_num = row;

	if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
	    dev_ptr = core_ptr->device[dev_num];
	else
	    dev_ptr = NULL;
	if(dev_ptr == NULL)
	{
	    reenterent = FALSE;
	    return;
	}

	/* Check if this device is internally allocated, in which case
	 * it cannot be removed.
	 */
	if(dev_ptr->internal)
	{
            CDialogSetTransientFor(lw->toplevel);
            CDialogGetResponse(
"Remove Failed",
"This device is internally created by this program\n\
and cannot be removed.",
                NULL,
                CDIALOG_ICON_WARNING,
                CDIALOG_BTNFLAG_OK,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);

            reenterent = FALSE;
            return;
	}


	/* Confirm removal of device. */
	if(1)
	{
	    gint status;
	    gchar *buf = g_strdup_printf(
"Are you sure you want to remove device\n\
\"%s\"?",
		dev_ptr->device_path
	    );

            CDialogSetTransientFor(lw->toplevel);
            status = CDialogGetResponse(
		"Confirm Remove",
		buf,
		NULL,
                CDIALOG_ICON_WARNING,
                CDIALOG_BTNFLAG_YES | CDIALOG_BTNFLAG_NO,
                CDIALOG_BTNFLAG_NO
            );
            CDialogSetTransientFor(NULL);

	    g_free(buf);

	    switch(status)
	    {
	      case CDIALOG_RESPONSE_YES_TO_ALL:
	      case CDIALOG_RESPONSE_YES:
	      case CDIALOG_RESPONSE_OK:
		break;

	      default:
		reenterent = FALSE;
		return;
		break;
	    }
	}


	/* Begin deleting device from core structure's list of devices. */

        EDVDevicesListSetBusy(lw, TRUE);

	/* Delete device structure. */
	EDVDeviceDelete(core_ptr->device[dev_num]);
	core_ptr->device[dev_num] = dev_ptr = NULL;

	/* Reduce total. */
	core_ptr->total_devices--;
	if(core_ptr->total_devices < 0)
	    core_ptr->total_devices = 0;

	/* Shift pointers and reallocate if there are still other devices
	 * in the list or else deallocate the list.
	 */
	if(core_ptr->total_devices > 0)
	{
	    gint i;

	    /* Shift pointers. */
	    for(i = dev_num; i < core_ptr->total_devices; i++)
		core_ptr->device[i] = core_ptr->device[i + 1];

	    /* Reduce pointer array allocation. */
	    core_ptr->device = (edv_device_struct **)g_realloc(
		core_ptr->device,
		core_ptr->total_devices * sizeof(edv_device_struct *)
	    );
	    if(core_ptr->device == NULL)
	    {
		core_ptr->total_devices = 0;
	    }
	}
	else
	{
	    g_free(core_ptr->device);
	    core_ptr->device = NULL;
	}

        /* Send device removed signal to all of endeavour's resources. */
        EDVDeviceRemovedEmit(core_ptr, dev_num);

	EDVDevicesListSetBusy(lw, FALSE);

        reenterent = FALSE;
}

/*
 *      Devices list window move up button callback.
 */
static void EDVDevicesListWinUpCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
	gint row;
	GtkCList *clist;
	edv_core_struct *core_ptr;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

	clist = (GtkCList *)lw->devices_clist;
	if(clist == NULL)
	    return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        EDVDevicesListSetBusy(lw, TRUE);

        /* Get last selected row. */
        row = EDVCListGetSelectedLast(clist, NULL);

        /* Can shift selected row up? */
        if((row > 0) && (row < core_ptr->total_devices) &&
	   (core_ptr->total_devices == clist->rows)
	)
        {
	    edv_device_struct *tmp_dev_ptr;

	    /* Shift clist rows. */
            gtk_clist_freeze(clist);
            gtk_clist_swap_rows(clist, row, row - 1);
            gtk_clist_thaw(clist);

	    /* Shift device structure pointers on the core structure's
	     * devices list.
	     */
	    tmp_dev_ptr = core_ptr->device[row - 1];
	    core_ptr->device[row - 1] = core_ptr->device[row];
	    core_ptr->device[row] = tmp_dev_ptr;

	    /* Emit device modified signal for both devices involved in
	     * shift.
	     */
	    EDVDeviceModifiedEmit(
		core_ptr,
		row - 1,
		core_ptr->device[row - 1]
	    );
            EDVDeviceModifiedEmit(
                core_ptr,
                row,
                core_ptr->device[row]
            );

            EDVDevicesListWinUpdateMenus(lw);
	}

        EDVDevicesListSetBusy(lw, FALSE);

        reenterent = FALSE;
}

/*
 *      Devices list window move down button callback.
 */
static void EDVDevicesListWinDownCB(
        GtkWidget *widget, gpointer data
)
{
	static gbool reenterent = FALSE;
	gint row;
        GtkCList *clist;
        edv_core_struct *core_ptr;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return;

	if(reenterent)
	    return;
	else
	    reenterent = TRUE;

        EDVDevicesListSetBusy(lw, TRUE);

	/* Get last selected row. */
        row = EDVCListGetSelectedLast(clist, NULL);

	/* Can shift selected row down? */
	if((row > -1) && (row < (clist->rows - 1)) &&
           (core_ptr->total_devices == clist->rows)
	)
	{
            edv_device_struct *tmp_dev_ptr;

            /* Shift clist rows. */
            gtk_clist_freeze(clist);
            gtk_clist_swap_rows(clist, row, row + 1);
            gtk_clist_thaw(clist);

            /* Shift device structure pointers on the core structure's
             * devices list.
             */
            tmp_dev_ptr = core_ptr->device[row + 1];
            core_ptr->device[row + 1] = core_ptr->device[row];
            core_ptr->device[row] = tmp_dev_ptr;

            /* Emit device modified signal for both devices involved in
             * shift.
             */
            EDVDeviceModifiedEmit(
                core_ptr,
                row + 1,
                core_ptr->device[row + 1]
            );
            EDVDeviceModifiedEmit(
                core_ptr,
                row,
                core_ptr->device[row]
            );

            EDVDevicesListWinUpdateMenus(lw);
	}

        EDVDevicesListSetBusy(lw, FALSE);

	reenterent = FALSE;
}

/*
 *	Device list window close button callback.
 */
static void EDVDevicesListWinCloseCB(
	GtkWidget *widget, gpointer data
)
{
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)data;
        if(lw == NULL)
            return;

	EDVDevicesListWinUnmap(lw);
}



/*
 *	Updates the displayed device on the given list window.
 *
 *	This will destroy the display_client widget and create a
 *	new one if dev_ptr is not NULL.
 */
static void EDVDevicesListWinUpdateDisplay(
        edv_device_listwin_struct *lw, edv_device_struct *dev_ptr
)
{
	gint border_major = 5, border_minor = 2;
	GtkWidget *w, *parent, *parent2, *parent3, *parent4;
	edv_core_struct *core_ptr;


	if(lw == NULL)
	    return;

	core_ptr = (edv_core_struct *)lw->core_ptr;
	if(core_ptr == NULL)
	    return;


	/* Begin destroying any existing widgets on the display_client and
	 * and the display_client widget itself.
	 */
	if(1)
	{
	    GtkWidget **w;	/* Overloaded. */

#define DO_DESTROY_WIDGET       \
{ \
 if((*w) != NULL) \
 { \
  GtkWidget *tmp_w = *w; \
  (*w) = NULL; \
  gtk_widget_destroy(tmp_w); \
 } \
}

            w = &lw->dev_icon_pm;
            DO_DESTROY_WIDGET
            w = &lw->dev_name_label;
            DO_DESTROY_WIDGET
            w = &lw->dev_device_path_label;
            DO_DESTROY_WIDGET
            w = &lw->dev_mount_path_label;
            DO_DESTROY_WIDGET
            w = &lw->dev_mount_btn;
            DO_DESTROY_WIDGET
            w = &lw->dev_eject_btn;
            DO_DESTROY_WIDGET
            w = &lw->dev_properties_btn;
            DO_DESTROY_WIDGET
            w = &lw->dev_fsck_btn;
            DO_DESTROY_WIDGET
            w = &lw->dev_tools_btn;
            DO_DESTROY_WIDGET
            w = &lw->dev_format_btn;
            DO_DESTROY_WIDGET
            PieChartDelete(lw->dev_pc);
            lw->dev_pc = NULL;
            w = &lw->display_client;
            DO_DESTROY_WIDGET

#undef DO_DESTROY_WIDGET
	}

	/* Stop updating at this point if the given device structure
	 * is NULL.
	 */
	if(dev_ptr == NULL)
	    return;

        /* Realize device as needed. */
        EDVDeviceRealize(dev_ptr, FALSE);


        /* Get parent to create display client widget on. */
        parent = lw->display_parent;
        if(parent == NULL)
            return;

	/* Create new client vbox. */
	lw->display_client = w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent = w;

	/* Hbox to separate two columns. */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;


	/* Left column vbox. */
	w = gtk_vbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent3 = w;


	/* HBox for icon and name line. */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent4 = w;

	/* Create icon? */
	if(1)
	{
	    GdkPixmap *pixmap;
	    GdkBitmap *mask;

	    /* First try to get large sized pixmap, use standard state
	     * always.
	     */
	    pixmap = dev_ptr->large_pixmap[EDV_DEVICE_ICON_STATE_STANDARD];
	    mask = dev_ptr->large_mask[EDV_DEVICE_ICON_STATE_STANDARD];
	    /* No large? Then try medium. */
	    if(pixmap == NULL)
	    {
                pixmap = dev_ptr->medium_pixmap[EDV_DEVICE_ICON_STATE_STANDARD];
                mask = dev_ptr->medium_mask[EDV_DEVICE_ICON_STATE_STANDARD];
	    }
            /* No medium? Then try small. */
            if(pixmap == NULL)
            {
                pixmap = dev_ptr->small_pixmap[EDV_DEVICE_ICON_STATE_STANDARD];
                mask = dev_ptr->small_mask[EDV_DEVICE_ICON_STATE_STANDARD];
            }

	    /* Got pixmap and mask pair? */
	    if(pixmap != NULL)
	    {
		lw->dev_icon_pm = w = gtk_pixmap_new(pixmap, mask);
		gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
		gtk_widget_show(w);
	    }
	}
	/* Name label (or device path if name is empty. */
	if((dev_ptr->name != NULL) ? (*dev_ptr->name != '\0') : FALSE)
	{
	    lw->dev_name_label = w = gtk_label_new(dev_ptr->name);
	}
	else
	{
	    const gchar *dev_name = (dev_ptr->device_path != NULL) ?
		strrchr(dev_ptr->device_path, DIR_DELIMINATOR) : NULL;
	    if(dev_name != NULL)
		dev_name++;
	    else
		dev_name = dev_ptr->device_path;
	    if(dev_name == NULL)
		dev_name = "(null)";
	    lw->dev_name_label = w = gtk_label_new(dev_name);
	}
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);


        /* HBox for device path line. */
        w = gtk_hbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent4 = w;

        /* Device path label. */
        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
	    "Device Path:"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Sendero Del Artefacto:"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Sentier D'appareil:"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        /* Label. */
        lw->dev_device_path_label = w = gtk_label_new(
            (dev_ptr->device_path != NULL) ? dev_ptr->device_path : "(null)"
        );
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_widget_show(w);



        /* HBox for mount path line. */
        w = gtk_hbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent4 = w;

        /* Mount path label. */
        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Mount Path:"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Monte Sendero:"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Monter Le Sentier:"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
	/* Label. */
        lw->dev_mount_path_label = w = gtk_label_new(
            (dev_ptr->mount_path != NULL) ? dev_ptr->mount_path : "(null)"
        );
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


        /* HBox for mount, eject, and properties buttons. */
        w = gtk_hbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent4 = w;

        /* Mount/unmount button. */
        lw->dev_mount_btn = w = (GtkWidget *)GUIButtonPixmap(
	    (u_int8_t **)(dev_ptr->is_mounted ?
		icon_unmount_20x20_xpm : icon_mount_20x20_xpm
	    )
	);
        gtk_widget_set_usize(w, 20 + 2, 20 + 2);
        gtk_button_set_relief(GTK_BUTTON(w), GTK_RELIEF_NONE);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVDevicesListWinMountCB), lw
        );
	GUISetWidgetTip(
	    w,
#ifdef PROG_LANGUAGE_ENGLISH
	    "Mount/unmount device"
#endif
#ifdef PROG_LANGUAGE_SPANISH
	    "Monte/unmonte del artefacto"
#endif
#ifdef PROG_LANGUAGE_FRENCH
	    "Mont/unmont de l'appareil"
#endif
	);
	gtk_widget_set_sensitive(
	    w,
	    !dev_ptr->no_unmount
	);
        gtk_widget_show(w);

	/* Eject button. */
        lw->dev_eject_btn = w = (GtkWidget *)GUIButtonPixmap(
	    (u_int8_t **)icon_eject_20x20_xpm
	);
        gtk_widget_set_usize(w, 20 + 2, 20 + 2);
	gtk_button_set_relief(GTK_BUTTON(w), GTK_RELIEF_NONE);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVDevicesListWinEjectCB), lw
        );
	GUISetWidgetTip(
	    w,
#ifdef PROG_LANGUAGE_ENGLISH
	    "Eject media from the device"
#endif
#ifdef PROG_LANGUAGE_SPANISH
	    "Expulse medios del artefacto"
#endif
#ifdef PROG_LANGUAGE_FRENCH
	    "Ejecter le presse de l'appareil"
#endif
	);
	gtk_widget_set_sensitive(
	    w,
	    (dev_ptr->command_eject != NULL) ?
		((*dev_ptr->command_eject != '\0') ? TRUE : FALSE) :
            FALSE
	);
	gtk_widget_show(w);

	/* Properties button. */
	lw->dev_properties_btn = w = (GtkWidget *)GUIButtonPixmap(
            (u_int8_t **)icon_properties2_20x20_xpm
        );
        gtk_widget_set_usize(w, 20 + 2, 20 + 2);
        gtk_button_set_relief(GTK_BUTTON(w), GTK_RELIEF_NONE);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVDevicesListWinPropertiesCB), lw
        );
	GUISetWidgetTip(
	    w,
#ifdef PROG_LANGUAGE_ENGLISH
	    "Modify mount path properties"
#endif
#ifdef PROG_LANGUAGE_SPANISH
	    "Modifican las propiedades de monte path"
#endif
#ifdef PROG_LANGUAGE_FRENCH
	    "Modifier les proprits de mont path"
#endif
	);
	gtk_widget_set_sensitive(
	    w,
	    (dev_ptr->mount_path != NULL) ?
		((*dev_ptr->mount_path != '\0') ? TRUE : FALSE) :
            FALSE
	);
        gtk_widget_show(w);

	/* FSCK button. */
        lw->dev_fsck_btn = w = (GtkWidget *)GUIButtonPixmap(
            (u_int8_t **)icon_fsck_20x20_xpm
        );
        gtk_widget_set_usize(w, 20 + 2, 20 + 2);
        gtk_button_set_relief(GTK_BUTTON(w), GTK_RELIEF_NONE);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVDevicesListWinFSCKCB), lw
        );
        GUISetWidgetTip(
            w,
#ifdef PROG_LANGUAGE_ENGLISH
            "Check the device's file system"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Verifique el sistema del archivo de artefacto"
#endif
#ifdef PROG_LANGUAGE_FRENCH
	    "Vrifier le systme de fichier de l'appareil"
#endif
        );
        gtk_widget_set_sensitive(
            w,
            (dev_ptr->command_check != NULL) ?
                ((*dev_ptr->command_check != '\0') ? TRUE : FALSE) :
            FALSE
        );
        gtk_widget_show(w);

        /* Tools button. */
        lw->dev_tools_btn = w = (GtkWidget *)GUIButtonPixmap(
            (u_int8_t **)icon_tools_20x20_xpm
        );
        gtk_widget_set_usize(w, 20 + 2, 20 + 2);
        gtk_button_set_relief(GTK_BUTTON(w), GTK_RELIEF_NONE);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVDevicesListWinToolsCB), lw
        );
        GUISetWidgetTip(
            w,
#ifdef PROG_LANGUAGE_ENGLISH
            "Run the device's tools program"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Corra el programa de herramientas de artefacto"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Courir le programme d'outils de l'appareil"
#endif
        );
        gtk_widget_set_sensitive(
            w,
            (dev_ptr->command_tools != NULL) ?
                ((*dev_ptr->command_tools != '\0') ? TRUE : FALSE) :
            FALSE
        );
        gtk_widget_show(w);

        /* Format button. */
        lw->dev_format_btn = w = (GtkWidget *)GUIButtonPixmap(
            (u_int8_t **)icon_floppy_20x20_xpm
        );
        gtk_widget_set_usize(w, 20 + 2, 20 + 2);
        gtk_button_set_relief(GTK_BUTTON(w), GTK_RELIEF_NONE);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVDevicesListWinFormatCB), lw
        );
        GUISetWidgetTip(
            w,
#ifdef PROG_LANGUAGE_ENGLISH
            "Format the media in the device"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            ""
#endif
#ifdef PROG_LANGUAGE_FRENCH
#endif
        );
        gtk_widget_set_sensitive(
            w,
            (dev_ptr->command_format != NULL) ?
                ((*dev_ptr->command_format != '\0') ? TRUE : FALSE) :
            FALSE
        );
        gtk_widget_show(w);


        /* Right column vbox. */
        w = gtk_vbox_new(TRUE, border_major);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;

	/* Begin creating pie chart. */
	if(1)
	{
	    gulong adj_division = 10;
	    GdkColor c;
	    GtkAdjustment *adj;
	    pie_chart_struct *pc;
	    gchar text[256], text2[256];

        /* Usage pie chart. */
        adj = (GtkAdjustment *)gtk_adjustment_new(
            0.0, 0.0,
            (gfloat)(dev_ptr->blocks_total / adj_division),
            0.0, 0.0, 0.0
        );
        c.red = 0.0 * (guint16)-1;
        c.green = 0.0 * (guint16)-1;
        c.blue = 1.0 * (guint16)-1;
        sprintf(
            text, "%s: %s kb",
#ifdef PROG_LANGUAGE_ENGLISH
            "Total Capacity",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Capacidad Total",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Capacit Totale",
#endif
            EDVGetObjectSizeStr(core_ptr, dev_ptr->blocks_total)
        );
        sprintf(
            text2, "%s kb",
            EDVGetObjectSizeStr(core_ptr, dev_ptr->blocks_free)
        );
        lw->dev_pc = pc = PieChartNew(
            adj, &c, 110, 70,
            NULL, text,
#ifdef PROG_LANGUAGE_ENGLISH
            "Free:",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Libre:",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Libre:",
#endif
	    text2
        );
        gtk_object_unref(GTK_OBJECT(adj));
        w = pc->toplevel;
        gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, FALSE, 0);
        gtk_widget_show(w);

        c.red = 0.0 * (guint16)-1;
        c.green = 1.0 * (guint16)-1;
        c.blue = 1.0 * (guint16)-1;
        adj = (GtkAdjustment *)gtk_adjustment_new(
            0.0, 0.0,
            (gfloat)(
                (dev_ptr->blocks_available) / adj_division),
            0.0, 0.0, 0.0
        );
        sprintf(
            text, "%s kb",
            EDVGetObjectSizeStr(core_ptr, dev_ptr->blocks_available)
        );
        PieChartValueAdd(pc, adj, &c,
#ifdef PROG_LANGUAGE_ENGLISH
            "Free & Available:",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Libre & Disponible:",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Libre & Disponible:",
#endif
	    text
	);
        gtk_object_unref(GTK_OBJECT(adj));

        c.red = 1.0 * (guint16)-1;
        c.green = 0.0 * (guint16)-1;
        c.blue = 1.0 * (guint16)-1;
        adj = (GtkAdjustment *)gtk_adjustment_new(
            0.0, 0.0,
            (gfloat)(
(dev_ptr->blocks_total - dev_ptr->blocks_free) / adj_division),
            0.0, 0.0, 0.0
        );
        sprintf(
            text, "%s kb",
	    EDVGetObjectSizeStr(
		core_ptr,
		dev_ptr->blocks_total - dev_ptr->blocks_free
	    )
        );
        PieChartValueAdd(
	    pc, adj, &c,
#ifdef PROG_LANGUAGE_ENGLISH
            "Used:",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Usado:",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Utilis:",
#endif
	    text
	);
        gtk_object_unref(GTK_OBJECT(adj));

	}
}


/*
 *	Sets the row on the device clist on the given list window to the
 *	values specified by the given device structure.
 */
void EDVDevicesListWinSetRow(
	edv_device_listwin_struct *lw, gint row, edv_device_struct *dev_ptr
)
{
        GtkCList *clist;
        edv_core_struct *core_ptr;

	GdkPixmap *pixmap = NULL;
	GdkBitmap *mask = NULL;


	if((lw == NULL) || (dev_ptr == NULL))
	    return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return;

	/* Realize device structure so we can have use of its
	 * icon pixmap and mask pairs.
	 */
	EDVDeviceRealize(dev_ptr, FALSE);


	/* Get small icon pixmap and mask pair for this row. */
	pixmap = dev_ptr->small_pixmap[
	    EDV_DEVICE_ICON_STATE_STANDARD
	];
	mask = dev_ptr->small_mask[
	    EDV_DEVICE_ICON_STATE_STANDARD
	];


	/* Given row index in bounds? */
	if((row >= 0) && (row < clist->rows))
	{
	    /* Set column 0 as name (or device path if name is not given). */
	    if(clist->columns > 0)
	    {
		const gchar *cell_text = dev_ptr->name;
		if((cell_text == NULL) && (dev_ptr->device_path != NULL))
		{
		    cell_text = strrchr(dev_ptr->device_path, DIR_DELIMINATOR);
		    if(cell_text != NULL)
			cell_text++;
		    else
			cell_text = dev_ptr->device_path;
		}
		if(cell_text == NULL)
		    cell_text = "(null)";

		if(pixmap != NULL)
		    gtk_clist_set_pixtext(
			clist, row, 0, cell_text,
			EDV_LIST_PIXMAP_TEXT_SPACING,
			pixmap, mask
		    );
		else
		    gtk_clist_set_text(
                        clist, row, 0, cell_text
                    );
	    }
            /* Set column 1 as device path. */
            if(clist->columns > 1)
            {
		const gchar *cell_text = dev_ptr->device_path;
		if(cell_text == NULL)
		    cell_text = "(null)";

		gtk_clist_set_text(
		    clist, row, 1, cell_text
		);
            }
            /* Set column 2 as mount path. */
            if(clist->columns > 2)
            {
                const gchar *cell_text = dev_ptr->mount_path;
                if(cell_text == NULL)
                    cell_text = "(null)";

                gtk_clist_set_text(
                    clist, row, 2, cell_text
                );
            }
            /* Set column 3 as fs type. */
            if(clist->columns > 3)
            {
                gtk_clist_set_text(
                    clist, row, 3,
                    EDVDeviceGetFSStringFromNumber(dev_ptr->fs_type)
                );
            }

	}
}

/*
 *	Regets list of devices from the core structure on the given list
 *	window.
 */
void EDVDevicesListWinFetchValues(
        edv_device_listwin_struct *lw
)
{
	gint i, row;
	gchar **strv;
	GtkCList *clist;
	edv_core_struct *core_ptr;
	edv_device_struct *dev_ptr;


	if(lw == NULL)
	    return;

	core_ptr = (edv_core_struct *)lw->core_ptr;
	if(core_ptr == NULL)
	    return;

	clist = (GtkCList *)lw->devices_clist;
	if(clist == NULL)
	    return;


	/* Allocate values list for one row. */
	strv = (gchar **)g_malloc(clist->columns * sizeof(gchar *));
	if(strv != NULL)
	{
	    for(i = 0; i < clist->columns; i++)
		strv[i] = g_strdup("");
	}


	/* Begin updating devices clist. */

	gtk_clist_freeze(clist);

	/* Remove existing rows on clist. */
	gtk_clist_clear(clist);

	/* Iterate through all devices on the core structure. */
	for(i = 0; i < core_ptr->total_devices; i++)
	{
	    dev_ptr = core_ptr->device[i];
	    if(dev_ptr == NULL)
		continue;

	    /* Append a new clist row. */
	    row = gtk_clist_append(clist, strv);

	    /* Set new clist row values with the current device 
	     * structure's values.
	     */
	    EDVDevicesListWinSetRow(lw, row, dev_ptr);
	}

	gtk_clist_thaw(clist);


        /* Deallocate valies array for clist row. */
	if(strv != NULL)
	{
            for(i = 0; i < clist->columns; i++)
                g_free(strv[i]);

	    g_free(strv);
	    strv = NULL;
        }


        EDVDevicesListWinUpdateMenus(lw);
}


/*
 *      Called whenever a device has been mounted or unmounted.
 */
void EDVDevicesListWinMountNotifyCB(
        edv_device_listwin_struct *lw,
        gint dev_num, edv_device_struct *dev_ptr,
        gbool is_mounted
)
{
	/* Just forward this to the device modified callback. */
	EDVDevicesListWinDeviceModifiedCB(
	    lw, dev_num, dev_ptr
        );
}

/*
 *	Called whenever a new device has been added.
 */
void EDVDevicesListWinDeviceAddedCB(
        edv_device_listwin_struct *lw,
        gint dev_num, edv_device_struct *dev_ptr
)
{
	gint row, new_row;
	gchar **strv;
        GtkCList *clist;
        edv_core_struct *core_ptr;


        if((lw == NULL) || (dev_ptr == NULL))
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return;

	/* The row to create a new device entry on should correspond to
	 * the given device index number since the clist should be synced
	 * with the devices list.
	 */
	row = dev_num;

        /* Insert a new row on the clist to indicate this new device
         * structure.
         */
        strv = (gchar **)g_malloc(clist->columns * sizeof(gchar *));
        if(strv != NULL)
        {
            gint i;
            for(i = 0; i < clist->columns; i++)
                strv[i] = g_strdup("");
        }
	if(row >= clist->rows)
	    new_row = gtk_clist_append(clist, strv);
	else
	    new_row = gtk_clist_insert(clist, row, strv);
        if(strv != NULL)
        {
            gint i;
            for(i = 0; i < clist->columns; i++)
                g_free(strv[i]);
            g_free(strv);
            strv = NULL;
	}
        /* Failed to insert new row on clist? */
        if(new_row < 0)
            return;

        /* Update clist row text with values from the new device. */
        EDVDevicesListWinSetRow(lw, new_row, dev_ptr);

	EDVDevicesListWinUpdateMenus(lw);

        /* Select new row on clist. */
        gtk_clist_select_row(clist, new_row, 0);
}

/*
 *	Notifies the given devices list window that the given device
 *	has been modified.
 */
void EDVDevicesListWinDeviceModifiedCB(
        edv_device_listwin_struct *lw,
        gint dev_num, edv_device_struct *dev_ptr
)
{
	GtkCList *clist;
	edv_core_struct *core_ptr;


	if((lw == NULL) || (dev_ptr == NULL))
	    return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

	clist = (GtkCList *)lw->devices_clist;
	if(clist == NULL)
	    return;

	/* Check if given device index number is in bounds. */
	if((dev_num >= 0) && (dev_num < core_ptr->total_devices) &&
           (dev_num < clist->rows)
	)
	{
	    gint sel_row = EDVCListGetSelectedLast(clist, NULL);

	    /* Update this row with the values from the given device. */
	    EDVDevicesListWinSetRow(lw, dev_num, dev_ptr);

	    /* This row currently selected? */
	    if(dev_num == sel_row)
	    {
		/* Update displayed device info. */
		EDVDevicesListWinUpdateDisplay(lw, dev_ptr);
	    }
	}

	EDVDevicesListWinUpdateMenus(lw);
}

/*
 *      Notifies the given devices list window that the given device
 *      has been removed.
 */
void EDVDevicesListWinDeviceRemovedCB(
        edv_device_listwin_struct *lw, gint dev_num
)
{
        gint row;
        GtkCList *clist;
        edv_core_struct *core_ptr;


        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->devices_clist;
        if(clist == NULL)
            return;

	/* The row to remove should correspond to the device entry index
	 * since the clist should be synced with the devices list.
	 */
	row = dev_num;

        /* Delete row from clist. */
	if((row >= 0) && (row < clist->rows))
	    gtk_clist_remove(clist, row);

        EDVDevicesListWinUpdateMenus(lw);


	/* Forward this signal to the devices edit window. */
	EDVDevicesEditWinDeviceRemovedCB(lw->editwin, dev_num);
}


/*
 *	Creates a new devices list window.
 */
edv_device_listwin_struct *EDVDevicesListWinNew(
        gpointer core_ptr
)
{
        gint border_minor = 2, border_major = 5;
        const gchar     *font_name = NULL,
                        *fg_color_name = NULL,
                        *bg_color_name = NULL,
                        *sfg_color_name = NULL,
                        *sbg_color_name = NULL,
                        *bg_pixmap_path = NULL,
                        *sbg_pixmap_path = NULL,
                        *wm_name = NULL,
                        *wm_class = NULL;
	gint state;
	gchar *heading[4];
        gpointer mclient_data;
	gpointer entry_rtn;
        GdkWindow *window;
        GtkAccelGroup *accelgrp;
	GtkStyle *style;
	GtkRcStyle *rcstyle;
        GtkWidget *w, *fw, *menu;
	GtkWidget *parent, *parent2, *parent3, *parent4, *parent5;
	GtkEntry *entry;
	GtkCList *clist;
        edv_device_listwin_struct *lw = (edv_device_listwin_struct *)g_malloc0(
            sizeof(edv_device_listwin_struct)
        );
        if(lw == NULL)
            return(lw);


        /* Get values from core structure. */
        if(core_ptr != NULL)
        {
            edv_core_struct *c_ptr = EDV_CORE(core_ptr);

            font_name = c_ptr->font_name;
            fg_color_name = c_ptr->fg_color_name;
            bg_color_name = c_ptr->bg_color_name;
            sfg_color_name = c_ptr->sfg_color_name;
            sbg_color_name = c_ptr->sbg_color_name;
            bg_pixmap_path = c_ptr->bg_pixmap_path;
            sbg_pixmap_path = c_ptr->sbg_pixmap_path;
            wm_name = c_ptr->wm_name;
            wm_class = c_ptr->wm_class;
	}


        /* Reset values. */
        lw->initialized = TRUE;
        lw->map_state = FALSE;
	lw->busy_count = 0;
        lw->core_ptr = core_ptr;


        /* Keyboard accelerator group. */
        lw->accelgrp = accelgrp = gtk_accel_group_new();


        /* Toplevel. */
        lw->toplevel = w = gtk_window_new(GTK_WINDOW_DIALOG);
        gtk_widget_set_usize(w, LISTWIN_WIDTH, LISTWIN_HEIGHT);
        gtk_window_set_wmclass(GTK_WINDOW(w), wm_name, wm_class);
        gtk_widget_realize(w);
        gtk_window_set_title(GTK_WINDOW(w), LISTWIN_TITLE);
	style = gtk_widget_get_style(w);
        window = w->window;
        if(window != NULL)
        {
            gdk_window_set_decorations(
                window,
                GDK_DECOR_TITLE | GDK_DECOR_MENU | GDK_DECOR_MINIMIZE
            );
            gdk_window_set_functions(
                window,
                GDK_FUNC_MOVE | GDK_FUNC_MINIMIZE | GDK_FUNC_CLOSE
            );
            GUISetWMIcon(window, (u_int8_t **)icon_device_misc_48x48_xpm);
        }
        gtk_signal_connect(
            GTK_OBJECT(w), "delete_event",
            GTK_SIGNAL_FUNC(EDVDevicesListWinDeleteEventCB), lw
        );
        gtk_container_border_width(GTK_CONTAINER(w), 0);
        gtk_accel_group_attach(accelgrp, GTK_OBJECT(w));
        parent = w;



        /* Main vbox. */
        lw->main_vbox = w = gtk_vbox_new(FALSE, border_major);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_container_add(GTK_CONTAINER(parent), w);
        gtk_widget_show(w);
        parent = w;


	/* Hbox for find prompt. */
	w = gtk_hbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;

        w = (GtkWidget *)GUIPromptBar(
            NULL,
#ifdef PROG_LANGUAGE_ENGLISH
            "Find:",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Hallazgo:",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Dcouverte:",
#endif
	    NULL, &entry_rtn
        );
        lw->find_entry = (GtkWidget *)entry_rtn;
	entry = (GtkEntry *)entry_rtn;
        gtk_signal_connect(
            GTK_OBJECT(entry), "activate",
            GTK_SIGNAL_FUNC(EDVDevicesListWinFindCB), lw
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
        EDVEntrySetDND((edv_core_struct *)core_ptr, (GtkWidget *)entry_rtn);
        gtk_widget_show(w);


	/* Vbox for devices clist and buttons. */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;


	/* Scrolled window for devices clist. */
        w = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(
            GTK_SCROLLED_WINDOW(w),
            GTK_POLICY_AUTOMATIC,
            GTK_POLICY_AUTOMATIC
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent3 = w;

        /* Contents clist. */
#ifdef PROG_LANGUAGE_ENGLISH
        heading[0] = g_strdup("Name");
	heading[1] = g_strdup("Device Path");
	heading[2] = g_strdup("Mount Path");
        heading[3] = g_strdup("File System");
#endif
#ifdef PROG_LANGUAGE_SPANISH
        heading[0] = g_strdup("El Nombre");
        heading[1] = g_strdup("El Sendero Del Artefacto");
        heading[2] = g_strdup("Monte Sendero");
        heading[3] = g_strdup("Archive Sistema");
#endif
#ifdef PROG_LANGUAGE_FRENCH
        heading[0] = g_strdup("Nom");
        heading[1] = g_strdup("Sentier D'appareil");
        heading[2] = g_strdup("Monter Le Sentier");
        heading[3] = g_strdup("Classer Le Systme");
#endif
	lw->devices_clist = w = gtk_clist_new_with_titles(4, heading);
	g_free(heading[0]);
        g_free(heading[1]);
        g_free(heading[2]);
        g_free(heading[3]);
        clist = GTK_CLIST(w);
        gtk_widget_add_events(
            w,
            GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
            GDK_BUTTON_PRESS_MASK
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "key_press_event",
            GTK_SIGNAL_FUNC(EDVDevicesListWinKeyEventCB), lw
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "key_release_event",
            GTK_SIGNAL_FUNC(EDVDevicesListWinKeyEventCB), lw
        );
        gtk_signal_connect_after(
            GTK_OBJECT(w), "button_press_event",
            GTK_SIGNAL_FUNC(EDVDevicesListWinButtonPressEventCB), lw
        );
	gtk_clist_set_column_width(clist, 0, 130);
        gtk_clist_set_column_width(clist, 1, 130);
        gtk_clist_set_column_width(clist, 2, 130);
        gtk_clist_set_column_width(clist, 3, 50);
	gtk_clist_column_titles_passive(clist);
        gtk_clist_set_row_height(clist, EDV_LIST_ROW_SPACING);
        gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
	gtk_widget_set_usize(w, -1, LISTWIN_HEIGHT * 0.35);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_signal_connect(
            GTK_OBJECT(w), "select_row",
            GTK_SIGNAL_FUNC(EDVDevicesListWinSelectRowCB), lw
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "unselect_row",
            GTK_SIGNAL_FUNC(EDVDevicesListWinUnselectRowCB), lw
        );
        rcstyle = gtk_rc_style_new();
        rcstyle->font_name = (font_name != NULL) ? g_strdup(font_name) : NULL;
        state = GTK_STATE_NORMAL;
        rcstyle->color_flags[state] =
            ((fg_color_name != NULL) ? GTK_RC_FG | GTK_RC_TEXT : 0) |
            ((bg_color_name != NULL) ? GTK_RC_BG | GTK_RC_BASE : 0);
        if(fg_color_name != NULL)
        {
            gdk_color_parse(fg_color_name, &rcstyle->fg[state]);
            gdk_color_parse(fg_color_name, &rcstyle->text[state]);
        }
        if(bg_color_name != NULL)
        {
            gdk_color_parse(bg_color_name, &rcstyle->bg[state]);
            gdk_color_parse(bg_color_name, &rcstyle->base[state]);
        }
        if(bg_pixmap_path != NULL)
            rcstyle->bg_pixmap_name[state] = g_strdup(bg_pixmap_path);
        state = GTK_STATE_SELECTED;
        rcstyle->color_flags[state] =
            ((sfg_color_name != NULL) ? GTK_RC_FG | GTK_RC_TEXT : 0) |
            ((sbg_color_name != NULL) ? GTK_RC_BG | GTK_RC_BASE : 0);
        if(sfg_color_name != NULL)
        {
            gdk_color_parse(sfg_color_name, &rcstyle->fg[state]);
            gdk_color_parse(sfg_color_name, &rcstyle->text[state]);
        }
        if(sbg_color_name != NULL)
        {
            gdk_color_parse(sbg_color_name, &rcstyle->bg[state]);
            gdk_color_parse(sbg_color_name, &rcstyle->base[state]);
        }
        if(sbg_pixmap_path != NULL)
            rcstyle->bg_pixmap_name[state] = g_strdup(sbg_pixmap_path);
        gtk_widget_modify_style(w, rcstyle);
        GUIRCStyleDeallocUnref(rcstyle);
        gtk_widget_show(w);


	/* Hbox for buttons. */
	w = gtk_hbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;

	/* Vbox for add, edit, and remove set of buttons. */
	w = gtk_hbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent4 = w;

        /* Add button. */
        lw->add_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_add_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Add...",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Agregue...",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Ajouter...",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVDevicesListWinAddCB), lw
        );
        gtk_widget_show(w);

        /* Edit button. */
        lw->edit_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_edit_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Edit...",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Redacte...",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Editer...",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVDevicesListWinEditCB), lw
        );
        gtk_widget_show(w);

        /* Remove button. */
        lw->remove_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_remove_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Remove",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Quite",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Enlever",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVDevicesListWinRemoveCB), lw
        );
        gtk_widget_show(w);


        /* Hbox for up and down set of buttons. */
        w = gtk_hbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent4 = w;

	/* Vbox for up button. */
	w = gtk_vbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent5 = w;
        /* Up button. */
        lw->up_btn = w = gtk_button_new();
        gtk_box_pack_start(GTK_BOX(parent5), w, TRUE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVDevicesListWinUpCB), lw
        );
        gtk_widget_show(w);
	parent5 = w;
        /* Arrow. */
        w = gtk_arrow_new(GTK_ARROW_UP, GTK_SHADOW_OUT);
        gtk_widget_set_usize(
            w, LISTWIN_ARROW_WIDTH, LISTWIN_ARROW_HEIGHT
        );
        gtk_container_add(GTK_CONTAINER(parent5), w);
        gtk_widget_show(w);

        /* Vbox for down button. */
        w = gtk_vbox_new(TRUE, 0);
        gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, FALSE, 0);
        gtk_widget_show(w);
        parent5 = w;
        /* Down button. */
        lw->down_btn = w = gtk_button_new();
        gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVDevicesListWinDownCB), lw
        );
        gtk_widget_show(w);
        parent5 = w;
        /* Arrow. */
        w = gtk_arrow_new(GTK_ARROW_DOWN, GTK_SHADOW_OUT);
        gtk_widget_set_usize(
            w, LISTWIN_ARROW_WIDTH, LISTWIN_ARROW_HEIGHT
        );
        gtk_container_add(GTK_CONTAINER(parent5), w);
        gtk_widget_show(w);





        /* Horizontal separator. */
        w = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


	/* Parent vbox for displaying selected device. */
	lw->display_parent = w = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
	parent2 = w;

	/* Client vbox that is parented to the display_parent, leave this
	 * NULL, it'll be created when needed.
	 */
	lw->display_client = NULL;


	/* Horizontal separator. */
	w = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


	/* Hbox for buttons. */
	w = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
	parent2 = w;

	/* Alignment. */
	w = gtk_alignment_new(1.0, 0.5, 0.0, 0.0);
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent2 = w;

	/* Hbox for buttons set. */
        w = gtk_hbox_new(FALSE, border_major);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_widget_show(w);
        parent2 = w;

        /* Close button. */
        lw->close_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_close_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Close",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Cierre",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Proche",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVDevicesListWinCloseCB), lw
        );
        gtk_accel_group_add(
            accelgrp, GDK_Escape, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_widget_show(w);



	/* Right click menu. */
        lw->menu = menu = (GtkWidget *)GUIMenuCreate();
        mclient_data = lw;
        if(menu != NULL)
        {
            u_int8_t **icon;
            gint accel_key;
            guint accel_mods;
            const gchar *label;
            void (*func_cb)(GtkWidget *, gpointer);

#define DO_ADD_MENU_ITEM_LABEL  \
{ \
 w = GUIMenuItemCreate( \
  menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp, \
  icon, label, accel_key, accel_mods, (void **)&fw, \
  mclient_data, func_cb \
 ); \
}
#define DO_ADD_MENU_SEP \
{ \
 w = GUIMenuItemCreate( \
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL, \
  NULL, NULL, 0, 0, NULL, \
  NULL, NULL \
 ); \
}
            icon = (u_int8_t **)icon_add_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
            label = "Add...";
#endif
#ifdef PROG_LANGUAGE_SPANISH
            label = "Agregue...";
#endif
#ifdef PROG_LANGUAGE_FRENCH
            label = "Ajouter...";
#endif
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVDevicesListWinAddCB;
            DO_ADD_MENU_ITEM_LABEL
	    lw->add_mi = w;

            icon = (u_int8_t **)icon_edit_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
            label = "Edit...";
#endif
#ifdef PROG_LANGUAGE_SPANISH
            label = "Redacte...";
#endif
#ifdef PROG_LANGUAGE_FRENCH
            label = "Editer...";
#endif
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVDevicesListWinEditCB;
            DO_ADD_MENU_ITEM_LABEL
            lw->edit_mi = w;

            icon = (u_int8_t **)icon_remove_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
            label = "Remove";
#endif
#ifdef PROG_LANGUAGE_SPANISH
            label = "Quite";
#endif
#ifdef PROG_LANGUAGE_FRENCH
            label = "Enlever";
#endif
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVDevicesListWinRemoveCB;
            DO_ADD_MENU_ITEM_LABEL
            lw->remove_mi = w;

            DO_ADD_MENU_SEP

            icon = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
            label = "Shift Up";
#endif
#ifdef PROG_LANGUAGE_SPANISH
            label = "Cambie Arriba";
#endif
#ifdef PROG_LANGUAGE_FRENCH
            label = "Changer En Haut";
#endif
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVDevicesListWinUpCB;
            DO_ADD_MENU_ITEM_LABEL
            lw->up_mi = w;

            icon = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
            label = "Shift Down";
#endif
#ifdef PROG_LANGUAGE_SPANISH
            label = "Cambie Hacia Abajo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
            label = "Changer En Bas";
#endif
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVDevicesListWinDownCB;
            DO_ADD_MENU_ITEM_LABEL
            lw->down_mi = w;

#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_SEP
        }




        EDVDevicesListWinUpdateMenus(lw);

	return(lw);
}

/*
 *	Updates menus and other widgets on the given devices list
 *	window to reflect its current data.
 */
void EDVDevicesListWinUpdateMenus(
        edv_device_listwin_struct *lw
)
{
	gbool sensitive;
	gint sel_row;
        GtkWidget *w;
	GtkCList *clist;


        if(lw == NULL)
            return;


	/* Get selected row on clist. */
	clist = (GtkCList *)lw->devices_clist;
	sel_row = EDVCListGetSelectedLast(clist, NULL);

#define DO_SET_SENSITIVE	\
{ \
 if(w != NULL) \
  gtk_widget_set_sensitive(w, sensitive); \
}

        sensitive = (sel_row > -1) ? TRUE : FALSE;
	w = lw->edit_btn;
        DO_SET_SENSITIVE
        w = lw->remove_btn;
        DO_SET_SENSITIVE

        w = lw->edit_mi;
        DO_SET_SENSITIVE
        w = lw->remove_mi;
        DO_SET_SENSITIVE

        sensitive = (sel_row > 0) ? TRUE : FALSE;
        w = lw->up_btn;
        DO_SET_SENSITIVE
        w = lw->up_mi;
        DO_SET_SENSITIVE

        sensitive = ((sel_row > -1) && (sel_row < (clist->rows - 1))) ?
            TRUE : FALSE;
        w = lw->down_btn;
        DO_SET_SENSITIVE
        w = lw->down_mi;
        DO_SET_SENSITIVE



#undef DO_SET_SENSITIVE
}

/*
 *	Marks the devices window as busy or ready.
 */
void EDVDevicesListSetBusy(
        edv_device_listwin_struct *lw, gbool is_busy
)
{
        GdkCursor *cursor;
        GtkWidget *w;
        edv_core_struct *core_ptr;


        if(lw == NULL)
            return;

        if(!lw->initialized)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        w = lw->toplevel;
        if(w != NULL)
        {
            if(is_busy)
            {
                /* Increase busy count. */
                lw->busy_count++;

                /* If already busy then don't change anything. */
                if(lw->busy_count > 1)
                    return;

                cursor = EDVGetCursor(core_ptr, EDV_CURSOR_CODE_BUSY);
            }
            else
            {
                /* Reduce busy count. */
                lw->busy_count--;
                if(lw->busy_count < 0)
                    lw->busy_count = 0;

                /* If still busy do not change anything. */
                if(lw->busy_count > 0)
                    return;

                cursor = NULL;  /* Use default cursor. */
            }

            /* Update toplevel window's cursor. */
            if(w->window != NULL)
            {
                gdk_window_set_cursor(w->window, cursor);
                gdk_flush();
            }
        }
}

/*
 *	Maps the devices list window.
 */
void EDVDevicesListWinMap(
        edv_device_listwin_struct *lw
)
{
        GtkWidget *w;

        if(lw == NULL)
            return;

	/* Set close button as the default on map. */
        w = lw->close_btn;
        if(w != NULL)
        {
            gtk_widget_grab_focus(w);
            gtk_widget_grab_default(w);
        }

	w = lw->toplevel;
	gtk_widget_show_raise(w);
	lw->map_state = TRUE;
}

/*
 *	Unmaps the devices list window.
 */
void EDVDevicesListWinUnmap(
        edv_device_listwin_struct *lw
)
{
	GtkWidget *w;

	if(lw == NULL)
	    return;

	w = lw->toplevel;
	if(w == NULL)
	    return;

	if(lw->map_state)
	{
	    gtk_widget_hide(w);
	    lw->map_state = FALSE;
	}
}

/*
 *	Deallocates all resources of the given devices list window and
 *	deallocates the structure itself.
 */
void EDVDevicesListWinDelete(
        edv_device_listwin_struct *lw
)
{
        GtkWidget **w;


        if(lw == NULL)
            return;

        if(lw->initialized)
        {
#define DO_DESTROY_WIDGET       \
{ \
 if((*w) != NULL) \
 { \
  GtkWidget *tmp_w = *w; \
  (*w) = NULL; \
  gtk_widget_destroy(tmp_w); \
 } \
}

	    /* Destroy right click menu. */
            w = &lw->menu;
            lw->add_mi = NULL;
            lw->edit_mi = NULL;
            lw->remove_mi = NULL;
            lw->up_mi = NULL;
            lw->down_mi = NULL;
            DO_DESTROY_WIDGET

	    /* Delete device edit window. */
	    EDVDevicesEditWinDelete(lw->editwin);
	    lw->editwin = NULL;

	    /* Begin destroying widgets. */

	    /* Child widgets of display_client. */
            w = &lw->dev_icon_pm;
            DO_DESTROY_WIDGET
            w = &lw->dev_name_label;
            DO_DESTROY_WIDGET
            w = &lw->dev_device_path_label;
            DO_DESTROY_WIDGET
            w = &lw->dev_mount_path_label;
            DO_DESTROY_WIDGET
            w = &lw->dev_mount_btn;
            DO_DESTROY_WIDGET
            w = &lw->dev_eject_btn;
            DO_DESTROY_WIDGET
            w = &lw->dev_properties_btn;
            DO_DESTROY_WIDGET
            w = &lw->dev_fsck_btn;
            DO_DESTROY_WIDGET
            w = &lw->dev_tools_btn;
            DO_DESTROY_WIDGET
            w = &lw->dev_format_btn;
            DO_DESTROY_WIDGET
            PieChartDelete(lw->dev_pc);
            lw->dev_pc = NULL;
	    w = &lw->display_client;
	    DO_DESTROY_WIDGET

	    w = &lw->display_parent;
	    DO_DESTROY_WIDGET

            w = &lw->find_entry;
            DO_DESTROY_WIDGET

            w = &lw->devices_clist;
            DO_DESTROY_WIDGET

            w = &lw->add_btn;
            DO_DESTROY_WIDGET
            w = &lw->edit_btn;
            DO_DESTROY_WIDGET
            w = &lw->remove_btn;
            DO_DESTROY_WIDGET
            w = &lw->up_btn;
            DO_DESTROY_WIDGET
            w = &lw->down_btn;
            DO_DESTROY_WIDGET
            w = &lw->close_btn;
            DO_DESTROY_WIDGET

            w = &lw->toplevel;
            DO_DESTROY_WIDGET

            if(lw->accelgrp != NULL)
            {
                gtk_accel_group_unref(lw->accelgrp);
                lw->accelgrp = NULL;
            }

#undef DO_DESTROY_WIDGET
        }

        /* Deallocate structure itself. */
	g_free(lw);
}
