/*
               Endeavour devices list (and editing) window
 */

#ifndef DEVICESWIN_H
#define DEVICESWIN_H


#include <gtk/gtk.h>

#include "piechart.h"

#include "edvtypes.h"
#include "edvdevices.h"
#include "editclist.h"


/*
 *	Device window icon structure:
 */
typedef struct {

	gpointer editwin;

	GtkWidget	*toplevel,	/* A GtkBox. */
			*button,	/* Icon GtkButton. */
			*gtk_pixmap,
			*left_btn, *right_btn, *state_label;

	GtkAdjustment *adj;

	GdkPixmap *pixmap[EDV_DEVICE_TOTAL_ICON_STATES];
	GdkBitmap *mask[EDV_DEVICE_TOTAL_ICON_STATES];

	gchar *path[EDV_DEVICE_TOTAL_ICON_STATES];

} edv_device_editwin_icon_struct;

/*
 *      Device edit window structure:
 */
typedef struct {

        gbool initialized;
        gbool map_state;
	gint busy_count;

        gpointer core_ptr, listwin;

        GtkAccelGroup *accelgrp;

        GtkWidget       *toplevel,
                        *main_vbox,
			*name_entry,
			*device_path_entry,
			*mount_path_entry,
                        *fs_type_combo,
                        *command_mount_entry,
                        *command_unmount_entry,
			*command_eject_entry,
			*command_check_entry,
                        *command_tools_entry,
			*command_format_entry,
			*no_unmount_check,
			*read_only_check,
			*unlisted_check,
			*ok_btn, *apply_btn, *cancel_btn;

	/* Device index on the core structure's list or -1 for none. */
	gint dev_num;

	/* Icon selecting structures. */
	edv_device_editwin_icon_struct	*icon_small,
					*icon_medium,
					*icon_large;

} edv_device_editwin_struct;


/*
 *	Device list window structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
        gint busy_count;

	gpointer core_ptr;

	GtkAccelGroup *accelgrp;

	GtkWidget	*toplevel,
			*main_vbox,
			*find_entry,
			*devices_clist,
			*add_btn,
			*edit_btn,
			*remove_btn,
			*up_btn,
			*down_btn,
			*display_parent,	/* GtkVBox. */
			*display_client,	/* Parented to display_parent. */
			*close_btn;

	/* Right click menu. */
	GtkWidget	*menu,
			*add_mi,
			*edit_mi,
			*remove_mi,
                        *up_mi,
                        *down_mi;

	/* Important widgets on display_client. */
	GtkWidget	*dev_icon_pm,
			*dev_name_label,
			*dev_device_path_label,
			*dev_mount_path_label,
			*dev_mount_btn, *dev_eject_btn,	*dev_properties_btn,
			*dev_fsck_btn, *dev_tools_btn, *dev_format_btn;
	pie_chart_struct *dev_pc;


	/* Device edit window. */
	edv_device_editwin_struct *editwin;

} edv_device_listwin_struct;


/* In devicesedit.c */
extern void EDVDevicesEditWinFetchValues(
        edv_device_editwin_struct *ew, gint dev_num
);
extern void EDVDevicesEditWinDeviceRemovedCB(
        edv_device_editwin_struct *ew, gint dev_num
);

extern edv_device_editwin_struct *EDVDevicesEditWinNew(
        gpointer core_ptr, gpointer listwin
);
extern void EDVDevicesEditWinMap(
        edv_device_editwin_struct *ew
);
extern void EDVDevicesEditWinUnmap(
        edv_device_editwin_struct *ew
);
extern void EDVDevicesEditWinDelete(
        edv_device_editwin_struct *ew
);


/* In deviceswin.c */
extern void EDVDevicesListWinSetRow(
        edv_device_listwin_struct *lw, gint row, edv_device_struct *dev_ptr
);
extern void EDVDevicesListWinFetchValues(
	edv_device_listwin_struct *lw
);

extern void EDVDevicesListWinMountNotifyCB(
        edv_device_listwin_struct *lw,
        gint dev_num, edv_device_struct *dev_ptr,
        gbool is_mounted
);
extern void EDVDevicesListWinDeviceAddedCB(
        edv_device_listwin_struct *lw,
        gint dev_num, edv_device_struct *dev_ptr
);
extern void EDVDevicesListWinDeviceModifiedCB(
        edv_device_listwin_struct *lw,
        gint dev_num, edv_device_struct *dev_ptr
);
extern void EDVDevicesListWinDeviceRemovedCB(
        edv_device_listwin_struct *lw, gint dev_num
);

extern edv_device_listwin_struct *EDVDevicesListWinNew(
	gpointer core_ptr
);
extern void EDVDevicesListWinUpdateMenus(
        edv_device_listwin_struct *lw
);
extern void EDVDevicesListSetBusy(
	edv_device_listwin_struct *lw, gbool is_busy
);
extern void EDVDevicesListWinMap(
        edv_device_listwin_struct *lw
);
extern void EDVDevicesListWinUnmap(
        edv_device_listwin_struct *lw
);
extern void EDVDevicesListWinDelete(
	edv_device_listwin_struct *lw
);





#endif	/* DEVICESWIN_H */
