/*
                       Endeavour Core Callbacks
 */

#ifndef EDVCB_H
#define EDVCB_H

#include <gtk/gtk.h>

#include "edvobj.h"
#include "edvdevices.h"
#include "edvmimetypes.h"
#include "edvarch.h"
#include "edvrecbin.h"
#include "endeavour.h"


/* Callbacks. */
extern void EDVSignalCB(int s);

extern gint EDVManageTimeoutCB(gpointer data);

extern void EDVNewBrowserCB(GtkWidget *widget, gpointer data);
extern void EDVNewImbrCB(GtkWidget *widget, gpointer data);
extern void EDVNewArchiverCB(GtkWidget *widget, gpointer data);
extern void EDVMapRecBinCB(GtkWidget *widget, gpointer data);

extern void EDVMapDevicesListCB(GtkWidget *widget, gpointer data);
extern void EDVMapMIMETypesListCB(GtkWidget *widget, gpointer data);

extern void EDVOptionsCB(GtkWidget *widget, gpointer data);
extern void EDVCustomizeCB(GtkWidget *widget, gpointer data);

extern gint EDVCListColumnSortStringCB(
        GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2
);
extern gint EDVCListColumnSortNumericCB(
        GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2
);

extern void EDVPurgeAllRecycledObjectsCB(GtkWidget *widget, gpointer data);

extern gboolean EDVEntryDragMotionCB(
        GtkWidget *widget, GdkDragContext *dc, gint x, gint y, guint t,
        gpointer data
);
extern void EDVEntryDragDataReceivedCB(
        GtkWidget *widget, GdkDragContext *dc, gint x, gint y,
        GtkSelectionData *selection_data, guint info, guint t,
        gpointer data
);

extern void EDVLocBarIconDragDataGet(
        GtkWidget *widget, GdkDragContext *context,
        GtkSelectionData *selection_data, guint info, guint time,
        gpointer data
);


/* Emitters. */
extern void EDVWriteProtectChangedEmit(
	edv_core_struct *core_ptr, gbool state
);

extern void EDVObjectAddedEmit(
	edv_core_struct *core_ptr, const gchar *path,
	const struct stat *lstat_buf
);
extern void EDVObjectModifiedEmit(
        edv_core_struct *core_ptr, const gchar *path,
	const gchar *new_path,
        const struct stat *lstat_buf
);
extern void EDVObjectRemovedEmit(
	edv_core_struct *core_ptr, const gchar *path
);

extern void EDVObjectMountEmit(
	edv_core_struct *core_ptr,
	gint dev_num, edv_device_struct *dev_ptr,
	gbool is_mounted
);

extern void EDVArchiveObjectAddedNotifyCB(
        edv_core_struct *core_ptr, const gchar *arch_path,
        const gchar *path, edv_archive_object_struct *obj
);
extern void EDVArchiveObjectModifiedNotifyCB(
        edv_core_struct *core_ptr, const gchar *arch_path,
        const gchar *path, const gchar *new_path,
        edv_archive_object_struct *obj
);
extern void EDVArchiveObjectRemovedNotifyCB(
        edv_core_struct *core_ptr, const gchar *arch_path,
        const gchar *path
);

extern void EDVRecycledObjectAddedEmit(
        edv_core_struct *core_ptr, guint index
);
extern void EDVRecycledObjectRemovedEmit(
        edv_core_struct *core_ptr, guint index
);

extern void EDVReconfiguredEmit(edv_core_struct *core_ptr);

extern void EDVMimeTypeAddedEmit(
        edv_core_struct *core_ptr,
        gint mt_num, edv_mimetype_struct *mt_ptr
);
extern void EDVMimeTypeModifiedEmit(
        edv_core_struct *core_ptr,
        gint mt_num, edv_mimetype_struct *mt_ptr
);
extern void EDVMimeTypeRemovedEmit(
        edv_core_struct *core_ptr, gint mt_num
);

extern void EDVDeviceAddedEmit(
        edv_core_struct *core_ptr,
        gint dev_num, edv_device_struct *dev_ptr
);
extern void EDVDeviceModifiedEmit(
        edv_core_struct *core_ptr,
        gint dev_num, edv_device_struct *dev_ptr
);
extern void EDVDeviceRemovedEmit(
        edv_core_struct *core_ptr, gint dev_num
);

#endif	/* EDVCB_H */
